/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;

public class Executor {
    private static final Logger log = Logger.getLogger(Executor.class.getName());
    private List<String> cmdList;
    private File workingDirectory;
    private byte[] stdout;
    private byte[] stderr;

    public Executor(String[] cmd) {
        this(Arrays.asList(cmd));
    }

    public Executor(List<String> cmdList) {
        this(cmdList, null);
    }

    public Executor(List<String> cmdList, File workingDirectory) {
        this.cmdList = cmdList;
        this.workingDirectory = workingDirectory;
    }

    public int exec() {
        return this.exec(true);
    }

    public int exec(boolean reportExceptions) {
        SpoolHandler spoolOut = new SpoolHandler();
        int ret = this.exec(reportExceptions, spoolOut);
        this.stdout = spoolOut.getBytes();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec(final boolean reportExceptions, StreamHandler handler) {
        File cwd;
        int ret = -1;
        ProcessBuilder processBuilder = new ProcessBuilder(this.cmdList);
        final String cmd_str = processBuilder.command().toString();
        if (this.workingDirectory != null) {
            processBuilder.directory(this.workingDirectory);
            if (processBuilder.environment().containsKey("PWD")) {
                processBuilder.environment().put("PWD", this.workingDirectory.getAbsolutePath());
            }
        }
        final String dir_str = (cwd = processBuilder.directory()) == null ? System.getProperty("user.dir") : cwd.toString();
        OpenGrokLogger.getLogger().log(Level.FINE, "Executing command {0} in directory {1}", new Object[]{cmd_str, dir_str});
        Process process = null;
        try {
            final Process proc = process = processBuilder.start();
            final InputStream errorStream = process.getErrorStream();
            final SpoolHandler err = new SpoolHandler();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            err.processStream(errorStream);
                        }
                        catch (IOException ex) {
                            if (!reportExceptions) break block2;
                            OpenGrokLogger.getLogger().log(Level.SEVERE, "Error during process pipe listening", ex);
                        }
                    }
                }
            });
            thread.start();
            Timer t = new Timer();
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    OpenGrokLogger.getLogger().log(Level.INFO, "Terminating process of command {0} in directory {1} due to timeout {2} seconds", new Object[]{cmd_str, dir_str, RuntimeEnvironment.getInstance().getCommandTimeout()});
                    proc.destroy();
                }
            }, RuntimeEnvironment.getInstance().getCommandTimeout() * 1000);
            handler.processStream(process.getInputStream());
            ret = process.waitFor();
            OpenGrokLogger.getLogger().log(Level.FINE, "Finished command {0} in directory {1}", new Object[]{cmd_str, dir_str});
            t.cancel();
            process = null;
            thread.join();
            this.stderr = err.getBytes();
        }
        catch (IOException e) {
            if (reportExceptions) {
                OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to read from process: " + this.cmdList.get(0), e);
            }
        }
        catch (InterruptedException e) {
            if (reportExceptions) {
                OpenGrokLogger.getLogger().log(Level.SEVERE, "Waiting for process interrupted: " + this.cmdList.get(0), e);
            }
        }
        finally {
            try {
                if (process != null) {
                    ret = process.exitValue();
                }
            }
            catch (IllegalThreadStateException e) {
                process.destroy();
            }
        }
        if (ret != 0 && reportExceptions) {
            int MAX_MSG_SZ = 512;
            StringBuilder msg = new StringBuilder("Non-zero exit status ").append(ret).append(" from command ").append(cmd_str).append(" in directory ").append(dir_str);
            if (this.stderr != null && this.stderr.length > 0) {
                msg.append(": ");
                if (this.stderr.length > MAX_MSG_SZ) {
                    msg.append(new String(this.stderr, 0, MAX_MSG_SZ)).append("...");
                } else {
                    msg.append(new String(this.stderr));
                }
            }
            OpenGrokLogger.getLogger().log(Level.WARNING, msg.toString());
        }
        return ret;
    }

    public String getOutputString() {
        String ret = null;
        if (this.stdout != null) {
            ret = new String(this.stdout);
        }
        return ret;
    }

    public Reader getOutputReader() {
        return new InputStreamReader(this.getOutputStream());
    }

    public InputStream getOutputStream() {
        return new ByteArrayInputStream(this.stdout);
    }

    public String getErrorString() {
        String ret = null;
        if (this.stderr != null) {
            ret = new String(this.stderr);
        }
        return ret;
    }

    public Reader getErrorReader() {
        return new InputStreamReader(this.getErrorStream());
    }

    public InputStream getErrorStream() {
        return new ByteArrayInputStream(this.stderr);
    }

    public static void registerErrorHandler() {
        Thread.currentThread();
        Thread.UncaughtExceptionHandler dueh = Thread.getDefaultUncaughtExceptionHandler();
        if (dueh == null) {
            log.fine("Installing default uncaught exception handler");
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    log.log(Level.SEVERE, "Uncaught exception in thread " + t.getName() + " with ID " + t.getId() + ": " + e.getMessage(), e);
                }
            });
        }
    }

    private static class SpoolHandler
    implements StreamHandler {
        private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();

        private SpoolHandler() {
        }

        public byte[] getBytes() {
            return this.bytes.toByteArray();
        }

        @Override
        public void processStream(InputStream in) throws IOException {
            int len;
            byte[] buffer = new byte[8092];
            while ((len = in.read(buffer)) != -1) {
                if (len <= 0) continue;
                this.bytes.write(buffer, 0, len);
            }
        }
    }

    public static interface StreamHandler {
        public void processStream(InputStream var1) throws IOException;
    }
}

