/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.opensolaris.opengrok.analysis.AnalyzerGuru;
import org.opensolaris.opengrok.analysis.ExpandTabsReader;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.index.IgnoredNames;
import org.opensolaris.opengrok.search.QueryBuilder;
import org.opensolaris.opengrok.util.IOUtils;
import org.opensolaris.opengrok.web.DiffData;
import org.opensolaris.opengrok.web.DiffType;
import org.opensolaris.opengrok.web.EftarFileReader;
import org.opensolaris.opengrok.web.Prefix;
import org.opensolaris.opengrok.web.SearchHelper;
import org.opensolaris.opengrok.web.SortOrder;
import org.opensolaris.opengrok.web.Util;

public final class PageConfig {
    boolean check4on = true;
    private RuntimeEnvironment env;
    private IgnoredNames ignoredNames;
    private String path;
    private File resourceFile;
    private String resourcePath;
    private EftarFileReader eftarReader;
    private String sourceRootPath;
    private Boolean isDir;
    private String uriEncodedPath;
    private Prefix prefix;
    private String pageTitle;
    private String dtag;
    private String rev;
    private Boolean hasAnnotation;
    private Boolean annotate;
    private Annotation annotation;
    private Boolean hasHistory;
    private static final EnumSet<FileAnalyzer.Genre> txtGenres = EnumSet.of(FileAnalyzer.Genre.DATA, FileAnalyzer.Genre.PLAIN, FileAnalyzer.Genre.HTML);
    private SortedSet<String> requestedProjects;
    private String requestedProjectsString;
    private List<String> dirFileList;
    private QueryBuilder queryBuilder;
    private File dataRoot;
    private StringBuilder headLines;
    private static final Logger log = Logger.getLogger(PageConfig.class.getName());
    private static final String ATTR_NAME = PageConfig.class.getCanonicalName();
    private HttpServletRequest req;
    private static Pattern COMMA_PATTERN = Pattern.compile(",");

    public void addHeaderData(String data) {
        if (data == null || data.length() == 0) {
            return;
        }
        if (this.headLines == null) {
            this.headLines = new StringBuilder();
        }
        this.headLines.append(data);
    }

    public String getHeaderData() {
        return this.headLines == null ? "" : this.headLines.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiffData getDiffData() {
        Object p;
        DiffData data = new DiffData();
        data.path = this.getPath().substring(0, this.path.lastIndexOf(47));
        data.filename = Util.htmlize(this.getResourceFile().getName());
        String srcRoot = this.getSourceRootPath();
        String context = this.req.getContextPath();
        String[] filepath = new String[2];
        data.rev = new String[2];
        data.file = new String[2][];
        data.param = new String[2];
        for (int i = 1; i <= 2; ++i) {
            String[] tmp = null;
            p = this.req.getParameter("r" + i);
            if (p != null) {
                tmp = ((String)p).split("@");
            }
            if (tmp == null || tmp.length != 2) continue;
            filepath[i - 1] = tmp[0];
            data.rev[i - 1] = tmp[1];
        }
        if (data.rev[0] == null || data.rev[1] == null || data.rev[0].length() == 0 || data.rev[1].length() == 0 || data.rev[0].equals(data.rev[1])) {
            data.errorMsg = "Please pick two revisions to compare the changed from the <a href=\"" + context + (Object)((Object)Prefix.HIST_L) + this.getUriEncodedPath() + "\">history</a>";
            return data;
        }
        data.genre = AnalyzerGuru.getGenre(this.getResourceFile().getName());
        if (data.genre == null || txtGenres.contains((Object)data.genre)) {
            InputStream[] in = new InputStream[2];
            try {
                int i;
                for (i = 0; i < 2; ++i) {
                    File f = new File(srcRoot + filepath[i]);
                    in[i] = HistoryGuru.getInstance().getRevision(f.getParent(), f.getName(), data.rev[i]);
                    if (in[i] != null) continue;
                    data.errorMsg = "Unable to get revision " + data.rev[i] + " for file: " + this.getResourceFile().getPath();
                    DiffData diffData = data;
                    return diffData;
                }
                for (i = 0; i < 2 && data.genre == null; ++i) {
                    try {
                        data.genre = AnalyzerGuru.getGenre(in[i]);
                        continue;
                    }
                    catch (IOException e) {
                        data.errorMsg = "Unable to determine the file type: " + Util.htmlize(e.getMessage());
                    }
                }
                if (data.genre != FileAnalyzer.Genre.PLAIN && data.genre != FileAnalyzer.Genre.HTML) {
                    DiffData i2 = data;
                    return i2;
                }
                ArrayList<String> lines = new ArrayList<String>();
                p = this.getProject();
                for (int i3 = 0; i3 < 2; ++i3) {
                    try (BufferedReader br = new BufferedReader(ExpandTabsReader.wrap(new InputStreamReader(in[i3]), (Project)p));){
                        String line;
                        while ((line = br.readLine()) != null) {
                            lines.add(line);
                        }
                        data.file[i3] = lines.toArray(new String[lines.size()]);
                        lines.clear();
                    }
                    in[i3] = null;
                }
            }
            catch (Exception e) {
                data.errorMsg = "Error reading revisions: " + Util.htmlize(e.getMessage());
                return data.errorMsg;
            }
            finally {
                for (int i = 0; i < 2; ++i) {
                    IOUtils.close(in[i]);
                }
            }
            if (data.errorMsg != null) {
                return data;
            }
            try {
                data.revision = Diff.diff(data.file[0], data.file[1]);
            }
            catch (DifferentiationFailedException e) {
                data.errorMsg = "Unable to get diffs: " + Util.htmlize(e.getMessage());
            }
            for (int i = 0; i < 2; ++i) {
                try {
                    URI u = new URI(null, null, null, filepath[i] + "@" + data.rev[i], null);
                    data.param[i] = u.getRawQuery();
                    continue;
                }
                catch (URISyntaxException e) {
                    log.log(Level.WARNING, "Failed to create URI: ", e);
                }
            }
            data.full = this.fullDiff();
            data.type = this.getDiffType();
        }
        return data;
    }

    public DiffType getDiffType() {
        DiffType d = DiffType.get(this.req.getParameter("format"));
        return d == null ? DiffType.SIDEBYSIDE : d;
    }

    public boolean fullDiff() {
        String val = this.req.getParameter("full");
        return val != null && val.equals("1");
    }

    public String canProcess() {
        if (this.resourceNotAvailable()) {
            return this.getOnRedirect();
        }
        String redir = this.getDirectoryRedirect();
        if (redir == null && this.getPrefix() == Prefix.HIST_L && !this.hasHistory()) {
            return null;
        }
        if (this.isDir() && (this.getPrefix() == Prefix.XREF_P ? this.getResourceFileList().isEmpty() && !this.getRequestedRevision().isEmpty() && !this.hasHistory() : this.getPrefix() == Prefix.RAW_P || this.getPrefix() == Prefix.DOWNLOAD_P)) {
            return null;
        }
        return redir == null ? "" : redir;
    }

    public List<String> getResourceFileList() {
        if (this.dirFileList == null) {
            String[] files = null;
            if (this.isDir() && this.getResourcePath().length() > 1) {
                files = this.getResourceFile().list();
            }
            if (files == null) {
                this.dirFileList = Collections.emptyList();
            } else {
                Arrays.sort(files, String.CASE_INSENSITIVE_ORDER);
                this.dirFileList = Collections.unmodifiableList(Arrays.asList(files));
            }
        }
        return this.dirFileList;
    }

    public long getLastModified() {
        return this.getResourceFile().lastModified();
    }

    public String getHistoryDirs() {
        if (!this.isDir()) {
            return "";
        }
        String[] val = this.req.getParameterValues("also");
        if (val == null || val.length == 0) {
            return this.path;
        }
        StringBuilder paths = new StringBuilder(this.path);
        for (int i = 0; i < val.length; ++i) {
            paths.append(' ').append(val[i]);
        }
        return paths.toString();
    }

    public int getIntParam(String name, int defaultValue) {
        int ret = defaultValue;
        String s = this.req.getParameter(name);
        if (s != null && s.length() != 0) {
            try {
                int x = Integer.parseInt(s, 10);
                if (x >= 0) {
                    ret = x;
                }
            }
            catch (Exception e) {
                log.log(Level.INFO, "Failed to parse integer " + s, e);
            }
        }
        return ret;
    }

    public int getSearchStart() {
        return this.getIntParam("start", 0);
    }

    public int getSearchMaxItems() {
        return this.getIntParam("n", this.getEnv().getHitsPerPage());
    }

    public List<SortOrder> getSortOrder() {
        SortOrder so;
        ArrayList<SortOrder> sort = new ArrayList<SortOrder>();
        List<String> vals = this.getParamVals("sort");
        for (String s : vals) {
            so = SortOrder.get(s);
            if (so == null) continue;
            sort.add(so);
        }
        if (sort.isEmpty()) {
            vals = this.getCookieVals("OpenGrokSorting");
            for (String s : vals) {
                so = SortOrder.get(s);
                if (so == null) continue;
                sort.add(so);
            }
        }
        return sort;
    }

    public QueryBuilder getQueryBuilder() {
        if (this.queryBuilder == null) {
            this.queryBuilder = new QueryBuilder().setFreetext(this.req.getParameter("q")).setDefs(this.req.getParameter("defs")).setRefs(this.req.getParameter("refs")).setPath(this.req.getParameter("path")).setHist(this.req.getParameter("hist")).setType(this.req.getParameter("type"));
            String t = this.req.getParameter("t");
            if (t != null) {
                this.queryBuilder.setFreetext(t);
            }
        }
        return this.queryBuilder;
    }

    public EftarFileReader getEftarReader() {
        if (this.eftarReader == null || this.eftarReader.isClosed()) {
            File f = this.getEnv().getConfiguration().getDtagsEftar();
            if (f == null) {
                this.eftarReader = null;
            } else {
                try {
                    this.eftarReader = new EftarFileReader(f);
                }
                catch (Exception e) {
                    log.log(Level.FINE, "Failed to create EftarFileReader: ", e);
                }
            }
        }
        return this.eftarReader;
    }

    public String getDefineTagsIndex() {
        if (this.dtag != null) {
            return this.dtag;
        }
        this.getEftarReader();
        if (this.eftarReader != null) {
            try {
                this.dtag = this.eftarReader.get(this.getPath());
            }
            catch (IOException e) {
                log.log(Level.INFO, "Failed to get entry from eftar reader: ", e);
            }
        }
        if (this.dtag == null) {
            this.dtag = "";
        }
        return this.dtag;
    }

    public String getRequestedRevision() {
        if (this.rev == null) {
            String tmp = this.req.getParameter("r");
            this.rev = tmp != null && tmp.length() > 0 ? "r=" + tmp : "";
        }
        return this.rev;
    }

    public boolean hasHistory() {
        if (this.hasHistory == null) {
            this.hasHistory = HistoryGuru.getInstance().hasHistory(this.getResourceFile());
        }
        return this.hasHistory;
    }

    public boolean hasAnnotations() {
        if (this.hasAnnotation == null) {
            this.hasAnnotation = !this.isDir() && HistoryGuru.getInstance().hasHistory(this.getResourceFile());
        }
        return this.hasAnnotation;
    }

    public boolean annotate() {
        if (this.annotate == null) {
            this.annotate = this.hasAnnotations() && Boolean.parseBoolean(this.req.getParameter("a"));
        }
        return this.annotate;
    }

    public Annotation getAnnotation() {
        if (this.isDir() || this.getResourcePath().equals("/") || !this.annotate()) {
            return null;
        }
        if (this.annotation != null) {
            return this.annotation;
        }
        this.getRequestedRevision();
        try {
            this.annotation = HistoryGuru.getInstance().annotate(this.resourceFile, this.rev.isEmpty() ? null : this.rev.substring(2));
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to get annotations: ", e);
        }
        return this.annotation;
    }

    public String getCrossFilename() {
        return this.getResourceFile().getName();
    }

    public String[] getSearchOnlyIn() {
        String[] res;
        if (this.isDir()) {
            String[] stringArray;
            if (this.path.length() == 0) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "/";
                stringArray2[1] = "this directory";
                stringArray = stringArray2;
                stringArray2[2] = "disabled=\"\"";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = this.path;
                stringArray3[1] = "this directory";
                stringArray = stringArray3;
                stringArray3[2] = "";
            }
            return stringArray;
        }
        res = new String[]{this.path.substring(0, this.path.lastIndexOf(47) + 1), res[0], ""};
        return res;
    }

    public Project getProject() {
        return Project.getProject(this.getResourceFile());
    }

    public String getRequestedProjectsAsString() {
        if (this.requestedProjectsString == null) {
            SortedSet<String> projects = this.getRequestedProjects();
            if (projects.isEmpty()) {
                this.requestedProjectsString = "";
            } else {
                StringBuilder buf = new StringBuilder();
                for (String name : projects) {
                    buf.append(name).append(',');
                }
                buf.setLength(buf.length() - 1);
                this.requestedProjectsString = buf.toString();
            }
        }
        return this.requestedProjectsString;
    }

    public String getDocumentHash() {
        return this.req.getParameter("h");
    }

    public SortedSet<String> getRequestedProjects() {
        if (this.requestedProjects == null) {
            this.requestedProjects = this.getRequestedProjects("project", "OpenGrokProject");
        }
        return this.requestedProjects;
    }

    private static void splitByComma(String value, List<String> result) {
        if (value == null || value.length() == 0) {
            return;
        }
        String[] p = COMMA_PATTERN.split(value);
        for (int k = 0; k < p.length; ++k) {
            if (p[k].length() == 0) continue;
            result.add(p[k]);
        }
    }

    public List<String> getCookieVals(String cookieName) {
        Cookie[] cookies = this.req.getCookies();
        ArrayList<String> res = new ArrayList<String>();
        if (cookies != null) {
            for (int i = cookies.length - 1; i >= 0; --i) {
                if (!cookies[i].getName().equals(cookieName)) continue;
                PageConfig.splitByComma(cookies[i].getValue(), res);
            }
        }
        return res;
    }

    private List<String> getParamVals(String paramName) {
        String[] vals = this.req.getParameterValues(paramName);
        ArrayList<String> res = new ArrayList<String>();
        if (vals != null) {
            for (int i = vals.length - 1; i >= 0; --i) {
                PageConfig.splitByComma(vals[i], res);
            }
        }
        return res;
    }

    protected SortedSet<String> getRequestedProjects(String paramName, String cookieName) {
        Project defaultProject;
        TreeSet<String> set = new TreeSet<String>();
        List<Project> projects = this.getEnv().getProjects();
        if (projects == null) {
            return set;
        }
        if (projects.size() == 1) {
            set.add(projects.get(0).getDescription());
            return set;
        }
        List<String> vals = this.getParamVals(paramName);
        for (String s : vals) {
            if (Project.getByDescription(s) == null) continue;
            set.add(s);
        }
        if (set.isEmpty()) {
            List<String> cookies = this.getCookieVals(cookieName);
            for (String s : cookies) {
                if (Project.getByDescription(s) == null) continue;
                set.add(s);
            }
        }
        if (set.isEmpty() && (defaultProject = this.env.getDefaultProject()) != null) {
            set.add(defaultProject.getDescription());
        }
        return set;
    }

    public void setTitle(String title) {
        this.pageTitle = title;
    }

    public String getTitle() {
        return this.pageTitle;
    }

    public String getCssDir() {
        return this.req.getContextPath() + '/' + this.getEnv().getWebappLAF();
    }

    public RuntimeEnvironment getEnv() {
        if (this.env == null) {
            this.env = RuntimeEnvironment.getInstance().register();
        }
        return this.env;
    }

    public IgnoredNames getIgnoredNames() {
        if (this.ignoredNames == null) {
            this.ignoredNames = this.getEnv().getIgnoredNames();
        }
        return this.ignoredNames;
    }

    public String getSourceRootPath() {
        String srcpath;
        if (this.sourceRootPath == null && (srcpath = this.getEnv().getSourceRootPath()) != null) {
            this.sourceRootPath = srcpath.replace(File.separatorChar, '/');
        }
        return this.sourceRootPath;
    }

    public Prefix getPrefix() {
        if (this.prefix == null) {
            this.prefix = Prefix.get(this.req.getServletPath());
        }
        return this.prefix;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = Util.getCanonicalPath(this.req.getPathInfo(), '/');
            if ("/".equals(this.path)) {
                this.path = "";
            }
        }
        return this.path;
    }

    public String getOnRedirect() {
        File newFile;
        if (this.check4on && (newFile = new File(this.getSourceRootPath() + "/on/" + this.getPath())).canRead()) {
            return this.req.getContextPath() + this.req.getServletPath() + "/on" + this.getUriEncodedPath() + (newFile.isDirectory() ? PageConfig.trailingSlash(this.path) : "");
        }
        return null;
    }

    public File getResourceFile() {
        if (this.resourceFile == null) {
            this.resourceFile = new File(this.getSourceRootPath(), this.getPath());
            if (!this.resourceFile.canRead()) {
                this.resourceFile = new File("/");
            }
        }
        return this.resourceFile;
    }

    public String getResourcePath() {
        if (this.resourcePath == null) {
            this.resourcePath = this.getResourceFile().getPath().replace(File.separatorChar, '/');
        }
        return this.resourcePath;
    }

    public boolean resourceNotAvailable() {
        this.getIgnoredNames();
        return this.getResourcePath().equals("/") || this.ignoredNames.ignore(this.getPath()) || this.ignoredNames.ignore(this.resourceFile.getParentFile().getName()) || this.ignoredNames.ignore(this.resourceFile);
    }

    public boolean isDir() {
        if (this.isDir == null) {
            this.isDir = this.getResourceFile().isDirectory();
        }
        return this.isDir;
    }

    private static String trailingSlash(String path) {
        return path.length() == 0 || path.charAt(path.length() - 1) != '/' ? "/" : "";
    }

    private File checkFile(File dir, String name, boolean compressed) {
        File f;
        if (compressed && (f = new File(dir, name + ".gz")).exists() && f.isFile() && f.lastModified() >= this.resourceFile.lastModified()) {
            return f;
        }
        f = new File(dir, name);
        if (f.exists() && f.isFile() && f.lastModified() >= this.resourceFile.lastModified()) {
            return f;
        }
        return null;
    }

    private File checkFileResolve(File dir, String name, boolean compressed) {
        File f;
        File lresourceFile = new File(this.getSourceRootPath() + this.getPath(), name);
        if (!lresourceFile.canRead()) {
            lresourceFile = new File("/");
        }
        if (compressed && (f = new File(dir, name + ".gz")).exists() && f.isFile() && f.lastModified() >= lresourceFile.lastModified()) {
            return f;
        }
        f = new File(dir, name);
        if (f.exists() && f.isFile() && f.lastModified() >= lresourceFile.lastModified()) {
            return f;
        }
        return null;
    }

    public File[] findDataFiles(List<String> filenames) {
        if (filenames == null || filenames.isEmpty()) {
            return new File[0];
        }
        File[] res = new File[filenames.size()];
        File dir = new File(this.getEnv().getDataRootPath() + (Object)((Object)Prefix.XREF_P) + this.path);
        if (dir.exists() && dir.isDirectory()) {
            this.getResourceFile();
            boolean compressed = this.getEnv().isCompressXref();
            for (int i = res.length - 1; i >= 0; --i) {
                res[i] = this.checkFileResolve(dir, filenames.get(i), compressed);
            }
        }
        return res;
    }

    public File findDataFile() {
        return this.checkFile(new File(this.getEnv().getDataRootPath() + (Object)((Object)Prefix.XREF_P)), this.path, this.env.isCompressXref());
    }

    public String getDirectoryRedirect() {
        if (this.isDir()) {
            if (this.path.length() == 0) {
                return null;
            }
            this.getPrefix();
            if (this.prefix != Prefix.XREF_P && this.prefix != Prefix.HIST_L) {
                return this.req.getContextPath() + (Object)((Object)Prefix.XREF_P) + this.getUriEncodedPath() + PageConfig.trailingSlash(this.path);
            }
            String ts = PageConfig.trailingSlash(this.path);
            if (ts.length() != 0) {
                return this.req.getContextPath() + (Object)((Object)this.prefix) + this.getUriEncodedPath() + ts;
            }
        }
        return null;
    }

    public String getUriEncodedPath() {
        if (this.uriEncodedPath == null) {
            this.uriEncodedPath = Util.URIEncodePath(this.getPath());
        }
        return this.uriEncodedPath;
    }

    public File getDataRoot() {
        if (this.dataRoot == null) {
            String tmp = this.getEnv().getDataRootPath();
            if (tmp == null || tmp.length() == 0) {
                throw new InvalidParameterException("dataRoot parameter is not set in configuration.xml!");
            }
            this.dataRoot = new File(tmp);
            if (!this.dataRoot.isDirectory() || !this.dataRoot.canRead()) {
                throw new InvalidParameterException("The configured dataRoot '" + tmp + "' refers to a none-existing or unreadable directory!");
            }
        }
        return this.dataRoot;
    }

    public SearchHelper prepareSearch() {
        SearchHelper sh = new SearchHelper();
        sh.dataRoot = this.getDataRoot();
        List<SortOrder> sortOrders = this.getSortOrder();
        SortOrder sortOrder = sh.order = sortOrders.isEmpty() ? SortOrder.RELEVANCY : sortOrders.get(0);
        if (this.getRequestedProjects().isEmpty() && this.getEnv().hasProjects()) {
            sh.errorMsg = "You must select a project!";
            return sh;
        }
        sh.builder = this.getQueryBuilder();
        if (sh.builder.getSize() == 0) {
            sh.redirect = this.req.getContextPath() + '/';
            return sh;
        }
        sh.start = this.getSearchStart();
        sh.maxItems = this.getSearchMaxItems();
        sh.contextPath = this.req.getContextPath();
        sh.parallel = Runtime.getRuntime().availableProcessors() > 1;
        sh.isCrossRefSearch = this.getPrefix() == Prefix.SEARCH_R;
        sh.compressed = this.env.isCompressXref();
        sh.desc = this.getEftarReader();
        sh.sourceRoot = new File(this.getSourceRootPath());
        return sh;
    }

    public static PageConfig get(HttpServletRequest request) {
        Object cfg = request.getAttribute(ATTR_NAME);
        if (cfg != null) {
            return (PageConfig)cfg;
        }
        PageConfig pcfg = new PageConfig(request);
        request.setAttribute(ATTR_NAME, (Object)pcfg);
        return pcfg;
    }

    private PageConfig(HttpServletRequest req) {
        this.req = req;
    }

    public static void cleanup(ServletRequest sr) {
        if (sr == null) {
            return;
        }
        PageConfig cfg = (PageConfig)sr.getAttribute(ATTR_NAME);
        if (cfg == null) {
            return;
        }
        sr.removeAttribute(ATTR_NAME);
        cfg.env = null;
        if (cfg.eftarReader != null) {
            cfg.eftarReader.close();
        }
    }
}

