/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public class ConfigurationMap
extends AbstractMap {
    Configuration configuration = null;

    public ConfigurationMap(Configuration configuration) {
        this.configuration = configuration;
    }

    public Set entrySet() {
        return new ConfigurationSet(this.configuration);
    }

    public Object put(Object key, Object value) {
        String strKey = String.valueOf(key);
        Object old = this.configuration.getProperty(strKey);
        this.configuration.setProperty(strKey, value);
        return old;
    }

    public Object get(Object key) {
        return this.configuration.getProperty(String.valueOf(key));
    }

    static class ConfigurationSet
    extends AbstractSet {
        private Configuration configuration = null;

        ConfigurationSet(Configuration configuration) {
            this.configuration = configuration;
        }

        public int size() {
            int count = 0;
            Iterator iterator = this.configuration.getKeys();
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
            return count;
        }

        public Iterator iterator() {
            return new ConfigurationSetIterator();
        }

        private class ConfigurationSetIterator
        implements Iterator {
            private Iterator keys;

            private ConfigurationSetIterator() {
                this.keys = ConfigurationSet.this.configuration.getKeys();
            }

            public boolean hasNext() {
                return this.keys.hasNext();
            }

            public Object next() {
                return new Entry(this.keys.next());
            }

            public void remove() {
                this.keys.remove();
            }
        }

        private class Entry
        implements Map.Entry {
            private Object key = null;

            private Entry(Object key) {
                this.key = key;
            }

            public Object getKey() {
                return this.key;
            }

            public Object getValue() {
                return ConfigurationSet.this.configuration.getProperty((String)this.key);
            }

            public Object setValue(Object value) {
                Object old = this.getValue();
                ConfigurationSet.this.configuration.setProperty((String)this.key, value);
                return old;
            }
        }
    }
}

