/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.autoupdate;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.autoupdate.ExtensionAutoUpdate;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.WaitMessageDialog;

public class ExtensionAutoUpdate
extends ExtensionAdaptor {
    private JMenuItem menuItemCheckUpdate = null;
    private ExtensionHookMenu extensionMenu = null;
    private static final String SF_PAROS_FILES = "http://sourceforge.net/project/showfiles.php?group_id=84378";
    private HttpSender httpSender = null;
    private Pattern patternNewestVersionWindows = Pattern.compile("paros-(\\d+)\\.(\\d+)\\.(\\d+)-win\\.dat", 8);
    private Pattern patternNewestVersionLinux = Pattern.compile("paros-(\\d+)\\.(\\d+)\\.(\\d+)-unix\\.zip", 8);
    String newestVersionName = null;
    private boolean manualCheckStarted = false;
    private final String header = "POST http://prdownloads.sourceforge.net/redir.php HTTP/1.1\r\nHost: prdownloads.sourceforge.net\r\nUser-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0;)\r\nPragma: no-cache\r\nContent-Type: application/x-www-form-urlencoded\r\n\r\n";
    private WaitMessageDialog waitDialog = null;
    private String[] mirrorList = new String[]{"osdn"};

    private String getBody(String string, String string2) {
        String string3 = "mirror=" + string + "&path=/paros/" + string2;
        return string3;
    }

    public ExtensionAutoUpdate() {
        this.initialize();
    }

    private void initialize() {
        this.setName("ExtensionAutoUpdate");
    }

    private JMenuItem getMenuItemCheckUpdate() {
        if (this.menuItemCheckUpdate == null) {
            this.menuItemCheckUpdate = new JMenuItem();
            this.menuItemCheckUpdate.setText("Check for Updates...");
            if (!Constant.isWindows() && !Constant.isLinux()) {
                this.menuItemCheckUpdate.setEnabled(false);
            }
            this.menuItemCheckUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Thread thread = new Thread(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ExtensionAutoUpdate.access$102(1.access$000(this.this$1), true);
                            1.access$000(this.this$1).newestVersionName = ExtensionAutoUpdate.access$200(1.access$000(this.this$1));
                            if (ExtensionAutoUpdate.access$300(1.access$000(this.this$1)) != null) {
                                ExtensionAutoUpdate.access$300(1.access$000(this.this$1)).hide();
                                ExtensionAutoUpdate.access$302(1.access$000(this.this$1), null);
                            }
                            EventQueue.invokeLater(new Runnable(this){
                                private final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void run() {
                                    if (1.access$000(2.access$400(this.this$2)).newestVersionName == null) {
                                        1.access$000(2.access$400(this.this$2)).getView().showMessageDialog("There is no new update available.  Paros may periodically check for update.");
                                    } else if (1.access$000(2.access$400(this.this$2)).newestVersionName.equals("")) {
                                        1.access$000(2.access$400(this.this$2)).getView().showWarningDialog("Error encountered.  Please check manually for new updates.");
                                    } else {
                                        int n = 1.access$000(2.access$400(this.this$2)).getView().showConfirmDialog("There is a newer version of Paros: " + 1.access$000(2.access$400(this.this$2)).newestVersionName.replaceAll("\\.dat", "") + "\nProceed to download?");
                                        if (n == 0) {
                                            ExtensionAutoUpdate.access$302(1.access$000(2.access$400(this.this$2)), 1.access$000(2.access$400(this.this$2)).getView().getWaitMessageDialog("Download in progress..."));
                                            Thread thread = new Thread(new Runnable(this){
                                                private final /* synthetic */ 3 this$3;
                                                {
                                                    this.this$3 = var1_1;
                                                }

                                                public void run() {
                                                    1.access$000(2.access$400(3.access$500(this.this$3))).download(false);
                                                }
                                            });
                                            thread.start();
                                            ExtensionAutoUpdate.access$300(1.access$000(2.access$400(this.this$2))).show();
                                        }
                                    }
                                }

                                static /* synthetic */ 2 access$500(3 var0) {
                                    return var0.this$2;
                                }
                            });
                        }

                        static /* synthetic */ 1 access$400(2 var0) {
                            return var0.this$1;
                        }
                    });
                    ExtensionAutoUpdate.this.waitDialog = ExtensionAutoUpdate.this.getView().getWaitMessageDialog("Checking if newer version exists...");
                    thread.start();
                    ExtensionAutoUpdate.this.waitDialog.show();
                }

                static /* synthetic */ ExtensionAutoUpdate access$000(1 var0) {
                    return var0.ExtensionAutoUpdate.this;
                }
            });
        }
        return this.menuItemCheckUpdate;
    }

    public void start() {
        if (!Constant.isWindows()) {
            return;
        }
        if (this.getRandom(30) != 1) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ExtensionAutoUpdate.this.newestVersionName = ExtensionAutoUpdate.this.getNewestVersionName();
                if (ExtensionAutoUpdate.this.newestVersionName == null || ExtensionAutoUpdate.this.newestVersionName.length() == 0) {
                    return;
                }
                ExtensionAutoUpdate.this.download(true);
            }
        });
        thread.start();
    }

    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuItemCheckUpdate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(final boolean bl) {
        if (this.newestVersionName == null) {
            return;
        }
        HttpMessage httpMessage = new HttpMessage();
        try {
            httpMessage.setRequestHeader("POST http://prdownloads.sourceforge.net/redir.php HTTP/1.1\r\nHost: prdownloads.sourceforge.net\r\nUser-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0;)\r\nPragma: no-cache\r\nContent-Type: application/x-www-form-urlencoded\r\n\r\n");
            httpMessage.setRequestBody(this.getBody(this.mirrorList[this.getRandom(this.mirrorList.length)], this.newestVersionName));
            this.getHttpSender().sendAndReceive(httpMessage, true);
            if (httpMessage.getResponseHeader().getStatusCode() != 200) {
                throw new IOException();
            }
            if (bl && this.manualCheckStarted) {
                return;
            }
            File file = null;
            if (Constant.isWindows()) {
                file = new File("parosnew.exe");
            } else if (Constant.isLinux()) {
                file = new File("parosnew.zip");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(httpMessage.getResponseBody().getBytes());
            fileOutputStream.close();
            try {
                final File file2 = file;
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        if (ExtensionAutoUpdate.this.waitDialog != null) {
                            ExtensionAutoUpdate.this.waitDialog.hide();
                        }
                        if (!bl) {
                            String string = "A newer verison has been downloaded.  It will be installed the \nnext time Paros is started.";
                            if (Constant.isLinux()) {
                                string = string + "  Note: Use startserver.sh to run Paros.";
                            }
                            ExtensionAutoUpdate.this.getView().showMessageDialog(string);
                        } else {
                            int n;
                            String string = "A newer version is available.  Install the new version \nnext time Paros is started?";
                            if (Constant.isLinux()) {
                                string = string + "  Note: Use startserver.sh to run Paros.";
                            }
                            if ((n = ExtensionAutoUpdate.this.getView().showConfirmDialog(string)) != 0) {
                                file2.delete();
                            }
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        if (ExtensionAutoUpdate.this.waitDialog != null) {
                            ExtensionAutoUpdate.this.waitDialog.hide();
                        }
                        if (!bl) {
                            ExtensionAutoUpdate.this.getView().showWarningDialog("Error encountered.  Please download new updates manually");
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.waitDialog != null) {
                this.waitDialog.hide();
            }
        }
        finally {
            this.httpSender.shutdown();
            this.httpSender = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewestVersionName() {
        String string = null;
        HttpMessage httpMessage = null;
        String string2 = null;
        try {
            int n;
            int n2;
            int n3;
            long l;
            httpMessage = new HttpMessage(new URI(SF_PAROS_FILES, true));
            this.getHttpSender().sendAndReceive(httpMessage, true);
            if (httpMessage.getResponseHeader().getStatusCode() != 200) {
                throw new IOException();
            }
            string2 = httpMessage.getResponseBody().toString();
            Matcher matcher = null;
            matcher = Constant.isWindows() ? this.patternNewestVersionWindows.matcher(string2) : this.patternNewestVersionLinux.matcher(string2);
            if (matcher.find() && (l = (long)(10000000 * (n3 = Integer.parseInt(matcher.group(1))) + 10000 * (n2 = Integer.parseInt(matcher.group(2))) + (n = Integer.parseInt(matcher.group(3))))) > 30020013L) {
                string = matcher.group(0);
            }
        }
        catch (Exception exception) {
            string = "";
        }
        finally {
            this.httpSender.shutdown();
            this.httpSender = null;
        }
        return string;
    }

    private HttpSender getHttpSender() {
        if (this.httpSender == null) {
            this.httpSender = new HttpSender(this.getModel().getOptionsParam().getConnectionParam(), true);
        }
        return this.httpSender;
    }

    private int getRandom(int n) {
        int n2 = (int)((double)n * Math.random());
        return n2;
    }

    static /* synthetic */ boolean access$102(ExtensionAutoUpdate extensionAutoUpdate, boolean bl) {
        extensionAutoUpdate.manualCheckStarted = bl;
        return extensionAutoUpdate.manualCheckStarted;
    }
}

