/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.graph;

import java.awt.geom.GeneralPath;

public abstract class LinkRouting {
    protected float lx0;
    protected float lx1;
    protected float lx2;
    protected float ly0;
    protected float ly1;
    protected float ly2;
    protected float fx0;
    protected float fx1;
    protected float fy0;
    protected float fy1;
    protected int nbPoints;
    protected GeneralPath path;

    protected void addLinkPoint(double d, double d2) {
        this.addLinkPoint(d, d2, true);
    }

    protected void addLinkPoint(double d, double d2, boolean bl) {
        this.lx2 = this.lx1;
        this.ly2 = this.ly1;
        this.lx1 = this.lx0;
        this.ly1 = this.ly0;
        this.lx0 = (int)Math.round(d);
        this.ly0 = (int)Math.round(d2);
        if (this.nbPoints == 0) {
            this.fx0 = this.lx0;
            this.fy0 = this.ly0;
            this.path.moveTo(this.lx0, this.ly0);
        } else {
            if (this.nbPoints == 1) {
                this.fx1 = this.lx0;
                this.fy1 = this.ly0;
            }
            if (bl) {
                this.path.lineTo(this.lx0, this.ly0);
            }
        }
        ++this.nbPoints;
    }

    protected void resetLinkPoints() {
        this.nbPoints = 0;
        this.lx0 = -1.0f;
        this.lx1 = -1.0f;
        this.ly0 = -1.0f;
        this.ly1 = -1.0f;
        this.fx0 = -1.0f;
        this.fx1 = -1.0f;
        this.fy0 = -1.0f;
        this.fy1 = -1.0f;
        this.path.reset();
    }

    protected void line() {
        this.path.lineTo(this.lx0, this.ly0);
    }

    protected void quad() {
        this.path.quadTo(this.lx1, this.ly1, this.lx0, this.ly0);
    }

    protected void curve() {
        this.path.curveTo(this.lx2, this.ly2, this.lx1, this.ly1, this.lx0, this.ly0);
    }

    public float getFirstX() {
        return this.fx0;
    }

    public float getFirstY() {
        return this.fy0;
    }

    public float getLastX() {
        return this.lx0;
    }

    public float getLastY() {
        return this.ly0;
    }

    public double getFirstAngle() {
        return Math.atan2(this.fy1 - this.fy0, this.fx0 - this.fx1);
    }

    public double getLastAngle() {
        return Math.atan2(this.ly1 - this.ly0, this.lx0 - this.lx1);
    }
}

