/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JREmbeddedImagesXmlSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_XML = ".xml";
    private static final String EXTENSION_JRPXML = ".jrpxml";

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName().toLowerCase();
        return name.endsWith(EXTENSION_XML) || name.endsWith(EXTENSION_JRPXML);
    }

    public String getDescription() {
        return "Embedded images XML (*.jrpxml, *.xml)";
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().endsWith(EXTENSION_XML) && !file.getName().endsWith(EXTENSION_JRPXML)) {
            file = new File(file.getAbsolutePath() + EXTENSION_JRPXML);
        }
        JRXmlExporter exporter = new JRXmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
        exporter.setParameter(JRXmlExporterParameter.IS_EMBEDDING_IMAGES, Boolean.TRUE);
        exporter.exportReport();
    }
}

