/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class LoaderConfiguration {
    private static final String MAIN_PREFIX = "main is";
    private static final String LOAD_PREFIX = "load";
    private ArrayList classPath = new ArrayList();
    private String main;
    private boolean requireMain = true;

    public void configure(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        int lineNumber = 0;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            ++lineNumber;
            if (line.startsWith("#") || line.length() == 0) continue;
            if (line.startsWith(LOAD_PREFIX)) {
                String loadPath = line.substring(LOAD_PREFIX.length()).trim();
                loadPath = this.assignProperties(loadPath);
                this.loadFilteredPath(loadPath);
                continue;
            }
            if (line.startsWith(MAIN_PREFIX)) {
                if (this.main != null) {
                    throw new IOException("duplicate definition of main in line " + lineNumber + " : " + line);
                }
                this.main = line.substring(MAIN_PREFIX.length()).trim();
                continue;
            }
            throw new IOException("unexpected line in " + lineNumber + " : " + line);
        }
        if (this.requireMain && this.main == null) {
            throw new IOException("missing main class definition in config file");
        }
    }

    private String assignProperties(String str) {
        int propertyIndexStart = 0;
        int propertyIndexEnd = 0;
        String result = "";
        while (propertyIndexStart < str.length() && (propertyIndexStart = str.indexOf("${", propertyIndexStart)) != -1) {
            result = result + str.substring(propertyIndexEnd, propertyIndexStart);
            propertyIndexEnd = str.indexOf("}", propertyIndexStart);
            if (propertyIndexEnd == -1) break;
            String propertyKey = str.substring(propertyIndexStart + 2, propertyIndexEnd);
            String propertyValue = System.getProperty(propertyKey);
            result = result + propertyValue;
            propertyIndexStart = ++propertyIndexEnd;
        }
        if (propertyIndexStart == -1 || propertyIndexStart >= str.length()) {
            result = result + str.substring(propertyIndexEnd);
        } else if (propertyIndexEnd == -1) {
            result = result + str.substring(propertyIndexStart);
        }
        return result;
    }

    private void loadFilteredPath(String filter) {
        int starIndex = filter.indexOf(42);
        if (starIndex == -1) {
            this.addFile(new File(filter));
            return;
        }
        if (!this.parentPathDoesExist(filter)) {
            return;
        }
        String filterPart = this.getParentPath(filter);
        int index = filterPart.indexOf(42);
        final String prefix = filterPart.substring(0, index);
        final String suffix = filterPart.substring(index + 1);
        File dir = new File(filter.substring(0, filter.length() - filterPart.length()));
        FilenameFilter ff = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!name.startsWith(prefix)) {
                    return false;
                }
                return name.endsWith(suffix);
            }
        };
        File[] matches = dir.listFiles(ff);
        for (int i = 0; i < matches.length; ++i) {
            this.addFile(matches[i]);
        }
    }

    private boolean parentPathDoesExist(String path) {
        File dir = new File(path).getParentFile();
        return dir.exists();
    }

    private String getParentPath(String filter) {
        int index = filter.lastIndexOf(47);
        if (index == -1) {
            return "";
        }
        return filter.substring(index + 1);
    }

    public void addFile(File f) {
        if (f != null && f.exists()) {
            try {
                this.classPath.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)"converting an existing file to an url should have never thrown an exception!");
            }
        }
    }

    public void addFile(String s) {
        if (s != null) {
            this.addFile(new File(s));
        }
    }

    public void addClassPath(String path) {
        String[] paths = path.split(File.pathSeparator);
        for (int i = 0; i < paths.length; ++i) {
            this.addFile(new File(paths[i]));
        }
    }

    public URL[] getClassPathUrls() {
        return this.classPath.toArray(new URL[0]);
    }

    public String getMainClass() {
        return this.main;
    }

    public void setMainClass(String clazz) {
        this.main = clazz;
        this.requireMain = false;
    }

    public void setRequireMain(boolean requireMain) {
        this.requireMain = requireMain;
    }
}

