# pylint:disable=line-too-long
from __future__ import annotations
from collections import OrderedDict

from angr.procedures.definitions import SimTypeCollection
from angr.sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeArray,     SimTypeBottom,     SimUnion,     SimTypeBool,     SimTypeRef

typelib = SimTypeCollection()
typelib.set_names(*['win32'])
typelib.types = {
    "AAAccountingData": SimStruct(OrderedDict((("userName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("clientName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("authType", SimTypeInt(signed=False, label="AAAuthSchemes")), ("resourceName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("portNumber", SimTypeInt(signed=True, label="Int32")), ("protocolName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("numberOfBytesReceived", SimTypeInt(signed=True, label="Int32")), ("numberOfBytesTransfered", SimTypeInt(signed=True, label="Int32")), ("reasonForDisconnect", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("mainSessionId", SimTypeBottom(label="Guid")), ("subSessionId", SimTypeInt(signed=True, label="Int32")),)), name="AAAccountingData", pack=False, align=None),
    "AAAccountingDataType": SimTypeInt(signed=False, label="AAAccountingDataType"),
    "AAAuthSchemes": SimTypeInt(signed=False, label="AAAuthSchemes"),
    "AAL5_PARAMETERS": SimStruct(OrderedDict((("ForwardMaxCPCSSDUSize", SimTypeInt(signed=False, label="UInt32")), ("BackwardMaxCPCSSDUSize", SimTypeInt(signed=False, label="UInt32")), ("Mode", SimTypeChar(label="Byte")), ("SSCSType", SimTypeChar(label="Byte")),)), name="AAL5_PARAMETERS", pack=False, align=None),
    "AALUSER_PARAMETERS": SimStruct(OrderedDict((("UserDefined", SimTypeInt(signed=False, label="UInt32")),)), name="AALUSER_PARAMETERS", pack=False, align=None),
    "AAL_PARAMETERS_IE": SimStruct(OrderedDict((("AALType", SimTypeInt(signed=False, label="AAL_TYPE")), ("AALSpecificParameters", SimUnion({"AAL5Parameters": SimTypeRef("AAL5_PARAMETERS", SimStruct), "AALUserParameters": SimTypeRef("AALUSER_PARAMETERS", SimStruct)}, name="<anon>", label="None")),)), name="AAL_PARAMETERS_IE", pack=False, align=None),
    "AAL_TYPE": SimTypeInt(signed=False, label="AAL_TYPE"),
    "AASHELLMENUFILENAME": SimStruct(OrderedDict((("cbTotal", SimTypeShort(signed=True, label="Int16")), ("rgbReserved", SimTypeArray(SimTypeChar(label="Byte"), 12)), ("szFileName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="AASHELLMENUFILENAME", pack=False, align=None),
    "AASHELLMENUITEM": SimStruct(OrderedDict((("lpReserved1", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("iReserved", SimTypeInt(signed=True, label="Int32")), ("uiReserved", SimTypeInt(signed=False, label="UInt32")), ("lpName", SimTypePointer(SimTypeRef("AASHELLMENUFILENAME", SimStruct), offset=0)), ("psz", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="AASHELLMENUITEM", pack=False, align=None),
    "AATrustClassID": SimTypeInt(signed=False, label="AATrustClassID"),
    "ABC": SimStruct(OrderedDict((("abcA", SimTypeInt(signed=True, label="Int32")), ("abcB", SimTypeInt(signed=False, label="UInt32")), ("abcC", SimTypeInt(signed=True, label="Int32")),)), name="ABC", pack=False, align=None),
    "ABCFLOAT": SimStruct(OrderedDict((("abcfA", SimTypeFloat(size=32)), ("abcfB", SimTypeFloat(size=32)), ("abcfC", SimTypeFloat(size=32)),)), name="ABCFLOAT", pack=False, align=None),
    "ABORTPATH": SimStruct(OrderedDict((("emr", SimTypeRef("EMR", SimStruct)),)), name="ABORTPATH", pack=False, align=None),
    "ABORTPROC": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0),
    "ACCEL": SimStruct(OrderedDict((("fVirt", SimTypeInt(signed=False, label="ACCEL_VIRT_FLAGS")), ("key", SimTypeShort(signed=False, label="UInt16")), ("cmd", SimTypeShort(signed=False, label="UInt16")),)), name="ACCEL", pack=False, align=None),
    "ACCEL_VIRT_FLAGS": SimTypeInt(signed=False, label="ACCEL_VIRT_FLAGS"),
    "ACCEPT_SECURITY_CONTEXT_FN": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("SecHandle", SimStruct), offset=0), SimTypePointer(SimTypeRef("SecHandle", SimStruct), offset=0), SimTypePointer(SimTypeRef("SecBufferDesc", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SecHandle", SimStruct), offset=0), SimTypePointer(SimTypeRef("SecBufferDesc", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7", "param8"]), offset=0),
    "ACCESSRECTLIST": SimStruct(OrderedDict((("lpLink", SimTypePointer(SimTypeRef("ACCESSRECTLIST", SimStruct), offset=0)), ("rDest", SimTypeRef("RECT", SimStruct)), ("lpOwner", SimTypePointer(SimTypeRef("DDRAWI_DIRECTDRAW_LCL", SimStruct), offset=0)), ("lpSurfaceData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("lpHeapAliasInfo", SimTypePointer(SimTypeRef("HEAPALIASINFO", SimStruct), offset=0)),)), name="ACCESSRECTLIST", pack=False, align=None),
    "ACCESSTIMEOUT": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("iTimeOutMSec", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESSTIMEOUT", pack=False, align=None),
    "ACCESS_ALLOWED_ACE": SimStruct(OrderedDict((("Header", SimTypeRef("ACE_HEADER", SimStruct)), ("Mask", SimTypeInt(signed=False, label="UInt32")), ("SidStart", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESS_ALLOWED_ACE", pack=False, align=None),
    "ACCESS_ALLOWED_CALLBACK_ACE": SimStruct(OrderedDict((("Header", SimTypeRef("ACE_HEADER", SimStruct)), ("Mask", SimTypeInt(signed=False, label="UInt32")), ("SidStart", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESS_ALLOWED_CALLBACK_ACE", pack=False, align=None),
    "ACCESS_ALLOWED_CALLBACK_OBJECT_ACE": SimStruct(OrderedDict((("Header", SimTypeRef("ACE_HEADER", SimStruct)), ("Mask", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="SYSTEM_AUDIT_OBJECT_ACE_FLAGS")), ("ObjectType", SimTypeBottom(label="Guid")), ("InheritedObjectType", SimTypeBottom(label="Guid")), ("SidStart", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESS_ALLOWED_CALLBACK_OBJECT_ACE", pack=False, align=None),
    "ACCESS_ALLOWED_OBJECT_ACE": SimStruct(OrderedDict((("Header", SimTypeRef("ACE_HEADER", SimStruct)), ("Mask", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="SYSTEM_AUDIT_OBJECT_ACE_FLAGS")), ("ObjectType", SimTypeBottom(label="Guid")), ("InheritedObjectType", SimTypeBottom(label="Guid")), ("SidStart", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESS_ALLOWED_OBJECT_ACE", pack=False, align=None),
    "ACCESS_DENIED_ACE": SimStruct(OrderedDict((("Header", SimTypeRef("ACE_HEADER", SimStruct)), ("Mask", SimTypeInt(signed=False, label="UInt32")), ("SidStart", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESS_DENIED_ACE", pack=False, align=None),
    "ACCESS_DENIED_CALLBACK_ACE": SimStruct(OrderedDict((("Header", SimTypeRef("ACE_HEADER", SimStruct)), ("Mask", SimTypeInt(signed=False, label="UInt32")), ("SidStart", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESS_DENIED_CALLBACK_ACE", pack=False, align=None),
    "ACCESS_DENIED_CALLBACK_OBJECT_ACE": SimStruct(OrderedDict((("Header", SimTypeRef("ACE_HEADER", SimStruct)), ("Mask", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="SYSTEM_AUDIT_OBJECT_ACE_FLAGS")), ("ObjectType", SimTypeBottom(label="Guid")), ("InheritedObjectType", SimTypeBottom(label="Guid")), ("SidStart", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESS_DENIED_CALLBACK_OBJECT_ACE", pack=False, align=None),
    "ACCESS_DENIED_OBJECT_ACE": SimStruct(OrderedDict((("Header", SimTypeRef("ACE_HEADER", SimStruct)), ("Mask", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="SYSTEM_AUDIT_OBJECT_ACE_FLAGS")), ("ObjectType", SimTypeBottom(label="Guid")), ("InheritedObjectType", SimTypeBottom(label="Guid")), ("SidStart", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESS_DENIED_OBJECT_ACE", pack=False, align=None),
    "ACCESS_INFO_0": SimStruct(OrderedDict((("acc0_resource_name", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ACCESS_INFO_0", pack=False, align=None),
    "ACCESS_INFO_1": SimStruct(OrderedDict((("acc1_resource_name", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("acc1_attr", SimTypeInt(signed=False, label="UInt32")), ("acc1_count", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESS_INFO_1", pack=False, align=None),
    "ACCESS_INFO_1002": SimStruct(OrderedDict((("acc1002_attr", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESS_INFO_1002", pack=False, align=None),
    "ACCESS_LIST": SimStruct(OrderedDict((("acl_ugname", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("acl_access", SimTypeInt(signed=False, label="UInt32")),)), name="ACCESS_LIST", pack=False, align=None),
    "ACCESS_MASKENUM": SimTypeInt(signed=False, label="ACCESS_MASKENUM"),
    "ACCESS_MODE": SimTypeInt(signed=False, label="ACCESS_MODE"),
    "ACCESS_REASONS": SimStruct(OrderedDict((("Data", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 32)),)), name="ACCESS_REASONS", pack=False, align=None),
    "ACCESS_REASON_TYPE": SimTypeInt(signed=False, label="ACCESS_REASON_TYPE"),
    "ACCESS_STATE": SimStruct(OrderedDict((("OperationID", SimTypeRef("LUID", SimStruct)), ("SecurityEvaluated", SimTypeChar(label="Byte")), ("GenerateAudit", SimTypeChar(label="Byte")), ("GenerateOnClose", SimTypeChar(label="Byte")), ("PrivilegesAllocated", SimTypeChar(label="Byte")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("RemainingDesiredAccess", SimTypeInt(signed=False, label="UInt32")), ("PreviouslyGrantedAccess", SimTypeInt(signed=False, label="UInt32")), ("OriginalDesiredAccess", SimTypeInt(signed=False, label="UInt32")), ("SubjectSecurityContext", SimTypeRef("SECURITY_SUBJECT_CONTEXT", SimStruct)), ("SecurityDescriptor", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("AuxData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("Privileges", SimUnion({"InitialPrivilegeSet": SimTypeRef("INITIAL_PRIVILEGE_SET", SimStruct), "PrivilegeSet": SimTypeRef("PRIVILEGE_SET", SimStruct)}, name="<anon>", label="None")), ("AuditPrivileges", SimTypeChar(label="Byte")), ("ObjectName", SimTypeRef("UNICODE_STRING", SimStruct)), ("ObjectTypeName", SimTypeRef("UNICODE_STRING", SimStruct)),)), name="ACCESS_STATE", pack=False, align=None),
    "ACCOUNTINGPROPERTIES": SimTypeInt(signed=False, label="ACCOUNTINGPROPERTIES"),
    "ACCOUNT_STATE": SimTypeInt(signed=False, label="ACCOUNT_STATE"),
    "ACC_UTILITY_STATE_FLAGS": SimTypeInt(signed=False, label="ACC_UTILITY_STATE_FLAGS"),
    "ACDGROUP_EVENT": SimTypeInt(signed=False, label="ACDGROUP_EVENT"),
    "ACDQUEUE_EVENT": SimTypeInt(signed=False, label="ACDQUEUE_EVENT"),
    "ACENUMOPTION": SimTypeInt(signed=False, label="ACENUMOPTION"),
    "ACE_FLAGS": SimTypeInt(signed=False, label="ACE_FLAGS"),
    "ACE_HEADER": SimStruct(OrderedDict((("AceType", SimTypeChar(label="Byte")), ("AceFlags", SimTypeChar(label="Byte")), ("AceSize", SimTypeShort(signed=False, label="UInt16")),)), name="ACE_HEADER", pack=False, align=None),
    "ACE_REVISION": SimTypeInt(signed=False, label="ACE_REVISION"),
    "ACL": SimStruct(OrderedDict((("AclRevision", SimTypeChar(label="Byte")), ("Sbz1", SimTypeChar(label="Byte")), ("AclSize", SimTypeShort(signed=False, label="UInt16")), ("AceCount", SimTypeShort(signed=False, label="UInt16")), ("Sbz2", SimTypeShort(signed=False, label="UInt16")),)), name="ACL", pack=False, align=None),
    "ACL_INFORMATION_CLASS": SimTypeInt(signed=False, label="ACL_INFORMATION_CLASS"),
    "ACL_REVISION_INFORMATION": SimStruct(OrderedDict((("AclRevision", SimTypeInt(signed=False, label="UInt32")),)), name="ACL_REVISION_INFORMATION", pack=False, align=None),
    "ACL_SIZE_INFORMATION": SimStruct(OrderedDict((("AceCount", SimTypeInt(signed=False, label="UInt32")), ("AclBytesInUse", SimTypeInt(signed=False, label="UInt32")), ("AclBytesFree", SimTypeInt(signed=False, label="UInt32")),)), name="ACL_SIZE_INFORMATION", pack=False, align=None),
    "ACMDRIVERDETAILSA": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fccType", SimTypeInt(signed=False, label="UInt32")), ("fccComp", SimTypeInt(signed=False, label="UInt32")), ("wMid", SimTypeShort(signed=False, label="UInt16")), ("wPid", SimTypeShort(signed=False, label="UInt16")), ("vdwACM", SimTypeInt(signed=False, label="UInt32")), ("vdwDriver", SimTypeInt(signed=False, label="UInt32")), ("fdwSupport", SimTypeInt(signed=False, label="UInt32")), ("cFormatTags", SimTypeInt(signed=False, label="UInt32")), ("cFilterTags", SimTypeInt(signed=False, label="UInt32")), ("hicon", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("szShortName", SimTypeArray(SimTypeChar(label="SByte"), 32)), ("szLongName", SimTypeArray(SimTypeChar(label="SByte"), 128)), ("szCopyright", SimTypeArray(SimTypeChar(label="SByte"), 80)), ("szLicensing", SimTypeArray(SimTypeChar(label="SByte"), 128)), ("szFeatures", SimTypeArray(SimTypeChar(label="SByte"), 512)),)), name="ACMDRIVERDETAILSA", pack=False, align=None),
    "ACMDRIVERDETAILSW": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fccType", SimTypeInt(signed=False, label="UInt32")), ("fccComp", SimTypeInt(signed=False, label="UInt32")), ("wMid", SimTypeShort(signed=False, label="UInt16")), ("wPid", SimTypeShort(signed=False, label="UInt16")), ("vdwACM", SimTypeInt(signed=False, label="UInt32")), ("vdwDriver", SimTypeInt(signed=False, label="UInt32")), ("fdwSupport", SimTypeInt(signed=False, label="UInt32")), ("cFormatTags", SimTypeInt(signed=False, label="UInt32")), ("cFilterTags", SimTypeInt(signed=False, label="UInt32")), ("hicon", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("szShortName", SimTypeArray(SimTypeChar(label="Char"), 32)), ("szLongName", SimTypeArray(SimTypeChar(label="Char"), 128)), ("szCopyright", SimTypeArray(SimTypeChar(label="Char"), 80)), ("szLicensing", SimTypeArray(SimTypeChar(label="Char"), 128)), ("szFeatures", SimTypeArray(SimTypeChar(label="Char"), 512)),)), name="ACMDRIVERDETAILSW", pack=False, align=None),
    "ACMDRIVERENUMCB": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "dwInstance", "fdwSupport"]), offset=0),
    "ACMDRVFORMATSUGGEST": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fdwSuggest", SimTypeInt(signed=False, label="UInt32")), ("pwfxSrc", SimTypePointer(SimTypeRef("WAVEFORMATEX", SimStruct), offset=0)), ("cbwfxSrc", SimTypeInt(signed=False, label="UInt32")), ("pwfxDst", SimTypePointer(SimTypeRef("WAVEFORMATEX", SimStruct), offset=0)), ("cbwfxDst", SimTypeInt(signed=False, label="UInt32")),)), name="ACMDRVFORMATSUGGEST", pack=False, align=None),
    "ACMDRVOPENDESCA": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fccType", SimTypeInt(signed=False, label="UInt32")), ("fccComp", SimTypeInt(signed=False, label="UInt32")), ("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwError", SimTypeInt(signed=False, label="UInt32")), ("pszSectionName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pszAliasName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dnDevNode", SimTypeInt(signed=False, label="UInt32")),)), name="ACMDRVOPENDESCA", pack=False, align=None),
    "ACMDRVOPENDESCW": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fccType", SimTypeInt(signed=False, label="UInt32")), ("fccComp", SimTypeInt(signed=False, label="UInt32")), ("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwError", SimTypeInt(signed=False, label="UInt32")), ("pszSectionName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszAliasName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dnDevNode", SimTypeInt(signed=False, label="UInt32")),)), name="ACMDRVOPENDESCW", pack=False, align=None),
    "ACMDRVSTREAMHEADER": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fdwStatus", SimTypeInt(signed=False, label="UInt32")), ("dwUser", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("pbSrc", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbSrcLength", SimTypeInt(signed=False, label="UInt32")), ("cbSrcLengthUsed", SimTypeInt(signed=False, label="UInt32")), ("dwSrcUser", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("pbDst", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbDstLength", SimTypeInt(signed=False, label="UInt32")), ("cbDstLengthUsed", SimTypeInt(signed=False, label="UInt32")), ("dwDstUser", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("fdwConvert", SimTypeInt(signed=False, label="UInt32")), ("padshNext", SimTypePointer(SimTypeRef("ACMDRVSTREAMHEADER", SimStruct), offset=0)), ("fdwDriver", SimTypeInt(signed=False, label="UInt32")), ("dwDriver", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("fdwPrepared", SimTypeInt(signed=False, label="UInt32")), ("dwPrepared", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("pbPreparedSrc", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbPreparedSrcLength", SimTypeInt(signed=False, label="UInt32")), ("pbPreparedDst", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbPreparedDstLength", SimTypeInt(signed=False, label="UInt32")),)), name="ACMDRVSTREAMHEADER", pack=False, align=None),
    "ACMDRVSTREAMINSTANCE": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("pwfxSrc", SimTypePointer(SimTypeRef("WAVEFORMATEX", SimStruct), offset=0)), ("pwfxDst", SimTypePointer(SimTypeRef("WAVEFORMATEX", SimStruct), offset=0)), ("pwfltr", SimTypePointer(SimTypeRef("WAVEFILTER", SimStruct), offset=0)), ("dwCallback", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("dwInstance", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("fdwOpen", SimTypeInt(signed=False, label="UInt32")), ("fdwDriver", SimTypeInt(signed=False, label="UInt32")), ("dwDriver", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("has", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="ACMDRVSTREAMINSTANCE", pack=False, align=None),
    "ACMDRVSTREAMSIZE": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fdwSize", SimTypeInt(signed=False, label="UInt32")), ("cbSrcLength", SimTypeInt(signed=False, label="UInt32")), ("cbDstLength", SimTypeInt(signed=False, label="UInt32")),)), name="ACMDRVSTREAMSIZE", pack=False, align=None),
    "ACMFILTERCHOOSEA": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fdwStyle", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pwfltr", SimTypePointer(SimTypeRef("WAVEFILTER", SimStruct), offset=0)), ("cbwfltr", SimTypeInt(signed=False, label="UInt32")), ("pszTitle", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("szFilterTag", SimTypeArray(SimTypeChar(label="SByte"), 48)), ("szFilter", SimTypeArray(SimTypeChar(label="SByte"), 128)), ("pszName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cchName", SimTypeInt(signed=False, label="UInt32")), ("fdwEnum", SimTypeInt(signed=False, label="UInt32")), ("pwfltrEnum", SimTypePointer(SimTypeRef("WAVEFILTER", SimStruct), offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pszTemplateName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0)),)), name="ACMFILTERCHOOSEA", pack=False, align=None),
    "ACMFILTERCHOOSEHOOKPROCA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0),
    "ACMFILTERCHOOSEHOOKPROCW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0),
    "ACMFILTERCHOOSEW": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fdwStyle", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pwfltr", SimTypePointer(SimTypeRef("WAVEFILTER", SimStruct), offset=0)), ("cbwfltr", SimTypeInt(signed=False, label="UInt32")), ("pszTitle", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("szFilterTag", SimTypeArray(SimTypeChar(label="Char"), 48)), ("szFilter", SimTypeArray(SimTypeChar(label="Char"), 128)), ("pszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cchName", SimTypeInt(signed=False, label="UInt32")), ("fdwEnum", SimTypeInt(signed=False, label="UInt32")), ("pwfltrEnum", SimTypePointer(SimTypeRef("WAVEFILTER", SimStruct), offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pszTemplateName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0)),)), name="ACMFILTERCHOOSEW", pack=False, align=None),
    "ACMFILTERDETAILSA": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("dwFilterIndex", SimTypeInt(signed=False, label="UInt32")), ("dwFilterTag", SimTypeInt(signed=False, label="UInt32")), ("fdwSupport", SimTypeInt(signed=False, label="UInt32")), ("pwfltr", SimTypePointer(SimTypeRef("WAVEFILTER", SimStruct), offset=0)), ("cbwfltr", SimTypeInt(signed=False, label="UInt32")), ("szFilter", SimTypeArray(SimTypeChar(label="SByte"), 128)),)), name="ACMFILTERDETAILSA", pack=False, align=None),
    "ACMFILTERDETAILSW": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("dwFilterIndex", SimTypeInt(signed=False, label="UInt32")), ("dwFilterTag", SimTypeInt(signed=False, label="UInt32")), ("fdwSupport", SimTypeInt(signed=False, label="UInt32")), ("pwfltr", SimTypePointer(SimTypeRef("WAVEFILTER", SimStruct), offset=0)), ("cbwfltr", SimTypeInt(signed=False, label="UInt32")), ("szFilter", SimTypeArray(SimTypeChar(label="Char"), 128)),)), name="ACMFILTERDETAILSW", pack=False, align=None),
    "ACMFILTERENUMCBA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("ACMFILTERDETAILSA", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "pafd", "dwInstance", "fdwSupport"]), offset=0),
    "ACMFILTERENUMCBW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("ACMFILTERDETAILSW", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "pafd", "dwInstance", "fdwSupport"]), offset=0),
    "ACMFILTERTAGDETAILSA": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("dwFilterTagIndex", SimTypeInt(signed=False, label="UInt32")), ("dwFilterTag", SimTypeInt(signed=False, label="UInt32")), ("cbFilterSize", SimTypeInt(signed=False, label="UInt32")), ("fdwSupport", SimTypeInt(signed=False, label="UInt32")), ("cStandardFilters", SimTypeInt(signed=False, label="UInt32")), ("szFilterTag", SimTypeArray(SimTypeChar(label="SByte"), 48)),)), name="ACMFILTERTAGDETAILSA", pack=False, align=None),
    "ACMFILTERTAGDETAILSW": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("dwFilterTagIndex", SimTypeInt(signed=False, label="UInt32")), ("dwFilterTag", SimTypeInt(signed=False, label="UInt32")), ("cbFilterSize", SimTypeInt(signed=False, label="UInt32")), ("fdwSupport", SimTypeInt(signed=False, label="UInt32")), ("cStandardFilters", SimTypeInt(signed=False, label="UInt32")), ("szFilterTag", SimTypeArray(SimTypeChar(label="Char"), 48)),)), name="ACMFILTERTAGDETAILSW", pack=False, align=None),
    "ACMFILTERTAGENUMCBA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("ACMFILTERTAGDETAILSA", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "paftd", "dwInstance", "fdwSupport"]), offset=0),
    "ACMFILTERTAGENUMCBW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("ACMFILTERTAGDETAILSW", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "paftd", "dwInstance", "fdwSupport"]), offset=0),
    "ACMFORMATCHOOSEA": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fdwStyle", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pwfx", SimTypePointer(SimTypeRef("WAVEFORMATEX", SimStruct), offset=0)), ("cbwfx", SimTypeInt(signed=False, label="UInt32")), ("pszTitle", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("szFormatTag", SimTypeArray(SimTypeChar(label="SByte"), 48)), ("szFormat", SimTypeArray(SimTypeChar(label="SByte"), 128)), ("pszName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cchName", SimTypeInt(signed=False, label="UInt32")), ("fdwEnum", SimTypeInt(signed=False, label="UInt32")), ("pwfxEnum", SimTypePointer(SimTypeRef("WAVEFORMATEX", SimStruct), offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pszTemplateName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0)),)), name="ACMFORMATCHOOSEA", pack=False, align=None),
    "ACMFORMATCHOOSEHOOKPROCA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0),
    "ACMFORMATCHOOSEHOOKPROCW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0),
    "ACMFORMATCHOOSEW": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fdwStyle", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pwfx", SimTypePointer(SimTypeRef("WAVEFORMATEX", SimStruct), offset=0)), ("cbwfx", SimTypeInt(signed=False, label="UInt32")), ("pszTitle", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("szFormatTag", SimTypeArray(SimTypeChar(label="Char"), 48)), ("szFormat", SimTypeArray(SimTypeChar(label="Char"), 128)), ("pszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cchName", SimTypeInt(signed=False, label="UInt32")), ("fdwEnum", SimTypeInt(signed=False, label="UInt32")), ("pwfxEnum", SimTypePointer(SimTypeRef("WAVEFORMATEX", SimStruct), offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pszTemplateName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0)),)), name="ACMFORMATCHOOSEW", pack=False, align=None),
    "ACMFORMATDETAILSA": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("dwFormatIndex", SimTypeInt(signed=False, label="UInt32")), ("dwFormatTag", SimTypeInt(signed=False, label="UInt32")), ("fdwSupport", SimTypeInt(signed=False, label="UInt32")), ("pwfx", SimTypePointer(SimTypeRef("WAVEFORMATEX", SimStruct), offset=0)), ("cbwfx", SimTypeInt(signed=False, label="UInt32")), ("szFormat", SimTypeArray(SimTypeChar(label="SByte"), 128)),)), name="ACMFORMATDETAILSA", pack=False, align=None),
    "ACMFORMATENUMCBA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("ACMFORMATDETAILSA", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "pafd", "dwInstance", "fdwSupport"]), offset=0),
    "ACMFORMATENUMCBW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("tACMFORMATDETAILSW", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "pafd", "dwInstance", "fdwSupport"]), offset=0),
    "ACMFORMATTAGDETAILSA": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("dwFormatTagIndex", SimTypeInt(signed=False, label="UInt32")), ("dwFormatTag", SimTypeInt(signed=False, label="UInt32")), ("cbFormatSize", SimTypeInt(signed=False, label="UInt32")), ("fdwSupport", SimTypeInt(signed=False, label="UInt32")), ("cStandardFormats", SimTypeInt(signed=False, label="UInt32")), ("szFormatTag", SimTypeArray(SimTypeChar(label="SByte"), 48)),)), name="ACMFORMATTAGDETAILSA", pack=False, align=None),
    "ACMFORMATTAGDETAILSW": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("dwFormatTagIndex", SimTypeInt(signed=False, label="UInt32")), ("dwFormatTag", SimTypeInt(signed=False, label="UInt32")), ("cbFormatSize", SimTypeInt(signed=False, label="UInt32")), ("fdwSupport", SimTypeInt(signed=False, label="UInt32")), ("cStandardFormats", SimTypeInt(signed=False, label="UInt32")), ("szFormatTag", SimTypeArray(SimTypeChar(label="Char"), 48)),)), name="ACMFORMATTAGDETAILSW", pack=False, align=None),
    "ACMFORMATTAGENUMCBA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("ACMFORMATTAGDETAILSA", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "paftd", "dwInstance", "fdwSupport"]), offset=0),
    "ACMFORMATTAGENUMCBW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("ACMFORMATTAGDETAILSW", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "paftd", "dwInstance", "fdwSupport"]), offset=0),
    "ACMSTREAMHEADER": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("fdwStatus", SimTypeInt(signed=False, label="UInt32")), ("dwUser", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("pbSrc", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbSrcLength", SimTypeInt(signed=False, label="UInt32")), ("cbSrcLengthUsed", SimTypeInt(signed=False, label="UInt32")), ("dwSrcUser", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("pbDst", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbDstLength", SimTypeInt(signed=False, label="UInt32")), ("cbDstLengthUsed", SimTypeInt(signed=False, label="UInt32")), ("dwDstUser", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("dwReservedDriver", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 10)),)), name="ACMSTREAMHEADER", pack=False, align=None),
    "ACPI_DEBUGGING_DEVICE_IN_USE": SimStruct(OrderedDict((("NameSpacePathLength", SimTypeInt(signed=False, label="UInt32")), ("NameSpacePath", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ACPI_DEBUGGING_DEVICE_IN_USE", pack=False, align=None),
    "ACPI_INTERFACE_STANDARD": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Context", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("InterfaceReference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("InterfaceDereference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("GpeConnectVector", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("DEVICE_OBJECT", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="KINTERRUPT_MODE"), SimTypeChar(label="Byte"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeChar(label="Byte"), arg_names=["param0", "param1"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6"]), offset=0)), ("GpeDisconnectVector", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0)), ("GpeEnableEvent", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("DEVICE_OBJECT", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0)), ("GpeDisableEvent", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("DEVICE_OBJECT", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0)), ("GpeClearStatus", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("DEVICE_OBJECT", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0)), ("RegisterForDeviceNotifications", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("DEVICE_OBJECT", SimStruct), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0)), ("UnregisterForDeviceNotifications", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("DEVICE_OBJECT", SimStruct), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)),)), name="ACPI_INTERFACE_STANDARD", pack=False, align=None),
    "ACPI_INTERFACE_STANDARD2": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Context", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("InterfaceReference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("InterfaceDereference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("GpeConnectVector", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="KINTERRUPT_MODE"), SimTypeChar(label="Byte"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeChar(label="Byte"), arg_names=["param0", "param1"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Context", "GpeNumber", "Mode", "Shareable", "ServiceRoutine", "ServiceContext", "ObjectContext"]), offset=0)), ("GpeDisconnectVector", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Context", "ObjectContext"]), offset=0)), ("GpeEnableEvent", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Context", "ObjectContext"]), offset=0)), ("GpeDisableEvent", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Context", "ObjectContext"]), offset=0)), ("GpeClearStatus", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Context", "ObjectContext"]), offset=0)), ("RegisterForDeviceNotifications", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["NotificationContext", "NotifyCode"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Context", "NotificationHandler", "NotificationContext"]), offset=0)), ("UnregisterForDeviceNotifications", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)),)), name="ACPI_INTERFACE_STANDARD2", pack=False, align=None),
    "ACPI_REAL_TIME": SimStruct(OrderedDict((("Year", SimTypeShort(signed=False, label="UInt16")), ("Month", SimTypeChar(label="Byte")), ("Day", SimTypeChar(label="Byte")), ("Hour", SimTypeChar(label="Byte")), ("Minute", SimTypeChar(label="Byte")), ("Second", SimTypeChar(label="Byte")), ("Valid", SimTypeChar(label="Byte")), ("Milliseconds", SimTypeShort(signed=False, label="UInt16")), ("TimeZone", SimTypeShort(signed=True, label="Int16")), ("DayLight", SimTypeChar(label="Byte")), ("Reserved1", SimTypeArray(SimTypeChar(label="Byte"), 3)),)), name="ACPI_REAL_TIME", pack=False, align=None),
    "ACPI_TIME_AND_ALARM_CAPABILITIES": SimStruct(OrderedDict((("AcWakeSupported", SimTypeChar(label="Byte")), ("DcWakeSupported", SimTypeChar(label="Byte")), ("S4AcWakeSupported", SimTypeChar(label="Byte")), ("S4DcWakeSupported", SimTypeChar(label="Byte")), ("S5AcWakeSupported", SimTypeChar(label="Byte")), ("S5DcWakeSupported", SimTypeChar(label="Byte")), ("S4S5WakeStatusSupported", SimTypeChar(label="Byte")), ("DeepestWakeSystemState", SimTypeInt(signed=False, label="UInt32")), ("RealTimeFeaturesSupported", SimTypeChar(label="Byte")), ("RealTimeResolution", SimTypeInt(signed=False, label="ACPI_TIME_RESOLUTION")),)), name="ACPI_TIME_AND_ALARM_CAPABILITIES", pack=False, align=None),
    "ACPI_TIME_RESOLUTION": SimTypeInt(signed=False, label="ACPI_TIME_RESOLUTION"),
    "ACQUIRE_CREDENTIALS_HANDLE_FN_A": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeRef("SecHandle", SimStruct), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7", "param8"]), offset=0),
    "ACQUIRE_CREDENTIALS_HANDLE_FN_W": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeRef("SecHandle", SimStruct), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7", "param8"]), offset=0),
    "ACTCTXA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("lpSource", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("wProcessorArchitecture", SimTypeShort(signed=False, label="UInt16")), ("wLangId", SimTypeShort(signed=False, label="UInt16")), ("lpAssemblyDirectory", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpResourceName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpApplicationName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("hModule", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="ACTCTXA", pack=False, align=None),
    "ACTCTXW": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("lpSource", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("wProcessorArchitecture", SimTypeShort(signed=False, label="UInt16")), ("wLangId", SimTypeShort(signed=False, label="UInt16")), ("lpAssemblyDirectory", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpResourceName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpApplicationName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("hModule", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="ACTCTXW", pack=False, align=None),
    "ACTCTX_COMPATIBILITY_ELEMENT_TYPE": SimTypeInt(signed=False, label="ACTCTX_COMPATIBILITY_ELEMENT_TYPE"),
    "ACTCTX_REQUESTED_RUN_LEVEL": SimTypeInt(signed=False, label="ACTCTX_REQUESTED_RUN_LEVEL"),
    "ACTCTX_SECTION_KEYED_DATA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("ulDataFormatVersion", SimTypeInt(signed=False, label="UInt32")), ("lpData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ulLength", SimTypeInt(signed=False, label="UInt32")), ("lpSectionGlobalData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ulSectionGlobalDataLength", SimTypeInt(signed=False, label="UInt32")), ("lpSectionBase", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ulSectionTotalLength", SimTypeInt(signed=False, label="UInt32")), ("hActCtx", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("ulAssemblyRosterIndex", SimTypeInt(signed=False, label="UInt32")), ("ulFlags", SimTypeInt(signed=False, label="UInt32")), ("AssemblyMetadata", SimTypeRef("ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA", SimStruct)),)), name="ACTCTX_SECTION_KEYED_DATA", pack=False, align=None),
    "ACTCTX_SECTION_KEYED_DATA_2600": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("ulDataFormatVersion", SimTypeInt(signed=False, label="UInt32")), ("lpData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ulLength", SimTypeInt(signed=False, label="UInt32")), ("lpSectionGlobalData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ulSectionGlobalDataLength", SimTypeInt(signed=False, label="UInt32")), ("lpSectionBase", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ulSectionTotalLength", SimTypeInt(signed=False, label="UInt32")), ("hActCtx", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("ulAssemblyRosterIndex", SimTypeInt(signed=False, label="UInt32")),)), name="ACTCTX_SECTION_KEYED_DATA_2600", pack=False, align=None),
    "ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA": SimStruct(OrderedDict((("lpInformation", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("lpSectionBase", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ulSectionLength", SimTypeInt(signed=False, label="UInt32")), ("lpSectionGlobalDataBase", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ulSectionGlobalDataLength", SimTypeInt(signed=False, label="UInt32")),)), name="ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA", pack=False, align=None),
    "ACTION_HEADER": SimStruct(OrderedDict((("transport_id", SimTypeInt(signed=False, label="UInt32")), ("action_code", SimTypeShort(signed=False, label="UInt16")), ("reserved", SimTypeShort(signed=False, label="UInt16")),)), name="ACTION_HEADER", pack=False, align=None),
    "ACTIVATEFLAGS": SimTypeInt(signed=False, label="ACTIVATEFLAGS"),
    "ACTIVATEOPTIONS": SimTypeInt(signed=False, label="ACTIVATEOPTIONS"),
    "ACTIVATE_KEYBOARD_LAYOUT_FLAGS": SimTypeInt(signed=False, label="ACTIVATE_KEYBOARD_LAYOUT_FLAGS"),
    "ACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION": SimStruct(OrderedDict((("ulFlags", SimTypeInt(signed=False, label="UInt32")), ("ulEncodedAssemblyIdentityLength", SimTypeInt(signed=False, label="UInt32")), ("ulManifestPathType", SimTypeInt(signed=False, label="UInt32")), ("ulManifestPathLength", SimTypeInt(signed=False, label="UInt32")), ("liManifestLastWriteTime", SimTypeLongLong(signed=True, label="Int64")), ("ulPolicyPathType", SimTypeInt(signed=False, label="UInt32")), ("ulPolicyPathLength", SimTypeInt(signed=False, label="UInt32")), ("liPolicyLastWriteTime", SimTypeLongLong(signed=True, label="Int64")), ("ulMetadataSatelliteRosterIndex", SimTypeInt(signed=False, label="UInt32")), ("ulManifestVersionMajor", SimTypeInt(signed=False, label="UInt32")), ("ulManifestVersionMinor", SimTypeInt(signed=False, label="UInt32")), ("ulPolicyVersionMajor", SimTypeInt(signed=False, label="UInt32")), ("ulPolicyVersionMinor", SimTypeInt(signed=False, label="UInt32")), ("ulAssemblyDirectoryNameLength", SimTypeInt(signed=False, label="UInt32")), ("lpAssemblyEncodedAssemblyIdentity", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpAssemblyManifestPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpAssemblyPolicyPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpAssemblyDirectoryName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ulFileCount", SimTypeInt(signed=False, label="UInt32")),)), name="ACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION", pack=False, align=None),
    "ACTIVATION_CONTEXT_BASIC_INFORMATION": SimStruct(OrderedDict((("hActCtx", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="ACTIVATION_CONTEXT_BASIC_INFORMATION", pack=False, align=None),
    "ACTIVATION_CONTEXT_COMPATIBILITY_INFORMATION": SimStruct(OrderedDict((("ElementCount", SimTypeInt(signed=False, label="UInt32")), ("Elements", SimTypePointer(SimTypeRef("COMPATIBILITY_CONTEXT_ELEMENT", SimStruct), offset=0)),)), name="ACTIVATION_CONTEXT_COMPATIBILITY_INFORMATION", pack=False, align=None),
    "ACTIVATION_CONTEXT_DETAILED_INFORMATION": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("ulFormatVersion", SimTypeInt(signed=False, label="UInt32")), ("ulAssemblyCount", SimTypeInt(signed=False, label="UInt32")), ("ulRootManifestPathType", SimTypeInt(signed=False, label="UInt32")), ("ulRootManifestPathChars", SimTypeInt(signed=False, label="UInt32")), ("ulRootConfigurationPathType", SimTypeInt(signed=False, label="UInt32")), ("ulRootConfigurationPathChars", SimTypeInt(signed=False, label="UInt32")), ("ulAppDirPathType", SimTypeInt(signed=False, label="UInt32")), ("ulAppDirPathChars", SimTypeInt(signed=False, label="UInt32")), ("lpRootManifestPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpRootConfigurationPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpAppDirPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ACTIVATION_CONTEXT_DETAILED_INFORMATION", pack=False, align=None),
    "ACTIVATION_CONTEXT_INFO_CLASS": SimTypeInt(signed=False, label="ACTIVATION_CONTEXT_INFO_CLASS"),
    "ACTIVATION_CONTEXT_QUERY_INDEX": SimStruct(OrderedDict((("ulAssemblyIndex", SimTypeInt(signed=False, label="UInt32")), ("ulFileIndexInAssembly", SimTypeInt(signed=False, label="UInt32")),)), name="ACTIVATION_CONTEXT_QUERY_INDEX", pack=False, align=None),
    "ACTIVATION_CONTEXT_RUN_LEVEL_INFORMATION": SimStruct(OrderedDict((("ulFlags", SimTypeInt(signed=False, label="UInt32")), ("RunLevel", SimTypeInt(signed=False, label="ACTCTX_REQUESTED_RUN_LEVEL")), ("UiAccess", SimTypeInt(signed=False, label="UInt32")),)), name="ACTIVATION_CONTEXT_RUN_LEVEL_INFORMATION", pack=False, align=None),
    "ACTIVEOBJECT_FLAGS": SimTypeInt(signed=False, label="ACTIVEOBJECT_FLAGS"),
    "ACTIVE_LATENCY_CONFIGURATION": SimStruct(OrderedDict((("Anonymous", SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUshort": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None")),)), name="ACTIVE_LATENCY_CONFIGURATION", pack=False, align=None),
    "ACTIVITY_STATE": SimTypeInt(signed=False, label="ACTIVITY_STATE"),
    "ACTIVITY_STATE_COUNT": SimTypeInt(signed=False, label="ACTIVITY_STATE_COUNT"),
    "ACTRL_ACCESSA": SimStruct(OrderedDict((("cEntries", SimTypeInt(signed=False, label="UInt32")), ("pPropertyAccessList", SimTypePointer(SimTypeRef("ACTRL_PROPERTY_ENTRYA", SimStruct), offset=0)),)), name="ACTRL_ACCESSA", pack=False, align=None),
    "ACTRL_ACCESSW": SimStruct(OrderedDict((("cEntries", SimTypeInt(signed=False, label="UInt32")), ("pPropertyAccessList", SimTypePointer(SimTypeRef("ACTRL_PROPERTY_ENTRYW", SimStruct), offset=0)),)), name="ACTRL_ACCESSW", pack=False, align=None),
    "ACTRL_ACCESS_ENTRYA": SimStruct(OrderedDict((("Trustee", SimTypeRef("TRUSTEE_A", SimStruct)), ("fAccessFlags", SimTypeInt(signed=False, label="ACTRL_ACCESS_ENTRY_ACCESS_FLAGS")), ("Access", SimTypeInt(signed=False, label="UInt32")), ("ProvSpecificAccess", SimTypeInt(signed=False, label="UInt32")), ("Inheritance", SimTypeInt(signed=False, label="ACE_FLAGS")), ("lpInheritProperty", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ACTRL_ACCESS_ENTRYA", pack=False, align=None),
    "ACTRL_ACCESS_ENTRYW": SimStruct(OrderedDict((("Trustee", SimTypeRef("TRUSTEE_W", SimStruct)), ("fAccessFlags", SimTypeInt(signed=False, label="ACTRL_ACCESS_ENTRY_ACCESS_FLAGS")), ("Access", SimTypeInt(signed=False, label="UInt32")), ("ProvSpecificAccess", SimTypeInt(signed=False, label="UInt32")), ("Inheritance", SimTypeInt(signed=False, label="ACE_FLAGS")), ("lpInheritProperty", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ACTRL_ACCESS_ENTRYW", pack=False, align=None),
    "ACTRL_ACCESS_ENTRY_ACCESS_FLAGS": SimTypeInt(signed=False, label="ACTRL_ACCESS_ENTRY_ACCESS_FLAGS"),
    "ACTRL_ACCESS_ENTRY_LISTA": SimStruct(OrderedDict((("cEntries", SimTypeInt(signed=False, label="UInt32")), ("pAccessList", SimTypePointer(SimTypeRef("ACTRL_ACCESS_ENTRYA", SimStruct), offset=0)),)), name="ACTRL_ACCESS_ENTRY_LISTA", pack=False, align=None),
    "ACTRL_ACCESS_ENTRY_LISTW": SimStruct(OrderedDict((("cEntries", SimTypeInt(signed=False, label="UInt32")), ("pAccessList", SimTypePointer(SimTypeRef("ACTRL_ACCESS_ENTRYW", SimStruct), offset=0)),)), name="ACTRL_ACCESS_ENTRY_LISTW", pack=False, align=None),
    "ACTRL_ACCESS_INFOA": SimStruct(OrderedDict((("fAccessPermission", SimTypeInt(signed=False, label="UInt32")), ("lpAccessPermissionName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ACTRL_ACCESS_INFOA", pack=False, align=None),
    "ACTRL_ACCESS_INFOW": SimStruct(OrderedDict((("fAccessPermission", SimTypeInt(signed=False, label="UInt32")), ("lpAccessPermissionName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ACTRL_ACCESS_INFOW", pack=False, align=None),
    "ACTRL_CONTROL_INFOA": SimStruct(OrderedDict((("lpControlId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpControlName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ACTRL_CONTROL_INFOA", pack=False, align=None),
    "ACTRL_CONTROL_INFOW": SimStruct(OrderedDict((("lpControlId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpControlName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ACTRL_CONTROL_INFOW", pack=False, align=None),
    "ACTRL_OVERLAPPED": SimStruct(OrderedDict((("Anonymous", SimUnion({"Provider": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved1": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("Reserved2", SimTypeInt(signed=False, label="UInt32")), ("hEvent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="ACTRL_OVERLAPPED", pack=False, align=None),
    "ACTRL_PROPERTY_ENTRYA": SimStruct(OrderedDict((("lpProperty", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pAccessEntryList", SimTypePointer(SimTypeRef("ACTRL_ACCESS_ENTRY_LISTA", SimStruct), offset=0)), ("fListFlags", SimTypeInt(signed=False, label="UInt32")),)), name="ACTRL_PROPERTY_ENTRYA", pack=False, align=None),
    "ACTRL_PROPERTY_ENTRYW": SimStruct(OrderedDict((("lpProperty", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pAccessEntryList", SimTypePointer(SimTypeRef("ACTRL_ACCESS_ENTRY_LISTW", SimStruct), offset=0)), ("fListFlags", SimTypeInt(signed=False, label="UInt32")),)), name="ACTRL_PROPERTY_ENTRYW", pack=False, align=None),
    "ACT_AUTHORIZATION_STATE": SimStruct(OrderedDict((("ulState", SimTypeInt(signed=False, label="UInt32")),)), name="ACT_AUTHORIZATION_STATE", pack=False, align=None),
    "ACT_AUTHORIZATION_STATE_VALUE": SimTypeInt(signed=False, label="ACT_AUTHORIZATION_STATE_VALUE"),
    "ADAPTER_STATUS": SimStruct(OrderedDict((("adapter_address", SimTypeArray(SimTypeChar(label="Byte"), 6)), ("rev_major", SimTypeChar(label="Byte")), ("reserved0", SimTypeChar(label="Byte")), ("adapter_type", SimTypeChar(label="Byte")), ("rev_minor", SimTypeChar(label="Byte")), ("duration", SimTypeShort(signed=False, label="UInt16")), ("frmr_recv", SimTypeShort(signed=False, label="UInt16")), ("frmr_xmit", SimTypeShort(signed=False, label="UInt16")), ("iframe_recv_err", SimTypeShort(signed=False, label="UInt16")), ("xmit_aborts", SimTypeShort(signed=False, label="UInt16")), ("xmit_success", SimTypeInt(signed=False, label="UInt32")), ("recv_success", SimTypeInt(signed=False, label="UInt32")), ("iframe_xmit_err", SimTypeShort(signed=False, label="UInt16")), ("recv_buff_unavail", SimTypeShort(signed=False, label="UInt16")), ("t1_timeouts", SimTypeShort(signed=False, label="UInt16")), ("ti_timeouts", SimTypeShort(signed=False, label="UInt16")), ("reserved1", SimTypeInt(signed=False, label="UInt32")), ("free_ncbs", SimTypeShort(signed=False, label="UInt16")), ("max_cfg_ncbs", SimTypeShort(signed=False, label="UInt16")), ("max_ncbs", SimTypeShort(signed=False, label="UInt16")), ("xmit_buf_unavail", SimTypeShort(signed=False, label="UInt16")), ("max_dgram_size", SimTypeShort(signed=False, label="UInt16")), ("pending_sess", SimTypeShort(signed=False, label="UInt16")), ("max_cfg_sess", SimTypeShort(signed=False, label="UInt16")), ("max_sess", SimTypeShort(signed=False, label="UInt16")), ("max_sess_pkt_size", SimTypeShort(signed=False, label="UInt16")), ("name_count", SimTypeShort(signed=False, label="UInt16")),)), name="ADAPTER_STATUS", pack=False, align=None),
    "ADDED_CERT_TYPE": SimTypeInt(signed=False, label="ADDED_CERT_TYPE"),
    "ADDJOB_INFO_1A": SimStruct(OrderedDict((("Path", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("JobId", SimTypeInt(signed=False, label="UInt32")),)), name="ADDJOB_INFO_1A", pack=False, align=None),
    "ADDJOB_INFO_1W": SimStruct(OrderedDict((("Path", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("JobId", SimTypeInt(signed=False, label="UInt32")),)), name="ADDJOB_INFO_1W", pack=False, align=None),
    "ADDRALIAS": SimStruct(OrderedDict((("rgchName", SimTypeArray(SimTypeChar(label="SByte"), 41)), ("rgchEName", SimTypeArray(SimTypeChar(label="SByte"), 11)), ("rgchSrvr", SimTypeArray(SimTypeChar(label="SByte"), 12)), ("dibDetail", SimTypeInt(signed=False, label="UInt32")), ("type", SimTypeShort(signed=False, label="UInt16")),)), name="ADDRALIAS", pack=False, align=None),
    "ADDRESS": SimStruct(OrderedDict((("Offset", SimTypeInt(signed=False, label="UInt32")), ("Segment", SimTypeShort(signed=False, label="UInt16")), ("Mode", SimTypeInt(signed=False, label="ADDRESS_MODE")),)), name="ADDRESS", pack=False, align=None),
    "ADDRESS64": SimStruct(OrderedDict((("Offset", SimTypeLongLong(signed=False, label="UInt64")), ("Segment", SimTypeShort(signed=False, label="UInt16")), ("Mode", SimTypeInt(signed=False, label="ADDRESS_MODE")),)), name="ADDRESS64", pack=False, align=None),
    "ADDRESS_CAPABILITY": SimTypeInt(signed=False, label="ADDRESS_CAPABILITY"),
    "ADDRESS_CAPABILITY_STRING": SimTypeInt(signed=False, label="ADDRESS_CAPABILITY_STRING"),
    "ADDRESS_EVENT": SimTypeInt(signed=False, label="ADDRESS_EVENT"),
    "ADDRESS_FAMILY": SimTypeInt(signed=False, label="ADDRESS_FAMILY"),
    "ADDRESS_LIST_DESCRIPTOR": SimStruct(OrderedDict((("MediaType", SimTypeInt(signed=False, label="UInt32")), ("AddressList", SimTypeRef("NETWORK_ADDRESS_LIST", SimStruct)),)), name="ADDRESS_LIST_DESCRIPTOR", pack=False, align=None),
    "ADDRESS_MODE": SimTypeInt(signed=False, label="ADDRESS_MODE"),
    "ADDRESS_STATE": SimTypeInt(signed=False, label="ADDRESS_STATE"),
    "ADDRINFOA": SimStruct(OrderedDict((("ai_flags", SimTypeInt(signed=True, label="Int32")), ("ai_family", SimTypeInt(signed=True, label="Int32")), ("ai_socktype", SimTypeInt(signed=True, label="Int32")), ("ai_protocol", SimTypeInt(signed=True, label="Int32")), ("ai_addrlen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_canonname", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("ai_addr", SimTypePointer(SimTypeRef("SOCKADDR", SimStruct), offset=0)), ("ai_next", SimTypePointer(SimTypeRef("ADDRINFOA", SimStruct), offset=0)),)), name="ADDRINFOA", pack=False, align=None),
    "ADDRINFOEX2A": SimStruct(OrderedDict((("ai_flags", SimTypeInt(signed=True, label="Int32")), ("ai_family", SimTypeInt(signed=True, label="Int32")), ("ai_socktype", SimTypeInt(signed=True, label="Int32")), ("ai_protocol", SimTypeInt(signed=True, label="Int32")), ("ai_addrlen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_canonname", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("ai_addr", SimTypePointer(SimTypeRef("SOCKADDR", SimStruct), offset=0)), ("ai_blob", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ai_bloblen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_provider", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)), ("ai_next", SimTypePointer(SimTypeRef("ADDRINFOEX2A", SimStruct), offset=0)), ("ai_version", SimTypeInt(signed=True, label="Int32")), ("ai_fqdn", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ADDRINFOEX2A", pack=False, align=None),
    "ADDRINFOEX2W": SimStruct(OrderedDict((("ai_flags", SimTypeInt(signed=True, label="Int32")), ("ai_family", SimTypeInt(signed=True, label="Int32")), ("ai_socktype", SimTypeInt(signed=True, label="Int32")), ("ai_protocol", SimTypeInt(signed=True, label="Int32")), ("ai_addrlen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_canonname", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ai_addr", SimTypePointer(SimTypeRef("SOCKADDR", SimStruct), offset=0)), ("ai_blob", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ai_bloblen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_provider", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)), ("ai_next", SimTypePointer(SimTypeRef("ADDRINFOEX2W", SimStruct), offset=0)), ("ai_version", SimTypeInt(signed=True, label="Int32")), ("ai_fqdn", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ADDRINFOEX2W", pack=False, align=None),
    "ADDRINFOEX3": SimStruct(OrderedDict((("ai_flags", SimTypeInt(signed=True, label="Int32")), ("ai_family", SimTypeInt(signed=True, label="Int32")), ("ai_socktype", SimTypeInt(signed=True, label="Int32")), ("ai_protocol", SimTypeInt(signed=True, label="Int32")), ("ai_addrlen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_canonname", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ai_addr", SimTypePointer(SimTypeRef("SOCKADDR", SimStruct), offset=0)), ("ai_blob", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ai_bloblen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_provider", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)), ("ai_next", SimTypePointer(SimTypeRef("ADDRINFOEX3", SimStruct), offset=0)), ("ai_version", SimTypeInt(signed=True, label="Int32")), ("ai_fqdn", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ai_interfaceindex", SimTypeInt(signed=True, label="Int32")),)), name="ADDRINFOEX3", pack=False, align=None),
    "ADDRINFOEX4": SimStruct(OrderedDict((("ai_flags", SimTypeInt(signed=True, label="Int32")), ("ai_family", SimTypeInt(signed=True, label="Int32")), ("ai_socktype", SimTypeInt(signed=True, label="Int32")), ("ai_protocol", SimTypeInt(signed=True, label="Int32")), ("ai_addrlen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_canonname", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ai_addr", SimTypePointer(SimTypeRef("SOCKADDR", SimStruct), offset=0)), ("ai_blob", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ai_bloblen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_provider", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)), ("ai_next", SimTypePointer(SimTypeRef("ADDRINFOEX4", SimStruct), offset=0)), ("ai_version", SimTypeInt(signed=True, label="Int32")), ("ai_fqdn", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ai_interfaceindex", SimTypeInt(signed=True, label="Int32")), ("ai_resolutionhandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="ADDRINFOEX4", pack=False, align=None),
    "ADDRINFOEX5": SimStruct(OrderedDict((("ai_flags", SimTypeInt(signed=True, label="Int32")), ("ai_family", SimTypeInt(signed=True, label="Int32")), ("ai_socktype", SimTypeInt(signed=True, label="Int32")), ("ai_protocol", SimTypeInt(signed=True, label="Int32")), ("ai_addrlen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_canonname", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ai_addr", SimTypePointer(SimTypeRef("SOCKADDR", SimStruct), offset=0)), ("ai_blob", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ai_bloblen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_provider", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)), ("ai_next", SimTypePointer(SimTypeRef("ADDRINFOEX5", SimStruct), offset=0)), ("ai_version", SimTypeInt(signed=True, label="Int32")), ("ai_fqdn", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ai_interfaceindex", SimTypeInt(signed=True, label="Int32")), ("ai_resolutionhandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("ai_ttl", SimTypeInt(signed=False, label="UInt32")),)), name="ADDRINFOEX5", pack=False, align=None),
    "ADDRINFOEX6": SimStruct(OrderedDict((("ai_flags", SimTypeInt(signed=True, label="Int32")), ("ai_family", SimTypeInt(signed=True, label="Int32")), ("ai_socktype", SimTypeInt(signed=True, label="Int32")), ("ai_protocol", SimTypeInt(signed=True, label="Int32")), ("ai_addrlen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_canonname", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ai_addr", SimTypePointer(SimTypeRef("SOCKADDR", SimStruct), offset=0)), ("ai_blob", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ai_bloblen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_provider", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)), ("ai_next", SimTypePointer(SimTypeRef("ADDRINFOEX5", SimStruct), offset=0)), ("ai_version", SimTypeInt(signed=True, label="Int32")), ("ai_fqdn", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ai_interfaceindex", SimTypeInt(signed=True, label="Int32")), ("ai_resolutionhandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("ai_ttl", SimTypeInt(signed=False, label="UInt32")), ("ai_numservers", SimTypeInt(signed=False, label="UInt32")), ("ai_servers", SimTypePointer(SimTypeRef("ADDRINFO_DNS_SERVER", SimStruct), offset=0)), ("ai_responseflags", SimTypeLongLong(signed=False, label="UInt64")),)), name="ADDRINFOEX6", pack=False, align=None),
    "ADDRINFOEXA": SimStruct(OrderedDict((("ai_flags", SimTypeInt(signed=True, label="Int32")), ("ai_family", SimTypeInt(signed=True, label="Int32")), ("ai_socktype", SimTypeInt(signed=True, label="Int32")), ("ai_protocol", SimTypeInt(signed=True, label="Int32")), ("ai_addrlen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_canonname", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("ai_addr", SimTypePointer(SimTypeRef("SOCKADDR", SimStruct), offset=0)), ("ai_blob", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ai_bloblen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_provider", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)), ("ai_next", SimTypePointer(SimTypeRef("ADDRINFOEXA", SimStruct), offset=0)),)), name="ADDRINFOEXA", pack=False, align=None),
    "ADDRINFOEXW": SimStruct(OrderedDict((("ai_flags", SimTypeInt(signed=True, label="Int32")), ("ai_family", SimTypeInt(signed=True, label="Int32")), ("ai_socktype", SimTypeInt(signed=True, label="Int32")), ("ai_protocol", SimTypeInt(signed=True, label="Int32")), ("ai_addrlen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_canonname", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ai_addr", SimTypePointer(SimTypeRef("SOCKADDR", SimStruct), offset=0)), ("ai_blob", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ai_bloblen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_provider", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)), ("ai_next", SimTypePointer(SimTypeRef("ADDRINFOEXW", SimStruct), offset=0)),)), name="ADDRINFOEXW", pack=False, align=None),
    "ADDRINFOW": SimStruct(OrderedDict((("ai_flags", SimTypeInt(signed=True, label="Int32")), ("ai_family", SimTypeInt(signed=True, label="Int32")), ("ai_socktype", SimTypeInt(signed=True, label="Int32")), ("ai_protocol", SimTypeInt(signed=True, label="Int32")), ("ai_addrlen", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ai_canonname", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ai_addr", SimTypePointer(SimTypeRef("SOCKADDR", SimStruct), offset=0)), ("ai_next", SimTypePointer(SimTypeRef("ADDRINFOW", SimStruct), offset=0)),)), name="ADDRINFOW", pack=False, align=None),
    "ADDRINFO_DNS_SERVER": SimStruct(OrderedDict((("ai_servertype", SimTypeInt(signed=False, label="UInt32")), ("ai_flags", SimTypeLongLong(signed=False, label="UInt64")), ("ai_addrlen", SimTypeInt(signed=False, label="UInt32")), ("ai_addr", SimTypePointer(SimTypeRef("SOCKADDR", SimStruct), offset=0)), ("Anonymous", SimUnion({"ai_template": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")),)), name="ADDRINFO_DNS_SERVER", pack=False, align=None),
    "ADDURL_FLAG": SimTypeInt(signed=False, label="ADDURL_FLAG"),
    "ADD_CREDENTIALS_FN_A": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("SecHandle", SimStruct), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7"]), offset=0),
    "ADD_CREDENTIALS_FN_W": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("SecHandle", SimStruct), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7"]), offset=0),
    "ADJACENT_DISPLAY_EDGES": SimTypeInt(signed=False, label="ADJACENT_DISPLAY_EDGES"),
    "ADMINISTRATOR_POWER_POLICY": SimStruct(OrderedDict((("MinSleep", SimTypeInt(signed=False, label="SYSTEM_POWER_STATE")), ("MaxSleep", SimTypeInt(signed=False, label="SYSTEM_POWER_STATE")), ("MinVideoTimeout", SimTypeInt(signed=False, label="UInt32")), ("MaxVideoTimeout", SimTypeInt(signed=False, label="UInt32")), ("MinSpindownTimeout", SimTypeInt(signed=False, label="UInt32")), ("MaxSpindownTimeout", SimTypeInt(signed=False, label="UInt32")),)), name="ADMINISTRATOR_POWER_POLICY", pack=False, align=None),
    "ADMIN_OTHER_INFO": SimStruct(OrderedDict((("alrtad_errcode", SimTypeInt(signed=False, label="UInt32")), ("alrtad_numstrings", SimTypeInt(signed=False, label="UInt32")),)), name="ADMIN_OTHER_INFO", pack=False, align=None),
    "ADPCMCOEFSET": SimStruct(OrderedDict((("iCoef1", SimTypeShort(signed=True, label="Int16")), ("iCoef2", SimTypeShort(signed=True, label="Int16")),)), name="ADPCMCOEFSET", pack=False, align=None),
    "ADPCMEWAVEFORMAT": SimStruct(OrderedDict((("wfx", SimTypeRef("WAVEFORMATEX", SimStruct)), ("wSamplesPerBlock", SimTypeShort(signed=False, label="UInt16")),)), name="ADPCMEWAVEFORMAT", pack=False, align=None),
    "ADPCMWAVEFORMAT": SimStruct(OrderedDict((("wfx", SimTypeRef("WAVEFORMATEX", SimStruct)), ("wSamplesPerBlock", SimTypeShort(signed=False, label="UInt16")), ("wNumCoef", SimTypeShort(signed=False, label="UInt16")), ("aCoef", SimTypePointer(SimTypeRef("ADPCMCOEFSET", SimStruct), offset=0)),)), name="ADPCMWAVEFORMAT", pack=False, align=None),
    "ADRENTRY": SimStruct(OrderedDict((("ulReserved1", SimTypeInt(signed=False, label="UInt32")), ("cValues", SimTypeInt(signed=False, label="UInt32")), ("rgPropVals", SimTypePointer(SimTypeRef("SPropValue", SimStruct), offset=0)),)), name="ADRENTRY", pack=False, align=None),
    "ADRLIST": SimStruct(OrderedDict((("cEntries", SimTypeInt(signed=False, label="UInt32")), ("aEntries", SimTypePointer(SimTypeRef("ADRENTRY", SimStruct), offset=0)),)), name="ADRLIST", pack=False, align=None),
    "ADRPARM": SimStruct(OrderedDict((("cbABContEntryID", SimTypeInt(signed=False, label="UInt32")), ("lpABContEntryID", SimTypePointer(SimTypeRef("ENTRYID", SimStruct), offset=0)), ("ulFlags", SimTypeInt(signed=False, label="UInt32")), ("lpReserved", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ulHelpContext", SimTypeInt(signed=False, label="UInt32")), ("lpszHelpFileName", SimTypePointer(SimTypeChar(label="SByte"), offset=0)), ("lpfnABSDI", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ulUIParam", "lpvmsg"]), offset=0)), ("lpfnDismiss", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["ulUIParam", "lpvContext"]), offset=0)), ("lpvDismissContext", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("lpszCaption", SimTypePointer(SimTypeChar(label="SByte"), offset=0)), ("lpszNewEntryTitle", SimTypePointer(SimTypeChar(label="SByte"), offset=0)), ("lpszDestWellsTitle", SimTypePointer(SimTypeChar(label="SByte"), offset=0)), ("cDestFields", SimTypeInt(signed=False, label="UInt32")), ("nDestFieldFocus", SimTypeInt(signed=False, label="UInt32")), ("lppszDestTitles", SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0)), ("lpulDestComps", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("lpContRestriction", SimTypePointer(SimTypeRef("SRestriction", SimStruct), offset=0)), ("lpHierRestriction", SimTypePointer(SimTypeRef("SRestriction", SimStruct), offset=0)),)), name="ADRPARM", pack=False, align=None),
    "ADSI_DIALECT_ENUM": SimTypeInt(signed=False, label="ADSI_DIALECT_ENUM"),
    "ADSPEC": SimStruct(OrderedDict((("adspec_header", SimTypeRef("RsvpObjHdr", SimStruct)), ("adspec_body", SimTypeRef("IS_ADSPEC_BODY", SimStruct)),)), name="ADSPEC", pack=False, align=None),
    "ADSPROPERROR": SimStruct(OrderedDict((("hwndPage", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pszPageTitle", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszObjPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszObjClass", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("hr", SimTypeInt(signed=True, label="Int32")), ("pszError", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ADSPROPERROR", pack=False, align=None),
    "ADSPROPINITPARAMS": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("hr", SimTypeInt(signed=True, label="Int32")), ("pDsObj", SimTypeBottom(label="IDirectoryObject")), ("pwzCN", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pWritableAttrs", SimTypePointer(SimTypeRef("ADS_ATTR_INFO", SimStruct), offset=0)),)), name="ADSPROPINITPARAMS", pack=False, align=None),
    "ADSTYPE": SimTypeInt(signed=False, label="ADSTYPE"),
    "ADSVALUE": SimStruct(OrderedDict((("dwType", SimTypeInt(signed=False, label="ADSTYPE")), ("Anonymous", SimUnion({"DNString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseExactString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseIgnoreString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "PrintableString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "NumericString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Boolean": SimTypeInt(signed=False, label="UInt32"), "Integer": SimTypeInt(signed=False, label="UInt32"), "OctetString": SimTypeRef("ADS_OCTET_STRING", SimStruct), "UTCTime": SimTypeRef("SYSTEMTIME", SimStruct), "LargeInteger": SimTypeLongLong(signed=True, label="Int64"), "ClassName": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "ProviderSpecific": SimTypeRef("ADS_PROV_SPECIFIC", SimStruct), "pCaseIgnoreList": SimTypePointer(SimTypeRef("ADS_CASEIGNORE_LIST", SimStruct), offset=0), "pOctetList": SimTypePointer(SimTypeRef("ADS_OCTET_LIST", SimStruct), offset=0), "pPath": SimTypePointer(SimTypeRef("ADS_PATH", SimStruct), offset=0), "pPostalAddress": SimTypePointer(SimTypeRef("ADS_POSTALADDRESS", SimStruct), offset=0), "Timestamp": SimTypeRef("ADS_TIMESTAMP", SimStruct), "BackLink": SimTypeRef("ADS_BACKLINK", SimStruct), "pTypedName": SimTypePointer(SimTypeRef("ADS_TYPEDNAME", SimStruct), offset=0), "Hold": SimTypeRef("ADS_HOLD", SimStruct), "pNetAddress": SimTypePointer(SimTypeRef("ADS_NETADDRESS", SimStruct), offset=0), "pReplicaPointer": SimTypePointer(SimTypeRef("ADS_REPLICAPOINTER", SimStruct), offset=0), "pFaxNumber": SimTypePointer(SimTypeRef("ADS_FAXNUMBER", SimStruct), offset=0), "Email": SimTypeRef("ADS_EMAIL", SimStruct), "SecurityDescriptor": SimTypeRef("ADS_NT_SECURITY_DESCRIPTOR", SimStruct), "pDNWithBinary": SimTypePointer(SimTypeRef("ADS_DN_WITH_BINARY", SimStruct), offset=0), "pDNWithString": SimTypePointer(SimTypeRef("ADS_DN_WITH_STRING", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="ADSVALUE", pack=False, align=None),
    "ADS_ACEFLAG_ENUM": SimTypeInt(signed=False, label="ADS_ACEFLAG_ENUM"),
    "ADS_ACETYPE_ENUM": SimTypeInt(signed=False, label="ADS_ACETYPE_ENUM"),
    "ADS_ATTR_DEF": SimStruct(OrderedDict((("pszAttrName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwADsType", SimTypeInt(signed=False, label="ADSTYPE")), ("dwMinRange", SimTypeInt(signed=False, label="UInt32")), ("dwMaxRange", SimTypeInt(signed=False, label="UInt32")), ("fMultiValued", SimTypeInt(signed=True, label="Int32")),)), name="ADS_ATTR_DEF", pack=False, align=None),
    "ADS_ATTR_INFO": SimStruct(OrderedDict((("pszAttrName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwControlCode", SimTypeInt(signed=False, label="UInt32")), ("dwADsType", SimTypeInt(signed=False, label="ADSTYPE")), ("pADsValues", SimTypePointer(SimTypeRef("ADSVALUE", SimStruct), offset=0)), ("dwNumValues", SimTypeInt(signed=False, label="UInt32")),)), name="ADS_ATTR_INFO", pack=False, align=None),
    "ADS_AUTHENTICATION_ENUM": SimTypeInt(signed=False, label="ADS_AUTHENTICATION_ENUM"),
    "ADS_BACKLINK": SimStruct(OrderedDict((("RemoteID", SimTypeInt(signed=False, label="UInt32")), ("ObjectName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ADS_BACKLINK", pack=False, align=None),
    "ADS_CASEIGNORE_LIST": SimStruct(OrderedDict((("Next", SimTypePointer(SimTypeRef("ADS_CASEIGNORE_LIST", SimStruct), offset=0)), ("String", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ADS_CASEIGNORE_LIST", pack=False, align=None),
    "ADS_CHASE_REFERRALS_ENUM": SimTypeInt(signed=False, label="ADS_CHASE_REFERRALS_ENUM"),
    "ADS_CLASS_DEF": SimStruct(OrderedDict((("pszClassName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwMandatoryAttrs", SimTypeInt(signed=False, label="UInt32")), ("ppszMandatoryAttrs", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)), ("optionalAttrs", SimTypeInt(signed=False, label="UInt32")), ("ppszOptionalAttrs", SimTypePointer(SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), offset=0)), ("dwNamingAttrs", SimTypeInt(signed=False, label="UInt32")), ("ppszNamingAttrs", SimTypePointer(SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), offset=0)), ("dwSuperClasses", SimTypeInt(signed=False, label="UInt32")), ("ppszSuperClasses", SimTypePointer(SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), offset=0)), ("fIsContainer", SimTypeInt(signed=True, label="Int32")),)), name="ADS_CLASS_DEF", pack=False, align=None),
    "ADS_DEREFENUM": SimTypeInt(signed=False, label="ADS_DEREFENUM"),
    "ADS_DISPLAY_ENUM": SimTypeInt(signed=False, label="ADS_DISPLAY_ENUM"),
    "ADS_DN_WITH_BINARY": SimStruct(OrderedDict((("dwLength", SimTypeInt(signed=False, label="UInt32")), ("lpBinaryValue", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pszDNString", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ADS_DN_WITH_BINARY", pack=False, align=None),
    "ADS_DN_WITH_STRING": SimStruct(OrderedDict((("pszStringValue", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszDNString", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ADS_DN_WITH_STRING", pack=False, align=None),
    "ADS_EMAIL": SimStruct(OrderedDict((("Address", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Type", SimTypeInt(signed=False, label="UInt32")),)), name="ADS_EMAIL", pack=False, align=None),
    "ADS_ESCAPE_MODE_ENUM": SimTypeInt(signed=False, label="ADS_ESCAPE_MODE_ENUM"),
    "ADS_FAXNUMBER": SimStruct(OrderedDict((("TelephoneNumber", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("NumberOfBits", SimTypeInt(signed=False, label="UInt32")), ("Parameters", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ADS_FAXNUMBER", pack=False, align=None),
    "ADS_FLAGTYPE_ENUM": SimTypeInt(signed=False, label="ADS_FLAGTYPE_ENUM"),
    "ADS_FORMAT_ENUM": SimTypeInt(signed=False, label="ADS_FORMAT_ENUM"),
    "ADS_GROUP_TYPE_ENUM": SimTypeInt(signed=False, label="ADS_GROUP_TYPE_ENUM"),
    "ADS_HOLD": SimStruct(OrderedDict((("ObjectName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Amount", SimTypeInt(signed=False, label="UInt32")),)), name="ADS_HOLD", pack=False, align=None),
    "ADS_NAME_INITTYPE_ENUM": SimTypeInt(signed=False, label="ADS_NAME_INITTYPE_ENUM"),
    "ADS_NAME_TYPE_ENUM": SimTypeInt(signed=False, label="ADS_NAME_TYPE_ENUM"),
    "ADS_NETADDRESS": SimStruct(OrderedDict((("AddressType", SimTypeInt(signed=False, label="UInt32")), ("AddressLength", SimTypeInt(signed=False, label="UInt32")), ("Address", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ADS_NETADDRESS", pack=False, align=None),
    "ADS_NT_SECURITY_DESCRIPTOR": SimStruct(OrderedDict((("dwLength", SimTypeInt(signed=False, label="UInt32")), ("lpValue", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ADS_NT_SECURITY_DESCRIPTOR", pack=False, align=None),
    "ADS_OBJECT_INFO": SimStruct(OrderedDict((("pszRDN", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszObjectDN", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszParentDN", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszSchemaDN", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszClassName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ADS_OBJECT_INFO", pack=False, align=None),
    "ADS_OCTET_LIST": SimStruct(OrderedDict((("Next", SimTypePointer(SimTypeRef("ADS_OCTET_LIST", SimStruct), offset=0)), ("Length", SimTypeInt(signed=False, label="UInt32")), ("Data", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ADS_OCTET_LIST", pack=False, align=None),
    "ADS_OCTET_STRING": SimStruct(OrderedDict((("dwLength", SimTypeInt(signed=False, label="UInt32")), ("lpValue", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ADS_OCTET_STRING", pack=False, align=None),
    "ADS_OPTION_ENUM": SimTypeInt(signed=False, label="ADS_OPTION_ENUM"),
    "ADS_PASSWORD_ENCODING_ENUM": SimTypeInt(signed=False, label="ADS_PASSWORD_ENCODING_ENUM"),
    "ADS_PATH": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="UInt32")), ("VolumeName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Path", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ADS_PATH", pack=False, align=None),
    "ADS_PATHTYPE_ENUM": SimTypeInt(signed=False, label="ADS_PATHTYPE_ENUM"),
    "ADS_POSTALADDRESS": SimStruct(OrderedDict((("PostalAddress", SimTypeArray(SimTypePointer(SimTypeChar(label="Char"), offset=0), 6)),)), name="ADS_POSTALADDRESS", pack=False, align=None),
    "ADS_PREFERENCES_ENUM": SimTypeInt(signed=False, label="ADS_PREFERENCES_ENUM"),
    "ADS_PROPERTY_OPERATION_ENUM": SimTypeInt(signed=False, label="ADS_PROPERTY_OPERATION_ENUM"),
    "ADS_PROV_SPECIFIC": SimStruct(OrderedDict((("dwLength", SimTypeInt(signed=False, label="UInt32")), ("lpValue", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ADS_PROV_SPECIFIC", pack=False, align=None),
    "ADS_REPLICAPOINTER": SimStruct(OrderedDict((("ServerName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ReplicaType", SimTypeInt(signed=False, label="UInt32")), ("ReplicaNumber", SimTypeInt(signed=False, label="UInt32")), ("Count", SimTypeInt(signed=False, label="UInt32")), ("ReplicaAddressHints", SimTypePointer(SimTypeRef("ADS_NETADDRESS", SimStruct), offset=0)),)), name="ADS_REPLICAPOINTER", pack=False, align=None),
    "ADS_RIGHTS_ENUM": SimTypeInt(signed=False, label="ADS_RIGHTS_ENUM"),
    "ADS_SCOPEENUM": SimTypeInt(signed=False, label="ADS_SCOPEENUM"),
    "ADS_SD_CONTROL_ENUM": SimTypeInt(signed=False, label="ADS_SD_CONTROL_ENUM"),
    "ADS_SD_FORMAT_ENUM": SimTypeInt(signed=False, label="ADS_SD_FORMAT_ENUM"),
    "ADS_SD_REVISION_ENUM": SimTypeInt(signed=False, label="ADS_SD_REVISION_ENUM"),
    "ADS_SEARCHPREF_ENUM": SimTypeInt(signed=False, label="ADS_SEARCHPREF_ENUM"),
    "ADS_SEARCHPREF_INFO": SimStruct(OrderedDict((("dwSearchPref", SimTypeInt(signed=False, label="ADS_SEARCHPREF_ENUM")), ("vValue", SimTypeRef("ADSVALUE", SimStruct)), ("dwStatus", SimTypeInt(signed=False, label="ADS_STATUSENUM")),)), name="ADS_SEARCHPREF_INFO", pack=False, align=None),
    "ADS_SEARCH_COLUMN": SimStruct(OrderedDict((("pszAttrName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwADsType", SimTypeInt(signed=False, label="ADSTYPE")), ("pADsValues", SimTypePointer(SimTypeRef("ADSVALUE", SimStruct), offset=0)), ("dwNumValues", SimTypeInt(signed=False, label="UInt32")), ("hReserved", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="ADS_SEARCH_COLUMN", pack=False, align=None),
    "ADS_SEARCH_HANDLE": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "ADS_SECURITY_INFO_ENUM": SimTypeInt(signed=False, label="ADS_SECURITY_INFO_ENUM"),
    "ADS_SETTYPE_ENUM": SimTypeInt(signed=False, label="ADS_SETTYPE_ENUM"),
    "ADS_SORTKEY": SimStruct(OrderedDict((("pszAttrType", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszReserved", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("fReverseorder", SimTypeChar(label="Byte")),)), name="ADS_SORTKEY", pack=False, align=None),
    "ADS_STATUSENUM": SimTypeInt(signed=False, label="ADS_STATUSENUM"),
    "ADS_SYSTEMFLAG_ENUM": SimTypeInt(signed=False, label="ADS_SYSTEMFLAG_ENUM"),
    "ADS_TIMESTAMP": SimStruct(OrderedDict((("WholeSeconds", SimTypeInt(signed=False, label="UInt32")), ("EventID", SimTypeInt(signed=False, label="UInt32")),)), name="ADS_TIMESTAMP", pack=False, align=None),
    "ADS_TYPEDNAME": SimStruct(OrderedDict((("ObjectName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Level", SimTypeInt(signed=False, label="UInt32")), ("Interval", SimTypeInt(signed=False, label="UInt32")),)), name="ADS_TYPEDNAME", pack=False, align=None),
    "ADS_USER_FLAG_ENUM": SimTypeInt(signed=False, label="ADS_USER_FLAG_ENUM"),
    "ADS_VLV": SimStruct(OrderedDict((("dwBeforeCount", SimTypeInt(signed=False, label="UInt32")), ("dwAfterCount", SimTypeInt(signed=False, label="UInt32")), ("dwOffset", SimTypeInt(signed=False, label="UInt32")), ("dwContentCount", SimTypeInt(signed=False, label="UInt32")), ("pszTarget", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwContextIDLength", SimTypeInt(signed=False, label="UInt32")), ("lpContextID", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ADS_VLV", pack=False, align=None),
    "ADVANCED_FEATURE_FLAGS": SimTypeInt(signed=False, label="ADVANCED_FEATURE_FLAGS"),
    "ADVERTISEFLAGS": SimTypeInt(signed=False, label="ADVERTISEFLAGS"),
    "ADVF": SimTypeInt(signed=False, label="ADVF"),
    "ADVISE_TYPE": SimTypeInt(signed=False, label="ADVISE_TYPE"),
    "AD_GENERAL_PARAMS": SimStruct(OrderedDict((("IntServAwareHopCount", SimTypeInt(signed=False, label="UInt32")), ("PathBandwidthEstimate", SimTypeInt(signed=False, label="UInt32")), ("MinimumLatency", SimTypeInt(signed=False, label="UInt32")), ("PathMTU", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")),)), name="AD_GENERAL_PARAMS", pack=False, align=None),
    "AD_GUARANTEED": SimStruct(OrderedDict((("CTotal", SimTypeInt(signed=False, label="UInt32")), ("DTotal", SimTypeInt(signed=False, label="UInt32")), ("CSum", SimTypeInt(signed=False, label="UInt32")), ("DSum", SimTypeInt(signed=False, label="UInt32")),)), name="AD_GUARANTEED", pack=False, align=None),
    "AEC_INPUT_STREAM": SimTypeInt(signed=False, label="AEC_INPUT_STREAM"),
    "AEC_SYSTEM_MODE": SimTypeInt(signed=False, label="AEC_SYSTEM_MODE"),
    "AEC_VAD_MODE": SimTypeInt(signed=False, label="AEC_VAD_MODE"),
    "AEROWIZARDPARTS": SimTypeInt(signed=False, label="AEROWIZARDPARTS"),
    "AER_BRIDGE_DESCRIPTOR_FLAGS": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUSHORT": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"),
    "AER_ENDPOINT_DESCRIPTOR_FLAGS": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUSHORT": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"),
    "AER_ROOTPORT_DESCRIPTOR_FLAGS": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUSHORT": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"),
    "AE_ACCLIM": SimStruct(OrderedDict((("ae_al_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_al_username", SimTypeInt(signed=False, label="UInt32")), ("ae_al_resname", SimTypeInt(signed=False, label="UInt32")), ("ae_al_limit", SimTypeInt(signed=False, label="UInt32")),)), name="AE_ACCLIM", pack=False, align=None),
    "AE_ACLMOD": SimStruct(OrderedDict((("ae_am_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_am_username", SimTypeInt(signed=False, label="UInt32")), ("ae_am_resname", SimTypeInt(signed=False, label="UInt32")), ("ae_am_action", SimTypeInt(signed=False, label="UInt32")), ("ae_am_datalen", SimTypeInt(signed=False, label="UInt32")),)), name="AE_ACLMOD", pack=False, align=None),
    "AE_CLOSEFILE": SimStruct(OrderedDict((("ae_cf_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_cf_username", SimTypeInt(signed=False, label="UInt32")), ("ae_cf_resname", SimTypeInt(signed=False, label="UInt32")), ("ae_cf_fileid", SimTypeInt(signed=False, label="UInt32")), ("ae_cf_duration", SimTypeInt(signed=False, label="UInt32")), ("ae_cf_reason", SimTypeInt(signed=False, label="UInt32")),)), name="AE_CLOSEFILE", pack=False, align=None),
    "AE_CONNREJ": SimStruct(OrderedDict((("ae_cr_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_cr_username", SimTypeInt(signed=False, label="UInt32")), ("ae_cr_netname", SimTypeInt(signed=False, label="UInt32")), ("ae_cr_reason", SimTypeInt(signed=False, label="UInt32")),)), name="AE_CONNREJ", pack=False, align=None),
    "AE_CONNSTART": SimStruct(OrderedDict((("ae_ct_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_ct_username", SimTypeInt(signed=False, label="UInt32")), ("ae_ct_netname", SimTypeInt(signed=False, label="UInt32")), ("ae_ct_connid", SimTypeInt(signed=False, label="UInt32")),)), name="AE_CONNSTART", pack=False, align=None),
    "AE_CONNSTOP": SimStruct(OrderedDict((("ae_cp_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_cp_username", SimTypeInt(signed=False, label="UInt32")), ("ae_cp_netname", SimTypeInt(signed=False, label="UInt32")), ("ae_cp_connid", SimTypeInt(signed=False, label="UInt32")), ("ae_cp_reason", SimTypeInt(signed=False, label="UInt32")),)), name="AE_CONNSTOP", pack=False, align=None),
    "AE_CURRENT_POSITION": SimStruct(OrderedDict((("u64DevicePosition", SimTypeLongLong(signed=False, label="UInt64")), ("u64StreamPosition", SimTypeLongLong(signed=False, label="UInt64")), ("u64PaddingFrames", SimTypeLongLong(signed=False, label="UInt64")), ("hnsQPCPosition", SimTypeLongLong(signed=True, label="Int64")), ("f32FramesPerSecond", SimTypeFloat(size=32)), ("Flag", SimTypeInt(signed=False, label="AE_POSITION_FLAGS")),)), name="AE_CURRENT_POSITION", pack=False, align=None),
    "AE_GENERIC": SimStruct(OrderedDict((("ae_ge_msgfile", SimTypeInt(signed=False, label="UInt32")), ("ae_ge_msgnum", SimTypeInt(signed=False, label="UInt32")), ("ae_ge_params", SimTypeInt(signed=False, label="UInt32")), ("ae_ge_param1", SimTypeInt(signed=False, label="UInt32")), ("ae_ge_param2", SimTypeInt(signed=False, label="UInt32")), ("ae_ge_param3", SimTypeInt(signed=False, label="UInt32")), ("ae_ge_param4", SimTypeInt(signed=False, label="UInt32")), ("ae_ge_param5", SimTypeInt(signed=False, label="UInt32")), ("ae_ge_param6", SimTypeInt(signed=False, label="UInt32")), ("ae_ge_param7", SimTypeInt(signed=False, label="UInt32")), ("ae_ge_param8", SimTypeInt(signed=False, label="UInt32")), ("ae_ge_param9", SimTypeInt(signed=False, label="UInt32")),)), name="AE_GENERIC", pack=False, align=None),
    "AE_LOCKOUT": SimStruct(OrderedDict((("ae_lk_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_lk_username", SimTypeInt(signed=False, label="UInt32")), ("ae_lk_action", SimTypeInt(signed=False, label="UInt32")), ("ae_lk_bad_pw_count", SimTypeInt(signed=False, label="UInt32")),)), name="AE_LOCKOUT", pack=False, align=None),
    "AE_NETLOGOFF": SimStruct(OrderedDict((("ae_nf_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_nf_username", SimTypeInt(signed=False, label="UInt32")), ("ae_nf_reserved1", SimTypeInt(signed=False, label="UInt32")), ("ae_nf_reserved2", SimTypeInt(signed=False, label="UInt32")),)), name="AE_NETLOGOFF", pack=False, align=None),
    "AE_NETLOGON": SimStruct(OrderedDict((("ae_no_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_no_username", SimTypeInt(signed=False, label="UInt32")), ("ae_no_privilege", SimTypeInt(signed=False, label="UInt32")), ("ae_no_authflags", SimTypeInt(signed=False, label="UInt32")),)), name="AE_NETLOGON", pack=False, align=None),
    "AE_POSITION_FLAGS": SimTypeInt(signed=False, label="AE_POSITION_FLAGS"),
    "AE_RESACCESS": SimStruct(OrderedDict((("ae_ra_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_ra_username", SimTypeInt(signed=False, label="UInt32")), ("ae_ra_resname", SimTypeInt(signed=False, label="UInt32")), ("ae_ra_operation", SimTypeInt(signed=False, label="UInt32")), ("ae_ra_returncode", SimTypeInt(signed=False, label="UInt32")), ("ae_ra_restype", SimTypeInt(signed=False, label="UInt32")), ("ae_ra_fileid", SimTypeInt(signed=False, label="UInt32")),)), name="AE_RESACCESS", pack=False, align=None),
    "AE_RESACCESSREJ": SimStruct(OrderedDict((("ae_rr_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_rr_username", SimTypeInt(signed=False, label="UInt32")), ("ae_rr_resname", SimTypeInt(signed=False, label="UInt32")), ("ae_rr_operation", SimTypeInt(signed=False, label="UInt32")),)), name="AE_RESACCESSREJ", pack=False, align=None),
    "AE_SERVICESTAT": SimStruct(OrderedDict((("ae_ss_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_ss_username", SimTypeInt(signed=False, label="UInt32")), ("ae_ss_svcname", SimTypeInt(signed=False, label="UInt32")), ("ae_ss_status", SimTypeInt(signed=False, label="UInt32")), ("ae_ss_code", SimTypeInt(signed=False, label="UInt32")), ("ae_ss_text", SimTypeInt(signed=False, label="UInt32")), ("ae_ss_returnval", SimTypeInt(signed=False, label="UInt32")),)), name="AE_SERVICESTAT", pack=False, align=None),
    "AE_SESSLOGOFF": SimStruct(OrderedDict((("ae_sf_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_sf_username", SimTypeInt(signed=False, label="UInt32")), ("ae_sf_reason", SimTypeInt(signed=False, label="UInt32")),)), name="AE_SESSLOGOFF", pack=False, align=None),
    "AE_SESSLOGON": SimStruct(OrderedDict((("ae_so_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_so_username", SimTypeInt(signed=False, label="UInt32")), ("ae_so_privilege", SimTypeInt(signed=False, label="UInt32")),)), name="AE_SESSLOGON", pack=False, align=None),
    "AE_SESSPWERR": SimStruct(OrderedDict((("ae_sp_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_sp_username", SimTypeInt(signed=False, label="UInt32")),)), name="AE_SESSPWERR", pack=False, align=None),
    "AE_SRVSTATUS": SimStruct(OrderedDict((("ae_sv_status", SimTypeInt(signed=False, label="UInt32")),)), name="AE_SRVSTATUS", pack=False, align=None),
    "AE_UASMOD": SimStruct(OrderedDict((("ae_um_compname", SimTypeInt(signed=False, label="UInt32")), ("ae_um_username", SimTypeInt(signed=False, label="UInt32")), ("ae_um_resname", SimTypeInt(signed=False, label="UInt32")), ("ae_um_rectype", SimTypeInt(signed=False, label="UInt32")), ("ae_um_action", SimTypeInt(signed=False, label="UInt32")), ("ae_um_datalen", SimTypeInt(signed=False, label="UInt32")),)), name="AE_UASMOD", pack=False, align=None),
    "AFPROTOCOLS": SimStruct(OrderedDict((("iAddressFamily", SimTypeInt(signed=True, label="Int32")), ("iProtocol", SimTypeInt(signed=True, label="Int32")),)), name="AFPROTOCOLS", pack=False, align=None),
    "AF_OP": SimTypeInt(signed=False, label="AF_OP"),
    "AGENTHANDLER_EVENT": SimTypeInt(signed=False, label="AGENTHANDLER_EVENT"),
    "AGENT_EVENT": SimTypeInt(signed=False, label="AGENT_EVENT"),
    "AGENT_SESSION_EVENT": SimTypeInt(signed=False, label="AGENT_SESSION_EVENT"),
    "AGENT_SESSION_STATE": SimTypeInt(signed=False, label="AGENT_SESSION_STATE"),
    "AGENT_STATE": SimTypeInt(signed=False, label="AGENT_STATE"),
    "AGP_TARGET_BUS_INTERFACE_STANDARD": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Context", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("InterfaceReference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("InterfaceDereference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("SetBusData", SimTypePointer(SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")), offset=0)), ("GetBusData", SimTypePointer(SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")), offset=0)), ("CapabilityID", SimTypeChar(label="Byte")),)), name="AGP_TARGET_BUS_INTERFACE_STANDARD", pack=False, align=None),
    "AHE_TYPE": SimTypeInt(signed=False, label="AHE_TYPE"),
    "AHTYPE": SimTypeInt(signed=False, label="AHTYPE"),
    "ALERT_SYSTEM_SEV": SimTypeInt(signed=False, label="ALERT_SYSTEM_SEV"),
    "ALG_ID": SimTypeInt(signed=False, label="ALG_ID"),
    "ALLOCATE_FUNCTION": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="POOL_TYPE"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["PoolType", "NumberOfBytes", "Tag"]), offset=0),
    "ALLOCATE_VIRTUAL_MEMORY_EX_CALLBACK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("MEM_EXTENDED_PARAMETER", SimStruct), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["CallbackContext", "ProcessHandle", "BaseAddress", "RegionSize", "AllocationType", "PageProtection", "ExtendedParameters", "ExtendedParameterCount"]), offset=0),
    "ALLOCATOR_PROPERTIES": SimStruct(OrderedDict((("cBuffers", SimTypeInt(signed=True, label="Int32")), ("cbBuffer", SimTypeInt(signed=True, label="Int32")), ("cbAlign", SimTypeInt(signed=True, label="Int32")), ("cbPrefix", SimTypeInt(signed=True, label="Int32")),)), name="ALLOCATOR_PROPERTIES", pack=False, align=None),
    "ALLOCATOR_PROPERTIES_EX": SimStruct(OrderedDict((("cBuffers", SimTypeInt(signed=True, label="Int32")), ("cbBuffer", SimTypeInt(signed=True, label="Int32")), ("cbAlign", SimTypeInt(signed=True, label="Int32")), ("cbPrefix", SimTypeInt(signed=True, label="Int32")), ("MemoryType", SimTypeBottom(label="Guid")), ("BusType", SimTypeBottom(label="Guid")), ("State", SimTypeInt(signed=False, label="PIPE_STATE")), ("Input", SimTypeRef("PIPE_TERMINATION", SimStruct)), ("Output", SimTypeRef("PIPE_TERMINATION", SimStruct)), ("Strategy", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("Weight", SimTypeInt(signed=False, label="UInt32")), ("LogicalMemoryType", SimTypeInt(signed=False, label="KS_LogicalMemoryType")), ("AllocatorPlace", SimTypeInt(signed=False, label="PIPE_ALLOCATOR_PLACE")), ("Dimensions", SimTypeRef("PIPE_DIMENSIONS", SimStruct)), ("PhysicalRange", SimTypeRef("KS_FRAMING_RANGE", SimStruct)), ("PrevSegment", SimTypeBottom(label="IKsAllocatorEx")), ("CountNextSegments", SimTypeInt(signed=False, label="UInt32")), ("NextSegments", SimTypePointer(SimTypeBottom(label="IKsAllocatorEx"), offset=0)), ("InsideFactors", SimTypeInt(signed=False, label="UInt32")), ("NumberPins", SimTypeInt(signed=False, label="UInt32")),)), name="ALLOCATOR_PROPERTIES_EX", pack=False, align=None),
    "ALTERNATE_INTERFACE": SimStruct(OrderedDict((("InterfaceNumber", SimTypeShort(signed=False, label="UInt16")), ("AlternateInterfaceNumber", SimTypeShort(signed=False, label="UInt16")),)), name="ALTERNATE_INTERFACE", pack=False, align=None),
    "ALTERNATIVE_ARCHITECTURE_TYPE": SimTypeInt(signed=False, label="ALTERNATIVE_ARCHITECTURE_TYPE"),
    "ALTTABINFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("cItems", SimTypeInt(signed=True, label="Int32")), ("cColumns", SimTypeInt(signed=True, label="Int32")), ("cRows", SimTypeInt(signed=True, label="Int32")), ("iColFocus", SimTypeInt(signed=True, label="Int32")), ("iRowFocus", SimTypeInt(signed=True, label="Int32")), ("cxItem", SimTypeInt(signed=True, label="Int32")), ("cyItem", SimTypeInt(signed=True, label="Int32")), ("ptStart", SimTypeRef("POINT", SimStruct)),)), name="ALTTABINFO", pack=False, align=None),
    "ALT_BREAKS": SimTypeInt(signed=False, label="ALT_BREAKS"),
    "AMBISONICS_CHANNEL_ORDERING": SimTypeInt(signed=False, label="AMBISONICS_CHANNEL_ORDERING"),
    "AMBISONICS_NORMALIZATION": SimTypeInt(signed=False, label="AMBISONICS_NORMALIZATION"),
    "AMBISONICS_PARAMS": SimStruct(OrderedDict((("u32Size", SimTypeInt(signed=False, label="UInt32")), ("u32Version", SimTypeInt(signed=False, label="UInt32")), ("u32Type", SimTypeInt(signed=False, label="AMBISONICS_TYPE")), ("u32ChannelOrdering", SimTypeInt(signed=False, label="AMBISONICS_CHANNEL_ORDERING")), ("u32Normalization", SimTypeInt(signed=False, label="AMBISONICS_NORMALIZATION")), ("u32Order", SimTypeInt(signed=False, label="UInt32")), ("u32NumChannels", SimTypeInt(signed=False, label="UInt32")), ("pu32ChannelMap", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="AMBISONICS_PARAMS", pack=False, align=None),
    "AMBISONICS_TYPE": SimTypeInt(signed=False, label="AMBISONICS_TYPE"),
    "AMCOPPCommand": SimStruct(OrderedDict((("macKDI", SimTypeBottom(label="Guid")), ("guidCommandID", SimTypeBottom(label="Guid")), ("dwSequence", SimTypeInt(signed=False, label="UInt32")), ("cbSizeData", SimTypeInt(signed=False, label="UInt32")), ("CommandData", SimTypeArray(SimTypeChar(label="Byte"), 4056)),)), name="AMCOPPCommand", pack=False, align=None),
    "AMCOPPSignature": SimStruct(OrderedDict((("Signature", SimTypeArray(SimTypeChar(label="Byte"), 256)),)), name="AMCOPPSignature", pack=False, align=None),
    "AMCOPPStatusInput": SimStruct(OrderedDict((("rApp", SimTypeBottom(label="Guid")), ("guidStatusRequestID", SimTypeBottom(label="Guid")), ("dwSequence", SimTypeInt(signed=False, label="UInt32")), ("cbSizeData", SimTypeInt(signed=False, label="UInt32")), ("StatusData", SimTypeArray(SimTypeChar(label="Byte"), 4056)),)), name="AMCOPPStatusInput", pack=False, align=None),
    "AMCOPPStatusOutput": SimStruct(OrderedDict((("macKDI", SimTypeBottom(label="Guid")), ("cbSizeData", SimTypeInt(signed=False, label="UInt32")), ("COPPStatus", SimTypeArray(SimTypeChar(label="Byte"), 4076)),)), name="AMCOPPStatusOutput", pack=False, align=None),
    "AMD_L1_CACHE_INFO": SimUnion({"Ulong": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct(OrderedDict((("LineSize", SimTypeChar(label="Byte")), ("LinesPerTag", SimTypeChar(label="Byte")), ("Associativity", SimTypeChar(label="Byte")), ("Size", SimTypeChar(label="Byte")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"),
    "AMD_L2_CACHE_INFO": SimUnion({"Ulong": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct(OrderedDict((("LineSize", SimTypeChar(label="Byte")), ("_bitfield", SimTypeChar(label="Byte")), ("Size", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"),
    "AMD_L3_CACHE_INFO": SimUnion({"Ulong": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct(OrderedDict((("LineSize", SimTypeChar(label="Byte")), ("_bitfield1", SimTypeChar(label="Byte")), ("_bitfield2", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"),
    "AMExtendedSeekingCapabilities": SimTypeInt(signed=False, label="AMExtendedSeekingCapabilities"),
    "AMGETERRORTEXTPROCA": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0),
    "AMGETERRORTEXTPROCW": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0),
    "AMMSF_MMS_INIT_FLAGS": SimTypeInt(signed=False, label="AMMSF_MMS_INIT_FLAGS"),
    "AMMSF_MS_FLAGS": SimTypeInt(signed=False, label="AMMSF_MS_FLAGS"),
    "AMMSF_RENDER_FLAGS": SimTypeInt(signed=False, label="AMMSF_RENDER_FLAGS"),
    "AMOVERLAYFX": SimTypeInt(signed=False, label="AMOVERLAYFX"),
    "AMPROPERTY_PIN": SimTypeInt(signed=False, label="AMPROPERTY_PIN"),
    "AMPlayListEventFlags": SimTypeInt(signed=False, label="AMPlayListEventFlags"),
    "AMPlayListFlags": SimTypeInt(signed=False, label="AMPlayListFlags"),
    "AMPlayListItemFlags": SimTypeInt(signed=False, label="AMPlayListItemFlags"),
    "AMSI_ATTRIBUTE": SimTypeInt(signed=False, label="AMSI_ATTRIBUTE"),
    "AMSI_RESULT": SimTypeInt(signed=False, label="AMSI_RESULT"),
    "AMSI_UAC_MSI_ACTION": SimTypeInt(signed=False, label="AMSI_UAC_MSI_ACTION"),
    "AMSI_UAC_REQUEST_AX_INFO": SimStruct(OrderedDict((("ulLength", SimTypeInt(signed=False, label="UInt32")), ("lpwszLocalInstallPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpwszSourceURL", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="AMSI_UAC_REQUEST_AX_INFO", pack=False, align=None),
    "AMSI_UAC_REQUEST_COM_INFO": SimStruct(OrderedDict((("ulLength", SimTypeInt(signed=False, label="UInt32")), ("lpwszServerBinary", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpwszRequestor", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Clsid", SimTypeBottom(label="Guid")),)), name="AMSI_UAC_REQUEST_COM_INFO", pack=False, align=None),
    "AMSI_UAC_REQUEST_CONTEXT": SimStruct(OrderedDict((("ulLength", SimTypeInt(signed=False, label="UInt32")), ("ulRequestorProcessId", SimTypeInt(signed=False, label="UInt32")), ("UACTrustState", SimTypeInt(signed=False, label="AMSI_UAC_TRUST_STATE")), ("Type", SimTypeInt(signed=False, label="AMSI_UAC_REQUEST_TYPE")), ("RequestType", SimUnion({"ExeInfo": SimTypeRef("AMSI_UAC_REQUEST_EXE_INFO", SimStruct), "ComInfo": SimTypeRef("AMSI_UAC_REQUEST_COM_INFO", SimStruct), "MsiInfo": SimTypeRef("AMSI_UAC_REQUEST_MSI_INFO", SimStruct), "ActiveXInfo": SimTypeRef("AMSI_UAC_REQUEST_AX_INFO", SimStruct), "PackagedAppInfo": SimTypeRef("AMSI_UAC_REQUEST_PACKAGED_APP_INFO", SimStruct)}, name="<anon>", label="None")), ("bAutoElevateRequest", SimTypeInt(signed=True, label="Int32")),)), name="AMSI_UAC_REQUEST_CONTEXT", pack=False, align=None),
    "AMSI_UAC_REQUEST_EXE_INFO": SimStruct(OrderedDict((("ulLength", SimTypeInt(signed=False, label="UInt32")), ("lpwszApplicationName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpwszCommandLine", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpwszDLLParameter", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="AMSI_UAC_REQUEST_EXE_INFO", pack=False, align=None),
    "AMSI_UAC_REQUEST_MSI_INFO": SimStruct(OrderedDict((("ulLength", SimTypeInt(signed=False, label="UInt32")), ("MsiAction", SimTypeInt(signed=False, label="AMSI_UAC_MSI_ACTION")), ("lpwszProductName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpwszVersion", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpwszLanguage", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpwszManufacturer", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpwszPackagePath", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpwszPackageSource", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ulUpdates", SimTypeInt(signed=False, label="UInt32")), ("ppwszUpdates", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)), ("ppwszUpdateSources", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="AMSI_UAC_REQUEST_MSI_INFO", pack=False, align=None),
    "AMSI_UAC_REQUEST_PACKAGED_APP_INFO": SimStruct(OrderedDict((("ulLength", SimTypeInt(signed=False, label="UInt32")), ("lpwszApplicationName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpwszCommandLine", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpPackageFamilyName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpApplicationId", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="AMSI_UAC_REQUEST_PACKAGED_APP_INFO", pack=False, align=None),
    "AMSI_UAC_REQUEST_TYPE": SimTypeInt(signed=False, label="AMSI_UAC_REQUEST_TYPE"),
    "AMSI_UAC_TRUST_STATE": SimTypeInt(signed=False, label="AMSI_UAC_TRUST_STATE"),
    "AMTVAudioEventType": SimTypeInt(signed=False, label="AMTVAudioEventType"),
    "AMTunerEventType": SimTypeInt(signed=False, label="AMTunerEventType"),
    "AMTunerModeType": SimTypeInt(signed=False, label="AMTunerModeType"),
    "AMTunerSignalStrength": SimTypeInt(signed=False, label="AMTunerSignalStrength"),
    "AMTunerSubChannel": SimTypeInt(signed=False, label="AMTunerSubChannel"),
    "AMVABUFFERINFO": SimStruct(OrderedDict((("dwTypeIndex", SimTypeInt(signed=False, label="UInt32")), ("dwBufferIndex", SimTypeInt(signed=False, label="UInt32")), ("dwDataOffset", SimTypeInt(signed=False, label="UInt32")), ("dwDataSize", SimTypeInt(signed=False, label="UInt32")),)), name="AMVABUFFERINFO", pack=False, align=None),
    "AMVABeginFrameInfo": SimStruct(OrderedDict((("dwDestSurfaceIndex", SimTypeInt(signed=False, label="UInt32")), ("pInputData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("dwSizeInputData", SimTypeInt(signed=False, label="UInt32")), ("pOutputData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("dwSizeOutputData", SimTypeInt(signed=False, label="UInt32")),)), name="AMVABeginFrameInfo", pack=False, align=None),
    "AMVACompBufferInfo": SimStruct(OrderedDict((("dwNumCompBuffers", SimTypeInt(signed=False, label="UInt32")), ("dwWidthToCreate", SimTypeInt(signed=False, label="UInt32")), ("dwHeightToCreate", SimTypeInt(signed=False, label="UInt32")), ("dwBytesToAllocate", SimTypeInt(signed=False, label="UInt32")), ("ddCompCaps", SimTypeRef("DDSCAPS2", SimStruct)), ("ddPixelFormat", SimTypeRef("DDPIXELFORMAT", SimStruct)),)), name="AMVACompBufferInfo", pack=False, align=None),
    "AMVAEndFrameInfo": SimStruct(OrderedDict((("dwSizeMiscData", SimTypeInt(signed=False, label="UInt32")), ("pMiscData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="AMVAEndFrameInfo", pack=False, align=None),
    "AMVAInternalMemInfo": SimStruct(OrderedDict((("dwScratchMemAlloc", SimTypeInt(signed=False, label="UInt32")),)), name="AMVAInternalMemInfo", pack=False, align=None),
    "AMVAUncompBufferInfo": SimStruct(OrderedDict((("dwMinNumSurfaces", SimTypeInt(signed=False, label="UInt32")), ("dwMaxNumSurfaces", SimTypeInt(signed=False, label="UInt32")), ("ddUncompPixelFormat", SimTypeRef("DDPIXELFORMAT", SimStruct)),)), name="AMVAUncompBufferInfo", pack=False, align=None),
    "AMVAUncompDataInfo": SimStruct(OrderedDict((("dwUncompWidth", SimTypeInt(signed=False, label="UInt32")), ("dwUncompHeight", SimTypeInt(signed=False, label="UInt32")), ("ddUncompPixelFormat", SimTypeRef("DDPIXELFORMAT", SimStruct)),)), name="AMVAUncompDataInfo", pack=False, align=None),
    "AMVPDATAINFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwMicrosecondsPerField", SimTypeInt(signed=False, label="UInt32")), ("amvpDimInfo", SimTypeRef("AMVPDIMINFO", SimStruct)), ("dwPictAspectRatioX", SimTypeInt(signed=False, label="UInt32")), ("dwPictAspectRatioY", SimTypeInt(signed=False, label="UInt32")), ("bEnableDoubleClock", SimTypeInt(signed=True, label="Int32")), ("bEnableVACT", SimTypeInt(signed=True, label="Int32")), ("bDataIsInterlaced", SimTypeInt(signed=True, label="Int32")), ("lHalfLinesOdd", SimTypeInt(signed=True, label="Int32")), ("bFieldPolarityInverted", SimTypeInt(signed=True, label="Int32")), ("dwNumLinesInVREF", SimTypeInt(signed=False, label="UInt32")), ("lHalfLinesEven", SimTypeInt(signed=True, label="Int32")), ("dwReserved1", SimTypeInt(signed=False, label="UInt32")),)), name="AMVPDATAINFO", pack=False, align=None),
    "AMVPDIMINFO": SimStruct(OrderedDict((("dwFieldWidth", SimTypeInt(signed=False, label="UInt32")), ("dwFieldHeight", SimTypeInt(signed=False, label="UInt32")), ("dwVBIWidth", SimTypeInt(signed=False, label="UInt32")), ("dwVBIHeight", SimTypeInt(signed=False, label="UInt32")), ("rcValidRegion", SimTypeRef("RECT", SimStruct)),)), name="AMVPDIMINFO", pack=False, align=None),
    "AMVPSIZE": SimStruct(OrderedDict((("dwWidth", SimTypeInt(signed=False, label="UInt32")), ("dwHeight", SimTypeInt(signed=False, label="UInt32")),)), name="AMVPSIZE", pack=False, align=None),
    "AMVP_MODE": SimTypeInt(signed=False, label="AMVP_MODE"),
    "AMVP_SELECT_FORMAT_BY": SimTypeInt(signed=False, label="AMVP_SELECT_FORMAT_BY"),
    "AM_AC3_ALTERNATE_AUDIO": SimStruct(OrderedDict((("fStereo", SimTypeInt(signed=True, label="Int32")), ("DualMode", SimTypeInt(signed=False, label="UInt32")),)), name="AM_AC3_ALTERNATE_AUDIO", pack=False, align=None),
    "AM_AC3_BIT_STREAM_MODE": SimStruct(OrderedDict((("BitStreamMode", SimTypeInt(signed=True, label="Int32")),)), name="AM_AC3_BIT_STREAM_MODE", pack=False, align=None),
    "AM_AC3_DIALOGUE_LEVEL": SimStruct(OrderedDict((("DialogueLevel", SimTypeInt(signed=False, label="UInt32")),)), name="AM_AC3_DIALOGUE_LEVEL", pack=False, align=None),
    "AM_AC3_DOWNMIX": SimStruct(OrderedDict((("fDownMix", SimTypeInt(signed=True, label="Int32")), ("fDolbySurround", SimTypeInt(signed=True, label="Int32")),)), name="AM_AC3_DOWNMIX", pack=False, align=None),
    "AM_AC3_ERROR_CONCEALMENT": SimStruct(OrderedDict((("fRepeatPreviousBlock", SimTypeInt(signed=True, label="Int32")), ("fErrorInCurrentBlock", SimTypeInt(signed=True, label="Int32")),)), name="AM_AC3_ERROR_CONCEALMENT", pack=False, align=None),
    "AM_AC3_ROOM_TYPE": SimStruct(OrderedDict((("fLargeRoom", SimTypeInt(signed=True, label="Int32")),)), name="AM_AC3_ROOM_TYPE", pack=False, align=None),
    "AM_ASPECT_RATIO_MODE": SimTypeInt(signed=False, label="AM_ASPECT_RATIO_MODE"),
    "AM_COLCON": SimStruct(OrderedDict((("_bitfield1", SimTypeChar(label="Byte")), ("_bitfield2", SimTypeChar(label="Byte")), ("_bitfield3", SimTypeChar(label="Byte")), ("_bitfield4", SimTypeChar(label="Byte")),)), name="AM_COLCON", pack=False, align=None),
    "AM_COPY_MACROVISION": SimStruct(OrderedDict((("MACROVISIONLevel", SimTypeInt(signed=False, label="UInt32")),)), name="AM_COPY_MACROVISION", pack=False, align=None),
    "AM_COPY_MACROVISION_LEVEL": SimTypeInt(signed=False, label="AM_COPY_MACROVISION_LEVEL"),
    "AM_DIGITAL_CP": SimTypeInt(signed=False, label="AM_DIGITAL_CP"),
    "AM_DVDCOPYSTATE": SimTypeInt(signed=False, label="AM_DVDCOPYSTATE"),
    "AM_DVDCOPY_BUSKEY": SimStruct(OrderedDict((("BusKey", SimTypeArray(SimTypeChar(label="Byte"), 5)), ("Reserved", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="AM_DVDCOPY_BUSKEY", pack=False, align=None),
    "AM_DVDCOPY_CHLGKEY": SimStruct(OrderedDict((("ChlgKey", SimTypeArray(SimTypeChar(label="Byte"), 10)), ("Reserved", SimTypeArray(SimTypeChar(label="Byte"), 2)),)), name="AM_DVDCOPY_CHLGKEY", pack=False, align=None),
    "AM_DVDCOPY_DISCKEY": SimStruct(OrderedDict((("DiscKey", SimTypeArray(SimTypeChar(label="Byte"), 2048)),)), name="AM_DVDCOPY_DISCKEY", pack=False, align=None),
    "AM_DVDCOPY_SET_COPY_STATE": SimStruct(OrderedDict((("DVDCopyState", SimTypeInt(signed=False, label="UInt32")),)), name="AM_DVDCOPY_SET_COPY_STATE", pack=False, align=None),
    "AM_DVDCOPY_TITLEKEY": SimStruct(OrderedDict((("KeyFlags", SimTypeInt(signed=False, label="UInt32")), ("Reserved1", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 2)), ("TitleKey", SimTypeArray(SimTypeChar(label="Byte"), 6)), ("Reserved2", SimTypeArray(SimTypeChar(label="Byte"), 2)),)), name="AM_DVDCOPY_TITLEKEY", pack=False, align=None),
    "AM_DVD_ChangeRate": SimStruct(OrderedDict((("StartInTime", SimTypeLongLong(signed=True, label="Int64")), ("StartOutTime", SimTypeLongLong(signed=True, label="Int64")), ("Rate", SimTypeInt(signed=True, label="Int32")),)), name="AM_DVD_ChangeRate", pack=False, align=None),
    "AM_DVD_GRAPH_FLAGS": SimTypeInt(signed=False, label="AM_DVD_GRAPH_FLAGS"),
    "AM_DVD_RENDERSTATUS": SimStruct(OrderedDict((("hrVPEStatus", SimTypeInt(signed=True, label="Int32")), ("bDvdVolInvalid", SimTypeInt(signed=True, label="Int32")), ("bDvdVolUnknown", SimTypeInt(signed=True, label="Int32")), ("bNoLine21In", SimTypeInt(signed=True, label="Int32")), ("bNoLine21Out", SimTypeInt(signed=True, label="Int32")), ("iNumStreams", SimTypeInt(signed=True, label="Int32")), ("iNumStreamsFailed", SimTypeInt(signed=True, label="Int32")), ("dwFailedStreamsFlag", SimTypeInt(signed=False, label="UInt32")),)), name="AM_DVD_RENDERSTATUS", pack=False, align=None),
    "AM_DVD_STREAM_FLAGS": SimTypeInt(signed=False, label="AM_DVD_STREAM_FLAGS"),
    "AM_DVD_YUV": SimStruct(OrderedDict((("Reserved", SimTypeChar(label="Byte")), ("Y", SimTypeChar(label="Byte")), ("U", SimTypeChar(label="Byte")), ("V", SimTypeChar(label="Byte")),)), name="AM_DVD_YUV", pack=False, align=None),
    "AM_DvdKaraokeData": SimStruct(OrderedDict((("dwDownmix", SimTypeInt(signed=False, label="UInt32")), ("dwSpeakerAssignment", SimTypeInt(signed=False, label="UInt32")),)), name="AM_DvdKaraokeData", pack=False, align=None),
    "AM_ExactRateChange": SimStruct(OrderedDict((("OutputZeroTime", SimTypeLongLong(signed=True, label="Int64")), ("Rate", SimTypeInt(signed=True, label="Int32")),)), name="AM_ExactRateChange", pack=False, align=None),
    "AM_FILESINK_FLAGS": SimTypeInt(signed=False, label="AM_FILESINK_FLAGS"),
    "AM_FILTER_FLAGS": SimTypeInt(signed=False, label="AM_FILTER_FLAGS"),
    "AM_FRAMESTEP_STEP": SimStruct(OrderedDict((("dwFramesToStep", SimTypeInt(signed=False, label="UInt32")),)), name="AM_FRAMESTEP_STEP", pack=False, align=None),
    "AM_GRAPH_CONFIG_RECONNECT_FLAGS": SimTypeInt(signed=False, label="AM_GRAPH_CONFIG_RECONNECT_FLAGS"),
    "AM_LINE21_CCLEVEL": SimTypeInt(signed=False, label="AM_LINE21_CCLEVEL"),
    "AM_LINE21_CCSERVICE": SimTypeInt(signed=False, label="AM_LINE21_CCSERVICE"),
    "AM_LINE21_CCSTATE": SimTypeInt(signed=False, label="AM_LINE21_CCSTATE"),
    "AM_LINE21_CCSTYLE": SimTypeInt(signed=False, label="AM_LINE21_CCSTYLE"),
    "AM_LINE21_DRAWBGMODE": SimTypeInt(signed=False, label="AM_LINE21_DRAWBGMODE"),
    "AM_MEDIAEVENT_FLAGS": SimTypeInt(signed=False, label="AM_MEDIAEVENT_FLAGS"),
    "AM_MEDIA_TYPE": SimStruct(OrderedDict((("majortype", SimTypeBottom(label="Guid")), ("subtype", SimTypeBottom(label="Guid")), ("bFixedSizeSamples", SimTypeInt(signed=True, label="Int32")), ("bTemporalCompression", SimTypeInt(signed=True, label="Int32")), ("lSampleSize", SimTypeInt(signed=False, label="UInt32")), ("formattype", SimTypeBottom(label="Guid")), ("pUnk", SimTypeBottom(label="IUnknown")), ("cbFormat", SimTypeInt(signed=False, label="UInt32")), ("pbFormat", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="AM_MEDIA_TYPE", pack=False, align=None),
    "AM_MPEG2Level": SimTypeInt(signed=False, label="AM_MPEG2Level"),
    "AM_MPEG2Profile": SimTypeInt(signed=False, label="AM_MPEG2Profile"),
    "AM_MPEGSTREAMTYPE": SimStruct(OrderedDict((("dwStreamId", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeInt(signed=False, label="UInt32")), ("mt", SimTypeRef("AM_MEDIA_TYPE", SimStruct)), ("bFormat", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="AM_MPEGSTREAMTYPE", pack=False, align=None),
    "AM_MPEGSYSTEMTYPE": SimStruct(OrderedDict((("dwBitRate", SimTypeInt(signed=False, label="UInt32")), ("cStreams", SimTypeInt(signed=False, label="UInt32")), ("Streams", SimTypePointer(SimTypeRef("AM_MPEGSTREAMTYPE", SimStruct), offset=0)),)), name="AM_MPEGSYSTEMTYPE", pack=False, align=None),
    "AM_PROPERTY_AC3": SimTypeInt(signed=False, label="AM_PROPERTY_AC3"),
    "AM_PROPERTY_DVDCOPYPROT": SimTypeInt(signed=False, label="AM_PROPERTY_DVDCOPYPROT"),
    "AM_PROPERTY_DVDKARAOKE": SimTypeInt(signed=False, label="AM_PROPERTY_DVDKARAOKE"),
    "AM_PROPERTY_DVDSUBPIC": SimTypeInt(signed=False, label="AM_PROPERTY_DVDSUBPIC"),
    "AM_PROPERTY_DVD_RATE_CHANGE": SimTypeInt(signed=False, label="AM_PROPERTY_DVD_RATE_CHANGE"),
    "AM_PROPERTY_FRAMESTEP": SimTypeInt(signed=False, label="AM_PROPERTY_FRAMESTEP"),
    "AM_PROPERTY_SPHLI": SimStruct(OrderedDict((("HLISS", SimTypeShort(signed=False, label="UInt16")), ("Reserved", SimTypeShort(signed=False, label="UInt16")), ("StartPTM", SimTypeInt(signed=False, label="UInt32")), ("EndPTM", SimTypeInt(signed=False, label="UInt32")), ("StartX", SimTypeShort(signed=False, label="UInt16")), ("StartY", SimTypeShort(signed=False, label="UInt16")), ("StopX", SimTypeShort(signed=False, label="UInt16")), ("StopY", SimTypeShort(signed=False, label="UInt16")), ("ColCon", SimTypeRef("AM_COLCON", SimStruct)),)), name="AM_PROPERTY_SPHLI", pack=False, align=None),
    "AM_PROPERTY_SPPAL": SimStruct(OrderedDict((("sppal", SimTypeArray(SimTypeRef("AM_DVD_YUV", SimStruct), 16)),)), name="AM_PROPERTY_SPPAL", pack=False, align=None),
    "AM_PROPERTY_TS_RATE_CHANGE": SimTypeInt(signed=False, label="AM_PROPERTY_TS_RATE_CHANGE"),
    "AM_QueryRate": SimStruct(OrderedDict((("lMaxForwardFullFrame", SimTypeInt(signed=True, label="Int32")), ("lMaxReverseFullFrame", SimTypeInt(signed=True, label="Int32")),)), name="AM_QueryRate", pack=False, align=None),
    "AM_SAMPLE2_PROPERTIES": SimStruct(OrderedDict((("cbData", SimTypeInt(signed=False, label="UInt32")), ("dwTypeSpecificFlags", SimTypeInt(signed=False, label="UInt32")), ("dwSampleFlags", SimTypeInt(signed=False, label="UInt32")), ("lActual", SimTypeInt(signed=True, label="Int32")), ("tStart", SimTypeLongLong(signed=True, label="Int64")), ("tStop", SimTypeLongLong(signed=True, label="Int64")), ("dwStreamId", SimTypeInt(signed=False, label="UInt32")), ("pMediaType", SimTypePointer(SimTypeRef("AM_MEDIA_TYPE", SimStruct), offset=0)), ("pbBuffer", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbBuffer", SimTypeInt(signed=True, label="Int32")),)), name="AM_SAMPLE2_PROPERTIES", pack=False, align=None),
    "AM_SAMPLE_PROPERTY_FLAGS": SimTypeInt(signed=False, label="AM_SAMPLE_PROPERTY_FLAGS"),
    "AM_SEEKING_SEEKING_CAPABILITIES": SimTypeInt(signed=False, label="AM_SEEKING_SEEKING_CAPABILITIES"),
    "AM_SEEKING_SEEKING_FLAGS": SimTypeInt(signed=False, label="AM_SEEKING_SEEKING_FLAGS"),
    "AM_STREAM_INFO": SimStruct(OrderedDict((("tStart", SimTypeLongLong(signed=True, label="Int64")), ("tStop", SimTypeLongLong(signed=True, label="Int64")), ("dwStartCookie", SimTypeInt(signed=False, label="UInt32")), ("dwStopCookie", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="AM_STREAM_INFO", pack=False, align=None),
    "AM_STREAM_INFO_FLAGS": SimTypeInt(signed=False, label="AM_STREAM_INFO_FLAGS"),
    "AM_SimpleRateChange": SimStruct(OrderedDict((("StartTime", SimTypeLongLong(signed=True, label="Int64")), ("Rate", SimTypeInt(signed=True, label="Int32")),)), name="AM_SimpleRateChange", pack=False, align=None),
    "AM_WMT_EVENT_DATA": SimStruct(OrderedDict((("hrStatus", SimTypeInt(signed=True, label="Int32")), ("pData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="AM_WMT_EVENT_DATA", pack=False, align=None),
    "AM_WST_DRAWBGMODE": SimTypeInt(signed=False, label="AM_WST_DRAWBGMODE"),
    "AM_WST_LEVEL": SimTypeInt(signed=False, label="AM_WST_LEVEL"),
    "AM_WST_PAGE": SimStruct(OrderedDict((("dwPageNr", SimTypeInt(signed=False, label="UInt32")), ("dwSubPageNr", SimTypeInt(signed=False, label="UInt32")), ("pucPageData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="AM_WST_PAGE", pack=False, align=None),
    "AM_WST_SERVICE": SimTypeInt(signed=False, label="AM_WST_SERVICE"),
    "AM_WST_STATE": SimTypeInt(signed=False, label="AM_WST_STATE"),
    "AM_WST_STYLE": SimTypeInt(signed=False, label="AM_WST_STYLE"),
    "ANALOGVIDEOINFO": SimStruct(OrderedDict((("rcSource", SimTypeRef("RECT", SimStruct)), ("rcTarget", SimTypeRef("RECT", SimStruct)), ("dwActiveWidth", SimTypeInt(signed=False, label="UInt32")), ("dwActiveHeight", SimTypeInt(signed=False, label="UInt32")), ("AvgTimePerFrame", SimTypeLongLong(signed=True, label="Int64")),)), name="ANALOGVIDEOINFO", pack=False, align=None),
    "ANCHOR_CHANGE_HISTORY_FLAGS": SimTypeInt(signed=False, label="ANCHOR_CHANGE_HISTORY_FLAGS"),
    "ANIMATE_WINDOW_FLAGS": SimTypeInt(signed=False, label="ANIMATE_WINDOW_FLAGS"),
    "ANIMATIONINFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("iMinAnimate", SimTypeInt(signed=True, label="Int32")),)), name="ANIMATIONINFO", pack=False, align=None),
    "ANON_OBJECT_HEADER": SimStruct(OrderedDict((("Sig1", SimTypeShort(signed=False, label="UInt16")), ("Sig2", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Machine", SimTypeShort(signed=False, label="UInt16")), ("TimeDateStamp", SimTypeInt(signed=False, label="UInt32")), ("ClassID", SimTypeBottom(label="Guid")), ("SizeOfData", SimTypeInt(signed=False, label="UInt32")),)), name="ANON_OBJECT_HEADER", pack=False, align=None),
    "ANON_OBJECT_HEADER_BIGOBJ": SimStruct(OrderedDict((("Sig1", SimTypeShort(signed=False, label="UInt16")), ("Sig2", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Machine", SimTypeShort(signed=False, label="UInt16")), ("TimeDateStamp", SimTypeInt(signed=False, label="UInt32")), ("ClassID", SimTypeBottom(label="Guid")), ("SizeOfData", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("MetaDataSize", SimTypeInt(signed=False, label="UInt32")), ("MetaDataOffset", SimTypeInt(signed=False, label="UInt32")), ("NumberOfSections", SimTypeInt(signed=False, label="UInt32")), ("PointerToSymbolTable", SimTypeInt(signed=False, label="UInt32")), ("NumberOfSymbols", SimTypeInt(signed=False, label="UInt32")),)), name="ANON_OBJECT_HEADER_BIGOBJ", pack=False, align=None),
    "ANON_OBJECT_HEADER_V2": SimStruct(OrderedDict((("Sig1", SimTypeShort(signed=False, label="UInt16")), ("Sig2", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Machine", SimTypeShort(signed=False, label="UInt16")), ("TimeDateStamp", SimTypeInt(signed=False, label="UInt32")), ("ClassID", SimTypeBottom(label="Guid")), ("SizeOfData", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("MetaDataSize", SimTypeInt(signed=False, label="UInt32")), ("MetaDataOffset", SimTypeInt(signed=False, label="UInt32")),)), name="ANON_OBJECT_HEADER_V2", pack=False, align=None),
    "APC_CALLBACK_DATA": SimStruct(OrderedDict((("Parameter", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ContextRecord", SimTypePointer(SimTypeRef("CONTEXT", SimStruct), offset=0)), ("Reserved0", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("Reserved1", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="APC_CALLBACK_DATA", pack=False, align=None),
    "APC_CALLBACK_FUNCTION": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1", "param2"]), offset=0),
    "API_VERSION": SimStruct(OrderedDict((("MajorVersion", SimTypeShort(signed=False, label="UInt16")), ("MinorVersion", SimTypeShort(signed=False, label="UInt16")), ("Revision", SimTypeShort(signed=False, label="UInt16")), ("Reserved", SimTypeShort(signed=False, label="UInt16")),)), name="API_VERSION", pack=False, align=None),
    "APOInitBaseStruct": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("clsid", SimTypeBottom(label="Guid")),)), name="APOInitBaseStruct", pack=False, align=None),
    "APOInitSystemEffects": SimStruct(OrderedDict((("APOInit", SimTypeRef("APOInitBaseStruct", SimStruct)), ("pAPOEndpointProperties", SimTypeBottom(label="IPropertyStore")), ("pAPOSystemEffectsProperties", SimTypeBottom(label="IPropertyStore")), ("pReserved", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pDeviceCollection", SimTypeBottom(label="IMMDeviceCollection")),)), name="APOInitSystemEffects", pack=False, align=None),
    "APOInitSystemEffects2": SimStruct(OrderedDict((("APOInit", SimTypeRef("APOInitBaseStruct", SimStruct)), ("pAPOEndpointProperties", SimTypeBottom(label="IPropertyStore")), ("pAPOSystemEffectsProperties", SimTypeBottom(label="IPropertyStore")), ("pReserved", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pDeviceCollection", SimTypeBottom(label="IMMDeviceCollection")), ("nSoftwareIoDeviceInCollection", SimTypeInt(signed=False, label="UInt32")), ("nSoftwareIoConnectorIndex", SimTypeInt(signed=False, label="UInt32")), ("AudioProcessingMode", SimTypeBottom(label="Guid")), ("InitializeForDiscoveryOnly", SimTypeInt(signed=True, label="Int32")),)), name="APOInitSystemEffects2", pack=False, align=None),
    "APOInitSystemEffects3": SimStruct(OrderedDict((("APOInit", SimTypeRef("APOInitBaseStruct", SimStruct)), ("pAPOEndpointProperties", SimTypeBottom(label="IPropertyStore")), ("pServiceProvider", SimTypeBottom(label="IServiceProvider")), ("pDeviceCollection", SimTypeBottom(label="IMMDeviceCollection")), ("nSoftwareIoDeviceInCollection", SimTypeInt(signed=False, label="UInt32")), ("nSoftwareIoConnectorIndex", SimTypeInt(signed=False, label="UInt32")), ("AudioProcessingMode", SimTypeBottom(label="Guid")), ("InitializeForDiscoveryOnly", SimTypeInt(signed=True, label="Int32")),)), name="APOInitSystemEffects3", pack=False, align=None),
    "APO_BUFFER_FLAGS": SimTypeInt(signed=False, label="APO_BUFFER_FLAGS"),
    "APO_CONNECTION_BUFFER_TYPE": SimTypeInt(signed=False, label="APO_CONNECTION_BUFFER_TYPE"),
    "APO_CONNECTION_DESCRIPTOR": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="APO_CONNECTION_BUFFER_TYPE")), ("pBuffer", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("u32MaxFrameCount", SimTypeInt(signed=False, label="UInt32")), ("pFormat", SimTypeBottom(label="IAudioMediaType")), ("u32Signature", SimTypeInt(signed=False, label="UInt32")),)), name="APO_CONNECTION_DESCRIPTOR", pack=False, align=None),
    "APO_CONNECTION_PROPERTY": SimStruct(OrderedDict((("pBuffer", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("u32ValidFrameCount", SimTypeInt(signed=False, label="UInt32")), ("u32BufferFlags", SimTypeInt(signed=False, label="APO_BUFFER_FLAGS")), ("u32Signature", SimTypeInt(signed=False, label="UInt32")),)), name="APO_CONNECTION_PROPERTY", pack=False, align=None),
    "APO_CONNECTION_PROPERTY_V2": SimStruct(OrderedDict((("property", SimTypeRef("APO_CONNECTION_PROPERTY", SimStruct)), ("u64QPCTime", SimTypeLongLong(signed=False, label="UInt64")),)), name="APO_CONNECTION_PROPERTY_V2", pack=False, align=None),
    "APO_FLAG": SimTypeInt(signed=False, label="APO_FLAG"),
    "APO_LOG_LEVEL": SimTypeInt(signed=False, label="APO_LOG_LEVEL"),
    "APO_NOTIFICATION": SimStruct(OrderedDict((("type", SimTypeInt(signed=False, label="APO_NOTIFICATION_TYPE")), ("Anonymous", SimUnion({"audioEndpointVolumeChange": SimTypeRef("AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION", SimStruct), "audioEndpointPropertyChange": SimTypeRef("AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION", SimStruct), "audioSystemEffectsPropertyChange": SimTypeRef("AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION", SimStruct), "audioEndpointVolumeChange2": SimTypeRef("AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION2", SimStruct), "deviceOrientation": SimTypeInt(signed=False, label="DEVICE_ORIENTATION_TYPE"), "audioMicrophoneBoostChange": SimTypeRef("AUDIO_MICROPHONE_BOOST_NOTIFICATION", SimStruct)}, name="<anon>", label="None")),)), name="APO_NOTIFICATION", pack=False, align=None),
    "APO_NOTIFICATION_DESCRIPTOR": SimStruct(OrderedDict((("type", SimTypeInt(signed=False, label="APO_NOTIFICATION_TYPE")), ("Anonymous", SimUnion({"audioEndpointVolume": SimTypeRef("AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR", SimStruct), "audioEndpointPropertyChange": SimTypeRef("AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR", SimStruct), "audioSystemEffectsPropertyChange": SimTypeRef("AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR", SimStruct), "audioMicrophoneBoost": SimTypeRef("AUDIO_MICROPHONE_BOOST_APO_NOTIFICATION_DESCRIPTOR", SimStruct)}, name="<anon>", label="None")),)), name="APO_NOTIFICATION_DESCRIPTOR", pack=False, align=None),
    "APO_NOTIFICATION_TYPE": SimTypeInt(signed=False, label="APO_NOTIFICATION_TYPE"),
    "APO_REG_PROPERTIES": SimStruct(OrderedDict((("clsid", SimTypeBottom(label="Guid")), ("Flags", SimTypeInt(signed=False, label="APO_FLAG")), ("szFriendlyName", SimTypeArray(SimTypeChar(label="Char"), 256)), ("szCopyrightInfo", SimTypeArray(SimTypeChar(label="Char"), 256)), ("u32MajorVersion", SimTypeInt(signed=False, label="UInt32")), ("u32MinorVersion", SimTypeInt(signed=False, label="UInt32")), ("u32MinInputConnections", SimTypeInt(signed=False, label="UInt32")), ("u32MaxInputConnections", SimTypeInt(signed=False, label="UInt32")), ("u32MinOutputConnections", SimTypeInt(signed=False, label="UInt32")), ("u32MaxOutputConnections", SimTypeInt(signed=False, label="UInt32")), ("u32MaxInstances", SimTypeInt(signed=False, label="UInt32")), ("u32NumAPOInterfaces", SimTypeInt(signed=False, label="UInt32")), ("iidAPOInterfaceList", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)),)), name="APO_REG_PROPERTIES", pack=False, align=None),
    "APPACTIONFLAGS": SimTypeInt(signed=False, label="APPACTIONFLAGS"),
    "APPBARDATA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hWnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("uCallbackMessage", SimTypeInt(signed=False, label="UInt32")), ("uEdge", SimTypeInt(signed=False, label="UInt32")), ("rc", SimTypeRef("RECT", SimStruct)), ("lParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="APPBARDATA", pack=False, align=None),
    "APPCATEGORYINFO": SimStruct(OrderedDict((("Locale", SimTypeInt(signed=False, label="UInt32")), ("pszDescription", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("AppCategoryId", SimTypeBottom(label="Guid")),)), name="APPCATEGORYINFO", pack=False, align=None),
    "APPCATEGORYINFOLIST": SimStruct(OrderedDict((("cCategory", SimTypeInt(signed=False, label="UInt32")), ("pCategoryInfo", SimTypePointer(SimTypeRef("APPCATEGORYINFO", SimStruct), offset=0)),)), name="APPCATEGORYINFOLIST", pack=False, align=None),
    "APPCOMMAND_ID": SimTypeInt(signed=False, label="APPCOMMAND_ID"),
    "APPDATA": SimStruct(OrderedDict((("m_idApp", SimTypeInt(signed=False, label="UInt32")), ("m_szAppGuid", SimTypeArray(SimTypeChar(label="Char"), 40)), ("m_dwAppProcessId", SimTypeInt(signed=False, label="UInt32")), ("m_AppStatistics", SimTypeRef("APPSTATISTICS", SimStruct)),)), name="APPDATA", pack=False, align=None),
    "APPDOCLISTTYPE": SimTypeInt(signed=False, label="APPDOCLISTTYPE"),
    "APPDOMAIN_SECURITY_FLAGS": SimTypeInt(signed=False, label="APPDOMAIN_SECURITY_FLAGS"),
    "APPINFODATA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMask", SimTypeInt(signed=False, label="UInt32")), ("pszDisplayName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszVersion", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszPublisher", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszProductID", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszRegisteredOwner", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszRegisteredCompany", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszLanguage", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszSupportUrl", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszSupportTelephone", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszHelpLink", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszInstallLocation", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszInstallSource", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszInstallDate", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszContact", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszComments", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszImage", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszReadmeUrl", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszUpdateInfoUrl", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="APPINFODATA", pack=False, align=None),
    "APPINFODATAFLAGS": SimTypeInt(signed=False, label="APPINFODATAFLAGS"),
    "APPLETIDLIST": SimStruct(OrderedDict((("count", SimTypeInt(signed=True, label="Int32")), ("pIIDList", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)),)), name="APPLETIDLIST", pack=False, align=None),
    "APPLET_PROC": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndCpl", "msg", "lParam1", "lParam2"]), offset=0),
    "APPLICATIONLAUNCH_SETTING_VALUE": SimStruct(OrderedDict((("ActivationTime", SimTypeLongLong(signed=True, label="Int64")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("ButtonInstanceID", SimTypeInt(signed=False, label="UInt32")),)), name="APPLICATIONLAUNCH_SETTING_VALUE", pack=False, align=None),
    "APPLICATIONTYPE": SimTypeInt(signed=False, label="APPLICATIONTYPE"),
    "APPLICATION_EVENT_DATA": SimStruct(OrderedDict((("cbApplicationEventData", SimTypeInt(signed=False, label="UInt32")), ("ApplicationId", SimTypeBottom(label="Guid")), ("EndpointId", SimTypeBottom(label="Guid")), ("dwEventId", SimTypeInt(signed=False, label="UInt32")), ("cbEventData", SimTypeInt(signed=False, label="UInt32")), ("bEventData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="APPLICATION_EVENT_DATA", pack=False, align=None),
    "APPLICATION_NODE_EVENT_FILTER": SimTypeInt(signed=False, label="APPLICATION_NODE_EVENT_FILTER"),
    "APPLICATION_RECOVERY_CALLBACK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pvParameter"]), offset=0),
    "APPLICATION_VIEW_MIN_WIDTH": SimTypeInt(signed=False, label="APPLICATION_VIEW_MIN_WIDTH"),
    "APPLICATION_VIEW_ORIENTATION": SimTypeInt(signed=False, label="APPLICATION_VIEW_ORIENTATION"),
    "APPLICATION_VIEW_SIZE_PREFERENCE": SimTypeInt(signed=False, label="APPLICATION_VIEW_SIZE_PREFERENCE"),
    "APPLICATION_VIEW_STATE": SimTypeInt(signed=False, label="APPLICATION_VIEW_STATE"),
    "APPLYCANDEXPARAM": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("lpwstrDisplay", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpwstrReading", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwReserved", SimTypeInt(signed=False, label="UInt32")),)), name="APPLYCANDEXPARAM", pack=False, align=None),
    "APPLY_CONTROL_TOKEN_FN": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("SecHandle", SimStruct), offset=0), SimTypePointer(SimTypeRef("SecBufferDesc", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0),
    "APPLY_SNAPSHOT_VHDSET_FLAG": SimTypeInt(signed=False, label="APPLY_SNAPSHOT_VHDSET_FLAG"),
    "APPLY_SNAPSHOT_VHDSET_PARAMETERS": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="APPLY_SNAPSHOT_VHDSET_VERSION")), ("Anonymous", SimUnion({"Version1": SimTypeRef("_Version1_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="APPLY_SNAPSHOT_VHDSET_PARAMETERS", pack=False, align=None),
    "APPLY_SNAPSHOT_VHDSET_VERSION": SimTypeInt(signed=False, label="APPLY_SNAPSHOT_VHDSET_VERSION"),
    "APPSTATE": SimTypeInt(signed=False, label="APPSTATE"),
    "APPSTATISTICS": SimStruct(OrderedDict((("m_cTotalCalls", SimTypeInt(signed=False, label="UInt32")), ("m_cTotalInstances", SimTypeInt(signed=False, label="UInt32")), ("m_cTotalClasses", SimTypeInt(signed=False, label="UInt32")), ("m_cCallsPerSecond", SimTypeInt(signed=False, label="UInt32")),)), name="APPSTATISTICS", pack=False, align=None),
    "APPX_BUNDLE_FOOTPRINT_FILE_TYPE": SimTypeInt(signed=False, label="APPX_BUNDLE_FOOTPRINT_FILE_TYPE"),
    "APPX_BUNDLE_PAYLOAD_PACKAGE_TYPE": SimTypeInt(signed=False, label="APPX_BUNDLE_PAYLOAD_PACKAGE_TYPE"),
    "APPX_CAPABILITIES": SimTypeInt(signed=False, label="APPX_CAPABILITIES"),
    "APPX_CAPABILITY_CLASS_TYPE": SimTypeInt(signed=False, label="APPX_CAPABILITY_CLASS_TYPE"),
    "APPX_COMPRESSION_OPTION": SimTypeInt(signed=False, label="APPX_COMPRESSION_OPTION"),
    "APPX_ENCRYPTED_EXEMPTIONS": SimStruct(OrderedDict((("count", SimTypeInt(signed=False, label="UInt32")), ("plainTextFiles", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="APPX_ENCRYPTED_EXEMPTIONS", pack=False, align=None),
    "APPX_ENCRYPTED_PACKAGE_OPTIONS": SimTypeInt(signed=False, label="APPX_ENCRYPTED_PACKAGE_OPTIONS"),
    "APPX_ENCRYPTED_PACKAGE_SETTINGS": SimStruct(OrderedDict((("keyLength", SimTypeInt(signed=False, label="UInt32")), ("encryptionAlgorithm", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("useDiffusion", SimTypeInt(signed=True, label="Int32")), ("blockMapHashAlgorithm", SimTypeBottom(label="IUri")),)), name="APPX_ENCRYPTED_PACKAGE_SETTINGS", pack=False, align=None),
    "APPX_ENCRYPTED_PACKAGE_SETTINGS2": SimStruct(OrderedDict((("keyLength", SimTypeInt(signed=False, label="UInt32")), ("encryptionAlgorithm", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("blockMapHashAlgorithm", SimTypeBottom(label="IUri")), ("options", SimTypeInt(signed=False, label="UInt32")),)), name="APPX_ENCRYPTED_PACKAGE_SETTINGS2", pack=False, align=None),
    "APPX_FOOTPRINT_FILE_TYPE": SimTypeInt(signed=False, label="APPX_FOOTPRINT_FILE_TYPE"),
    "APPX_KEY_INFO": SimStruct(OrderedDict((("keyLength", SimTypeInt(signed=False, label="UInt32")), ("keyIdLength", SimTypeInt(signed=False, label="UInt32")), ("key", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("keyId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="APPX_KEY_INFO", pack=False, align=None),
    "APPX_PACKAGE_ARCHITECTURE": SimTypeInt(signed=False, label="APPX_PACKAGE_ARCHITECTURE"),
    "APPX_PACKAGE_ARCHITECTURE2": SimTypeInt(signed=False, label="APPX_PACKAGE_ARCHITECTURE2"),
    "APPX_PACKAGE_EDITOR_UPDATE_PACKAGE_MANIFEST_OPTIONS": SimTypeInt(signed=False, label="APPX_PACKAGE_EDITOR_UPDATE_PACKAGE_MANIFEST_OPTIONS"),
    "APPX_PACKAGE_EDITOR_UPDATE_PACKAGE_OPTION": SimTypeInt(signed=False, label="APPX_PACKAGE_EDITOR_UPDATE_PACKAGE_OPTION"),
    "APPX_PACKAGE_SETTINGS": SimStruct(OrderedDict((("forceZip32", SimTypeInt(signed=True, label="Int32")), ("hashMethod", SimTypeBottom(label="IUri")),)), name="APPX_PACKAGE_SETTINGS", pack=False, align=None),
    "APPX_PACKAGE_WRITER_PAYLOAD_STREAM": SimStruct(OrderedDict((("inputStream", SimTypeBottom(label="IStream")), ("fileName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("contentType", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("compressionOption", SimTypeInt(signed=False, label="APPX_COMPRESSION_OPTION")),)), name="APPX_PACKAGE_WRITER_PAYLOAD_STREAM", pack=False, align=None),
    "APPX_PACKAGING_CONTEXT_CHANGE_TYPE": SimTypeInt(signed=False, label="APPX_PACKAGING_CONTEXT_CHANGE_TYPE"),
    "APP_CACHE_DOWNLOAD_ENTRY": SimStruct(OrderedDict((("pwszUrl", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwEntryType", SimTypeInt(signed=False, label="UInt32")),)), name="APP_CACHE_DOWNLOAD_ENTRY", pack=False, align=None),
    "APP_CACHE_DOWNLOAD_LIST": SimStruct(OrderedDict((("dwEntryCount", SimTypeInt(signed=False, label="UInt32")), ("pEntries", SimTypePointer(SimTypeRef("APP_CACHE_DOWNLOAD_ENTRY", SimStruct), offset=0)),)), name="APP_CACHE_DOWNLOAD_LIST", pack=False, align=None),
    "APP_CACHE_FINALIZE_STATE": SimTypeInt(signed=False, label="APP_CACHE_FINALIZE_STATE"),
    "APP_CACHE_GROUP_INFO": SimStruct(OrderedDict((("pwszManifestUrl", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ftLastAccessTime", SimTypeRef("FILETIME", SimStruct)), ("ullSize", SimTypeLongLong(signed=False, label="UInt64")),)), name="APP_CACHE_GROUP_INFO", pack=False, align=None),
    "APP_CACHE_GROUP_LIST": SimStruct(OrderedDict((("dwAppCacheGroupCount", SimTypeInt(signed=False, label="UInt32")), ("pAppCacheGroups", SimTypePointer(SimTypeRef("APP_CACHE_GROUP_INFO", SimStruct), offset=0)),)), name="APP_CACHE_GROUP_LIST", pack=False, align=None),
    "APP_CACHE_STATE": SimTypeInt(signed=False, label="APP_CACHE_STATE"),
    "APP_LOCAL_DEVICE_ID": SimStruct(OrderedDict((("value", SimTypeArray(SimTypeChar(label="Byte"), 32)),)), name="APP_LOCAL_DEVICE_ID", pack=False, align=None),
    "APP_MEMORY_INFORMATION": SimStruct(OrderedDict((("AvailableCommit", SimTypeLongLong(signed=False, label="UInt64")), ("PrivateCommitUsage", SimTypeLongLong(signed=False, label="UInt64")), ("PeakPrivateCommitUsage", SimTypeLongLong(signed=False, label="UInt64")), ("TotalCommitUsage", SimTypeLongLong(signed=False, label="UInt64")),)), name="APP_MEMORY_INFORMATION", pack=False, align=None),
    "APTTYPE": SimTypeInt(signed=False, label="APTTYPE"),
    "APTTYPEQUALIFIER": SimTypeInt(signed=False, label="APTTYPEQUALIFIER"),
    "APTXWAVEFORMAT": SimStruct(OrderedDict((("wfx", SimTypeRef("WAVEFORMATEX", SimStruct)),)), name="APTXWAVEFORMAT", pack=False, align=None),
    "ARBITER_ACTION": SimTypeInt(signed=False, label="ARBITER_ACTION"),
    "ARBITER_ADD_RESERVED_PARAMETERS": SimStruct(OrderedDict((("ReserveDevice", SimTypePointer(SimTypeRef("DEVICE_OBJECT", SimStruct), offset=0)),)), name="ARBITER_ADD_RESERVED_PARAMETERS", pack=False, align=None),
    "ARBITER_BOOT_ALLOCATION_PARAMETERS": SimStruct(OrderedDict((("ArbitrationList", SimTypePointer(SimTypeRef("LIST_ENTRY", SimStruct), offset=0)),)), name="ARBITER_BOOT_ALLOCATION_PARAMETERS", pack=False, align=None),
    "ARBITER_CONFLICT_INFO": SimStruct(OrderedDict((("OwningObject", SimTypePointer(SimTypeRef("DEVICE_OBJECT", SimStruct), offset=0)), ("Start", SimTypeLongLong(signed=False, label="UInt64")), ("End", SimTypeLongLong(signed=False, label="UInt64")),)), name="ARBITER_CONFLICT_INFO", pack=False, align=None),
    "ARBITER_INTERFACE": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Context", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("InterfaceReference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("InterfaceDereference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("ArbiterHandler", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="ARBITER_ACTION"), SimTypePointer(SimTypeRef("ARBITER_PARAMETERS", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Context", "Action", "Parameters"]), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")),)), name="ARBITER_INTERFACE", pack=False, align=None),
    "ARBITER_LIST_ENTRY": SimStruct(OrderedDict((("ListEntry", SimTypeRef("LIST_ENTRY", SimStruct)), ("AlternativeCount", SimTypeInt(signed=False, label="UInt32")), ("Alternatives", SimTypePointer(SimTypeRef("IO_RESOURCE_DESCRIPTOR", SimStruct), offset=0)), ("PhysicalDeviceObject", SimTypePointer(SimTypeRef("DEVICE_OBJECT", SimStruct), offset=0)), ("RequestSource", SimTypeInt(signed=False, label="ARBITER_REQUEST_SOURCE")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("WorkSpace", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("InterfaceType", SimTypeInt(signed=False, label="INTERFACE_TYPE")), ("SlotNumber", SimTypeInt(signed=False, label="UInt32")), ("BusNumber", SimTypeInt(signed=False, label="UInt32")), ("Assignment", SimTypePointer(SimTypeRef("CM_PARTIAL_RESOURCE_DESCRIPTOR", SimStruct), offset=0)), ("SelectedAlternative", SimTypePointer(SimTypeRef("IO_RESOURCE_DESCRIPTOR", SimStruct), offset=0)), ("Result", SimTypeInt(signed=False, label="ARBITER_RESULT")),)), name="ARBITER_LIST_ENTRY", pack=False, align=None),
    "ARBITER_PARAMETERS": SimStruct(OrderedDict((("Parameters", SimUnion({"TestAllocation": SimTypeRef("ARBITER_TEST_ALLOCATION_PARAMETERS", SimStruct), "RetestAllocation": SimTypeRef("ARBITER_RETEST_ALLOCATION_PARAMETERS", SimStruct), "BootAllocation": SimTypeRef("ARBITER_BOOT_ALLOCATION_PARAMETERS", SimStruct), "QueryAllocatedResources": SimTypeRef("ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS", SimStruct), "QueryConflict": SimTypeRef("ARBITER_QUERY_CONFLICT_PARAMETERS", SimStruct), "QueryArbitrate": SimTypeRef("ARBITER_QUERY_ARBITRATE_PARAMETERS", SimStruct), "AddReserved": SimTypeRef("ARBITER_ADD_RESERVED_PARAMETERS", SimStruct)}, name="<anon>", label="None")),)), name="ARBITER_PARAMETERS", pack=False, align=None),
    "ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS": SimStruct(OrderedDict((("AllocatedResources", SimTypePointer(SimTypePointer(SimTypeRef("CM_PARTIAL_RESOURCE_LIST", SimStruct), offset=0), offset=0)),)), name="ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS", pack=False, align=None),
    "ARBITER_QUERY_ARBITRATE_PARAMETERS": SimStruct(OrderedDict((("ArbitrationList", SimTypePointer(SimTypeRef("LIST_ENTRY", SimStruct), offset=0)),)), name="ARBITER_QUERY_ARBITRATE_PARAMETERS", pack=False, align=None),
    "ARBITER_QUERY_CONFLICT_PARAMETERS": SimStruct(OrderedDict((("PhysicalDeviceObject", SimTypePointer(SimTypeRef("DEVICE_OBJECT", SimStruct), offset=0)), ("ConflictingResource", SimTypePointer(SimTypeRef("IO_RESOURCE_DESCRIPTOR", SimStruct), offset=0)), ("ConflictCount", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("Conflicts", SimTypePointer(SimTypePointer(SimTypeRef("ARBITER_CONFLICT_INFO", SimStruct), offset=0), offset=0)),)), name="ARBITER_QUERY_CONFLICT_PARAMETERS", pack=False, align=None),
    "ARBITER_REQUEST_SOURCE": SimTypeInt(signed=False, label="ARBITER_REQUEST_SOURCE"),
    "ARBITER_RESULT": SimTypeInt(signed=False, label="ARBITER_RESULT"),
    "ARBITER_RETEST_ALLOCATION_PARAMETERS": SimStruct(OrderedDict((("ArbitrationList", SimTypePointer(SimTypeRef("LIST_ENTRY", SimStruct), offset=0)), ("AllocateFromCount", SimTypeInt(signed=False, label="UInt32")), ("AllocateFrom", SimTypePointer(SimTypeRef("CM_PARTIAL_RESOURCE_DESCRIPTOR", SimStruct), offset=0)),)), name="ARBITER_RETEST_ALLOCATION_PARAMETERS", pack=False, align=None),
    "ARBITER_TEST_ALLOCATION_PARAMETERS": SimStruct(OrderedDict((("ArbitrationList", SimTypePointer(SimTypeRef("LIST_ENTRY", SimStruct), offset=0)), ("AllocateFromCount", SimTypeInt(signed=False, label="UInt32")), ("AllocateFrom", SimTypePointer(SimTypeRef("CM_PARTIAL_RESOURCE_DESCRIPTOR", SimStruct), offset=0)),)), name="ARBITER_TEST_ALLOCATION_PARAMETERS", pack=False, align=None),
    "ARC_DIRECTION": SimTypeInt(signed=False, label="ARC_DIRECTION"),
    "ARM64_FNPDATA_CR": SimTypeInt(signed=False, label="ARM64_FNPDATA_CR"),
    "ARM64_FNPDATA_FLAGS": SimTypeInt(signed=False, label="ARM64_FNPDATA_FLAGS"),
    "ARM64_NT_CONTEXT": SimStruct(OrderedDict((("ContextFlags", SimTypeInt(signed=False, label="UInt32")), ("Cpsr", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"Anonymous": SimStruct(OrderedDict((("X0", SimTypeLongLong(signed=False, label="UInt64")), ("X1", SimTypeLongLong(signed=False, label="UInt64")), ("X2", SimTypeLongLong(signed=False, label="UInt64")), ("X3", SimTypeLongLong(signed=False, label="UInt64")), ("X4", SimTypeLongLong(signed=False, label="UInt64")), ("X5", SimTypeLongLong(signed=False, label="UInt64")), ("X6", SimTypeLongLong(signed=False, label="UInt64")), ("X7", SimTypeLongLong(signed=False, label="UInt64")), ("X8", SimTypeLongLong(signed=False, label="UInt64")), ("X9", SimTypeLongLong(signed=False, label="UInt64")), ("X10", SimTypeLongLong(signed=False, label="UInt64")), ("X11", SimTypeLongLong(signed=False, label="UInt64")), ("X12", SimTypeLongLong(signed=False, label="UInt64")), ("X13", SimTypeLongLong(signed=False, label="UInt64")), ("X14", SimTypeLongLong(signed=False, label="UInt64")), ("X15", SimTypeLongLong(signed=False, label="UInt64")), ("X16", SimTypeLongLong(signed=False, label="UInt64")), ("X17", SimTypeLongLong(signed=False, label="UInt64")), ("X18", SimTypeLongLong(signed=False, label="UInt64")), ("X19", SimTypeLongLong(signed=False, label="UInt64")), ("X20", SimTypeLongLong(signed=False, label="UInt64")), ("X21", SimTypeLongLong(signed=False, label="UInt64")), ("X22", SimTypeLongLong(signed=False, label="UInt64")), ("X23", SimTypeLongLong(signed=False, label="UInt64")), ("X24", SimTypeLongLong(signed=False, label="UInt64")), ("X25", SimTypeLongLong(signed=False, label="UInt64")), ("X26", SimTypeLongLong(signed=False, label="UInt64")), ("X27", SimTypeLongLong(signed=False, label="UInt64")), ("X28", SimTypeLongLong(signed=False, label="UInt64")), ("Fp", SimTypeLongLong(signed=False, label="UInt64")), ("Lr", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "X": SimTypeArray(SimTypeLongLong(signed=False, label="UInt64"), 31)}, name="<anon>", label="None")), ("Sp", SimTypeLongLong(signed=False, label="UInt64")), ("Pc", SimTypeLongLong(signed=False, label="UInt64")), ("V", SimTypeArray(SimUnion({"Anonymous": SimStruct(OrderedDict((("Low", SimTypeLongLong(signed=False, label="UInt64")), ("High", SimTypeLongLong(signed=True, label="Int64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "D": SimTypeArray(SimTypeFloat(size=64), 2), "S": SimTypeArray(SimTypeFloat(size=32), 4), "H": SimTypeArray(SimTypeShort(signed=False, label="UInt16"), 8), "B": SimTypeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), 32)), ("Fpcr", SimTypeInt(signed=False, label="UInt32")), ("Fpsr", SimTypeInt(signed=False, label="UInt32")), ("Bcr", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 8)), ("Bvr", SimTypeArray(SimTypeLongLong(signed=False, label="UInt64"), 8)), ("Wcr", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 2)), ("Wvr", SimTypeArray(SimTypeLongLong(signed=False, label="UInt64"), 2)),)), name="ARM64_NT_CONTEXT", pack=False, align=None),
    "ARM64_NT_NEON128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low", SimTypeLongLong(signed=False, label="UInt64")), ("High", SimTypeLongLong(signed=True, label="Int64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "D": SimTypeArray(SimTypeFloat(size=64), 2), "S": SimTypeArray(SimTypeFloat(size=32), 4), "H": SimTypeArray(SimTypeShort(signed=False, label="UInt16"), 8), "B": SimTypeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"),
    "ARP_HARDWARE_TYPE": SimTypeInt(signed=False, label="ARP_HARDWARE_TYPE"),
    "ARP_HEADER": SimStruct(OrderedDict((("HardwareAddressSpace", SimTypeShort(signed=False, label="UInt16")), ("ProtocolAddressSpace", SimTypeShort(signed=False, label="UInt16")), ("HardwareAddressLength", SimTypeChar(label="Byte")), ("ProtocolAddressLength", SimTypeChar(label="Byte")), ("Opcode", SimTypeShort(signed=False, label="UInt16")), ("SenderHardwareAddress", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ARP_HEADER", pack=False, align=None),
    "ARP_OPCODE": SimTypeInt(signed=False, label="ARP_OPCODE"),
    "ARP_SEND_REPLY": SimStruct(OrderedDict((("DestAddress", SimTypeInt(signed=False, label="UInt32")), ("SrcAddress", SimTypeInt(signed=False, label="UInt32")),)), name="ARP_SEND_REPLY", pack=False, align=None),
    "ARRAYDESC": SimStruct(OrderedDict((("tdescElem", SimTypeRef("TYPEDESC", SimStruct)), ("cDims", SimTypeShort(signed=False, label="UInt16")), ("rgbounds", SimTypePointer(SimTypeRef("SAFEARRAYBOUND", SimStruct), offset=0)),)), name="ARRAYDESC", pack=False, align=None),
    "ARRAY_INFO": SimStruct(OrderedDict((("Dimension", SimTypeInt(signed=True, label="Int32")), ("BufferConformanceMark", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("BufferVarianceMark", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("MaxCountArray", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("OffsetArray", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("ActualCountArray", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="ARRAY_INFO", pack=False, align=None),
    "ARROWBTNSTATES": SimTypeInt(signed=False, label="ARROWBTNSTATES"),
    "AR_STATE": SimTypeInt(signed=False, label="AR_STATE"),
    "ASC_REQ_FLAGS": SimTypeInt(signed=False, label="ASC_REQ_FLAGS"),
    "ASC_REQ_HIGH_FLAGS": SimTypeInt(signed=False, label="ASC_REQ_HIGH_FLAGS"),
    "ASF_FLAT_PICTURE": SimStruct(OrderedDict((("bPictureType", SimTypeChar(label="Byte")), ("dwDataLen", SimTypeInt(signed=False, label="UInt32")),)), name="ASF_FLAT_PICTURE", pack=False, align=None),
    "ASF_FLAT_SYNCHRONISED_LYRICS": SimStruct(OrderedDict((("bTimeStampFormat", SimTypeChar(label="Byte")), ("bContentType", SimTypeChar(label="Byte")), ("dwLyricsLen", SimTypeInt(signed=False, label="UInt32")),)), name="ASF_FLAT_SYNCHRONISED_LYRICS", pack=False, align=None),
    "ASF_INDEX_DESCRIPTOR": SimStruct(OrderedDict((("Identifier", SimTypeRef("ASF_INDEX_IDENTIFIER", SimStruct)), ("cPerEntryBytes", SimTypeShort(signed=False, label="UInt16")), ("szDescription", SimTypeArray(SimTypeChar(label="Char"), 32)), ("dwInterval", SimTypeInt(signed=False, label="UInt32")),)), name="ASF_INDEX_DESCRIPTOR", pack=False, align=None),
    "ASF_INDEX_IDENTIFIER": SimStruct(OrderedDict((("guidIndexType", SimTypeBottom(label="Guid")), ("wStreamNumber", SimTypeShort(signed=False, label="UInt16")),)), name="ASF_INDEX_IDENTIFIER", pack=False, align=None),
    "ASF_MUX_STATISTICS": SimStruct(OrderedDict((("cFramesWritten", SimTypeInt(signed=False, label="UInt32")), ("cFramesDropped", SimTypeInt(signed=False, label="UInt32")),)), name="ASF_MUX_STATISTICS", pack=False, align=None),
    "ASF_SELECTION_STATUS": SimTypeInt(signed=False, label="ASF_SELECTION_STATUS"),
    "ASF_STATUSFLAGS": SimTypeInt(signed=False, label="ASF_STATUSFLAGS"),
    "ASM_BIND_FLAGS": SimTypeInt(signed=False, label="ASM_BIND_FLAGS"),
    "ASM_CMP_FLAGS": SimTypeInt(signed=False, label="ASM_CMP_FLAGS"),
    "ASM_DISPLAY_FLAGS": SimTypeInt(signed=False, label="ASM_DISPLAY_FLAGS"),
    "ASM_NAME": SimTypeInt(signed=False, label="ASM_NAME"),
    "ASSEMBLY_FILE_DETAILED_INFORMATION": SimStruct(OrderedDict((("ulFlags", SimTypeInt(signed=False, label="UInt32")), ("ulFilenameLength", SimTypeInt(signed=False, label="UInt32")), ("ulPathLength", SimTypeInt(signed=False, label="UInt32")), ("lpFileName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpFilePath", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ASSEMBLY_FILE_DETAILED_INFORMATION", pack=False, align=None),
    "ASSEMBLY_INFO": SimStruct(OrderedDict((("cbAssemblyInfo", SimTypeInt(signed=False, label="UInt32")), ("dwAssemblyFlags", SimTypeInt(signed=False, label="UInt32")), ("uliAssemblySizeInKB", SimTypeLongLong(signed=False, label="UInt64")), ("pszCurrentAssemblyPathBuf", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cchBuf", SimTypeInt(signed=False, label="UInt32")),)), name="ASSEMBLY_INFO", pack=False, align=None),
    "ASSOCCLASS": SimTypeInt(signed=False, label="ASSOCCLASS"),
    "ASSOCDATA": SimTypeInt(signed=False, label="ASSOCDATA"),
    "ASSOCENUM": SimTypeInt(signed=False, label="ASSOCENUM"),
    "ASSOCF": SimTypeInt(signed=False, label="ASSOCF"),
    "ASSOCIATE_NAMERES_CONTEXT_INPUT": SimStruct(OrderedDict((("TransportSettingId", SimTypeRef("TRANSPORT_SETTING_ID", SimStruct)), ("Handle", SimTypeLongLong(signed=False, label="UInt64")),)), name="ASSOCIATE_NAMERES_CONTEXT_INPUT", pack=False, align=None),
    "ASSOCIATIONELEMENT": SimStruct(OrderedDict((("ac", SimTypeInt(signed=False, label="ASSOCCLASS")), ("hkClass", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pszClass", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ASSOCIATIONELEMENT", pack=False, align=None),
    "ASSOCIATIONLEVEL": SimTypeInt(signed=False, label="ASSOCIATIONLEVEL"),
    "ASSOCIATIONTYPE": SimTypeInt(signed=False, label="ASSOCIATIONTYPE"),
    "ASSOCKEY": SimTypeInt(signed=False, label="ASSOCKEY"),
    "ASSOCSTR": SimTypeInt(signed=False, label="ASSOCSTR"),
    "ASSOC_FILTER": SimTypeInt(signed=False, label="ASSOC_FILTER"),
    "ASYNC_COMPLETION": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["dwRequestID", "lResult"]), offset=0),
    "ASYNC_DUPLICATE_EXTENTS_STATUS": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("State", SimTypeInt(signed=False, label="DUPLICATE_EXTENTS_STATE")), ("SourceFileOffset", SimTypeLongLong(signed=False, label="UInt64")), ("TargetFileOffset", SimTypeLongLong(signed=False, label="UInt64")), ("ByteCount", SimTypeLongLong(signed=False, label="UInt64")), ("BytesDuplicated", SimTypeLongLong(signed=False, label="UInt64")),)), name="ASYNC_DUPLICATE_EXTENTS_STATUS", pack=False, align=None),
    "ATA_PASS_THROUGH_DIRECT": SimStruct(OrderedDict((("Length", SimTypeShort(signed=False, label="UInt16")), ("AtaFlags", SimTypeShort(signed=False, label="UInt16")), ("PathId", SimTypeChar(label="Byte")), ("TargetId", SimTypeChar(label="Byte")), ("Lun", SimTypeChar(label="Byte")), ("ReservedAsUchar", SimTypeChar(label="Byte")), ("DataTransferLength", SimTypeInt(signed=False, label="UInt32")), ("TimeOutValue", SimTypeInt(signed=False, label="UInt32")), ("ReservedAsUlong", SimTypeInt(signed=False, label="UInt32")), ("DataBuffer", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("PreviousTaskFile", SimTypeArray(SimTypeChar(label="Byte"), 8)), ("CurrentTaskFile", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="ATA_PASS_THROUGH_DIRECT", pack=False, align=None),
    "ATA_PASS_THROUGH_DIRECT32": SimStruct(OrderedDict((("Length", SimTypeShort(signed=False, label="UInt16")), ("AtaFlags", SimTypeShort(signed=False, label="UInt16")), ("PathId", SimTypeChar(label="Byte")), ("TargetId", SimTypeChar(label="Byte")), ("Lun", SimTypeChar(label="Byte")), ("ReservedAsUchar", SimTypeChar(label="Byte")), ("DataTransferLength", SimTypeInt(signed=False, label="UInt32")), ("TimeOutValue", SimTypeInt(signed=False, label="UInt32")), ("ReservedAsUlong", SimTypeInt(signed=False, label="UInt32")), ("DataBuffer", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("PreviousTaskFile", SimTypeArray(SimTypeChar(label="Byte"), 8)), ("CurrentTaskFile", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="ATA_PASS_THROUGH_DIRECT32", pack=False, align=None),
    "ATA_PASS_THROUGH_EX": SimStruct(OrderedDict((("Length", SimTypeShort(signed=False, label="UInt16")), ("AtaFlags", SimTypeShort(signed=False, label="UInt16")), ("PathId", SimTypeChar(label="Byte")), ("TargetId", SimTypeChar(label="Byte")), ("Lun", SimTypeChar(label="Byte")), ("ReservedAsUchar", SimTypeChar(label="Byte")), ("DataTransferLength", SimTypeInt(signed=False, label="UInt32")), ("TimeOutValue", SimTypeInt(signed=False, label="UInt32")), ("ReservedAsUlong", SimTypeInt(signed=False, label="UInt32")), ("DataBufferOffset", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("PreviousTaskFile", SimTypeArray(SimTypeChar(label="Byte"), 8)), ("CurrentTaskFile", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="ATA_PASS_THROUGH_EX", pack=False, align=None),
    "ATA_PASS_THROUGH_EX32": SimStruct(OrderedDict((("Length", SimTypeShort(signed=False, label="UInt16")), ("AtaFlags", SimTypeShort(signed=False, label="UInt16")), ("PathId", SimTypeChar(label="Byte")), ("TargetId", SimTypeChar(label="Byte")), ("Lun", SimTypeChar(label="Byte")), ("ReservedAsUchar", SimTypeChar(label="Byte")), ("DataTransferLength", SimTypeInt(signed=False, label="UInt32")), ("TimeOutValue", SimTypeInt(signed=False, label="UInt32")), ("ReservedAsUlong", SimTypeInt(signed=False, label="UInt32")), ("DataBufferOffset", SimTypeInt(signed=False, label="UInt32")), ("PreviousTaskFile", SimTypeArray(SimTypeChar(label="Byte"), 8)), ("CurrentTaskFile", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="ATA_PASS_THROUGH_EX32", pack=False, align=None),
    "ATF_FLAGS": SimTypeInt(signed=False, label="ATF_FLAGS"),
    "ATM_ADDRESS": SimStruct(OrderedDict((("AddressType", SimTypeInt(signed=False, label="UInt32")), ("NumofDigits", SimTypeInt(signed=False, label="UInt32")), ("Addr", SimTypeArray(SimTypeChar(label="Byte"), 20)),)), name="ATM_ADDRESS", pack=False, align=None),
    "ATM_BHLI": SimStruct(OrderedDict((("HighLayerInfoType", SimTypeInt(signed=False, label="UInt32")), ("HighLayerInfoLength", SimTypeInt(signed=False, label="UInt32")), ("HighLayerInfo", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="ATM_BHLI", pack=False, align=None),
    "ATM_BLLI": SimStruct(OrderedDict((("Layer2Protocol", SimTypeInt(signed=False, label="UInt32")), ("Layer2UserSpecifiedProtocol", SimTypeInt(signed=False, label="UInt32")), ("Layer3Protocol", SimTypeInt(signed=False, label="UInt32")), ("Layer3UserSpecifiedProtocol", SimTypeInt(signed=False, label="UInt32")), ("Layer3IPI", SimTypeInt(signed=False, label="UInt32")), ("SnapID", SimTypeArray(SimTypeChar(label="Byte"), 5)),)), name="ATM_BLLI", pack=False, align=None),
    "ATM_BLLI_IE": SimStruct(OrderedDict((("Layer2Protocol", SimTypeInt(signed=False, label="UInt32")), ("Layer2Mode", SimTypeChar(label="Byte")), ("Layer2WindowSize", SimTypeChar(label="Byte")), ("Layer2UserSpecifiedProtocol", SimTypeInt(signed=False, label="UInt32")), ("Layer3Protocol", SimTypeInt(signed=False, label="UInt32")), ("Layer3Mode", SimTypeChar(label="Byte")), ("Layer3DefaultPacketSize", SimTypeChar(label="Byte")), ("Layer3PacketWindowSize", SimTypeChar(label="Byte")), ("Layer3UserSpecifiedProtocol", SimTypeInt(signed=False, label="UInt32")), ("Layer3IPI", SimTypeInt(signed=False, label="UInt32")), ("SnapID", SimTypeArray(SimTypeChar(label="Byte"), 5)),)), name="ATM_BLLI_IE", pack=False, align=None),
    "ATM_BROADBAND_BEARER_CAPABILITY_IE": SimStruct(OrderedDict((("BearerClass", SimTypeChar(label="Byte")), ("TrafficType", SimTypeChar(label="Byte")), ("TimingRequirements", SimTypeChar(label="Byte")), ("ClippingSusceptability", SimTypeChar(label="Byte")), ("UserPlaneConnectionConfig", SimTypeChar(label="Byte")),)), name="ATM_BROADBAND_BEARER_CAPABILITY_IE", pack=False, align=None),
    "ATM_CALLING_PARTY_NUMBER_IE": SimStruct(OrderedDict((("ATM_Number", SimTypeRef("ATM_ADDRESS", SimStruct)), ("Presentation_Indication", SimTypeChar(label="Byte")), ("Screening_Indicator", SimTypeChar(label="Byte")),)), name="ATM_CALLING_PARTY_NUMBER_IE", pack=False, align=None),
    "ATM_CAUSE_IE": SimStruct(OrderedDict((("Location", SimTypeChar(label="Byte")), ("Cause", SimTypeChar(label="Byte")), ("DiagnosticsLength", SimTypeChar(label="Byte")), ("Diagnostics", SimTypeArray(SimTypeChar(label="Byte"), 4)),)), name="ATM_CAUSE_IE", pack=False, align=None),
    "ATM_CONNECTION_ID": SimStruct(OrderedDict((("DeviceNumber", SimTypeInt(signed=False, label="UInt32")), ("VPI", SimTypeInt(signed=False, label="UInt32")), ("VCI", SimTypeInt(signed=False, label="UInt32")),)), name="ATM_CONNECTION_ID", pack=False, align=None),
    "ATM_PVC_PARAMS": SimStruct(OrderedDict((("PvcConnectionId", SimTypeRef("ATM_CONNECTION_ID", SimStruct)), ("PvcQos", SimTypeRef("QOS", SimStruct)),)), name="ATM_PVC_PARAMS", pack=False, align=None),
    "ATM_QOS_CLASS_IE": SimStruct(OrderedDict((("QOSClassForward", SimTypeChar(label="Byte")), ("QOSClassBackward", SimTypeChar(label="Byte")),)), name="ATM_QOS_CLASS_IE", pack=False, align=None),
    "ATM_TD": SimStruct(OrderedDict((("PeakCellRate_CLP0", SimTypeInt(signed=False, label="UInt32")), ("PeakCellRate_CLP01", SimTypeInt(signed=False, label="UInt32")), ("SustainableCellRate_CLP0", SimTypeInt(signed=False, label="UInt32")), ("SustainableCellRate_CLP01", SimTypeInt(signed=False, label="UInt32")), ("MaxBurstSize_CLP0", SimTypeInt(signed=False, label="UInt32")), ("MaxBurstSize_CLP01", SimTypeInt(signed=False, label="UInt32")), ("Tagging", SimTypeInt(signed=True, label="Int32")),)), name="ATM_TD", pack=False, align=None),
    "ATM_TRAFFIC_DESCRIPTOR_IE": SimStruct(OrderedDict((("Forward", SimTypeRef("ATM_TD", SimStruct)), ("Backward", SimTypeRef("ATM_TD", SimStruct)), ("BestEffort", SimTypeInt(signed=True, label="Int32")),)), name="ATM_TRAFFIC_DESCRIPTOR_IE", pack=False, align=None),
    "ATM_TRANSIT_NETWORK_SELECTION_IE": SimStruct(OrderedDict((("TypeOfNetworkId", SimTypeChar(label="Byte")), ("NetworkIdPlan", SimTypeChar(label="Byte")), ("NetworkIdLength", SimTypeChar(label="Byte")), ("NetworkId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="ATM_TRANSIT_NETWORK_SELECTION_IE", pack=False, align=None),
    "ATOMIC_CREATE_ECP_CONTEXT": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("InFlags", SimTypeShort(signed=False, label="UInt16")), ("OutFlags", SimTypeShort(signed=False, label="UInt16")), ("ReparseBufferLength", SimTypeShort(signed=False, label="UInt16")), ("ReparseBuffer", SimTypePointer(SimTypeRef("REPARSE_DATA_BUFFER", SimStruct), offset=0)), ("FileSize", SimTypeLongLong(signed=True, label="Int64")), ("ValidDataLength", SimTypeLongLong(signed=True, label="Int64")), ("FileTimestamps", SimTypePointer(SimTypeRef("FILE_TIMESTAMPS", SimStruct), offset=0)), ("FileAttributes", SimTypeInt(signed=False, label="UInt32")), ("UsnSourceInfo", SimTypeInt(signed=False, label="UInt32")), ("Usn", SimTypeLongLong(signed=True, label="Int64")), ("SuppressFileAttributeInheritanceMask", SimTypeInt(signed=False, label="UInt32")), ("InOpFlags", SimTypeInt(signed=False, label="UInt32")), ("OutOpFlags", SimTypeInt(signed=False, label="UInt32")), ("InGenFlags", SimTypeInt(signed=False, label="UInt32")), ("OutGenFlags", SimTypeInt(signed=False, label="UInt32")), ("CaseSensitiveFlagsMask", SimTypeInt(signed=False, label="UInt32")), ("InCaseSensitiveFlags", SimTypeInt(signed=False, label="UInt32")), ("OutCaseSensitiveFlags", SimTypeInt(signed=False, label="UInt32")),)), name="ATOMIC_CREATE_ECP_CONTEXT", pack=False, align=None),
    "ATSCComponentTypeFlags": SimTypeInt(signed=False, label="ATSCComponentTypeFlags"),
    "ATSC_FILTER_OPTIONS": SimStruct(OrderedDict((("fSpecifyEtmId", SimTypeInt(signed=True, label="Int32")), ("EtmId", SimTypeInt(signed=False, label="UInt32")),)), name="ATSC_FILTER_OPTIONS", pack=False, align=None),
    "ATTACHLIST": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("lpLink", SimTypePointer(SimTypeRef("ATTACHLIST", SimStruct), offset=0)), ("lpAttached", SimTypePointer(SimTypeRef("DDRAWI_DDRAWSURFACE_LCL", SimStruct), offset=0)), ("lpIAttached", SimTypePointer(SimTypeRef("DDRAWI_DDRAWSURFACE_INT", SimStruct), offset=0)),)), name="ATTACHLIST", pack=False, align=None),
    "ATTACHMENT_ACTION": SimTypeInt(signed=False, label="ATTACHMENT_ACTION"),
    "ATTACHMENT_PROMPT": SimTypeInt(signed=False, label="ATTACHMENT_PROMPT"),
    "ATTACH_VIRTUAL_DISK_FLAG": SimTypeInt(signed=False, label="ATTACH_VIRTUAL_DISK_FLAG"),
    "ATTACH_VIRTUAL_DISK_PARAMETERS": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="ATTACH_VIRTUAL_DISK_VERSION")), ("Anonymous", SimUnion({"Version1": SimTypeRef("_Version1_e__Struct", SimStruct), "Version2": SimTypeRef("_Version2_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="ATTACH_VIRTUAL_DISK_PARAMETERS", pack=False, align=None),
    "ATTACH_VIRTUAL_DISK_VERSION": SimTypeInt(signed=False, label="ATTACH_VIRTUAL_DISK_VERSION"),
    "ATTENDEE_DISCONNECT_REASON": SimTypeInt(signed=False, label="ATTENDEE_DISCONNECT_REASON"),
    "ATTRIBUTEFILTER": SimTypeInt(signed=False, label="ATTRIBUTEFILTER"),
    "ATTRIBUTEID": SimTypeInt(signed=False, label="ATTRIBUTEID"),
    "ATTRIBUTEINFO": SimTypeInt(signed=False, label="ATTRIBUTEINFO"),
    "ATTRIBUTEPROPERTIES": SimTypeInt(signed=False, label="ATTRIBUTEPROPERTIES"),
    "ATTRIBUTERESTRICTIONS": SimTypeInt(signed=False, label="ATTRIBUTERESTRICTIONS"),
    "ATTRIBUTESYNTAX": SimTypeInt(signed=False, label="ATTRIBUTESYNTAX"),
    "ATTRIBUTE_INFO_1": SimStruct(OrderedDict((("dwJobNumberOfPagesPerSide", SimTypeInt(signed=False, label="UInt32")), ("dwDrvNumberOfPagesPerSide", SimTypeInt(signed=False, label="UInt32")), ("dwNupBorderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwJobPageOrderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwDrvPageOrderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwJobNumberOfCopies", SimTypeInt(signed=False, label="UInt32")), ("dwDrvNumberOfCopies", SimTypeInt(signed=False, label="UInt32")),)), name="ATTRIBUTE_INFO_1", pack=False, align=None),
    "ATTRIBUTE_INFO_2": SimStruct(OrderedDict((("dwJobNumberOfPagesPerSide", SimTypeInt(signed=False, label="UInt32")), ("dwDrvNumberOfPagesPerSide", SimTypeInt(signed=False, label="UInt32")), ("dwNupBorderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwJobPageOrderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwDrvPageOrderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwJobNumberOfCopies", SimTypeInt(signed=False, label="UInt32")), ("dwDrvNumberOfCopies", SimTypeInt(signed=False, label="UInt32")), ("dwColorOptimization", SimTypeInt(signed=False, label="UInt32")),)), name="ATTRIBUTE_INFO_2", pack=False, align=None),
    "ATTRIBUTE_INFO_3": SimStruct(OrderedDict((("dwJobNumberOfPagesPerSide", SimTypeInt(signed=False, label="UInt32")), ("dwDrvNumberOfPagesPerSide", SimTypeInt(signed=False, label="UInt32")), ("dwNupBorderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwJobPageOrderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwDrvPageOrderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwJobNumberOfCopies", SimTypeInt(signed=False, label="UInt32")), ("dwDrvNumberOfCopies", SimTypeInt(signed=False, label="UInt32")), ("dwColorOptimization", SimTypeInt(signed=False, label="UInt32")), ("dmPrintQuality", SimTypeShort(signed=True, label="Int16")), ("dmYResolution", SimTypeShort(signed=True, label="Int16")),)), name="ATTRIBUTE_INFO_3", pack=False, align=None),
    "ATTRIBUTE_INFO_4": SimStruct(OrderedDict((("dwJobNumberOfPagesPerSide", SimTypeInt(signed=False, label="UInt32")), ("dwDrvNumberOfPagesPerSide", SimTypeInt(signed=False, label="UInt32")), ("dwNupBorderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwJobPageOrderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwDrvPageOrderFlags", SimTypeInt(signed=False, label="UInt32")), ("dwJobNumberOfCopies", SimTypeInt(signed=False, label="UInt32")), ("dwDrvNumberOfCopies", SimTypeInt(signed=False, label="UInt32")), ("dwColorOptimization", SimTypeInt(signed=False, label="UInt32")), ("dmPrintQuality", SimTypeShort(signed=True, label="Int16")), ("dmYResolution", SimTypeShort(signed=True, label="Int16")), ("dwDuplexFlags", SimTypeInt(signed=False, label="UInt32")), ("dwNupDirection", SimTypeInt(signed=False, label="UInt32")), ("dwBookletFlags", SimTypeInt(signed=False, label="UInt32")), ("dwScalingPercentX", SimTypeInt(signed=False, label="UInt32")), ("dwScalingPercentY", SimTypeInt(signed=False, label="UInt32")),)), name="ATTRIBUTE_INFO_4", pack=False, align=None),
    "ATTRIBUTE_TYPE": SimTypeInt(signed=False, label="ATTRIBUTE_TYPE"),
    "AT_ENUM": SimStruct(OrderedDict((("JobId", SimTypeInt(signed=False, label="UInt32")), ("JobTime", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("DaysOfMonth", SimTypeInt(signed=False, label="UInt32")), ("DaysOfWeek", SimTypeChar(label="Byte")), ("Flags", SimTypeChar(label="Byte")), ("Command", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="AT_ENUM", pack=False, align=None),
    "AT_INFO": SimStruct(OrderedDict((("JobTime", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("DaysOfMonth", SimTypeInt(signed=False, label="UInt32")), ("DaysOfWeek", SimTypeChar(label="Byte")), ("Flags", SimTypeChar(label="Byte")), ("Command", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="AT_INFO", pack=False, align=None),
    "AUDCLNT_SHAREMODE": SimTypeInt(signed=False, label="AUDCLNT_SHAREMODE"),
    "AUDCLNT_STREAMOPTIONS": SimTypeInt(signed=False, label="AUDCLNT_STREAMOPTIONS"),
    "AUDIOCLIENT_ACTIVATION_PARAMS": SimStruct(OrderedDict((("ActivationType", SimTypeInt(signed=False, label="AUDIOCLIENT_ACTIVATION_TYPE")), ("Anonymous", SimUnion({"ProcessLoopbackParams": SimTypeRef("AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS", SimStruct)}, name="<anon>", label="None")),)), name="AUDIOCLIENT_ACTIVATION_PARAMS", pack=False, align=None),
    "AUDIOCLIENT_ACTIVATION_TYPE": SimTypeInt(signed=False, label="AUDIOCLIENT_ACTIVATION_TYPE"),
    "AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS": SimStruct(OrderedDict((("TargetProcessId", SimTypeInt(signed=False, label="UInt32")), ("ProcessLoopbackMode", SimTypeInt(signed=False, label="PROCESS_LOOPBACK_MODE")),)), name="AUDIOCLIENT_PROCESS_LOOPBACK_PARAMS", pack=False, align=None),
    "AUDIODESCRIPTION": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("Enabled", SimTypeInt(signed=True, label="Int32")), ("Locale", SimTypeInt(signed=False, label="UInt32")),)), name="AUDIODESCRIPTION", pack=False, align=None),
    "AUDIOFILE_AF10WAVEFORMAT": SimStruct(OrderedDict((("wfx", SimTypeRef("WAVEFORMATEX", SimStruct)),)), name="AUDIOFILE_AF10WAVEFORMAT", pack=False, align=None),
    "AUDIOFILE_AF36WAVEFORMAT": SimStruct(OrderedDict((("wfx", SimTypeRef("WAVEFORMATEX", SimStruct)),)), name="AUDIOFILE_AF36WAVEFORMAT", pack=False, align=None),
    "AUDIOPOSTURE_ORIENTATION": SimTypeInt(signed=False, label="AUDIOPOSTURE_ORIENTATION"),
    "AUDIORESOURCEMANAGEMENT_RESOURCEGROUP": SimStruct(OrderedDict((("ResourceGroupAcquired", SimTypeInt(signed=True, label="Int32")), ("ResourceGroupName", SimTypeArray(SimTypeChar(label="Char"), 256)),)), name="AUDIORESOURCEMANAGEMENT_RESOURCEGROUP", pack=False, align=None),
    "AUDIO_CURVE_TYPE": SimTypeInt(signed=False, label="AUDIO_CURVE_TYPE"),
    "AUDIO_DUCKING_OPTIONS": SimTypeInt(signed=False, label="AUDIO_DUCKING_OPTIONS"),
    "AUDIO_EFFECT": SimStruct(OrderedDict((("id", SimTypeBottom(label="Guid")), ("canSetState", SimTypeInt(signed=True, label="Int32")), ("state", SimTypeInt(signed=False, label="AUDIO_EFFECT_STATE")),)), name="AUDIO_EFFECT", pack=False, align=None),
    "AUDIO_EFFECT_STATE": SimTypeInt(signed=False, label="AUDIO_EFFECT_STATE"),
    "AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR": SimStruct(OrderedDict((("device", SimTypeBottom(label="IMMDevice")),)), name="AUDIO_ENDPOINT_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR", pack=False, align=None),
    "AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION": SimStruct(OrderedDict((("endpoint", SimTypeBottom(label="IMMDevice")), ("propertyStore", SimTypeBottom(label="IPropertyStore")), ("propertyKey", SimTypeRef("PROPERTYKEY", SimStruct)),)), name="AUDIO_ENDPOINT_PROPERTY_CHANGE_NOTIFICATION", pack=False, align=None),
    "AUDIO_ENDPOINT_SHARED_CREATE_PARAMS": SimStruct(OrderedDict((("u32Size", SimTypeInt(signed=False, label="UInt32")), ("u32TSSessionId", SimTypeInt(signed=False, label="UInt32")), ("targetEndpointConnectorType", SimTypeInt(signed=False, label="EndpointConnectorType")), ("wfxDeviceFormat", SimTypeRef("WAVEFORMATEX", SimStruct)),)), name="AUDIO_ENDPOINT_SHARED_CREATE_PARAMS", pack=False, align=None),
    "AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR": SimStruct(OrderedDict((("device", SimTypeBottom(label="IMMDevice")),)), name="AUDIO_ENDPOINT_VOLUME_APO_NOTIFICATION_DESCRIPTOR", pack=False, align=None),
    "AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION": SimStruct(OrderedDict((("endpoint", SimTypeBottom(label="IMMDevice")), ("volume", SimTypePointer(SimTypeRef("AUDIO_VOLUME_NOTIFICATION_DATA", SimStruct), offset=0)),)), name="AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION", pack=False, align=None),
    "AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION2": SimStruct(OrderedDict((("endpoint", SimTypeBottom(label="IMMDevice")), ("volume", SimTypePointer(SimTypeRef("AUDIO_VOLUME_NOTIFICATION_DATA2", SimStruct), offset=0)),)), name="AUDIO_ENDPOINT_VOLUME_CHANGE_NOTIFICATION2", pack=False, align=None),
    "AUDIO_FLOW_TYPE": SimTypeInt(signed=False, label="AUDIO_FLOW_TYPE"),
    "AUDIO_MICROPHONE_BOOST_APO_NOTIFICATION_DESCRIPTOR": SimStruct(OrderedDict((("device", SimTypeBottom(label="IMMDevice")),)), name="AUDIO_MICROPHONE_BOOST_APO_NOTIFICATION_DESCRIPTOR", pack=False, align=None),
    "AUDIO_MICROPHONE_BOOST_NOTIFICATION": SimStruct(OrderedDict((("endpoint", SimTypeBottom(label="IMMDevice")), ("eventContext", SimTypeBottom(label="Guid")), ("microphoneBoostEnabled", SimTypeInt(signed=True, label="Int32")), ("levelInDb", SimTypeFloat(size=32)), ("levelMinInDb", SimTypeFloat(size=32)), ("levelMaxInDb", SimTypeFloat(size=32)), ("levelStepInDb", SimTypeFloat(size=32)), ("muteSupported", SimTypeInt(signed=True, label="Int32")), ("mute", SimTypeInt(signed=True, label="Int32")),)), name="AUDIO_MICROPHONE_BOOST_NOTIFICATION", pack=False, align=None),
    "AUDIO_STREAM_CATEGORY": SimTypeInt(signed=False, label="AUDIO_STREAM_CATEGORY"),
    "AUDIO_STREAM_CONFIG_CAPS": SimStruct(OrderedDict((("guid", SimTypeBottom(label="Guid")), ("MinimumChannels", SimTypeInt(signed=False, label="UInt32")), ("MaximumChannels", SimTypeInt(signed=False, label="UInt32")), ("ChannelsGranularity", SimTypeInt(signed=False, label="UInt32")), ("MinimumBitsPerSample", SimTypeInt(signed=False, label="UInt32")), ("MaximumBitsPerSample", SimTypeInt(signed=False, label="UInt32")), ("BitsPerSampleGranularity", SimTypeInt(signed=False, label="UInt32")), ("MinimumSampleFrequency", SimTypeInt(signed=False, label="UInt32")), ("MaximumSampleFrequency", SimTypeInt(signed=False, label="UInt32")), ("SampleFrequencyGranularity", SimTypeInt(signed=False, label="UInt32")),)), name="AUDIO_STREAM_CONFIG_CAPS", pack=False, align=None),
    "AUDIO_SYSTEMEFFECT": SimStruct(OrderedDict((("id", SimTypeBottom(label="Guid")), ("canSetState", SimTypeInt(signed=True, label="Int32")), ("state", SimTypeInt(signed=False, label="AUDIO_SYSTEMEFFECT_STATE")),)), name="AUDIO_SYSTEMEFFECT", pack=False, align=None),
    "AUDIO_SYSTEMEFFECTS_PROPERTYSTORE_TYPE": SimTypeInt(signed=False, label="AUDIO_SYSTEMEFFECTS_PROPERTYSTORE_TYPE"),
    "AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR": SimStruct(OrderedDict((("device", SimTypeBottom(label="IMMDevice")), ("propertyStoreContext", SimTypeBottom(label="Guid")),)), name="AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_APO_NOTIFICATION_DESCRIPTOR", pack=False, align=None),
    "AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION": SimStruct(OrderedDict((("endpoint", SimTypeBottom(label="IMMDevice")), ("propertyStoreContext", SimTypeBottom(label="Guid")), ("propertyStoreType", SimTypeInt(signed=False, label="AUDIO_SYSTEMEFFECTS_PROPERTYSTORE_TYPE")), ("propertyStore", SimTypeBottom(label="IPropertyStore")), ("propertyKey", SimTypeRef("PROPERTYKEY", SimStruct)),)), name="AUDIO_SYSTEMEFFECTS_PROPERTY_CHANGE_NOTIFICATION", pack=False, align=None),
    "AUDIO_SYSTEMEFFECT_STATE": SimTypeInt(signed=False, label="AUDIO_SYSTEMEFFECT_STATE"),
    "AUDIO_VOLUME_NOTIFICATION_DATA": SimStruct(OrderedDict((("guidEventContext", SimTypeBottom(label="Guid")), ("bMuted", SimTypeInt(signed=True, label="Int32")), ("fMasterVolume", SimTypeFloat(size=32)), ("nChannels", SimTypeInt(signed=False, label="UInt32")), ("afChannelVolumes", SimTypePointer(SimTypeFloat(size=32), offset=0)),)), name="AUDIO_VOLUME_NOTIFICATION_DATA", pack=False, align=None),
    "AUDIO_VOLUME_NOTIFICATION_DATA2": SimStruct(OrderedDict((("notificationData", SimTypePointer(SimTypeRef("AUDIO_VOLUME_NOTIFICATION_DATA", SimStruct), offset=0)), ("masterVolumeInDb", SimTypeFloat(size=32)), ("volumeMinInDb", SimTypeFloat(size=32)), ("volumeMaxInDb", SimTypeFloat(size=32)), ("volumeIncrementInDb", SimTypeFloat(size=32)), ("step", SimTypeInt(signed=False, label="UInt32")), ("stepCount", SimTypeInt(signed=False, label="UInt32")), ("channelVolumesInDb", SimTypePointer(SimTypeFloat(size=32), offset=0)),)), name="AUDIO_VOLUME_NOTIFICATION_DATA2", pack=False, align=None),
    "AUDIT_ENTRY": SimStruct(OrderedDict((("ae_len", SimTypeInt(signed=False, label="UInt32")), ("ae_reserved", SimTypeInt(signed=False, label="UInt32")), ("ae_time", SimTypeInt(signed=False, label="UInt32")), ("ae_type", SimTypeInt(signed=False, label="UInt32")), ("ae_data_offset", SimTypeInt(signed=False, label="UInt32")), ("ae_data_size", SimTypeInt(signed=False, label="UInt32")),)), name="AUDIT_ENTRY", pack=False, align=None),
    "AUDIT_EVENT_TYPE": SimTypeInt(signed=False, label="AUDIT_EVENT_TYPE"),
    "AUDIT_IP_ADDRESS": SimStruct(OrderedDict((("pIpAddress", SimTypeArray(SimTypeChar(label="Byte"), 128)),)), name="AUDIT_IP_ADDRESS", pack=False, align=None),
    "AUDIT_OBJECT_TYPE": SimStruct(OrderedDict((("ObjectType", SimTypeBottom(label="Guid")), ("Flags", SimTypeShort(signed=False, label="UInt16")), ("Level", SimTypeShort(signed=False, label="UInt16")), ("AccessMask", SimTypeInt(signed=False, label="UInt32")),)), name="AUDIT_OBJECT_TYPE", pack=False, align=None),
    "AUDIT_OBJECT_TYPES": SimStruct(OrderedDict((("Count", SimTypeShort(signed=False, label="UInt16")), ("Flags", SimTypeShort(signed=False, label="UInt16")), ("pObjectTypes", SimTypePointer(SimTypeRef("AUDIT_OBJECT_TYPE", SimStruct), offset=0)),)), name="AUDIT_OBJECT_TYPES", pack=False, align=None),
    "AUDIT_PARAM": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="AUDIT_PARAM_TYPE")), ("Length", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("Anonymous1", SimUnion({"Data0": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "String": SimTypePointer(SimTypeChar(label="Char"), offset=0), "u": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "psid": SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), "pguid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "LogonId_LowPart": SimTypeInt(signed=False, label="UInt32"), "pObjectTypes": SimTypePointer(SimTypeRef("AUDIT_OBJECT_TYPES", SimStruct), offset=0), "pIpAddress": SimTypePointer(SimTypeRef("AUDIT_IP_ADDRESS", SimStruct), offset=0)}, name="<anon>", label="None")), ("Anonymous2", SimUnion({"Data1": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "LogonId_HighPart": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None")),)), name="AUDIT_PARAM", pack=False, align=None),
    "AUDIT_PARAMS": SimStruct(OrderedDict((("Length", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("Count", SimTypeShort(signed=False, label="UInt16")), ("Parameters", SimTypePointer(SimTypeRef("AUDIT_PARAM", SimStruct), offset=0)),)), name="AUDIT_PARAMS", pack=False, align=None),
    "AUDIT_PARAM_TYPE": SimTypeInt(signed=False, label="AUDIT_PARAM_TYPE"),
    "AUDIT_POLICY_INFORMATION": SimStruct(OrderedDict((("AuditSubCategoryGuid", SimTypeBottom(label="Guid")), ("AuditingInformation", SimTypeInt(signed=False, label="UInt32")), ("AuditCategoryGuid", SimTypeBottom(label="Guid")),)), name="AUDIT_POLICY_INFORMATION", pack=False, align=None),
    "AUTHENTICATEF": SimTypeInt(signed=False, label="AUTHENTICATEF"),
    "AUTHENTICATEINFO": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeInt(signed=False, label="UInt32")),)), name="AUTHENTICATEINFO", pack=False, align=None),
    "AUTHENTICATION_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("atAuthenticationType", SimTypeInt(signed=False, label="AUTH_TYPE")), ("pcwszUser", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pcwszPassword", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="AUTHENTICATION_INFO", pack=False, align=None),
    "AUTHENTICATION_LEVEL": SimTypeInt(signed=False, label="AUTHENTICATION_LEVEL"),
    "AUTHENTICATION_REQUIREMENTS": SimTypeInt(signed=False, label="AUTHENTICATION_REQUIREMENTS"),
    "AUTHENTICATION_TYPE": SimTypeInt(signed=False, label="AUTHENTICATION_TYPE"),
    "AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwRegPolicySettings", SimTypeInt(signed=False, label="UInt32")), ("pSignerInfo", SimTypePointer(SimTypeRef("CMSG_SIGNER_INFO", SimStruct), offset=0)),)), name="AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA", pack=False, align=None),
    "AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("fCommercial", SimTypeInt(signed=True, label="Int32")),)), name="AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS", pack=False, align=None),
    "AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwRegPolicySettings", SimTypeInt(signed=False, label="UInt32")), ("fCommercial", SimTypeInt(signed=True, label="Int32")),)), name="AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA", pack=False, align=None),
    "AUTHNEXTSTEP": SimTypeInt(signed=False, label="AUTHNEXTSTEP"),
    "AUTHZ_ACCESS_CHECK_FLAGS": SimTypeInt(signed=False, label="AUTHZ_ACCESS_CHECK_FLAGS"),
    "AUTHZ_ACCESS_CHECK_RESULTS_HANDLE": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "AUTHZ_ACCESS_REPLY": SimStruct(OrderedDict((("ResultListLength", SimTypeInt(signed=False, label="UInt32")), ("GrantedAccessMask", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("SaclEvaluationResults", SimTypePointer(SimTypeInt(signed=False, label="AUTHZ_GENERATE_RESULTS"), offset=0)), ("Error", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="AUTHZ_ACCESS_REPLY", pack=False, align=None),
    "AUTHZ_ACCESS_REQUEST": SimStruct(OrderedDict((("DesiredAccess", SimTypeInt(signed=False, label="UInt32")), ("PrincipalSelfSid", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ObjectTypeList", SimTypePointer(SimTypeRef("OBJECT_TYPE_LIST", SimStruct), offset=0)), ("ObjectTypeListLength", SimTypeInt(signed=False, label="UInt32")), ("OptionalArguments", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="AUTHZ_ACCESS_REQUEST", pack=False, align=None),
    "AUTHZ_AUDIT_EVENT_HANDLE": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "AUTHZ_AUDIT_EVENT_INFORMATION_CLASS": SimTypeInt(signed=False, label="AUTHZ_AUDIT_EVENT_INFORMATION_CLASS"),
    "AUTHZ_AUDIT_EVENT_TYPE_HANDLE": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "AUTHZ_AUDIT_EVENT_TYPE_LEGACY": SimStruct(OrderedDict((("CategoryId", SimTypeShort(signed=False, label="UInt16")), ("AuditId", SimTypeShort(signed=False, label="UInt16")), ("ParameterCount", SimTypeShort(signed=False, label="UInt16")),)), name="AUTHZ_AUDIT_EVENT_TYPE_LEGACY", pack=False, align=None),
    "AUTHZ_AUDIT_EVENT_TYPE_OLD": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("RefCount", SimTypeInt(signed=True, label="Int32")), ("hAudit", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("LinkId", SimTypeRef("LUID", SimStruct)), ("u", SimUnion({"Legacy": SimTypeRef("AUTHZ_AUDIT_EVENT_TYPE_LEGACY", SimStruct)}, name="<anon>", label="None")),)), name="AUTHZ_AUDIT_EVENT_TYPE_OLD", pack=False, align=None),
    "AUTHZ_AUDIT_EVENT_TYPE_UNION": SimUnion({"Legacy": SimTypeRef("AUTHZ_AUDIT_EVENT_TYPE_LEGACY", SimStruct)}, name="<anon>", label="None"),
    "AUTHZ_CAP_CHANGE_SUBSCRIPTION_HANDLE": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "AUTHZ_CLIENT_CONTEXT_HANDLE": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "AUTHZ_CONTEXT_INFORMATION_CLASS": SimTypeInt(signed=False, label="AUTHZ_CONTEXT_INFORMATION_CLASS"),
    "AUTHZ_GENERATE_RESULTS": SimTypeInt(signed=False, label="AUTHZ_GENERATE_RESULTS"),
    "AUTHZ_INITIALIZE_OBJECT_ACCESS_AUDIT_EVENT_FLAGS": SimTypeInt(signed=False, label="AUTHZ_INITIALIZE_OBJECT_ACCESS_AUDIT_EVENT_FLAGS"),
    "AUTHZ_INIT_INFO": SimStruct(OrderedDict((("version", SimTypeShort(signed=False, label="UInt16")), ("szResourceManagerName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pfnDynamicAccessCheck", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("ACE_HEADER", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hAuthzClientContext", "pAce", "pArgs", "pbAceApplicable"]), offset=0)), ("pfnComputeDynamicGroups", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("SID_AND_ATTRIBUTES", SimStruct), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("SID_AND_ATTRIBUTES", SimStruct), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hAuthzClientContext", "Args", "pSidAttrArray", "pSidCount", "pRestrictedSidAttrArray", "pRestrictedSidCount"]), offset=0)), ("pfnFreeDynamicGroups", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("SID_AND_ATTRIBUTES", SimStruct), offset=0)], SimTypeBottom(label="Void"), arg_names=["pSidAttrArray"]), offset=0)), ("pfnGetCentralAccessPolicy", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hAuthzClientContext", "capid", "pArgs", "pCentralAccessPolicyApplicable", "ppCentralAccessPolicy"]), offset=0)), ("pfnFreeCentralAccessPolicy", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pCentralAccessPolicy"]), offset=0)),)), name="AUTHZ_INIT_INFO", pack=False, align=None),
    "AUTHZ_REGISTRATION_OBJECT_TYPE_NAME_OFFSET": SimStruct(OrderedDict((("szObjectTypeName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwOffset", SimTypeInt(signed=False, label="UInt32")),)), name="AUTHZ_REGISTRATION_OBJECT_TYPE_NAME_OFFSET", pack=False, align=None),
    "AUTHZ_RESOURCE_MANAGER_FLAGS": SimTypeInt(signed=False, label="AUTHZ_RESOURCE_MANAGER_FLAGS"),
    "AUTHZ_RESOURCE_MANAGER_HANDLE": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "AUTHZ_RPC_INIT_INFO_CLIENT": SimStruct(OrderedDict((("version", SimTypeShort(signed=False, label="UInt16")), ("ObjectUuid", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ProtSeq", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("NetworkAddr", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Endpoint", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Options", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ServerSpn", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="AUTHZ_RPC_INIT_INFO_CLIENT", pack=False, align=None),
    "AUTHZ_SECURITY_ATTRIBUTES_INFORMATION": SimStruct(OrderedDict((("Version", SimTypeShort(signed=False, label="UInt16")), ("Reserved", SimTypeShort(signed=False, label="UInt16")), ("AttributeCount", SimTypeInt(signed=False, label="UInt32")), ("Attribute", SimUnion({"pAttributeV1": SimTypePointer(SimTypeRef("AUTHZ_SECURITY_ATTRIBUTE_V1", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="AUTHZ_SECURITY_ATTRIBUTES_INFORMATION", pack=False, align=None),
    "AUTHZ_SECURITY_ATTRIBUTE_FLAGS": SimTypeInt(signed=False, label="AUTHZ_SECURITY_ATTRIBUTE_FLAGS"),
    "AUTHZ_SECURITY_ATTRIBUTE_FQBN_VALUE": SimStruct(OrderedDict((("Version", SimTypeLongLong(signed=False, label="UInt64")), ("pName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="AUTHZ_SECURITY_ATTRIBUTE_FQBN_VALUE", pack=False, align=None),
    "AUTHZ_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE": SimStruct(OrderedDict((("pValue", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ValueLength", SimTypeInt(signed=False, label="UInt32")),)), name="AUTHZ_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE", pack=False, align=None),
    "AUTHZ_SECURITY_ATTRIBUTE_OPERATION": SimTypeInt(signed=False, label="AUTHZ_SECURITY_ATTRIBUTE_OPERATION"),
    "AUTHZ_SECURITY_ATTRIBUTE_V1": SimStruct(OrderedDict((("pName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ValueType", SimTypeShort(signed=False, label="UInt16")), ("Reserved", SimTypeShort(signed=False, label="UInt16")), ("Flags", SimTypeInt(signed=False, label="AUTHZ_SECURITY_ATTRIBUTE_FLAGS")), ("ValueCount", SimTypeInt(signed=False, label="UInt32")), ("Values", SimUnion({"pInt64": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "pUint64": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "ppString": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "pFqbn": SimTypePointer(SimTypeRef("AUTHZ_SECURITY_ATTRIBUTE_FQBN_VALUE", SimStruct), offset=0), "pOctetString": SimTypePointer(SimTypeRef("AUTHZ_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="AUTHZ_SECURITY_ATTRIBUTE_V1", pack=False, align=None),
    "AUTHZ_SECURITY_EVENT_PROVIDER_HANDLE": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "AUTHZ_SID_OPERATION": SimTypeInt(signed=False, label="AUTHZ_SID_OPERATION"),
    "AUTHZ_SOURCE_SCHEMA_REGISTRATION": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("szEventSourceName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("szEventMessageFile", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("szEventSourceXmlSchemaFile", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("szEventAccessStringsFile", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("szExecutableImagePath", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Anonymous", SimUnion({"pReserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pProviderGuid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="<anon>", label="None")), ("dwObjectTypeNameCount", SimTypeInt(signed=False, label="UInt32")), ("ObjectTypeNames", SimTypePointer(SimTypeRef("AUTHZ_REGISTRATION_OBJECT_TYPE_NAME_OFFSET", SimStruct), offset=0)),)), name="AUTHZ_SOURCE_SCHEMA_REGISTRATION", pack=False, align=None),
    "AUTH_TYPE": SimTypeInt(signed=False, label="AUTH_TYPE"),
    "AUTH_VALIDATION_EX": SimStruct(OrderedDict((("Header", SimTypeRef("MPRAPI_OBJECT_HEADER", SimStruct)), ("hRasConnection", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("wszUserName", SimTypeArray(SimTypeChar(label="Char"), 257)), ("wszLogonDomain", SimTypeArray(SimTypeChar(label="Char"), 16)), ("AuthInfoSize", SimTypeInt(signed=False, label="UInt32")), ("AuthInfo", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="AUTH_VALIDATION_EX", pack=False, align=None),
    "AUTOCOMPLETELISTOPTIONS": SimTypeInt(signed=False, label="AUTOCOMPLETELISTOPTIONS"),
    "AUTOCOMPLETEOPTIONS": SimTypeInt(signed=False, label="AUTOCOMPLETEOPTIONS"),
    "AUTO_PROXY_SCRIPT_BUFFER": SimStruct(OrderedDict((("dwStructSize", SimTypeInt(signed=False, label="UInt32")), ("lpszScriptBuffer", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwScriptBufferSize", SimTypeInt(signed=False, label="UInt32")),)), name="AUTO_PROXY_SCRIPT_BUFFER", pack=False, align=None),
    "AUTO_SCROLL_DATA": SimStruct(OrderedDict((("iNextSample", SimTypeInt(signed=True, label="Int32")), ("dwLastScroll", SimTypeInt(signed=False, label="UInt32")), ("bFull", SimTypeInt(signed=True, label="Int32")), ("pts", SimTypeArray(SimTypeRef("POINT", SimStruct), 3)), ("dwTimes", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 3)),)), name="AUTO_SCROLL_DATA", pack=False, align=None),
    "AUXCAPS2A": SimStruct(OrderedDict((("wMid", SimTypeShort(signed=False, label="UInt16")), ("wPid", SimTypeShort(signed=False, label="UInt16")), ("vDriverVersion", SimTypeInt(signed=False, label="UInt32")), ("szPname", SimTypeArray(SimTypeChar(label="SByte"), 32)), ("wTechnology", SimTypeShort(signed=False, label="UInt16")), ("wReserved1", SimTypeShort(signed=False, label="UInt16")), ("dwSupport", SimTypeInt(signed=False, label="UInt32")), ("ManufacturerGuid", SimTypeBottom(label="Guid")), ("ProductGuid", SimTypeBottom(label="Guid")), ("NameGuid", SimTypeBottom(label="Guid")),)), name="AUXCAPS2A", pack=False, align=None),
    "AUXCAPS2W": SimStruct(OrderedDict((("wMid", SimTypeShort(signed=False, label="UInt16")), ("wPid", SimTypeShort(signed=False, label="UInt16")), ("vDriverVersion", SimTypeInt(signed=False, label="UInt32")), ("szPname", SimTypeArray(SimTypeChar(label="Char"), 32)), ("wTechnology", SimTypeShort(signed=False, label="UInt16")), ("wReserved1", SimTypeShort(signed=False, label="UInt16")), ("dwSupport", SimTypeInt(signed=False, label="UInt32")), ("ManufacturerGuid", SimTypeBottom(label="Guid")), ("ProductGuid", SimTypeBottom(label="Guid")), ("NameGuid", SimTypeBottom(label="Guid")),)), name="AUXCAPS2W", pack=False, align=None),
    "AUXCAPSA": SimStruct(OrderedDict((("wMid", SimTypeShort(signed=False, label="UInt16")), ("wPid", SimTypeShort(signed=False, label="UInt16")), ("vDriverVersion", SimTypeInt(signed=False, label="UInt32")), ("szPname", SimTypeArray(SimTypeChar(label="SByte"), 32)), ("wTechnology", SimTypeShort(signed=False, label="UInt16")), ("wReserved1", SimTypeShort(signed=False, label="UInt16")), ("dwSupport", SimTypeInt(signed=False, label="UInt32")),)), name="AUXCAPSA", pack=False, align=None),
    "AUXCAPSW": SimStruct(OrderedDict((("wMid", SimTypeShort(signed=False, label="UInt16")), ("wPid", SimTypeShort(signed=False, label="UInt16")), ("vDriverVersion", SimTypeInt(signed=False, label="UInt32")), ("szPname", SimTypeArray(SimTypeChar(label="Char"), 32)), ("wTechnology", SimTypeShort(signed=False, label="UInt16")), ("wReserved1", SimTypeShort(signed=False, label="UInt16")), ("dwSupport", SimTypeInt(signed=False, label="UInt32")),)), name="AUXCAPSW", pack=False, align=None),
    "AVICOMPRESSOPTIONS": SimStruct(OrderedDict((("fccType", SimTypeInt(signed=False, label="UInt32")), ("fccHandler", SimTypeInt(signed=False, label="UInt32")), ("dwKeyFrameEvery", SimTypeInt(signed=False, label="UInt32")), ("dwQuality", SimTypeInt(signed=False, label="UInt32")), ("dwBytesPerSecond", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("lpFormat", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cbFormat", SimTypeInt(signed=False, label="UInt32")), ("lpParms", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cbParms", SimTypeInt(signed=False, label="UInt32")), ("dwInterleaveEvery", SimTypeInt(signed=False, label="UInt32")),)), name="AVICOMPRESSOPTIONS", pack=False, align=None),
    "AVIEXTHEADER": SimStruct(OrderedDict((("fcc", SimTypeInt(signed=False, label="UInt32")), ("cb", SimTypeInt(signed=False, label="UInt32")), ("dwGrandFrames", SimTypeInt(signed=False, label="UInt32")), ("dwFuture", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 61)),)), name="AVIEXTHEADER", pack=False, align=None),
    "AVIFIELDINDEX": SimStruct(OrderedDict((("fcc", SimTypeInt(signed=False, label="UInt32")), ("cb", SimTypeInt(signed=False, label="UInt32")), ("wLongsPerEntry", SimTypeShort(signed=False, label="UInt16")), ("bIndexSubType", SimTypeChar(label="Byte")), ("bIndexType", SimTypeChar(label="Byte")), ("nEntriesInUse", SimTypeInt(signed=False, label="UInt32")), ("dwChunkId", SimTypeInt(signed=False, label="UInt32")), ("qwBaseOffset", SimTypeLongLong(signed=False, label="UInt64")), ("dwReserved3", SimTypeInt(signed=False, label="UInt32")), ("aIndex", SimTypePointer(SimTypeRef("_avifieldindex_entry", SimStruct), offset=0)),)), name="AVIFIELDINDEX", pack=False, align=None),
    "AVIFILEINFOA": SimStruct(OrderedDict((("dwMaxBytesPerSec", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwCaps", SimTypeInt(signed=False, label="UInt32")), ("dwStreams", SimTypeInt(signed=False, label="UInt32")), ("dwSuggestedBufferSize", SimTypeInt(signed=False, label="UInt32")), ("dwWidth", SimTypeInt(signed=False, label="UInt32")), ("dwHeight", SimTypeInt(signed=False, label="UInt32")), ("dwScale", SimTypeInt(signed=False, label="UInt32")), ("dwRate", SimTypeInt(signed=False, label="UInt32")), ("dwLength", SimTypeInt(signed=False, label="UInt32")), ("dwEditCount", SimTypeInt(signed=False, label="UInt32")), ("szFileType", SimTypeArray(SimTypeChar(label="SByte"), 64)),)), name="AVIFILEINFOA", pack=False, align=None),
    "AVIFILEINFOW": SimStruct(OrderedDict((("dwMaxBytesPerSec", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwCaps", SimTypeInt(signed=False, label="UInt32")), ("dwStreams", SimTypeInt(signed=False, label="UInt32")), ("dwSuggestedBufferSize", SimTypeInt(signed=False, label="UInt32")), ("dwWidth", SimTypeInt(signed=False, label="UInt32")), ("dwHeight", SimTypeInt(signed=False, label="UInt32")), ("dwScale", SimTypeInt(signed=False, label="UInt32")), ("dwRate", SimTypeInt(signed=False, label="UInt32")), ("dwLength", SimTypeInt(signed=False, label="UInt32")), ("dwEditCount", SimTypeInt(signed=False, label="UInt32")), ("szFileType", SimTypeArray(SimTypeChar(label="Char"), 64)),)), name="AVIFILEINFOW", pack=False, align=None),
    "AVIINDEXENTRY": SimStruct(OrderedDict((("ckid", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwChunkOffset", SimTypeInt(signed=False, label="UInt32")), ("dwChunkLength", SimTypeInt(signed=False, label="UInt32")),)), name="AVIINDEXENTRY", pack=False, align=None),
    "AVIMAINHEADER": SimStruct(OrderedDict((("fcc", SimTypeInt(signed=False, label="UInt32")), ("cb", SimTypeInt(signed=False, label="UInt32")), ("dwMicroSecPerFrame", SimTypeInt(signed=False, label="UInt32")), ("dwMaxBytesPerSec", SimTypeInt(signed=False, label="UInt32")), ("dwPaddingGranularity", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwTotalFrames", SimTypeInt(signed=False, label="UInt32")), ("dwInitialFrames", SimTypeInt(signed=False, label="UInt32")), ("dwStreams", SimTypeInt(signed=False, label="UInt32")), ("dwSuggestedBufferSize", SimTypeInt(signed=False, label="UInt32")), ("dwWidth", SimTypeInt(signed=False, label="UInt32")), ("dwHeight", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)),)), name="AVIMAINHEADER", pack=False, align=None),
    "AVIMETAINDEX": SimStruct(OrderedDict((("fcc", SimTypeInt(signed=False, label="UInt32")), ("cb", SimTypeInt(signed=False, label="UInt32")), ("wLongsPerEntry", SimTypeShort(signed=False, label="UInt16")), ("bIndexSubType", SimTypeChar(label="Byte")), ("bIndexType", SimTypeChar(label="Byte")), ("nEntriesInUse", SimTypeInt(signed=False, label="UInt32")), ("dwChunkId", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 3)), ("adwIndex", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="AVIMETAINDEX", pack=False, align=None),
    "AVIOLDINDEX": SimStruct(OrderedDict((("fcc", SimTypeInt(signed=False, label="UInt32")), ("cb", SimTypeInt(signed=False, label="UInt32")), ("aIndex", SimTypePointer(SimTypeRef("_avioldindex_entry", SimStruct), offset=0)),)), name="AVIOLDINDEX", pack=False, align=None),
    "AVIPALCHANGE": SimStruct(OrderedDict((("bFirstEntry", SimTypeChar(label="Byte")), ("bNumEntries", SimTypeChar(label="Byte")), ("wFlags", SimTypeShort(signed=False, label="UInt16")), ("peNew", SimTypePointer(SimTypeRef("PALETTEENTRY", SimStruct), offset=0)),)), name="AVIPALCHANGE", pack=False, align=None),
    "AVISAVECALLBACK": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0),
    "AVISTDINDEX": SimStruct(OrderedDict((("fcc", SimTypeInt(signed=False, label="UInt32")), ("cb", SimTypeInt(signed=False, label="UInt32")), ("wLongsPerEntry", SimTypeShort(signed=False, label="UInt16")), ("bIndexSubType", SimTypeChar(label="Byte")), ("bIndexType", SimTypeChar(label="Byte")), ("nEntriesInUse", SimTypeInt(signed=False, label="UInt32")), ("dwChunkId", SimTypeInt(signed=False, label="UInt32")), ("qwBaseOffset", SimTypeLongLong(signed=False, label="UInt64")), ("dwReserved_3", SimTypeInt(signed=False, label="UInt32")), ("aIndex", SimTypeArray(SimTypeRef("AVISTDINDEX_ENTRY", SimStruct), 2044)),)), name="AVISTDINDEX", pack=False, align=None),
    "AVISTDINDEX_ENTRY": SimStruct(OrderedDict((("dwOffset", SimTypeInt(signed=False, label="UInt32")), ("dwSize", SimTypeInt(signed=False, label="UInt32")),)), name="AVISTDINDEX_ENTRY", pack=False, align=None),
    "AVISTREAMHEADER": SimStruct(OrderedDict((("fcc", SimTypeInt(signed=False, label="UInt32")), ("cb", SimTypeInt(signed=False, label="UInt32")), ("fccType", SimTypeInt(signed=False, label="UInt32")), ("fccHandler", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("wPriority", SimTypeShort(signed=False, label="UInt16")), ("wLanguage", SimTypeShort(signed=False, label="UInt16")), ("dwInitialFrames", SimTypeInt(signed=False, label="UInt32")), ("dwScale", SimTypeInt(signed=False, label="UInt32")), ("dwRate", SimTypeInt(signed=False, label="UInt32")), ("dwStart", SimTypeInt(signed=False, label="UInt32")), ("dwLength", SimTypeInt(signed=False, label="UInt32")), ("dwSuggestedBufferSize", SimTypeInt(signed=False, label="UInt32")), ("dwQuality", SimTypeInt(signed=False, label="UInt32")), ("dwSampleSize", SimTypeInt(signed=False, label="UInt32")), ("rcFrame", SimTypeRef("_rcFrame_e__Struct", SimStruct)),)), name="AVISTREAMHEADER", pack=False, align=None),
    "AVISTREAMINFOA": SimStruct(OrderedDict((("fccType", SimTypeInt(signed=False, label="UInt32")), ("fccHandler", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwCaps", SimTypeInt(signed=False, label="UInt32")), ("wPriority", SimTypeShort(signed=False, label="UInt16")), ("wLanguage", SimTypeShort(signed=False, label="UInt16")), ("dwScale", SimTypeInt(signed=False, label="UInt32")), ("dwRate", SimTypeInt(signed=False, label="UInt32")), ("dwStart", SimTypeInt(signed=False, label="UInt32")), ("dwLength", SimTypeInt(signed=False, label="UInt32")), ("dwInitialFrames", SimTypeInt(signed=False, label="UInt32")), ("dwSuggestedBufferSize", SimTypeInt(signed=False, label="UInt32")), ("dwQuality", SimTypeInt(signed=False, label="UInt32")), ("dwSampleSize", SimTypeInt(signed=False, label="UInt32")), ("rcFrame", SimTypeRef("RECT", SimStruct)), ("dwEditCount", SimTypeInt(signed=False, label="UInt32")), ("dwFormatChangeCount", SimTypeInt(signed=False, label="UInt32")), ("szName", SimTypeArray(SimTypeChar(label="SByte"), 64)),)), name="AVISTREAMINFOA", pack=False, align=None),
    "AVISTREAMINFOW": SimStruct(OrderedDict((("fccType", SimTypeInt(signed=False, label="UInt32")), ("fccHandler", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwCaps", SimTypeInt(signed=False, label="UInt32")), ("wPriority", SimTypeShort(signed=False, label="UInt16")), ("wLanguage", SimTypeShort(signed=False, label="UInt16")), ("dwScale", SimTypeInt(signed=False, label="UInt32")), ("dwRate", SimTypeInt(signed=False, label="UInt32")), ("dwStart", SimTypeInt(signed=False, label="UInt32")), ("dwLength", SimTypeInt(signed=False, label="UInt32")), ("dwInitialFrames", SimTypeInt(signed=False, label="UInt32")), ("dwSuggestedBufferSize", SimTypeInt(signed=False, label="UInt32")), ("dwQuality", SimTypeInt(signed=False, label="UInt32")), ("dwSampleSize", SimTypeInt(signed=False, label="UInt32")), ("rcFrame", SimTypeRef("RECT", SimStruct)), ("dwEditCount", SimTypeInt(signed=False, label="UInt32")), ("dwFormatChangeCount", SimTypeInt(signed=False, label="UInt32")), ("szName", SimTypeArray(SimTypeChar(label="Char"), 64)),)), name="AVISTREAMINFOW", pack=False, align=None),
    "AVISUPERINDEX": SimStruct(OrderedDict((("fcc", SimTypeInt(signed=False, label="UInt32")), ("cb", SimTypeInt(signed=False, label="UInt32")), ("wLongsPerEntry", SimTypeShort(signed=False, label="UInt16")), ("bIndexSubType", SimTypeChar(label="Byte")), ("bIndexType", SimTypeChar(label="Byte")), ("nEntriesInUse", SimTypeInt(signed=False, label="UInt32")), ("dwChunkId", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 3)), ("aIndex", SimTypeArray(SimTypeRef("_avisuperindex_entry", SimStruct), 1022)),)), name="AVISUPERINDEX", pack=False, align=None),
    "AVIStreamHeader": SimStruct(OrderedDict((("fccType", SimTypeInt(signed=False, label="UInt32")), ("fccHandler", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("wPriority", SimTypeShort(signed=False, label="UInt16")), ("wLanguage", SimTypeShort(signed=False, label="UInt16")), ("dwInitialFrames", SimTypeInt(signed=False, label="UInt32")), ("dwScale", SimTypeInt(signed=False, label="UInt32")), ("dwRate", SimTypeInt(signed=False, label="UInt32")), ("dwStart", SimTypeInt(signed=False, label="UInt32")), ("dwLength", SimTypeInt(signed=False, label="UInt32")), ("dwSuggestedBufferSize", SimTypeInt(signed=False, label="UInt32")), ("dwQuality", SimTypeInt(signed=False, label="UInt32")), ("dwSampleSize", SimTypeInt(signed=False, label="UInt32")), ("rcFrame", SimTypeRef("RECT", SimStruct)),)), name="AVIStreamHeader", pack=False, align=None),
    "AVITCDLINDEX": SimStruct(OrderedDict((("fcc", SimTypeInt(signed=False, label="UInt32")), ("cb", SimTypeInt(signed=False, label="UInt32")), ("wLongsPerEntry", SimTypeShort(signed=False, label="UInt16")), ("bIndexSubType", SimTypeChar(label="Byte")), ("bIndexType", SimTypeChar(label="Byte")), ("nEntriesInUse", SimTypeInt(signed=False, label="UInt32")), ("dwChunkId", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 3)), ("aIndex", SimTypeArray(SimTypeRef("AVITCDLINDEX_ENTRY", SimStruct), 584)), ("adwTrailingFill", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 3512)),)), name="AVITCDLINDEX", pack=False, align=None),
    "AVITCDLINDEX_ENTRY": SimStruct(OrderedDict((("dwTick", SimTypeInt(signed=False, label="UInt32")), ("time", SimUnion({"Anonymous": SimStruct(OrderedDict((("wFrameRate", SimTypeShort(signed=False, label="UInt16")), ("wFrameFract", SimTypeShort(signed=False, label="UInt16")), ("dwFrames", SimTypeInt(signed=False, label="UInt32")),)), name="_Anonymous_e__Struct", pack=False, align=None), "qw": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None")), ("dwSMPTEflags", SimTypeInt(signed=False, label="UInt32")), ("dwUser", SimTypeInt(signed=False, label="UInt32")), ("szReelId", SimTypeArray(SimTypeChar(label="SByte"), 12)),)), name="AVITCDLINDEX_ENTRY", pack=False, align=None),
    "AVITIMECODEINDEX": SimStruct(OrderedDict((("fcc", SimTypeInt(signed=False, label="UInt32")), ("cb", SimTypeInt(signed=False, label="UInt32")), ("wLongsPerEntry", SimTypeShort(signed=False, label="UInt16")), ("bIndexSubType", SimTypeChar(label="Byte")), ("bIndexType", SimTypeChar(label="Byte")), ("nEntriesInUse", SimTypeInt(signed=False, label="UInt32")), ("dwChunkId", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 3)), ("aIndex", SimTypeArray(SimTypeRef("TIMECODEDATA", SimStruct), 1022)),)), name="AVITIMECODEINDEX", pack=False, align=None),
    "AVITIMEDINDEX": SimStruct(OrderedDict((("fcc", SimTypeInt(signed=False, label="UInt32")), ("cb", SimTypeInt(signed=False, label="UInt32")), ("wLongsPerEntry", SimTypeShort(signed=False, label="UInt16")), ("bIndexSubType", SimTypeChar(label="Byte")), ("bIndexType", SimTypeChar(label="Byte")), ("nEntriesInUse", SimTypeInt(signed=False, label="UInt32")), ("dwChunkId", SimTypeInt(signed=False, label="UInt32")), ("qwBaseOffset", SimTypeLongLong(signed=False, label="UInt64")), ("dwReserved_3", SimTypeInt(signed=False, label="UInt32")), ("aIndex", SimTypeArray(SimTypeRef("AVITIMEDINDEX_ENTRY", SimStruct), 1362)), ("adwTrailingFill", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 2734)),)), name="AVITIMEDINDEX", pack=False, align=None),
    "AVITIMEDINDEX_ENTRY": SimStruct(OrderedDict((("dwOffset", SimTypeInt(signed=False, label="UInt32")), ("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwDuration", SimTypeInt(signed=False, label="UInt32")),)), name="AVITIMEDINDEX_ENTRY", pack=False, align=None),
    "AVRF_BACKTRACE_INFORMATION": SimStruct(OrderedDict((("Depth", SimTypeInt(signed=False, label="UInt32")), ("Index", SimTypeInt(signed=False, label="UInt32")), ("ReturnAddresses", SimTypeArray(SimTypeLongLong(signed=False, label="UInt64"), 32)),)), name="AVRF_BACKTRACE_INFORMATION", pack=False, align=None),
    "AVRF_HANDLEOPERATION_ENUMERATE_CALLBACK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("AVRF_HANDLE_OPERATION", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["HandleOperation", "EnumerationContext", "EnumerationLevel"]), offset=0),
    "AVRF_HANDLE_OPERATION": SimStruct(OrderedDict((("Handle", SimTypeLongLong(signed=False, label="UInt64")), ("ProcessId", SimTypeInt(signed=False, label="UInt32")), ("ThreadId", SimTypeInt(signed=False, label="UInt32")), ("OperationType", SimTypeInt(signed=False, label="UInt32")), ("Spare0", SimTypeInt(signed=False, label="UInt32")), ("BackTraceInformation", SimTypeRef("AVRF_BACKTRACE_INFORMATION", SimStruct)),)), name="AVRF_HANDLE_OPERATION", pack=False, align=None),
    "AVRF_HEAPALLOCATION_ENUMERATE_CALLBACK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("AVRF_HEAP_ALLOCATION", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["HeapAllocation", "EnumerationContext", "EnumerationLevel"]), offset=0),
    "AVRF_HEAP_ALLOCATION": SimStruct(OrderedDict((("HeapHandle", SimTypeLongLong(signed=False, label="UInt64")), ("UserAllocation", SimTypeLongLong(signed=False, label="UInt64")), ("UserAllocationSize", SimTypeLongLong(signed=False, label="UInt64")), ("Allocation", SimTypeLongLong(signed=False, label="UInt64")), ("AllocationSize", SimTypeLongLong(signed=False, label="UInt64")), ("UserAllocationState", SimTypeInt(signed=False, label="UInt32")), ("HeapState", SimTypeInt(signed=False, label="UInt32")), ("HeapContext", SimTypeLongLong(signed=False, label="UInt64")), ("BackTraceInformation", SimTypePointer(SimTypeRef("AVRF_BACKTRACE_INFORMATION", SimStruct), offset=0)),)), name="AVRF_HEAP_ALLOCATION", pack=False, align=None),
    "AVRF_RESOURCE_ENUMERATE_CALLBACK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceDescription", "EnumerationContext", "EnumerationLevel"]), offset=0),
    "AVRT_PRIORITY": SimTypeInt(signed=False, label="AVRT_PRIORITY"),
    "AXESLISTA": SimStruct(OrderedDict((("axlReserved", SimTypeInt(signed=False, label="UInt32")), ("axlNumAxes", SimTypeInt(signed=False, label="UInt32")), ("axlAxisInfo", SimTypeArray(SimTypeRef("AXISINFOA", SimStruct), 16)),)), name="AXESLISTA", pack=False, align=None),
    "AXESLISTW": SimStruct(OrderedDict((("axlReserved", SimTypeInt(signed=False, label="UInt32")), ("axlNumAxes", SimTypeInt(signed=False, label="UInt32")), ("axlAxisInfo", SimTypeArray(SimTypeRef("AXISINFOW", SimStruct), 16)),)), name="AXESLISTW", pack=False, align=None),
    "AXIS": SimTypeInt(signed=False, label="AXIS"),
    "AXISINFOA": SimStruct(OrderedDict((("axMinValue", SimTypeInt(signed=True, label="Int32")), ("axMaxValue", SimTypeInt(signed=True, label="Int32")), ("axAxisName", SimTypeArray(SimTypeChar(label="Byte"), 16)),)), name="AXISINFOA", pack=False, align=None),
    "AXISINFOW": SimStruct(OrderedDict((("axMinValue", SimTypeInt(signed=True, label="Int32")), ("axMaxValue", SimTypeInt(signed=True, label="Int32")), ("axAxisName", SimTypeArray(SimTypeChar(label="Char"), 16)),)), name="AXISINFOW", pack=False, align=None),
    "AZ_PROP_CONSTANTS": SimTypeInt(signed=False, label="AZ_PROP_CONSTANTS"),
    "ActiveEnd": SimTypeInt(signed=False, label="ActiveEnd"),
    "Adapter": SimStruct(OrderedDict((("AdapterName", SimTypeArray(SimTypeChar(label="Char"), 128)), ("numSources", SimTypeInt(signed=True, label="Int32")), ("sources", SimTypePointer(SimTypeRef("Sources", SimStruct), offset=0)),)), name="Adapter", pack=False, align=None),
    "Adapters": SimStruct(OrderedDict((("numAdapters", SimTypeInt(signed=True, label="Int32")), ("adapter", SimTypePointer(SimTypeRef("Adapter", SimStruct), offset=0)),)), name="Adapters", pack=False, align=None),
    "AddPackageDependencyOptions": SimTypeInt(signed=False, label="AddPackageDependencyOptions"),
    "AddServiceFlag": SimTypeInt(signed=False, label="AddServiceFlag"),
    "AdrClientDisplayFlags": SimTypeInt(signed=False, label="AdrClientDisplayFlags"),
    "AdrClientErrorType": SimTypeInt(signed=False, label="AdrClientErrorType"),
    "AdrClientFlags": SimTypeInt(signed=False, label="AdrClientFlags"),
    "AdrEmailFlags": SimTypeInt(signed=False, label="AdrEmailFlags"),
    "AecQualityMetrics_Struct": SimStruct(OrderedDict((("i64Timestamp", SimTypeLongLong(signed=True, label="Int64")), ("ConvergenceFlag", SimTypeChar(label="Byte")), ("MicClippedFlag", SimTypeChar(label="Byte")), ("MicSilenceFlag", SimTypeChar(label="Byte")), ("PstvFeadbackFlag", SimTypeChar(label="Byte")), ("SpkClippedFlag", SimTypeChar(label="Byte")), ("SpkMuteFlag", SimTypeChar(label="Byte")), ("GlitchFlag", SimTypeChar(label="Byte")), ("DoubleTalkFlag", SimTypeChar(label="Byte")), ("uGlitchCount", SimTypeInt(signed=False, label="UInt32")), ("uMicClipCount", SimTypeInt(signed=False, label="UInt32")), ("fDuration", SimTypeFloat(size=32)), ("fTSVariance", SimTypeFloat(size=32)), ("fTSDriftRate", SimTypeFloat(size=32)), ("fVoiceLevel", SimTypeFloat(size=32)), ("fNoiseLevel", SimTypeFloat(size=32)), ("fERLE", SimTypeFloat(size=32)), ("fAvgERLE", SimTypeFloat(size=32)), ("dwReserved", SimTypeInt(signed=False, label="UInt32")),)), name="AecQualityMetrics_Struct", pack=False, align=None),
    "AlgorithmFlags": SimTypeInt(signed=False, label="AlgorithmFlags"),
    "AlgorithmOperationFlags": SimTypeInt(signed=False, label="AlgorithmOperationFlags"),
    "AlgorithmType": SimTypeInt(signed=False, label="AlgorithmType"),
    "AlternativeNameType": SimTypeInt(signed=False, label="AlternativeNameType"),
    "AnalogVideoStandard": SimTypeInt(signed=False, label="AnalogVideoStandard"),
    "AnimationStyle": SimTypeInt(signed=False, label="AnimationStyle"),
    "AnnoScope": SimTypeInt(signed=False, label="AnnoScope"),
    "AppEvents": SimTypeBottom(label="AppEvents"),
    "AppPolicyClrCompat": SimTypeInt(signed=False, label="AppPolicyClrCompat"),
    "AppPolicyCreateFileAccess": SimTypeInt(signed=False, label="AppPolicyCreateFileAccess"),
    "AppPolicyLifecycleManagement": SimTypeInt(signed=False, label="AppPolicyLifecycleManagement"),
    "AppPolicyMediaFoundationCodecLoading": SimTypeInt(signed=False, label="AppPolicyMediaFoundationCodecLoading"),
    "AppPolicyProcessTerminationMethod": SimTypeInt(signed=False, label="AppPolicyProcessTerminationMethod"),
    "AppPolicyShowDeveloperDiagnostic": SimTypeInt(signed=False, label="AppPolicyShowDeveloperDiagnostic"),
    "AppPolicyThreadInitializationType": SimTypeInt(signed=False, label="AppPolicyThreadInitializationType"),
    "AppPolicyWindowingModel": SimTypeInt(signed=False, label="AppPolicyWindowingModel"),
    "AppearanceConstants": SimTypeInt(signed=False, label="AppearanceConstants"),
    "ApplicationProcessRecycleInfo": SimStruct(OrderedDict((("IsRecyclable", SimTypeInt(signed=True, label="Int32")), ("IsRecycled", SimTypeInt(signed=True, label="Int32")), ("TimeRecycled", SimTypeRef("FILETIME", SimStruct)), ("TimeToTerminate", SimTypeRef("FILETIME", SimStruct)), ("RecycleReasonCode", SimTypeInt(signed=True, label="Int32")), ("IsPendingRecycle", SimTypeInt(signed=True, label="Int32")), ("HasAutomaticLifetimeRecycling", SimTypeInt(signed=True, label="Int32")), ("TimeForAutomaticRecycling", SimTypeRef("FILETIME", SimStruct)), ("MemoryLimitInKB", SimTypeInt(signed=False, label="UInt32")), ("MemoryUsageInKBLastCheck", SimTypeInt(signed=False, label="UInt32")), ("ActivationLimit", SimTypeInt(signed=False, label="UInt32")), ("NumActivationsLastReported", SimTypeInt(signed=False, label="UInt32")), ("CallLimit", SimTypeInt(signed=False, label="UInt32")), ("NumCallsLastReported", SimTypeInt(signed=False, label="UInt32")),)), name="ApplicationProcessRecycleInfo", pack=False, align=None),
    "ApplicationProcessStatistics": SimStruct(OrderedDict((("NumCallsOutstanding", SimTypeInt(signed=False, label="UInt32")), ("NumTrackedComponents", SimTypeInt(signed=False, label="UInt32")), ("NumComponentInstances", SimTypeInt(signed=False, label="UInt32")), ("AvgCallsPerSecond", SimTypeInt(signed=False, label="UInt32")), ("Reserved1", SimTypeInt(signed=False, label="UInt32")), ("Reserved2", SimTypeInt(signed=False, label="UInt32")), ("Reserved3", SimTypeInt(signed=False, label="UInt32")), ("Reserved4", SimTypeInt(signed=False, label="UInt32")),)), name="ApplicationProcessStatistics", pack=False, align=None),
    "ApplicationProcessSummary": SimStruct(OrderedDict((("PartitionIdPrimaryApplication", SimTypeBottom(label="Guid")), ("ApplicationIdPrimaryApplication", SimTypeBottom(label="Guid")), ("ApplicationInstanceId", SimTypeBottom(label="Guid")), ("ProcessId", SimTypeInt(signed=False, label="UInt32")), ("Type", SimTypeInt(signed=False, label="COMPLUS_APPTYPE")), ("ProcessExeName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("IsService", SimTypeInt(signed=True, label="Int32")), ("IsPaused", SimTypeInt(signed=True, label="Int32")), ("IsRecycled", SimTypeInt(signed=True, label="Int32")),)), name="ApplicationProcessSummary", pack=False, align=None),
    "ApplicationSummary": SimStruct(OrderedDict((("ApplicationInstanceId", SimTypeBottom(label="Guid")), ("PartitionId", SimTypeBottom(label="Guid")), ("ApplicationId", SimTypeBottom(label="Guid")), ("Type", SimTypeInt(signed=False, label="COMPLUS_APPTYPE")), ("ApplicationName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("NumTrackedComponents", SimTypeInt(signed=False, label="UInt32")), ("NumComponentInstances", SimTypeInt(signed=False, label="UInt32")),)), name="ApplicationSummary", pack=False, align=None),
    "ApplicationType": SimTypeInt(signed=False, label="ApplicationType"),
    "ApplicationTypeType": SimTypeInt(signed=False, label="ApplicationTypeType"),
    "ArrayDimension": SimStruct(OrderedDict((("LowerBound", SimTypeLongLong(signed=True, label="Int64")), ("Length", SimTypeLongLong(signed=False, label="UInt64")), ("Stride", SimTypeLongLong(signed=False, label="UInt64")),)), name="ArrayDimension", pack=False, align=None),
    "AsnAny": SimStruct(OrderedDict((("asnType", SimTypeChar(label="Byte")), ("asnValue", SimUnion({"number": SimTypeInt(signed=True, label="Int32"), "unsigned32": SimTypeInt(signed=False, label="UInt32"), "counter64": SimTypeLongLong(signed=False, label="UInt64"), "string": SimTypeRef("AsnOctetString", SimStruct), "bits": SimTypeRef("AsnOctetString", SimStruct), "object": SimTypeRef("AsnObjectIdentifier", SimStruct), "sequence": SimTypeRef("AsnOctetString", SimStruct), "address": SimTypeRef("AsnOctetString", SimStruct), "counter": SimTypeInt(signed=False, label="UInt32"), "gauge": SimTypeInt(signed=False, label="UInt32"), "ticks": SimTypeInt(signed=False, label="UInt32"), "arbitrary": SimTypeRef("AsnOctetString", SimStruct)}, name="<anon>", label="None")),)), name="AsnAny", pack=False, align=None),
    "AsnObjectIdentifier": SimStruct(OrderedDict((("idLength", SimTypeInt(signed=False, label="UInt32")), ("ids", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="AsnObjectIdentifier", pack=False, align=None),
    "AsnOctetString": SimStruct(OrderedDict((("stream", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("length", SimTypeInt(signed=False, label="UInt32")), ("dynamic", SimTypeInt(signed=True, label="Int32")),)), name="AsnOctetString", pack=False, align=None),
    "AssemblyBindInfo": SimStruct(OrderedDict((("dwAppDomainId", SimTypeInt(signed=False, label="UInt32")), ("lpReferencedIdentity", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpPostPolicyIdentity", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ePolicyLevel", SimTypeInt(signed=False, label="UInt32")),)), name="AssemblyBindInfo", pack=False, align=None),
    "AsyncContentLoadedState": SimTypeInt(signed=False, label="AsyncContentLoadedState"),
    "AsyncIAdviseSink": SimTypeBottom(label="AsyncIAdviseSink"),
    "AsyncIAdviseSink2": SimTypeBottom(label="AsyncIAdviseSink2"),
    "AsyncIAssociatedIdentityProvider": SimTypeBottom(label="AsyncIAssociatedIdentityProvider"),
    "AsyncIBackgroundCopyCallback": SimTypeBottom(label="AsyncIBackgroundCopyCallback"),
    "AsyncIConnectedIdentityProvider": SimTypeBottom(label="AsyncIConnectedIdentityProvider"),
    "AsyncIDebugApplicationNodeEvents": SimTypeBottom(label="AsyncIDebugApplicationNodeEvents"),
    "AsyncIFtpAuthenticationProvider": SimTypeBottom(label="AsyncIFtpAuthenticationProvider"),
    "AsyncIFtpAuthorizationProvider": SimTypeBottom(label="AsyncIFtpAuthorizationProvider"),
    "AsyncIFtpHomeDirectoryProvider": SimTypeBottom(label="AsyncIFtpHomeDirectoryProvider"),
    "AsyncIFtpLogProvider": SimTypeBottom(label="AsyncIFtpLogProvider"),
    "AsyncIFtpPostprocessProvider": SimTypeBottom(label="AsyncIFtpPostprocessProvider"),
    "AsyncIFtpPreprocessProvider": SimTypeBottom(label="AsyncIFtpPreprocessProvider"),
    "AsyncIFtpRoleProvider": SimTypeBottom(label="AsyncIFtpRoleProvider"),
    "AsyncIIdentityAdvise": SimTypeBottom(label="AsyncIIdentityAdvise"),
    "AsyncIIdentityAuthentication": SimTypeBottom(label="AsyncIIdentityAuthentication"),
    "AsyncIIdentityProvider": SimTypeBottom(label="AsyncIIdentityProvider"),
    "AsyncIIdentityStore": SimTypeBottom(label="AsyncIIdentityStore"),
    "AsyncIIdentityStoreEx": SimTypeBottom(label="AsyncIIdentityStoreEx"),
    "AsyncIMSAdminBaseSinkW": SimTypeBottom(label="AsyncIMSAdminBaseSinkW"),
    "AsyncIMultiQI": SimTypeBottom(label="AsyncIMultiQI"),
    "AsyncIPipeByte": SimTypeBottom(label="AsyncIPipeByte"),
    "AsyncIPipeDouble": SimTypeBottom(label="AsyncIPipeDouble"),
    "AsyncIPipeLong": SimTypeBottom(label="AsyncIPipeLong"),
    "AsyncIUnknown": SimTypeBottom(label="AsyncIUnknown"),
    "AtlThunkData_t": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "AudioClient3ActivationParams": SimStruct(OrderedDict((("tracingContextId", SimTypeBottom(label="Guid")),)), name="AudioClient3ActivationParams", pack=False, align=None),
    "AudioClientProperties": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("bIsOffload", SimTypeInt(signed=True, label="Int32")), ("eCategory", SimTypeInt(signed=False, label="AUDIO_STREAM_CATEGORY")), ("Options", SimTypeInt(signed=False, label="AUDCLNT_STREAMOPTIONS")),)), name="AudioClientProperties", pack=False, align=None),
    "AudioExtensionParams": SimStruct(OrderedDict((("AddPageParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pEndpoint", SimTypeBottom(label="IMMDevice")), ("pPnpInterface", SimTypeBottom(label="IMMDevice")), ("pPnpDevnode", SimTypeBottom(label="IMMDevice")),)), name="AudioExtensionParams", pack=False, align=None),
    "AudioFXExtensionParams": SimStruct(OrderedDict((("AddPageParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pwstrEndpointID", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pFxProperties", SimTypeBottom(label="IPropertyStore")),)), name="AudioFXExtensionParams", pack=False, align=None),
    "AudioObjectType": SimTypeInt(signed=False, label="AudioObjectType"),
    "AudioSessionDisconnectReason": SimTypeInt(signed=False, label="AudioSessionDisconnectReason"),
    "AudioSessionState": SimTypeInt(signed=False, label="AudioSessionState"),
    "AudioStateMonitorSoundLevel": SimTypeInt(signed=False, label="AudioStateMonitorSoundLevel"),
    "AutoCorrectProc": SimTypePointer(SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["langid", "pszBefore", "pszAfter", "cchAfter", "pcchReplaced"]), offset=0),
    "AutoDownloadMode": SimTypeInt(signed=False, label="AutoDownloadMode"),
    "AutoPathFormat": SimTypeInt(signed=False, label="AutoPathFormat"),
    "AutoProxyHelperFunctions": SimStruct(OrderedDict((("lpVtbl", SimTypePointer(SimTypeRef("AutoProxyHelperVtbl", SimStruct), offset=0)),)), name="AutoProxyHelperFunctions", pack=False, align=None),
    "AutoProxyHelperVtbl": SimStruct(OrderedDict((("IsResolvable", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("GetIPAddress", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("ResolveHostName", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("IsInNet", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("IsResolvableEx", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("GetIPAddressEx", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("ResolveHostNameEx", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("IsInNetEx", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("SortIpList", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="AutoProxyHelperVtbl", pack=False, align=None),
    "AutoSelectionMode": SimTypeInt(signed=False, label="AutoSelectionMode"),
    "AutoSvcs_Error_Constants": SimTypeInt(signed=False, label="AutoSvcs_Error_Constants"),
    "AutomaticUpdatesNotificationLevel": SimTypeInt(signed=False, label="AutomaticUpdatesNotificationLevel"),
    "AutomaticUpdatesPermissionType": SimTypeInt(signed=False, label="AutomaticUpdatesPermissionType"),
    "AutomaticUpdatesScheduledInstallationDay": SimTypeInt(signed=False, label="AutomaticUpdatesScheduledInstallationDay"),
    "AutomaticUpdatesUserType": SimTypeInt(signed=False, label="AutomaticUpdatesUserType"),
    "AutomationElementMode": SimTypeInt(signed=False, label="AutomationElementMode"),
    "AutomationIdentifierType": SimTypeInt(signed=False, label="AutomationIdentifierType"),
    "BACKGROUNDSTATES": SimTypeInt(signed=False, label="BACKGROUNDSTATES"),
    "BACKGROUNDWITHBORDERSTATES": SimTypeInt(signed=False, label="BACKGROUNDWITHBORDERSTATES"),
    "BACKGROUND_MODE": SimTypeInt(signed=False, label="BACKGROUND_MODE"),
    "BACKLIGHT_OPTIMIZATION_LEVEL": SimTypeInt(signed=False, label="BACKLIGHT_OPTIMIZATION_LEVEL"),
    "BACKLIGHT_REDUCTION_GAMMA_RAMP": SimStruct(OrderedDict((("R", SimTypeArray(SimTypeShort(signed=False, label="UInt16"), 256)), ("G", SimTypeArray(SimTypeShort(signed=False, label="UInt16"), 256)), ("B", SimTypeArray(SimTypeShort(signed=False, label="UInt16"), 256)),)), name="BACKLIGHT_REDUCTION_GAMMA_RAMP", pack=False, align=None),
    "BALLOONSTATES": SimTypeInt(signed=False, label="BALLOONSTATES"),
    "BALLOONSTEMSTATES": SimTypeInt(signed=False, label="BALLOONSTEMSTATES"),
    "BANDINFOSFB": SimStruct(OrderedDict((("dwMask", SimTypeInt(signed=False, label="UInt32")), ("dwStateMask", SimTypeInt(signed=False, label="UInt32")), ("dwState", SimTypeInt(signed=False, label="UInt32")), ("crBkgnd", SimTypeInt(signed=False, label="UInt32")), ("crBtnLt", SimTypeInt(signed=False, label="UInt32")), ("crBtnDk", SimTypeInt(signed=False, label="UInt32")), ("wViewMode", SimTypeShort(signed=False, label="UInt16")), ("wAlign", SimTypeShort(signed=False, label="UInt16")), ("psf", SimTypeBottom(label="IShellFolder")), ("pidl", SimTypePointer(SimTypeRef("ITEMIDLIST", SimStruct), offset=0)),)), name="BANDINFOSFB", pack=False, align=None),
    "BANDSITECID": SimTypeInt(signed=False, label="BANDSITECID"),
    "BANDSITEINFO": SimStruct(OrderedDict((("dwMask", SimTypeInt(signed=False, label="UInt32")), ("dwState", SimTypeInt(signed=False, label="UInt32")), ("dwStyle", SimTypeInt(signed=False, label="UInt32")),)), name="BANDSITEINFO", pack=False, align=None),
    "BANK_POSITION": SimStruct(OrderedDict((("ReadBankPosition", SimTypeInt(signed=False, label="UInt32")), ("WriteBankPosition", SimTypeInt(signed=False, label="UInt32")),)), name="BANK_POSITION", pack=False, align=None),
    "BANNER_NOTIFICATION": SimStruct(OrderedDict((("event", SimTypeInt(signed=False, label="BANNER_NOTIFICATION_EVENT")), ("providerIdentity", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("contentId", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="BANNER_NOTIFICATION", pack=False, align=None),
    "BANNER_NOTIFICATION_EVENT": SimTypeInt(signed=False, label="BANNER_NOTIFICATION_EVENT"),
    "BARBACKGROUNDSTATES": SimTypeInt(signed=False, label="BARBACKGROUNDSTATES"),
    "BARITEMSTATES": SimTypeInt(signed=False, label="BARITEMSTATES"),
    "BASEBROWSERDATALH": SimStruct(OrderedDict((("_hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("_ptl", SimTypeBottom(label="ITravelLog")), ("_phlf", SimTypeBottom(label="IHlinkFrame")), ("_pautoWB2", SimTypeBottom(label="IWebBrowser2")), ("_pautoEDS", SimTypeBottom(label="IExpDispSupport")), ("_pautoSS", SimTypeBottom(label="IShellService")), ("_eSecureLockIcon", SimTypeInt(signed=True, label="Int32")), ("_bitfield", SimTypeInt(signed=False, label="UInt32")), ("_uActivateState", SimTypeInt(signed=False, label="UInt32")), ("_pidlViewState", SimTypePointer(SimTypeRef("ITEMIDLIST", SimStruct), offset=0)), ("_pctView", SimTypeBottom(label="IOleCommandTarget")), ("_pidlCur", SimTypePointer(SimTypeRef("ITEMIDLIST", SimStruct), offset=0)), ("_psv", SimTypeBottom(label="IShellView")), ("_psf", SimTypeBottom(label="IShellFolder")), ("_hwndView", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("_pszTitleCur", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("_pidlPending", SimTypePointer(SimTypeRef("ITEMIDLIST", SimStruct), offset=0)), ("_psvPending", SimTypeBottom(label="IShellView")), ("_psfPending", SimTypeBottom(label="IShellFolder")), ("_hwndViewPending", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("_pszTitlePending", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("_fIsViewMSHTML", SimTypeInt(signed=True, label="Int32")), ("_fPrivacyImpacted", SimTypeInt(signed=True, label="Int32")), ("_clsidView", SimTypeBottom(label="Guid")), ("_clsidViewPending", SimTypeBottom(label="Guid")), ("_hwndFrame", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("_lPhishingFilterStatus", SimTypeInt(signed=True, label="Int32")),)), name="BASEBROWSERDATALH", pack=False, align=None),
    "BASEBROWSERDATAXP": SimStruct(OrderedDict((("_hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("_ptl", SimTypeBottom(label="ITravelLog")), ("_phlf", SimTypeBottom(label="IHlinkFrame")), ("_pautoWB2", SimTypeBottom(label="IWebBrowser2")), ("_pautoEDS", SimTypeBottom(label="IExpDispSupportXP")), ("_pautoSS", SimTypeBottom(label="IShellService")), ("_eSecureLockIcon", SimTypeInt(signed=True, label="Int32")), ("_bitfield", SimTypeInt(signed=False, label="UInt32")), ("_uActivateState", SimTypeInt(signed=False, label="UInt32")), ("_pidlViewState", SimTypePointer(SimTypeRef("ITEMIDLIST", SimStruct), offset=0)), ("_pctView", SimTypeBottom(label="IOleCommandTarget")), ("_pidlCur", SimTypePointer(SimTypeRef("ITEMIDLIST", SimStruct), offset=0)), ("_psv", SimTypeBottom(label="IShellView")), ("_psf", SimTypeBottom(label="IShellFolder")), ("_hwndView", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("_pszTitleCur", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("_pidlPending", SimTypePointer(SimTypeRef("ITEMIDLIST", SimStruct), offset=0)), ("_psvPending", SimTypeBottom(label="IShellView")), ("_psfPending", SimTypeBottom(label="IShellFolder")), ("_hwndViewPending", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("_pszTitlePending", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("_fIsViewMSHTML", SimTypeInt(signed=True, label="Int32")), ("_fPrivacyImpacted", SimTypeInt(signed=True, label="Int32")), ("_clsidView", SimTypeBottom(label="Guid")), ("_clsidViewPending", SimTypeBottom(label="Guid")), ("_hwndFrame", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="BASEBROWSERDATAXP", pack=False, align=None),
    "BASE_MCB": SimStruct(OrderedDict((("MaximumPairCount", SimTypeInt(signed=False, label="UInt32")), ("PairCount", SimTypeInt(signed=False, label="UInt32")), ("PoolType", SimTypeShort(signed=False, label="UInt16")), ("Flags", SimTypeShort(signed=False, label="UInt16")), ("Mapping", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="BASE_MCB", pack=False, align=None),
    "BATTERY_CHARGER_STATUS": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="BATTERY_CHARGING_SOURCE_TYPE")), ("VaData", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="BATTERY_CHARGER_STATUS", pack=False, align=None),
    "BATTERY_CHARGING_SOURCE": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="BATTERY_CHARGING_SOURCE_TYPE")), ("MaxCurrent", SimTypeInt(signed=False, label="UInt32")),)), name="BATTERY_CHARGING_SOURCE", pack=False, align=None),
    "BATTERY_CHARGING_SOURCE_INFORMATION": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="BATTERY_CHARGING_SOURCE_TYPE")), ("SourceOnline", SimTypeChar(label="Byte")),)), name="BATTERY_CHARGING_SOURCE_INFORMATION", pack=False, align=None),
    "BATTERY_CHARGING_SOURCE_TYPE": SimTypeInt(signed=False, label="BATTERY_CHARGING_SOURCE_TYPE"),
    "BATTERY_DEVTYPE": SimTypeInt(signed=False, label="BATTERY_DEVTYPE"),
    "BATTERY_INFORMATION": SimStruct(OrderedDict((("Capabilities", SimTypeInt(signed=False, label="UInt32")), ("Technology", SimTypeChar(label="Byte")), ("Reserved", SimTypeArray(SimTypeChar(label="Byte"), 3)), ("Chemistry", SimTypeArray(SimTypeChar(label="Byte"), 4)), ("DesignedCapacity", SimTypeInt(signed=False, label="UInt32")), ("FullChargedCapacity", SimTypeInt(signed=False, label="UInt32")), ("DefaultAlert1", SimTypeInt(signed=False, label="UInt32")), ("DefaultAlert2", SimTypeInt(signed=False, label="UInt32")), ("CriticalBias", SimTypeInt(signed=False, label="UInt32")), ("CycleCount", SimTypeInt(signed=False, label="UInt32")),)), name="BATTERY_INFORMATION", pack=False, align=None),
    "BATTERY_LEVEL": SimTypeInt(signed=False, label="BATTERY_LEVEL"),
    "BATTERY_MANUFACTURE_DATE": SimStruct(OrderedDict((("Day", SimTypeChar(label="Byte")), ("Month", SimTypeChar(label="Byte")), ("Year", SimTypeShort(signed=False, label="UInt16")),)), name="BATTERY_MANUFACTURE_DATE", pack=False, align=None),
    "BATTERY_QUERY_INFORMATION": SimStruct(OrderedDict((("BatteryTag", SimTypeInt(signed=False, label="UInt32")), ("InformationLevel", SimTypeInt(signed=False, label="BATTERY_QUERY_INFORMATION_LEVEL")), ("AtRate", SimTypeInt(signed=False, label="UInt32")),)), name="BATTERY_QUERY_INFORMATION", pack=False, align=None),
    "BATTERY_QUERY_INFORMATION_LEVEL": SimTypeInt(signed=False, label="BATTERY_QUERY_INFORMATION_LEVEL"),
    "BATTERY_REPORTING_SCALE": SimStruct(OrderedDict((("Granularity", SimTypeInt(signed=False, label="UInt32")), ("Capacity", SimTypeInt(signed=False, label="UInt32")),)), name="BATTERY_REPORTING_SCALE", pack=False, align=None),
    "BATTERY_SET_INFORMATION": SimStruct(OrderedDict((("BatteryTag", SimTypeInt(signed=False, label="UInt32")), ("InformationLevel", SimTypeInt(signed=False, label="BATTERY_SET_INFORMATION_LEVEL")), ("Buffer", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BATTERY_SET_INFORMATION", pack=False, align=None),
    "BATTERY_SET_INFORMATION_LEVEL": SimTypeInt(signed=False, label="BATTERY_SET_INFORMATION_LEVEL"),
    "BATTERY_STATUS": SimStruct(OrderedDict((("PowerState", SimTypeInt(signed=False, label="UInt32")), ("Capacity", SimTypeInt(signed=False, label="UInt32")), ("Voltage", SimTypeInt(signed=False, label="UInt32")), ("Rate", SimTypeInt(signed=True, label="Int32")),)), name="BATTERY_STATUS", pack=False, align=None),
    "BATTERY_TYPE": SimTypeInt(signed=False, label="BATTERY_TYPE"),
    "BATTERY_USB_CHARGER_STATUS": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="BATTERY_CHARGING_SOURCE_TYPE")), ("Reserved", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("MaxCurrent", SimTypeInt(signed=False, label="UInt32")), ("Voltage", SimTypeInt(signed=False, label="UInt32")), ("PortType", SimTypeInt(signed=False, label="USB_CHARGER_PORT")), ("PortId", SimTypeLongLong(signed=False, label="UInt64")), ("PowerSourceInformation", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("OemCharger", SimTypeBottom(label="Guid")),)), name="BATTERY_USB_CHARGER_STATUS", pack=False, align=None),
    "BATTERY_WAIT_STATUS": SimStruct(OrderedDict((("BatteryTag", SimTypeInt(signed=False, label="UInt32")), ("Timeout", SimTypeInt(signed=False, label="UInt32")), ("PowerState", SimTypeInt(signed=False, label="UInt32")), ("LowCapacity", SimTypeInt(signed=False, label="UInt32")), ("HighCapacity", SimTypeInt(signed=False, label="UInt32")),)), name="BATTERY_WAIT_STATUS", pack=False, align=None),
    "BCRYPTGENRANDOM_FLAGS": SimTypeInt(signed=False, label="BCRYPTGENRANDOM_FLAGS"),
    "BCRYPT_ALGORITHM_IDENTIFIER": SimStruct(OrderedDict((("pszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwClass", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None),
    "BCRYPT_ALG_HANDLE": SimTypePointer(SimTypeBottom(label="Void"), offset=0),
    "BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwInfoVersion", SimTypeInt(signed=False, label="UInt32")), ("pbNonce", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbNonce", SimTypeInt(signed=False, label="UInt32")), ("pbAuthData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbAuthData", SimTypeInt(signed=False, label="UInt32")), ("pbTag", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbTag", SimTypeInt(signed=False, label="UInt32")), ("pbMacContext", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbMacContext", SimTypeInt(signed=False, label="UInt32")), ("cbAAD", SimTypeInt(signed=False, label="UInt32")), ("cbData", SimTypeLongLong(signed=False, label="UInt64")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO", pack=False, align=None),
    "BCRYPT_DH_KEY_BLOB": SimStruct(OrderedDict((("dwMagic", SimTypeInt(signed=False, label="BCRYPT_DH_KEY_BLOB_MAGIC")), ("cbKey", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_DH_KEY_BLOB", pack=False, align=None),
    "BCRYPT_DH_KEY_BLOB_MAGIC": SimTypeInt(signed=False, label="BCRYPT_DH_KEY_BLOB_MAGIC"),
    "BCRYPT_DH_PARAMETER_HEADER": SimStruct(OrderedDict((("cbLength", SimTypeInt(signed=False, label="UInt32")), ("dwMagic", SimTypeInt(signed=False, label="UInt32")), ("cbKeyLength", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_DH_PARAMETER_HEADER", pack=False, align=None),
    "BCRYPT_DSA_KEY_BLOB": SimStruct(OrderedDict((("dwMagic", SimTypeInt(signed=False, label="BCRYPT_DSA_MAGIC")), ("cbKey", SimTypeInt(signed=False, label="UInt32")), ("Count", SimTypeArray(SimTypeChar(label="Byte"), 4)), ("Seed", SimTypeArray(SimTypeChar(label="Byte"), 20)), ("q", SimTypeArray(SimTypeChar(label="Byte"), 20)),)), name="BCRYPT_DSA_KEY_BLOB", pack=False, align=None),
    "BCRYPT_DSA_KEY_BLOB_V2": SimStruct(OrderedDict((("dwMagic", SimTypeInt(signed=False, label="BCRYPT_DSA_MAGIC")), ("cbKey", SimTypeInt(signed=False, label="UInt32")), ("hashAlgorithm", SimTypeInt(signed=False, label="HASHALGORITHM_ENUM")), ("standardVersion", SimTypeInt(signed=False, label="DSAFIPSVERSION_ENUM")), ("cbSeedLength", SimTypeInt(signed=False, label="UInt32")), ("cbGroupSize", SimTypeInt(signed=False, label="UInt32")), ("Count", SimTypeArray(SimTypeChar(label="Byte"), 4)),)), name="BCRYPT_DSA_KEY_BLOB_V2", pack=False, align=None),
    "BCRYPT_DSA_MAGIC": SimTypeInt(signed=False, label="BCRYPT_DSA_MAGIC"),
    "BCRYPT_DSA_PARAMETER_HEADER": SimStruct(OrderedDict((("cbLength", SimTypeInt(signed=False, label="UInt32")), ("dwMagic", SimTypeInt(signed=False, label="UInt32")), ("cbKeyLength", SimTypeInt(signed=False, label="UInt32")), ("Count", SimTypeArray(SimTypeChar(label="Byte"), 4)), ("Seed", SimTypeArray(SimTypeChar(label="Byte"), 20)), ("q", SimTypeArray(SimTypeChar(label="Byte"), 20)),)), name="BCRYPT_DSA_PARAMETER_HEADER", pack=False, align=None),
    "BCRYPT_DSA_PARAMETER_HEADER_V2": SimStruct(OrderedDict((("cbLength", SimTypeInt(signed=False, label="UInt32")), ("dwMagic", SimTypeInt(signed=False, label="UInt32")), ("cbKeyLength", SimTypeInt(signed=False, label="UInt32")), ("hashAlgorithm", SimTypeInt(signed=False, label="HASHALGORITHM_ENUM")), ("standardVersion", SimTypeInt(signed=False, label="DSAFIPSVERSION_ENUM")), ("cbSeedLength", SimTypeInt(signed=False, label="UInt32")), ("cbGroupSize", SimTypeInt(signed=False, label="UInt32")), ("Count", SimTypeArray(SimTypeChar(label="Byte"), 4)),)), name="BCRYPT_DSA_PARAMETER_HEADER_V2", pack=False, align=None),
    "BCRYPT_ECCFULLKEY_BLOB": SimStruct(OrderedDict((("dwMagic", SimTypeInt(signed=False, label="UInt32")), ("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("dwCurveType", SimTypeInt(signed=False, label="ECC_CURVE_TYPE_ENUM")), ("dwCurveGenerationAlgId", SimTypeInt(signed=False, label="ECC_CURVE_ALG_ID_ENUM")), ("cbFieldLength", SimTypeInt(signed=False, label="UInt32")), ("cbSubgroupOrder", SimTypeInt(signed=False, label="UInt32")), ("cbCofactor", SimTypeInt(signed=False, label="UInt32")), ("cbSeed", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_ECCFULLKEY_BLOB", pack=False, align=None),
    "BCRYPT_ECCKEY_BLOB": SimStruct(OrderedDict((("dwMagic", SimTypeInt(signed=False, label="UInt32")), ("cbKey", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_ECCKEY_BLOB", pack=False, align=None),
    "BCRYPT_ECC_CURVE_NAMES": SimStruct(OrderedDict((("dwEccCurveNames", SimTypeInt(signed=False, label="UInt32")), ("pEccCurveNames", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="BCRYPT_ECC_CURVE_NAMES", pack=False, align=None),
    "BCRYPT_FLAGS": SimTypeInt(signed=False, label="BCRYPT_FLAGS"),
    "BCRYPT_HANDLE": SimTypePointer(SimTypeBottom(label="Void"), offset=0),
    "BCRYPT_HASH_HANDLE": SimTypePointer(SimTypeBottom(label="Void"), offset=0),
    "BCRYPT_HASH_OPERATION_TYPE": SimTypeInt(signed=False, label="BCRYPT_HASH_OPERATION_TYPE"),
    "BCRYPT_INTERFACE": SimTypeInt(signed=False, label="BCRYPT_INTERFACE"),
    "BCRYPT_INTERFACE_VERSION": SimStruct(OrderedDict((("MajorVersion", SimTypeShort(signed=False, label="UInt16")), ("MinorVersion", SimTypeShort(signed=False, label="UInt16")),)), name="BCRYPT_INTERFACE_VERSION", pack=False, align=None),
    "BCRYPT_KEY_BLOB": SimStruct(OrderedDict((("Magic", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_KEY_BLOB", pack=False, align=None),
    "BCRYPT_KEY_DATA_BLOB_HEADER": SimStruct(OrderedDict((("dwMagic", SimTypeInt(signed=False, label="UInt32")), ("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("cbKeyData", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_KEY_DATA_BLOB_HEADER", pack=False, align=None),
    "BCRYPT_KEY_HANDLE": SimTypePointer(SimTypeBottom(label="Void"), offset=0),
    "BCRYPT_KEY_LENGTHS_STRUCT": SimStruct(OrderedDict((("dwMinLength", SimTypeInt(signed=False, label="UInt32")), ("dwMaxLength", SimTypeInt(signed=False, label="UInt32")), ("dwIncrement", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_KEY_LENGTHS_STRUCT", pack=False, align=None),
    "BCRYPT_MULTI_HASH_OPERATION": SimStruct(OrderedDict((("iHash", SimTypeInt(signed=False, label="UInt32")), ("hashOperation", SimTypeInt(signed=False, label="BCRYPT_HASH_OPERATION_TYPE")), ("pbBuffer", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbBuffer", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_MULTI_HASH_OPERATION", pack=False, align=None),
    "BCRYPT_MULTI_OBJECT_LENGTH_STRUCT": SimStruct(OrderedDict((("cbPerObject", SimTypeInt(signed=False, label="UInt32")), ("cbPerElement", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_MULTI_OBJECT_LENGTH_STRUCT", pack=False, align=None),
    "BCRYPT_MULTI_OPERATION_TYPE": SimTypeInt(signed=False, label="BCRYPT_MULTI_OPERATION_TYPE"),
    "BCRYPT_OAEP_PADDING_INFO": SimStruct(OrderedDict((("pszAlgId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pbLabel", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbLabel", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_OAEP_PADDING_INFO", pack=False, align=None),
    "BCRYPT_OID": SimStruct(OrderedDict((("cbOID", SimTypeInt(signed=False, label="UInt32")), ("pbOID", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BCRYPT_OID", pack=False, align=None),
    "BCRYPT_OID_LIST": SimStruct(OrderedDict((("dwOIDCount", SimTypeInt(signed=False, label="UInt32")), ("pOIDs", SimTypePointer(SimTypeRef("BCRYPT_OID", SimStruct), offset=0)),)), name="BCRYPT_OID_LIST", pack=False, align=None),
    "BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS": SimTypeInt(signed=False, label="BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS"),
    "BCRYPT_OPERATION": SimTypeInt(signed=False, label="BCRYPT_OPERATION"),
    "BCRYPT_PKCS1_PADDING_INFO": SimStruct(OrderedDict((("pszAlgId", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="BCRYPT_PKCS1_PADDING_INFO", pack=False, align=None),
    "BCRYPT_PROVIDER_NAME": SimStruct(OrderedDict((("pszProviderName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="BCRYPT_PROVIDER_NAME", pack=False, align=None),
    "BCRYPT_PSS_PADDING_INFO": SimStruct(OrderedDict((("pszAlgId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cbSalt", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_PSS_PADDING_INFO", pack=False, align=None),
    "BCRYPT_QUERY_PROVIDER_MODE": SimTypeInt(signed=False, label="BCRYPT_QUERY_PROVIDER_MODE"),
    "BCRYPT_RESOLVE_PROVIDERS_FLAGS": SimTypeInt(signed=False, label="BCRYPT_RESOLVE_PROVIDERS_FLAGS"),
    "BCRYPT_RSAKEY_BLOB": SimStruct(OrderedDict((("Magic", SimTypeInt(signed=False, label="BCRYPT_RSAKEY_BLOB_MAGIC")), ("BitLength", SimTypeInt(signed=False, label="UInt32")), ("cbPublicExp", SimTypeInt(signed=False, label="UInt32")), ("cbModulus", SimTypeInt(signed=False, label="UInt32")), ("cbPrime1", SimTypeInt(signed=False, label="UInt32")), ("cbPrime2", SimTypeInt(signed=False, label="UInt32")),)), name="BCRYPT_RSAKEY_BLOB", pack=False, align=None),
    "BCRYPT_RSAKEY_BLOB_MAGIC": SimTypeInt(signed=False, label="BCRYPT_RSAKEY_BLOB_MAGIC"),
    "BCRYPT_SECRET_HANDLE": SimTypePointer(SimTypeBottom(label="Void"), offset=0),
    "BCRYPT_TABLE": SimTypeInt(signed=False, label="BCRYPT_TABLE"),
    "BCryptBuffer": SimStruct(OrderedDict((("cbBuffer", SimTypeInt(signed=False, label="UInt32")), ("BufferType", SimTypeInt(signed=False, label="UInt32")), ("pvBuffer", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="BCryptBuffer", pack=False, align=None),
    "BCryptBufferDesc": SimStruct(OrderedDict((("ulVersion", SimTypeInt(signed=False, label="UInt32")), ("cBuffers", SimTypeInt(signed=False, label="UInt32")), ("pBuffers", SimTypePointer(SimTypeRef("BCryptBuffer", SimStruct), offset=0)),)), name="BCryptBufferDesc", pack=False, align=None),
    "BDANODE_DESCRIPTOR": SimStruct(OrderedDict((("ulBdaNodeType", SimTypeInt(signed=False, label="UInt32")), ("guidFunction", SimTypeBottom(label="Guid")), ("guidName", SimTypeBottom(label="Guid")),)), name="BDANODE_DESCRIPTOR", pack=False, align=None),
    "BDA_BUFFER": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulBufferSize", SimTypeInt(signed=False, label="UInt32")), ("argbBuffer", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_BUFFER", pack=False, align=None),
    "BDA_CAS_CHECK_ENTITLEMENTTOKEN": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulDescrambleStatus", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_CAS_CHECK_ENTITLEMENTTOKEN", pack=False, align=None),
    "BDA_CAS_CLOSEMMIDATA": SimStruct(OrderedDict((("ulDialogNumber", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_CAS_CLOSEMMIDATA", pack=False, align=None),
    "BDA_CAS_CLOSE_MMIDIALOG": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("SessionResult", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_CAS_CLOSE_MMIDIALOG", pack=False, align=None),
    "BDA_CAS_OPENMMIDATA": SimStruct(OrderedDict((("ulDialogNumber", SimTypeInt(signed=False, label="UInt32")), ("ulDialogRequest", SimTypeInt(signed=False, label="UInt32")), ("uuidDialogType", SimTypeBottom(label="Guid")), ("usDialogDataLength", SimTypeShort(signed=False, label="UInt16")), ("argbDialogData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_CAS_OPENMMIDATA", pack=False, align=None),
    "BDA_CAS_REQUESTTUNERDATA": SimStruct(OrderedDict((("ucRequestPriority", SimTypeChar(label="Byte")), ("ucRequestReason", SimTypeChar(label="Byte")), ("ucRequestConsequences", SimTypeChar(label="Byte")), ("ulEstimatedTime", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_CAS_REQUESTTUNERDATA", pack=False, align=None),
    "BDA_CA_MODULE_UI": SimStruct(OrderedDict((("ulFormat", SimTypeInt(signed=False, label="UInt32")), ("ulbcDesc", SimTypeInt(signed=False, label="UInt32")), ("ulDesc", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="BDA_CA_MODULE_UI", pack=False, align=None),
    "BDA_CHANGE_STATE": SimTypeInt(signed=False, label="BDA_CHANGE_STATE"),
    "BDA_CONDITIONALACCESS_MMICLOSEREASON": SimTypeInt(signed=False, label="BDA_CONDITIONALACCESS_MMICLOSEREASON"),
    "BDA_CONDITIONALACCESS_REQUESTTYPE": SimTypeInt(signed=False, label="BDA_CONDITIONALACCESS_REQUESTTYPE"),
    "BDA_CONDITIONALACCESS_SESSION_RESULT": SimTypeInt(signed=False, label="BDA_CONDITIONALACCESS_SESSION_RESULT"),
    "BDA_Channel": SimTypeInt(signed=False, label="BDA_Channel"),
    "BDA_Channel_Bandwidth": SimTypeInt(signed=False, label="BDA_Channel_Bandwidth"),
    "BDA_Comp_Flags": SimTypeInt(signed=False, label="BDA_Comp_Flags"),
    "BDA_DEBUG_DATA": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("uuidDebugDataType", SimTypeBottom(label="Guid")), ("ulDataSize", SimTypeInt(signed=False, label="UInt32")), ("argbDebugData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_DEBUG_DATA", pack=False, align=None),
    "BDA_DISCOVERY_STATE": SimTypeInt(signed=False, label="BDA_DISCOVERY_STATE"),
    "BDA_DISEQC_RESPONSE": SimStruct(OrderedDict((("ulRequestId", SimTypeInt(signed=False, label="UInt32")), ("ulPacketLength", SimTypeInt(signed=False, label="UInt32")), ("argbPacketData", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="BDA_DISEQC_RESPONSE", pack=False, align=None),
    "BDA_DISEQC_SEND": SimStruct(OrderedDict((("ulRequestId", SimTypeInt(signed=False, label="UInt32")), ("ulPacketLength", SimTypeInt(signed=False, label="UInt32")), ("argbPacketData", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="BDA_DISEQC_SEND", pack=False, align=None),
    "BDA_DRM_DRMSTATUS": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("DRMuuid", SimTypeBottom(label="Guid")), ("ulDrmUuidListStringSize", SimTypeInt(signed=False, label="UInt32")), ("argbDrmUuidListString", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)),)), name="BDA_DRM_DRMSTATUS", pack=False, align=None),
    "BDA_DVBT2_L1_SIGNALLING_DATA": SimStruct(OrderedDict((("L1Pre_TYPE", SimTypeChar(label="Byte")), ("L1Pre_BWT_S1_S2", SimTypeChar(label="Byte")), ("L1Pre_REPETITION_GUARD_PAPR", SimTypeChar(label="Byte")), ("L1Pre_MOD_COD_FEC", SimTypeChar(label="Byte")), ("L1Pre_POSTSIZE_INFO_PILOT", SimTypeArray(SimTypeChar(label="Byte"), 5)), ("L1Pre_TX_ID_AVAIL", SimTypeChar(label="Byte")), ("L1Pre_CELL_ID", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("L1Pre_NETWORK_ID", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("L1Pre_T2SYSTEM_ID", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("L1Pre_NUM_T2_FRAMES", SimTypeChar(label="Byte")), ("L1Pre_NUM_DATA_REGENFLAG_L1POSTEXT", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("L1Pre_NUMRF_CURRENTRF_RESERVED", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("L1Pre_CRC32", SimTypeArray(SimTypeChar(label="Byte"), 4)), ("L1PostData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_DVBT2_L1_SIGNALLING_DATA", pack=False, align=None),
    "BDA_DigitalSignalStandard": SimTypeInt(signed=False, label="BDA_DigitalSignalStandard"),
    "BDA_DrmPairingError": SimTypeInt(signed=False, label="BDA_DrmPairingError"),
    "BDA_ETHERNET_ADDRESS": SimStruct(OrderedDict((("rgbAddress", SimTypeArray(SimTypeChar(label="Byte"), 6)),)), name="BDA_ETHERNET_ADDRESS", pack=False, align=None),
    "BDA_ETHERNET_ADDRESS_LIST": SimStruct(OrderedDict((("ulcAddresses", SimTypeInt(signed=False, label="UInt32")), ("rgAddressl", SimTypePointer(SimTypeRef("BDA_ETHERNET_ADDRESS", SimStruct), offset=0)),)), name="BDA_ETHERNET_ADDRESS_LIST", pack=False, align=None),
    "BDA_EVENT_DATA": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulEventID", SimTypeInt(signed=False, label="UInt32")), ("uuidEventType", SimTypeBottom(label="Guid")), ("ulEventDataLength", SimTypeInt(signed=False, label="UInt32")), ("argbEventData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_EVENT_DATA", pack=False, align=None),
    "BDA_EVENT_ID": SimTypeInt(signed=False, label="BDA_EVENT_ID"),
    "BDA_Frequency": SimTypeInt(signed=False, label="BDA_Frequency"),
    "BDA_Frequency_Multiplier": SimTypeInt(signed=False, label="BDA_Frequency_Multiplier"),
    "BDA_GDDS_DATA": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulDataLength", SimTypeInt(signed=False, label="UInt32")), ("ulPercentageProgress", SimTypeInt(signed=False, label="UInt32")), ("argbData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_GDDS_DATA", pack=False, align=None),
    "BDA_GDDS_DATATYPE": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("uuidDataType", SimTypeBottom(label="Guid")),)), name="BDA_GDDS_DATATYPE", pack=False, align=None),
    "BDA_IPv4_ADDRESS": SimStruct(OrderedDict((("rgbAddress", SimTypeArray(SimTypeChar(label="Byte"), 4)),)), name="BDA_IPv4_ADDRESS", pack=False, align=None),
    "BDA_IPv4_ADDRESS_LIST": SimStruct(OrderedDict((("ulcAddresses", SimTypeInt(signed=False, label="UInt32")), ("rgAddressl", SimTypePointer(SimTypeRef("BDA_IPv4_ADDRESS", SimStruct), offset=0)),)), name="BDA_IPv4_ADDRESS_LIST", pack=False, align=None),
    "BDA_IPv6_ADDRESS": SimStruct(OrderedDict((("rgbAddress", SimTypeArray(SimTypeChar(label="Byte"), 6)),)), name="BDA_IPv6_ADDRESS", pack=False, align=None),
    "BDA_IPv6_ADDRESS_LIST": SimStruct(OrderedDict((("ulcAddresses", SimTypeInt(signed=False, label="UInt32")), ("rgAddressl", SimTypePointer(SimTypeRef("BDA_IPv6_ADDRESS", SimStruct), offset=0)),)), name="BDA_IPv6_ADDRESS_LIST", pack=False, align=None),
    "BDA_ISDBCAS_EMG_REQ": SimStruct(OrderedDict((("bCLA", SimTypeChar(label="Byte")), ("bINS", SimTypeChar(label="Byte")), ("bP1", SimTypeChar(label="Byte")), ("bP2", SimTypeChar(label="Byte")), ("bLC", SimTypeChar(label="Byte")), ("bCardId", SimTypeArray(SimTypeChar(label="Byte"), 6)), ("bProtocol", SimTypeChar(label="Byte")), ("bCABroadcasterGroupId", SimTypeChar(label="Byte")), ("bMessageControl", SimTypeChar(label="Byte")), ("bMessageCode", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_ISDBCAS_EMG_REQ", pack=False, align=None),
    "BDA_ISDBCAS_REQUESTHEADER": SimStruct(OrderedDict((("bInstruction", SimTypeChar(label="Byte")), ("bReserved", SimTypeArray(SimTypeChar(label="Byte"), 3)), ("ulDataLength", SimTypeInt(signed=False, label="UInt32")), ("argbIsdbCommand", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_ISDBCAS_REQUESTHEADER", pack=False, align=None),
    "BDA_ISDBCAS_RESPONSEDATA": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulRequestID", SimTypeInt(signed=False, label="UInt32")), ("ulIsdbStatus", SimTypeInt(signed=False, label="UInt32")), ("ulIsdbDataSize", SimTypeInt(signed=False, label="UInt32")), ("argbIsdbCommandData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_ISDBCAS_RESPONSEDATA", pack=False, align=None),
    "BDA_LockType": SimTypeInt(signed=False, label="BDA_LockType"),
    "BDA_MULTICAST_MODE": SimTypeInt(signed=False, label="BDA_MULTICAST_MODE"),
    "BDA_MUX_PIDLISTITEM": SimStruct(OrderedDict((("usPIDNumber", SimTypeShort(signed=False, label="UInt16")), ("usProgramNumber", SimTypeShort(signed=False, label="UInt16")), ("ePIDType", SimTypeInt(signed=False, label="MUX_PID_TYPE")),)), name="BDA_MUX_PIDLISTITEM", pack=False, align=None),
    "BDA_PID_MAP": SimStruct(OrderedDict((("MediaSampleContent", SimTypeInt(signed=False, label="MEDIA_SAMPLE_CONTENT")), ("ulcPIDs", SimTypeInt(signed=False, label="UInt32")), ("aulPIDs", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="BDA_PID_MAP", pack=False, align=None),
    "BDA_PID_UNMAP": SimStruct(OrderedDict((("ulcPIDs", SimTypeInt(signed=False, label="UInt32")), ("aulPIDs", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="BDA_PID_UNMAP", pack=False, align=None),
    "BDA_PROGRAM_PID_LIST": SimStruct(OrderedDict((("ulProgramNumber", SimTypeInt(signed=False, label="UInt32")), ("ulcPIDs", SimTypeInt(signed=False, label="UInt32")), ("ulPID", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="BDA_PROGRAM_PID_LIST", pack=False, align=None),
    "BDA_RATING_PINRESET": SimStruct(OrderedDict((("bPinLength", SimTypeChar(label="Byte")), ("argbNewPin", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_RATING_PINRESET", pack=False, align=None),
    "BDA_Range": SimTypeInt(signed=False, label="BDA_Range"),
    "BDA_SCAN_CAPABILTIES": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ul64AnalogStandardsSupported", SimTypeLongLong(signed=False, label="UInt64")),)), name="BDA_SCAN_CAPABILTIES", pack=False, align=None),
    "BDA_SCAN_START": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("LowerFrequency", SimTypeInt(signed=False, label="UInt32")), ("HigerFrequency", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_SCAN_START", pack=False, align=None),
    "BDA_SCAN_STATE": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulSignalLock", SimTypeInt(signed=False, label="UInt32")), ("ulSecondsLeft", SimTypeInt(signed=False, label="UInt32")), ("ulCurrentFrequency", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_SCAN_STATE", pack=False, align=None),
    "BDA_SIGNAL_STATE": SimTypeInt(signed=False, label="BDA_SIGNAL_STATE"),
    "BDA_SIGNAL_TIMEOUTS": SimStruct(OrderedDict((("ulCarrierTimeoutMs", SimTypeInt(signed=False, label="UInt32")), ("ulScanningTimeoutMs", SimTypeInt(signed=False, label="UInt32")), ("ulTuningTimeoutMs", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_SIGNAL_TIMEOUTS", pack=False, align=None),
    "BDA_STRING": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulStringSize", SimTypeInt(signed=False, label="UInt32")), ("argbString", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_STRING", pack=False, align=None),
    "BDA_SignalType": SimTypeInt(signed=False, label="BDA_SignalType"),
    "BDA_TABLE_SECTION": SimStruct(OrderedDict((("ulPrimarySectionId", SimTypeInt(signed=False, label="UInt32")), ("ulSecondarySectionId", SimTypeInt(signed=False, label="UInt32")), ("ulcbSectionLength", SimTypeInt(signed=False, label="UInt32")), ("argbSectionData", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="BDA_TABLE_SECTION", pack=False, align=None),
    "BDA_TEMPLATE_CONNECTION": SimStruct(OrderedDict((("FromNodeType", SimTypeInt(signed=False, label="UInt32")), ("FromNodePinType", SimTypeInt(signed=False, label="UInt32")), ("ToNodeType", SimTypeInt(signed=False, label="UInt32")), ("ToNodePinType", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_TEMPLATE_CONNECTION", pack=False, align=None),
    "BDA_TEMPLATE_PIN_JOINT": SimStruct(OrderedDict((("uliTemplateConnection", SimTypeInt(signed=False, label="UInt32")), ("ulcInstancesMax", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_TEMPLATE_PIN_JOINT", pack=False, align=None),
    "BDA_TRANSPORT_INFO": SimStruct(OrderedDict((("ulcbPhyiscalPacket", SimTypeInt(signed=False, label="UInt32")), ("ulcbPhyiscalFrame", SimTypeInt(signed=False, label="UInt32")), ("ulcbPhyiscalFrameAlignment", SimTypeInt(signed=False, label="UInt32")), ("AvgTimePerFrame", SimTypeLongLong(signed=True, label="Int64")),)), name="BDA_TRANSPORT_INFO", pack=False, align=None),
    "BDA_TS_SELECTORINFO": SimStruct(OrderedDict((("bTSInfolength", SimTypeChar(label="Byte")), ("bReserved", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("guidNetworkType", SimTypeBottom(label="Guid")), ("bTSIDCount", SimTypeChar(label="Byte")), ("usTSID", SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)),)), name="BDA_TS_SELECTORINFO", pack=False, align=None),
    "BDA_TS_SELECTORINFO_ISDBS_EXT": SimStruct(OrderedDict((("bTMCC", SimTypeArray(SimTypeChar(label="Byte"), 48)),)), name="BDA_TS_SELECTORINFO_ISDBS_EXT", pack=False, align=None),
    "BDA_TUNER_DIAGNOSTICS": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulSignalLevel", SimTypeInt(signed=False, label="UInt32")), ("ulSignalLevelQuality", SimTypeInt(signed=False, label="UInt32")), ("ulSignalNoiseRatio", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_TUNER_DIAGNOSTICS", pack=False, align=None),
    "BDA_TUNER_TUNERSTATE": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulTuneLength", SimTypeInt(signed=False, label="UInt32")), ("argbTuneData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_TUNER_TUNERSTATE", pack=False, align=None),
    "BDA_USERACTIVITY_INTERVAL": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulActivityInterval", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_USERACTIVITY_INTERVAL", pack=False, align=None),
    "BDA_WMDRMTUNER_PIDPROTECTION": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("uuidKeyID", SimTypeBottom(label="Guid")),)), name="BDA_WMDRMTUNER_PIDPROTECTION", pack=False, align=None),
    "BDA_WMDRMTUNER_PURCHASEENTITLEMENT": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulDescrambleStatus", SimTypeInt(signed=False, label="UInt32")), ("ulCaptureTokenLength", SimTypeInt(signed=False, label="UInt32")), ("argbCaptureTokenBuffer", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_WMDRMTUNER_PURCHASEENTITLEMENT", pack=False, align=None),
    "BDA_WMDRM_KEYINFOLIST": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulKeyuuidBufferLen", SimTypeInt(signed=False, label="UInt32")), ("argKeyuuidBuffer", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)),)), name="BDA_WMDRM_KEYINFOLIST", pack=False, align=None),
    "BDA_WMDRM_RENEWLICENSE": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulDescrambleStatus", SimTypeInt(signed=False, label="UInt32")), ("ulXmrLicenseOutputLength", SimTypeInt(signed=False, label="UInt32")), ("argbXmrLicenceOutputBuffer", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BDA_WMDRM_RENEWLICENSE", pack=False, align=None),
    "BDA_WMDRM_STATUS": SimStruct(OrderedDict((("lResult", SimTypeInt(signed=True, label="Int32")), ("ulMaxCaptureTokenSize", SimTypeInt(signed=False, label="UInt32")), ("uMaxStreamingPid", SimTypeInt(signed=False, label="UInt32")), ("ulMaxLicense", SimTypeInt(signed=False, label="UInt32")), ("ulMinSecurityLevel", SimTypeInt(signed=False, label="UInt32")), ("ulRevInfoSequenceNumber", SimTypeInt(signed=False, label="UInt32")), ("ulRevInfoIssuedTime", SimTypeLongLong(signed=False, label="UInt64")), ("ulRevListVersion", SimTypeInt(signed=False, label="UInt32")), ("ulRevInfoTTL", SimTypeInt(signed=False, label="UInt32")), ("ulState", SimTypeInt(signed=False, label="UInt32")),)), name="BDA_WMDRM_STATUS", pack=False, align=None),
    "BDCB_CALLBACK_TYPE": SimTypeInt(signed=False, label="BDCB_CALLBACK_TYPE"),
    "BDCB_CLASSIFICATION": SimTypeInt(signed=False, label="BDCB_CLASSIFICATION"),
    "BDCB_IMAGE_INFORMATION": SimStruct(OrderedDict((("Classification", SimTypeInt(signed=False, label="BDCB_CLASSIFICATION")), ("ImageFlags", SimTypeInt(signed=False, label="UInt32")), ("ImageName", SimTypeRef("UNICODE_STRING", SimStruct)), ("RegistryPath", SimTypeRef("UNICODE_STRING", SimStruct)), ("CertificatePublisher", SimTypeRef("UNICODE_STRING", SimStruct)), ("CertificateIssuer", SimTypeRef("UNICODE_STRING", SimStruct)), ("ImageHash", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("CertificateThumbprint", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ImageHashAlgorithm", SimTypeInt(signed=False, label="UInt32")), ("ThumbprintHashAlgorithm", SimTypeInt(signed=False, label="UInt32")), ("ImageHashLength", SimTypeInt(signed=False, label="UInt32")), ("CertificateThumbprintLength", SimTypeInt(signed=False, label="UInt32")),)), name="BDCB_IMAGE_INFORMATION", pack=False, align=None),
    "BDCB_STATUS_UPDATE_CONTEXT": SimStruct(OrderedDict((("StatusType", SimTypeInt(signed=False, label="BDCB_STATUS_UPDATE_TYPE")),)), name="BDCB_STATUS_UPDATE_CONTEXT", pack=False, align=None),
    "BDCB_STATUS_UPDATE_TYPE": SimTypeInt(signed=False, label="BDCB_STATUS_UPDATE_TYPE"),
    "BEHAVIOR_EVENT": SimTypeInt(signed=False, label="BEHAVIOR_EVENT"),
    "BEHAVIOR_EVENT_FLAGS": SimTypeInt(signed=False, label="BEHAVIOR_EVENT_FLAGS"),
    "BEHAVIOR_LAYOUT_INFO": SimTypeInt(signed=False, label="BEHAVIOR_LAYOUT_INFO"),
    "BEHAVIOR_LAYOUT_MODE": SimTypeInt(signed=False, label="BEHAVIOR_LAYOUT_MODE"),
    "BEHAVIOR_RELATION": SimTypeInt(signed=False, label="BEHAVIOR_RELATION"),
    "BEHAVIOR_RENDER_INFO": SimTypeInt(signed=False, label="BEHAVIOR_RENDER_INFO"),
    "BFFCALLBACK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "uMsg", "lParam", "lpData"]), offset=0),
    "BGTYPE": SimTypeInt(signed=False, label="BGTYPE"),
    "BG_AUTH_CREDENTIALS": SimStruct(OrderedDict((("Target", SimTypeInt(signed=False, label="BG_AUTH_TARGET")), ("Scheme", SimTypeInt(signed=False, label="BG_AUTH_SCHEME")), ("Credentials", SimUnion({"Basic": SimTypeRef("BG_BASIC_CREDENTIALS", SimStruct)}, name="<anon>", label="None")),)), name="BG_AUTH_CREDENTIALS", pack=False, align=None),
    "BG_AUTH_CREDENTIALS_UNION": SimUnion({"Basic": SimTypeRef("BG_BASIC_CREDENTIALS", SimStruct)}, name="<anon>", label="None"),
    "BG_AUTH_SCHEME": SimTypeInt(signed=False, label="BG_AUTH_SCHEME"),
    "BG_AUTH_TARGET": SimTypeInt(signed=False, label="BG_AUTH_TARGET"),
    "BG_BASIC_CREDENTIALS": SimStruct(OrderedDict((("UserName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Password", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="BG_BASIC_CREDENTIALS", pack=False, align=None),
    "BG_CERT_STORE_LOCATION": SimTypeInt(signed=False, label="BG_CERT_STORE_LOCATION"),
    "BG_ERROR_CONTEXT": SimTypeInt(signed=False, label="BG_ERROR_CONTEXT"),
    "BG_FILE_INFO": SimStruct(OrderedDict((("RemoteName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("LocalName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="BG_FILE_INFO", pack=False, align=None),
    "BG_FILE_PROGRESS": SimStruct(OrderedDict((("BytesTotal", SimTypeLongLong(signed=False, label="UInt64")), ("BytesTransferred", SimTypeLongLong(signed=False, label="UInt64")), ("Completed", SimTypeInt(signed=True, label="Int32")),)), name="BG_FILE_PROGRESS", pack=False, align=None),
    "BG_FILE_RANGE": SimStruct(OrderedDict((("InitialOffset", SimTypeLongLong(signed=False, label="UInt64")), ("Length", SimTypeLongLong(signed=False, label="UInt64")),)), name="BG_FILE_RANGE", pack=False, align=None),
    "BG_JOB_PRIORITY": SimTypeInt(signed=False, label="BG_JOB_PRIORITY"),
    "BG_JOB_PROGRESS": SimStruct(OrderedDict((("BytesTotal", SimTypeLongLong(signed=False, label="UInt64")), ("BytesTransferred", SimTypeLongLong(signed=False, label="UInt64")), ("FilesTotal", SimTypeInt(signed=False, label="UInt32")), ("FilesTransferred", SimTypeInt(signed=False, label="UInt32")),)), name="BG_JOB_PROGRESS", pack=False, align=None),
    "BG_JOB_PROXY_USAGE": SimTypeInt(signed=False, label="BG_JOB_PROXY_USAGE"),
    "BG_JOB_REPLY_PROGRESS": SimStruct(OrderedDict((("BytesTotal", SimTypeLongLong(signed=False, label="UInt64")), ("BytesTransferred", SimTypeLongLong(signed=False, label="UInt64")),)), name="BG_JOB_REPLY_PROGRESS", pack=False, align=None),
    "BG_JOB_STATE": SimTypeInt(signed=False, label="BG_JOB_STATE"),
    "BG_JOB_TIMES": SimStruct(OrderedDict((("CreationTime", SimTypeRef("FILETIME", SimStruct)), ("ModificationTime", SimTypeRef("FILETIME", SimStruct)), ("TransferCompletionTime", SimTypeRef("FILETIME", SimStruct)),)), name="BG_JOB_TIMES", pack=False, align=None),
    "BG_JOB_TYPE": SimTypeInt(signed=False, label="BG_JOB_TYPE"),
    "BG_TOKEN": SimTypeInt(signed=False, label="BG_TOKEN"),
    "BIDIOPTIONS": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("wMask", SimTypeShort(signed=False, label="UInt16")), ("wEffects", SimTypeShort(signed=False, label="UInt16")),)), name="BIDIOPTIONS", pack=False, align=None),
    "BIDI_DATA": SimStruct(OrderedDict((("dwBidiType", SimTypeInt(signed=False, label="UInt32")), ("u", SimUnion({"bData": SimTypeInt(signed=True, label="Int32"), "iData": SimTypeInt(signed=True, label="Int32"), "sData": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fData": SimTypeFloat(size=32), "biData": SimTypeRef("BINARY_CONTAINER", SimStruct)}, name="<anon>", label="None")),)), name="BIDI_DATA", pack=False, align=None),
    "BIDI_REQUEST_CONTAINER": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("Count", SimTypeInt(signed=False, label="UInt32")), ("aData", SimTypePointer(SimTypeRef("BIDI_REQUEST_DATA", SimStruct), offset=0)),)), name="BIDI_REQUEST_CONTAINER", pack=False, align=None),
    "BIDI_REQUEST_DATA": SimStruct(OrderedDict((("dwReqNumber", SimTypeInt(signed=False, label="UInt32")), ("pSchema", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("data", SimTypeRef("BIDI_DATA", SimStruct)),)), name="BIDI_REQUEST_DATA", pack=False, align=None),
    "BIDI_RESPONSE_CONTAINER": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("Count", SimTypeInt(signed=False, label="UInt32")), ("aData", SimTypePointer(SimTypeRef("BIDI_RESPONSE_DATA", SimStruct), offset=0)),)), name="BIDI_RESPONSE_CONTAINER", pack=False, align=None),
    "BIDI_RESPONSE_DATA": SimStruct(OrderedDict((("dwResult", SimTypeInt(signed=False, label="UInt32")), ("dwReqNumber", SimTypeInt(signed=False, label="UInt32")), ("pSchema", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("data", SimTypeRef("BIDI_DATA", SimStruct)),)), name="BIDI_RESPONSE_DATA", pack=False, align=None),
    "BIDI_TYPE": SimTypeInt(signed=False, label="BIDI_TYPE"),
    "BINARY_BLOB_CREDENTIAL_INFO": SimStruct(OrderedDict((("cbBlob", SimTypeInt(signed=False, label="UInt32")), ("pbBlob", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BINARY_BLOB_CREDENTIAL_INFO", pack=False, align=None),
    "BINARY_CONTAINER": SimStruct(OrderedDict((("cbBuf", SimTypeInt(signed=False, label="UInt32")), ("pData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BINARY_CONTAINER", pack=False, align=None),
    "BINARY_DATA": SimStruct(OrderedDict((("Length", SimTypeShort(signed=False, label="UInt16")), ("Buffer", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="BINARY_DATA", pack=False, align=None),
    "BINDF": SimTypeInt(signed=False, label="BINDF"),
    "BINDF2": SimTypeInt(signed=False, label="BINDF2"),
    "BINDHANDLETYPES": SimTypeInt(signed=False, label="BINDHANDLETYPES"),
    "BINDINFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("szExtraInfo", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("stgmedData", SimTypeRef("STGMEDIUM", SimStruct)), ("grfBindInfoF", SimTypeInt(signed=False, label="UInt32")), ("dwBindVerb", SimTypeInt(signed=False, label="UInt32")), ("szCustomVerb", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cbstgmedData", SimTypeInt(signed=False, label="UInt32")), ("dwOptions", SimTypeInt(signed=False, label="UInt32")), ("dwOptionsFlags", SimTypeInt(signed=False, label="UInt32")), ("dwCodePage", SimTypeInt(signed=False, label="UInt32")), ("securityAttributes", SimTypeRef("SECURITY_ATTRIBUTES", SimStruct)), ("iid", SimTypeBottom(label="Guid")), ("pUnk", SimTypeBottom(label="IUnknown")), ("dwReserved", SimTypeInt(signed=False, label="UInt32")),)), name="BINDINFO", pack=False, align=None),
    "BINDINFOF": SimTypeInt(signed=False, label="BINDINFOF"),
    "BINDINFO_OPTIONS": SimTypeInt(signed=False, label="BINDINFO_OPTIONS"),
    "BINDPTR": SimUnion({"lpfuncdesc": SimTypePointer(SimTypeRef("FUNCDESC", SimStruct), offset=0), "lpvardesc": SimTypePointer(SimTypeRef("VARDESC", SimStruct), offset=0), "lptcomp": SimTypeBottom(label="ITypeComp")}, name="<anon>", label="None"),
    "BINDSPEED": SimTypeInt(signed=False, label="BINDSPEED"),
    "BINDSTATUS": SimTypeInt(signed=False, label="BINDSTATUS"),
    "BINDSTRING": SimTypeInt(signed=False, label="BINDSTRING"),
    "BINDVERB": SimTypeInt(signed=False, label="BINDVERB"),
    "BIND_FLAGS": SimTypeInt(signed=False, label="BIND_FLAGS"),
    "BIND_FLAGS1": SimTypeInt(signed=False, label="BIND_FLAGS1"),
    "BIND_OPTS": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("grfFlags", SimTypeInt(signed=False, label="UInt32")), ("grfMode", SimTypeInt(signed=False, label="UInt32")), ("dwTickCountDeadline", SimTypeInt(signed=False, label="UInt32")),)), name="BIND_OPTS", pack=False, align=None),
    "BIND_OPTS2": SimStruct(OrderedDict((("Base", SimTypeRef("BIND_OPTS", SimStruct)), ("dwTrackFlags", SimTypeInt(signed=False, label="UInt32")), ("dwClassContext", SimTypeInt(signed=False, label="UInt32")), ("locale", SimTypeInt(signed=False, label="UInt32")), ("pServerInfo", SimTypePointer(SimTypeRef("COSERVERINFO", SimStruct), offset=0)),)), name="BIND_OPTS2", pack=False, align=None),
    "BIND_OPTS3": SimStruct(OrderedDict((("Base", SimTypeRef("BIND_OPTS2", SimStruct)), ("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="BIND_OPTS3", pack=False, align=None),
    "BIN_COUNT": SimStruct(OrderedDict((("BinRange", SimTypeRef("BIN_RANGE", SimStruct)), ("BinCount", SimTypeInt(signed=False, label="UInt32")),)), name="BIN_COUNT", pack=False, align=None),
    "BIN_RANGE": SimStruct(OrderedDict((("StartValue", SimTypeLongLong(signed=True, label="Int64")), ("Length", SimTypeLongLong(signed=True, label="Int64")),)), name="BIN_RANGE", pack=False, align=None),
    "BIN_RESULTS": SimStruct(OrderedDict((("NumberOfBins", SimTypeInt(signed=False, label="UInt32")), ("BinCounts", SimTypePointer(SimTypeRef("BIN_COUNT", SimStruct), offset=0)),)), name="BIN_RESULTS", pack=False, align=None),
    "BIN_TYPES": SimTypeInt(signed=False, label="BIN_TYPES"),
    "BITMAP": SimStruct(OrderedDict((("bmType", SimTypeInt(signed=True, label="Int32")), ("bmWidth", SimTypeInt(signed=True, label="Int32")), ("bmHeight", SimTypeInt(signed=True, label="Int32")), ("bmWidthBytes", SimTypeInt(signed=True, label="Int32")), ("bmPlanes", SimTypeShort(signed=False, label="UInt16")), ("bmBitsPixel", SimTypeShort(signed=False, label="UInt16")), ("bmBits", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="BITMAP", pack=False, align=None),
    "BITMAPCOREHEADER": SimStruct(OrderedDict((("bcSize", SimTypeInt(signed=False, label="UInt32")), ("bcWidth", SimTypeShort(signed=False, label="UInt16")), ("bcHeight", SimTypeShort(signed=False, label="UInt16")), ("bcPlanes", SimTypeShort(signed=False, label="UInt16")), ("bcBitCount", SimTypeShort(signed=False, label="UInt16")),)), name="BITMAPCOREHEADER", pack=False, align=None),
    "BITMAPCOREINFO": SimStruct(OrderedDict((("bmciHeader", SimTypeRef("BITMAPCOREHEADER", SimStruct)), ("bmciColors", SimTypePointer(SimTypeRef("RGBTRIPLE", SimStruct), offset=0)),)), name="BITMAPCOREINFO", pack=False, align=None),
    "BITMAPFILEHEADER": SimStruct(OrderedDict((("bfType", SimTypeShort(signed=False, label="UInt16")), ("bfSize", SimTypeInt(signed=False, label="UInt32")), ("bfReserved1", SimTypeShort(signed=False, label="UInt16")), ("bfReserved2", SimTypeShort(signed=False, label="UInt16")), ("bfOffBits", SimTypeInt(signed=False, label="UInt32")),)), name="BITMAPFILEHEADER", pack=False, align=None),
    "BITMAPINFO": SimStruct(OrderedDict((("bmiHeader", SimTypeRef("BITMAPINFOHEADER", SimStruct)), ("bmiColors", SimTypePointer(SimTypeRef("RGBQUAD", SimStruct), offset=0)),)), name="BITMAPINFO", pack=False, align=None),
    "BITMAPINFOHEADER": SimStruct(OrderedDict((("biSize", SimTypeInt(signed=False, label="UInt32")), ("biWidth", SimTypeInt(signed=True, label="Int32")), ("biHeight", SimTypeInt(signed=True, label="Int32")), ("biPlanes", SimTypeShort(signed=False, label="UInt16")), ("biBitCount", SimTypeShort(signed=False, label="UInt16")), ("biCompression", SimTypeInt(signed=False, label="UInt32")), ("biSizeImage", SimTypeInt(signed=False, label="UInt32")), ("biXPelsPerMeter", SimTypeInt(signed=True, label="Int32")), ("biYPelsPerMeter", SimTypeInt(signed=True, label="Int32")), ("biClrUsed", SimTypeInt(signed=False, label="UInt32")), ("biClrImportant", SimTypeInt(signed=False, label="UInt32")),)), name="BITMAPINFOHEADER", pack=False, align=None),
    "BITMAPV4HEADER": SimStruct(OrderedDict((("bV4Size", SimTypeInt(signed=False, label="UInt32")), ("bV4Width", SimTypeInt(signed=True, label="Int32")), ("bV4Height", SimTypeInt(signed=True, label="Int32")), ("bV4Planes", SimTypeShort(signed=False, label="UInt16")), ("bV4BitCount", SimTypeShort(signed=False, label="UInt16")), ("bV4V4Compression", SimTypeInt(signed=False, label="BI_COMPRESSION")), ("bV4SizeImage", SimTypeInt(signed=False, label="UInt32")), ("bV4XPelsPerMeter", SimTypeInt(signed=True, label="Int32")), ("bV4YPelsPerMeter", SimTypeInt(signed=True, label="Int32")), ("bV4ClrUsed", SimTypeInt(signed=False, label="UInt32")), ("bV4ClrImportant", SimTypeInt(signed=False, label="UInt32")), ("bV4RedMask", SimTypeInt(signed=False, label="UInt32")), ("bV4GreenMask", SimTypeInt(signed=False, label="UInt32")), ("bV4BlueMask", SimTypeInt(signed=False, label="UInt32")), ("bV4AlphaMask", SimTypeInt(signed=False, label="UInt32")), ("bV4CSType", SimTypeInt(signed=False, label="UInt32")), ("bV4Endpoints", SimTypeRef("CIEXYZTRIPLE", SimStruct)), ("bV4GammaRed", SimTypeInt(signed=False, label="UInt32")), ("bV4GammaGreen", SimTypeInt(signed=False, label="UInt32")), ("bV4GammaBlue", SimTypeInt(signed=False, label="UInt32")),)), name="BITMAPV4HEADER", pack=False, align=None),
    "BITMAPV5HEADER": SimStruct(OrderedDict((("bV5Size", SimTypeInt(signed=False, label="UInt32")), ("bV5Width", SimTypeInt(signed=True, label="Int32")), ("bV5Height", SimTypeInt(signed=True, label="Int32")), ("bV5Planes", SimTypeShort(signed=False, label="UInt16")), ("bV5BitCount", SimTypeShort(signed=False, label="UInt16")), ("bV5Compression", SimTypeInt(signed=False, label="BI_COMPRESSION")), ("bV5SizeImage", SimTypeInt(signed=False, label="UInt32")), ("bV5XPelsPerMeter", SimTypeInt(signed=True, label="Int32")), ("bV5YPelsPerMeter", SimTypeInt(signed=True, label="Int32")), ("bV5ClrUsed", SimTypeInt(signed=False, label="UInt32")), ("bV5ClrImportant", SimTypeInt(signed=False, label="UInt32")), ("bV5RedMask", SimTypeInt(signed=False, label="UInt32")), ("bV5GreenMask", SimTypeInt(signed=False, label="UInt32")), ("bV5BlueMask", SimTypeInt(signed=False, label="UInt32")), ("bV5AlphaMask", SimTypeInt(signed=False, label="UInt32")), ("bV5CSType", SimTypeInt(signed=False, label="UInt32")), ("bV5Endpoints", SimTypeRef("CIEXYZTRIPLE", SimStruct)), ("bV5GammaRed", SimTypeInt(signed=False, label="UInt32")), ("bV5GammaGreen", SimTypeInt(signed=False, label="UInt32")), ("bV5GammaBlue", SimTypeInt(signed=False, label="UInt32")), ("bV5Intent", SimTypeInt(signed=False, label="UInt32")), ("bV5ProfileData", SimTypeInt(signed=False, label="UInt32")), ("bV5ProfileSize", SimTypeInt(signed=False, label="UInt32")), ("bV5Reserved", SimTypeInt(signed=False, label="UInt32")),)), name="BITMAPV5HEADER", pack=False, align=None),
    "BITMAP_RENDERER_STATISTICS": SimStruct(OrderedDict((("dwFramesDelivered", SimTypeInt(signed=False, label="UInt32")), ("dwFramesDropped", SimTypeInt(signed=False, label="UInt32")),)), name="BITMAP_RENDERER_STATISTICS", pack=False, align=None),
    "BITS_FILE_PROPERTY_ID": SimTypeInt(signed=False, label="BITS_FILE_PROPERTY_ID"),
    "BITS_FILE_PROPERTY_VALUE": SimUnion({"String": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None"),
    "BITS_JOB_PROPERTY_ID": SimTypeInt(signed=False, label="BITS_JOB_PROPERTY_ID"),
    "BITS_JOB_PROPERTY_VALUE": SimUnion({"Dword": SimTypeInt(signed=False, label="UInt32"), "ClsID": SimTypeBottom(label="Guid"), "Enable": SimTypeInt(signed=True, label="Int32"), "Uint64": SimTypeLongLong(signed=False, label="UInt64"), "Target": SimTypeInt(signed=False, label="BG_AUTH_TARGET")}, name="<anon>", label="None"),
    "BITS_JOB_TRANSFER_POLICY": SimTypeInt(signed=False, label="BITS_JOB_TRANSFER_POLICY"),
    "BI_COMPRESSION": SimTypeInt(signed=False, label="BI_COMPRESSION"),
    "BLENDFUNCTION": SimStruct(OrderedDict((("BlendOp", SimTypeChar(label="Byte")), ("BlendFlags", SimTypeChar(label="Byte")), ("SourceConstantAlpha", SimTypeChar(label="Byte")), ("AlphaFormat", SimTypeChar(label="Byte")),)), name="BLENDFUNCTION", pack=False, align=None),
    "BLENDOBJ": SimStruct(OrderedDict((("BlendFunction", SimTypeRef("BLENDFUNCTION", SimStruct)),)), name="BLENDOBJ", pack=False, align=None),
    "BLOB": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pBlobData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BLOB", pack=False, align=None),
    "BLUETOOTH_ADDRESS": SimStruct(OrderedDict((("Anonymous", SimUnion({"ullLong": SimTypeLongLong(signed=False, label="UInt64"), "rgBytes": SimTypeArray(SimTypeChar(label="Byte"), 6)}, name="<anon>", label="None")),)), name="BLUETOOTH_ADDRESS", pack=False, align=None),
    "BLUETOOTH_AUTHENTICATE_RESPONSE": SimStruct(OrderedDict((("bthAddressRemote", SimTypeRef("BLUETOOTH_ADDRESS", SimStruct)), ("authMethod", SimTypeInt(signed=False, label="BLUETOOTH_AUTHENTICATION_METHOD")), ("Anonymous", SimUnion({"pinInfo": SimTypeRef("BLUETOOTH_PIN_INFO", SimStruct), "oobInfo": SimTypeRef("BLUETOOTH_OOB_DATA_INFO", SimStruct), "numericCompInfo": SimTypeRef("BLUETOOTH_NUMERIC_COMPARISON_INFO", SimStruct), "passkeyInfo": SimTypeRef("BLUETOOTH_PASSKEY_INFO", SimStruct)}, name="<anon>", label="None")), ("negativeResponse", SimTypeChar(label="Byte")),)), name="BLUETOOTH_AUTHENTICATE_RESPONSE", pack=False, align=None),
    "BLUETOOTH_AUTHENTICATION_CALLBACK_PARAMS": SimStruct(OrderedDict((("deviceInfo", SimTypeRef("BLUETOOTH_DEVICE_INFO", SimStruct)), ("authenticationMethod", SimTypeInt(signed=False, label="BLUETOOTH_AUTHENTICATION_METHOD")), ("ioCapability", SimTypeInt(signed=False, label="BLUETOOTH_IO_CAPABILITY")), ("authenticationRequirements", SimTypeInt(signed=False, label="BLUETOOTH_AUTHENTICATION_REQUIREMENTS")), ("Anonymous", SimUnion({"Numeric_Value": SimTypeInt(signed=False, label="UInt32"), "Passkey": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")),)), name="BLUETOOTH_AUTHENTICATION_CALLBACK_PARAMS", pack=False, align=None),
    "BLUETOOTH_AUTHENTICATION_METHOD": SimTypeInt(signed=False, label="BLUETOOTH_AUTHENTICATION_METHOD"),
    "BLUETOOTH_AUTHENTICATION_REQUIREMENTS": SimTypeInt(signed=False, label="BLUETOOTH_AUTHENTICATION_REQUIREMENTS"),
    "BLUETOOTH_COD_PAIRS": SimStruct(OrderedDict((("ulCODMask", SimTypeInt(signed=False, label="UInt32")), ("pcszDescription", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="BLUETOOTH_COD_PAIRS", pack=False, align=None),
    "BLUETOOTH_DEVICE_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("Address", SimTypeRef("BLUETOOTH_ADDRESS", SimStruct)), ("ulClassofDevice", SimTypeInt(signed=False, label="UInt32")), ("fConnected", SimTypeInt(signed=True, label="Int32")), ("fRemembered", SimTypeInt(signed=True, label="Int32")), ("fAuthenticated", SimTypeInt(signed=True, label="Int32")), ("stLastSeen", SimTypeRef("SYSTEMTIME", SimStruct)), ("stLastUsed", SimTypeRef("SYSTEMTIME", SimStruct)), ("szName", SimTypeArray(SimTypeChar(label="Char"), 248)),)), name="BLUETOOTH_DEVICE_INFO", pack=False, align=None),
    "BLUETOOTH_DEVICE_SEARCH_PARAMS": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("fReturnAuthenticated", SimTypeInt(signed=True, label="Int32")), ("fReturnRemembered", SimTypeInt(signed=True, label="Int32")), ("fReturnUnknown", SimTypeInt(signed=True, label="Int32")), ("fReturnConnected", SimTypeInt(signed=True, label="Int32")), ("fIssueInquiry", SimTypeInt(signed=True, label="Int32")), ("cTimeoutMultiplier", SimTypeChar(label="Byte")), ("hRadio", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="BLUETOOTH_DEVICE_SEARCH_PARAMS", pack=False, align=None),
    "BLUETOOTH_FIND_RADIO_PARAMS": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")),)), name="BLUETOOTH_FIND_RADIO_PARAMS", pack=False, align=None),
    "BLUETOOTH_GATT_VALUE_CHANGED_EVENT": SimStruct(OrderedDict((("ChangedAttributeHandle", SimTypeShort(signed=False, label="UInt16")), ("CharacteristicValueDataSize", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("CharacteristicValue", SimTypePointer(SimTypeRef("BTH_LE_GATT_CHARACTERISTIC_VALUE", SimStruct), offset=0)),)), name="BLUETOOTH_GATT_VALUE_CHANGED_EVENT", pack=False, align=None),
    "BLUETOOTH_GATT_VALUE_CHANGED_EVENT_REGISTRATION": SimStruct(OrderedDict((("NumCharacteristics", SimTypeShort(signed=False, label="UInt16")), ("Characteristics", SimTypePointer(SimTypeRef("BTH_LE_GATT_CHARACTERISTIC", SimStruct), offset=0)),)), name="BLUETOOTH_GATT_VALUE_CHANGED_EVENT_REGISTRATION", pack=False, align=None),
    "BLUETOOTH_IO_CAPABILITY": SimTypeInt(signed=False, label="BLUETOOTH_IO_CAPABILITY"),
    "BLUETOOTH_LOCAL_SERVICE_INFO": SimStruct(OrderedDict((("Enabled", SimTypeInt(signed=True, label="Int32")), ("btAddr", SimTypeRef("BLUETOOTH_ADDRESS", SimStruct)), ("szName", SimTypeArray(SimTypeChar(label="Char"), 256)), ("szDeviceString", SimTypeArray(SimTypeChar(label="Char"), 256)),)), name="BLUETOOTH_LOCAL_SERVICE_INFO", pack=False, align=None),
    "BLUETOOTH_NUMERIC_COMPARISON_INFO": SimStruct(OrderedDict((("NumericValue", SimTypeInt(signed=False, label="UInt32")),)), name="BLUETOOTH_NUMERIC_COMPARISON_INFO", pack=False, align=None),
    "BLUETOOTH_OOB_DATA_INFO": SimStruct(OrderedDict((("C", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("R", SimTypeArray(SimTypeChar(label="Byte"), 16)),)), name="BLUETOOTH_OOB_DATA_INFO", pack=False, align=None),
    "BLUETOOTH_PASSKEY_INFO": SimStruct(OrderedDict((("passkey", SimTypeInt(signed=False, label="UInt32")),)), name="BLUETOOTH_PASSKEY_INFO", pack=False, align=None),
    "BLUETOOTH_PIN_INFO": SimStruct(OrderedDict((("pin", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("pinLength", SimTypeChar(label="Byte")),)), name="BLUETOOTH_PIN_INFO", pack=False, align=None),
    "BLUETOOTH_RADIO_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("address", SimTypeRef("BLUETOOTH_ADDRESS", SimStruct)), ("szName", SimTypeArray(SimTypeChar(label="Char"), 248)), ("ulClassofDevice", SimTypeInt(signed=False, label="UInt32")), ("lmpSubversion", SimTypeShort(signed=False, label="UInt16")), ("manufacturer", SimTypeShort(signed=False, label="UInt16")),)), name="BLUETOOTH_RADIO_INFO", pack=False, align=None),
    "BLUETOOTH_SELECT_DEVICE_PARAMS": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("cNumOfClasses", SimTypeInt(signed=False, label="UInt32")), ("prgClassOfDevices", SimTypePointer(SimTypeRef("BLUETOOTH_COD_PAIRS", SimStruct), offset=0)), ("pszInfo", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("fForceAuthentication", SimTypeInt(signed=True, label="Int32")), ("fShowAuthenticated", SimTypeInt(signed=True, label="Int32")), ("fShowRemembered", SimTypeInt(signed=True, label="Int32")), ("fShowUnknown", SimTypeInt(signed=True, label="Int32")), ("fAddNewDeviceWizard", SimTypeInt(signed=True, label="Int32")), ("fSkipServicesPage", SimTypeInt(signed=True, label="Int32")), ("pfnDeviceCallback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeRef("BLUETOOTH_DEVICE_INFO", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvParam", "pDevice"]), offset=0)), ("pvParam", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cNumDevices", SimTypeInt(signed=False, label="UInt32")), ("pDevices", SimTypePointer(SimTypeRef("BLUETOOTH_DEVICE_INFO", SimStruct), offset=0)),)), name="BLUETOOTH_SELECT_DEVICE_PARAMS", pack=False, align=None),
    "BMFORMAT": SimTypeInt(signed=False, label="BMFORMAT"),
    "BM_REQUEST_TYPE": SimUnion({"s": SimTypeRef("_BM", SimStruct), "B": SimTypeChar(label="Byte")}, name="<anon>", label="None"),
    "BNSTATE": SimTypeInt(signed=False, label="BNSTATE"),
    "BODYSTATES": SimTypeInt(signed=False, label="BODYSTATES"),
    "BOID": SimStruct(OrderedDict((("rgb", SimTypeArray(SimTypeChar(label="Byte"), 16)),)), name="BOID", pack=False, align=None),
    "BOOL": SimTypeInt(signed=True, label="Int32"),
    "BOOLEAN": SimTypeChar(label="Byte"),
    "BOOTDISK_INFORMATION": SimStruct(OrderedDict((("BootPartitionOffset", SimTypeLongLong(signed=True, label="Int64")), ("SystemPartitionOffset", SimTypeLongLong(signed=True, label="Int64")), ("BootDeviceSignature", SimTypeInt(signed=False, label="UInt32")), ("SystemDeviceSignature", SimTypeInt(signed=False, label="UInt32")),)), name="BOOTDISK_INFORMATION", pack=False, align=None),
    "BOOTDISK_INFORMATION_EX": SimStruct(OrderedDict((("BootPartitionOffset", SimTypeLongLong(signed=True, label="Int64")), ("SystemPartitionOffset", SimTypeLongLong(signed=True, label="Int64")), ("BootDeviceSignature", SimTypeInt(signed=False, label="UInt32")), ("SystemDeviceSignature", SimTypeInt(signed=False, label="UInt32")), ("BootDeviceGuid", SimTypeBottom(label="Guid")), ("SystemDeviceGuid", SimTypeBottom(label="Guid")), ("BootDeviceIsGpt", SimTypeChar(label="Byte")), ("SystemDeviceIsGpt", SimTypeChar(label="Byte")),)), name="BOOTDISK_INFORMATION_EX", pack=False, align=None),
    "BOOTDISK_INFORMATION_LITE": SimStruct(OrderedDict((("NumberEntries", SimTypeInt(signed=False, label="UInt32")), ("Entries", SimTypePointer(SimTypeRef("LOADER_PARTITION_INFORMATION_EX", SimStruct), offset=0)),)), name="BOOTDISK_INFORMATION_LITE", pack=False, align=None),
    "BOOT_AREA_INFO": SimStruct(OrderedDict((("BootSectorCount", SimTypeInt(signed=False, label="UInt32")), ("BootSectors", SimTypeArray(SimStruct(OrderedDict((("Offset", SimTypeLongLong(signed=True, label="Int64")),)), name="_Anonymous_e__Struct", pack=False, align=None), 2)),)), name="BOOT_AREA_INFO", pack=False, align=None),
    "BOOT_DRIVER_CALLBACK_FUNCTION": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="BDCB_CALLBACK_TYPE"), SimTypePointer(SimTypeRef("BDCB_IMAGE_INFORMATION", SimStruct), offset=0)], SimTypeBottom(label="Void"), arg_names=["CallbackContext", "Classification", "ImageInformation"]), offset=0),
    "BORDERSTATES": SimTypeInt(signed=False, label="BORDERSTATES"),
    "BORDERTYPE": SimTypeInt(signed=False, label="BORDERTYPE"),
    "BORDER_HSCROLLSTATES": SimTypeInt(signed=False, label="BORDER_HSCROLLSTATES"),
    "BORDER_HVSCROLLSTATES": SimTypeInt(signed=False, label="BORDER_HVSCROLLSTATES"),
    "BORDER_NOSCROLLSTATES": SimTypeInt(signed=False, label="BORDER_NOSCROLLSTATES"),
    "BORDER_VSCROLLSTATES": SimTypeInt(signed=False, label="BORDER_VSCROLLSTATES"),
    "BOUND_CALLBACK": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=False, label="BOUND_CALLBACK_STATUS")), offset=0),
    "BOUND_CALLBACK_STATUS": SimTypeInt(signed=False, label="BOUND_CALLBACK_STATUS"),
    "BP_ANIMATIONPARAMS": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("style", SimTypeInt(signed=False, label="BP_ANIMATIONSTYLE")), ("dwDuration", SimTypeInt(signed=False, label="UInt32")),)), name="BP_ANIMATIONPARAMS", pack=False, align=None),
    "BP_ANIMATIONSTYLE": SimTypeInt(signed=False, label="BP_ANIMATIONSTYLE"),
    "BP_BUFFERFORMAT": SimTypeInt(signed=False, label="BP_BUFFERFORMAT"),
    "BP_PAINTPARAMS": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="BP_PAINTPARAMS_FLAGS")), ("prcExclude", SimTypePointer(SimTypeRef("RECT", SimStruct), offset=0)), ("pBlendFunction", SimTypePointer(SimTypeRef("BLENDFUNCTION", SimStruct), offset=0)),)), name="BP_PAINTPARAMS", pack=False, align=None),
    "BP_PAINTPARAMS_FLAGS": SimTypeInt(signed=False, label="BP_PAINTPARAMS_FLAGS"),
    "BREAKPOINT_STATE": SimTypeInt(signed=False, label="BREAKPOINT_STATE"),
    "BREAKREASON": SimTypeInt(signed=False, label="BREAKREASON"),
    "BREAKRESUMEACTION": SimTypeInt(signed=False, label="BREAKRESUMEACTION"),
    "BRIGHTNESS_INTERFACE_VERSION": SimTypeInt(signed=False, label="BRIGHTNESS_INTERFACE_VERSION"),
    "BRIGHTNESS_LEVEL": SimStruct(OrderedDict((("Count", SimTypeChar(label="Byte")), ("Level", SimTypeArray(SimTypeChar(label="Byte"), 103)),)), name="BRIGHTNESS_LEVEL", pack=False, align=None),
    "BRIGHTNESS_NIT_RANGE": SimStruct(OrderedDict((("MinLevelInMillinit", SimTypeInt(signed=False, label="UInt32")), ("MaxLevelInMillinit", SimTypeInt(signed=False, label="UInt32")), ("StepSizeInMillinit", SimTypeInt(signed=False, label="UInt32")),)), name="BRIGHTNESS_NIT_RANGE", pack=False, align=None),
    "BRIGHTNESS_NIT_RANGES": SimStruct(OrderedDict((("NormalRangeCount", SimTypeInt(signed=False, label="UInt32")), ("RangeCount", SimTypeInt(signed=False, label="UInt32")), ("PreferredMaximumBrightness", SimTypeInt(signed=False, label="UInt32")), ("SupportedRanges", SimTypeArray(SimTypeRef("BRIGHTNESS_NIT_RANGE", SimStruct), 16)),)), name="BRIGHTNESS_NIT_RANGES", pack=False, align=None),
    "BROADCAST_SYSTEM_MESSAGE_FLAGS": SimTypeInt(signed=False, label="BROADCAST_SYSTEM_MESSAGE_FLAGS"),
    "BROADCAST_SYSTEM_MESSAGE_INFO": SimTypeInt(signed=False, label="BROADCAST_SYSTEM_MESSAGE_INFO"),
    "BROWSEINFOA": SimStruct(OrderedDict((("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pidlRoot", SimTypePointer(SimTypeRef("ITEMIDLIST", SimStruct), offset=0)), ("pszDisplayName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpszTitle", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("ulFlags", SimTypeInt(signed=False, label="UInt32")), ("lpfn", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "uMsg", "lParam", "lpData"]), offset=0)), ("lParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("iImage", SimTypeInt(signed=True, label="Int32")),)), name="BROWSEINFOA", pack=False, align=None),
    "BROWSEINFOW": SimStruct(OrderedDict((("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pidlRoot", SimTypePointer(SimTypeRef("ITEMIDLIST", SimStruct), offset=0)), ("pszDisplayName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpszTitle", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ulFlags", SimTypeInt(signed=False, label="UInt32")), ("lpfn", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "uMsg", "lParam", "lpData"]), offset=0)), ("lParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("iImage", SimTypeInt(signed=True, label="Int32")),)), name="BROWSEINFOW", pack=False, align=None),
    "BRUSHOBJ": SimStruct(OrderedDict((("iSolidColor", SimTypeInt(signed=False, label="UInt32")), ("pvRbrush", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("flColorType", SimTypeInt(signed=False, label="UInt32")),)), name="BRUSHOBJ", pack=False, align=None),
    "BRUSH_STYLE": SimTypeInt(signed=False, label="BRUSH_STYLE"),
    "BSCF": SimTypeInt(signed=False, label="BSCF"),
    "BSMINFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hdesk", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("luid", SimTypeRef("LUID", SimStruct)),)), name="BSMINFO", pack=False, align=None),
    "BSSID_INFO": SimStruct(OrderedDict((("BSSID", SimTypeArray(SimTypeChar(label="Byte"), 6)), ("PMKID", SimTypeArray(SimTypeChar(label="Byte"), 16)),)), name="BSSID_INFO", pack=False, align=None),
    "BSTR": SimTypePointer(SimTypeChar(label="Char"), offset=0),
    "BSTRBLOB": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BSTRBLOB", pack=False, align=None),
    "BTH_DEVICE_INFO": SimStruct(OrderedDict((("flags", SimTypeInt(signed=False, label="UInt32")), ("address", SimTypeLongLong(signed=False, label="UInt64")), ("classOfDevice", SimTypeInt(signed=False, label="UInt32")), ("name", SimTypeArray(SimTypeChar(label="SByte"), 248)),)), name="BTH_DEVICE_INFO", pack=False, align=None),
    "BTH_HCI_EVENT_INFO": SimStruct(OrderedDict((("bthAddress", SimTypeLongLong(signed=False, label="UInt64")), ("connectionType", SimTypeChar(label="Byte")), ("connected", SimTypeChar(label="Byte")),)), name="BTH_HCI_EVENT_INFO", pack=False, align=None),
    "BTH_INFO_REQ": SimStruct(OrderedDict((("btAddr", SimTypeLongLong(signed=False, label="UInt64")), ("infoType", SimTypeShort(signed=False, label="UInt16")),)), name="BTH_INFO_REQ", pack=False, align=None),
    "BTH_INFO_RSP": SimStruct(OrderedDict((("result", SimTypeShort(signed=False, label="UInt16")), ("dataLen", SimTypeChar(label="Byte")), ("Anonymous", SimUnion({"connectionlessMTU": SimTypeShort(signed=False, label="UInt16"), "data": SimTypeArray(SimTypeChar(label="Byte"), 44)}, name="<anon>", label="None")),)), name="BTH_INFO_RSP", pack=False, align=None),
    "BTH_L2CAP_EVENT_INFO": SimStruct(OrderedDict((("bthAddress", SimTypeLongLong(signed=False, label="UInt64")), ("psm", SimTypeShort(signed=False, label="UInt16")), ("connected", SimTypeChar(label="Byte")), ("initiated", SimTypeChar(label="Byte")),)), name="BTH_L2CAP_EVENT_INFO", pack=False, align=None),
    "BTH_LE_GATT_CHARACTERISTIC": SimStruct(OrderedDict((("ServiceHandle", SimTypeShort(signed=False, label="UInt16")), ("CharacteristicUuid", SimTypeRef("BTH_LE_UUID", SimStruct)), ("AttributeHandle", SimTypeShort(signed=False, label="UInt16")), ("CharacteristicValueHandle", SimTypeShort(signed=False, label="UInt16")), ("IsBroadcastable", SimTypeChar(label="Byte")), ("IsReadable", SimTypeChar(label="Byte")), ("IsWritable", SimTypeChar(label="Byte")), ("IsWritableWithoutResponse", SimTypeChar(label="Byte")), ("IsSignedWritable", SimTypeChar(label="Byte")), ("IsNotifiable", SimTypeChar(label="Byte")), ("IsIndicatable", SimTypeChar(label="Byte")), ("HasExtendedProperties", SimTypeChar(label="Byte")),)), name="BTH_LE_GATT_CHARACTERISTIC", pack=False, align=None),
    "BTH_LE_GATT_CHARACTERISTIC_VALUE": SimStruct(OrderedDict((("DataSize", SimTypeInt(signed=False, label="UInt32")), ("Data", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BTH_LE_GATT_CHARACTERISTIC_VALUE", pack=False, align=None),
    "BTH_LE_GATT_DESCRIPTOR": SimStruct(OrderedDict((("ServiceHandle", SimTypeShort(signed=False, label="UInt16")), ("CharacteristicHandle", SimTypeShort(signed=False, label="UInt16")), ("DescriptorType", SimTypeInt(signed=False, label="BTH_LE_GATT_DESCRIPTOR_TYPE")), ("DescriptorUuid", SimTypeRef("BTH_LE_UUID", SimStruct)), ("AttributeHandle", SimTypeShort(signed=False, label="UInt16")),)), name="BTH_LE_GATT_DESCRIPTOR", pack=False, align=None),
    "BTH_LE_GATT_DESCRIPTOR_TYPE": SimTypeInt(signed=False, label="BTH_LE_GATT_DESCRIPTOR_TYPE"),
    "BTH_LE_GATT_DESCRIPTOR_VALUE": SimStruct(OrderedDict((("DescriptorType", SimTypeInt(signed=False, label="BTH_LE_GATT_DESCRIPTOR_TYPE")), ("DescriptorUuid", SimTypeRef("BTH_LE_UUID", SimStruct)), ("Anonymous", SimUnion({"CharacteristicExtendedProperties": SimTypeRef("_CharacteristicExtendedProperties_e__Struct", SimStruct), "ClientCharacteristicConfiguration": SimTypeRef("_ClientCharacteristicConfiguration_e__Struct", SimStruct), "ServerCharacteristicConfiguration": SimTypeRef("_ServerCharacteristicConfiguration_e__Struct", SimStruct), "CharacteristicFormat": SimTypeRef("_CharacteristicFormat_e__Struct", SimStruct)}, name="<anon>", label="None")), ("DataSize", SimTypeInt(signed=False, label="UInt32")), ("Data", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BTH_LE_GATT_DESCRIPTOR_VALUE", pack=False, align=None),
    "BTH_LE_GATT_EVENT_TYPE": SimTypeInt(signed=False, label="BTH_LE_GATT_EVENT_TYPE"),
    "BTH_LE_GATT_SERVICE": SimStruct(OrderedDict((("ServiceUuid", SimTypeRef("BTH_LE_UUID", SimStruct)), ("AttributeHandle", SimTypeShort(signed=False, label="UInt16")),)), name="BTH_LE_GATT_SERVICE", pack=False, align=None),
    "BTH_LE_UUID": SimStruct(OrderedDict((("IsShortUuid", SimTypeChar(label="Byte")), ("Value", SimUnion({"ShortUuid": SimTypeShort(signed=False, label="UInt16"), "LongUuid": SimTypeBottom(label="Guid")}, name="<anon>", label="None")),)), name="BTH_LE_UUID", pack=False, align=None),
    "BTH_PING_REQ": SimStruct(OrderedDict((("btAddr", SimTypeLongLong(signed=False, label="UInt64")), ("dataLen", SimTypeChar(label="Byte")), ("data", SimTypeArray(SimTypeChar(label="Byte"), 44)),)), name="BTH_PING_REQ", pack=False, align=None),
    "BTH_PING_RSP": SimStruct(OrderedDict((("dataLen", SimTypeChar(label="Byte")), ("data", SimTypeArray(SimTypeChar(label="Byte"), 44)),)), name="BTH_PING_RSP", pack=False, align=None),
    "BTH_QUERY_DEVICE": SimStruct(OrderedDict((("LAP", SimTypeInt(signed=False, label="UInt32")), ("length", SimTypeChar(label="Byte")),)), name="BTH_QUERY_DEVICE", pack=False, align=None),
    "BTH_QUERY_SERVICE": SimStruct(OrderedDict((("type", SimTypeInt(signed=False, label="UInt32")), ("serviceHandle", SimTypeInt(signed=False, label="UInt32")), ("uuids", SimTypeArray(SimTypeRef("SdpQueryUuid", SimStruct), 12)), ("numRange", SimTypeInt(signed=False, label="UInt32")), ("pRange", SimTypePointer(SimTypeRef("SdpAttributeRange", SimStruct), offset=0)),)), name="BTH_QUERY_SERVICE", pack=False, align=None),
    "BTH_RADIO_IN_RANGE": SimStruct(OrderedDict((("deviceInfo", SimTypeRef("BTH_DEVICE_INFO", SimStruct)), ("previousDeviceFlags", SimTypeInt(signed=False, label="UInt32")),)), name="BTH_RADIO_IN_RANGE", pack=False, align=None),
    "BTH_SET_SERVICE": SimStruct(OrderedDict((("pSdpVersion", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("pRecordHandle", SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)), ("fCodService", SimTypeInt(signed=False, label="UInt32")), ("Reserved", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 5)), ("ulRecordLength", SimTypeInt(signed=False, label="UInt32")), ("pRecord", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BTH_SET_SERVICE", pack=False, align=None),
    "BUCKETCATEGORIZE": SimStruct(OrderedDict((("cBuckets", SimTypeInt(signed=False, label="UInt32")), ("Distribution", SimTypeInt(signed=False, label="UInt32")),)), name="BUCKETCATEGORIZE", pack=False, align=None),
    "BUCKET_COUNTER": SimStruct(OrderedDict((("Reserved", SimTypeInt(signed=False, label="UInt32")), ("Trim", SimTypeInt(signed=False, label="UInt32")), ("Write", SimTypeInt(signed=False, label="UInt32")), ("Read", SimTypeInt(signed=False, label="UInt32")),)), name="BUCKET_COUNTER", pack=False, align=None),
    "BUGCHECK_ERROR": SimTypeInt(signed=False, label="BUGCHECK_ERROR"),
    "BULK_SECURITY_TEST_DATA": SimStruct(OrderedDict((("DesiredAccess", SimTypeInt(signed=False, label="UInt32")), ("SecurityIds", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="BULK_SECURITY_TEST_DATA", pack=False, align=None),
    "BUSDATA": SimStruct(OrderedDict((("BusDataType", SimTypeInt(signed=False, label="UInt32")), ("BusNumber", SimTypeInt(signed=False, label="UInt32")), ("SlotNumber", SimTypeInt(signed=False, label="UInt32")), ("Buffer", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("Offset", SimTypeInt(signed=False, label="UInt32")), ("Length", SimTypeInt(signed=False, label="UInt32")),)), name="BUSDATA", pack=False, align=None),
    "BUSNUMBER_DES": SimStruct(OrderedDict((("BUSD_Count", SimTypeInt(signed=False, label="UInt32")), ("BUSD_Type", SimTypeInt(signed=False, label="UInt32")), ("BUSD_Flags", SimTypeInt(signed=False, label="UInt32")), ("BUSD_Alloc_Base", SimTypeInt(signed=False, label="UInt32")), ("BUSD_Alloc_End", SimTypeInt(signed=False, label="UInt32")),)), name="BUSNUMBER_DES", pack=False, align=None),
    "BUSNUMBER_RANGE": SimStruct(OrderedDict((("BUSR_Min", SimTypeInt(signed=False, label="UInt32")), ("BUSR_Max", SimTypeInt(signed=False, label="UInt32")), ("BUSR_nBusNumbers", SimTypeInt(signed=False, label="UInt32")), ("BUSR_Flags", SimTypeInt(signed=False, label="UInt32")),)), name="BUSNUMBER_RANGE", pack=False, align=None),
    "BUSNUMBER_RESOURCE": SimStruct(OrderedDict((("BusNumber_Header", SimTypeRef("BUSNUMBER_DES", SimStruct)), ("BusNumber_Data", SimTypePointer(SimTypeRef("BUSNUMBER_RANGE", SimStruct), offset=0)),)), name="BUSNUMBER_RESOURCE", pack=False, align=None),
    "BUSY_DIALOG_FLAGS": SimTypeInt(signed=False, label="BUSY_DIALOG_FLAGS"),
    "BUS_DATA_TYPE": SimTypeInt(signed=False, label="BUS_DATA_TYPE"),
    "BUS_INTERFACE_STANDARD": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Context", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("InterfaceReference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("InterfaceDereference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("TranslateBusAddress", SimTypePointer(SimTypeFunction([], SimTypeChar(label="Byte")), offset=0)), ("GetDmaAdapter", SimTypePointer(SimTypeFunction([], SimTypePointer(SimTypeRef("DMA_ADAPTER", SimStruct), offset=0)), offset=0)), ("SetBusData", SimTypePointer(SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")), offset=0)), ("GetBusData", SimTypePointer(SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")), offset=0)),)), name="BUS_INTERFACE_STANDARD", pack=False, align=None),
    "BUS_QUERY_ID_TYPE": SimTypeInt(signed=False, label="BUS_QUERY_ID_TYPE"),
    "BUS_RESOURCE_UPDATE_INTERFACE": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Context", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("InterfaceReference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("InterfaceDereference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("GetUpdatedBusResource", SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0)),)), name="BUS_RESOURCE_UPDATE_INTERFACE", pack=False, align=None),
    "BUS_SPECIFIC_RESET_FLAGS": SimUnion({"u": SimTypeRef("_u_e__Struct", SimStruct), "AsUlonglong": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"),
    "BUTTONPARTS": SimTypeInt(signed=False, label="BUTTONPARTS"),
    "BUTTON_IMAGELIST": SimStruct(OrderedDict((("himl", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("margin", SimTypeRef("RECT", SimStruct)), ("uAlign", SimTypeInt(signed=False, label="BUTTON_IMAGELIST_ALIGN")),)), name="BUTTON_IMAGELIST", pack=False, align=None),
    "BUTTON_IMAGELIST_ALIGN": SimTypeInt(signed=False, label="BUTTON_IMAGELIST_ALIGN"),
    "BUTTON_SPLITINFO": SimStruct(OrderedDict((("mask", SimTypeInt(signed=False, label="UInt32")), ("himlGlyph", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("uSplitStyle", SimTypeInt(signed=False, label="UInt32")), ("size", SimTypeRef("SIZE", SimStruct)),)), name="BUTTON_SPLITINFO", pack=False, align=None),
    "BYTE_BLOB": SimStruct(OrderedDict((("clSize", SimTypeInt(signed=False, label="UInt32")), ("abData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BYTE_BLOB", pack=False, align=None),
    "BYTE_SIZEDARR": SimStruct(OrderedDict((("clSize", SimTypeInt(signed=False, label="UInt32")), ("pData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BYTE_SIZEDARR", pack=False, align=None),
    "BY_HANDLE_FILE_INFORMATION": SimStruct(OrderedDict((("dwFileAttributes", SimTypeInt(signed=False, label="UInt32")), ("ftCreationTime", SimTypeRef("FILETIME", SimStruct)), ("ftLastAccessTime", SimTypeRef("FILETIME", SimStruct)), ("ftLastWriteTime", SimTypeRef("FILETIME", SimStruct)), ("dwVolumeSerialNumber", SimTypeInt(signed=False, label="UInt32")), ("nFileSizeHigh", SimTypeInt(signed=False, label="UInt32")), ("nFileSizeLow", SimTypeInt(signed=False, label="UInt32")), ("nNumberOfLinks", SimTypeInt(signed=False, label="UInt32")), ("nFileIndexHigh", SimTypeInt(signed=False, label="UInt32")), ("nFileIndexLow", SimTypeInt(signed=False, label="UInt32")),)), name="BY_HANDLE_FILE_INFORMATION", pack=False, align=None),
    "BadSampleInfo": SimStruct(OrderedDict((("hrReason", SimTypeInt(signed=True, label="Int32")),)), name="BadSampleInfo", pack=False, align=None),
    "BaseValueSource": SimTypeInt(signed=False, label="BaseValueSource"),
    "BerElement": SimStruct(OrderedDict((("opaque", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="BerElement", pack=False, align=None),
    "BfEnTvRat_Attributes_CAE_TV": SimTypeInt(signed=False, label="BfEnTvRat_Attributes_CAE_TV"),
    "BfEnTvRat_Attributes_CAF_TV": SimTypeInt(signed=False, label="BfEnTvRat_Attributes_CAF_TV"),
    "BfEnTvRat_Attributes_MPAA": SimTypeInt(signed=False, label="BfEnTvRat_Attributes_MPAA"),
    "BfEnTvRat_Attributes_US_TV": SimTypeInt(signed=False, label="BfEnTvRat_Attributes_US_TV"),
    "BfEnTvRat_GenericAttributes": SimTypeInt(signed=False, label="BfEnTvRat_GenericAttributes"),
    "BinaryConvolutionCodeRate": SimTypeInt(signed=False, label="BinaryConvolutionCodeRate"),
    "BinaryParam": SimStruct(OrderedDict((("Buffer", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("Size", SimTypeShort(signed=True, label="Int16")),)), name="BinaryParam", pack=False, align=None),
    "Bitmap": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "BitmapData": SimStruct(OrderedDict((("Width", SimTypeInt(signed=False, label="UInt32")), ("Height", SimTypeInt(signed=False, label="UInt32")), ("Stride", SimTypeInt(signed=True, label="Int32")), ("PixelFormat", SimTypeInt(signed=True, label="Int32")), ("Scan0", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("Reserved", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="BitmapData", pack=False, align=None),
    "BitmapDescription": SimStruct(OrderedDict((("Width", SimTypeInt(signed=False, label="UInt32")), ("Height", SimTypeInt(signed=False, label="UInt32")), ("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("AlphaMode", SimTypeInt(signed=False, label="DXGI_ALPHA_MODE")),)), name="BitmapDescription", pack=False, align=None),
    "BlackInformation": SimStruct(OrderedDict((("fBlackOnly", SimTypeInt(signed=True, label="Int32")), ("blackWeight", SimTypeFloat(size=32)),)), name="BlackInformation", pack=False, align=None),
    "BlackScreenDiagnosticsCalloutParam": SimTypeInt(signed=False, label="BlackScreenDiagnosticsCalloutParam"),
    "Blur": SimStruct(OrderedDict((("Base", SimTypeRef("Effect", SimStruct)),)), name="Blur", pack=False, align=None),
    "BlurParams": SimStruct(OrderedDict((("radius", SimTypeFloat(size=32)), ("expandEdge", SimTypeInt(signed=True, label="Int32")),)), name="BlurParams", pack=False, align=None),
    "BorderStyleConstants": SimTypeInt(signed=False, label="BorderStyleConstants"),
    "BranchOfficeJobData": SimStruct(OrderedDict((("eEventType", SimTypeInt(signed=False, label="EBranchOfficeJobEventType")), ("JobId", SimTypeInt(signed=False, label="UInt32")), ("JobInfo", SimUnion({"LogJobPrinted": SimTypeRef("BranchOfficeJobDataPrinted", SimStruct), "LogJobRendered": SimTypeRef("BranchOfficeJobDataRendered", SimStruct), "LogJobError": SimTypeRef("BranchOfficeJobDataError", SimStruct), "LogPipelineFailed": SimTypeRef("BranchOfficeJobDataPipelineFailed", SimStruct), "LogOfflineFileFull": SimTypeRef("BranchOfficeLogOfflineFileFull", SimStruct)}, name="<anon>", label="None")),)), name="BranchOfficeJobData", pack=False, align=None),
    "BranchOfficeJobDataContainer": SimStruct(OrderedDict((("cJobDataEntries", SimTypeInt(signed=False, label="UInt32")), ("JobData", SimTypePointer(SimTypeRef("BranchOfficeJobData", SimStruct), offset=0)),)), name="BranchOfficeJobDataContainer", pack=False, align=None),
    "BranchOfficeJobDataError": SimStruct(OrderedDict((("LastError", SimTypeInt(signed=False, label="UInt32")), ("pDocumentName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pUserName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pPrinterName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pDataType", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("TotalSize", SimTypeLongLong(signed=True, label="Int64")), ("PrintedSize", SimTypeLongLong(signed=True, label="Int64")), ("TotalPages", SimTypeInt(signed=False, label="UInt32")), ("PrintedPages", SimTypeInt(signed=False, label="UInt32")), ("pMachineName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pJobError", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pErrorDescription", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="BranchOfficeJobDataError", pack=False, align=None),
    "BranchOfficeJobDataPipelineFailed": SimStruct(OrderedDict((("pDocumentName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pPrinterName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pExtraErrorInfo", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="BranchOfficeJobDataPipelineFailed", pack=False, align=None),
    "BranchOfficeJobDataPrinted": SimStruct(OrderedDict((("Status", SimTypeInt(signed=False, label="UInt32")), ("pDocumentName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pUserName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pMachineName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pPrinterName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pPortName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Size", SimTypeLongLong(signed=True, label="Int64")), ("TotalPages", SimTypeInt(signed=False, label="UInt32")),)), name="BranchOfficeJobDataPrinted", pack=False, align=None),
    "BranchOfficeJobDataRendered": SimStruct(OrderedDict((("Size", SimTypeLongLong(signed=True, label="Int64")), ("ICMMethod", SimTypeInt(signed=False, label="UInt32")), ("Color", SimTypeShort(signed=True, label="Int16")), ("PrintQuality", SimTypeShort(signed=True, label="Int16")), ("YResolution", SimTypeShort(signed=True, label="Int16")), ("Copies", SimTypeShort(signed=True, label="Int16")), ("TTOption", SimTypeShort(signed=True, label="Int16")),)), name="BranchOfficeJobDataRendered", pack=False, align=None),
    "BranchOfficeLogOfflineFileFull": SimStruct(OrderedDict((("pMachineName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="BranchOfficeLogOfflineFileFull", pack=False, align=None),
    "BrightnessContrast": SimStruct(OrderedDict((("Base", SimTypeRef("Effect", SimStruct)),)), name="BrightnessContrast", pack=False, align=None),
    "BrightnessContrastParams": SimStruct(OrderedDict((("brightnessLevel", SimTypeInt(signed=True, label="Int32")), ("contrastLevel", SimTypeInt(signed=True, label="Int32")),)), name="BrightnessContrastParams", pack=False, align=None),
    "BrowserNavConstants": SimTypeInt(signed=False, label="BrowserNavConstants"),
    "BrushType": SimTypeInt(signed=False, label="BrushType"),
    "BucketParameterIndex": SimTypeInt(signed=False, label="BucketParameterIndex"),
    "BucketParameters": SimStruct(OrderedDict((("fInited", SimTypeInt(signed=True, label="Int32")), ("pszEventTypeName", SimTypeArray(SimTypeChar(label="Char"), 255)), ("pszParams", SimTypeArray(SimTypeChar(label="Char"), 2550)),)), name="BucketParameters", pack=False, align=None),
    "BufferUnion": SimUnion({"Address": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "IndexAndOffset": SimTypeRef("IORING_REGISTERED_BUFFER", SimStruct)}, name="<anon>", label="None"),
    "BulletStyle": SimTypeInt(signed=False, label="BulletStyle"),
    "CABINETSTATE": SimStruct(OrderedDict((("cLength", SimTypeShort(signed=False, label="UInt16")), ("nVersion", SimTypeShort(signed=False, label="UInt16")), ("_bitfield", SimTypeInt(signed=True, label="Int32")), ("fMenuEnumFilter", SimTypeInt(signed=False, label="UInt32")),)), name="CABINETSTATE", pack=False, align=None),
    "CABINET_INFO_A": SimStruct(OrderedDict((("CabinetPath", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("CabinetFile", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("DiskName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("SetId", SimTypeShort(signed=False, label="UInt16")), ("CabinetNumber", SimTypeShort(signed=False, label="UInt16")),)), name="CABINET_INFO_A", pack=False, align=None),
    "CABINET_INFO_W": SimStruct(OrderedDict((("CabinetPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("CabinetFile", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("DiskName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("SetId", SimTypeShort(signed=False, label="UInt16")), ("CabinetNumber", SimTypeShort(signed=False, label="UInt16")),)), name="CABINET_INFO_W", pack=False, align=None),
    "CABINFOA": SimStruct(OrderedDict((("pszCab", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pszInf", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pszSection", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("szSrcPath", SimTypeArray(SimTypeChar(label="SByte"), 260)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CABINFOA", pack=False, align=None),
    "CABINFOW": SimStruct(OrderedDict((("pszCab", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszInf", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszSection", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("szSrcPath", SimTypeArray(SimTypeChar(label="Char"), 260)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CABINFOW", pack=False, align=None),
    "CABOOL": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)),)), name="CABOOL", pack=False, align=None),
    "CABSTR": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="CABSTR", pack=False, align=None),
    "CABSTRBLOB": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeRef("BSTRBLOB", SimStruct), offset=0)),)), name="CABSTRBLOB", pack=False, align=None),
    "CAC": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CAC", pack=False, align=None),
    "CACHE_ACCESS_CHECK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("GENERIC_MAPPING", SimStruct), offset=0), SimTypePointer(SimTypeRef("PRIVILEGE_SET", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "hClientToken", "dwDesiredAccess", "GenericMapping", "PrivilegeSet", "PrivilegeSetLength", "GrantedAccess", "AccessStatus"]), offset=0),
    "CACHE_CONFIG": SimTypeInt(signed=False, label="CACHE_CONFIG"),
    "CACHE_DESCRIPTOR": SimStruct(OrderedDict((("Level", SimTypeChar(label="Byte")), ("Associativity", SimTypeChar(label="Byte")), ("LineSize", SimTypeShort(signed=False, label="UInt16")), ("Size", SimTypeInt(signed=False, label="UInt32")), ("Type", SimTypeInt(signed=False, label="PROCESSOR_CACHE_TYPE")),)), name="CACHE_DESCRIPTOR", pack=False, align=None),
    "CACHE_DESTROY_CALLBACK": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["cb", "lpb"]), offset=0),
    "CACHE_KEY_COMPARE": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["cbKey1", "lpbKey1", "cbKey2", "lpbKey2"]), offset=0),
    "CACHE_KEY_HASH": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpbKey", "cbKey"]), offset=0),
    "CACHE_MANAGER_CALLBACKS": SimStruct(OrderedDict((("AcquireForLazyWrite", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte")], SimTypeChar(label="Byte"), arg_names=["Context", "Wait"]), offset=0)), ("ReleaseFromLazyWrite", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("AcquireForReadAhead", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte")], SimTypeChar(label="Byte"), arg_names=["Context", "Wait"]), offset=0)), ("ReleaseFromReadAhead", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)),)), name="CACHE_MANAGER_CALLBACKS", pack=False, align=None),
    "CACHE_MANAGER_CALLBACKS_EX": SimStruct(OrderedDict((("Version", SimTypeShort(signed=False, label="UInt16")), ("Size", SimTypeShort(signed=False, label="UInt16")), ("Functions", SimTypeRef("CACHE_MANAGER_CALLBACK_FUNCTIONS", SimStruct)),)), name="CACHE_MANAGER_CALLBACKS_EX", pack=False, align=None),
    "CACHE_MANAGER_CALLBACK_FUNCTIONS": SimStruct(OrderedDict((("AcquireForLazyWriteEx", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["Context", "InFlags", "OutFlags"]), offset=0)), ("ReleaseFromLazyWrite", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("AcquireForReadAhead", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte")], SimTypeChar(label="Byte"), arg_names=["Context", "Wait"]), offset=0)), ("ReleaseFromReadAhead", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)),)), name="CACHE_MANAGER_CALLBACK_FUNCTIONS", pack=False, align=None),
    "CACHE_OPERATOR": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("INTERNET_CACHE_ENTRY_INFOA", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcei", "pcbcei", "pOpData"]), offset=0),
    "CACHE_READ_CALLBACK": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["cb", "lpb", "lpvContext"]), offset=0),
    "CACHE_RELATIONSHIP": SimStruct(OrderedDict((("Level", SimTypeChar(label="Byte")), ("Associativity", SimTypeChar(label="Byte")), ("LineSize", SimTypeShort(signed=False, label="UInt16")), ("CacheSize", SimTypeInt(signed=False, label="UInt32")), ("Type", SimTypeInt(signed=False, label="PROCESSOR_CACHE_TYPE")), ("Reserved", SimTypeArray(SimTypeChar(label="Byte"), 18)), ("GroupCount", SimTypeShort(signed=False, label="UInt16")), ("Anonymous", SimUnion({"GroupMask": SimTypeRef("GROUP_AFFINITY", SimStruct), "GroupMasks": SimTypePointer(SimTypeRef("GROUP_AFFINITY", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="CACHE_RELATIONSHIP", pack=False, align=None),
    "CACHE_UNINITIALIZE_EVENT": SimStruct(OrderedDict((("Next", SimTypePointer(SimTypeRef("CACHE_UNINITIALIZE_EVENT", SimStruct), offset=0)), ("Event", SimTypeRef("KEVENT", SimStruct)),)), name="CACHE_UNINITIALIZE_EVENT", pack=False, align=None),
    "CACLIPDATA": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeRef("CLIPDATA", SimStruct), offset=0)),)), name="CACLIPDATA", pack=False, align=None),
    "CACLSID": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)),)), name="CACLSID", pack=False, align=None),
    "CACY": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimUnion({"Anonymous": SimStruct(OrderedDict((("Lo", SimTypeInt(signed=False, label="UInt32")), ("Hi", SimTypeInt(signed=True, label="Int32")),)), name="_Anonymous_e__Struct", pack=False, align=None), "int64": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)),)), name="CACY", pack=False, align=None),
    "CADATE": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeFloat(size=64), offset=0)),)), name="CADATE", pack=False, align=None),
    "CADBL": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeFloat(size=64), offset=0)),)), name="CADBL", pack=False, align=None),
    "CADWORD": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="CADWORD", pack=False, align=None),
    "CAFILETIME": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeRef("FILETIME", SimStruct), offset=0)),)), name="CAFILETIME", pack=False, align=None),
    "CAFLT": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeFloat(size=32), offset=0)),)), name="CAFLT", pack=False, align=None),
    "CAH": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)),)), name="CAH", pack=False, align=None),
    "CAI": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)),)), name="CAI", pack=False, align=None),
    "CAINFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("CAType", SimTypeInt(signed=False, label="ENUM_CATYPES")), ("cCASignatureCerts", SimTypeInt(signed=False, label="UInt32")), ("cCAExchangeCerts", SimTypeInt(signed=False, label="UInt32")), ("cExitModules", SimTypeInt(signed=False, label="UInt32")), ("lPropIdMax", SimTypeInt(signed=True, label="Int32")), ("lRoleSeparationEnabled", SimTypeInt(signed=True, label="Int32")), ("cKRACertUsedCount", SimTypeInt(signed=False, label="UInt32")), ("cKRACertCount", SimTypeInt(signed=False, label="UInt32")), ("fAdvancedServer", SimTypeInt(signed=False, label="UInt32")),)), name="CAINFO", pack=False, align=None),
    "CAL": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)),)), name="CAL", pack=False, align=None),
    "CALDATETIME": SimStruct(OrderedDict((("CalId", SimTypeInt(signed=False, label="UInt32")), ("Era", SimTypeInt(signed=False, label="UInt32")), ("Year", SimTypeInt(signed=False, label="UInt32")), ("Month", SimTypeInt(signed=False, label="UInt32")), ("Day", SimTypeInt(signed=False, label="UInt32")), ("DayOfWeek", SimTypeInt(signed=False, label="UInt32")), ("Hour", SimTypeInt(signed=False, label="UInt32")), ("Minute", SimTypeInt(signed=False, label="UInt32")), ("Second", SimTypeInt(signed=False, label="UInt32")), ("Tick", SimTypeInt(signed=False, label="UInt32")),)), name="CALDATETIME", pack=False, align=None),
    "CALDATETIME_DATEUNIT": SimTypeInt(signed=False, label="CALDATETIME_DATEUNIT"),
    "CALINFO_ENUMPROCA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0),
    "CALINFO_ENUMPROCEXA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0),
    "CALINFO_ENUMPROCEXEX": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0),
    "CALINFO_ENUMPROCEXW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0),
    "CALINFO_ENUMPROCW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0),
    "CALLCONV": SimTypeInt(signed=False, label="CALLCONV"),
    "CALLERRELEASE": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="ITableData"), SimTypeBottom(label="IMAPITable")], SimTypeBottom(label="Void"), arg_names=["ulCallerData", "lpTblData", "lpVue"]), offset=0),
    "CALLFRAMEINFO": SimStruct(OrderedDict((("iMethod", SimTypeInt(signed=False, label="UInt32")), ("fHasInValues", SimTypeInt(signed=True, label="Int32")), ("fHasInOutValues", SimTypeInt(signed=True, label="Int32")), ("fHasOutValues", SimTypeInt(signed=True, label="Int32")), ("fDerivesFromIDispatch", SimTypeInt(signed=True, label="Int32")), ("cInInterfacesMax", SimTypeInt(signed=True, label="Int32")), ("cInOutInterfacesMax", SimTypeInt(signed=True, label="Int32")), ("cOutInterfacesMax", SimTypeInt(signed=True, label="Int32")), ("cTopLevelInInterfaces", SimTypeInt(signed=True, label="Int32")), ("iid", SimTypeBottom(label="Guid")), ("cMethod", SimTypeInt(signed=False, label="UInt32")), ("cParams", SimTypeInt(signed=False, label="UInt32")),)), name="CALLFRAMEINFO", pack=False, align=None),
    "CALLFRAMEPARAMINFO": SimStruct(OrderedDict((("fIn", SimTypeChar(label="Byte")), ("fOut", SimTypeChar(label="Byte")), ("stackOffset", SimTypeInt(signed=False, label="UInt32")), ("cbParam", SimTypeInt(signed=False, label="UInt32")),)), name="CALLFRAMEPARAMINFO", pack=False, align=None),
    "CALLFRAME_COPY": SimTypeInt(signed=False, label="CALLFRAME_COPY"),
    "CALLFRAME_FREE": SimTypeInt(signed=False, label="CALLFRAME_FREE"),
    "CALLFRAME_MARSHALCONTEXT": SimStruct(OrderedDict((("fIn", SimTypeChar(label="Byte")), ("dwDestContext", SimTypeInt(signed=False, label="UInt32")), ("pvDestContext", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("punkReserved", SimTypeBottom(label="IUnknown")), ("guidTransferSyntax", SimTypeBottom(label="Guid")),)), name="CALLFRAME_MARSHALCONTEXT", pack=False, align=None),
    "CALLFRAME_NULL": SimTypeInt(signed=False, label="CALLFRAME_NULL"),
    "CALLFRAME_WALK": SimTypeInt(signed=False, label="CALLFRAME_WALK"),
    "CALLHUB_EVENT": SimTypeInt(signed=False, label="CALLHUB_EVENT"),
    "CALLHUB_STATE": SimTypeInt(signed=False, label="CALLHUB_STATE"),
    "CALLINFOCHANGE_CAUSE": SimTypeInt(signed=False, label="CALLINFOCHANGE_CAUSE"),
    "CALLINFO_BUFFER": SimTypeInt(signed=False, label="CALLINFO_BUFFER"),
    "CALLINFO_LONG": SimTypeInt(signed=False, label="CALLINFO_LONG"),
    "CALLINFO_STRING": SimTypeInt(signed=False, label="CALLINFO_STRING"),
    "CALLTYPE": SimTypeInt(signed=False, label="CALLTYPE"),
    "CALL_MEDIA_EVENT": SimTypeInt(signed=False, label="CALL_MEDIA_EVENT"),
    "CALL_MEDIA_EVENT_CAUSE": SimTypeInt(signed=False, label="CALL_MEDIA_EVENT_CAUSE"),
    "CALL_NOTIFICATION_EVENT": SimTypeInt(signed=False, label="CALL_NOTIFICATION_EVENT"),
    "CALL_PRIVILEGE": SimTypeInt(signed=False, label="CALL_PRIVILEGE"),
    "CALL_STATE": SimTypeInt(signed=False, label="CALL_STATE"),
    "CALL_STATE_EVENT_CAUSE": SimTypeInt(signed=False, label="CALL_STATE_EVENT_CAUSE"),
    "CALPOLESTR": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="CALPOLESTR", pack=False, align=None),
    "CALPSTR": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)),)), name="CALPSTR", pack=False, align=None),
    "CALPWSTR": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="CALPWSTR", pack=False, align=None),
    "CANDIDATEFORM": SimStruct(OrderedDict((("dwIndex", SimTypeInt(signed=False, label="UInt32")), ("dwStyle", SimTypeInt(signed=False, label="UInt32")), ("ptCurrentPos", SimTypeRef("POINT", SimStruct)), ("rcArea", SimTypeRef("RECT", SimStruct)),)), name="CANDIDATEFORM", pack=False, align=None),
    "CANDIDATEINFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwCount", SimTypeInt(signed=False, label="UInt32")), ("dwOffset", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 32)), ("dwPrivateSize", SimTypeInt(signed=False, label="UInt32")), ("dwPrivateOffset", SimTypeInt(signed=False, label="UInt32")),)), name="CANDIDATEINFO", pack=False, align=None),
    "CANDIDATELIST": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwStyle", SimTypeInt(signed=False, label="UInt32")), ("dwCount", SimTypeInt(signed=False, label="UInt32")), ("dwSelection", SimTypeInt(signed=False, label="UInt32")), ("dwPageStart", SimTypeInt(signed=False, label="UInt32")), ("dwPageSize", SimTypeInt(signed=False, label="UInt32")), ("dwOffset", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="CANDIDATELIST", pack=False, align=None),
    "CAPCONTROLCALLBACK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "nState"]), offset=0),
    "CAPDRIVERCAPS": SimStruct(OrderedDict((("wDeviceIndex", SimTypeInt(signed=False, label="UInt32")), ("fHasOverlay", SimTypeInt(signed=True, label="Int32")), ("fHasDlgVideoSource", SimTypeInt(signed=True, label="Int32")), ("fHasDlgVideoFormat", SimTypeInt(signed=True, label="Int32")), ("fHasDlgVideoDisplay", SimTypeInt(signed=True, label="Int32")), ("fCaptureInitialized", SimTypeInt(signed=True, label="Int32")), ("fDriverSuppliesPalettes", SimTypeInt(signed=True, label="Int32")), ("hVideoIn", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hVideoOut", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hVideoExtIn", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hVideoExtOut", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CAPDRIVERCAPS", pack=False, align=None),
    "CAPERRORCALLBACKA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "nID", "lpsz"]), offset=0),
    "CAPERRORCALLBACKW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "nID", "lpsz"]), offset=0),
    "CAPINFOCHUNK": SimStruct(OrderedDict((("fccInfoID", SimTypeInt(signed=False, label="UInt32")), ("lpData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cbData", SimTypeInt(signed=True, label="Int32")),)), name="CAPINFOCHUNK", pack=False, align=None),
    "CAPROPVARIANT": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeRef("PROPVARIANT", SimStruct), offset=0)),)), name="CAPROPVARIANT", pack=False, align=None),
    "CAPSTATUS": SimStruct(OrderedDict((("uiImageWidth", SimTypeInt(signed=False, label="UInt32")), ("uiImageHeight", SimTypeInt(signed=False, label="UInt32")), ("fLiveWindow", SimTypeInt(signed=True, label="Int32")), ("fOverlayWindow", SimTypeInt(signed=True, label="Int32")), ("fScale", SimTypeInt(signed=True, label="Int32")), ("ptScroll", SimTypeRef("POINT", SimStruct)), ("fUsingDefaultPalette", SimTypeInt(signed=True, label="Int32")), ("fAudioHardware", SimTypeInt(signed=True, label="Int32")), ("fCapFileExists", SimTypeInt(signed=True, label="Int32")), ("dwCurrentVideoFrame", SimTypeInt(signed=False, label="UInt32")), ("dwCurrentVideoFramesDropped", SimTypeInt(signed=False, label="UInt32")), ("dwCurrentWaveSamples", SimTypeInt(signed=False, label="UInt32")), ("dwCurrentTimeElapsedMS", SimTypeInt(signed=False, label="UInt32")), ("hPalCurrent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("fCapturingNow", SimTypeInt(signed=True, label="Int32")), ("dwReturn", SimTypeInt(signed=False, label="UInt32")), ("wNumVideoAllocated", SimTypeInt(signed=False, label="UInt32")), ("wNumAudioAllocated", SimTypeInt(signed=False, label="UInt32")),)), name="CAPSTATUS", pack=False, align=None),
    "CAPSTATUSCALLBACKA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "nID", "lpsz"]), offset=0),
    "CAPSTATUSCALLBACKW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "nID", "lpsz"]), offset=0),
    "CAPTIONSTATES": SimTypeInt(signed=False, label="CAPTIONSTATES"),
    "CAPTUREPARMS": SimStruct(OrderedDict((("dwRequestMicroSecPerFrame", SimTypeInt(signed=False, label="UInt32")), ("fMakeUserHitOKToCapture", SimTypeInt(signed=True, label="Int32")), ("wPercentDropForError", SimTypeInt(signed=False, label="UInt32")), ("fYield", SimTypeInt(signed=True, label="Int32")), ("dwIndexSize", SimTypeInt(signed=False, label="UInt32")), ("wChunkGranularity", SimTypeInt(signed=False, label="UInt32")), ("fUsingDOSMemory", SimTypeInt(signed=True, label="Int32")), ("wNumVideoRequested", SimTypeInt(signed=False, label="UInt32")), ("fCaptureAudio", SimTypeInt(signed=True, label="Int32")), ("wNumAudioRequested", SimTypeInt(signed=False, label="UInt32")), ("vKeyAbort", SimTypeInt(signed=False, label="UInt32")), ("fAbortLeftMouse", SimTypeInt(signed=True, label="Int32")), ("fAbortRightMouse", SimTypeInt(signed=True, label="Int32")), ("fLimitEnabled", SimTypeInt(signed=True, label="Int32")), ("wTimeLimit", SimTypeInt(signed=False, label="UInt32")), ("fMCIControl", SimTypeInt(signed=True, label="Int32")), ("fStepMCIDevice", SimTypeInt(signed=True, label="Int32")), ("dwMCIStartTime", SimTypeInt(signed=False, label="UInt32")), ("dwMCIStopTime", SimTypeInt(signed=False, label="UInt32")), ("fStepCaptureAt2x", SimTypeInt(signed=True, label="Int32")), ("wStepCaptureAverageFrames", SimTypeInt(signed=False, label="UInt32")), ("dwAudioBufferSize", SimTypeInt(signed=False, label="UInt32")), ("fDisableWriteCache", SimTypeInt(signed=True, label="Int32")), ("AVStreamMaster", SimTypeInt(signed=False, label="UInt32")),)), name="CAPTUREPARMS", pack=False, align=None),
    "CAPTURE_MEMORY_ALLOCATION_FLAGS": SimTypeInt(signed=False, label="CAPTURE_MEMORY_ALLOCATION_FLAGS"),
    "CAPTURE_STREAMTIME": SimStruct(OrderedDict((("StreamTime", SimTypeLongLong(signed=True, label="Int64")),)), name="CAPTURE_STREAMTIME", pack=False, align=None),
    "CAPVIDEOCALLBACK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("VIDEOHDR", SimStruct), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "lpVHdr"]), offset=0),
    "CAPWAVECALLBACK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("WAVEHDR", SimStruct), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "lpWHdr"]), offset=0),
    "CAPYIELDCALLBACK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd"]), offset=0),
    "CARET_DIRECTION": SimTypeInt(signed=False, label="CARET_DIRECTION"),
    "CARET_FLAGS": SimTypeInt(signed=False, label="CARET_FLAGS"),
    "CARET_INFO": SimUnion({"hbitmap": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "caretFlags": SimTypeInt(signed=False, label="CARET_FLAGS")}, name="<anon>", label="None"),
    "CASCADE_WINDOWS_HOW": SimTypeInt(signed=False, label="CASCADE_WINDOWS_HOW"),
    "CASCODE": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)),)), name="CASCODE", pack=False, align=None),
    "CASE_REQUIREMENT": SimTypeInt(signed=False, label="CASE_REQUIREMENT"),
    "CASetupProperty": SimTypeInt(signed=False, label="CASetupProperty"),
    "CATALOG_INFO": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("wszCatalogFile", SimTypeArray(SimTypeChar(label="Char"), 260)),)), name="CATALOG_INFO", pack=False, align=None),
    "CATEGORIZATION": SimStruct(OrderedDict((("ulCatType", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"cClusters": SimTypeInt(signed=False, label="UInt32"), "bucket": SimTypeRef("BUCKETCATEGORIZE", SimStruct), "range": SimTypeRef("RANGECATEGORIZE", SimStruct)}, name="<anon>", label="None")), ("csColumns", SimTypeRef("COLUMNSET", SimStruct)),)), name="CATEGORIZATION", pack=False, align=None),
    "CATEGORIZATIONSET": SimStruct(OrderedDict((("cCat", SimTypeInt(signed=False, label="UInt32")), ("aCat", SimTypePointer(SimTypeRef("CATEGORIZATION", SimStruct), offset=0)),)), name="CATEGORIZATIONSET", pack=False, align=None),
    "CATEGORYINFO": SimStruct(OrderedDict((("catid", SimTypeBottom(label="Guid")), ("lcid", SimTypeInt(signed=False, label="UInt32")), ("szDescription", SimTypeArray(SimTypeChar(label="Char"), 128)),)), name="CATEGORYINFO", pack=False, align=None),
    "CATEGORYINFO_FLAGS": SimTypeInt(signed=False, label="CATEGORYINFO_FLAGS"),
    "CATEGORY_INFO": SimStruct(OrderedDict((("cif", SimTypeInt(signed=False, label="CATEGORYINFO_FLAGS")), ("wszName", SimTypeArray(SimTypeChar(label="Char"), 260)),)), name="CATEGORY_INFO", pack=False, align=None),
    "CATSORT_FLAGS": SimTypeInt(signed=False, label="CATSORT_FLAGS"),
    "CAT_MEMBERINFO": SimStruct(OrderedDict((("pwszSubjGuid", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwCertVersion", SimTypeInt(signed=False, label="UInt32")),)), name="CAT_MEMBERINFO", pack=False, align=None),
    "CAT_MEMBERINFO2": SimStruct(OrderedDict((("SubjectGuid", SimTypeBottom(label="Guid")), ("dwCertVersion", SimTypeInt(signed=False, label="UInt32")),)), name="CAT_MEMBERINFO2", pack=False, align=None),
    "CAT_NAMEVALUE": SimStruct(OrderedDict((("pwszTag", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("fdwFlags", SimTypeInt(signed=False, label="UInt32")), ("Value", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CAT_NAMEVALUE", pack=False, align=None),
    "CAUB": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CAUB", pack=False, align=None),
    "CAUH": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)),)), name="CAUH", pack=False, align=None),
    "CAUI": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)),)), name="CAUI", pack=False, align=None),
    "CAUL": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="CAUL", pack=False, align=None),
    "CAUUID": SimStruct(OrderedDict((("cElems", SimTypeInt(signed=False, label="UInt32")), ("pElems", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)),)), name="CAUUID", pack=False, align=None),
    "CBADMITRESULT": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeRef("POLICY_DECISION", SimStruct), offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), arg_names=["LpmHandle", "RequestHandle", "ulPcmActionFlags", "LpmError", "PolicyDecisionsCount", "pPolicyDecisions"]), offset=0),
    "CBGETRSVPOBJECTS": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeRef("RsvpObjHdr", SimStruct), offset=0), offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), arg_names=["LpmHandle", "RequestHandle", "LpmError", "RsvpObjectsCount", "ppRsvpObjects"]), offset=0),
    "CBTACTIVATESTRUCT": SimStruct(OrderedDict((("fMouse", SimTypeInt(signed=True, label="Int32")), ("hWndActive", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CBTACTIVATESTRUCT", pack=False, align=None),
    "CBT_CREATEWNDA": SimStruct(OrderedDict((("lpcs", SimTypePointer(SimTypeRef("CREATESTRUCTA", SimStruct), offset=0)), ("hwndInsertAfter", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CBT_CREATEWNDA", pack=False, align=None),
    "CBT_CREATEWNDW": SimStruct(OrderedDict((("lpcs", SimTypePointer(SimTypeRef("CREATESTRUCTW", SimStruct), offset=0)), ("hwndInsertAfter", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CBT_CREATEWNDW", pack=False, align=None),
    "CCAB": SimStruct(OrderedDict((("cb", SimTypeInt(signed=False, label="UInt32")), ("cbFolderThresh", SimTypeInt(signed=False, label="UInt32")), ("cbReserveCFHeader", SimTypeInt(signed=False, label="UInt32")), ("cbReserveCFFolder", SimTypeInt(signed=False, label="UInt32")), ("cbReserveCFData", SimTypeInt(signed=False, label="UInt32")), ("iCab", SimTypeInt(signed=True, label="Int32")), ("iDisk", SimTypeInt(signed=True, label="Int32")), ("fFailOnIncompressible", SimTypeInt(signed=True, label="Int32")), ("setID", SimTypeShort(signed=False, label="UInt16")), ("szDisk", SimTypeArray(SimTypeChar(label="SByte"), 256)), ("szCab", SimTypeArray(SimTypeChar(label="SByte"), 256)), ("szCabPath", SimTypeArray(SimTypeChar(label="SByte"), 256)),)), name="CCAB", pack=False, align=None),
    "CCINFOA": SimStruct(OrderedDict((("szClass", SimTypeArray(SimTypeChar(label="SByte"), 32)), ("flOptions", SimTypeInt(signed=False, label="UInt32")), ("szDesc", SimTypeArray(SimTypeChar(label="SByte"), 32)), ("cxDefault", SimTypeInt(signed=False, label="UInt32")), ("cyDefault", SimTypeInt(signed=False, label="UInt32")), ("flStyleDefault", SimTypeInt(signed=False, label="UInt32")), ("flExtStyleDefault", SimTypeInt(signed=False, label="UInt32")), ("flCtrlTypeMask", SimTypeInt(signed=False, label="UInt32")), ("szTextDefault", SimTypeArray(SimTypeChar(label="SByte"), 256)), ("cStyleFlags", SimTypeInt(signed=True, label="Int32")), ("aStyleFlags", SimTypePointer(SimTypeRef("CCSTYLEFLAGA", SimStruct), offset=0)), ("lpfnStyle", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("CCSTYLEA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndParent", "pccs"]), offset=0)), ("lpfnSizeToText", SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["flStyle", "flExtStyle", "hfont", "pszText"]), offset=0)), ("dwReserved1", SimTypeInt(signed=False, label="UInt32")), ("dwReserved2", SimTypeInt(signed=False, label="UInt32")),)), name="CCINFOA", pack=False, align=None),
    "CCINFOW": SimStruct(OrderedDict((("szClass", SimTypeArray(SimTypeChar(label="Char"), 32)), ("flOptions", SimTypeInt(signed=False, label="UInt32")), ("szDesc", SimTypeArray(SimTypeChar(label="Char"), 32)), ("cxDefault", SimTypeInt(signed=False, label="UInt32")), ("cyDefault", SimTypeInt(signed=False, label="UInt32")), ("flStyleDefault", SimTypeInt(signed=False, label="UInt32")), ("flExtStyleDefault", SimTypeInt(signed=False, label="UInt32")), ("flCtrlTypeMask", SimTypeInt(signed=False, label="UInt32")), ("cStyleFlags", SimTypeInt(signed=True, label="Int32")), ("aStyleFlags", SimTypePointer(SimTypeRef("CCSTYLEFLAGW", SimStruct), offset=0)), ("szTextDefault", SimTypeArray(SimTypeChar(label="Char"), 256)), ("lpfnStyle", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("CCSTYLEW", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndParent", "pccs"]), offset=0)), ("lpfnSizeToText", SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["flStyle", "flExtStyle", "hfont", "pszText"]), offset=0)), ("dwReserved1", SimTypeInt(signed=False, label="UInt32")), ("dwReserved2", SimTypeInt(signed=False, label="UInt32")),)), name="CCINFOW", pack=False, align=None),
    "CCM_COMMANDID_MASK_CONSTANTS": SimTypeInt(signed=False, label="CCM_COMMANDID_MASK_CONSTANTS"),
    "CCM_INSERTIONALLOWED": SimTypeInt(signed=False, label="CCM_INSERTIONALLOWED"),
    "CCM_INSERTIONPOINTID": SimTypeInt(signed=False, label="CCM_INSERTIONPOINTID"),
    "CCM_SPECIAL": SimTypeInt(signed=False, label="CCM_SPECIAL"),
    "CCSTYLEA": SimStruct(OrderedDict((("flStyle", SimTypeInt(signed=False, label="UInt32")), ("flExtStyle", SimTypeInt(signed=False, label="UInt32")), ("szText", SimTypeArray(SimTypeChar(label="SByte"), 256)), ("lgid", SimTypeShort(signed=False, label="UInt16")), ("wReserved1", SimTypeShort(signed=False, label="UInt16")),)), name="CCSTYLEA", pack=False, align=None),
    "CCSTYLEFLAGA": SimStruct(OrderedDict((("flStyle", SimTypeInt(signed=False, label="UInt32")), ("flStyleMask", SimTypeInt(signed=False, label="UInt32")), ("pszStyle", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CCSTYLEFLAGA", pack=False, align=None),
    "CCSTYLEFLAGW": SimStruct(OrderedDict((("flStyle", SimTypeInt(signed=False, label="UInt32")), ("flStyleMask", SimTypeInt(signed=False, label="UInt32")), ("pszStyle", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CCSTYLEFLAGW", pack=False, align=None),
    "CCSTYLEW": SimStruct(OrderedDict((("flStyle", SimTypeInt(signed=False, label="UInt32")), ("flExtStyle", SimTypeInt(signed=False, label="UInt32")), ("szText", SimTypeArray(SimTypeChar(label="Char"), 256)), ("lgid", SimTypeShort(signed=False, label="UInt16")), ("wReserved1", SimTypeShort(signed=False, label="UInt16")),)), name="CCSTYLEW", pack=False, align=None),
    "CC_ASYNC_READ_CONTEXT": SimStruct(OrderedDict((("CompletionRoutine", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeChar(label="Byte"), arg_names=["Context"]), offset=0)), ("Context", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("Mdl", SimTypePointer(SimTypeRef("MDL", SimStruct), offset=0)), ("RequestorMode", SimTypeChar(label="SByte")), ("NestingLevel", SimTypeInt(signed=False, label="UInt32")),)), name="CC_ASYNC_READ_CONTEXT", pack=False, align=None),
    "CC_BYTE_PAIR": SimStruct(OrderedDict((("Decoded", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("Reserved", SimTypeShort(signed=False, label="UInt16")),)), name="CC_BYTE_PAIR", pack=False, align=None),
    "CC_ERROR_CALLBACK_CONTEXT": SimStruct(OrderedDict((("NodeByteSize", SimTypeShort(signed=True, label="Int16")), ("ErrorCode", SimTypeInt(signed=True, label="Int32")),)), name="CC_ERROR_CALLBACK_CONTEXT", pack=False, align=None),
    "CC_FILE_SIZES": SimStruct(OrderedDict((("AllocationSize", SimTypeLongLong(signed=True, label="Int64")), ("FileSize", SimTypeLongLong(signed=True, label="Int64")), ("ValidDataLength", SimTypeLongLong(signed=True, label="Int64")),)), name="CC_FILE_SIZES", pack=False, align=None),
    "CC_HW_FIELD": SimStruct(OrderedDict((("ScanlinesRequested", SimTypeRef("VBICODECFILTERING_SCANLINES", SimStruct)), ("fieldFlags", SimTypeInt(signed=False, label="UInt32")), ("PictureNumber", SimTypeLongLong(signed=True, label="Int64")), ("Lines", SimTypeArray(SimTypeRef("CC_BYTE_PAIR", SimStruct), 12)),)), name="CC_HW_FIELD", pack=False, align=None),
    "CDBURNINGEXTENSIONRET": SimTypeInt(signed=False, label="CDBURNINGEXTENSIONRET"),
    "CDCONTROLSTATEF": SimTypeInt(signed=False, label="CDCONTROLSTATEF"),
    "CDDDXGK_REDIRBITMAPPRESENTINFO": SimStruct(OrderedDict((("NumDirtyRects", SimTypeInt(signed=False, label="UInt32")), ("DirtyRect", SimTypePointer(SimTypeRef("RECT", SimStruct), offset=0)), ("NumContexts", SimTypeInt(signed=False, label="UInt32")), ("hContext", SimTypeArray(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), 65)), ("bDoNotSynchronizeWithDxContent", SimTypeChar(label="Byte")),)), name="CDDDXGK_REDIRBITMAPPRESENTINFO", pack=False, align=None),
    "CDS_TYPE": SimTypeInt(signed=False, label="CDS_TYPE"),
    "CENTRAL_ACCESS_POLICY": SimStruct(OrderedDict((("CAPID", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("Name", SimTypeRef("LSA_UNICODE_STRING", SimStruct)), ("Description", SimTypeRef("LSA_UNICODE_STRING", SimStruct)), ("ChangeId", SimTypeRef("LSA_UNICODE_STRING", SimStruct)), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("CAPECount", SimTypeInt(signed=False, label="UInt32")), ("CAPEs", SimTypePointer(SimTypePointer(SimTypeRef("CENTRAL_ACCESS_POLICY_ENTRY", SimStruct), offset=0), offset=0)),)), name="CENTRAL_ACCESS_POLICY", pack=False, align=None),
    "CENTRAL_ACCESS_POLICY_ENTRY": SimStruct(OrderedDict((("Name", SimTypeRef("LSA_UNICODE_STRING", SimStruct)), ("Description", SimTypeRef("LSA_UNICODE_STRING", SimStruct)), ("ChangeId", SimTypeRef("LSA_UNICODE_STRING", SimStruct)), ("LengthAppliesTo", SimTypeInt(signed=False, label="UInt32")), ("AppliesTo", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("LengthSD", SimTypeInt(signed=False, label="UInt32")), ("SD", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("LengthStagedSD", SimTypeInt(signed=False, label="UInt32")), ("StagedSD", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")),)), name="CENTRAL_ACCESS_POLICY_ENTRY", pack=False, align=None),
    "CEPSetupProperty": SimTypeInt(signed=False, label="CEPSetupProperty"),
    "CERTADMIN_GET_ROLES_FLAGS": SimTypeInt(signed=False, label="CERTADMIN_GET_ROLES_FLAGS"),
    "CERTENROLL_OBJECTID": SimTypeInt(signed=False, label="CERTENROLL_OBJECTID"),
    "CERTENROLL_PROPERTYID": SimTypeInt(signed=False, label="CERTENROLL_PROPERTYID"),
    "CERTIFICATE_CHAIN_BLOB": SimStruct(OrderedDict((("certCount", SimTypeInt(signed=False, label="UInt32")), ("rawCertificates", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)),)), name="CERTIFICATE_CHAIN_BLOB", pack=False, align=None),
    "CERTTRANSBLOB": SimStruct(OrderedDict((("cb", SimTypeInt(signed=False, label="UInt32")), ("pb", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CERTTRANSBLOB", pack=False, align=None),
    "CERTVIEWRESTRICTION": SimStruct(OrderedDict((("ColumnIndex", SimTypeInt(signed=False, label="UInt32")), ("SeekOperator", SimTypeInt(signed=True, label="Int32")), ("SortOrder", SimTypeInt(signed=True, label="Int32")), ("pbValue", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbValue", SimTypeInt(signed=False, label="UInt32")),)), name="CERTVIEWRESTRICTION", pack=False, align=None),
    "CERT_ACCESS_DESCRIPTION": SimStruct(OrderedDict((("pszAccessMethod", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("AccessLocation", SimTypeRef("CERT_ALT_NAME_ENTRY", SimStruct)),)), name="CERT_ACCESS_DESCRIPTION", pack=False, align=None),
    "CERT_ALT_NAME": SimTypeInt(signed=False, label="CERT_ALT_NAME"),
    "CERT_ALT_NAME_ENTRY": SimStruct(OrderedDict((("dwAltNameChoice", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"pOtherName": SimTypePointer(SimTypeRef("CERT_OTHER_NAME", SimStruct), offset=0), "pwszRfc822Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszDNSName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DirectoryName": SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), "pwszURL": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IPAddress": SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), "pszRegisteredID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")),)), name="CERT_ALT_NAME_ENTRY", pack=False, align=None),
    "CERT_ALT_NAME_INFO": SimStruct(OrderedDict((("cAltEntry", SimTypeInt(signed=False, label="UInt32")), ("rgAltEntry", SimTypePointer(SimTypeRef("CERT_ALT_NAME_ENTRY", SimStruct), offset=0)),)), name="CERT_ALT_NAME_INFO", pack=False, align=None),
    "CERT_AUTHORITY_INFO_ACCESS": SimStruct(OrderedDict((("cAccDescr", SimTypeInt(signed=False, label="UInt32")), ("rgAccDescr", SimTypePointer(SimTypeRef("CERT_ACCESS_DESCRIPTION", SimStruct), offset=0)),)), name="CERT_AUTHORITY_INFO_ACCESS", pack=False, align=None),
    "CERT_AUTHORITY_KEY_ID2_INFO": SimStruct(OrderedDict((("KeyId", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("AuthorityCertIssuer", SimTypeRef("CERT_ALT_NAME_INFO", SimStruct)), ("AuthorityCertSerialNumber", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_AUTHORITY_KEY_ID2_INFO", pack=False, align=None),
    "CERT_AUTHORITY_KEY_ID_INFO": SimStruct(OrderedDict((("KeyId", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("CertIssuer", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("CertSerialNumber", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_AUTHORITY_KEY_ID_INFO", pack=False, align=None),
    "CERT_BASIC_CONSTRAINTS2_INFO": SimStruct(OrderedDict((("fCA", SimTypeInt(signed=True, label="Int32")), ("fPathLenConstraint", SimTypeInt(signed=True, label="Int32")), ("dwPathLenConstraint", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_BASIC_CONSTRAINTS2_INFO", pack=False, align=None),
    "CERT_BASIC_CONSTRAINTS_INFO": SimStruct(OrderedDict((("SubjectType", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)), ("fPathLenConstraint", SimTypeInt(signed=True, label="Int32")), ("dwPathLenConstraint", SimTypeInt(signed=False, label="UInt32")), ("cSubtreesConstraint", SimTypeInt(signed=False, label="UInt32")), ("rgSubtreesConstraint", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)),)), name="CERT_BASIC_CONSTRAINTS_INFO", pack=False, align=None),
    "CERT_BIOMETRIC_DATA": SimStruct(OrderedDict((("dwTypeOfBiometricDataChoice", SimTypeInt(signed=False, label="CERT_BIOMETRIC_DATA_TYPE")), ("Anonymous", SimUnion({"dwPredefined": SimTypeInt(signed=False, label="UInt32"), "pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")), ("HashedUrl", SimTypeRef("CERT_HASHED_URL", SimStruct)),)), name="CERT_BIOMETRIC_DATA", pack=False, align=None),
    "CERT_BIOMETRIC_DATA_TYPE": SimTypeInt(signed=False, label="CERT_BIOMETRIC_DATA_TYPE"),
    "CERT_BIOMETRIC_EXT_INFO": SimStruct(OrderedDict((("cBiometricData", SimTypeInt(signed=False, label="UInt32")), ("rgBiometricData", SimTypePointer(SimTypeRef("CERT_BIOMETRIC_DATA", SimStruct), offset=0)),)), name="CERT_BIOMETRIC_EXT_INFO", pack=False, align=None),
    "CERT_CHAIN": SimStruct(OrderedDict((("cCerts", SimTypeInt(signed=False, label="UInt32")), ("certs", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)), ("keyLocatorInfo", SimTypeRef("CRYPT_KEY_PROV_INFO", SimStruct)),)), name="CERT_CHAIN", pack=False, align=None),
    "CERT_CHAIN_CONTEXT": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("TrustStatus", SimTypeRef("CERT_TRUST_STATUS", SimStruct)), ("cChain", SimTypeInt(signed=False, label="UInt32")), ("rgpChain", SimTypePointer(SimTypePointer(SimTypeRef("CERT_SIMPLE_CHAIN", SimStruct), offset=0), offset=0)), ("cLowerQualityChainContext", SimTypeInt(signed=False, label="UInt32")), ("rgpLowerQualityChainContext", SimTypePointer(SimTypePointer(SimTypeRef("CERT_CHAIN_CONTEXT", SimStruct), offset=0), offset=0)), ("fHasRevocationFreshnessTime", SimTypeInt(signed=True, label="Int32")), ("dwRevocationFreshnessTime", SimTypeInt(signed=False, label="UInt32")), ("dwCreateFlags", SimTypeInt(signed=False, label="UInt32")), ("ChainId", SimTypeBottom(label="Guid")),)), name="CERT_CHAIN_CONTEXT", pack=False, align=None),
    "CERT_CHAIN_ELEMENT": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pCertContext", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("TrustStatus", SimTypeRef("CERT_TRUST_STATUS", SimStruct)), ("pRevocationInfo", SimTypePointer(SimTypeRef("CERT_REVOCATION_INFO", SimStruct), offset=0)), ("pIssuanceUsage", SimTypePointer(SimTypeRef("CTL_USAGE", SimStruct), offset=0)), ("pApplicationUsage", SimTypePointer(SimTypeRef("CTL_USAGE", SimStruct), offset=0)), ("pwszExtendedErrorInfo", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CERT_CHAIN_ELEMENT", pack=False, align=None),
    "CERT_CHAIN_ENGINE_CONFIG": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hRestrictedRoot", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("hRestrictedTrust", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("hRestrictedOther", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cAdditionalStore", SimTypeInt(signed=False, label="UInt32")), ("rghAdditionalStore", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwUrlRetrievalTimeout", SimTypeInt(signed=False, label="UInt32")), ("MaximumCachedCertificates", SimTypeInt(signed=False, label="UInt32")), ("CycleDetectionModulus", SimTypeInt(signed=False, label="UInt32")), ("hExclusiveRoot", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("hExclusiveTrustedPeople", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("dwExclusiveFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_CHAIN_ENGINE_CONFIG", pack=False, align=None),
    "CERT_CHAIN_FIND_BY_ISSUER_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pszUsageIdentifier", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwKeySpec", SimTypeInt(signed=False, label="UInt32")), ("dwAcquirePrivateKeyFlags", SimTypeInt(signed=False, label="UInt32")), ("cIssuer", SimTypeInt(signed=False, label="UInt32")), ("rgIssuer", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)), ("pfnFindCallback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCert", "pvFindArg"]), offset=0)), ("pvFindArg", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CERT_CHAIN_FIND_BY_ISSUER_PARA", pack=False, align=None),
    "CERT_CHAIN_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("RequestedUsage", SimTypeRef("CERT_USAGE_MATCH", SimStruct)),)), name="CERT_CHAIN_PARA", pack=False, align=None),
    "CERT_CHAIN_POLICY_FLAGS": SimTypeInt(signed=False, label="CERT_CHAIN_POLICY_FLAGS"),
    "CERT_CHAIN_POLICY_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="CERT_CHAIN_POLICY_FLAGS")), ("pvExtraPolicyPara", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CERT_CHAIN_POLICY_PARA", pack=False, align=None),
    "CERT_CHAIN_POLICY_STATUS": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwError", SimTypeInt(signed=False, label="UInt32")), ("lChainIndex", SimTypeInt(signed=True, label="Int32")), ("lElementIndex", SimTypeInt(signed=True, label="Int32")), ("pvExtraPolicyStatus", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CERT_CHAIN_POLICY_STATUS", pack=False, align=None),
    "CERT_CONTEXT": SimStruct(OrderedDict((("dwCertEncodingType", SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE")), ("pbCertEncoded", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbCertEncoded", SimTypeInt(signed=False, label="UInt32")), ("pCertInfo", SimTypePointer(SimTypeRef("CERT_INFO", SimStruct), offset=0)), ("hCertStore", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CERT_CONTEXT", pack=False, align=None),
    "CERT_CONTEXT_EX": SimStruct(OrderedDict((("CertContext", SimTypeRef("CERT_CONTEXT", SimStruct)), ("cbAllocated", SimTypeInt(signed=False, label="UInt32")), ("dwCertificateFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_CONTEXT_EX", pack=False, align=None),
    "CERT_CONTROL_STORE_FLAGS": SimTypeInt(signed=False, label="CERT_CONTROL_STORE_FLAGS"),
    "CERT_CREATE_CONTEXT_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pfnFree", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0)), ("pvFree", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pfnSort", SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["cbTotalEncoded", "cbRemainEncoded", "cEntry", "pvSort"]), offset=0)), ("pvSort", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CERT_CREATE_CONTEXT_PARA", pack=False, align=None),
    "CERT_CREATE_REQUEST_FLAGS": SimTypeInt(signed=False, label="CERT_CREATE_REQUEST_FLAGS"),
    "CERT_CREATE_SELFSIGN_FLAGS": SimTypeInt(signed=False, label="CERT_CREATE_SELFSIGN_FLAGS"),
    "CERT_CREDENTIAL_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("rgbHashOfCert", SimTypeArray(SimTypeChar(label="Byte"), 20)),)), name="CERT_CREDENTIAL_INFO", pack=False, align=None),
    "CERT_CRL_CONTEXT_PAIR": SimStruct(OrderedDict((("pCertContext", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("pCrlContext", SimTypePointer(SimTypeRef("CRL_CONTEXT", SimStruct), offset=0)),)), name="CERT_CRL_CONTEXT_PAIR", pack=False, align=None),
    "CERT_DELETE_ROW_FLAGS": SimTypeInt(signed=False, label="CERT_DELETE_ROW_FLAGS"),
    "CERT_DH_PARAMETERS": SimStruct(OrderedDict((("p", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("g", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_DH_PARAMETERS", pack=False, align=None),
    "CERT_DSS_PARAMETERS": SimStruct(OrderedDict((("p", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("q", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("g", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_DSS_PARAMETERS", pack=False, align=None),
    "CERT_ECC_SIGNATURE": SimStruct(OrderedDict((("r", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("s", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_ECC_SIGNATURE", pack=False, align=None),
    "CERT_EXIT_EVENT_MASK": SimTypeInt(signed=False, label="CERT_EXIT_EVENT_MASK"),
    "CERT_EXTENSION": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("fCritical", SimTypeInt(signed=True, label="Int32")), ("Value", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_EXTENSION", pack=False, align=None),
    "CERT_EXTENSIONS": SimStruct(OrderedDict((("cExtension", SimTypeInt(signed=False, label="UInt32")), ("rgExtension", SimTypePointer(SimTypeRef("CERT_EXTENSION", SimStruct), offset=0)),)), name="CERT_EXTENSIONS", pack=False, align=None),
    "CERT_FILTER_DATA": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("cExtensionChecks", SimTypeInt(signed=False, label="UInt32")), ("arrayExtensionChecks", SimTypePointer(SimTypeRef("CERT_FILTER_EXTENSION_MATCH", SimStruct), offset=0)), ("dwCheckingFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_FILTER_DATA", pack=False, align=None),
    "CERT_FILTER_EXTENSION_MATCH": SimStruct(OrderedDict((("szExtensionOID", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwTestOperation", SimTypeInt(signed=False, label="UInt32")), ("pbTestData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbTestData", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_FILTER_EXTENSION_MATCH", pack=False, align=None),
    "CERT_FIND_CHAIN_IN_STORE_FLAGS": SimTypeInt(signed=False, label="CERT_FIND_CHAIN_IN_STORE_FLAGS"),
    "CERT_FIND_FLAGS": SimTypeInt(signed=False, label="CERT_FIND_FLAGS"),
    "CERT_FIND_TYPE": SimTypeInt(signed=False, label="CERT_FIND_TYPE"),
    "CERT_FORTEZZA_DATA_PROP": SimStruct(OrderedDict((("SerialNumber", SimTypeArray(SimTypeChar(label="Byte"), 8)), ("CertIndex", SimTypeInt(signed=True, label="Int32")), ("CertLabel", SimTypeArray(SimTypeChar(label="Byte"), 36)),)), name="CERT_FORTEZZA_DATA_PROP", pack=False, align=None),
    "CERT_GENERAL_SUBTREE": SimStruct(OrderedDict((("Base", SimTypeRef("CERT_ALT_NAME_ENTRY", SimStruct)), ("dwMinimum", SimTypeInt(signed=False, label="UInt32")), ("fMaximum", SimTypeInt(signed=True, label="Int32")), ("dwMaximum", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_GENERAL_SUBTREE", pack=False, align=None),
    "CERT_GET_CONFIG_FLAGS": SimTypeInt(signed=False, label="CERT_GET_CONFIG_FLAGS"),
    "CERT_HASHED_URL": SimStruct(OrderedDict((("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("Hash", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("pwszUrl", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CERT_HASHED_URL", pack=False, align=None),
    "CERT_ID": SimStruct(OrderedDict((("dwIdChoice", SimTypeInt(signed=False, label="CERT_ID_OPTION")), ("Anonymous", SimUnion({"IssuerSerialNumber": SimTypeRef("CERT_ISSUER_SERIAL_NUMBER", SimStruct), "KeyId": SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), "HashId": SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)}, name="<anon>", label="None")),)), name="CERT_ID", pack=False, align=None),
    "CERT_ID_OPTION": SimTypeInt(signed=False, label="CERT_ID_OPTION"),
    "CERT_IMPORT_FLAGS": SimTypeInt(signed=False, label="CERT_IMPORT_FLAGS"),
    "CERT_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("SerialNumber", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("SignatureAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("Issuer", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("NotBefore", SimTypeRef("FILETIME", SimStruct)), ("NotAfter", SimTypeRef("FILETIME", SimStruct)), ("Subject", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("SubjectPublicKeyInfo", SimTypeRef("CERT_PUBLIC_KEY_INFO", SimStruct)), ("IssuerUniqueId", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)), ("SubjectUniqueId", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)), ("cExtension", SimTypeInt(signed=False, label="UInt32")), ("rgExtension", SimTypePointer(SimTypeRef("CERT_EXTENSION", SimStruct), label="LPArray", offset=0)),)), name="CERT_INFO", pack=False, align=None),
    "CERT_ISSUER_SERIAL_NUMBER": SimStruct(OrderedDict((("Issuer", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("SerialNumber", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_ISSUER_SERIAL_NUMBER", pack=False, align=None),
    "CERT_KEYGEN_REQUEST_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("SubjectPublicKeyInfo", SimTypeRef("CERT_PUBLIC_KEY_INFO", SimStruct)), ("pwszChallengeString", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CERT_KEYGEN_REQUEST_INFO", pack=False, align=None),
    "CERT_KEY_ATTRIBUTES_INFO": SimStruct(OrderedDict((("KeyId", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("IntendedKeyUsage", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)), ("pPrivateKeyUsagePeriod", SimTypePointer(SimTypeRef("CERT_PRIVATE_KEY_VALIDITY", SimStruct), offset=0)),)), name="CERT_KEY_ATTRIBUTES_INFO", pack=False, align=None),
    "CERT_KEY_CONTEXT": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hNCryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None")), ("dwKeySpec", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_KEY_CONTEXT", pack=False, align=None),
    "CERT_KEY_SPEC": SimTypeInt(signed=False, label="CERT_KEY_SPEC"),
    "CERT_KEY_USAGE_RESTRICTION_INFO": SimStruct(OrderedDict((("cCertPolicyId", SimTypeInt(signed=False, label="UInt32")), ("rgCertPolicyId", SimTypePointer(SimTypeRef("CERT_POLICY_ID", SimStruct), offset=0)), ("RestrictedKeyUsage", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)),)), name="CERT_KEY_USAGE_RESTRICTION_INFO", pack=False, align=None),
    "CERT_LDAP_STORE_OPENED_PARA": SimStruct(OrderedDict((("pvLdapSessionHandle", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pwszLdapUrl", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CERT_LDAP_STORE_OPENED_PARA", pack=False, align=None),
    "CERT_LOGOTYPE_AUDIO": SimStruct(OrderedDict((("LogotypeDetails", SimTypeRef("CERT_LOGOTYPE_DETAILS", SimStruct)), ("pLogotypeAudioInfo", SimTypePointer(SimTypeRef("CERT_LOGOTYPE_AUDIO_INFO", SimStruct), offset=0)),)), name="CERT_LOGOTYPE_AUDIO", pack=False, align=None),
    "CERT_LOGOTYPE_AUDIO_INFO": SimStruct(OrderedDict((("dwFileSize", SimTypeInt(signed=False, label="UInt32")), ("dwPlayTime", SimTypeInt(signed=False, label="UInt32")), ("dwChannels", SimTypeInt(signed=False, label="UInt32")), ("dwSampleRate", SimTypeInt(signed=False, label="UInt32")), ("pwszLanguage", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CERT_LOGOTYPE_AUDIO_INFO", pack=False, align=None),
    "CERT_LOGOTYPE_CHOICE": SimTypeInt(signed=False, label="CERT_LOGOTYPE_CHOICE"),
    "CERT_LOGOTYPE_DATA": SimStruct(OrderedDict((("cLogotypeImage", SimTypeInt(signed=False, label="UInt32")), ("rgLogotypeImage", SimTypePointer(SimTypeRef("CERT_LOGOTYPE_IMAGE", SimStruct), offset=0)), ("cLogotypeAudio", SimTypeInt(signed=False, label="UInt32")), ("rgLogotypeAudio", SimTypePointer(SimTypeRef("CERT_LOGOTYPE_AUDIO", SimStruct), offset=0)),)), name="CERT_LOGOTYPE_DATA", pack=False, align=None),
    "CERT_LOGOTYPE_DETAILS": SimStruct(OrderedDict((("pwszMimeType", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cHashedUrl", SimTypeInt(signed=False, label="UInt32")), ("rgHashedUrl", SimTypePointer(SimTypeRef("CERT_HASHED_URL", SimStruct), offset=0)),)), name="CERT_LOGOTYPE_DETAILS", pack=False, align=None),
    "CERT_LOGOTYPE_EXT_INFO": SimStruct(OrderedDict((("cCommunityLogo", SimTypeInt(signed=False, label="UInt32")), ("rgCommunityLogo", SimTypePointer(SimTypeRef("CERT_LOGOTYPE_INFO", SimStruct), offset=0)), ("pIssuerLogo", SimTypePointer(SimTypeRef("CERT_LOGOTYPE_INFO", SimStruct), offset=0)), ("pSubjectLogo", SimTypePointer(SimTypeRef("CERT_LOGOTYPE_INFO", SimStruct), offset=0)), ("cOtherLogo", SimTypeInt(signed=False, label="UInt32")), ("rgOtherLogo", SimTypePointer(SimTypeRef("CERT_OTHER_LOGOTYPE_INFO", SimStruct), offset=0)),)), name="CERT_LOGOTYPE_EXT_INFO", pack=False, align=None),
    "CERT_LOGOTYPE_IMAGE": SimStruct(OrderedDict((("LogotypeDetails", SimTypeRef("CERT_LOGOTYPE_DETAILS", SimStruct)), ("pLogotypeImageInfo", SimTypePointer(SimTypeRef("CERT_LOGOTYPE_IMAGE_INFO", SimStruct), offset=0)),)), name="CERT_LOGOTYPE_IMAGE", pack=False, align=None),
    "CERT_LOGOTYPE_IMAGE_INFO": SimStruct(OrderedDict((("dwLogotypeImageInfoChoice", SimTypeInt(signed=False, label="CERT_LOGOTYPE_IMAGE_INFO_TYPE")), ("dwFileSize", SimTypeInt(signed=False, label="UInt32")), ("dwXSize", SimTypeInt(signed=False, label="UInt32")), ("dwYSize", SimTypeInt(signed=False, label="UInt32")), ("dwLogotypeImageResolutionChoice", SimTypeInt(signed=False, label="CERT_LOGOTYPE_CHOICE")), ("Anonymous", SimUnion({"dwNumBits": SimTypeInt(signed=False, label="UInt32"), "dwTableSize": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("pwszLanguage", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CERT_LOGOTYPE_IMAGE_INFO", pack=False, align=None),
    "CERT_LOGOTYPE_IMAGE_INFO_TYPE": SimTypeInt(signed=False, label="CERT_LOGOTYPE_IMAGE_INFO_TYPE"),
    "CERT_LOGOTYPE_INFO": SimStruct(OrderedDict((("dwLogotypeInfoChoice", SimTypeInt(signed=False, label="CERT_LOGOTYPE_OPTION")), ("Anonymous", SimUnion({"pLogotypeDirectInfo": SimTypePointer(SimTypeRef("CERT_LOGOTYPE_DATA", SimStruct), offset=0), "pLogotypeIndirectInfo": SimTypePointer(SimTypeRef("CERT_LOGOTYPE_REFERENCE", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="CERT_LOGOTYPE_INFO", pack=False, align=None),
    "CERT_LOGOTYPE_OPTION": SimTypeInt(signed=False, label="CERT_LOGOTYPE_OPTION"),
    "CERT_LOGOTYPE_REFERENCE": SimStruct(OrderedDict((("cHashedUrl", SimTypeInt(signed=False, label="UInt32")), ("rgHashedUrl", SimTypePointer(SimTypeRef("CERT_HASHED_URL", SimStruct), offset=0)),)), name="CERT_LOGOTYPE_REFERENCE", pack=False, align=None),
    "CERT_NAME_CONSTRAINTS_INFO": SimStruct(OrderedDict((("cPermittedSubtree", SimTypeInt(signed=False, label="UInt32")), ("rgPermittedSubtree", SimTypePointer(SimTypeRef("CERT_GENERAL_SUBTREE", SimStruct), offset=0)), ("cExcludedSubtree", SimTypeInt(signed=False, label="UInt32")), ("rgExcludedSubtree", SimTypePointer(SimTypeRef("CERT_GENERAL_SUBTREE", SimStruct), offset=0)),)), name="CERT_NAME_CONSTRAINTS_INFO", pack=False, align=None),
    "CERT_NAME_INFO": SimStruct(OrderedDict((("cRDN", SimTypeInt(signed=False, label="UInt32")), ("rgRDN", SimTypePointer(SimTypeRef("CERT_RDN", SimStruct), offset=0)),)), name="CERT_NAME_INFO", pack=False, align=None),
    "CERT_NAME_VALUE": SimStruct(OrderedDict((("dwValueType", SimTypeInt(signed=False, label="UInt32")), ("Value", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_NAME_VALUE", pack=False, align=None),
    "CERT_OPEN_STORE_FLAGS": SimTypeInt(signed=False, label="CERT_OPEN_STORE_FLAGS"),
    "CERT_OR_CRL_BLOB": SimStruct(OrderedDict((("dwChoice", SimTypeInt(signed=False, label="UInt32")), ("cbEncoded", SimTypeInt(signed=False, label="UInt32")), ("pbEncoded", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CERT_OR_CRL_BLOB", pack=False, align=None),
    "CERT_OR_CRL_BUNDLE": SimStruct(OrderedDict((("cItem", SimTypeInt(signed=False, label="UInt32")), ("rgItem", SimTypePointer(SimTypeRef("CERT_OR_CRL_BLOB", SimStruct), offset=0)),)), name="CERT_OR_CRL_BUNDLE", pack=False, align=None),
    "CERT_OTHER_LOGOTYPE_INFO": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("LogotypeInfo", SimTypeRef("CERT_LOGOTYPE_INFO", SimStruct)),)), name="CERT_OTHER_LOGOTYPE_INFO", pack=False, align=None),
    "CERT_OTHER_NAME": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Value", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_OTHER_NAME", pack=False, align=None),
    "CERT_PAIR": SimStruct(OrderedDict((("Forward", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("Reverse", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_PAIR", pack=False, align=None),
    "CERT_PHYSICAL_STORE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pszOpenStoreProvider", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwOpenEncodingType", SimTypeInt(signed=False, label="UInt32")), ("dwOpenFlags", SimTypeInt(signed=False, label="UInt32")), ("OpenParameters", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwPriority", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_PHYSICAL_STORE_INFO", pack=False, align=None),
    "CERT_POLICIES_INFO": SimStruct(OrderedDict((("cPolicyInfo", SimTypeInt(signed=False, label="UInt32")), ("rgPolicyInfo", SimTypePointer(SimTypeRef("CERT_POLICY_INFO", SimStruct), offset=0)),)), name="CERT_POLICIES_INFO", pack=False, align=None),
    "CERT_POLICY95_QUALIFIER1": SimStruct(OrderedDict((("pszPracticesReference", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszNoticeIdentifier", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pszNSINoticeIdentifier", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cCPSURLs", SimTypeInt(signed=False, label="UInt32")), ("rgCPSURLs", SimTypePointer(SimTypeRef("CPS_URLS", SimStruct), offset=0)),)), name="CERT_POLICY95_QUALIFIER1", pack=False, align=None),
    "CERT_POLICY_CONSTRAINTS_INFO": SimStruct(OrderedDict((("fRequireExplicitPolicy", SimTypeInt(signed=True, label="Int32")), ("dwRequireExplicitPolicySkipCerts", SimTypeInt(signed=False, label="UInt32")), ("fInhibitPolicyMapping", SimTypeInt(signed=True, label="Int32")), ("dwInhibitPolicyMappingSkipCerts", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_POLICY_CONSTRAINTS_INFO", pack=False, align=None),
    "CERT_POLICY_ID": SimStruct(OrderedDict((("cCertPolicyElementId", SimTypeInt(signed=False, label="UInt32")), ("rgpszCertPolicyElementId", SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)),)), name="CERT_POLICY_ID", pack=False, align=None),
    "CERT_POLICY_INFO": SimStruct(OrderedDict((("pszPolicyIdentifier", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cPolicyQualifier", SimTypeInt(signed=False, label="UInt32")), ("rgPolicyQualifier", SimTypePointer(SimTypeRef("CERT_POLICY_QUALIFIER_INFO", SimStruct), offset=0)),)), name="CERT_POLICY_INFO", pack=False, align=None),
    "CERT_POLICY_MAPPING": SimStruct(OrderedDict((("pszIssuerDomainPolicy", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pszSubjectDomainPolicy", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CERT_POLICY_MAPPING", pack=False, align=None),
    "CERT_POLICY_MAPPINGS_INFO": SimStruct(OrderedDict((("cPolicyMapping", SimTypeInt(signed=False, label="UInt32")), ("rgPolicyMapping", SimTypePointer(SimTypeRef("CERT_POLICY_MAPPING", SimStruct), offset=0)),)), name="CERT_POLICY_MAPPINGS_INFO", pack=False, align=None),
    "CERT_POLICY_QUALIFIER_INFO": SimStruct(OrderedDict((("pszPolicyQualifierId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Qualifier", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_POLICY_QUALIFIER_INFO", pack=False, align=None),
    "CERT_POLICY_QUALIFIER_NOTICE_REFERENCE": SimStruct(OrderedDict((("pszOrganization", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cNoticeNumbers", SimTypeInt(signed=False, label="UInt32")), ("rgNoticeNumbers", SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)),)), name="CERT_POLICY_QUALIFIER_NOTICE_REFERENCE", pack=False, align=None),
    "CERT_POLICY_QUALIFIER_USER_NOTICE": SimStruct(OrderedDict((("pNoticeReference", SimTypePointer(SimTypeRef("CERT_POLICY_QUALIFIER_NOTICE_REFERENCE", SimStruct), offset=0)), ("pszDisplayText", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CERT_POLICY_QUALIFIER_USER_NOTICE", pack=False, align=None),
    "CERT_PRIVATE_KEY_VALIDITY": SimStruct(OrderedDict((("NotBefore", SimTypeRef("FILETIME", SimStruct)), ("NotAfter", SimTypeRef("FILETIME", SimStruct)),)), name="CERT_PRIVATE_KEY_VALIDITY", pack=False, align=None),
    "CERT_PROPERTY_TYPE": SimTypeInt(signed=False, label="CERT_PROPERTY_TYPE"),
    "CERT_PUBLIC_KEY_INFO": SimStruct(OrderedDict((("Algorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("PublicKey", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)),)), name="CERT_PUBLIC_KEY_INFO", pack=False, align=None),
    "CERT_QC_STATEMENT": SimStruct(OrderedDict((("pszStatementId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("StatementInfo", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_QC_STATEMENT", pack=False, align=None),
    "CERT_QC_STATEMENTS_EXT_INFO": SimStruct(OrderedDict((("cStatement", SimTypeInt(signed=False, label="UInt32")), ("rgStatement", SimTypePointer(SimTypeRef("CERT_QC_STATEMENT", SimStruct), offset=0)),)), name="CERT_QC_STATEMENTS_EXT_INFO", pack=False, align=None),
    "CERT_QUERY_CONTENT_TYPE": SimTypeInt(signed=False, label="CERT_QUERY_CONTENT_TYPE"),
    "CERT_QUERY_CONTENT_TYPE_FLAGS": SimTypeInt(signed=False, label="CERT_QUERY_CONTENT_TYPE_FLAGS"),
    "CERT_QUERY_ENCODING_TYPE": SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE"),
    "CERT_QUERY_FORMAT_TYPE": SimTypeInt(signed=False, label="CERT_QUERY_FORMAT_TYPE"),
    "CERT_QUERY_FORMAT_TYPE_FLAGS": SimTypeInt(signed=False, label="CERT_QUERY_FORMAT_TYPE_FLAGS"),
    "CERT_QUERY_OBJECT_TYPE": SimTypeInt(signed=False, label="CERT_QUERY_OBJECT_TYPE"),
    "CERT_RDN": SimStruct(OrderedDict((("cRDNAttr", SimTypeInt(signed=False, label="UInt32")), ("rgRDNAttr", SimTypePointer(SimTypeRef("CERT_RDN_ATTR", SimStruct), offset=0)),)), name="CERT_RDN", pack=False, align=None),
    "CERT_RDN_ATTR": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwValueType", SimTypeInt(signed=False, label="UInt32")), ("Value", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CERT_RDN_ATTR", pack=False, align=None),
    "CERT_RDN_ATTR_VALUE_TYPE": SimTypeInt(signed=False, label="CERT_RDN_ATTR_VALUE_TYPE"),
    "CERT_REGISTRY_STORE_CLIENT_GPT_PARA": SimStruct(OrderedDict((("hKeyBase", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pwszRegPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CERT_REGISTRY_STORE_CLIENT_GPT_PARA", pack=False, align=None),
    "CERT_REGISTRY_STORE_ROAMING_PARA": SimStruct(OrderedDict((("hKey", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pwszStoreDirectory", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CERT_REGISTRY_STORE_ROAMING_PARA", pack=False, align=None),
    "CERT_REQUEST_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("Subject", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("SubjectPublicKeyInfo", SimTypeRef("CERT_PUBLIC_KEY_INFO", SimStruct)), ("cAttribute", SimTypeInt(signed=False, label="UInt32")), ("rgAttribute", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE", SimStruct), offset=0)),)), name="CERT_REQUEST_INFO", pack=False, align=None),
    "CERT_REQUEST_OUT_TYPE": SimTypeInt(signed=False, label="CERT_REQUEST_OUT_TYPE"),
    "CERT_REVOCATION_CHAIN_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hChainEngine", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hAdditionalStore", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("dwChainFlags", SimTypeInt(signed=False, label="UInt32")), ("dwUrlRetrievalTimeout", SimTypeInt(signed=False, label="UInt32")), ("pftCurrentTime", SimTypePointer(SimTypeRef("FILETIME", SimStruct), offset=0)), ("pftCacheResync", SimTypePointer(SimTypeRef("FILETIME", SimStruct), offset=0)), ("cbMaxUrlRetrievalByteCount", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_REVOCATION_CHAIN_PARA", pack=False, align=None),
    "CERT_REVOCATION_CRL_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pBaseCrlContext", SimTypePointer(SimTypeRef("CRL_CONTEXT", SimStruct), offset=0)), ("pDeltaCrlContext", SimTypePointer(SimTypeRef("CRL_CONTEXT", SimStruct), offset=0)), ("pCrlEntry", SimTypePointer(SimTypeRef("CRL_ENTRY", SimStruct), offset=0)), ("fDeltaCrlEntry", SimTypeInt(signed=True, label="Int32")),)), name="CERT_REVOCATION_CRL_INFO", pack=False, align=None),
    "CERT_REVOCATION_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwRevocationResult", SimTypeInt(signed=False, label="UInt32")), ("pszRevocationOid", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pvOidSpecificInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("fHasFreshnessTime", SimTypeInt(signed=True, label="Int32")), ("dwFreshnessTime", SimTypeInt(signed=False, label="UInt32")), ("pCrlInfo", SimTypePointer(SimTypeRef("CERT_REVOCATION_CRL_INFO", SimStruct), offset=0)),)), name="CERT_REVOCATION_INFO", pack=False, align=None),
    "CERT_REVOCATION_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pIssuerCert", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("cCertStore", SimTypeInt(signed=False, label="UInt32")), ("rgCertStore", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("hCrlStore", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pftTimeToUse", SimTypePointer(SimTypeRef("FILETIME", SimStruct), offset=0)),)), name="CERT_REVOCATION_PARA", pack=False, align=None),
    "CERT_REVOCATION_STATUS": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwIndex", SimTypeInt(signed=False, label="UInt32")), ("dwError", SimTypeInt(signed=False, label="UInt32")), ("dwReason", SimTypeInt(signed=False, label="CERT_REVOCATION_STATUS_REASON")), ("fHasFreshnessTime", SimTypeInt(signed=True, label="Int32")), ("dwFreshnessTime", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_REVOCATION_STATUS", pack=False, align=None),
    "CERT_REVOCATION_STATUS_REASON": SimTypeInt(signed=False, label="CERT_REVOCATION_STATUS_REASON"),
    "CERT_ROOT_PROGRAM_FLAGS": SimTypeInt(signed=False, label="CERT_ROOT_PROGRAM_FLAGS"),
    "CERT_SELECTUI_INPUT": SimStruct(OrderedDict((("hStore", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("prgpChain", SimTypePointer(SimTypePointer(SimTypeRef("CERT_CHAIN_CONTEXT", SimStruct), offset=0), offset=0)), ("cChain", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_SELECTUI_INPUT", pack=False, align=None),
    "CERT_SELECT_CHAIN_PARA": SimStruct(OrderedDict((("hChainEngine", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pTime", SimTypePointer(SimTypeRef("FILETIME", SimStruct), offset=0)), ("hAdditionalStore", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pChainPara", SimTypePointer(SimTypeRef("CERT_CHAIN_PARA", SimStruct), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_SELECT_CHAIN_PARA", pack=False, align=None),
    "CERT_SELECT_CRITERIA": SimStruct(OrderedDict((("dwType", SimTypeInt(signed=False, label="CERT_SELECT_CRITERIA_TYPE")), ("cPara", SimTypeInt(signed=False, label="UInt32")), ("ppPara", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)),)), name="CERT_SELECT_CRITERIA", pack=False, align=None),
    "CERT_SELECT_CRITERIA_TYPE": SimTypeInt(signed=False, label="CERT_SELECT_CRITERIA_TYPE"),
    "CERT_SELECT_STRUCT_A": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pTemplateName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="CERT_SELECT_STRUCT_FLAGS")), ("szTitle", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cCertStore", SimTypeInt(signed=False, label="UInt32")), ("arrayCertStore", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("szPurposeOid", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cCertContext", SimTypeInt(signed=False, label="UInt32")), ("arrayCertContext", SimTypePointer(SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), offset=0)), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwndDialog", "message", "wParam", "lParam"]), offset=0)), ("pfnFilter", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "param1", "param2", "param3"]), offset=0)), ("szHelpFileName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwHelpId", SimTypeInt(signed=False, label="UInt32")), ("hprov", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="CERT_SELECT_STRUCT_A", pack=False, align=None),
    "CERT_SELECT_STRUCT_FLAGS": SimTypeInt(signed=False, label="CERT_SELECT_STRUCT_FLAGS"),
    "CERT_SELECT_STRUCT_W": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pTemplateName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="CERT_SELECT_STRUCT_FLAGS")), ("szTitle", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cCertStore", SimTypeInt(signed=False, label="UInt32")), ("arrayCertStore", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("szPurposeOid", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cCertContext", SimTypeInt(signed=False, label="UInt32")), ("arrayCertContext", SimTypePointer(SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), offset=0)), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwndDialog", "message", "wParam", "lParam"]), offset=0)), ("pfnFilter", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "param1", "param2", "param3"]), offset=0)), ("szHelpFileName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwHelpId", SimTypeInt(signed=False, label="UInt32")), ("hprov", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="CERT_SELECT_STRUCT_W", pack=False, align=None),
    "CERT_SERVER_OCSP_RESPONSE_CONTEXT": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pbEncodedOcspResponse", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbEncodedOcspResponse", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_SERVER_OCSP_RESPONSE_CONTEXT", pack=False, align=None),
    "CERT_SERVER_OCSP_RESPONSE_OPEN_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("pcbUsedSize", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("pwszOcspDirectory", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pfnUpdateCallback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CERT_CHAIN_CONTEXT", SimStruct), offset=0), SimTypePointer(SimTypeRef("CERT_SERVER_OCSP_RESPONSE_CONTEXT", SimStruct), offset=0), SimTypePointer(SimTypeRef("CRL_CONTEXT", SimStruct), offset=0), SimTypePointer(SimTypeRef("CRL_CONTEXT", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pChainContext", "pServerOcspResponseContext", "pNewCrlContext", "pPrevCrlContext", "pvArg", "dwWriteOcspFileError"]), offset=0)), ("pvUpdateCallbackArg", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CERT_SERVER_OCSP_RESPONSE_OPEN_PARA", pack=False, align=None),
    "CERT_SIGNED_CONTENT_INFO": SimStruct(OrderedDict((("ToBeSigned", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("SignatureAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("Signature", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)),)), name="CERT_SIGNED_CONTENT_INFO", pack=False, align=None),
    "CERT_SIMPLE_CHAIN": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("TrustStatus", SimTypeRef("CERT_TRUST_STATUS", SimStruct)), ("cElement", SimTypeInt(signed=False, label="UInt32")), ("rgpElement", SimTypePointer(SimTypePointer(SimTypeRef("CERT_CHAIN_ELEMENT", SimStruct), offset=0), offset=0)), ("pTrustListInfo", SimTypePointer(SimTypeRef("CERT_TRUST_LIST_INFO", SimStruct), offset=0)), ("fHasRevocationFreshnessTime", SimTypeInt(signed=True, label="Int32")), ("dwRevocationFreshnessTime", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_SIMPLE_CHAIN", pack=False, align=None),
    "CERT_STORE_PROV_FIND_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMsgAndCertEncodingType", SimTypeInt(signed=False, label="UInt32")), ("dwFindFlags", SimTypeInt(signed=False, label="UInt32")), ("dwFindType", SimTypeInt(signed=False, label="UInt32")), ("pvFindPara", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CERT_STORE_PROV_FIND_INFO", pack=False, align=None),
    "CERT_STORE_PROV_FLAGS": SimTypeInt(signed=False, label="CERT_STORE_PROV_FLAGS"),
    "CERT_STORE_PROV_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("cStoreProvFunc", SimTypeInt(signed=False, label="UInt32")), ("rgpvStoreProvFunc", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("hStoreProv", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("dwStoreProvFlags", SimTypeInt(signed=False, label="CERT_STORE_PROV_FLAGS")), ("hStoreProvFuncAddr2", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CERT_STORE_PROV_INFO", pack=False, align=None),
    "CERT_STORE_SAVE_AS": SimTypeInt(signed=False, label="CERT_STORE_SAVE_AS"),
    "CERT_STORE_SAVE_TO": SimTypeInt(signed=False, label="CERT_STORE_SAVE_TO"),
    "CERT_STRING_TYPE": SimTypeInt(signed=False, label="CERT_STRING_TYPE"),
    "CERT_STRONG_SIGN_FLAGS": SimTypeInt(signed=False, label="CERT_STRONG_SIGN_FLAGS"),
    "CERT_STRONG_SIGN_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwInfoChoice", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"pvInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSerializedInfo": SimTypePointer(SimTypeRef("CERT_STRONG_SIGN_SERIALIZED_INFO", SimStruct), offset=0), "pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")),)), name="CERT_STRONG_SIGN_PARA", pack=False, align=None),
    "CERT_STRONG_SIGN_SERIALIZED_INFO": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="CERT_STRONG_SIGN_FLAGS")), ("pwszCNGSignHashAlgids", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pwszCNGPubKeyMinBitLengths", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CERT_STRONG_SIGN_SERIALIZED_INFO", pack=False, align=None),
    "CERT_SUPPORTED_ALGORITHM_INFO": SimStruct(OrderedDict((("Algorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("IntendedKeyUsage", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)), ("IntendedCertPolicies", SimTypeRef("CERT_POLICIES_INFO", SimStruct)),)), name="CERT_SUPPORTED_ALGORITHM_INFO", pack=False, align=None),
    "CERT_SYSTEM_STORE_FLAGS": SimTypeInt(signed=False, label="CERT_SYSTEM_STORE_FLAGS"),
    "CERT_SYSTEM_STORE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_SYSTEM_STORE_INFO", pack=False, align=None),
    "CERT_SYSTEM_STORE_RELOCATE_PARA": SimStruct(OrderedDict((("Anonymous1", SimUnion({"hKeyBase": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pvBase": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None")), ("Anonymous2", SimUnion({"pvSystemStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pszSystemStore": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszSystemStore": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")),)), name="CERT_SYSTEM_STORE_RELOCATE_PARA", pack=False, align=None),
    "CERT_TEMPLATE_EXT": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwMajorVersion", SimTypeInt(signed=False, label="UInt32")), ("fMinorVersion", SimTypeInt(signed=True, label="Int32")), ("dwMinorVersion", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_TEMPLATE_EXT", pack=False, align=None),
    "CERT_TPM_SPECIFICATION_INFO": SimStruct(OrderedDict((("pwszFamily", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwLevel", SimTypeInt(signed=False, label="UInt32")), ("dwRevision", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_TPM_SPECIFICATION_INFO", pack=False, align=None),
    "CERT_TRUST_LIST_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pCtlEntry", SimTypePointer(SimTypeRef("CTL_ENTRY", SimStruct), offset=0)), ("pCtlContext", SimTypePointer(SimTypeRef("CTL_CONTEXT", SimStruct), offset=0)),)), name="CERT_TRUST_LIST_INFO", pack=False, align=None),
    "CERT_TRUST_STATUS": SimStruct(OrderedDict((("dwErrorStatus", SimTypeInt(signed=False, label="UInt32")), ("dwInfoStatus", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_TRUST_STATUS", pack=False, align=None),
    "CERT_USAGE_MATCH": SimStruct(OrderedDict((("dwType", SimTypeInt(signed=False, label="UInt32")), ("Usage", SimTypeRef("CTL_USAGE", SimStruct)),)), name="CERT_USAGE_MATCH", pack=False, align=None),
    "CERT_VERIFY_CERTIFICATE_TRUST": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pccert", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwIgnoreErr", SimTypeInt(signed=False, label="UInt32")), ("pdwErrors", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("pszUsageOid", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("hprov", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("cRootStores", SimTypeInt(signed=False, label="UInt32")), ("rghstoreRoots", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("cStores", SimTypeInt(signed=False, label="UInt32")), ("rghstoreCAs", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("cTrustStores", SimTypeInt(signed=False, label="UInt32")), ("rghstoreTrust", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pfnTrustHelper", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "lCustData", "fLeafCertificate", "pbTrustBlob"]), offset=0)), ("pcChain", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("prgChain", SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), offset=0), offset=0)), ("prgdwErrors", SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), offset=0)), ("prgpbTrustInfo", SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0), offset=0)),)), name="CERT_VERIFY_CERTIFICATE_TRUST", pack=False, align=None),
    "CERT_VIEWPROPERTIES_STRUCT_A": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("dwFlags", SimTypeInt(signed=False, label="CERT_VIEWPROPERTIES_STRUCT_FLAGS")), ("szTitle", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pCertContext", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("arrayPurposes", SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)), ("cArrayPurposes", SimTypeInt(signed=False, label="UInt32")), ("cRootStores", SimTypeInt(signed=False, label="UInt32")), ("rghstoreRoots", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("cStores", SimTypeInt(signed=False, label="UInt32")), ("rghstoreCAs", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("cTrustStores", SimTypeInt(signed=False, label="UInt32")), ("rghstoreTrust", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("hprov", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("dwPad", SimTypeInt(signed=False, label="UInt32")), ("szHelpFileName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwHelpId", SimTypeInt(signed=False, label="UInt32")), ("nStartPage", SimTypeInt(signed=False, label="UInt32")), ("cArrayPropSheetPages", SimTypeInt(signed=False, label="UInt32")), ("arrayPropSheetPages", SimTypePointer(SimTypeRef("PROPSHEETPAGEA", SimStruct), offset=0)),)), name="CERT_VIEWPROPERTIES_STRUCT_A", pack=False, align=None),
    "CERT_VIEWPROPERTIES_STRUCT_FLAGS": SimTypeInt(signed=False, label="CERT_VIEWPROPERTIES_STRUCT_FLAGS"),
    "CERT_VIEWPROPERTIES_STRUCT_W": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("dwFlags", SimTypeInt(signed=False, label="CERT_VIEWPROPERTIES_STRUCT_FLAGS")), ("szTitle", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pCertContext", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("arrayPurposes", SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)), ("cArrayPurposes", SimTypeInt(signed=False, label="UInt32")), ("cRootStores", SimTypeInt(signed=False, label="UInt32")), ("rghstoreRoots", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("cStores", SimTypeInt(signed=False, label="UInt32")), ("rghstoreCAs", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("cTrustStores", SimTypeInt(signed=False, label="UInt32")), ("rghstoreTrust", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("hprov", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("dwPad", SimTypeInt(signed=False, label="UInt32")), ("szHelpFileName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwHelpId", SimTypeInt(signed=False, label="UInt32")), ("nStartPage", SimTypeInt(signed=False, label="UInt32")), ("cArrayPropSheetPages", SimTypeInt(signed=False, label="UInt32")), ("arrayPropSheetPages", SimTypePointer(SimTypeRef("PROPSHEETPAGEA", SimStruct), offset=0)),)), name="CERT_VIEWPROPERTIES_STRUCT_W", pack=False, align=None),
    "CERT_VIEW_COLUMN_INDEX": SimTypeInt(signed=False, label="CERT_VIEW_COLUMN_INDEX"),
    "CERT_VIEW_SEEK_OPERATOR_FLAGS": SimTypeInt(signed=False, label="CERT_VIEW_SEEK_OPERATOR_FLAGS"),
    "CERT_X942_DH_PARAMETERS": SimStruct(OrderedDict((("p", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("g", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("q", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("j", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("pValidationParams", SimTypePointer(SimTypeRef("CERT_X942_DH_VALIDATION_PARAMS", SimStruct), offset=0)),)), name="CERT_X942_DH_PARAMETERS", pack=False, align=None),
    "CERT_X942_DH_VALIDATION_PARAMS": SimStruct(OrderedDict((("seed", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)), ("pgenCounter", SimTypeInt(signed=False, label="UInt32")),)), name="CERT_X942_DH_VALIDATION_PARAMS", pack=False, align=None),
    "CESSetupProperty": SimTypeInt(signed=False, label="CESSetupProperty"),
    "CFE_EFFECTS": SimTypeInt(signed=False, label="CFE_EFFECTS"),
    "CFE_UNDERLINE": SimTypeInt(signed=False, label="CFE_UNDERLINE"),
    "CFG_CALL_TARGET_INFO": SimStruct(OrderedDict((("Offset", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("Flags", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="CFG_CALL_TARGET_INFO", pack=False, align=None),
    "CFM_MASK": SimTypeInt(signed=False, label="CFM_MASK"),
    "CFP_ALLOCPROC": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0"]), offset=0),
    "CFP_FREEPROC": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0),
    "CFP_REALLOCPROC": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0", "param1"]), offset=0),
    "CF_CALLBACK": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CF_CALLBACK_INFO", SimStruct), offset=0), SimTypePointer(SimTypeRef("CF_CALLBACK_PARAMETERS", SimStruct), offset=0)], SimTypeBottom(label="Void"), arg_names=["CallbackInfo", "CallbackParameters"]), offset=0),
    "CF_CALLBACK_CANCEL_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_CANCEL_FLAGS"),
    "CF_CALLBACK_CLOSE_COMPLETION_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_CLOSE_COMPLETION_FLAGS"),
    "CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS"),
    "CF_CALLBACK_DEHYDRATE_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_DEHYDRATE_FLAGS"),
    "CF_CALLBACK_DEHYDRATION_REASON": SimTypeInt(signed=False, label="CF_CALLBACK_DEHYDRATION_REASON"),
    "CF_CALLBACK_DELETE_COMPLETION_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_DELETE_COMPLETION_FLAGS"),
    "CF_CALLBACK_DELETE_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_DELETE_FLAGS"),
    "CF_CALLBACK_FETCH_DATA_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_FETCH_DATA_FLAGS"),
    "CF_CALLBACK_FETCH_PLACEHOLDERS_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_FETCH_PLACEHOLDERS_FLAGS"),
    "CF_CALLBACK_INFO": SimStruct(OrderedDict((("StructSize", SimTypeInt(signed=False, label="UInt32")), ("ConnectionKey", SimTypeLongLong(signed=True, label="Int64")), ("CallbackContext", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("VolumeGuidName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("VolumeDosName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("VolumeSerialNumber", SimTypeInt(signed=False, label="UInt32")), ("SyncRootFileId", SimTypeLongLong(signed=True, label="Int64")), ("SyncRootIdentity", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("SyncRootIdentityLength", SimTypeInt(signed=False, label="UInt32")), ("FileId", SimTypeLongLong(signed=True, label="Int64")), ("FileSize", SimTypeLongLong(signed=True, label="Int64")), ("FileIdentity", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("FileIdentityLength", SimTypeInt(signed=False, label="UInt32")), ("NormalizedPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("TransferKey", SimTypeLongLong(signed=True, label="Int64")), ("PriorityHint", SimTypeChar(label="Byte")), ("CorrelationVector", SimTypePointer(SimTypeRef("CORRELATION_VECTOR", SimStruct), offset=0)), ("ProcessInfo", SimTypePointer(SimTypeRef("CF_PROCESS_INFO", SimStruct), offset=0)), ("RequestKey", SimTypeLongLong(signed=True, label="Int64")),)), name="CF_CALLBACK_INFO", pack=False, align=None),
    "CF_CALLBACK_OPEN_COMPLETION_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_OPEN_COMPLETION_FLAGS"),
    "CF_CALLBACK_PARAMETERS": SimStruct(OrderedDict((("ParamSize", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"Cancel": SimTypeRef("_Cancel_e__Struct", SimStruct), "FetchData": SimTypeRef("_FetchData_e__Struct", SimStruct), "ValidateData": SimTypeRef("_ValidateData_e__Struct", SimStruct), "FetchPlaceholders": SimTypeRef("_FetchPlaceholders_e__Struct", SimStruct), "OpenCompletion": SimTypeRef("_OpenCompletion_e__Struct", SimStruct), "CloseCompletion": SimTypeRef("_CloseCompletion_e__Struct", SimStruct), "Dehydrate": SimTypeRef("_Dehydrate_e__Struct", SimStruct), "DehydrateCompletion": SimTypeRef("_DehydrateCompletion_e__Struct", SimStruct), "Delete": SimTypeRef("_Delete_e__Struct", SimStruct), "DeleteCompletion": SimTypeRef("_DeleteCompletion_e__Struct", SimStruct), "Rename": SimTypeRef("_Rename_e__Struct", SimStruct), "RenameCompletion": SimTypeRef("_RenameCompletion_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="CF_CALLBACK_PARAMETERS", pack=False, align=None),
    "CF_CALLBACK_REGISTRATION": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="CF_CALLBACK_TYPE")), ("Callback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CF_CALLBACK_INFO", SimStruct), offset=0), SimTypePointer(SimTypeRef("CF_CALLBACK_PARAMETERS", SimStruct), offset=0)], SimTypeBottom(label="Void"), arg_names=["CallbackInfo", "CallbackParameters"]), offset=0)),)), name="CF_CALLBACK_REGISTRATION", pack=False, align=None),
    "CF_CALLBACK_RENAME_COMPLETION_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_RENAME_COMPLETION_FLAGS"),
    "CF_CALLBACK_RENAME_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_RENAME_FLAGS"),
    "CF_CALLBACK_TYPE": SimTypeInt(signed=False, label="CF_CALLBACK_TYPE"),
    "CF_CALLBACK_VALIDATE_DATA_FLAGS": SimTypeInt(signed=False, label="CF_CALLBACK_VALIDATE_DATA_FLAGS"),
    "CF_CONNECTION_KEY": SimTypeLongLong(signed=True, label="Int64"),
    "CF_CONNECT_FLAGS": SimTypeInt(signed=False, label="CF_CONNECT_FLAGS"),
    "CF_CONVERT_FLAGS": SimTypeInt(signed=False, label="CF_CONVERT_FLAGS"),
    "CF_CREATE_FLAGS": SimTypeInt(signed=False, label="CF_CREATE_FLAGS"),
    "CF_DEHYDRATE_FLAGS": SimTypeInt(signed=False, label="CF_DEHYDRATE_FLAGS"),
    "CF_FILE_RANGE": SimStruct(OrderedDict((("StartingOffset", SimTypeLongLong(signed=True, label="Int64")), ("Length", SimTypeLongLong(signed=True, label="Int64")),)), name="CF_FILE_RANGE", pack=False, align=None),
    "CF_FS_METADATA": SimStruct(OrderedDict((("BasicInfo", SimTypeRef("FILE_BASIC_INFO", SimStruct)), ("FileSize", SimTypeLongLong(signed=True, label="Int64")),)), name="CF_FS_METADATA", pack=False, align=None),
    "CF_HARDLINK_POLICY": SimTypeInt(signed=False, label="CF_HARDLINK_POLICY"),
    "CF_HYDRATE_FLAGS": SimTypeInt(signed=False, label="CF_HYDRATE_FLAGS"),
    "CF_HYDRATION_POLICY": SimStruct(OrderedDict((("Primary", SimTypeInt(signed=False, label="CF_HYDRATION_POLICY_PRIMARY")), ("Modifier", SimTypeInt(signed=False, label="CF_HYDRATION_POLICY_MODIFIER")),)), name="CF_HYDRATION_POLICY", pack=False, align=None),
    "CF_HYDRATION_POLICY_MODIFIER": SimTypeInt(signed=False, label="CF_HYDRATION_POLICY_MODIFIER"),
    "CF_HYDRATION_POLICY_PRIMARY": SimTypeInt(signed=False, label="CF_HYDRATION_POLICY_PRIMARY"),
    "CF_INSYNC_POLICY": SimTypeInt(signed=False, label="CF_INSYNC_POLICY"),
    "CF_IN_SYNC_STATE": SimTypeInt(signed=False, label="CF_IN_SYNC_STATE"),
    "CF_OPEN_FILE_FLAGS": SimTypeInt(signed=False, label="CF_OPEN_FILE_FLAGS"),
    "CF_OPERATION_ACK_DATA_FLAGS": SimTypeInt(signed=False, label="CF_OPERATION_ACK_DATA_FLAGS"),
    "CF_OPERATION_ACK_DEHYDRATE_FLAGS": SimTypeInt(signed=False, label="CF_OPERATION_ACK_DEHYDRATE_FLAGS"),
    "CF_OPERATION_ACK_DELETE_FLAGS": SimTypeInt(signed=False, label="CF_OPERATION_ACK_DELETE_FLAGS"),
    "CF_OPERATION_ACK_RENAME_FLAGS": SimTypeInt(signed=False, label="CF_OPERATION_ACK_RENAME_FLAGS"),
    "CF_OPERATION_INFO": SimStruct(OrderedDict((("StructSize", SimTypeInt(signed=False, label="UInt32")), ("Type", SimTypeInt(signed=False, label="CF_OPERATION_TYPE")), ("ConnectionKey", SimTypeLongLong(signed=True, label="Int64")), ("TransferKey", SimTypeLongLong(signed=True, label="Int64")), ("CorrelationVector", SimTypePointer(SimTypeRef("CORRELATION_VECTOR", SimStruct), offset=0)), ("SyncStatus", SimTypePointer(SimTypeRef("CF_SYNC_STATUS", SimStruct), offset=0)), ("RequestKey", SimTypeLongLong(signed=True, label="Int64")),)), name="CF_OPERATION_INFO", pack=False, align=None),
    "CF_OPERATION_PARAMETERS": SimStruct(OrderedDict((("ParamSize", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"TransferData": SimTypeRef("_TransferData_e__Struct", SimStruct), "RetrieveData": SimTypeRef("_RetrieveData_e__Struct", SimStruct), "AckData": SimTypeRef("_AckData_e__Struct", SimStruct), "RestartHydration": SimTypeRef("_RestartHydration_e__Struct", SimStruct), "TransferPlaceholders": SimTypeRef("_TransferPlaceholders_e__Struct", SimStruct), "AckDehydrate": SimTypeRef("_AckDehydrate_e__Struct", SimStruct), "AckRename": SimTypeRef("_AckRename_e__Struct", SimStruct), "AckDelete": SimTypeRef("_AckDelete_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="CF_OPERATION_PARAMETERS", pack=False, align=None),
    "CF_OPERATION_RESTART_HYDRATION_FLAGS": SimTypeInt(signed=False, label="CF_OPERATION_RESTART_HYDRATION_FLAGS"),
    "CF_OPERATION_RETRIEVE_DATA_FLAGS": SimTypeInt(signed=False, label="CF_OPERATION_RETRIEVE_DATA_FLAGS"),
    "CF_OPERATION_TRANSFER_DATA_FLAGS": SimTypeInt(signed=False, label="CF_OPERATION_TRANSFER_DATA_FLAGS"),
    "CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS": SimTypeInt(signed=False, label="CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS"),
    "CF_OPERATION_TYPE": SimTypeInt(signed=False, label="CF_OPERATION_TYPE"),
    "CF_PIN_STATE": SimTypeInt(signed=False, label="CF_PIN_STATE"),
    "CF_PLACEHOLDER_BASIC_INFO": SimStruct(OrderedDict((("PinState", SimTypeInt(signed=False, label="CF_PIN_STATE")), ("InSyncState", SimTypeInt(signed=False, label="CF_IN_SYNC_STATE")), ("FileId", SimTypeLongLong(signed=True, label="Int64")), ("SyncRootFileId", SimTypeLongLong(signed=True, label="Int64")), ("FileIdentityLength", SimTypeInt(signed=False, label="UInt32")), ("FileIdentity", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CF_PLACEHOLDER_BASIC_INFO", pack=False, align=None),
    "CF_PLACEHOLDER_CREATE_FLAGS": SimTypeInt(signed=False, label="CF_PLACEHOLDER_CREATE_FLAGS"),
    "CF_PLACEHOLDER_CREATE_INFO": SimStruct(OrderedDict((("RelativeFileName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("FsMetadata", SimTypeRef("CF_FS_METADATA", SimStruct)), ("FileIdentity", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("FileIdentityLength", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="CF_PLACEHOLDER_CREATE_FLAGS")), ("Result", SimTypeInt(signed=True, label="Int32")), ("CreateUsn", SimTypeLongLong(signed=True, label="Int64")),)), name="CF_PLACEHOLDER_CREATE_INFO", pack=False, align=None),
    "CF_PLACEHOLDER_INFO_CLASS": SimTypeInt(signed=False, label="CF_PLACEHOLDER_INFO_CLASS"),
    "CF_PLACEHOLDER_MANAGEMENT_POLICY": SimTypeInt(signed=False, label="CF_PLACEHOLDER_MANAGEMENT_POLICY"),
    "CF_PLACEHOLDER_RANGE_INFO_CLASS": SimTypeInt(signed=False, label="CF_PLACEHOLDER_RANGE_INFO_CLASS"),
    "CF_PLACEHOLDER_STANDARD_INFO": SimStruct(OrderedDict((("OnDiskDataSize", SimTypeLongLong(signed=True, label="Int64")), ("ValidatedDataSize", SimTypeLongLong(signed=True, label="Int64")), ("ModifiedDataSize", SimTypeLongLong(signed=True, label="Int64")), ("PropertiesSize", SimTypeLongLong(signed=True, label="Int64")), ("PinState", SimTypeInt(signed=False, label="CF_PIN_STATE")), ("InSyncState", SimTypeInt(signed=False, label="CF_IN_SYNC_STATE")), ("FileId", SimTypeLongLong(signed=True, label="Int64")), ("SyncRootFileId", SimTypeLongLong(signed=True, label="Int64")), ("FileIdentityLength", SimTypeInt(signed=False, label="UInt32")), ("FileIdentity", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CF_PLACEHOLDER_STANDARD_INFO", pack=False, align=None),
    "CF_PLACEHOLDER_STATE": SimTypeInt(signed=False, label="CF_PLACEHOLDER_STATE"),
    "CF_PLATFORM_INFO": SimStruct(OrderedDict((("BuildNumber", SimTypeInt(signed=False, label="UInt32")), ("RevisionNumber", SimTypeInt(signed=False, label="UInt32")), ("IntegrationNumber", SimTypeInt(signed=False, label="UInt32")),)), name="CF_PLATFORM_INFO", pack=False, align=None),
    "CF_POPULATION_POLICY": SimStruct(OrderedDict((("Primary", SimTypeInt(signed=False, label="CF_POPULATION_POLICY_PRIMARY")), ("Modifier", SimTypeInt(signed=False, label="CF_POPULATION_POLICY_MODIFIER")),)), name="CF_POPULATION_POLICY", pack=False, align=None),
    "CF_POPULATION_POLICY_MODIFIER": SimTypeInt(signed=False, label="CF_POPULATION_POLICY_MODIFIER"),
    "CF_POPULATION_POLICY_PRIMARY": SimTypeInt(signed=False, label="CF_POPULATION_POLICY_PRIMARY"),
    "CF_PROCESS_INFO": SimStruct(OrderedDict((("StructSize", SimTypeInt(signed=False, label="UInt32")), ("ProcessId", SimTypeInt(signed=False, label="UInt32")), ("ImagePath", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("PackageName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ApplicationId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("CommandLine", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("SessionId", SimTypeInt(signed=False, label="UInt32")),)), name="CF_PROCESS_INFO", pack=False, align=None),
    "CF_REGISTER_FLAGS": SimTypeInt(signed=False, label="CF_REGISTER_FLAGS"),
    "CF_REVERT_FLAGS": SimTypeInt(signed=False, label="CF_REVERT_FLAGS"),
    "CF_SET_IN_SYNC_FLAGS": SimTypeInt(signed=False, label="CF_SET_IN_SYNC_FLAGS"),
    "CF_SET_PIN_FLAGS": SimTypeInt(signed=False, label="CF_SET_PIN_FLAGS"),
    "CF_SYNC_POLICIES": SimStruct(OrderedDict((("StructSize", SimTypeInt(signed=False, label="UInt32")), ("Hydration", SimTypeRef("CF_HYDRATION_POLICY", SimStruct)), ("Population", SimTypeRef("CF_POPULATION_POLICY", SimStruct)), ("InSync", SimTypeInt(signed=False, label="CF_INSYNC_POLICY")), ("HardLink", SimTypeInt(signed=False, label="CF_HARDLINK_POLICY")), ("PlaceholderManagement", SimTypeInt(signed=False, label="CF_PLACEHOLDER_MANAGEMENT_POLICY")),)), name="CF_SYNC_POLICIES", pack=False, align=None),
    "CF_SYNC_PROVIDER_STATUS": SimTypeInt(signed=False, label="CF_SYNC_PROVIDER_STATUS"),
    "CF_SYNC_REGISTRATION": SimStruct(OrderedDict((("StructSize", SimTypeInt(signed=False, label="UInt32")), ("ProviderName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ProviderVersion", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("SyncRootIdentity", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("SyncRootIdentityLength", SimTypeInt(signed=False, label="UInt32")), ("FileIdentity", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("FileIdentityLength", SimTypeInt(signed=False, label="UInt32")), ("ProviderId", SimTypeBottom(label="Guid")),)), name="CF_SYNC_REGISTRATION", pack=False, align=None),
    "CF_SYNC_ROOT_BASIC_INFO": SimStruct(OrderedDict((("SyncRootFileId", SimTypeLongLong(signed=True, label="Int64")),)), name="CF_SYNC_ROOT_BASIC_INFO", pack=False, align=None),
    "CF_SYNC_ROOT_INFO_CLASS": SimTypeInt(signed=False, label="CF_SYNC_ROOT_INFO_CLASS"),
    "CF_SYNC_ROOT_PROVIDER_INFO": SimStruct(OrderedDict((("ProviderStatus", SimTypeInt(signed=False, label="CF_SYNC_PROVIDER_STATUS")), ("ProviderName", SimTypeArray(SimTypeChar(label="Char"), 256)), ("ProviderVersion", SimTypeArray(SimTypeChar(label="Char"), 256)),)), name="CF_SYNC_ROOT_PROVIDER_INFO", pack=False, align=None),
    "CF_SYNC_ROOT_STANDARD_INFO": SimStruct(OrderedDict((("SyncRootFileId", SimTypeLongLong(signed=True, label="Int64")), ("HydrationPolicy", SimTypeRef("CF_HYDRATION_POLICY", SimStruct)), ("PopulationPolicy", SimTypeRef("CF_POPULATION_POLICY", SimStruct)), ("InSyncPolicy", SimTypeInt(signed=False, label="CF_INSYNC_POLICY")), ("HardLinkPolicy", SimTypeInt(signed=False, label="CF_HARDLINK_POLICY")), ("ProviderStatus", SimTypeInt(signed=False, label="CF_SYNC_PROVIDER_STATUS")), ("ProviderName", SimTypeArray(SimTypeChar(label="Char"), 256)), ("ProviderVersion", SimTypeArray(SimTypeChar(label="Char"), 256)), ("SyncRootIdentityLength", SimTypeInt(signed=False, label="UInt32")), ("SyncRootIdentity", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CF_SYNC_ROOT_STANDARD_INFO", pack=False, align=None),
    "CF_SYNC_STATUS": SimStruct(OrderedDict((("StructSize", SimTypeInt(signed=False, label="UInt32")), ("Code", SimTypeInt(signed=False, label="UInt32")), ("DescriptionOffset", SimTypeInt(signed=False, label="UInt32")), ("DescriptionLength", SimTypeInt(signed=False, label="UInt32")), ("DeviceIdOffset", SimTypeInt(signed=False, label="UInt32")), ("DeviceIdLength", SimTypeInt(signed=False, label="UInt32")),)), name="CF_SYNC_STATUS", pack=False, align=None),
    "CF_UPDATE_FLAGS": SimTypeInt(signed=False, label="CF_UPDATE_FLAGS"),
    "CGpEffect": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "CHANGEFILTERSTRUCT": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("ExtStatus", SimTypeInt(signed=False, label="MSGFLTINFO_STATUS")),)), name="CHANGEFILTERSTRUCT", pack=False, align=None),
    "CHANGEKIND": SimTypeInt(signed=False, label="CHANGEKIND"),
    "CHANGENOTIFY": SimStruct(OrderedDict((("dwChangeType", SimTypeInt(signed=False, label="UInt32")), ("pvCookieData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CHANGENOTIFY", pack=False, align=None),
    "CHANGER_DEVICE_PROBLEM_TYPE": SimTypeInt(signed=False, label="CHANGER_DEVICE_PROBLEM_TYPE"),
    "CHANGER_ELEMENT": SimStruct(OrderedDict((("ElementType", SimTypeInt(signed=False, label="ELEMENT_TYPE")), ("ElementAddress", SimTypeInt(signed=False, label="UInt32")),)), name="CHANGER_ELEMENT", pack=False, align=None),
    "CHANGER_ELEMENT_LIST": SimStruct(OrderedDict((("Element", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("NumberOfElements", SimTypeInt(signed=False, label="UInt32")),)), name="CHANGER_ELEMENT_LIST", pack=False, align=None),
    "CHANGER_ELEMENT_STATUS": SimStruct(OrderedDict((("Element", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("SrcElementAddress", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Flags", SimTypeInt(signed=False, label="CHANGER_ELEMENT_STATUS_FLAGS")), ("ExceptionCode", SimTypeInt(signed=False, label="UInt32")), ("TargetId", SimTypeChar(label="Byte")), ("Lun", SimTypeChar(label="Byte")), ("Reserved", SimTypeShort(signed=False, label="UInt16")), ("PrimaryVolumeID", SimTypeArray(SimTypeChar(label="Byte"), 36)), ("AlternateVolumeID", SimTypeArray(SimTypeChar(label="Byte"), 36)),)), name="CHANGER_ELEMENT_STATUS", pack=False, align=None),
    "CHANGER_ELEMENT_STATUS_EX": SimStruct(OrderedDict((("Element", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("SrcElementAddress", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Flags", SimTypeInt(signed=False, label="CHANGER_ELEMENT_STATUS_FLAGS")), ("ExceptionCode", SimTypeInt(signed=False, label="UInt32")), ("TargetId", SimTypeChar(label="Byte")), ("Lun", SimTypeChar(label="Byte")), ("Reserved", SimTypeShort(signed=False, label="UInt16")), ("PrimaryVolumeID", SimTypeArray(SimTypeChar(label="Byte"), 36)), ("AlternateVolumeID", SimTypeArray(SimTypeChar(label="Byte"), 36)), ("VendorIdentification", SimTypeArray(SimTypeChar(label="Byte"), 8)), ("ProductIdentification", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("SerialNumber", SimTypeArray(SimTypeChar(label="Byte"), 32)),)), name="CHANGER_ELEMENT_STATUS_EX", pack=False, align=None),
    "CHANGER_ELEMENT_STATUS_FLAGS": SimTypeInt(signed=False, label="CHANGER_ELEMENT_STATUS_FLAGS"),
    "CHANGER_EXCHANGE_MEDIUM": SimStruct(OrderedDict((("Transport", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Source", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Destination1", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Destination2", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Flip1", SimTypeChar(label="Byte")), ("Flip2", SimTypeChar(label="Byte")),)), name="CHANGER_EXCHANGE_MEDIUM", pack=False, align=None),
    "CHANGER_FEATURES": SimTypeInt(signed=False, label="CHANGER_FEATURES"),
    "CHANGER_INITIALIZE_ELEMENT_STATUS": SimStruct(OrderedDict((("ElementList", SimTypeRef("CHANGER_ELEMENT_LIST", SimStruct)), ("BarCodeScan", SimTypeChar(label="Byte")),)), name="CHANGER_INITIALIZE_ELEMENT_STATUS", pack=False, align=None),
    "CHANGER_MOVE_MEDIUM": SimStruct(OrderedDict((("Transport", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Source", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Destination", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Flip", SimTypeChar(label="Byte")),)), name="CHANGER_MOVE_MEDIUM", pack=False, align=None),
    "CHANGER_PRODUCT_DATA": SimStruct(OrderedDict((("VendorId", SimTypeArray(SimTypeChar(label="Byte"), 8)), ("ProductId", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("Revision", SimTypeArray(SimTypeChar(label="Byte"), 4)), ("SerialNumber", SimTypeArray(SimTypeChar(label="Byte"), 32)), ("DeviceType", SimTypeChar(label="Byte")),)), name="CHANGER_PRODUCT_DATA", pack=False, align=None),
    "CHANGER_READ_ELEMENT_STATUS": SimStruct(OrderedDict((("ElementList", SimTypeRef("CHANGER_ELEMENT_LIST", SimStruct)), ("VolumeTagInfo", SimTypeChar(label="Byte")),)), name="CHANGER_READ_ELEMENT_STATUS", pack=False, align=None),
    "CHANGER_SEND_VOLUME_TAG_INFORMATION": SimStruct(OrderedDict((("StartingElement", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("ActionCode", SimTypeInt(signed=False, label="UInt32")), ("VolumeIDTemplate", SimTypeArray(SimTypeChar(label="Byte"), 40)),)), name="CHANGER_SEND_VOLUME_TAG_INFORMATION", pack=False, align=None),
    "CHANGER_SET_ACCESS": SimStruct(OrderedDict((("Element", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Control", SimTypeInt(signed=False, label="UInt32")),)), name="CHANGER_SET_ACCESS", pack=False, align=None),
    "CHANGER_SET_POSITION": SimStruct(OrderedDict((("Transport", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Destination", SimTypeRef("CHANGER_ELEMENT", SimStruct)), ("Flip", SimTypeChar(label="Byte")),)), name="CHANGER_SET_POSITION", pack=False, align=None),
    "CHANGETYPE": SimTypeInt(signed=False, label="CHANGETYPE"),
    "CHANGE_ATTRIBUTES_PARAMETERS": SimStruct(OrderedDict((("style", SimTypeInt(signed=False, label="VDS_PARTITION_STYLE")), ("Anonymous", SimUnion({"MbrPartInfo": SimTypeRef("_MbrPartInfo_e__Struct", SimStruct), "GptPartInfo": SimTypeRef("_GptPartInfo_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="CHANGE_ATTRIBUTES_PARAMETERS", pack=False, align=None),
    "CHANGE_ICON_FLAGS": SimTypeInt(signed=False, label="CHANGE_ICON_FLAGS"),
    "CHANGE_PARTITION_TYPE_PARAMETERS": SimStruct(OrderedDict((("style", SimTypeInt(signed=False, label="VDS_PARTITION_STYLE")), ("Anonymous", SimUnion({"MbrPartInfo": SimTypeRef("_MbrPartInfo_e__Struct", SimStruct), "GptPartInfo": SimTypeRef("_GptPartInfo_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="CHANGE_PARTITION_TYPE_PARAMETERS", pack=False, align=None),
    "CHANGE_PASSWORD_FN_A": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SecBufferDesc", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7"]), offset=0),
    "CHANGE_PASSWORD_FN_W": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SecBufferDesc", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7"]), offset=0),
    "CHANGE_SOURCE_FLAGS": SimTypeInt(signed=False, label="CHANGE_SOURCE_FLAGS"),
    "CHANGE_WINDOW_MESSAGE_FILTER_FLAGS": SimTypeInt(signed=False, label="CHANGE_WINDOW_MESSAGE_FILTER_FLAGS"),
    "CHANNEL_ACCESS_ENUM": SimTypeInt(signed=False, label="CHANNEL_ACCESS_ENUM"),
    "CHANNEL_AGENT_FLAGS": SimTypeInt(signed=False, label="CHANNEL_AGENT_FLAGS"),
    "CHANNEL_CAPS": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwSrcRectXMod", SimTypeInt(signed=False, label="UInt32")), ("dwSrcRectYMod", SimTypeInt(signed=False, label="UInt32")), ("dwSrcRectWidthMod", SimTypeInt(signed=False, label="UInt32")), ("dwSrcRectHeightMod", SimTypeInt(signed=False, label="UInt32")), ("dwDstRectXMod", SimTypeInt(signed=False, label="UInt32")), ("dwDstRectYMod", SimTypeInt(signed=False, label="UInt32")), ("dwDstRectWidthMod", SimTypeInt(signed=False, label="UInt32")), ("dwDstRectHeightMod", SimTypeInt(signed=False, label="UInt32")),)), name="CHANNEL_CAPS", pack=False, align=None),
    "CHANNEL_DEF": SimStruct(OrderedDict((("name", SimTypeArray(SimTypeChar(label="SByte"), 8)), ("options", SimTypeInt(signed=False, label="UInt32")),)), name="CHANNEL_DEF", pack=False, align=None),
    "CHANNEL_ENTRY_POINTS": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("protocolVersion", SimTypeInt(signed=False, label="UInt32")), ("pVirtualChannelInit", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeRef("CHANNEL_DEF", SimStruct), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pInitHandle", "event", "pData", "dataLength"]), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ppInitHandle", "pChannel", "channelCount", "versionRequested", "pChannelInitEventProc"]), offset=0)), ("pVirtualChannelOpen", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["openHandle", "event", "pData", "dataLength", "totalLength", "dataFlags"]), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInitHandle", "pOpenHandle", "pChannelName", "pChannelOpenEventProc"]), offset=0)), ("pVirtualChannelClose", SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["openHandle"]), offset=0)), ("pVirtualChannelWrite", SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["openHandle", "pData", "dataLength", "pUserData"]), offset=0)),)), name="CHANNEL_ENTRY_POINTS", pack=False, align=None),
    "CHANNEL_FLAGS": SimTypeInt(signed=False, label="CHANNEL_FLAGS"),
    "CHANNEL_INFO": SimStruct(OrderedDict((("EventChannelSize", SimTypeInt(signed=False, label="UInt32")), ("uReadDataAlignment", SimTypeInt(signed=False, label="UInt32")), ("uWriteDataAlignment", SimTypeInt(signed=False, label="UInt32")),)), name="CHANNEL_INFO", pack=False, align=None),
    "CHANNEL_PDU_HEADER": SimStruct(OrderedDict((("length", SimTypeInt(signed=False, label="UInt32")), ("flags", SimTypeInt(signed=False, label="UInt32")),)), name="CHANNEL_PDU_HEADER", pack=False, align=None),
    "CHANNEL_PRIORITY": SimTypeInt(signed=False, label="CHANNEL_PRIORITY"),
    "CHAR": SimTypeChar(label="SByte"),
    "CHARACTER_RANGE": SimStruct(OrderedDict((("wcLow", SimTypeChar(label="Char")), ("cChars", SimTypeShort(signed=False, label="UInt16")),)), name="CHARACTER_RANGE", pack=False, align=None),
    "CHARFORMAT2A": SimStruct(OrderedDict((("Base", SimTypeRef("CHARFORMATA", SimStruct)), ("wWeight", SimTypeShort(signed=False, label="UInt16")), ("sSpacing", SimTypeShort(signed=True, label="Int16")), ("crBackColor", SimTypeInt(signed=False, label="UInt32")), ("lcid", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwCookie": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("sStyle", SimTypeShort(signed=True, label="Int16")), ("wKerning", SimTypeShort(signed=False, label="UInt16")), ("bUnderlineType", SimTypeChar(label="Byte")), ("bAnimation", SimTypeChar(label="Byte")), ("bRevAuthor", SimTypeChar(label="Byte")), ("bUnderlineColor", SimTypeChar(label="Byte")),)), name="CHARFORMAT2A", pack=False, align=None),
    "CHARFORMAT2W": SimStruct(OrderedDict((("Base", SimTypeRef("CHARFORMATW", SimStruct)), ("wWeight", SimTypeShort(signed=False, label="UInt16")), ("sSpacing", SimTypeShort(signed=True, label="Int16")), ("crBackColor", SimTypeInt(signed=False, label="UInt32")), ("lcid", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwCookie": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("sStyle", SimTypeShort(signed=True, label="Int16")), ("wKerning", SimTypeShort(signed=False, label="UInt16")), ("bUnderlineType", SimTypeChar(label="Byte")), ("bAnimation", SimTypeChar(label="Byte")), ("bRevAuthor", SimTypeChar(label="Byte")), ("bUnderlineColor", SimTypeChar(label="Byte")),)), name="CHARFORMAT2W", pack=False, align=None),
    "CHARFORMATA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMask", SimTypeInt(signed=False, label="CFM_MASK")), ("dwEffects", SimTypeInt(signed=False, label="CFE_EFFECTS")), ("yHeight", SimTypeInt(signed=True, label="Int32")), ("yOffset", SimTypeInt(signed=True, label="Int32")), ("crTextColor", SimTypeInt(signed=False, label="UInt32")), ("bCharSet", SimTypeInt(signed=False, label="FONT_CHARSET")), ("bPitchAndFamily", SimTypeChar(label="Byte")), ("szFaceName", SimTypeArray(SimTypeChar(label="SByte"), 32)),)), name="CHARFORMATA", pack=False, align=None),
    "CHARFORMATW": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMask", SimTypeInt(signed=False, label="CFM_MASK")), ("dwEffects", SimTypeInt(signed=False, label="CFE_EFFECTS")), ("yHeight", SimTypeInt(signed=True, label="Int32")), ("yOffset", SimTypeInt(signed=True, label="Int32")), ("crTextColor", SimTypeInt(signed=False, label="UInt32")), ("bCharSet", SimTypeInt(signed=False, label="FONT_CHARSET")), ("bPitchAndFamily", SimTypeChar(label="Byte")), ("szFaceName", SimTypeArray(SimTypeChar(label="Char"), 32)),)), name="CHARFORMATW", pack=False, align=None),
    "CHARRANGE": SimStruct(OrderedDict((("cpMin", SimTypeInt(signed=True, label="Int32")), ("cpMax", SimTypeInt(signed=True, label="Int32")),)), name="CHARRANGE", pack=False, align=None),
    "CHARSETINFO": SimStruct(OrderedDict((("ciCharset", SimTypeInt(signed=False, label="UInt32")), ("ciACP", SimTypeInt(signed=False, label="UInt32")), ("fs", SimTypeRef("FONTSIGNATURE", SimStruct)),)), name="CHARSETINFO", pack=False, align=None),
    "CHAR_IMAGE_INFO": SimStruct(OrderedDict((("CharInfo", SimTypeRef("CHAR_INFO", SimStruct)), ("FontImageInfo", SimTypeRef("FONT_IMAGE_INFO", SimStruct)),)), name="CHAR_IMAGE_INFO", pack=False, align=None),
    "CHAR_INFO": SimStruct(OrderedDict((("Char", SimUnion({"UnicodeChar": SimTypeChar(label="Char"), "AsciiChar": SimTypeChar(label="SByte")}, name="<anon>", label="None")), ("Attributes", SimTypeShort(signed=False, label="UInt16")),)), name="CHAR_INFO", pack=False, align=None),
    "CHECKBOXSTATES": SimTypeInt(signed=False, label="CHECKBOXSTATES"),
    "CHEVRONSTATES": SimTypeInt(signed=False, label="CHEVRONSTATES"),
    "CHEVRONVERTSTATES": SimTypeInt(signed=False, label="CHEVRONVERTSTATES"),
    "CHOOSECOLORA": SimStruct(OrderedDict((("lStructSize", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("rgbResult", SimTypeInt(signed=False, label="UInt32")), ("lpCustColors", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("Flags", SimTypeInt(signed=False, label="CHOOSECOLOR_FLAGS")), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0)), ("lpTemplateName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CHOOSECOLORA", pack=False, align=None),
    "CHOOSECOLORW": SimStruct(OrderedDict((("lStructSize", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("rgbResult", SimTypeInt(signed=False, label="UInt32")), ("lpCustColors", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("Flags", SimTypeInt(signed=False, label="CHOOSECOLOR_FLAGS")), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0)), ("lpTemplateName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CHOOSECOLORW", pack=False, align=None),
    "CHOOSECOLOR_FLAGS": SimTypeInt(signed=False, label="CHOOSECOLOR_FLAGS"),
    "CHOOSEFONTA": SimStruct(OrderedDict((("lStructSize", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hDC", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpLogFont", SimTypePointer(SimTypeRef("LOGFONTA", SimStruct), offset=0)), ("iPointSize", SimTypeInt(signed=True, label="Int32")), ("Flags", SimTypeInt(signed=False, label="CHOOSEFONT_FLAGS")), ("rgbColors", SimTypeInt(signed=False, label="UInt32")), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0)), ("lpTemplateName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpszStyle", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("nFontType", SimTypeInt(signed=False, label="CHOOSEFONT_FONT_TYPE")), ("___MISSING_ALIGNMENT__", SimTypeShort(signed=False, label="UInt16")), ("nSizeMin", SimTypeInt(signed=True, label="Int32")), ("nSizeMax", SimTypeInt(signed=True, label="Int32")),)), name="CHOOSEFONTA", pack=False, align=None),
    "CHOOSEFONTW": SimStruct(OrderedDict((("lStructSize", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hDC", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpLogFont", SimTypePointer(SimTypeRef("LOGFONTW", SimStruct), offset=0)), ("iPointSize", SimTypeInt(signed=True, label="Int32")), ("Flags", SimTypeInt(signed=False, label="CHOOSEFONT_FLAGS")), ("rgbColors", SimTypeInt(signed=False, label="UInt32")), ("lCustData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0)), ("lpTemplateName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpszStyle", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("nFontType", SimTypeInt(signed=False, label="CHOOSEFONT_FONT_TYPE")), ("___MISSING_ALIGNMENT__", SimTypeShort(signed=False, label="UInt16")), ("nSizeMin", SimTypeInt(signed=True, label="Int32")), ("nSizeMax", SimTypeInt(signed=True, label="Int32")),)), name="CHOOSEFONTW", pack=False, align=None),
    "CHOOSEFONT_FLAGS": SimTypeInt(signed=False, label="CHOOSEFONT_FLAGS"),
    "CHOOSEFONT_FONT_TYPE": SimTypeInt(signed=False, label="CHOOSEFONT_FONT_TYPE"),
    "CHROMATICITY_COORDINATE": SimStruct(OrderedDict((("x", SimTypeFloat(size=32)), ("y", SimTypeFloat(size=32)),)), name="CHROMATICITY_COORDINATE", pack=False, align=None),
    "CHUNKSTATE": SimTypeInt(signed=False, label="CHUNKSTATE"),
    "CHUNK_BREAKTYPE": SimTypeInt(signed=False, label="CHUNK_BREAKTYPE"),
    "CH_DESCRIPTION_TYPE": SimTypeInt(signed=False, label="CH_DESCRIPTION_TYPE"),
    "CIDA": SimStruct(OrderedDict((("cidl", SimTypeInt(signed=False, label="UInt32")), ("aoffset", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="CIDA", pack=False, align=None),
    "CIE4ConnectionPoint": SimTypeBottom(label="CIE4ConnectionPoint"),
    "CIECHROMA": SimStruct(OrderedDict((("x", SimTypeInt(signed=True, label="Int32")), ("y", SimTypeInt(signed=True, label="Int32")), ("Y", SimTypeInt(signed=True, label="Int32")),)), name="CIECHROMA", pack=False, align=None),
    "CIEXYZ": SimStruct(OrderedDict((("ciexyzX", SimTypeInt(signed=True, label="Int32")), ("ciexyzY", SimTypeInt(signed=True, label="Int32")), ("ciexyzZ", SimTypeInt(signed=True, label="Int32")),)), name="CIEXYZ", pack=False, align=None),
    "CIEXYZTRIPLE": SimStruct(OrderedDict((("ciexyzRed", SimTypeRef("CIEXYZ", SimStruct)), ("ciexyzGreen", SimTypeRef("CIEXYZ", SimStruct)), ("ciexyzBlue", SimTypeRef("CIEXYZ", SimStruct)),)), name="CIEXYZTRIPLE", pack=False, align=None),
    "CIMTYPE_ENUMERATION": SimTypeInt(signed=False, label="CIMTYPE_ENUMERATION"),
    "CIP_STATUS": SimTypeInt(signed=False, label="CIP_STATUS"),
    "CI_STATE": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("cWordList", SimTypeInt(signed=False, label="UInt32")), ("cPersistentIndex", SimTypeInt(signed=False, label="UInt32")), ("cQueries", SimTypeInt(signed=False, label="UInt32")), ("cDocuments", SimTypeInt(signed=False, label="UInt32")), ("cFreshTest", SimTypeInt(signed=False, label="UInt32")), ("dwMergeProgress", SimTypeInt(signed=False, label="UInt32")), ("eState", SimTypeInt(signed=False, label="UInt32")), ("cFilteredDocuments", SimTypeInt(signed=False, label="UInt32")), ("cTotalDocuments", SimTypeInt(signed=False, label="UInt32")), ("cPendingScans", SimTypeInt(signed=False, label="UInt32")), ("dwIndexSize", SimTypeInt(signed=False, label="UInt32")), ("cUniqueKeys", SimTypeInt(signed=False, label="UInt32")), ("cSecQDocuments", SimTypeInt(signed=False, label="UInt32")), ("dwPropCacheSize", SimTypeInt(signed=False, label="UInt32")),)), name="CI_STATE", pack=False, align=None),
    "CKCL_DATA": SimStruct(OrderedDict((("NextLogEvent", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("TAnalyzeString", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("TAnalyzeReturnType", SimTypeInt(signed=False, label="TANALYZE_RETURN")),)), name="CKCL_DATA", pack=False, align=None),
    "CKCL_LISTHEAD": SimStruct(OrderedDict((("LogEventListHead", SimTypePointer(SimTypeRef("CKCL_DATA", SimStruct), offset=0)), ("Heap", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CKCL_LISTHEAD", pack=False, align=None),
    "CLAIMLIST": SimStruct(OrderedDict((("count", SimTypeInt(signed=False, label="UInt32")), ("claims", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="CLAIMLIST", pack=False, align=None),
    "CLAIMMEDIALABEL": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("MediaLabelInfo", SimStruct), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pBuffer", "nBufferSize", "pLabelInfo"]), offset=0),
    "CLAIMMEDIALABELEX": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("MediaLabelInfo", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pBuffer", "nBufferSize", "pLabelInfo", "LabelGuid"]), offset=0),
    "CLAIM_SECURITY_ATTRIBUTES_INFORMATION": SimStruct(OrderedDict((("Version", SimTypeShort(signed=False, label="UInt16")), ("Reserved", SimTypeShort(signed=False, label="UInt16")), ("AttributeCount", SimTypeInt(signed=False, label="UInt32")), ("Attribute", SimUnion({"pAttributeV1": SimTypePointer(SimTypeRef("CLAIM_SECURITY_ATTRIBUTE_V1", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="CLAIM_SECURITY_ATTRIBUTES_INFORMATION", pack=False, align=None),
    "CLAIM_SECURITY_ATTRIBUTE_FLAGS": SimTypeInt(signed=False, label="CLAIM_SECURITY_ATTRIBUTE_FLAGS"),
    "CLAIM_SECURITY_ATTRIBUTE_FQBN_VALUE": SimStruct(OrderedDict((("Version", SimTypeLongLong(signed=False, label="UInt64")), ("Name", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CLAIM_SECURITY_ATTRIBUTE_FQBN_VALUE", pack=False, align=None),
    "CLAIM_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE": SimStruct(OrderedDict((("pValue", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ValueLength", SimTypeInt(signed=False, label="UInt32")),)), name="CLAIM_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE", pack=False, align=None),
    "CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1": SimStruct(OrderedDict((("Name", SimTypeInt(signed=False, label="UInt32")), ("ValueType", SimTypeInt(signed=False, label="CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE")), ("Reserved", SimTypeShort(signed=False, label="UInt16")), ("Flags", SimTypeInt(signed=False, label="CLAIM_SECURITY_ATTRIBUTE_FLAGS")), ("ValueCount", SimTypeInt(signed=False, label="UInt32")), ("Values", SimUnion({"pInt64": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pUint64": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ppString": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pFqbn": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pOctetString": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="<anon>", label="None")),)), name="CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1", pack=False, align=None),
    "CLAIM_SECURITY_ATTRIBUTE_V1": SimStruct(OrderedDict((("Name", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ValueType", SimTypeInt(signed=False, label="CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE")), ("Reserved", SimTypeShort(signed=False, label="UInt16")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("ValueCount", SimTypeInt(signed=False, label="UInt32")), ("Values", SimUnion({"pInt64": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "pUint64": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "ppString": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "pFqbn": SimTypePointer(SimTypeRef("CLAIM_SECURITY_ATTRIBUTE_FQBN_VALUE", SimStruct), offset=0), "pOctetString": SimTypePointer(SimTypeRef("CLAIM_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="CLAIM_SECURITY_ATTRIBUTE_V1", pack=False, align=None),
    "CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE": SimTypeInt(signed=False, label="CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE"),
    "CLASSIC_EVENT_ID": SimStruct(OrderedDict((("EventGuid", SimTypeBottom(label="Guid")), ("Type", SimTypeChar(label="Byte")), ("Reserved", SimTypeArray(SimTypeChar(label="Byte"), 7)),)), name="CLASSIC_EVENT_ID", pack=False, align=None),
    "CLASS_MEDIA_CHANGE_CONTEXT": SimStruct(OrderedDict((("MediaChangeCount", SimTypeInt(signed=False, label="UInt32")), ("NewState", SimTypeInt(signed=False, label="UInt32")),)), name="CLASS_MEDIA_CHANGE_CONTEXT", pack=False, align=None),
    "CLCTL_CODES": SimTypeInt(signed=False, label="CLCTL_CODES"),
    "CLEANLOCALSTORAGE": SimStruct(OrderedDict((("pInterface", SimTypeBottom(label="IUnknown")), ("pStorage", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("flags", SimTypeInt(signed=False, label="UInt32")),)), name="CLEANLOCALSTORAGE", pack=False, align=None),
    "CLEAR_BLOCK": SimStruct(OrderedDict((("data", SimTypeArray(SimTypeChar(label="SByte"), 8)),)), name="CLEAR_BLOCK", pack=False, align=None),
    "CLEAR_COMM_ERROR_FLAGS": SimTypeInt(signed=False, label="CLEAR_COMM_ERROR_FLAGS"),
    "CLFS_BLOCK_ALLOCATION": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbBufferLength", "pvUserContext"]), offset=0),
    "CLFS_BLOCK_DEALLOCATION": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pvBuffer", "pvUserContext"]), offset=0),
    "CLFS_CONTEXT_MODE": SimTypeInt(signed=False, label="CLFS_CONTEXT_MODE"),
    "CLFS_FLAG": SimTypeInt(signed=False, label="CLFS_FLAG"),
    "CLFS_IOSTATS_CLASS": SimTypeInt(signed=False, label="CLFS_IOSTATS_CLASS"),
    "CLFS_LOG_ARCHIVE_MODE": SimTypeInt(signed=False, label="CLFS_LOG_ARCHIVE_MODE"),
    "CLFS_LOG_NAME_INFORMATION": SimStruct(OrderedDict((("NameLengthInBytes", SimTypeShort(signed=False, label="UInt16")), ("Name", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CLFS_LOG_NAME_INFORMATION", pack=False, align=None),
    "CLFS_MGMT_CLIENT_REGISTRATION": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("AdvanceTailCallback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("FILE_OBJECT", SimStruct), offset=0), SimTypePointer(SimTypeRef("CLS_LSN", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LogFile", "TargetLsn", "ClientData"]), offset=0)), ("AdvanceTailCallbackData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("LogGrowthCompleteCallback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("FILE_OBJECT", SimStruct), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeChar(label="Byte"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["LogFile", "OperationStatus", "LogIsPinned", "ClientData"]), offset=0)), ("LogGrowthCompleteCallbackData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("LogUnpinnedCallback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("FILE_OBJECT", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["LogFile", "ClientData"]), offset=0)), ("LogUnpinnedCallbackData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CLFS_MGMT_CLIENT_REGISTRATION", pack=False, align=None),
    "CLFS_MGMT_NOTIFICATION": SimStruct(OrderedDict((("Notification", SimTypeInt(signed=False, label="CLFS_MGMT_NOTIFICATION_TYPE")), ("Lsn", SimTypeRef("CLS_LSN", SimStruct)), ("LogIsPinned", SimTypeShort(signed=False, label="UInt16")),)), name="CLFS_MGMT_NOTIFICATION", pack=False, align=None),
    "CLFS_MGMT_NOTIFICATION_TYPE": SimTypeInt(signed=False, label="CLFS_MGMT_NOTIFICATION_TYPE"),
    "CLFS_MGMT_POLICY": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("LengthInBytes", SimTypeInt(signed=False, label="UInt32")), ("PolicyFlags", SimTypeInt(signed=False, label="UInt32")), ("PolicyType", SimTypeInt(signed=False, label="CLFS_MGMT_POLICY_TYPE")), ("PolicyParameters", SimUnion({"MaximumSize": SimTypeRef("_MaximumSize_e__Struct", SimStruct), "MinimumSize": SimTypeRef("_MinimumSize_e__Struct", SimStruct), "NewContainerSize": SimTypeRef("_NewContainerSize_e__Struct", SimStruct), "GrowthRate": SimTypeRef("_GrowthRate_e__Struct", SimStruct), "LogTail": SimTypeRef("_LogTail_e__Struct", SimStruct), "AutoShrink": SimTypeRef("_AutoShrink_e__Struct", SimStruct), "AutoGrow": SimTypeRef("_AutoGrow_e__Struct", SimStruct), "NewContainerPrefix": SimTypeRef("_NewContainerPrefix_e__Struct", SimStruct), "NewContainerSuffix": SimTypeRef("_NewContainerSuffix_e__Struct", SimStruct), "NewContainerExtension": SimTypeRef("_NewContainerExtension_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="CLFS_MGMT_POLICY", pack=False, align=None),
    "CLFS_MGMT_POLICY_TYPE": SimTypeInt(signed=False, label="CLFS_MGMT_POLICY_TYPE"),
    "CLFS_NODE_ID": SimStruct(OrderedDict((("cType", SimTypeInt(signed=False, label="UInt32")), ("cbNode", SimTypeInt(signed=False, label="UInt32")),)), name="CLFS_NODE_ID", pack=False, align=None),
    "CLFS_PHYSICAL_LSN_INFORMATION": SimStruct(OrderedDict((("StreamIdentifier", SimTypeChar(label="Byte")), ("VirtualLsn", SimTypeRef("CLS_LSN", SimStruct)), ("PhysicalLsn", SimTypeRef("CLS_LSN", SimStruct)),)), name="CLFS_PHYSICAL_LSN_INFORMATION", pack=False, align=None),
    "CLFS_STREAM_ID_INFORMATION": SimStruct(OrderedDict((("StreamIdentifier", SimTypeChar(label="Byte")),)), name="CLFS_STREAM_ID_INFORMATION", pack=False, align=None),
    "CLIENTCREATESTRUCT": SimStruct(OrderedDict((("hWindowMenu", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("idFirstChild", SimTypeInt(signed=False, label="UInt32")),)), name="CLIENTCREATESTRUCT", pack=False, align=None),
    "CLIENTPROPERTIES": SimTypeInt(signed=False, label="CLIENTPROPERTIES"),
    "CLIENT_CALL_RETURN": SimUnion({"Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Simple": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="<anon>", label="None"),
    "CLIENT_DISPLAY": SimStruct(OrderedDict((("HorizontalResolution", SimTypeInt(signed=False, label="UInt32")), ("VerticalResolution", SimTypeInt(signed=False, label="UInt32")), ("ColorDepth", SimTypeInt(signed=False, label="UInt32")),)), name="CLIENT_DISPLAY", pack=False, align=None),
    "CLIENT_ID": SimStruct(OrderedDict((("UniqueProcess", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("UniqueThread", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CLIENT_ID", pack=False, align=None),
    "CLIENT_MESSAGE_TYPE": SimTypeInt(signed=False, label="CLIENT_MESSAGE_TYPE"),
    "CLIPBOARDFORMAT": SimStruct(OrderedDict((("nmhdr", SimTypeRef("NMHDR", SimStruct)), ("cf", SimTypeShort(signed=False, label="UInt16")),)), name="CLIPBOARDFORMAT", pack=False, align=None),
    "CLIPBOARD_FORMAT": SimTypeInt(signed=False, label="CLIPBOARD_FORMAT"),
    "CLIPDATA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("ulClipFmt", SimTypeInt(signed=True, label="Int32")), ("pClipData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CLIPDATA", pack=False, align=None),
    "CLIPLINE": SimStruct(OrderedDict((("ptfxA", SimTypeRef("POINTFIX", SimStruct)), ("ptfxB", SimTypeRef("POINTFIX", SimStruct)), ("lStyleState", SimTypeInt(signed=True, label="Int32")), ("c", SimTypeInt(signed=False, label="UInt32")), ("arun", SimTypePointer(SimTypeRef("RUN", SimStruct), offset=0)),)), name="CLIPLINE", pack=False, align=None),
    "CLIPOBJ": SimStruct(OrderedDict((("iUniq", SimTypeInt(signed=False, label="UInt32")), ("rclBounds", SimTypeRef("RECTL", SimStruct)), ("iDComplexity", SimTypeChar(label="Byte")), ("iFComplexity", SimTypeChar(label="Byte")), ("iMode", SimTypeChar(label="Byte")), ("fjOptions", SimTypeChar(label="Byte")),)), name="CLIPOBJ", pack=False, align=None),
    "CLOCKPARTS": SimTypeInt(signed=False, label="CLOCKPARTS"),
    "CLOCKSTATES": SimTypeInt(signed=False, label="CLOCKSTATES"),
    "CLOSEBUTTONSTATES": SimTypeInt(signed=False, label="CLOSEBUTTONSTATES"),
    "CLOSESTATES": SimTypeInt(signed=False, label="CLOSESTATES"),
    "CLRCreateInstanceFnPtr": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["clsid", "riid", "ppInterface"]), offset=0),
    "CLRES_CALLBACK_FUNCTION_TABLE": SimStruct(OrderedDict((("LogEvent", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="LOG_LEVEL"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["ResourceHandle", "LogLevel", "FormatString"]), offset=0)), ("SetResourceStatusEx", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("RESOURCE_STATUS_EX", SimStruct), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceHandle", "ResourceStatus"]), offset=0)), ("SetResourceLockedMode", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceHandle", "LockedModeEnabled", "LockedModeReason"]), offset=0)), ("SignalFailure", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="FAILURE_TYPE"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceHandle", "FailureType", "ApplicationSpecificErrorCode"]), offset=0)), ("SetResourceInMemoryNodeLocalProperties", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceHandle", "propertyListBuffer", "propertyListBufferSize"]), offset=0)), ("EndControlCall", SimTypePointer(SimTypeFunction([SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["context", "status"]), offset=0)), ("EndTypeControlCall", SimTypePointer(SimTypeFunction([SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["context", "status"]), offset=0)), ("ExtendControlCall", SimTypePointer(SimTypeFunction([SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["context", "newTimeoutInMs"]), offset=0)), ("ExtendTypeControlCall", SimTypePointer(SimTypeFunction([SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["context", "newTimeoutInMs"]), offset=0)), ("RaiseResTypeNotification", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceType", "pPayload", "payloadSize"]), offset=0)), ("ChangeResourceProcessForDumps", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["resource", "processName", "processId", "isAdd"]), offset=0)), ("ChangeResTypeProcessForDumps", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["resourceTypeName", "processName", "processId", "isAdd"]), offset=0)), ("SetInternalState", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="CLUSTER_RESOURCE_APPLICATION_STATE"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "stateType", "active"]), offset=0)), ("SetResourceLockedModeEx", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceHandle", "LockedModeEnabled", "LockedModeReason", "LockedModeFlags"]), offset=0)), ("RequestDump", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceHandle", "DumpDueToCallInProgress", "DumpDelayInMs"]), offset=0)), ("SetResourceWprPolicy", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceHandle", "WprPolicyFlags"]), offset=0)), ("ArmWprWatchdogForCurrentResourceCall", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceHandle", "TimeoutInMs"]), offset=0)),)), name="CLRES_CALLBACK_FUNCTION_TABLE", pack=False, align=None),
    "CLRES_FUNCTION_TABLE": SimStruct(OrderedDict((("TableSize", SimTypeInt(signed=False, label="UInt32")), ("Version", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"V1Functions": SimTypeRef("CLRES_V1_FUNCTIONS", SimStruct), "V2Functions": SimTypeRef("CLRES_V2_FUNCTIONS", SimStruct), "V3Functions": SimTypeRef("CLRES_V3_FUNCTIONS", SimStruct), "V4Functions": SimTypeRef("CLRES_V4_FUNCTIONS", SimStruct)}, name="<anon>", label="None")),)), name="CLRES_FUNCTION_TABLE", pack=False, align=None),
    "CLRES_V1_FUNCTIONS": SimStruct(OrderedDict((("Open", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["ResourceName", "ResourceKey", "ResourceHandle"]), offset=0)), ("Close", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)), ("Online", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "EventHandle"]), offset=0)), ("Offline", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource"]), offset=0)), ("Terminate", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)), ("LooksAlive", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Resource"]), offset=0)), ("IsAlive", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Resource"]), offset=0)), ("Arbitrate", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "LostQuorumResource"]), offset=0)), ("Release", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource"]), offset=0)), ("ResourceControl", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "ControlCode", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "BytesReturned"]), offset=0)), ("ResourceTypeControl", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceTypeName", "ControlCode", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "BytesReturned"]), offset=0)),)), name="CLRES_V1_FUNCTIONS", pack=False, align=None),
    "CLRES_V2_FUNCTIONS": SimStruct(OrderedDict((("Open", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["ResourceName", "ResourceKey", "ResourceHandle", "OpenFlags"]), offset=0)), ("Close", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)), ("Online", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "EventHandle", "OnlineFlags", "InBuffer", "InBufferSize", "Reserved"]), offset=0)), ("Offline", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "DestinationNodeName", "OfflineFlags", "InBuffer", "InBufferSize", "Reserved"]), offset=0)), ("Terminate", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)), ("LooksAlive", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Resource"]), offset=0)), ("IsAlive", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Resource"]), offset=0)), ("Arbitrate", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "LostQuorumResource"]), offset=0)), ("Release", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource"]), offset=0)), ("ResourceControl", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "ControlCode", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "BytesReturned"]), offset=0)), ("ResourceTypeControl", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceTypeName", "ControlCode", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "BytesReturned"]), offset=0)), ("Cancel", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "CancelFlags_RESERVED"]), offset=0)),)), name="CLRES_V2_FUNCTIONS", pack=False, align=None),
    "CLRES_V3_FUNCTIONS": SimStruct(OrderedDict((("Open", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["ResourceName", "ResourceKey", "ResourceHandle", "OpenFlags"]), offset=0)), ("Close", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)), ("Online", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "EventHandle", "OnlineFlags", "InBuffer", "InBufferSize", "Reserved"]), offset=0)), ("Offline", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "DestinationNodeName", "OfflineFlags", "InBuffer", "InBufferSize", "Reserved"]), offset=0)), ("Terminate", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)), ("LooksAlive", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Resource"]), offset=0)), ("IsAlive", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Resource"]), offset=0)), ("Arbitrate", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "LostQuorumResource"]), offset=0)), ("Release", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource"]), offset=0)), ("BeginResourceControl", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "ControlCode", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "BytesReturned", "context", "ReturnedAsynchronously"]), offset=0)), ("BeginResourceTypeControl", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceTypeName", "ControlCode", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "BytesReturned", "context", "ReturnedAsynchronously"]), offset=0)), ("Cancel", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "CancelFlags_RESERVED"]), offset=0)),)), name="CLRES_V3_FUNCTIONS", pack=False, align=None),
    "CLRES_V4_FUNCTIONS": SimStruct(OrderedDict((("Open", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["ResourceName", "ResourceKey", "ResourceHandle", "OpenFlags"]), offset=0)), ("Close", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)), ("Online", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "EventHandle", "OnlineFlags", "InBuffer", "InBufferSize", "Reserved"]), offset=0)), ("Offline", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "DestinationNodeName", "OfflineFlags", "InBuffer", "InBufferSize", "Reserved"]), offset=0)), ("Terminate", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)), ("LooksAlive", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Resource"]), offset=0)), ("IsAlive", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Resource"]), offset=0)), ("Arbitrate", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["Resource"]), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "LostQuorumResource"]), offset=0)), ("Release", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource"]), offset=0)), ("BeginResourceControl", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "ControlCode", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "BytesReturned", "context", "ReturnedAsynchronously"]), offset=0)), ("BeginResourceTypeControl", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceTypeName", "ControlCode", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "BytesReturned", "context", "ReturnedAsynchronously"]), offset=0)), ("Cancel", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "CancelFlags_RESERVED"]), offset=0)), ("BeginResourceControlAsUser", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Resource", "TokenHandle", "ControlCode", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "BytesReturned", "context", "ReturnedAsynchronously"]), offset=0)), ("BeginResourceTypeControlAsUser", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceTypeName", "TokenHandle", "ControlCode", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "BytesReturned", "context", "ReturnedAsynchronously"]), offset=0)),)), name="CLRES_V4_FUNCTIONS", pack=False, align=None),
    "CLR_DEBUGGING_PROCESS_FLAGS": SimTypeInt(signed=False, label="CLR_DEBUGGING_PROCESS_FLAGS"),
    "CLR_DEBUGGING_VERSION": SimStruct(OrderedDict((("wStructVersion", SimTypeShort(signed=False, label="UInt16")), ("wMajor", SimTypeShort(signed=False, label="UInt16")), ("wMinor", SimTypeShort(signed=False, label="UInt16")), ("wBuild", SimTypeShort(signed=False, label="UInt16")), ("wRevision", SimTypeShort(signed=False, label="UInt16")),)), name="CLR_DEBUGGING_VERSION", pack=False, align=None),
    "CLSCTX": SimTypeInt(signed=False, label="CLSCTX"),
    "CLSIDDATA": SimStruct(OrderedDict((("m_clsid", SimTypeBottom(label="Guid")), ("m_cReferences", SimTypeInt(signed=False, label="UInt32")), ("m_cBound", SimTypeInt(signed=False, label="UInt32")), ("m_cPooled", SimTypeInt(signed=False, label="UInt32")), ("m_cInCall", SimTypeInt(signed=False, label="UInt32")), ("m_dwRespTime", SimTypeInt(signed=False, label="UInt32")), ("m_cCallsCompleted", SimTypeInt(signed=False, label="UInt32")), ("m_cCallsFailed", SimTypeInt(signed=False, label="UInt32")),)), name="CLSIDDATA", pack=False, align=None),
    "CLSIDDATA2": SimStruct(OrderedDict((("m_clsid", SimTypeBottom(label="Guid")), ("m_appid", SimTypeBottom(label="Guid")), ("m_partid", SimTypeBottom(label="Guid")), ("m_pwszAppName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("m_pwszCtxName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("m_eAppType", SimTypeInt(signed=False, label="COMPLUS_APPTYPE")), ("m_cReferences", SimTypeInt(signed=False, label="UInt32")), ("m_cBound", SimTypeInt(signed=False, label="UInt32")), ("m_cPooled", SimTypeInt(signed=False, label="UInt32")), ("m_cInCall", SimTypeInt(signed=False, label="UInt32")), ("m_dwRespTime", SimTypeInt(signed=False, label="UInt32")), ("m_cCallsCompleted", SimTypeInt(signed=False, label="UInt32")), ("m_cCallsFailed", SimTypeInt(signed=False, label="UInt32")),)), name="CLSIDDATA2", pack=False, align=None),
    "CLSID_RESOLUTION_FLAGS": SimTypeInt(signed=False, label="CLSID_RESOLUTION_FLAGS"),
    "CLS_ARCHIVE_DESCRIPTOR": SimStruct(OrderedDict((("coffLow", SimTypeLongLong(signed=False, label="UInt64")), ("coffHigh", SimTypeLongLong(signed=False, label="UInt64")), ("infoContainer", SimTypeRef("CLS_CONTAINER_INFORMATION", SimStruct)),)), name="CLS_ARCHIVE_DESCRIPTOR", pack=False, align=None),
    "CLS_CONTAINER_INFORMATION": SimStruct(OrderedDict((("FileAttributes", SimTypeInt(signed=False, label="UInt32")), ("CreationTime", SimTypeLongLong(signed=False, label="UInt64")), ("LastAccessTime", SimTypeLongLong(signed=False, label="UInt64")), ("LastWriteTime", SimTypeLongLong(signed=False, label="UInt64")), ("ContainerSize", SimTypeLongLong(signed=True, label="Int64")), ("FileNameActualLength", SimTypeInt(signed=False, label="UInt32")), ("FileNameLength", SimTypeInt(signed=False, label="UInt32")), ("FileName", SimTypeArray(SimTypeChar(label="Char"), 256)), ("State", SimTypeInt(signed=False, label="UInt32")), ("PhysicalContainerId", SimTypeInt(signed=False, label="UInt32")), ("LogicalContainerId", SimTypeInt(signed=False, label="UInt32")),)), name="CLS_CONTAINER_INFORMATION", pack=False, align=None),
    "CLS_CONTEXT_MODE": SimTypeInt(signed=False, label="CLS_CONTEXT_MODE"),
    "CLS_INFORMATION": SimStruct(OrderedDict((("TotalAvailable", SimTypeLongLong(signed=True, label="Int64")), ("CurrentAvailable", SimTypeLongLong(signed=True, label="Int64")), ("TotalReservation", SimTypeLongLong(signed=True, label="Int64")), ("BaseFileSize", SimTypeLongLong(signed=False, label="UInt64")), ("ContainerSize", SimTypeLongLong(signed=False, label="UInt64")), ("TotalContainers", SimTypeInt(signed=False, label="UInt32")), ("FreeContainers", SimTypeInt(signed=False, label="UInt32")), ("TotalClients", SimTypeInt(signed=False, label="UInt32")), ("Attributes", SimTypeInt(signed=False, label="UInt32")), ("FlushThreshold", SimTypeInt(signed=False, label="UInt32")), ("SectorSize", SimTypeInt(signed=False, label="UInt32")), ("MinArchiveTailLsn", SimTypeRef("CLS_LSN", SimStruct)), ("BaseLsn", SimTypeRef("CLS_LSN", SimStruct)), ("LastFlushedLsn", SimTypeRef("CLS_LSN", SimStruct)), ("LastLsn", SimTypeRef("CLS_LSN", SimStruct)), ("RestartLsn", SimTypeRef("CLS_LSN", SimStruct)), ("Identity", SimTypeBottom(label="Guid")),)), name="CLS_INFORMATION", pack=False, align=None),
    "CLS_IOSTATS_CLASS": SimTypeInt(signed=False, label="CLS_IOSTATS_CLASS"),
    "CLS_IO_STATISTICS": SimStruct(OrderedDict((("hdrIoStats", SimTypeRef("CLS_IO_STATISTICS_HEADER", SimStruct)), ("cFlush", SimTypeLongLong(signed=False, label="UInt64")), ("cbFlush", SimTypeLongLong(signed=False, label="UInt64")), ("cMetaFlush", SimTypeLongLong(signed=False, label="UInt64")), ("cbMetaFlush", SimTypeLongLong(signed=False, label="UInt64")),)), name="CLS_IO_STATISTICS", pack=False, align=None),
    "CLS_IO_STATISTICS_HEADER": SimStruct(OrderedDict((("ubMajorVersion", SimTypeChar(label="Byte")), ("ubMinorVersion", SimTypeChar(label="Byte")), ("eStatsClass", SimTypeInt(signed=False, label="CLFS_IOSTATS_CLASS")), ("cbLength", SimTypeShort(signed=False, label="UInt16")), ("coffData", SimTypeInt(signed=False, label="UInt32")),)), name="CLS_IO_STATISTICS_HEADER", pack=False, align=None),
    "CLS_LOG_INFORMATION_CLASS": SimTypeInt(signed=False, label="CLS_LOG_INFORMATION_CLASS"),
    "CLS_LSN": SimStruct(OrderedDict((("Internal", SimTypeLongLong(signed=False, label="UInt64")),)), name="CLS_LSN", pack=False, align=None),
    "CLS_SCAN_CONTEXT": SimStruct(OrderedDict((("cidNode", SimTypeRef("CLFS_NODE_ID", SimStruct)), ("hLog", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("cIndex", SimTypeInt(signed=False, label="UInt32")), ("cContainers", SimTypeInt(signed=False, label="UInt32")), ("cContainersReturned", SimTypeInt(signed=False, label="UInt32")), ("eScanMode", SimTypeChar(label="Byte")), ("pinfoContainer", SimTypePointer(SimTypeRef("CLS_CONTAINER_INFORMATION", SimStruct), offset=0)),)), name="CLS_SCAN_CONTEXT", pack=False, align=None),
    "CLS_WRITE_ENTRY": SimStruct(OrderedDict((("Buffer", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("ByteLength", SimTypeInt(signed=False, label="UInt32")),)), name="CLS_WRITE_ENTRY", pack=False, align=None),
    "CLUADMEX_OBJECT_TYPE": SimTypeInt(signed=False, label="CLUADMEX_OBJECT_TYPE"),
    "CLUSAPI_REASON_HANDLER": SimStruct(OrderedDict((("lpParameter", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pfnHandler", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpParameter", "hCluster", "szReason", "lpSize"]), offset=0)),)), name="CLUSAPI_REASON_HANDLER", pack=False, align=None),
    "CLUSCTL_AFFINITYRULE_CODES": SimTypeInt(signed=False, label="CLUSCTL_AFFINITYRULE_CODES"),
    "CLUSCTL_CLUSTER_CODES": SimTypeInt(signed=False, label="CLUSCTL_CLUSTER_CODES"),
    "CLUSCTL_GROUPSET_CODES": SimTypeInt(signed=False, label="CLUSCTL_GROUPSET_CODES"),
    "CLUSCTL_GROUP_CODES": SimTypeInt(signed=False, label="CLUSCTL_GROUP_CODES"),
    "CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT": SimStruct(OrderedDict((("GetTickCount64", SimTypeLongLong(signed=False, label="UInt64")), ("GetSystemTime", SimTypeRef("SYSTEMTIME", SimStruct)), ("NodeId", SimTypeInt(signed=False, label="UInt32")),)), name="CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT", pack=False, align=None),
    "CLUSCTL_NETINTERFACE_CODES": SimTypeInt(signed=False, label="CLUSCTL_NETINTERFACE_CODES"),
    "CLUSCTL_NETWORK_CODES": SimTypeInt(signed=False, label="CLUSCTL_NETWORK_CODES"),
    "CLUSCTL_NODE_CODES": SimTypeInt(signed=False, label="CLUSCTL_NODE_CODES"),
    "CLUSCTL_RESOURCE_CODES": SimTypeInt(signed=False, label="CLUSCTL_RESOURCE_CODES"),
    "CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("eReason", SimTypeInt(signed=False, label="CLUSTER_RESOURCE_STATE_CHANGE_REASON")),)), name="CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT", pack=False, align=None),
    "CLUSCTL_RESOURCE_TYPE_CODES": SimTypeInt(signed=False, label="CLUSCTL_RESOURCE_TYPE_CODES"),
    "CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("guidPoolFilter", SimTypeBottom(label="Guid")),)), name="CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT", pack=False, align=None),
    "CLUSGROUP_TYPE": SimTypeInt(signed=False, label="CLUSGROUP_TYPE"),
    "CLUSION_REASON": SimTypeInt(signed=False, label="CLUSION_REASON"),
    "CLUSPROP_BINARY": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("rgb", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CLUSPROP_BINARY", pack=False, align=None),
    "CLUSPROP_BUFFER_HELPER": SimUnion({"pb": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pw": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pdw": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pl": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "psz": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pList": SimTypePointer(SimTypeRef("CLUSPROP_LIST", SimStruct), offset=0), "pSyntax": SimTypePointer(SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct(OrderedDict((("wFormat", SimTypeShort(signed=False, label="UInt16")), ("wType", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), "pName": SimTypePointer(SimTypeRef("CLUSPROP_SZ", SimStruct), offset=0), "pValue": SimTypePointer(SimTypeRef("CLUSPROP_VALUE", SimStruct), offset=0), "pBinaryValue": SimTypePointer(SimTypeRef("CLUSPROP_BINARY", SimStruct), offset=0), "pWordValue": SimTypePointer(SimTypeRef("CLUSPROP_WORD", SimStruct), offset=0), "pDwordValue": SimTypePointer(SimTypeRef("CLUSPROP_DWORD", SimStruct), offset=0), "pLongValue": SimTypePointer(SimTypeRef("CLUSPROP_LONG", SimStruct), offset=0), "pULargeIntegerValue": SimTypePointer(SimTypeRef("CLUSPROP_ULARGE_INTEGER", SimStruct), offset=0), "pLargeIntegerValue": SimTypePointer(SimTypeRef("CLUSPROP_LARGE_INTEGER", SimStruct), offset=0), "pStringValue": SimTypePointer(SimTypeRef("CLUSPROP_SZ", SimStruct), offset=0), "pMultiSzValue": SimTypePointer(SimTypeRef("CLUSPROP_SZ", SimStruct), offset=0), "pSecurityDescriptor": SimTypePointer(SimTypeRef("CLUSPROP_SECURITY_DESCRIPTOR", SimStruct), offset=0), "pResourceClassValue": SimTypePointer(SimTypeRef("CLUSPROP_RESOURCE_CLASS", SimStruct), offset=0), "pResourceClassInfoValue": SimTypePointer(SimTypeRef("CLUSPROP_RESOURCE_CLASS_INFO", SimStruct), offset=0), "pDiskSignatureValue": SimTypePointer(SimTypeRef("CLUSPROP_DWORD", SimStruct), offset=0), "pScsiAddressValue": SimTypePointer(SimTypeRef("CLUSPROP_SCSI_ADDRESS", SimStruct), offset=0), "pDiskNumberValue": SimTypePointer(SimTypeRef("CLUSPROP_DWORD", SimStruct), offset=0), "pPartitionInfoValue": SimTypePointer(SimTypeRef("CLUSPROP_PARTITION_INFO", SimStruct), offset=0), "pRequiredDependencyValue": SimTypePointer(SimUnion({"Value": SimTypeRef("CLUSPROP_VALUE", SimStruct), "ResClass": SimTypeRef("CLUSPROP_RESOURCE_CLASS", SimStruct), "ResTypeName": SimTypeRef("CLUSPROP_SZ", SimStruct)}, name="<anon>", label="None"), offset=0), "pPartitionInfoValueEx": SimTypePointer(SimTypeRef("CLUSPROP_PARTITION_INFO_EX", SimStruct), offset=0), "pPartitionInfoValueEx2": SimTypePointer(SimTypeRef("CLUSPROP_PARTITION_INFO_EX2", SimStruct), offset=0), "pFileTimeValue": SimTypePointer(SimTypeRef("CLUSPROP_FILETIME", SimStruct), offset=0)}, name="<anon>", label="None"),
    "CLUSPROP_DWORD": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("dw", SimTypeInt(signed=False, label="UInt32")),)), name="CLUSPROP_DWORD", pack=False, align=None),
    "CLUSPROP_FILETIME": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("ft", SimTypeRef("FILETIME", SimStruct)),)), name="CLUSPROP_FILETIME", pack=False, align=None),
    "CLUSPROP_FTSET_INFO": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("Base2", SimTypeRef("CLUS_FTSET_INFO", SimStruct)),)), name="CLUSPROP_FTSET_INFO", pack=False, align=None),
    "CLUSPROP_IPADDR_ENABLENETBIOS": SimTypeInt(signed=False, label="CLUSPROP_IPADDR_ENABLENETBIOS"),
    "CLUSPROP_LARGE_INTEGER": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("li", SimTypeLongLong(signed=True, label="Int64")),)), name="CLUSPROP_LARGE_INTEGER", pack=False, align=None),
    "CLUSPROP_LIST": SimStruct(OrderedDict((("nPropertyCount", SimTypeInt(signed=False, label="UInt32")), ("PropertyName", SimTypeRef("CLUSPROP_SZ", SimStruct)),)), name="CLUSPROP_LIST", pack=False, align=None),
    "CLUSPROP_LONG": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("l", SimTypeInt(signed=True, label="Int32")),)), name="CLUSPROP_LONG", pack=False, align=None),
    "CLUSPROP_PARTITION_INFO": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("Base2", SimTypeRef("CLUS_PARTITION_INFO", SimStruct)),)), name="CLUSPROP_PARTITION_INFO", pack=False, align=None),
    "CLUSPROP_PARTITION_INFO_EX": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("Base2", SimTypeRef("CLUS_PARTITION_INFO_EX", SimStruct)),)), name="CLUSPROP_PARTITION_INFO_EX", pack=False, align=None),
    "CLUSPROP_PARTITION_INFO_EX2": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_PARTITION_INFO_EX", SimStruct)), ("Base2", SimTypeRef("CLUS_PARTITION_INFO_EX2", SimStruct)),)), name="CLUSPROP_PARTITION_INFO_EX2", pack=False, align=None),
    "CLUSPROP_PIFLAGS": SimTypeInt(signed=False, label="CLUSPROP_PIFLAGS"),
    "CLUSPROP_REQUIRED_DEPENDENCY": SimUnion({"Value": SimTypeRef("CLUSPROP_VALUE", SimStruct), "ResClass": SimTypeRef("CLUSPROP_RESOURCE_CLASS", SimStruct), "ResTypeName": SimTypeRef("CLUSPROP_SZ", SimStruct)}, name="<anon>", label="None"),
    "CLUSPROP_RESOURCE_CLASS": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("rc", SimTypeInt(signed=False, label="CLUSTER_RESOURCE_CLASS")),)), name="CLUSPROP_RESOURCE_CLASS", pack=False, align=None),
    "CLUSPROP_RESOURCE_CLASS_INFO": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("Base2", SimTypeRef("CLUS_RESOURCE_CLASS_INFO", SimStruct)),)), name="CLUSPROP_RESOURCE_CLASS_INFO", pack=False, align=None),
    "CLUSPROP_SCSI_ADDRESS": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("Base2", SimTypeRef("CLUS_SCSI_ADDRESS", SimStruct)),)), name="CLUSPROP_SCSI_ADDRESS", pack=False, align=None),
    "CLUSPROP_SECURITY_DESCRIPTOR": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("Anonymous", SimUnion({"sd": SimTypeRef("SECURITY_DESCRIPTOR_RELATIVE", SimStruct), "rgbSecurityDescriptor": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")),)), name="CLUSPROP_SECURITY_DESCRIPTOR", pack=False, align=None),
    "CLUSPROP_SYNTAX": SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct(OrderedDict((("wFormat", SimTypeShort(signed=False, label="UInt16")), ("wType", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"),
    "CLUSPROP_SZ": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("sz", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CLUSPROP_SZ", pack=False, align=None),
    "CLUSPROP_ULARGE_INTEGER": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("li", SimTypeLongLong(signed=False, label="UInt64")),)), name="CLUSPROP_ULARGE_INTEGER", pack=False, align=None),
    "CLUSPROP_VALUE": SimStruct(OrderedDict((("Syntax", SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct(OrderedDict((("wFormat", SimTypeShort(signed=False, label="UInt16")), ("wType", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")), ("cbLength", SimTypeInt(signed=False, label="UInt32")),)), name="CLUSPROP_VALUE", pack=False, align=None),
    "CLUSPROP_WORD": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSPROP_VALUE", SimStruct)), ("w", SimTypeShort(signed=False, label="UInt16")),)), name="CLUSPROP_WORD", pack=False, align=None),
    "CLUSTERSET_OBJECT_TYPE": SimTypeInt(signed=False, label="CLUSTERSET_OBJECT_TYPE"),
    "CLUSTERVERSIONINFO": SimStruct(OrderedDict((("dwVersionInfoSize", SimTypeInt(signed=False, label="UInt32")), ("MajorVersion", SimTypeShort(signed=False, label="UInt16")), ("MinorVersion", SimTypeShort(signed=False, label="UInt16")), ("BuildNumber", SimTypeShort(signed=False, label="UInt16")), ("szVendorId", SimTypeArray(SimTypeChar(label="Char"), 64)), ("szCSDVersion", SimTypeArray(SimTypeChar(label="Char"), 64)), ("dwClusterHighestVersion", SimTypeInt(signed=False, label="UInt32")), ("dwClusterLowestVersion", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeInt(signed=False, label="UInt32")),)), name="CLUSTERVERSIONINFO", pack=False, align=None),
    "CLUSTERVERSIONINFO_NT4": SimStruct(OrderedDict((("dwVersionInfoSize", SimTypeInt(signed=False, label="UInt32")), ("MajorVersion", SimTypeShort(signed=False, label="UInt16")), ("MinorVersion", SimTypeShort(signed=False, label="UInt16")), ("BuildNumber", SimTypeShort(signed=False, label="UInt16")), ("szVendorId", SimTypeArray(SimTypeChar(label="Char"), 64)), ("szCSDVersion", SimTypeArray(SimTypeChar(label="Char"), 64)),)), name="CLUSTERVERSIONINFO_NT4", pack=False, align=None),
    "CLUSTER_AVAILABILITY_SET_CONFIG": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("dwUpdateDomains", SimTypeInt(signed=False, label="UInt32")), ("dwFaultDomains", SimTypeInt(signed=False, label="UInt32")), ("bReserveSpareNode", SimTypeInt(signed=True, label="Int32")),)), name="CLUSTER_AVAILABILITY_SET_CONFIG", pack=False, align=None),
    "CLUSTER_BATCH_COMMAND": SimStruct(OrderedDict((("Command", SimTypeInt(signed=False, label="CLUSTER_REG_COMMAND")), ("dwOptions", SimTypeInt(signed=False, label="UInt32")), ("wzName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbData", SimTypeInt(signed=False, label="UInt32")),)), name="CLUSTER_BATCH_COMMAND", pack=False, align=None),
    "CLUSTER_CHANGE": SimTypeInt(signed=False, label="CLUSTER_CHANGE"),
    "CLUSTER_CHANGE_CLUSTER_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_CLUSTER_V2"),
    "CLUSTER_CHANGE_GROUPSET_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_GROUPSET_V2"),
    "CLUSTER_CHANGE_GROUP_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_GROUP_V2"),
    "CLUSTER_CHANGE_NETINTERFACE_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_NETINTERFACE_V2"),
    "CLUSTER_CHANGE_NETWORK_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_NETWORK_V2"),
    "CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2"),
    "CLUSTER_CHANGE_NODE_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_NODE_V2"),
    "CLUSTER_CHANGE_QUORUM_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_QUORUM_V2"),
    "CLUSTER_CHANGE_REGISTRY_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_REGISTRY_V2"),
    "CLUSTER_CHANGE_RESOURCE_TYPE_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_RESOURCE_TYPE_V2"),
    "CLUSTER_CHANGE_RESOURCE_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_RESOURCE_V2"),
    "CLUSTER_CHANGE_SHARED_VOLUME_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_SHARED_VOLUME_V2"),
    "CLUSTER_CHANGE_SPACEPORT_V2": SimTypeInt(signed=False, label="CLUSTER_CHANGE_SPACEPORT_V2"),
    "CLUSTER_CLOUD_TYPE": SimTypeInt(signed=False, label="CLUSTER_CLOUD_TYPE"),
    "CLUSTER_CONTROL_OBJECT": SimTypeInt(signed=False, label="CLUSTER_CONTROL_OBJECT"),
    "CLUSTER_CREATE_GROUP_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("groupType", SimTypeInt(signed=False, label="CLUSGROUP_TYPE")),)), name="CLUSTER_CREATE_GROUP_INFO", pack=False, align=None),
    "CLUSTER_CSV_VOLUME_FAULT_STATE": SimTypeInt(signed=False, label="CLUSTER_CSV_VOLUME_FAULT_STATE"),
    "CLUSTER_ENUM": SimTypeInt(signed=False, label="CLUSTER_ENUM"),
    "CLUSTER_ENUM_ITEM": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("dwType", SimTypeInt(signed=False, label="UInt32")), ("cbId", SimTypeInt(signed=False, label="UInt32")), ("lpszId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cbName", SimTypeInt(signed=False, label="UInt32")), ("lpszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CLUSTER_ENUM_ITEM", pack=False, align=None),
    "CLUSTER_GROUP_AUTOFAILBACK_TYPE": SimTypeInt(signed=False, label="CLUSTER_GROUP_AUTOFAILBACK_TYPE"),
    "CLUSTER_GROUP_ENUM": SimTypeInt(signed=False, label="CLUSTER_GROUP_ENUM"),
    "CLUSTER_GROUP_ENUM_ITEM": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("cbId", SimTypeInt(signed=False, label="UInt32")), ("lpszId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cbName", SimTypeInt(signed=False, label="UInt32")), ("lpszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("state", SimTypeInt(signed=False, label="CLUSTER_GROUP_STATE")), ("cbOwnerNode", SimTypeInt(signed=False, label="UInt32")), ("lpszOwnerNode", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("cbProperties", SimTypeInt(signed=False, label="UInt32")), ("pProperties", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cbRoProperties", SimTypeInt(signed=False, label="UInt32")), ("pRoProperties", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CLUSTER_GROUP_ENUM_ITEM", pack=False, align=None),
    "CLUSTER_GROUP_PRIORITY": SimTypeInt(signed=False, label="CLUSTER_GROUP_PRIORITY"),
    "CLUSTER_GROUP_STATE": SimTypeInt(signed=False, label="CLUSTER_GROUP_STATE"),
    "CLUSTER_HEALTH_FAULT": SimStruct(OrderedDict((("Id", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ErrorType", SimTypeInt(signed=False, label="UInt32")), ("ErrorCode", SimTypeInt(signed=False, label="UInt32")), ("Description", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Provider", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("Reserved", SimTypeInt(signed=False, label="UInt32")),)), name="CLUSTER_HEALTH_FAULT", pack=False, align=None),
    "CLUSTER_HEALTH_FAULT_ARRAY": SimStruct(OrderedDict((("numFaults", SimTypeInt(signed=False, label="UInt32")), ("faults", SimTypePointer(SimTypeRef("CLUSTER_HEALTH_FAULT", SimStruct), offset=0)),)), name="CLUSTER_HEALTH_FAULT_ARRAY", pack=False, align=None),
    "CLUSTER_IP_ENTRY": SimStruct(OrderedDict((("lpszIpAddress", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwPrefixLength", SimTypeInt(signed=False, label="UInt32")),)), name="CLUSTER_IP_ENTRY", pack=False, align=None),
    "CLUSTER_MEMBERSHIP_INFO": SimStruct(OrderedDict((("HasQuorum", SimTypeInt(signed=True, label="Int32")), ("UpnodesSize", SimTypeInt(signed=False, label="UInt32")), ("Upnodes", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CLUSTER_MEMBERSHIP_INFO", pack=False, align=None),
    "CLUSTER_MGMT_POINT_RESTYPE": SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_RESTYPE"),
    "CLUSTER_MGMT_POINT_TYPE": SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_TYPE"),
    "CLUSTER_NETINTERFACE_STATE": SimTypeInt(signed=False, label="CLUSTER_NETINTERFACE_STATE"),
    "CLUSTER_NETWORK_ENUM": SimTypeInt(signed=False, label="CLUSTER_NETWORK_ENUM"),
    "CLUSTER_NETWORK_ROLE": SimTypeInt(signed=False, label="CLUSTER_NETWORK_ROLE"),
    "CLUSTER_NETWORK_STATE": SimTypeInt(signed=False, label="CLUSTER_NETWORK_STATE"),
    "CLUSTER_NODE_DRAIN_STATUS": SimTypeInt(signed=False, label="CLUSTER_NODE_DRAIN_STATUS"),
    "CLUSTER_NODE_ENUM": SimTypeInt(signed=False, label="CLUSTER_NODE_ENUM"),
    "CLUSTER_NODE_RESUME_FAILBACK_TYPE": SimTypeInt(signed=False, label="CLUSTER_NODE_RESUME_FAILBACK_TYPE"),
    "CLUSTER_NODE_STATE": SimTypeInt(signed=False, label="CLUSTER_NODE_STATE"),
    "CLUSTER_NODE_STATUS": SimTypeInt(signed=False, label="CLUSTER_NODE_STATUS"),
    "CLUSTER_NOTIFICATIONS_VERSION": SimTypeInt(signed=False, label="CLUSTER_NOTIFICATIONS_VERSION"),
    "CLUSTER_OBJECT_TYPE": SimTypeInt(signed=False, label="CLUSTER_OBJECT_TYPE"),
    "CLUSTER_PROPERTY_FORMAT": SimTypeInt(signed=False, label="CLUSTER_PROPERTY_FORMAT"),
    "CLUSTER_PROPERTY_SYNTAX": SimTypeInt(signed=False, label="CLUSTER_PROPERTY_SYNTAX"),
    "CLUSTER_PROPERTY_TYPE": SimTypeInt(signed=False, label="CLUSTER_PROPERTY_TYPE"),
    "CLUSTER_QUORUM_TYPE": SimTypeInt(signed=False, label="CLUSTER_QUORUM_TYPE"),
    "CLUSTER_QUORUM_VALUE": SimTypeInt(signed=False, label="CLUSTER_QUORUM_VALUE"),
    "CLUSTER_RANGE": SimStruct(OrderedDict((("StartingCluster", SimTypeLongLong(signed=True, label="Int64")), ("ClusterCount", SimTypeLongLong(signed=True, label="Int64")),)), name="CLUSTER_RANGE", pack=False, align=None),
    "CLUSTER_READ_BATCH_COMMAND": SimStruct(OrderedDict((("Command", SimTypeInt(signed=False, label="CLUSTER_REG_COMMAND")), ("dwOptions", SimTypeInt(signed=False, label="UInt32")), ("wzSubkeyName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("wzValueName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbData", SimTypeInt(signed=False, label="UInt32")),)), name="CLUSTER_READ_BATCH_COMMAND", pack=False, align=None),
    "CLUSTER_REG_COMMAND": SimTypeInt(signed=False, label="CLUSTER_REG_COMMAND"),
    "CLUSTER_RESOURCE_APPLICATION_STATE": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_APPLICATION_STATE"),
    "CLUSTER_RESOURCE_CLASS": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_CLASS"),
    "CLUSTER_RESOURCE_CREATE_FLAGS": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_CREATE_FLAGS"),
    "CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION"),
    "CLUSTER_RESOURCE_ENUM": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_ENUM"),
    "CLUSTER_RESOURCE_ENUM_ITEM": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("cbId", SimTypeInt(signed=False, label="UInt32")), ("lpszId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cbName", SimTypeInt(signed=False, label="UInt32")), ("lpszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cbOwnerGroupName", SimTypeInt(signed=False, label="UInt32")), ("lpszOwnerGroupName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cbOwnerGroupId", SimTypeInt(signed=False, label="UInt32")), ("lpszOwnerGroupId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cbProperties", SimTypeInt(signed=False, label="UInt32")), ("pProperties", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cbRoProperties", SimTypeInt(signed=False, label="UInt32")), ("pRoProperties", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CLUSTER_RESOURCE_ENUM_ITEM", pack=False, align=None),
    "CLUSTER_RESOURCE_RESTART_ACTION": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_RESTART_ACTION"),
    "CLUSTER_RESOURCE_STATE": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_STATE"),
    "CLUSTER_RESOURCE_STATE_CHANGE_REASON": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_STATE_CHANGE_REASON"),
    "CLUSTER_RESOURCE_TYPE_ENUM": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_TYPE_ENUM"),
    "CLUSTER_ROLE": SimTypeInt(signed=False, label="CLUSTER_ROLE"),
    "CLUSTER_ROLE_STATE": SimTypeInt(signed=False, label="CLUSTER_ROLE_STATE"),
    "CLUSTER_SETUP_PHASE": SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE"),
    "CLUSTER_SETUP_PHASE_SEVERITY": SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_SEVERITY"),
    "CLUSTER_SETUP_PHASE_TYPE": SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_TYPE"),
    "CLUSTER_SET_PASSWORD_STATUS": SimStruct(OrderedDict((("NodeId", SimTypeInt(signed=False, label="UInt32")), ("SetAttempted", SimTypeChar(label="Byte")), ("ReturnStatus", SimTypeInt(signed=False, label="UInt32")),)), name="CLUSTER_SET_PASSWORD_STATUS", pack=False, align=None),
    "CLUSTER_SHARED_VOLUME_BACKUP_STATE": SimTypeInt(signed=False, label="CLUSTER_SHARED_VOLUME_BACKUP_STATE"),
    "CLUSTER_SHARED_VOLUME_RENAME_GUID_INPUT": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME", SimStruct)), ("Base2", SimTypeRef("CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME", SimStruct)),)), name="CLUSTER_SHARED_VOLUME_RENAME_GUID_INPUT", pack=False, align=None),
    "CLUSTER_SHARED_VOLUME_RENAME_INPUT": SimStruct(OrderedDict((("Base", SimTypeRef("CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME", SimStruct)), ("Base2", SimTypeRef("CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME", SimStruct)),)), name="CLUSTER_SHARED_VOLUME_RENAME_INPUT", pack=False, align=None),
    "CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME": SimStruct(OrderedDict((("NewVolumeName", SimTypeArray(SimTypeChar(label="Char"), 260)), ("NewVolumeGuid", SimTypeArray(SimTypeChar(label="Char"), 50)),)), name="CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME", pack=False, align=None),
    "CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME": SimStruct(OrderedDict((("NewVolumeName", SimTypeArray(SimTypeChar(label="Char"), 260)),)), name="CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME", pack=False, align=None),
    "CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE": SimTypeInt(signed=False, label="CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE"),
    "CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME": SimStruct(OrderedDict((("InputType", SimTypeInt(signed=False, label="CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE")), ("Anonymous", SimUnion({"VolumeOffset": SimTypeLongLong(signed=False, label="UInt64"), "VolumeId": SimTypeArray(SimTypeChar(label="Char"), 260), "VolumeName": SimTypeArray(SimTypeChar(label="Char"), 260), "VolumeGuid": SimTypeArray(SimTypeChar(label="Char"), 50)}, name="<anon>", label="None")),)), name="CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME", pack=False, align=None),
    "CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE": SimTypeInt(signed=False, label="CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE"),
    "CLUSTER_SHARED_VOLUME_STATE": SimTypeInt(signed=False, label="CLUSTER_SHARED_VOLUME_STATE"),
    "CLUSTER_SHARED_VOLUME_STATE_INFO": SimStruct(OrderedDict((("szVolumeName", SimTypeArray(SimTypeChar(label="Char"), 260)), ("szNodeName", SimTypeArray(SimTypeChar(label="Char"), 260)), ("VolumeState", SimTypeInt(signed=False, label="CLUSTER_SHARED_VOLUME_STATE")),)), name="CLUSTER_SHARED_VOLUME_STATE_INFO", pack=False, align=None),
    "CLUSTER_SHARED_VOLUME_STATE_INFO_EX": SimStruct(OrderedDict((("szVolumeName", SimTypeArray(SimTypeChar(label="Char"), 260)), ("szNodeName", SimTypeArray(SimTypeChar(label="Char"), 260)), ("VolumeState", SimTypeInt(signed=False, label="CLUSTER_SHARED_VOLUME_STATE")), ("szVolumeFriendlyName", SimTypeArray(SimTypeChar(label="Char"), 260)), ("RedirectedIOReason", SimTypeLongLong(signed=False, label="UInt64")), ("VolumeRedirectedIOReason", SimTypeLongLong(signed=False, label="UInt64")),)), name="CLUSTER_SHARED_VOLUME_STATE_INFO_EX", pack=False, align=None),
    "CLUSTER_STORAGENODE_STATE": SimTypeInt(signed=False, label="CLUSTER_STORAGENODE_STATE"),
    "CLUSTER_UPGRADE_PHASE": SimTypeInt(signed=False, label="CLUSTER_UPGRADE_PHASE"),
    "CLUSTER_VALIDATE_CSV_FILENAME": SimStruct(OrderedDict((("szFileName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CLUSTER_VALIDATE_CSV_FILENAME", pack=False, align=None),
    "CLUSTER_VALIDATE_DIRECTORY": SimStruct(OrderedDict((("szPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CLUSTER_VALIDATE_DIRECTORY", pack=False, align=None),
    "CLUSTER_VALIDATE_NETNAME": SimStruct(OrderedDict((("szNetworkName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CLUSTER_VALIDATE_NETNAME", pack=False, align=None),
    "CLUSTER_VALIDATE_PATH": SimStruct(OrderedDict((("szPath", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CLUSTER_VALIDATE_PATH", pack=False, align=None),
    "CLUS_AFFINITY_RULE_TYPE": SimTypeInt(signed=False, label="CLUS_AFFINITY_RULE_TYPE"),
    "CLUS_CHARACTERISTICS": SimTypeInt(signed=False, label="CLUS_CHARACTERISTICS"),
    "CLUS_CHKDSK_INFO": SimStruct(OrderedDict((("PartitionNumber", SimTypeInt(signed=False, label="UInt32")), ("ChkdskState", SimTypeInt(signed=False, label="UInt32")), ("FileIdCount", SimTypeInt(signed=False, label="UInt32")), ("FileIdList", SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)),)), name="CLUS_CHKDSK_INFO", pack=False, align=None),
    "CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT": SimStruct(OrderedDict((("FileServerName", SimTypeArray(SimTypeChar(label="Char"), 16)),)), name="CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT", pack=False, align=None),
    "CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT": SimStruct(OrderedDict((("FileServerName", SimTypeArray(SimTypeChar(label="Char"), 260)),)), name="CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT", pack=False, align=None),
    "CLUS_CSV_MAINTENANCE_MODE_INFO": SimStruct(OrderedDict((("InMaintenance", SimTypeInt(signed=True, label="Int32")), ("VolumeName", SimTypeArray(SimTypeChar(label="Char"), 260)),)), name="CLUS_CSV_MAINTENANCE_MODE_INFO", pack=False, align=None),
    "CLUS_CSV_VOLUME_INFO": SimStruct(OrderedDict((("VolumeOffset", SimTypeLongLong(signed=False, label="UInt64")), ("PartitionNumber", SimTypeInt(signed=False, label="UInt32")), ("FaultState", SimTypeInt(signed=False, label="CLUSTER_CSV_VOLUME_FAULT_STATE")), ("BackupState", SimTypeInt(signed=False, label="CLUSTER_SHARED_VOLUME_BACKUP_STATE")), ("szVolumeFriendlyName", SimTypeArray(SimTypeChar(label="Char"), 260)), ("szVolumeName", SimTypeArray(SimTypeChar(label="Char"), 50)),)), name="CLUS_CSV_VOLUME_INFO", pack=False, align=None),
    "CLUS_CSV_VOLUME_NAME": SimStruct(OrderedDict((("VolumeOffset", SimTypeLongLong(signed=True, label="Int64")), ("szVolumeName", SimTypeArray(SimTypeChar(label="Char"), 260)), ("szRootPath", SimTypeArray(SimTypeChar(label="Char"), 263)),)), name="CLUS_CSV_VOLUME_NAME", pack=False, align=None),
    "CLUS_DISK_NUMBER_INFO": SimStruct(OrderedDict((("DiskNumber", SimTypeInt(signed=False, label="UInt32")), ("BytesPerSector", SimTypeInt(signed=False, label="UInt32")),)), name="CLUS_DISK_NUMBER_INFO", pack=False, align=None),
    "CLUS_DNN_LEADER_STATUS": SimStruct(OrderedDict((("IsOnline", SimTypeInt(signed=True, label="Int32")), ("IsFileServerPresent", SimTypeInt(signed=True, label="Int32")),)), name="CLUS_DNN_LEADER_STATUS", pack=False, align=None),
    "CLUS_DNN_SODAFS_CLONE_STATUS": SimStruct(OrderedDict((("NodeId", SimTypeInt(signed=False, label="UInt32")), ("Status", SimTypeInt(signed=False, label="CLUSTER_RESOURCE_STATE")),)), name="CLUS_DNN_SODAFS_CLONE_STATUS", pack=False, align=None),
    "CLUS_FLAGS": SimTypeInt(signed=False, label="CLUS_FLAGS"),
    "CLUS_FORCE_QUORUM_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwNodeBitMask", SimTypeInt(signed=False, label="UInt32")), ("dwMaxNumberofNodes", SimTypeInt(signed=False, label="UInt32")), ("multiszNodeList", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CLUS_FORCE_QUORUM_INFO", pack=False, align=None),
    "CLUS_FTSET_INFO": SimStruct(OrderedDict((("dwRootSignature", SimTypeInt(signed=False, label="UInt32")), ("dwFtType", SimTypeInt(signed=False, label="UInt32")),)), name="CLUS_FTSET_INFO", pack=False, align=None),
    "CLUS_GROUP_START_SETTING": SimTypeInt(signed=False, label="CLUS_GROUP_START_SETTING"),
    "CLUS_MAINTENANCE_MODE_INFO": SimStruct(OrderedDict((("InMaintenance", SimTypeInt(signed=True, label="Int32")),)), name="CLUS_MAINTENANCE_MODE_INFO", pack=False, align=None),
    "CLUS_MAINTENANCE_MODE_INFOEX": SimStruct(OrderedDict((("InMaintenance", SimTypeInt(signed=True, label="Int32")), ("MaintainenceModeType", SimTypeInt(signed=False, label="MAINTENANCE_MODE_TYPE_ENUM")), ("InternalState", SimTypeInt(signed=False, label="CLUSTER_RESOURCE_STATE")), ("Signature", SimTypeInt(signed=False, label="UInt32")),)), name="CLUS_MAINTENANCE_MODE_INFOEX", pack=False, align=None),
    "CLUS_NETNAME_IP_INFO_ENTRY": SimStruct(OrderedDict((("NodeId", SimTypeInt(signed=False, label="UInt32")), ("AddressSize", SimTypeInt(signed=False, label="UInt32")), ("Address", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CLUS_NETNAME_IP_INFO_ENTRY", pack=False, align=None),
    "CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL": SimStruct(OrderedDict((("szName", SimTypeArray(SimTypeChar(label="Char"), 64)), ("NumEntries", SimTypeInt(signed=False, label="UInt32")), ("IpInfo", SimTypePointer(SimTypeRef("CLUS_NETNAME_IP_INFO_ENTRY", SimStruct), offset=0)),)), name="CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL", pack=False, align=None),
    "CLUS_NETNAME_PWD_INFO": SimStruct(OrderedDict((("Flags", SimTypeInt(signed=False, label="UInt32")), ("Password", SimTypeArray(SimTypeChar(label="Char"), 16)), ("CreatingDC", SimTypeArray(SimTypeChar(label="Char"), 258)), ("ObjectGuid", SimTypeArray(SimTypeChar(label="Char"), 64)),)), name="CLUS_NETNAME_PWD_INFO", pack=False, align=None),
    "CLUS_NETNAME_PWD_INFOEX": SimStruct(OrderedDict((("Flags", SimTypeInt(signed=False, label="UInt32")), ("Password", SimTypeArray(SimTypeChar(label="Char"), 128)), ("CreatingDC", SimTypeArray(SimTypeChar(label="Char"), 258)), ("ObjectGuid", SimTypeArray(SimTypeChar(label="Char"), 64)),)), name="CLUS_NETNAME_PWD_INFOEX", pack=False, align=None),
    "CLUS_NETNAME_VS_TOKEN_INFO": SimStruct(OrderedDict((("ProcessID", SimTypeInt(signed=False, label="UInt32")), ("DesiredAccess", SimTypeInt(signed=False, label="UInt32")), ("InheritHandle", SimTypeInt(signed=True, label="Int32")),)), name="CLUS_NETNAME_VS_TOKEN_INFO", pack=False, align=None),
    "CLUS_PARTITION_INFO": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("szDeviceName", SimTypeArray(SimTypeChar(label="Char"), 260)), ("szVolumeLabel", SimTypeArray(SimTypeChar(label="Char"), 260)), ("dwSerialNumber", SimTypeInt(signed=False, label="UInt32")), ("rgdwMaximumComponentLength", SimTypeInt(signed=False, label="UInt32")), ("dwFileSystemFlags", SimTypeInt(signed=False, label="UInt32")), ("szFileSystem", SimTypeArray(SimTypeChar(label="Char"), 32)),)), name="CLUS_PARTITION_INFO", pack=False, align=None),
    "CLUS_PARTITION_INFO_EX": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("szDeviceName", SimTypeArray(SimTypeChar(label="Char"), 260)), ("szVolumeLabel", SimTypeArray(SimTypeChar(label="Char"), 260)), ("dwSerialNumber", SimTypeInt(signed=False, label="UInt32")), ("rgdwMaximumComponentLength", SimTypeInt(signed=False, label="UInt32")), ("dwFileSystemFlags", SimTypeInt(signed=False, label="UInt32")), ("szFileSystem", SimTypeArray(SimTypeChar(label="Char"), 32)), ("TotalSizeInBytes", SimTypeLongLong(signed=False, label="UInt64")), ("FreeSizeInBytes", SimTypeLongLong(signed=False, label="UInt64")), ("DeviceNumber", SimTypeInt(signed=False, label="UInt32")), ("PartitionNumber", SimTypeInt(signed=False, label="UInt32")), ("VolumeGuid", SimTypeBottom(label="Guid")),)), name="CLUS_PARTITION_INFO_EX", pack=False, align=None),
    "CLUS_PARTITION_INFO_EX2": SimStruct(OrderedDict((("GptPartitionId", SimTypeBottom(label="Guid")), ("szPartitionName", SimTypeArray(SimTypeChar(label="Char"), 260)), ("EncryptionFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CLUS_PARTITION_INFO_EX2", pack=False, align=None),
    "CLUS_PROVIDER_STATE_CHANGE_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("resourceState", SimTypeInt(signed=False, label="CLUSTER_RESOURCE_STATE")), ("szProviderId", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CLUS_PROVIDER_STATE_CHANGE_INFO", pack=False, align=None),
    "CLUS_RESOURCE_CLASS_INFO": SimStruct(OrderedDict((("Anonymous", SimUnion({"Anonymous": SimStruct(OrderedDict((("Anonymous", SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "rc": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_CLASS")}, name="<anon>", label="None")), ("SubClass", SimTypeInt(signed=False, label="UInt32")),)), name="_Anonymous_e__Struct", pack=False, align=None), "li": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None")),)), name="CLUS_RESOURCE_CLASS_INFO", pack=False, align=None),
    "CLUS_RESSUBCLASS": SimTypeInt(signed=False, label="CLUS_RESSUBCLASS"),
    "CLUS_RESSUBCLASS_NETWORK": SimTypeInt(signed=False, label="CLUS_RESSUBCLASS_NETWORK"),
    "CLUS_RESSUBCLASS_STORAGE": SimTypeInt(signed=False, label="CLUS_RESSUBCLASS_STORAGE"),
    "CLUS_SCSI_ADDRESS": SimStruct(OrderedDict((("Anonymous", SimUnion({"Anonymous": SimStruct(OrderedDict((("PortNumber", SimTypeChar(label="Byte")), ("PathId", SimTypeChar(label="Byte")), ("TargetId", SimTypeChar(label="Byte")), ("Lun", SimTypeChar(label="Byte")),)), name="_Anonymous_e__Struct", pack=False, align=None), "dw": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")),)), name="CLUS_SCSI_ADDRESS", pack=False, align=None),
    "CLUS_SET_MAINTENANCE_MODE_INPUT": SimStruct(OrderedDict((("InMaintenance", SimTypeInt(signed=True, label="Int32")), ("ExtraParameterSize", SimTypeInt(signed=False, label="UInt32")), ("ExtraParameter", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CLUS_SET_MAINTENANCE_MODE_INPUT", pack=False, align=None),
    "CLUS_SHARED_VOLUME_BACKUP_MODE": SimStruct(OrderedDict((("BackupState", SimTypeInt(signed=False, label="CLUSTER_SHARED_VOLUME_BACKUP_STATE")), ("DelayTimerInSecs", SimTypeInt(signed=False, label="UInt32")), ("VolumeName", SimTypeArray(SimTypeChar(label="Char"), 260)),)), name="CLUS_SHARED_VOLUME_BACKUP_MODE", pack=False, align=None),
    "CLUS_STARTING_PARAMS": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("bForm", SimTypeInt(signed=True, label="Int32")), ("bFirst", SimTypeInt(signed=True, label="Int32")),)), name="CLUS_STARTING_PARAMS", pack=False, align=None),
    "CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS": SimStruct(OrderedDict((("AvailDrivelettersMask", SimTypeInt(signed=False, label="UInt32")),)), name="CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS", pack=False, align=None),
    "CLUS_STORAGE_REMAP_DRIVELETTER": SimStruct(OrderedDict((("CurrentDriveLetterMask", SimTypeInt(signed=False, label="UInt32")), ("TargetDriveLetterMask", SimTypeInt(signed=False, label="UInt32")),)), name="CLUS_STORAGE_REMAP_DRIVELETTER", pack=False, align=None),
    "CLUS_STORAGE_SET_DRIVELETTER": SimStruct(OrderedDict((("PartitionNumber", SimTypeInt(signed=False, label="UInt32")), ("DriveLetterMask", SimTypeInt(signed=False, label="UInt32")),)), name="CLUS_STORAGE_SET_DRIVELETTER", pack=False, align=None),
    "CLUS_WORKER": SimStruct(OrderedDict((("hThread", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("Terminate", SimTypeInt(signed=True, label="Int32")),)), name="CLUS_WORKER", pack=False, align=None),
    "CL_ADD_PARTY_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_CALL_CONNECTED_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_CLOSE_AF_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_CLOSE_CALL_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_DEREG_SAP_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_DROP_PARTY_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_INCOMING_CALL_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CL_INCOMING_CALL_QOS_CHANGE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_INCOMING_CLOSE_CALL_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_INCOMING_DROP_PARTY_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_MAKE_CALL_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_MODIFY_CALL_QOS_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_OPEN_AF_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CL_REG_SAP_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CMC_ADD_ATTRIBUTES_INFO": SimStruct(OrderedDict((("dwCmcDataReference", SimTypeInt(signed=False, label="UInt32")), ("cCertReference", SimTypeInt(signed=False, label="UInt32")), ("rgdwCertReference", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("cAttribute", SimTypeInt(signed=False, label="UInt32")), ("rgAttribute", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE", SimStruct), offset=0)),)), name="CMC_ADD_ATTRIBUTES_INFO", pack=False, align=None),
    "CMC_ADD_EXTENSIONS_INFO": SimStruct(OrderedDict((("dwCmcDataReference", SimTypeInt(signed=False, label="UInt32")), ("cCertReference", SimTypeInt(signed=False, label="UInt32")), ("rgdwCertReference", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("cExtension", SimTypeInt(signed=False, label="UInt32")), ("rgExtension", SimTypePointer(SimTypeRef("CERT_EXTENSION", SimStruct), offset=0)),)), name="CMC_ADD_EXTENSIONS_INFO", pack=False, align=None),
    "CMC_DATA_INFO": SimStruct(OrderedDict((("cTaggedAttribute", SimTypeInt(signed=False, label="UInt32")), ("rgTaggedAttribute", SimTypePointer(SimTypeRef("CMC_TAGGED_ATTRIBUTE", SimStruct), offset=0)), ("cTaggedRequest", SimTypeInt(signed=False, label="UInt32")), ("rgTaggedRequest", SimTypePointer(SimTypeRef("CMC_TAGGED_REQUEST", SimStruct), offset=0)), ("cTaggedContentInfo", SimTypeInt(signed=False, label="UInt32")), ("rgTaggedContentInfo", SimTypePointer(SimTypeRef("CMC_TAGGED_CONTENT_INFO", SimStruct), offset=0)), ("cTaggedOtherMsg", SimTypeInt(signed=False, label="UInt32")), ("rgTaggedOtherMsg", SimTypePointer(SimTypeRef("CMC_TAGGED_OTHER_MSG", SimStruct), offset=0)),)), name="CMC_DATA_INFO", pack=False, align=None),
    "CMC_DRIVER_INFO": SimStruct(OrderedDict((("ExceptionCallback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeRef("MCA_EXCEPTION", SimStruct), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context", "CmcLog"]), offset=0)), ("DpcCallback", SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0)), ("DeviceContext", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CMC_DRIVER_INFO", pack=False, align=None),
    "CMC_PEND_INFO": SimStruct(OrderedDict((("PendToken", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("PendTime", SimTypeRef("FILETIME", SimStruct)),)), name="CMC_PEND_INFO", pack=False, align=None),
    "CMC_RESPONSE_INFO": SimStruct(OrderedDict((("cTaggedAttribute", SimTypeInt(signed=False, label="UInt32")), ("rgTaggedAttribute", SimTypePointer(SimTypeRef("CMC_TAGGED_ATTRIBUTE", SimStruct), offset=0)), ("cTaggedContentInfo", SimTypeInt(signed=False, label="UInt32")), ("rgTaggedContentInfo", SimTypePointer(SimTypeRef("CMC_TAGGED_CONTENT_INFO", SimStruct), offset=0)), ("cTaggedOtherMsg", SimTypeInt(signed=False, label="UInt32")), ("rgTaggedOtherMsg", SimTypePointer(SimTypeRef("CMC_TAGGED_OTHER_MSG", SimStruct), offset=0)),)), name="CMC_RESPONSE_INFO", pack=False, align=None),
    "CMC_STATUS_INFO": SimStruct(OrderedDict((("dwStatus", SimTypeInt(signed=False, label="UInt32")), ("cBodyList", SimTypeInt(signed=False, label="UInt32")), ("rgdwBodyList", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("pwszStatusString", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwOtherInfoChoice", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"dwFailInfo": SimTypeInt(signed=False, label="UInt32"), "pPendInfo": SimTypePointer(SimTypeRef("CMC_PEND_INFO", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="CMC_STATUS_INFO", pack=False, align=None),
    "CMC_TAGGED_ATTRIBUTE": SimStruct(OrderedDict((("dwBodyPartID", SimTypeInt(signed=False, label="UInt32")), ("Attribute", SimTypeRef("CRYPT_ATTRIBUTE", SimStruct)),)), name="CMC_TAGGED_ATTRIBUTE", pack=False, align=None),
    "CMC_TAGGED_CERT_REQUEST": SimStruct(OrderedDict((("dwBodyPartID", SimTypeInt(signed=False, label="UInt32")), ("SignedCertRequest", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CMC_TAGGED_CERT_REQUEST", pack=False, align=None),
    "CMC_TAGGED_CONTENT_INFO": SimStruct(OrderedDict((("dwBodyPartID", SimTypeInt(signed=False, label="UInt32")), ("EncodedContentInfo", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CMC_TAGGED_CONTENT_INFO", pack=False, align=None),
    "CMC_TAGGED_OTHER_MSG": SimStruct(OrderedDict((("dwBodyPartID", SimTypeInt(signed=False, label="UInt32")), ("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Value", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CMC_TAGGED_OTHER_MSG", pack=False, align=None),
    "CMC_TAGGED_REQUEST": SimStruct(OrderedDict((("dwTaggedRequestChoice", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"pTaggedCertRequest": SimTypePointer(SimTypeRef("CMC_TAGGED_CERT_REQUEST", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="CMC_TAGGED_REQUEST", pack=False, align=None),
    "CMD_ENTRY": SimStruct(OrderedDict((("pwszCmdToken", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pfnCmdHandler", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszMachine", "ppwcArguments", "dwCurrentIndex", "dwArgCount", "dwFlags", "pvData", "pbDone"]), offset=0)), ("dwShortCmdHelpToken", SimTypeInt(signed=False, label="UInt32")), ("dwCmdHlpToken", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("pOsVersionCheck", SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["CIMOSType", "CIMOSProductSuite", "CIMOSVersion", "CIMOSBuildNumber", "CIMServicePackMajorVersion", "CIMServicePackMinorVersion", "uiReserved", "dwReserved"]), offset=0)), ("pfnCustomHelpFn", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hModule", "pwszCmdToken"]), offset=0)),)), name="CMD_ENTRY", pack=False, align=None),
    "CMD_GROUP_ENTRY": SimStruct(OrderedDict((("pwszCmdGroupToken", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwShortCmdHelpToken", SimTypeInt(signed=False, label="UInt32")), ("ulCmdGroupSize", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("pCmdGroup", SimTypePointer(SimTypeRef("CMD_ENTRY", SimStruct), offset=0)), ("pOsVersionCheck", SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["CIMOSType", "CIMOSProductSuite", "CIMOSVersion", "CIMOSBuildNumber", "CIMServicePackMajorVersion", "CIMServicePackMinorVersion", "uiReserved", "dwReserved"]), offset=0)),)), name="CMD_GROUP_ENTRY", pack=False, align=None),
    "CMINVOKECOMMANDINFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("fMask", SimTypeInt(signed=False, label="UInt32")), ("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpVerb", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpParameters", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpDirectory", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("nShow", SimTypeInt(signed=True, label="Int32")), ("dwHotKey", SimTypeInt(signed=False, label="UInt32")), ("hIcon", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CMINVOKECOMMANDINFO", pack=False, align=None),
    "CMINVOKECOMMANDINFOEX": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("fMask", SimTypeInt(signed=False, label="UInt32")), ("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpVerb", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpParameters", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpDirectory", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("nShow", SimTypeInt(signed=True, label="Int32")), ("dwHotKey", SimTypeInt(signed=False, label="UInt32")), ("hIcon", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpTitle", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpVerbW", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpParametersW", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpDirectoryW", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpTitleW", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ptInvoke", SimTypeRef("POINT", SimStruct)),)), name="CMINVOKECOMMANDINFOEX", pack=False, align=None),
    "CMINVOKECOMMANDINFOEX_REMOTE": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("fMask", SimTypeInt(signed=False, label="UInt32")), ("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpVerbString", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpParameters", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpDirectory", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("nShow", SimTypeInt(signed=True, label="Int32")), ("dwHotKey", SimTypeInt(signed=False, label="UInt32")), ("lpTitle", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpVerbWString", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpParametersW", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpDirectoryW", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpTitleW", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ptInvoke", SimTypeRef("POINT", SimStruct)), ("lpVerbInt", SimTypeInt(signed=False, label="UInt32")), ("lpVerbWInt", SimTypeInt(signed=False, label="UInt32")),)), name="CMINVOKECOMMANDINFOEX_REMOTE", pack=False, align=None),
    "CMSGHDR": SimStruct(OrderedDict((("cmsg_len", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("cmsg_level", SimTypeInt(signed=True, label="Int32")), ("cmsg_type", SimTypeInt(signed=True, label="Int32")),)), name="CMSGHDR", pack=False, align=None),
    "CMSG_CMS_RECIPIENT_INFO": SimStruct(OrderedDict((("dwRecipientChoice", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"pKeyTrans": SimTypePointer(SimTypeRef("CMSG_KEY_TRANS_RECIPIENT_INFO", SimStruct), offset=0), "pKeyAgree": SimTypePointer(SimTypeRef("CMSG_KEY_AGREE_RECIPIENT_INFO", SimStruct), offset=0), "pMailList": SimTypePointer(SimTypeRef("CMSG_MAIL_LIST_RECIPIENT_INFO", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="CMSG_CMS_RECIPIENT_INFO", pack=False, align=None),
    "CMSG_CMS_SIGNER_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("SignerId", SimTypeRef("CERT_ID", SimStruct)), ("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("HashEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("EncryptedHash", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("AuthAttrs", SimTypeRef("CRYPT_ATTRIBUTES", SimStruct)), ("UnauthAttrs", SimTypeRef("CRYPT_ATTRIBUTES", SimStruct)),)), name="CMSG_CMS_SIGNER_INFO", pack=False, align=None),
    "CMSG_CNG_CONTENT_DECRYPT_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("ContentEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pfnAlloc", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cb"]), offset=0)), ("pfnFree", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0)), ("hNCryptKey", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("pbContentEncryptKey", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbContentEncryptKey", SimTypeInt(signed=False, label="UInt32")), ("hCNGContentEncryptKey", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pbCNGContentEncryptKeyObject", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CMSG_CNG_CONTENT_DECRYPT_INFO", pack=False, align=None),
    "CMSG_CONTENT_ENCRYPT_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ContentEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvEncryptionAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cRecipients", SimTypeInt(signed=False, label="UInt32")), ("rgCmsRecipients", SimTypePointer(SimTypeRef("CMSG_RECIPIENT_ENCODE_INFO", SimStruct), offset=0)), ("pfnAlloc", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cb"]), offset=0)), ("pfnFree", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0)), ("dwEncryptFlags", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"hContentEncryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hCNGContentEncryptKey": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("fCNG", SimTypeInt(signed=True, label="Int32")), ("pbCNGContentEncryptKeyObject", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pbContentEncryptKey", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbContentEncryptKey", SimTypeInt(signed=False, label="UInt32")),)), name="CMSG_CONTENT_ENCRYPT_INFO", pack=False, align=None),
    "CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwSignerIndex", SimTypeInt(signed=False, label="UInt32")), ("blob", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA", pack=False, align=None),
    "CMSG_CTRL_DECRYPT_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hNCryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None")), ("dwKeySpec", SimTypeInt(signed=False, label="UInt32")), ("dwRecipientIndex", SimTypeInt(signed=False, label="UInt32")),)), name="CMSG_CTRL_DECRYPT_PARA", pack=False, align=None),
    "CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwSignerIndex", SimTypeInt(signed=False, label="UInt32")), ("dwUnauthAttrIndex", SimTypeInt(signed=False, label="UInt32")),)), name="CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA", pack=False, align=None),
    "CMSG_CTRL_KEY_AGREE_DECRYPT_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hNCryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None")), ("dwKeySpec", SimTypeInt(signed=False, label="UInt32")), ("pKeyAgree", SimTypePointer(SimTypeRef("CMSG_KEY_AGREE_RECIPIENT_INFO", SimStruct), offset=0)), ("dwRecipientIndex", SimTypeInt(signed=False, label="UInt32")), ("dwRecipientEncryptedKeyIndex", SimTypeInt(signed=False, label="UInt32")), ("OriginatorPublicKey", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)),)), name="CMSG_CTRL_KEY_AGREE_DECRYPT_PARA", pack=False, align=None),
    "CMSG_CTRL_KEY_TRANS_DECRYPT_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hNCryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None")), ("dwKeySpec", SimTypeInt(signed=False, label="UInt32")), ("pKeyTrans", SimTypePointer(SimTypeRef("CMSG_KEY_TRANS_RECIPIENT_INFO", SimStruct), offset=0)), ("dwRecipientIndex", SimTypeInt(signed=False, label="UInt32")),)), name="CMSG_CTRL_KEY_TRANS_DECRYPT_PARA", pack=False, align=None),
    "CMSG_CTRL_MAIL_LIST_DECRYPT_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("pMailList", SimTypePointer(SimTypeRef("CMSG_MAIL_LIST_RECIPIENT_INFO", SimStruct), offset=0)), ("dwRecipientIndex", SimTypeInt(signed=False, label="UInt32")), ("dwKeyChoice", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"hKeyEncryptionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pvKeyEncryptionKey": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None")),)), name="CMSG_CTRL_MAIL_LIST_DECRYPT_PARA", pack=False, align=None),
    "CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("dwSignerIndex", SimTypeInt(signed=False, label="UInt32")), ("dwSignerType", SimTypeInt(signed=False, label="UInt32")), ("pvSigner", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA", pack=False, align=None),
    "CMSG_ENCRYPTED_ENCODE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("ContentEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvEncryptionAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CMSG_ENCRYPTED_ENCODE_INFO", pack=False, align=None),
    "CMSG_ENVELOPED_ENCODE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ContentEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvEncryptionAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cRecipients", SimTypeInt(signed=False, label="UInt32")), ("rgpRecipients", SimTypePointer(SimTypePointer(SimTypeRef("CERT_INFO", SimStruct), offset=0), offset=0)),)), name="CMSG_ENVELOPED_ENCODE_INFO", pack=False, align=None),
    "CMSG_HASHED_ENCODE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvHashAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CMSG_HASHED_ENCODE_INFO", pack=False, align=None),
    "CMSG_KEY_AGREE_ENCRYPT_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwRecipientIndex", SimTypeInt(signed=False, label="UInt32")), ("KeyEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("UserKeyingMaterial", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("dwOriginatorChoice", SimTypeInt(signed=False, label="CMSG_KEY_AGREE_ORIGINATOR")), ("Anonymous", SimUnion({"OriginatorCertId": SimTypeRef("CERT_ID", SimStruct), "OriginatorPublicKeyInfo": SimTypeRef("CERT_PUBLIC_KEY_INFO", SimStruct)}, name="<anon>", label="None")), ("cKeyAgreeKeyEncryptInfo", SimTypeInt(signed=False, label="UInt32")), ("rgpKeyAgreeKeyEncryptInfo", SimTypePointer(SimTypePointer(SimTypeRef("CMSG_KEY_AGREE_KEY_ENCRYPT_INFO", SimStruct), offset=0), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CMSG_KEY_AGREE_ENCRYPT_INFO", pack=False, align=None),
    "CMSG_KEY_AGREE_KEY_ENCRYPT_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("EncryptedKey", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CMSG_KEY_AGREE_KEY_ENCRYPT_INFO", pack=False, align=None),
    "CMSG_KEY_AGREE_OPTION": SimTypeInt(signed=False, label="CMSG_KEY_AGREE_OPTION"),
    "CMSG_KEY_AGREE_ORIGINATOR": SimTypeInt(signed=False, label="CMSG_KEY_AGREE_ORIGINATOR"),
    "CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("KeyEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvKeyEncryptionAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("KeyWrapAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvKeyWrapAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("dwKeySpec", SimTypeInt(signed=False, label="UInt32")), ("dwKeyChoice", SimTypeInt(signed=False, label="CMSG_KEY_AGREE_OPTION")), ("Anonymous", SimUnion({"pEphemeralAlgorithm": SimTypePointer(SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct), offset=0), "pSenderId": SimTypePointer(SimTypeRef("CERT_ID", SimStruct), offset=0)}, name="<anon>", label="None")), ("UserKeyingMaterial", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("cRecipientEncryptedKeys", SimTypeInt(signed=False, label="UInt32")), ("rgpRecipientEncryptedKeys", SimTypePointer(SimTypePointer(SimTypeRef("CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO", SimStruct), offset=0), offset=0)),)), name="CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO", pack=False, align=None),
    "CMSG_KEY_AGREE_RECIPIENT_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("dwOriginatorChoice", SimTypeInt(signed=False, label="CMSG_KEY_AGREE_ORIGINATOR")), ("Anonymous", SimUnion({"OriginatorCertId": SimTypeRef("CERT_ID", SimStruct), "OriginatorPublicKeyInfo": SimTypeRef("CERT_PUBLIC_KEY_INFO", SimStruct)}, name="<anon>", label="None")), ("UserKeyingMaterial", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("KeyEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("cRecipientEncryptedKeys", SimTypeInt(signed=False, label="UInt32")), ("rgpRecipientEncryptedKeys", SimTypePointer(SimTypePointer(SimTypeRef("CMSG_RECIPIENT_ENCRYPTED_KEY_INFO", SimStruct), offset=0), offset=0)),)), name="CMSG_KEY_AGREE_RECIPIENT_INFO", pack=False, align=None),
    "CMSG_KEY_TRANS_ENCRYPT_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwRecipientIndex", SimTypeInt(signed=False, label="UInt32")), ("KeyEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("EncryptedKey", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CMSG_KEY_TRANS_ENCRYPT_INFO", pack=False, align=None),
    "CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("KeyEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvKeyEncryptionAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("RecipientPublicKey", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)), ("RecipientId", SimTypeRef("CERT_ID", SimStruct)),)), name="CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO", pack=False, align=None),
    "CMSG_KEY_TRANS_RECIPIENT_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("RecipientId", SimTypeRef("CERT_ID", SimStruct)), ("KeyEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("EncryptedKey", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CMSG_KEY_TRANS_RECIPIENT_INFO", pack=False, align=None),
    "CMSG_MAIL_LIST_ENCRYPT_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwRecipientIndex", SimTypeInt(signed=False, label="UInt32")), ("KeyEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("EncryptedKey", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CMSG_MAIL_LIST_ENCRYPT_INFO", pack=False, align=None),
    "CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("KeyEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvKeyEncryptionAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("dwKeyChoice", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"hKeyEncryptionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pvKeyEncryptionKey": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None")), ("KeyId", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("Date", SimTypeRef("FILETIME", SimStruct)), ("pOtherAttr", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE_TYPE_VALUE", SimStruct), offset=0)),)), name="CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO", pack=False, align=None),
    "CMSG_MAIL_LIST_RECIPIENT_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("KeyId", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("KeyEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("EncryptedKey", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("Date", SimTypeRef("FILETIME", SimStruct)), ("pOtherAttr", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE_TYPE_VALUE", SimStruct), offset=0)),)), name="CMSG_MAIL_LIST_RECIPIENT_INFO", pack=False, align=None),
    "CMSG_RC2_AUX_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwBitLen", SimTypeInt(signed=False, label="UInt32")),)), name="CMSG_RC2_AUX_INFO", pack=False, align=None),
    "CMSG_RC4_AUX_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwBitLen", SimTypeInt(signed=False, label="UInt32")),)), name="CMSG_RC4_AUX_INFO", pack=False, align=None),
    "CMSG_RECIPIENT_ENCODE_INFO": SimStruct(OrderedDict((("dwRecipientChoice", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"pKeyTrans": SimTypePointer(SimTypeRef("CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO", SimStruct), offset=0), "pKeyAgree": SimTypePointer(SimTypeRef("CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO", SimStruct), offset=0), "pMailList": SimTypePointer(SimTypeRef("CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="CMSG_RECIPIENT_ENCODE_INFO", pack=False, align=None),
    "CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("RecipientPublicKey", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)), ("RecipientId", SimTypeRef("CERT_ID", SimStruct)), ("Date", SimTypeRef("FILETIME", SimStruct)), ("pOtherAttr", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE_TYPE_VALUE", SimStruct), offset=0)),)), name="CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO", pack=False, align=None),
    "CMSG_RECIPIENT_ENCRYPTED_KEY_INFO": SimStruct(OrderedDict((("RecipientId", SimTypeRef("CERT_ID", SimStruct)), ("EncryptedKey", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("Date", SimTypeRef("FILETIME", SimStruct)), ("pOtherAttr", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE_TYPE_VALUE", SimStruct), offset=0)),)), name="CMSG_RECIPIENT_ENCRYPTED_KEY_INFO", pack=False, align=None),
    "CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("SignedInfo", SimTypeRef("CMSG_SIGNED_ENCODE_INFO", SimStruct)), ("EnvelopedInfo", SimTypeRef("CMSG_ENVELOPED_ENCODE_INFO", SimStruct)),)), name="CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO", pack=False, align=None),
    "CMSG_SIGNED_ENCODE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("cSigners", SimTypeInt(signed=False, label="UInt32")), ("rgSigners", SimTypePointer(SimTypeRef("CMSG_SIGNER_ENCODE_INFO", SimStruct), offset=0)), ("cCertEncoded", SimTypeInt(signed=False, label="UInt32")), ("rgCertEncoded", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)), ("cCrlEncoded", SimTypeInt(signed=False, label="UInt32")), ("rgCrlEncoded", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)),)), name="CMSG_SIGNED_ENCODE_INFO", pack=False, align=None),
    "CMSG_SIGNER_ENCODE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pCertInfo", SimTypePointer(SimTypeRef("CERT_INFO", SimStruct), offset=0)), ("Anonymous", SimUnion({"hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hNCryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None")), ("dwKeySpec", SimTypeInt(signed=False, label="UInt32")), ("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvHashAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cAuthAttr", SimTypeInt(signed=False, label="UInt32")), ("rgAuthAttr", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE", SimStruct), offset=0)), ("cUnauthAttr", SimTypeInt(signed=False, label="UInt32")), ("rgUnauthAttr", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE", SimStruct), offset=0)),)), name="CMSG_SIGNER_ENCODE_INFO", pack=False, align=None),
    "CMSG_SIGNER_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("Issuer", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("SerialNumber", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("HashEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("EncryptedHash", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("AuthAttrs", SimTypeRef("CRYPT_ATTRIBUTES", SimStruct)), ("UnauthAttrs", SimTypeRef("CRYPT_ATTRIBUTES", SimStruct)),)), name="CMSG_SIGNER_INFO", pack=False, align=None),
    "CMSG_SP3_COMPATIBLE_AUX_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CMSG_SP3_COMPATIBLE_AUX_INFO", pack=False, align=None),
    "CMSG_STREAM_INFO": SimStruct(OrderedDict((("cbContent", SimTypeInt(signed=False, label="UInt32")), ("pfnStreamOutput", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvArg", "pbData", "cbData", "fFinal"]), offset=0)), ("pvArg", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CMSG_STREAM_INFO", pack=False, align=None),
    "CMS_DH_KEY_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("Algid", SimTypeInt(signed=False, label="ALG_ID")), ("pszContentEncObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("PubInfo", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("pReserved", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CMS_DH_KEY_INFO", pack=False, align=None),
    "CMS_KEY_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("Algid", SimTypeInt(signed=False, label="ALG_ID")), ("pbOID", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbOID", SimTypeInt(signed=False, label="UInt32")),)), name="CMS_KEY_INFO", pack=False, align=None),
    "CMYKCOLOR": SimStruct(OrderedDict((("cyan", SimTypeShort(signed=False, label="UInt16")), ("magenta", SimTypeShort(signed=False, label="UInt16")), ("yellow", SimTypeShort(signed=False, label="UInt16")), ("black", SimTypeShort(signed=False, label="UInt16")),)), name="CMYKCOLOR", pack=False, align=None),
    "CM_ACTIVATE_VC_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CM_ADD_PARTY_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CM_CDFLAGS": SimTypeInt(signed=False, label="CM_CDFLAGS"),
    "CM_CDMASK": SimTypeInt(signed=False, label="CM_CDMASK"),
    "CM_CLOSE_AF_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CM_CLOSE_CALL_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CM_COLUMNINFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMask", SimTypeInt(signed=False, label="UInt32")), ("dwState", SimTypeInt(signed=False, label="UInt32")), ("uWidth", SimTypeInt(signed=False, label="UInt32")), ("uDefaultWidth", SimTypeInt(signed=False, label="UInt32")), ("uIdealWidth", SimTypeInt(signed=False, label="UInt32")), ("wszName", SimTypeArray(SimTypeChar(label="Char"), 80)),)), name="CM_COLUMNINFO", pack=False, align=None),
    "CM_COMPONENT_INFORMATION": SimStruct(OrderedDict((("Flags", SimTypeRef("DEVICE_FLAGS", SimStruct)), ("Version", SimTypeInt(signed=False, label="UInt32")), ("Key", SimTypeInt(signed=False, label="UInt32")), ("AffinityMask", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="CM_COMPONENT_INFORMATION", pack=False, align=None),
    "CM_DEACTIVATE_VC_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CM_DEREG_SAP_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CM_DEVCAP": SimTypeInt(signed=False, label="CM_DEVCAP"),
    "CM_DEVNODE_STATUS_FLAGS": SimTypeInt(signed=False, label="CM_DEVNODE_STATUS_FLAGS"),
    "CM_DISK_GEOMETRY_DEVICE_DATA": SimStruct(OrderedDict((("BytesPerSector", SimTypeInt(signed=False, label="UInt32")), ("NumberOfCylinders", SimTypeInt(signed=False, label="UInt32")), ("SectorsPerTrack", SimTypeInt(signed=False, label="UInt32")), ("NumberOfHeads", SimTypeInt(signed=False, label="UInt32")),)), name="CM_DISK_GEOMETRY_DEVICE_DATA", pack=False, align=None),
    "CM_DROP_PARTY_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CM_EISA_FUNCTION_INFORMATION": SimStruct(OrderedDict((("CompressedId", SimTypeInt(signed=False, label="UInt32")), ("IdSlotFlags1", SimTypeChar(label="Byte")), ("IdSlotFlags2", SimTypeChar(label="Byte")), ("MinorRevision", SimTypeChar(label="Byte")), ("MajorRevision", SimTypeChar(label="Byte")), ("Selections", SimTypeArray(SimTypeChar(label="Byte"), 26)), ("FunctionFlags", SimTypeChar(label="Byte")), ("TypeString", SimTypeArray(SimTypeChar(label="Byte"), 80)), ("EisaMemory", SimTypeArray(SimTypeRef("EISA_MEMORY_CONFIGURATION", SimStruct), 9)), ("EisaIrq", SimTypeArray(SimTypeRef("EISA_IRQ_CONFIGURATION", SimStruct), 7)), ("EisaDma", SimTypeArray(SimTypeRef("EISA_DMA_CONFIGURATION", SimStruct), 4)), ("EisaPort", SimTypeArray(SimTypeRef("EISA_PORT_CONFIGURATION", SimStruct), 20)), ("InitializationData", SimTypeArray(SimTypeChar(label="Byte"), 60)),)), name="CM_EISA_FUNCTION_INFORMATION", pack=False, align=None),
    "CM_EISA_SLOT_INFORMATION": SimStruct(OrderedDict((("ReturnCode", SimTypeChar(label="Byte")), ("ReturnFlags", SimTypeChar(label="Byte")), ("MajorRevision", SimTypeChar(label="Byte")), ("MinorRevision", SimTypeChar(label="Byte")), ("Checksum", SimTypeShort(signed=False, label="UInt16")), ("NumberFunctions", SimTypeChar(label="Byte")), ("FunctionInformation", SimTypeChar(label="Byte")), ("CompressedId", SimTypeInt(signed=False, label="UInt32")),)), name="CM_EISA_SLOT_INFORMATION", pack=False, align=None),
    "CM_ENUMERATE_FLAGS": SimTypeInt(signed=False, label="CM_ENUMERATE_FLAGS"),
    "CM_ENUM_FLAGS": SimTypeInt(signed=False, label="CM_ENUM_FLAGS"),
    "CM_FLOPPY_DEVICE_DATA": SimStruct(OrderedDict((("Version", SimTypeShort(signed=False, label="UInt16")), ("Revision", SimTypeShort(signed=False, label="UInt16")), ("Size", SimTypeArray(SimTypeChar(label="SByte"), 8)), ("MaxDensity", SimTypeInt(signed=False, label="UInt32")), ("MountDensity", SimTypeInt(signed=False, label="UInt32")), ("StepRateHeadUnloadTime", SimTypeChar(label="Byte")), ("HeadLoadTime", SimTypeChar(label="Byte")), ("MotorOffTime", SimTypeChar(label="Byte")), ("SectorLengthCode", SimTypeChar(label="Byte")), ("SectorPerTrack", SimTypeChar(label="Byte")), ("ReadWriteGapLength", SimTypeChar(label="Byte")), ("DataTransferLength", SimTypeChar(label="Byte")), ("FormatGapLength", SimTypeChar(label="Byte")), ("FormatFillCharacter", SimTypeChar(label="Byte")), ("HeadSettleTime", SimTypeChar(label="Byte")), ("MotorSettleTime", SimTypeChar(label="Byte")), ("MaximumTrackValue", SimTypeChar(label="Byte")), ("DataTransferRate", SimTypeChar(label="Byte")),)), name="CM_FLOPPY_DEVICE_DATA", pack=False, align=None),
    "CM_FULL_RESOURCE_DESCRIPTOR": SimStruct(OrderedDict((("InterfaceType", SimTypeInt(signed=False, label="INTERFACE_TYPE")), ("BusNumber", SimTypeInt(signed=False, label="UInt32")), ("PartialResourceList", SimTypeRef("CM_PARTIAL_RESOURCE_LIST", SimStruct)),)), name="CM_FULL_RESOURCE_DESCRIPTOR", pack=False, align=None),
    "CM_GET_DEVICE_INTERFACE_LIST_FLAGS": SimTypeInt(signed=False, label="CM_GET_DEVICE_INTERFACE_LIST_FLAGS"),
    "CM_INCOMING_CALL_COMPLETE_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CM_INSTALL_STATE": SimTypeInt(signed=False, label="CM_INSTALL_STATE"),
    "CM_INT13_DRIVE_PARAMETER": SimStruct(OrderedDict((("DriveSelect", SimTypeShort(signed=False, label="UInt16")), ("MaxCylinders", SimTypeInt(signed=False, label="UInt32")), ("SectorsPerTrack", SimTypeShort(signed=False, label="UInt16")), ("MaxHeads", SimTypeShort(signed=False, label="UInt16")), ("NumberDrives", SimTypeShort(signed=False, label="UInt16")),)), name="CM_INT13_DRIVE_PARAMETER", pack=False, align=None),
    "CM_KEYBOARD_DEVICE_DATA": SimStruct(OrderedDict((("Version", SimTypeShort(signed=False, label="UInt16")), ("Revision", SimTypeShort(signed=False, label="UInt16")), ("Type", SimTypeChar(label="Byte")), ("Subtype", SimTypeChar(label="Byte")), ("KeyboardFlags", SimTypeShort(signed=False, label="UInt16")),)), name="CM_KEYBOARD_DEVICE_DATA", pack=False, align=None),
    "CM_LOCATE_DEVNODE_FLAGS": SimTypeInt(signed=False, label="CM_LOCATE_DEVNODE_FLAGS"),
    "CM_LOG_CONF": SimTypeInt(signed=False, label="CM_LOG_CONF"),
    "CM_MAKE_CALL_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CM_MASK": SimTypeInt(signed=False, label="CM_MASK"),
    "CM_MCA_POS_DATA": SimStruct(OrderedDict((("AdapterId", SimTypeShort(signed=False, label="UInt16")), ("PosData1", SimTypeChar(label="Byte")), ("PosData2", SimTypeChar(label="Byte")), ("PosData3", SimTypeChar(label="Byte")), ("PosData4", SimTypeChar(label="Byte")),)), name="CM_MCA_POS_DATA", pack=False, align=None),
    "CM_MODIFY_CALL_QOS_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CM_MONITOR_DEVICE_DATA": SimStruct(OrderedDict((("Version", SimTypeShort(signed=False, label="UInt16")), ("Revision", SimTypeShort(signed=False, label="UInt16")), ("HorizontalScreenSize", SimTypeShort(signed=False, label="UInt16")), ("VerticalScreenSize", SimTypeShort(signed=False, label="UInt16")), ("HorizontalResolution", SimTypeShort(signed=False, label="UInt16")), ("VerticalResolution", SimTypeShort(signed=False, label="UInt16")), ("HorizontalDisplayTimeLow", SimTypeShort(signed=False, label="UInt16")), ("HorizontalDisplayTime", SimTypeShort(signed=False, label="UInt16")), ("HorizontalDisplayTimeHigh", SimTypeShort(signed=False, label="UInt16")), ("HorizontalBackPorchLow", SimTypeShort(signed=False, label="UInt16")), ("HorizontalBackPorch", SimTypeShort(signed=False, label="UInt16")), ("HorizontalBackPorchHigh", SimTypeShort(signed=False, label="UInt16")), ("HorizontalFrontPorchLow", SimTypeShort(signed=False, label="UInt16")), ("HorizontalFrontPorch", SimTypeShort(signed=False, label="UInt16")), ("HorizontalFrontPorchHigh", SimTypeShort(signed=False, label="UInt16")), ("HorizontalSyncLow", SimTypeShort(signed=False, label="UInt16")), ("HorizontalSync", SimTypeShort(signed=False, label="UInt16")), ("HorizontalSyncHigh", SimTypeShort(signed=False, label="UInt16")), ("VerticalBackPorchLow", SimTypeShort(signed=False, label="UInt16")), ("VerticalBackPorch", SimTypeShort(signed=False, label="UInt16")), ("VerticalBackPorchHigh", SimTypeShort(signed=False, label="UInt16")), ("VerticalFrontPorchLow", SimTypeShort(signed=False, label="UInt16")), ("VerticalFrontPorch", SimTypeShort(signed=False, label="UInt16")), ("VerticalFrontPorchHigh", SimTypeShort(signed=False, label="UInt16")), ("VerticalSyncLow", SimTypeShort(signed=False, label="UInt16")), ("VerticalSync", SimTypeShort(signed=False, label="UInt16")), ("VerticalSyncHigh", SimTypeShort(signed=False, label="UInt16")),)), name="CM_MONITOR_DEVICE_DATA", pack=False, align=None),
    "CM_NOTIFY_ACTION": SimTypeInt(signed=False, label="CM_NOTIFY_ACTION"),
    "CM_NOTIFY_EVENT_DATA": SimStruct(OrderedDict((("FilterType", SimTypeInt(signed=False, label="CM_NOTIFY_FILTER_TYPE")), ("Reserved", SimTypeInt(signed=False, label="UInt32")), ("u", SimUnion({"DeviceInterface": SimTypeRef("_DeviceInterface_e__Struct", SimStruct), "DeviceHandle": SimTypeRef("_DeviceHandle_e__Struct", SimStruct), "DeviceInstance": SimTypeRef("_DeviceInstance_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="CM_NOTIFY_EVENT_DATA", pack=False, align=None),
    "CM_NOTIFY_FILTER": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("FilterType", SimTypeInt(signed=False, label="CM_NOTIFY_FILTER_TYPE")), ("Reserved", SimTypeInt(signed=False, label="UInt32")), ("u", SimUnion({"DeviceInterface": SimTypeRef("_DeviceInterface_e__Struct", SimStruct), "DeviceHandle": SimTypeRef("_DeviceHandle_e__Struct", SimStruct), "DeviceInstance": SimTypeRef("_DeviceInstance_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="CM_NOTIFY_FILTER", pack=False, align=None),
    "CM_NOTIFY_FILTER_TYPE": SimTypeInt(signed=False, label="CM_NOTIFY_FILTER_TYPE"),
    "CM_OPEN_AF_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CM_PARTIAL_RESOURCE_DESCRIPTOR": SimStruct(OrderedDict((("Type", SimTypeChar(label="Byte")), ("ShareDisposition", SimTypeChar(label="Byte")), ("Flags", SimTypeShort(signed=False, label="UInt16")), ("u", SimUnion({"Generic": SimTypeRef("_Generic_e__Struct", SimStruct), "Port": SimTypeRef("_Port_e__Struct", SimStruct), "Interrupt": SimTypeRef("_Interrupt_e__Struct", SimStruct), "MessageInterrupt": SimTypeRef("_MessageInterrupt_e__Struct", SimStruct), "Memory": SimTypeRef("_Memory_e__Struct", SimStruct), "Dma": SimTypeRef("_Dma_e__Struct", SimStruct), "DmaV3": SimTypeRef("_DmaV3_e__Struct", SimStruct), "DevicePrivate": SimTypeRef("_DevicePrivate_e__Struct", SimStruct), "BusNumber": SimTypeRef("_BusNumber_e__Struct", SimStruct), "DeviceSpecificData": SimTypeRef("_DeviceSpecificData_e__Struct", SimStruct), "Memory40": SimTypeRef("_Memory40_e__Struct", SimStruct), "Memory48": SimTypeRef("_Memory48_e__Struct", SimStruct), "Memory64": SimTypeRef("_Memory64_e__Struct", SimStruct), "Connection": SimTypeRef("_Connection_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="CM_PARTIAL_RESOURCE_DESCRIPTOR", pack=False, align=None),
    "CM_PARTIAL_RESOURCE_LIST": SimStruct(OrderedDict((("Version", SimTypeShort(signed=False, label="UInt16")), ("Revision", SimTypeShort(signed=False, label="UInt16")), ("Count", SimTypeInt(signed=False, label="UInt32")), ("PartialDescriptors", SimTypePointer(SimTypeRef("CM_PARTIAL_RESOURCE_DESCRIPTOR", SimStruct), offset=0)),)), name="CM_PARTIAL_RESOURCE_LIST", pack=False, align=None),
    "CM_PCCARD_DEVICE_DATA": SimStruct(OrderedDict((("Flags", SimTypeChar(label="Byte")), ("ErrorCode", SimTypeChar(label="Byte")), ("Reserved", SimTypeShort(signed=False, label="UInt16")), ("BusData", SimTypeInt(signed=False, label="UInt32")), ("DeviceId", SimTypeInt(signed=False, label="UInt32")), ("LegacyBaseAddress", SimTypeInt(signed=False, label="UInt32")), ("IRQMap", SimTypeArray(SimTypeChar(label="Byte"), 16)),)), name="CM_PCCARD_DEVICE_DATA", pack=False, align=None),
    "CM_PNP_BIOS_DEVICE_NODE": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Node", SimTypeChar(label="Byte")), ("ProductId", SimTypeInt(signed=False, label="UInt32")), ("DeviceType", SimTypeArray(SimTypeChar(label="Byte"), 3)), ("DeviceAttributes", SimTypeShort(signed=False, label="UInt16")),)), name="CM_PNP_BIOS_DEVICE_NODE", pack=False, align=None),
    "CM_PNP_BIOS_INSTALLATION_CHECK": SimStruct(OrderedDict((("Signature", SimTypeArray(SimTypeChar(label="Byte"), 4)), ("Revision", SimTypeChar(label="Byte")), ("Length", SimTypeChar(label="Byte")), ("ControlField", SimTypeShort(signed=False, label="UInt16")), ("Checksum", SimTypeChar(label="Byte")), ("EventFlagAddress", SimTypeInt(signed=False, label="UInt32")), ("RealModeEntryOffset", SimTypeShort(signed=False, label="UInt16")), ("RealModeEntrySegment", SimTypeShort(signed=False, label="UInt16")), ("ProtectedModeEntryOffset", SimTypeShort(signed=False, label="UInt16")), ("ProtectedModeCodeBaseAddress", SimTypeInt(signed=False, label="UInt32")), ("OemDeviceId", SimTypeInt(signed=False, label="UInt32")), ("RealModeDataBaseAddress", SimTypeShort(signed=False, label="UInt16")), ("ProtectedModeDataBaseAddress", SimTypeInt(signed=False, label="UInt32")),)), name="CM_PNP_BIOS_INSTALLATION_CHECK", pack=False, align=None),
    "CM_POWER_DATA": SimStruct(OrderedDict((("PD_Size", SimTypeInt(signed=False, label="UInt32")), ("PD_MostRecentPowerState", SimTypeInt(signed=False, label="DEVICE_POWER_STATE")), ("PD_Capabilities", SimTypeInt(signed=False, label="UInt32")), ("PD_D1Latency", SimTypeInt(signed=False, label="UInt32")), ("PD_D2Latency", SimTypeInt(signed=False, label="UInt32")), ("PD_D3Latency", SimTypeInt(signed=False, label="UInt32")), ("PD_PowerStateMapping", SimTypeArray(SimTypeInt(signed=False, label="DEVICE_POWER_STATE"), 7)), ("PD_DeepestSystemWake", SimTypeInt(signed=False, label="SYSTEM_POWER_STATE")),)), name="CM_POWER_DATA", pack=False, align=None),
    "CM_PROB": SimTypeInt(signed=False, label="CM_PROB"),
    "CM_REENUMERATE_FLAGS": SimTypeInt(signed=False, label="CM_REENUMERATE_FLAGS"),
    "CM_REG_SAP_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CM_REMOVAL_POLICY": SimTypeInt(signed=False, label="CM_REMOVAL_POLICY"),
    "CM_RESOURCE_LIST": SimStruct(OrderedDict((("Count", SimTypeInt(signed=False, label="UInt32")), ("List", SimTypePointer(SimTypeRef("CM_FULL_RESOURCE_DESCRIPTOR", SimStruct), offset=0)),)), name="CM_RESOURCE_LIST", pack=False, align=None),
    "CM_RESTYPE": SimTypeInt(signed=False, label="CM_RESTYPE"),
    "CM_ROM_BLOCK": SimStruct(OrderedDict((("Address", SimTypeInt(signed=False, label="UInt32")), ("Size", SimTypeInt(signed=False, label="UInt32")),)), name="CM_ROM_BLOCK", pack=False, align=None),
    "CM_SCSI_DEVICE_DATA": SimStruct(OrderedDict((("Version", SimTypeShort(signed=False, label="UInt16")), ("Revision", SimTypeShort(signed=False, label="UInt16")), ("HostIdentifier", SimTypeChar(label="Byte")),)), name="CM_SCSI_DEVICE_DATA", pack=False, align=None),
    "CM_SERIAL_DEVICE_DATA": SimStruct(OrderedDict((("Version", SimTypeShort(signed=False, label="UInt16")), ("Revision", SimTypeShort(signed=False, label="UInt16")), ("BaudClock", SimTypeInt(signed=False, label="UInt32")),)), name="CM_SERIAL_DEVICE_DATA", pack=False, align=None),
    "CM_SET_WIDTH_VALUE": SimTypeInt(signed=False, label="CM_SET_WIDTH_VALUE"),
    "CM_SHARE_DISPOSITION": SimTypeInt(signed=False, label="CM_SHARE_DISPOSITION"),
    "CM_SONIC_DEVICE_DATA": SimStruct(OrderedDict((("Version", SimTypeShort(signed=False, label="UInt16")), ("Revision", SimTypeShort(signed=False, label="UInt16")), ("DataConfigurationRegister", SimTypeShort(signed=False, label="UInt16")), ("EthernetAddress", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="CM_SONIC_DEVICE_DATA", pack=False, align=None),
    "CM_STATE": SimTypeInt(signed=False, label="CM_STATE"),
    "CM_VIDEO_DEVICE_DATA": SimStruct(OrderedDict((("Version", SimTypeShort(signed=False, label="UInt16")), ("Revision", SimTypeShort(signed=False, label="UInt16")), ("VideoClock", SimTypeInt(signed=False, label="UInt32")),)), name="CM_VIDEO_DEVICE_DATA", pack=False, align=None),
    "COAUTHIDENTITY": SimStruct(OrderedDict((("User", SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)), ("UserLength", SimTypeInt(signed=False, label="UInt32")), ("Domain", SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)), ("DomainLength", SimTypeInt(signed=False, label="UInt32")), ("Password", SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)), ("PasswordLength", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")),)), name="COAUTHIDENTITY", pack=False, align=None),
    "COAUTHINFO": SimStruct(OrderedDict((("dwAuthnSvc", SimTypeInt(signed=False, label="UInt32")), ("dwAuthzSvc", SimTypeInt(signed=False, label="UInt32")), ("pwszServerPrincName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwAuthnLevel", SimTypeInt(signed=False, label="UInt32")), ("dwImpersonationLevel", SimTypeInt(signed=False, label="UInt32")), ("pAuthIdentityData", SimTypePointer(SimTypeRef("COAUTHIDENTITY", SimStruct), offset=0)), ("dwCapabilities", SimTypeInt(signed=False, label="UInt32")),)), name="COAUTHINFO", pack=False, align=None),
    "CODEBASEHOLD": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("szDistUnit", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("szCodeBase", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwVersionMS", SimTypeInt(signed=False, label="UInt32")), ("dwVersionLS", SimTypeInt(signed=False, label="UInt32")), ("dwStyle", SimTypeInt(signed=False, label="UInt32")),)), name="CODEBASEHOLD", pack=False, align=None),
    "CODEPAGE_ENUMPROCA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0),
    "CODEPAGE_ENUMPROCW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0),
    "COINIT": SimTypeInt(signed=False, label="COINIT"),
    "COINITBASE": SimTypeInt(signed=False, label="COINITBASE"),
    "COINSTALLER_CONTEXT_DATA": SimStruct(OrderedDict((("PostProcessing", SimTypeInt(signed=True, label="Int32")), ("InstallResult", SimTypeInt(signed=False, label="UInt32")), ("PrivateData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="COINSTALLER_CONTEXT_DATA", pack=False, align=None),
    "COLLAPSEBUTTONSTATES": SimTypeInt(signed=False, label="COLLAPSEBUTTONSTATES"),
    "COLOR": SimUnion({"gray": SimTypeRef("GRAYCOLOR", SimStruct), "rgb": SimTypeRef("RGBCOLOR", SimStruct), "cmyk": SimTypeRef("CMYKCOLOR", SimStruct), "XYZ": SimTypeRef("XYZCOLOR", SimStruct), "Yxy": SimTypeRef("YxyCOLOR", SimStruct), "Lab": SimTypeRef("LabCOLOR", SimStruct), "gen3ch": SimTypeRef("GENERIC3CHANNEL", SimStruct), "named": SimTypeRef("NAMEDCOLOR", SimStruct), "hifi": SimTypeRef("HiFiCOLOR", SimStruct), "Anonymous": SimStruct(OrderedDict((("reserved1", SimTypeInt(signed=False, label="UInt32")), ("reserved2", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"),
    "COLORADJUSTMENT": SimStruct(OrderedDict((("caSize", SimTypeShort(signed=False, label="UInt16")), ("caFlags", SimTypeShort(signed=False, label="UInt16")), ("caIlluminantIndex", SimTypeShort(signed=False, label="UInt16")), ("caRedGamma", SimTypeShort(signed=False, label="UInt16")), ("caGreenGamma", SimTypeShort(signed=False, label="UInt16")), ("caBlueGamma", SimTypeShort(signed=False, label="UInt16")), ("caReferenceBlack", SimTypeShort(signed=False, label="UInt16")), ("caReferenceWhite", SimTypeShort(signed=False, label="UInt16")), ("caContrast", SimTypeShort(signed=True, label="Int16")), ("caBrightness", SimTypeShort(signed=True, label="Int16")), ("caColorfulness", SimTypeShort(signed=True, label="Int16")), ("caRedGreenTint", SimTypeShort(signed=True, label="Int16")),)), name="COLORADJUSTMENT", pack=False, align=None),
    "COLORDATATYPE": SimTypeInt(signed=False, label="COLORDATATYPE"),
    "COLORINFO": SimStruct(OrderedDict((("Red", SimTypeRef("CIECHROMA", SimStruct)), ("Green", SimTypeRef("CIECHROMA", SimStruct)), ("Blue", SimTypeRef("CIECHROMA", SimStruct)), ("Cyan", SimTypeRef("CIECHROMA", SimStruct)), ("Magenta", SimTypeRef("CIECHROMA", SimStruct)), ("Yellow", SimTypeRef("CIECHROMA", SimStruct)), ("AlignmentWhite", SimTypeRef("CIECHROMA", SimStruct)), ("RedGamma", SimTypeInt(signed=True, label="Int32")), ("GreenGamma", SimTypeInt(signed=True, label="Int32")), ("BlueGamma", SimTypeInt(signed=True, label="Int32")), ("MagentaInCyanDye", SimTypeInt(signed=True, label="Int32")), ("YellowInCyanDye", SimTypeInt(signed=True, label="Int32")), ("CyanInMagentaDye", SimTypeInt(signed=True, label="Int32")), ("YellowInMagentaDye", SimTypeInt(signed=True, label="Int32")), ("CyanInYellowDye", SimTypeInt(signed=True, label="Int32")), ("MagentaInYellowDye", SimTypeInt(signed=True, label="Int32")),)), name="COLORINFO", pack=False, align=None),
    "COLORKEY": SimStruct(OrderedDict((("KeyType", SimTypeInt(signed=False, label="UInt32")), ("PaletteIndex", SimTypeInt(signed=False, label="UInt32")), ("LowColorValue", SimTypeInt(signed=False, label="UInt32")), ("HighColorValue", SimTypeInt(signed=False, label="UInt32")),)), name="COLORKEY", pack=False, align=None),
    "COLORKEY_TYPE": SimTypeInt(signed=False, label="COLORKEY_TYPE"),
    "COLORMAP": SimStruct(OrderedDict((("from", SimTypeInt(signed=False, label="UInt32")), ("to", SimTypeInt(signed=False, label="UInt32")),)), name="COLORMAP", pack=False, align=None),
    "COLORMATCHSETUPA": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pSourceName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pDisplayName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pPrinterName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwRenderIntent", SimTypeInt(signed=False, label="UInt32")), ("dwProofingIntent", SimTypeInt(signed=False, label="UInt32")), ("pMonitorProfile", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("ccMonitorProfile", SimTypeInt(signed=False, label="UInt32")), ("pPrinterProfile", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("ccPrinterProfile", SimTypeInt(signed=False, label="UInt32")), ("pTargetProfile", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("ccTargetProfile", SimTypeInt(signed=False, label="UInt32")), ("lpfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0)), ("lParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpfnApplyCallback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("COLORMATCHSETUPA", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0)), ("lParamApplyCallback", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="COLORMATCHSETUPA", pack=False, align=None),
    "COLORMATCHSETUPW": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pSourceName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pDisplayName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pPrinterName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwRenderIntent", SimTypeInt(signed=False, label="UInt32")), ("dwProofingIntent", SimTypeInt(signed=False, label="UInt32")), ("pMonitorProfile", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ccMonitorProfile", SimTypeInt(signed=False, label="UInt32")), ("pPrinterProfile", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ccPrinterProfile", SimTypeInt(signed=False, label="UInt32")), ("pTargetProfile", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ccTargetProfile", SimTypeInt(signed=False, label="UInt32")), ("lpfnHook", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0)), ("lParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpfnApplyCallback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("COLORMATCHSETUPW", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0)), ("lParamApplyCallback", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="COLORMATCHSETUPW", pack=False, align=None),
    "COLORPROFILESUBTYPE": SimTypeInt(signed=False, label="COLORPROFILESUBTYPE"),
    "COLORPROFILETYPE": SimTypeInt(signed=False, label="COLORPROFILETYPE"),
    "COLORREF": SimTypeInt(signed=False, label="UInt32"),
    "COLORSCHEME": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("clrBtnHighlight", SimTypeInt(signed=False, label="UInt32")), ("clrBtnShadow", SimTypeInt(signed=False, label="UInt32")),)), name="COLORSCHEME", pack=False, align=None),
    "COLORSPACE_TRANSFORM": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="COLORSPACE_TRANSFORM_TYPE")), ("Data", SimUnion({"Rgb256x3x16": SimTypeRef("GAMMA_RAMP_RGB256x3x16", SimStruct), "Dxgi1": SimTypeRef("GAMMA_RAMP_DXGI_1", SimStruct), "T3x4": SimTypeRef("COLORSPACE_TRANSFORM_3x4", SimStruct), "MatrixV2": SimTypeRef("COLORSPACE_TRANSFORM_MATRIX_V2", SimStruct)}, name="<anon>", label="None")),)), name="COLORSPACE_TRANSFORM", pack=False, align=None),
    "COLORSPACE_TRANSFORM_1DLUT_CAP": SimStruct(OrderedDict((("NumberOfLUTEntries", SimTypeInt(signed=False, label="UInt32")), ("DataCap", SimTypeRef("COLORSPACE_TRANSFORM_DATA_CAP", SimStruct)),)), name="COLORSPACE_TRANSFORM_1DLUT_CAP", pack=False, align=None),
    "COLORSPACE_TRANSFORM_3x4": SimStruct(OrderedDict((("ColorMatrix3x4", SimTypeArray(SimTypeFloat(size=32), 12)), ("ScalarMultiplier", SimTypeFloat(size=32)), ("LookupTable1D", SimTypeArray(SimTypeRef("GAMMA_RAMP_RGB", SimStruct), 4096)),)), name="COLORSPACE_TRANSFORM_3x4", pack=False, align=None),
    "COLORSPACE_TRANSFORM_DATA_CAP": SimStruct(OrderedDict((("DataType", SimTypeInt(signed=False, label="COLORSPACE_TRANSFORM_DATA_TYPE")), ("Anonymous", SimUnion({"Anonymous1": SimStruct(OrderedDict((("_bitfield", SimTypeInt(signed=False, label="UInt32")),)), name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct(OrderedDict((("_bitfield", SimTypeInt(signed=False, label="UInt32")),)), name="_Anonymous2_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("NumericRangeMin", SimTypeFloat(size=32)), ("NumericRangeMax", SimTypeFloat(size=32)),)), name="COLORSPACE_TRANSFORM_DATA_CAP", pack=False, align=None),
    "COLORSPACE_TRANSFORM_DATA_TYPE": SimTypeInt(signed=False, label="COLORSPACE_TRANSFORM_DATA_TYPE"),
    "COLORSPACE_TRANSFORM_MATRIX_CAP": SimStruct(OrderedDict((("Anonymous", SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeInt(signed=False, label="UInt32")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("DataCap", SimTypeRef("COLORSPACE_TRANSFORM_DATA_CAP", SimStruct)),)), name="COLORSPACE_TRANSFORM_MATRIX_CAP", pack=False, align=None),
    "COLORSPACE_TRANSFORM_MATRIX_V2": SimStruct(OrderedDict((("StageControlLookupTable1DDegamma", SimTypeInt(signed=False, label="COLORSPACE_TRANSFORM_STAGE_CONTROL")), ("LookupTable1DDegamma", SimTypeArray(SimTypeRef("GAMMA_RAMP_RGB", SimStruct), 4096)), ("StageControlColorMatrix3x3", SimTypeInt(signed=False, label="COLORSPACE_TRANSFORM_STAGE_CONTROL")), ("ColorMatrix3x3", SimTypeArray(SimTypeFloat(size=32), 9)), ("StageControlLookupTable1DRegamma", SimTypeInt(signed=False, label="COLORSPACE_TRANSFORM_STAGE_CONTROL")), ("LookupTable1DRegamma", SimTypeArray(SimTypeRef("GAMMA_RAMP_RGB", SimStruct), 4096)),)), name="COLORSPACE_TRANSFORM_MATRIX_V2", pack=False, align=None),
    "COLORSPACE_TRANSFORM_SET_INPUT": SimStruct(OrderedDict((("OutputWireColorSpaceExpected", SimTypeInt(signed=False, label="OUTPUT_WIRE_COLOR_SPACE_TYPE")), ("OutputWireFormatExpected", SimTypeRef("OUTPUT_WIRE_FORMAT", SimStruct)), ("ColorSpaceTransform", SimTypeRef("COLORSPACE_TRANSFORM", SimStruct)),)), name="COLORSPACE_TRANSFORM_SET_INPUT", pack=False, align=None),
    "COLORSPACE_TRANSFORM_STAGE_CONTROL": SimTypeInt(signed=False, label="COLORSPACE_TRANSFORM_STAGE_CONTROL"),
    "COLORSPACE_TRANSFORM_TARGET_CAPS": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="COLORSPACE_TRANSFORM_TARGET_CAPS_VERSION")), ("LookupTable1DDegammaCap", SimTypeRef("COLORSPACE_TRANSFORM_1DLUT_CAP", SimStruct)), ("ColorMatrix3x3Cap", SimTypeRef("COLORSPACE_TRANSFORM_MATRIX_CAP", SimStruct)), ("LookupTable1DRegammaCap", SimTypeRef("COLORSPACE_TRANSFORM_1DLUT_CAP", SimStruct)),)), name="COLORSPACE_TRANSFORM_TARGET_CAPS", pack=False, align=None),
    "COLORSPACE_TRANSFORM_TARGET_CAPS_VERSION": SimTypeInt(signed=False, label="COLORSPACE_TRANSFORM_TARGET_CAPS_VERSION"),
    "COLORSPACE_TRANSFORM_TYPE": SimTypeInt(signed=False, label="COLORSPACE_TRANSFORM_TYPE"),
    "COLORTYPE": SimTypeInt(signed=False, label="COLORTYPE"),
    "COLOR_MATCH_TO_TARGET_ACTION": SimTypeInt(signed=False, label="COLOR_MATCH_TO_TARGET_ACTION"),
    "COLUMNSET": SimStruct(OrderedDict((("cCol", SimTypeInt(signed=False, label="UInt32")), ("aCol", SimTypePointer(SimTypeRef("FULLPROPSPEC", SimStruct), offset=0)),)), name="COLUMNSET", pack=False, align=None),
    "COLUMNSTATUS": SimStruct(OrderedDict((("cPropCount", SimTypeInt(signed=True, label="Int32")), ("cPropsLoaded", SimTypeInt(signed=True, label="Int32")),)), name="COLUMNSTATUS", pack=False, align=None),
    "COMAdminAccessChecksLevelOptions": SimTypeInt(signed=False, label="COMAdminAccessChecksLevelOptions"),
    "COMAdminActivationOptions": SimTypeInt(signed=False, label="COMAdminActivationOptions"),
    "COMAdminApplicationExportOptions": SimTypeInt(signed=False, label="COMAdminApplicationExportOptions"),
    "COMAdminApplicationInstallOptions": SimTypeInt(signed=False, label="COMAdminApplicationInstallOptions"),
    "COMAdminAuthenticationCapabilitiesOptions": SimTypeInt(signed=False, label="COMAdminAuthenticationCapabilitiesOptions"),
    "COMAdminAuthenticationLevelOptions": SimTypeInt(signed=False, label="COMAdminAuthenticationLevelOptions"),
    "COMAdminComponentFlags": SimTypeInt(signed=False, label="COMAdminComponentFlags"),
    "COMAdminComponentType": SimTypeInt(signed=False, label="COMAdminComponentType"),
    "COMAdminErrorCodes": SimTypeInt(signed=False, label="COMAdminErrorCodes"),
    "COMAdminFileFlags": SimTypeInt(signed=False, label="COMAdminFileFlags"),
    "COMAdminImpersonationLevelOptions": SimTypeInt(signed=False, label="COMAdminImpersonationLevelOptions"),
    "COMAdminInUse": SimTypeInt(signed=False, label="COMAdminInUse"),
    "COMAdminOS": SimTypeInt(signed=False, label="COMAdminOS"),
    "COMAdminQCMessageAuthenticateOptions": SimTypeInt(signed=False, label="COMAdminQCMessageAuthenticateOptions"),
    "COMAdminServiceOptions": SimTypeInt(signed=False, label="COMAdminServiceOptions"),
    "COMAdminServiceStatusOptions": SimTypeInt(signed=False, label="COMAdminServiceStatusOptions"),
    "COMAdminSynchronizationOptions": SimTypeInt(signed=False, label="COMAdminSynchronizationOptions"),
    "COMAdminThreadingModels": SimTypeInt(signed=False, label="COMAdminThreadingModels"),
    "COMAdminTransactionOptions": SimTypeInt(signed=False, label="COMAdminTransactionOptions"),
    "COMAdminTxIsolationLevelOptions": SimTypeInt(signed=False, label="COMAdminTxIsolationLevelOptions"),
    "COMBOBOXEXITEMA": SimStruct(OrderedDict((("mask", SimTypeInt(signed=False, label="COMBOBOX_EX_ITEM_FLAGS")), ("iItem", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pszText", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cchTextMax", SimTypeInt(signed=True, label="Int32")), ("iImage", SimTypeInt(signed=True, label="Int32")), ("iSelectedImage", SimTypeInt(signed=True, label="Int32")), ("iOverlay", SimTypeInt(signed=True, label="Int32")), ("iIndent", SimTypeInt(signed=True, label="Int32")), ("lParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="COMBOBOXEXITEMA", pack=False, align=None),
    "COMBOBOXEXITEMW": SimStruct(OrderedDict((("mask", SimTypeInt(signed=False, label="COMBOBOX_EX_ITEM_FLAGS")), ("iItem", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pszText", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cchTextMax", SimTypeInt(signed=True, label="Int32")), ("iImage", SimTypeInt(signed=True, label="Int32")), ("iSelectedImage", SimTypeInt(signed=True, label="Int32")), ("iOverlay", SimTypeInt(signed=True, label="Int32")), ("iIndent", SimTypeInt(signed=True, label="Int32")), ("lParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="COMBOBOXEXITEMW", pack=False, align=None),
    "COMBOBOXINFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("rcItem", SimTypeRef("RECT", SimStruct)), ("rcButton", SimTypeRef("RECT", SimStruct)), ("stateButton", SimTypeInt(signed=False, label="COMBOBOXINFO_BUTTON_STATE")), ("hwndCombo", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hwndItem", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hwndList", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="COMBOBOXINFO", pack=False, align=None),
    "COMBOBOXINFO_BUTTON_STATE": SimTypeInt(signed=False, label="COMBOBOXINFO_BUTTON_STATE"),
    "COMBOBOXPARTS": SimTypeInt(signed=False, label="COMBOBOXPARTS"),
    "COMBOBOXSTYLESTATES": SimTypeInt(signed=False, label="COMBOBOXSTYLESTATES"),
    "COMBOBOX_EX_ITEM_FLAGS": SimTypeInt(signed=False, label="COMBOBOX_EX_ITEM_FLAGS"),
    "COMDLG_FILTERSPEC": SimStruct(OrderedDict((("pszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszSpec", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="COMDLG_FILTERSPEC", pack=False, align=None),
    "COMEVENTSYSCHANGEINFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("changeType", SimTypeInt(signed=False, label="EOC_ChangeType")), ("objectId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("partitionId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("applicationId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("reserved", SimTypeArray(SimTypeBottom(label="Guid"), 10)),)), name="COMEVENTSYSCHANGEINFO", pack=False, align=None),
    "COMMANDLINKGLYPHSTATES": SimTypeInt(signed=False, label="COMMANDLINKGLYPHSTATES"),
    "COMMANDLINKSTATES": SimTypeInt(signed=False, label="COMMANDLINKSTATES"),
    "COMMCONFIG": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("wVersion", SimTypeShort(signed=False, label="UInt16")), ("wReserved", SimTypeShort(signed=False, label="UInt16")), ("dcb", SimTypeRef("DCB", SimStruct)), ("dwProviderSubType", SimTypeInt(signed=False, label="UInt32")), ("dwProviderOffset", SimTypeInt(signed=False, label="UInt32")), ("dwProviderSize", SimTypeInt(signed=False, label="UInt32")), ("wcProviderData", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="COMMCONFIG", pack=False, align=None),
    "COMMON_DLG_ERRORS": SimTypeInt(signed=False, label="COMMON_DLG_ERRORS"),
    "COMMPROP": SimStruct(OrderedDict((("wPacketLength", SimTypeShort(signed=False, label="UInt16")), ("wPacketVersion", SimTypeShort(signed=False, label="UInt16")), ("dwServiceMask", SimTypeInt(signed=False, label="UInt32")), ("dwReserved1", SimTypeInt(signed=False, label="UInt32")), ("dwMaxTxQueue", SimTypeInt(signed=False, label="UInt32")), ("dwMaxRxQueue", SimTypeInt(signed=False, label="UInt32")), ("dwMaxBaud", SimTypeInt(signed=False, label="UInt32")), ("dwProvSubType", SimTypeInt(signed=False, label="UInt32")), ("dwProvCapabilities", SimTypeInt(signed=False, label="UInt32")), ("dwSettableParams", SimTypeInt(signed=False, label="UInt32")), ("dwSettableBaud", SimTypeInt(signed=False, label="UInt32")), ("wSettableData", SimTypeShort(signed=False, label="UInt16")), ("wSettableStopParity", SimTypeInt(signed=False, label="COMMPROP_STOP_PARITY")), ("dwCurrentTxQueue", SimTypeInt(signed=False, label="UInt32")), ("dwCurrentRxQueue", SimTypeInt(signed=False, label="UInt32")), ("dwProvSpec1", SimTypeInt(signed=False, label="UInt32")), ("dwProvSpec2", SimTypeInt(signed=False, label="UInt32")), ("wcProvChar", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="COMMPROP", pack=False, align=None),
    "COMMPROP_STOP_PARITY": SimTypeInt(signed=False, label="COMMPROP_STOP_PARITY"),
    "COMMTIMEOUTS": SimStruct(OrderedDict((("ReadIntervalTimeout", SimTypeInt(signed=False, label="UInt32")), ("ReadTotalTimeoutMultiplier", SimTypeInt(signed=False, label="UInt32")), ("ReadTotalTimeoutConstant", SimTypeInt(signed=False, label="UInt32")), ("WriteTotalTimeoutMultiplier", SimTypeInt(signed=False, label="UInt32")), ("WriteTotalTimeoutConstant", SimTypeInt(signed=False, label="UInt32")),)), name="COMMTIMEOUTS", pack=False, align=None),
    "COMMUNICATIONSPARTS": SimTypeInt(signed=False, label="COMMUNICATIONSPARTS"),
    "COMM_EVENT_MASK": SimTypeInt(signed=False, label="COMM_EVENT_MASK"),
    "COMM_FAULT_OFFSETS": SimStruct(OrderedDict((("CommOffset", SimTypeShort(signed=True, label="Int16")), ("FaultOffset", SimTypeShort(signed=True, label="Int16")),)), name="COMM_FAULT_OFFSETS", pack=False, align=None),
    "COMPACT_VIRTUAL_DISK_FLAG": SimTypeInt(signed=False, label="COMPACT_VIRTUAL_DISK_FLAG"),
    "COMPACT_VIRTUAL_DISK_PARAMETERS": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="COMPACT_VIRTUAL_DISK_VERSION")), ("Anonymous", SimUnion({"Version1": SimTypeRef("_Version1_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="COMPACT_VIRTUAL_DISK_PARAMETERS", pack=False, align=None),
    "COMPACT_VIRTUAL_DISK_VERSION": SimTypeInt(signed=False, label="COMPACT_VIRTUAL_DISK_VERSION"),
    "COMPAREITEMSTRUCT": SimStruct(OrderedDict((("CtlType", SimTypeInt(signed=False, label="DRAWITEMSTRUCT_CTL_TYPE")), ("CtlID", SimTypeInt(signed=False, label="UInt32")), ("hwndItem", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("itemID1", SimTypeInt(signed=False, label="UInt32")), ("itemData1", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("itemID2", SimTypeInt(signed=False, label="UInt32")), ("itemData2", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("dwLocaleId", SimTypeInt(signed=False, label="UInt32")),)), name="COMPAREITEMSTRUCT", pack=False, align=None),
    "COMPARESTRING_RESULT": SimTypeInt(signed=False, label="COMPARESTRING_RESULT"),
    "COMPARE_STRING_FLAGS": SimTypeInt(signed=False, label="COMPARE_STRING_FLAGS"),
    "COMPARTMENT_ID": SimTypeInt(signed=False, label="COMPARTMENT_ID"),
    "COMPATIBILITY_CONTEXT_ELEMENT": SimStruct(OrderedDict((("Id", SimTypeBottom(label="Guid")), ("Type", SimTypeInt(signed=False, label="ACTCTX_COMPATIBILITY_ELEMENT_TYPE")), ("MaxVersionTested", SimTypeLongLong(signed=False, label="UInt64")),)), name="COMPATIBILITY_CONTEXT_ELEMENT", pack=False, align=None),
    "COMPCOLOR": SimStruct(OrderedDict((("crText", SimTypeInt(signed=False, label="UInt32")), ("crBackground", SimTypeInt(signed=False, label="UInt32")), ("dwEffects", SimTypeInt(signed=False, label="UInt32")),)), name="COMPCOLOR", pack=False, align=None),
    "COMPLETE_AUTH_TOKEN_FN": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("SecHandle", SimStruct), offset=0), SimTypePointer(SimTypeRef("SecBufferDesc", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0),
    "COMPLETION_STATUS_FLAGS": SimTypeInt(signed=False, label="COMPLETION_STATUS_FLAGS"),
    "COMPLUS_APPTYPE": SimTypeInt(signed=False, label="COMPLUS_APPTYPE"),
    "COMPONENT_CHARACTERISTICS": SimTypeInt(signed=False, label="COMPONENT_CHARACTERISTICS"),
    "COMPONENT_FILTER": SimStruct(OrderedDict((("ComponentFlags", SimTypeInt(signed=False, label="UInt32")),)), name="COMPONENT_FILTER", pack=False, align=None),
    "COMPOSITIONFORM": SimStruct(OrderedDict((("dwStyle", SimTypeInt(signed=False, label="UInt32")), ("ptCurrentPos", SimTypeRef("POINT", SimStruct)), ("rcArea", SimTypeRef("RECT", SimStruct)),)), name="COMPOSITIONFORM", pack=False, align=None),
    "COMPOSITIONSTRING": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwCompReadAttrLen", SimTypeInt(signed=False, label="UInt32")), ("dwCompReadAttrOffset", SimTypeInt(signed=False, label="UInt32")), ("dwCompReadClauseLen", SimTypeInt(signed=False, label="UInt32")), ("dwCompReadClauseOffset", SimTypeInt(signed=False, label="UInt32")), ("dwCompReadStrLen", SimTypeInt(signed=False, label="UInt32")), ("dwCompReadStrOffset", SimTypeInt(signed=False, label="UInt32")), ("dwCompAttrLen", SimTypeInt(signed=False, label="UInt32")), ("dwCompAttrOffset", SimTypeInt(signed=False, label="UInt32")), ("dwCompClauseLen", SimTypeInt(signed=False, label="UInt32")), ("dwCompClauseOffset", SimTypeInt(signed=False, label="UInt32")), ("dwCompStrLen", SimTypeInt(signed=False, label="UInt32")), ("dwCompStrOffset", SimTypeInt(signed=False, label="UInt32")), ("dwCursorPos", SimTypeInt(signed=False, label="UInt32")), ("dwDeltaStart", SimTypeInt(signed=False, label="UInt32")), ("dwResultReadClauseLen", SimTypeInt(signed=False, label="UInt32")), ("dwResultReadClauseOffset", SimTypeInt(signed=False, label="UInt32")), ("dwResultReadStrLen", SimTypeInt(signed=False, label="UInt32")), ("dwResultReadStrOffset", SimTypeInt(signed=False, label="UInt32")), ("dwResultClauseLen", SimTypeInt(signed=False, label="UInt32")), ("dwResultClauseOffset", SimTypeInt(signed=False, label="UInt32")), ("dwResultStrLen", SimTypeInt(signed=False, label="UInt32")), ("dwResultStrOffset", SimTypeInt(signed=False, label="UInt32")), ("dwPrivateSize", SimTypeInt(signed=False, label="UInt32")), ("dwPrivateOffset", SimTypeInt(signed=False, label="UInt32")),)), name="COMPOSITIONSTRING", pack=False, align=None),
    "COMPOSITION_FRAME_ID_TYPE": SimTypeInt(signed=False, label="COMPOSITION_FRAME_ID_TYPE"),
    "COMPOSITION_FRAME_STATS": SimStruct(OrderedDict((("startTime", SimTypeLongLong(signed=False, label="UInt64")), ("targetTime", SimTypeLongLong(signed=False, label="UInt64")), ("framePeriod", SimTypeLongLong(signed=False, label="UInt64")),)), name="COMPOSITION_FRAME_STATS", pack=False, align=None),
    "COMPOSITION_STATS": SimStruct(OrderedDict((("presentCount", SimTypeInt(signed=False, label="UInt32")), ("refreshCount", SimTypeInt(signed=False, label="UInt32")), ("virtualRefreshCount", SimTypeInt(signed=False, label="UInt32")), ("time", SimTypeLongLong(signed=False, label="UInt64")),)), name="COMPOSITION_STATS", pack=False, align=None),
    "COMPOSITION_TARGET_ID": SimStruct(OrderedDict((("displayAdapterLuid", SimTypeRef("LUID", SimStruct)), ("renderAdapterLuid", SimTypeRef("LUID", SimStruct)), ("vidPnSourceId", SimTypeInt(signed=False, label="UInt32")), ("vidPnTargetId", SimTypeInt(signed=False, label="UInt32")), ("uniqueId", SimTypeInt(signed=False, label="UInt32")),)), name="COMPOSITION_TARGET_ID", pack=False, align=None),
    "COMPOSITION_TARGET_STATS": SimStruct(OrderedDict((("outstandingPresents", SimTypeInt(signed=False, label="UInt32")), ("presentTime", SimTypeLongLong(signed=False, label="UInt64")), ("vblankDuration", SimTypeLongLong(signed=False, label="UInt64")), ("presentedStats", SimTypeRef("COMPOSITION_STATS", SimStruct)), ("completedStats", SimTypeRef("COMPOSITION_STATS", SimStruct)),)), name="COMPOSITION_TARGET_STATS", pack=False, align=None),
    "COMPRESSED_DATA_INFO": SimStruct(OrderedDict((("CompressionFormatAndEngine", SimTypeShort(signed=False, label="UInt16")), ("CompressionUnitShift", SimTypeChar(label="Byte")), ("ChunkShift", SimTypeChar(label="Byte")), ("ClusterShift", SimTypeChar(label="Byte")), ("Reserved", SimTypeChar(label="Byte")), ("NumberOfChunks", SimTypeShort(signed=False, label="UInt16")), ("CompressedChunkSizes", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="COMPRESSED_DATA_INFO", pack=False, align=None),
    "COMPRESSION_FORMAT": SimTypeInt(signed=False, label="COMPRESSION_FORMAT"),
    "COMPRESSOR_HANDLE": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "COMPRESS_ALGORITHM": SimTypeInt(signed=False, label="COMPRESS_ALGORITHM"),
    "COMPRESS_ALLOCATION_ROUTINES": SimStruct(OrderedDict((("Allocate", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["UserContext", "Size"]), offset=0)), ("Free", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["UserContext", "Memory"]), offset=0)), ("UserContext", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="COMPRESS_ALLOCATION_ROUTINES", pack=False, align=None),
    "COMPRESS_INFORMATION_CLASS": SimTypeInt(signed=False, label="COMPRESS_INFORMATION_CLASS"),
    "COMPROPSHEETUI": SimStruct(OrderedDict((("cbSize", SimTypeShort(signed=False, label="UInt16")), ("Flags", SimTypeShort(signed=False, label="UInt16")), ("hInstCaller", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pCallerName", SimTypePointer(SimTypeChar(label="SByte"), offset=0)), ("UserData", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("pHelpFile", SimTypePointer(SimTypeChar(label="SByte"), offset=0)), ("pfnCallBack", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CPSUICBPARAM", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCPSUICBParam"]), offset=0)), ("pOptItem", SimTypePointer(SimTypeRef("OPTITEM", SimStruct), offset=0)), ("pDlgPage", SimTypePointer(SimTypeRef("DLGPAGE", SimStruct), offset=0)), ("cOptItem", SimTypeShort(signed=False, label="UInt16")), ("cDlgPage", SimTypeShort(signed=False, label="UInt16")), ("IconID", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("pOptItemName", SimTypePointer(SimTypeChar(label="SByte"), offset=0)), ("CallerVersion", SimTypeShort(signed=False, label="UInt16")), ("OptItemVersion", SimTypeShort(signed=False, label="UInt16")), ("dwReserved", SimTypeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 4)),)), name="COMPROPSHEETUI", pack=False, align=None),
    "COMPUTER_NAME_FORMAT": SimTypeInt(signed=False, label="COMPUTER_NAME_FORMAT"),
    "COMPVARS": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=True, label="Int32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("hic", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("fccType", SimTypeInt(signed=False, label="UInt32")), ("fccHandler", SimTypeInt(signed=False, label="UInt32")), ("lpbiIn", SimTypePointer(SimTypeRef("BITMAPINFO", SimStruct), offset=0)), ("lpbiOut", SimTypePointer(SimTypeRef("BITMAPINFO", SimStruct), offset=0)), ("lpBitsOut", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("lpBitsPrev", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("lFrame", SimTypeInt(signed=True, label="Int32")), ("lKey", SimTypeInt(signed=True, label="Int32")), ("lDataRate", SimTypeInt(signed=True, label="Int32")), ("lQ", SimTypeInt(signed=True, label="Int32")), ("lKeyCount", SimTypeInt(signed=True, label="Int32")), ("lpState", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cbState", SimTypeInt(signed=True, label="Int32")),)), name="COMPVARS", pack=False, align=None),
    "COMSD": SimTypeInt(signed=False, label="COMSD"),
    "COMSTAT": SimStruct(OrderedDict((("_bitfield", SimTypeInt(signed=False, label="UInt32")), ("cbInQue", SimTypeInt(signed=False, label="UInt32")), ("cbOutQue", SimTypeInt(signed=False, label="UInt32")),)), name="COMSTAT", pack=False, align=None),
    "COMSVCSEVENTINFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwPid", SimTypeInt(signed=False, label="UInt32")), ("lTime", SimTypeLongLong(signed=True, label="Int64")), ("lMicroTime", SimTypeInt(signed=True, label="Int32")), ("perfCount", SimTypeLongLong(signed=True, label="Int64")), ("guidApp", SimTypeBottom(label="Guid")), ("sMachineName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="COMSVCSEVENTINFO", pack=False, align=None),
    "CONDITIONPROPERTIES": SimTypeInt(signed=False, label="CONDITIONPROPERTIES"),
    "CONDITION_CREATION_OPTIONS": SimTypeInt(signed=False, label="CONDITION_CREATION_OPTIONS"),
    "CONDITION_OPERATION": SimTypeInt(signed=False, label="CONDITION_OPERATION"),
    "CONDITION_TYPE": SimTypeInt(signed=False, label="CONDITION_TYPE"),
    "CONDITION_VARIABLE": SimStruct(OrderedDict((("Ptr", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CONDITION_VARIABLE", pack=False, align=None),
    "CONFIDENCE_LEVEL": SimTypeInt(signed=False, label="CONFIDENCE_LEVEL"),
    "CONFIGRET": SimTypeInt(signed=False, label="CONFIGRET"),
    "CONFIGURATION_ENTRY": SimStruct(OrderedDict((("bstrKey", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("bstrValue", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CONFIGURATION_ENTRY", pack=False, align=None),
    "CONFIGURATION_INFORMATION": SimStruct(OrderedDict((("DiskCount", SimTypeInt(signed=False, label="UInt32")), ("FloppyCount", SimTypeInt(signed=False, label="UInt32")), ("CdRomCount", SimTypeInt(signed=False, label="UInt32")), ("TapeCount", SimTypeInt(signed=False, label="UInt32")), ("ScsiPortCount", SimTypeInt(signed=False, label="UInt32")), ("SerialCount", SimTypeInt(signed=False, label="UInt32")), ("ParallelCount", SimTypeInt(signed=False, label="UInt32")), ("AtDiskPrimaryAddressClaimed", SimTypeChar(label="Byte")), ("AtDiskSecondaryAddressClaimed", SimTypeChar(label="Byte")), ("Version", SimTypeInt(signed=False, label="UInt32")), ("MediumChangerCount", SimTypeInt(signed=False, label="UInt32")),)), name="CONFIGURATION_INFORMATION", pack=False, align=None),
    "CONFIGURATION_TYPE": SimTypeInt(signed=False, label="CONFIGURATION_TYPE"),
    "CONFIG_CI_PROV_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwPolicies", SimTypeInt(signed=False, label="UInt32")), ("pPolicies", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)), ("result", SimTypeRef("CONFIG_CI_PROV_INFO_RESULT", SimStruct)), ("dwScenario", SimTypeInt(signed=False, label="UInt32")), ("result2", SimTypePointer(SimTypeRef("CONFIG_CI_PROV_INFO_RESULT2", SimStruct), offset=0)),)), name="CONFIG_CI_PROV_INFO", pack=False, align=None),
    "CONFIG_CI_PROV_INFO_RESULT": SimStruct(OrderedDict((("hr", SimTypeInt(signed=True, label="Int32")), ("dwResult", SimTypeInt(signed=False, label="UInt32")), ("dwPolicyIndex", SimTypeInt(signed=False, label="UInt32")), ("fIsExplicitDeny", SimTypeChar(label="Byte")),)), name="CONFIG_CI_PROV_INFO_RESULT", pack=False, align=None),
    "CONFIG_CI_PROV_INFO_RESULT2": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hr", SimTypeInt(signed=True, label="Int32")), ("dwResult", SimTypeInt(signed=False, label="UInt32")), ("dwPolicyIndex", SimTypeInt(signed=False, label="UInt32")), ("fIsExplicitDeny", SimTypeChar(label="Byte")), ("cbCalculatedFileHash", SimTypeInt(signed=False, label="UInt32")), ("pbCalculatedFileHash", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CONFIG_CI_PROV_INFO_RESULT2", pack=False, align=None),
    "CONFIG_INFO_0": SimStruct(OrderedDict((("cfgi0_key", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cfgi0_data", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CONFIG_INFO_0", pack=False, align=None),
    "CONFIG_INFO_DATA_1": SimStruct(OrderedDict((("Reserved", SimTypeArray(SimTypeChar(label="Byte"), 128)), ("dwVersion", SimTypeInt(signed=False, label="UInt32")),)), name="CONFIG_INFO_DATA_1", pack=False, align=None),
    "CONFIRMSAFETY": SimStruct(OrderedDict((("clsid", SimTypeBottom(label="Guid")), ("pUnk", SimTypeBottom(label="IUnknown")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CONFIRMSAFETY", pack=False, align=None),
    "CONFIRM_CONFLICT_ITEM": SimStruct(OrderedDict((("pShellItem", SimTypeBottom(label="IShellItem2")), ("pszOriginalName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszAlternateName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszLocationShort", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszLocationFull", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("nType", SimTypeInt(signed=False, label="SYNCMGR_CONFLICT_ITEM_TYPE")),)), name="CONFIRM_CONFLICT_ITEM", pack=False, align=None),
    "CONFIRM_CONFLICT_RESULT_INFO": SimStruct(OrderedDict((("pszNewName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("iItemIndex", SimTypeInt(signed=False, label="UInt32")),)), name="CONFIRM_CONFLICT_RESULT_INFO", pack=False, align=None),
    "CONFLICT_DETAILS_A": SimStruct(OrderedDict((("CD_ulSize", SimTypeInt(signed=False, label="UInt32")), ("CD_ulMask", SimTypeInt(signed=False, label="CM_CDMASK")), ("CD_dnDevInst", SimTypeInt(signed=False, label="UInt32")), ("CD_rdResDes", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("CD_ulFlags", SimTypeInt(signed=False, label="CM_CDFLAGS")), ("CD_szDescription", SimTypeArray(SimTypeChar(label="SByte"), 260)),)), name="CONFLICT_DETAILS_A", pack=False, align=None),
    "CONFLICT_DETAILS_W": SimStruct(OrderedDict((("CD_ulSize", SimTypeInt(signed=False, label="UInt32")), ("CD_ulMask", SimTypeInt(signed=False, label="CM_CDMASK")), ("CD_dnDevInst", SimTypeInt(signed=False, label="UInt32")), ("CD_rdResDes", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("CD_ulFlags", SimTypeInt(signed=False, label="CM_CDFLAGS")), ("CD_szDescription", SimTypeArray(SimTypeChar(label="Char"), 260)),)), name="CONFLICT_DETAILS_W", pack=False, align=None),
    "CONFLICT_RESOLUTION_POLICY": SimTypeInt(signed=False, label="CONFLICT_RESOLUTION_POLICY"),
    "CONNECTDATA": SimStruct(OrderedDict((("pUnk", SimTypeBottom(label="IUnknown")), ("dwCookie", SimTypeInt(signed=False, label="UInt32")),)), name="CONNECTDATA", pack=False, align=None),
    "CONNECTDLGSTRUCTA": SimStruct(OrderedDict((("cbStructure", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpConnRes", SimTypePointer(SimTypeRef("NETRESOURCEA", SimStruct), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="CONNECTDLGSTRUCT_FLAGS")), ("dwDevNum", SimTypeInt(signed=False, label="UInt32")),)), name="CONNECTDLGSTRUCTA", pack=False, align=None),
    "CONNECTDLGSTRUCTW": SimStruct(OrderedDict((("cbStructure", SimTypeInt(signed=False, label="UInt32")), ("hwndOwner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpConnRes", SimTypePointer(SimTypeRef("NETRESOURCEW", SimStruct), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="CONNECTDLGSTRUCT_FLAGS")), ("dwDevNum", SimTypeInt(signed=False, label="UInt32")),)), name="CONNECTDLGSTRUCTW", pack=False, align=None),
    "CONNECTDLGSTRUCT_FLAGS": SimTypeInt(signed=False, label="CONNECTDLGSTRUCT_FLAGS"),
    "CONNECTION": SimStruct(OrderedDict((("usSource", SimTypeShort(signed=False, label="UInt16")), ("usControl", SimTypeShort(signed=False, label="UInt16")), ("usDestination", SimTypeShort(signed=False, label="UInt16")), ("usTransform", SimTypeShort(signed=False, label="UInt16")), ("lScale", SimTypeInt(signed=True, label="Int32")),)), name="CONNECTION", pack=False, align=None),
    "CONNECTIONLIST": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("cConnections", SimTypeInt(signed=False, label="UInt32")),)), name="CONNECTIONLIST", pack=False, align=None),
    "CONNECTION_CHANGE_NOTIFICATION": SimTypeInt(signed=False, label="CONNECTION_CHANGE_NOTIFICATION"),
    "CONNECTION_DES": SimStruct(OrderedDict((("COND_Type", SimTypeInt(signed=False, label="UInt32")), ("COND_Flags", SimTypeInt(signed=False, label="UInt32")), ("COND_Class", SimTypeChar(label="Byte")), ("COND_ClassType", SimTypeChar(label="Byte")), ("COND_Reserved1", SimTypeChar(label="Byte")), ("COND_Reserved2", SimTypeChar(label="Byte")), ("COND_Id", SimTypeLongLong(signed=True, label="Int64")),)), name="CONNECTION_DES", pack=False, align=None),
    "CONNECTION_INFO_0": SimStruct(OrderedDict((("coni0_id", SimTypeInt(signed=False, label="UInt32")),)), name="CONNECTION_INFO_0", pack=False, align=None),
    "CONNECTION_INFO_1": SimStruct(OrderedDict((("coni1_id", SimTypeInt(signed=False, label="UInt32")), ("coni1_type", SimTypeInt(signed=False, label="SHARE_TYPE")), ("coni1_num_opens", SimTypeInt(signed=False, label="UInt32")), ("coni1_num_users", SimTypeInt(signed=False, label="UInt32")), ("coni1_time", SimTypeInt(signed=False, label="UInt32")), ("coni1_username", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("coni1_netname", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CONNECTION_INFO_1", pack=False, align=None),
    "CONNECTION_RESOURCE": SimStruct(OrderedDict((("Connection_Header", SimTypeRef("CONNECTION_DES", SimStruct)),)), name="CONNECTION_RESOURCE", pack=False, align=None),
    "CONSOLECONTROL": SimTypeInt(signed=False, label="CONSOLECONTROL"),
    "CONSOLEENDTASK": SimStruct(OrderedDict((("ProcessId", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("ConsoleEventCode", SimTypeInt(signed=False, label="UInt32")), ("ConsoleFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CONSOLEENDTASK", pack=False, align=None),
    "CONSOLESETFOREGROUND": SimStruct(OrderedDict((("hProcess", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("bForeground", SimTypeInt(signed=True, label="Int32")),)), name="CONSOLESETFOREGROUND", pack=False, align=None),
    "CONSOLEWINDOWOWNER": SimStruct(OrderedDict((("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("ProcessId", SimTypeInt(signed=False, label="UInt32")), ("ThreadId", SimTypeInt(signed=False, label="UInt32")),)), name="CONSOLEWINDOWOWNER", pack=False, align=None),
    "CONSOLE_CARET_INFO": SimStruct(OrderedDict((("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("rc", SimTypeRef("RECT", SimStruct)),)), name="CONSOLE_CARET_INFO", pack=False, align=None),
    "CONSOLE_CHARACTER_ATTRIBUTES": SimTypeInt(signed=False, label="CONSOLE_CHARACTER_ATTRIBUTES"),
    "CONSOLE_CURSOR_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("bVisible", SimTypeInt(signed=True, label="Int32")),)), name="CONSOLE_CURSOR_INFO", pack=False, align=None),
    "CONSOLE_FONT_INFO": SimStruct(OrderedDict((("nFont", SimTypeInt(signed=False, label="UInt32")), ("dwFontSize", SimTypeRef("COORD", SimStruct)),)), name="CONSOLE_FONT_INFO", pack=False, align=None),
    "CONSOLE_FONT_INFOEX": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("nFont", SimTypeInt(signed=False, label="UInt32")), ("dwFontSize", SimTypeRef("COORD", SimStruct)), ("FontFamily", SimTypeInt(signed=False, label="UInt32")), ("FontWeight", SimTypeInt(signed=False, label="UInt32")), ("FaceName", SimTypeArray(SimTypeChar(label="Char"), 32)),)), name="CONSOLE_FONT_INFOEX", pack=False, align=None),
    "CONSOLE_HISTORY_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("HistoryBufferSize", SimTypeInt(signed=False, label="UInt32")), ("NumberOfHistoryBuffers", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CONSOLE_HISTORY_INFO", pack=False, align=None),
    "CONSOLE_MODE": SimTypeInt(signed=False, label="CONSOLE_MODE"),
    "CONSOLE_PROCESS_INFO": SimStruct(OrderedDict((("dwProcessID", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CONSOLE_PROCESS_INFO", pack=False, align=None),
    "CONSOLE_READCONSOLE_CONTROL": SimStruct(OrderedDict((("nLength", SimTypeInt(signed=False, label="UInt32")), ("nInitialChars", SimTypeInt(signed=False, label="UInt32")), ("dwCtrlWakeupMask", SimTypeInt(signed=False, label="UInt32")), ("dwControlKeyState", SimTypeInt(signed=False, label="UInt32")),)), name="CONSOLE_READCONSOLE_CONTROL", pack=False, align=None),
    "CONSOLE_SCREEN_BUFFER_INFO": SimStruct(OrderedDict((("dwSize", SimTypeRef("COORD", SimStruct)), ("dwCursorPosition", SimTypeRef("COORD", SimStruct)), ("wAttributes", SimTypeInt(signed=False, label="CONSOLE_CHARACTER_ATTRIBUTES")), ("srWindow", SimTypeRef("SMALL_RECT", SimStruct)), ("dwMaximumWindowSize", SimTypeRef("COORD", SimStruct)),)), name="CONSOLE_SCREEN_BUFFER_INFO", pack=False, align=None),
    "CONSOLE_SCREEN_BUFFER_INFOEX": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwSize", SimTypeRef("COORD", SimStruct)), ("dwCursorPosition", SimTypeRef("COORD", SimStruct)), ("wAttributes", SimTypeInt(signed=False, label="CONSOLE_CHARACTER_ATTRIBUTES")), ("srWindow", SimTypeRef("SMALL_RECT", SimStruct)), ("dwMaximumWindowSize", SimTypeRef("COORD", SimStruct)), ("wPopupAttributes", SimTypeShort(signed=False, label="UInt16")), ("bFullscreenSupported", SimTypeInt(signed=True, label="Int32")), ("ColorTable", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 16)),)), name="CONSOLE_SCREEN_BUFFER_INFOEX", pack=False, align=None),
    "CONSOLE_SELECTION_INFO": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwSelectionAnchor", SimTypeRef("COORD", SimStruct)), ("srSelection", SimTypeRef("SMALL_RECT", SimStruct)),)), name="CONSOLE_SELECTION_INFO", pack=False, align=None),
    "CONSTRAINT_CONFLICT_REASON": SimTypeInt(signed=False, label="CONSTRAINT_CONFLICT_REASON"),
    "CONSTRICTOR_OPTION": SimTypeInt(signed=False, label="CONSTRICTOR_OPTION"),
    "CONTACT_AGGREGATION_BLOB": SimStruct(OrderedDict((("dwCount", SimTypeInt(signed=False, label="UInt32")), ("lpb", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CONTACT_AGGREGATION_BLOB", pack=False, align=None),
    "CONTACT_AGGREGATION_COLLECTION_OPTIONS": SimTypeInt(signed=False, label="CONTACT_AGGREGATION_COLLECTION_OPTIONS"),
    "CONTACT_AGGREGATION_CREATE_OR_OPEN_OPTIONS": SimTypeInt(signed=False, label="CONTACT_AGGREGATION_CREATE_OR_OPEN_OPTIONS"),
    "CONTAINER_ROOT_INFO_INPUT": SimStruct(OrderedDict((("Flags", SimTypeInt(signed=False, label="UInt32")),)), name="CONTAINER_ROOT_INFO_INPUT", pack=False, align=None),
    "CONTAINER_ROOT_INFO_OUTPUT": SimStruct(OrderedDict((("ContainerRootIdLength", SimTypeShort(signed=False, label="UInt16")), ("ContainerRootId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CONTAINER_ROOT_INFO_OUTPUT", pack=False, align=None),
    "CONTAINER_VOLUME_STATE": SimStruct(OrderedDict((("Flags", SimTypeInt(signed=False, label="UInt32")),)), name="CONTAINER_VOLUME_STATE", pack=False, align=None),
    "CONTENTALIGNMENT": SimTypeInt(signed=False, label="CONTENTALIGNMENT"),
    "CONTENTAREASTATES": SimTypeInt(signed=False, label="CONTENTAREASTATES"),
    "CONTENTLINKSTATES": SimTypeInt(signed=False, label="CONTENTLINKSTATES"),
    "CONTENTPANESTATES": SimTypeInt(signed=False, label="CONTENTPANESTATES"),
    "CONTENTRESTRICTION": SimStruct(OrderedDict((("prop", SimTypeRef("FULLPROPSPEC", SimStruct)), ("pwcsPhrase", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lcid", SimTypeInt(signed=False, label="UInt32")), ("ulGenerateMethod", SimTypeInt(signed=False, label="UInt32")),)), name="CONTENTRESTRICTION", pack=False, align=None),
    "CONTENT_MISSING_EVENT_DATA": SimStruct(OrderedDict((("cbContentMissingEventData", SimTypeInt(signed=False, label="UInt32")), ("ApplicationId", SimTypeBottom(label="Guid")), ("EndpointId", SimTypeBottom(label="Guid")), ("ContentId", SimTypeInt(signed=False, label="UInt32")),)), name="CONTENT_MISSING_EVENT_DATA", pack=False, align=None),
    "CONTEXT": SimStruct(OrderedDict((("ContextFlags", SimTypeInt(signed=False, label="CONTEXT_FLAGS")), ("Dr0", SimTypeInt(signed=False, label="UInt32")), ("Dr1", SimTypeInt(signed=False, label="UInt32")), ("Dr2", SimTypeInt(signed=False, label="UInt32")), ("Dr3", SimTypeInt(signed=False, label="UInt32")), ("Dr6", SimTypeInt(signed=False, label="UInt32")), ("Dr7", SimTypeInt(signed=False, label="UInt32")), ("FloatSave", SimTypeRef("FLOATING_SAVE_AREA", SimStruct)), ("SegGs", SimTypeInt(signed=False, label="UInt32")), ("SegFs", SimTypeInt(signed=False, label="UInt32")), ("SegEs", SimTypeInt(signed=False, label="UInt32")), ("SegDs", SimTypeInt(signed=False, label="UInt32")), ("Edi", SimTypeInt(signed=False, label="UInt32")), ("Esi", SimTypeInt(signed=False, label="UInt32")), ("Ebx", SimTypeInt(signed=False, label="UInt32")), ("Edx", SimTypeInt(signed=False, label="UInt32")), ("Ecx", SimTypeInt(signed=False, label="UInt32")), ("Eax", SimTypeInt(signed=False, label="UInt32")), ("Ebp", SimTypeInt(signed=False, label="UInt32")), ("Eip", SimTypeInt(signed=False, label="UInt32")), ("SegCs", SimTypeInt(signed=False, label="UInt32")), ("EFlags", SimTypeInt(signed=False, label="UInt32")), ("Esp", SimTypeInt(signed=False, label="UInt32")), ("SegSs", SimTypeInt(signed=False, label="UInt32")), ("ExtendedRegisters", SimTypeArray(SimTypeChar(label="Byte"), 512)),)), name="CONTEXT", pack=False, align=None),
    "CONTEXTMENUITEM": SimStruct(OrderedDict((("strName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("strStatusBarText", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lCommandID", SimTypeInt(signed=True, label="Int32")), ("lInsertionPointID", SimTypeInt(signed=True, label="Int32")), ("fFlags", SimTypeInt(signed=True, label="Int32")), ("fSpecialFlags", SimTypeInt(signed=True, label="Int32")),)), name="CONTEXTMENUITEM", pack=False, align=None),
    "CONTEXTMENUITEM2": SimStruct(OrderedDict((("strName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("strStatusBarText", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lCommandID", SimTypeInt(signed=True, label="Int32")), ("lInsertionPointID", SimTypeInt(signed=True, label="Int32")), ("fFlags", SimTypeInt(signed=True, label="Int32")), ("fSpecialFlags", SimTypeInt(signed=True, label="Int32")), ("strLanguageIndependentName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CONTEXTMENUITEM2", pack=False, align=None),
    "CONTEXT_FLAGS": SimTypeInt(signed=False, label="CONTEXT_FLAGS"),
    "CONTRESCR10WAVEFORMAT": SimStruct(OrderedDict((("wfx", SimTypeRef("WAVEFORMATEX", SimStruct)), ("wSamplesPerBlock", SimTypeShort(signed=False, label="UInt16")),)), name="CONTRESCR10WAVEFORMAT", pack=False, align=None),
    "CONTRESVQLPCWAVEFORMAT": SimStruct(OrderedDict((("wfx", SimTypeRef("WAVEFORMATEX", SimStruct)), ("wSamplesPerBlock", SimTypeShort(signed=False, label="UInt16")),)), name="CONTRESVQLPCWAVEFORMAT", pack=False, align=None),
    "CONTROLINFO": SimStruct(OrderedDict((("cb", SimTypeInt(signed=False, label="UInt32")), ("hAccel", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("cAccel", SimTypeShort(signed=False, label="UInt16")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CONTROLINFO", pack=False, align=None),
    "CONTROLLABELSTATES": SimTypeInt(signed=False, label="CONTROLLABELSTATES"),
    "CONTROLLER_OBJECT": SimStruct(OrderedDict((("Type", SimTypeShort(signed=True, label="Int16")), ("Size", SimTypeShort(signed=True, label="Int16")), ("ControllerExtension", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("DeviceWaitQueue", SimTypeRef("KDEVICE_QUEUE", SimStruct)), ("Spare1", SimTypeInt(signed=False, label="UInt32")), ("Spare2", SimTypeLongLong(signed=True, label="Int64")),)), name="CONTROLLER_OBJECT", pack=False, align=None),
    "CONTROLPANELPARTS": SimTypeInt(signed=False, label="CONTROLPANELPARTS"),
    "CONTROLTRACE_HANDLE": SimStruct(OrderedDict((("Value", SimTypeLongLong(signed=False, label="UInt64")),)), name="CONTROLTRACE_HANDLE", pack=False, align=None),
    "CONTROL_CHANNEL_TRIGGER_STATUS": SimTypeInt(signed=False, label="CONTROL_CHANNEL_TRIGGER_STATUS"),
    "CONTROL_SERVICE": SimStruct(OrderedDict((("Length", SimTypeInt(signed=False, label="UInt32")), ("Service", SimTypeInt(signed=False, label="UInt32")), ("Overrides", SimTypeRef("AD_GENERAL_PARAMS", SimStruct)), ("Anonymous", SimUnion({"Guaranteed": SimTypeRef("AD_GUARANTEED", SimStruct), "ParamBuffer": SimTypePointer(SimTypeRef("PARAM_BUFFER", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="CONTROL_SERVICE", pack=False, align=None),
    "CONVCONTEXT": SimStruct(OrderedDict((("cb", SimTypeInt(signed=False, label="UInt32")), ("wFlags", SimTypeInt(signed=False, label="UInt32")), ("wCountryID", SimTypeInt(signed=False, label="UInt32")), ("iCodePage", SimTypeInt(signed=True, label="Int32")), ("dwLangID", SimTypeInt(signed=False, label="UInt32")), ("dwSecurity", SimTypeInt(signed=False, label="UInt32")), ("qos", SimTypeRef("SECURITY_QUALITY_OF_SERVICE", SimStruct)),)), name="CONVCONTEXT", pack=False, align=None),
    "CONVINFO": SimStruct(OrderedDict((("cb", SimTypeInt(signed=False, label="UInt32")), ("hUser", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("hConvPartner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hszSvcPartner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hszServiceReq", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hszTopic", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hszItem", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("wFmt", SimTypeInt(signed=False, label="UInt32")), ("wType", SimTypeInt(signed=False, label="DDE_CLIENT_TRANSACTION_TYPE")), ("wStatus", SimTypeInt(signed=False, label="CONVINFO_STATUS")), ("wConvst", SimTypeInt(signed=False, label="CONVINFO_CONVERSATION_STATE")), ("wLastError", SimTypeInt(signed=False, label="UInt32")), ("hConvList", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("ConvCtxt", SimTypeRef("CONVCONTEXT", SimStruct)), ("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hwndPartner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CONVINFO", pack=False, align=None),
    "CONVINFO_CONVERSATION_STATE": SimTypeInt(signed=False, label="CONVINFO_CONVERSATION_STATE"),
    "CONVINFO_STATUS": SimTypeInt(signed=False, label="CONVINFO_STATUS"),
    "COOKIE_DLG_INFO": SimStruct(OrderedDict((("pszServer", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pic", SimTypePointer(SimTypeRef("INTERNET_COOKIE", SimStruct), offset=0)), ("dwStopWarning", SimTypeInt(signed=False, label="UInt32")), ("cx", SimTypeInt(signed=True, label="Int32")), ("cy", SimTypeInt(signed=True, label="Int32")), ("pszHeader", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwOperation", SimTypeInt(signed=False, label="UInt32")),)), name="COOKIE_DLG_INFO", pack=False, align=None),
    "COORD": SimStruct(OrderedDict((("X", SimTypeShort(signed=True, label="Int16")), ("Y", SimTypeShort(signed=True, label="Int16")),)), name="COORD", pack=False, align=None),
    "COORD_SYSTEM": SimTypeInt(signed=False, label="COORD_SYSTEM"),
    "COPPEventBlockReason": SimTypeInt(signed=False, label="COPPEventBlockReason"),
    "COPP_ACP_Protection_Level": SimTypeInt(signed=False, label="COPP_ACP_Protection_Level"),
    "COPP_BusType": SimTypeInt(signed=False, label="COPP_BusType"),
    "COPP_CGMSA_Protection_Level": SimTypeInt(signed=False, label="COPP_CGMSA_Protection_Level"),
    "COPP_ConnectorType": SimTypeInt(signed=False, label="COPP_ConnectorType"),
    "COPP_HDCP_Protection_Level": SimTypeInt(signed=False, label="COPP_HDCP_Protection_Level"),
    "COPP_ImageAspectRatio_EN300294": SimTypeInt(signed=False, label="COPP_ImageAspectRatio_EN300294"),
    "COPP_StatusFlags": SimTypeInt(signed=False, label="COPP_StatusFlags"),
    "COPP_StatusHDCPFlags": SimTypeInt(signed=False, label="COPP_StatusHDCPFlags"),
    "COPP_TVProtectionStandard": SimTypeInt(signed=False, label="COPP_TVProtectionStandard"),
    "COPYDATASTRUCT": SimStruct(OrderedDict((("dwData", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("cbData", SimTypeInt(signed=False, label="UInt32")), ("lpData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="COPYDATASTRUCT", pack=False, align=None),
    "COPYFILE2_COPY_PHASE": SimTypeInt(signed=False, label="COPYFILE2_COPY_PHASE"),
    "COPYFILE2_EXTENDED_PARAMETERS": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwCopyFlags", SimTypeInt(signed=False, label="UInt32")), ("pfCancel", SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)), ("pProgressRoutine", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("COPYFILE2_MESSAGE", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="COPYFILE2_MESSAGE_ACTION"), arg_names=["pMessage", "pvCallbackContext"]), offset=0)), ("pvCallbackContext", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="COPYFILE2_EXTENDED_PARAMETERS", pack=False, align=None),
    "COPYFILE2_EXTENDED_PARAMETERS_V2": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwCopyFlags", SimTypeInt(signed=False, label="UInt32")), ("pfCancel", SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)), ("pProgressRoutine", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("COPYFILE2_MESSAGE", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="COPYFILE2_MESSAGE_ACTION"), arg_names=["pMessage", "pvCallbackContext"]), offset=0)), ("pvCallbackContext", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("dwCopyFlagsV2", SimTypeInt(signed=False, label="UInt32")), ("ioDesiredSize", SimTypeInt(signed=False, label="UInt32")), ("ioDesiredRate", SimTypeInt(signed=False, label="UInt32")), ("reserved", SimTypeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 8)),)), name="COPYFILE2_EXTENDED_PARAMETERS_V2", pack=False, align=None),
    "COPYFILE2_MESSAGE": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="COPYFILE2_MESSAGE_TYPE")), ("dwPadding", SimTypeInt(signed=False, label="UInt32")), ("Info", SimUnion({"ChunkStarted": SimTypeRef("_ChunkStarted_e__Struct", SimStruct), "ChunkFinished": SimTypeRef("_ChunkFinished_e__Struct", SimStruct), "StreamStarted": SimTypeRef("_StreamStarted_e__Struct", SimStruct), "StreamFinished": SimTypeRef("_StreamFinished_e__Struct", SimStruct), "PollContinue": SimTypeRef("_PollContinue_e__Struct", SimStruct), "Error": SimTypeRef("_Error_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="COPYFILE2_MESSAGE", pack=False, align=None),
    "COPYFILE2_MESSAGE_ACTION": SimTypeInt(signed=False, label="COPYFILE2_MESSAGE_ACTION"),
    "COPYFILE2_MESSAGE_TYPE": SimTypeInt(signed=False, label="COPYFILE2_MESSAGE_TYPE"),
    "COPYSTATES": SimTypeInt(signed=False, label="COPYSTATES"),
    "COPY_INFORMATION": SimStruct(OrderedDict((("SourceFileObject", SimTypePointer(SimTypeRef("FILE_OBJECT", SimStruct), offset=0)), ("SourceFileOffset", SimTypeLongLong(signed=True, label="Int64")),)), name="COPY_INFORMATION", pack=False, align=None),
    "CORE_PRINTER_DRIVERA": SimStruct(OrderedDict((("CoreDriverGUID", SimTypeBottom(label="Guid")), ("ftDriverDate", SimTypeRef("FILETIME", SimStruct)), ("dwlDriverVersion", SimTypeLongLong(signed=False, label="UInt64")), ("szPackageID", SimTypeArray(SimTypeChar(label="SByte"), 260)),)), name="CORE_PRINTER_DRIVERA", pack=False, align=None),
    "CORE_PRINTER_DRIVERW": SimStruct(OrderedDict((("CoreDriverGUID", SimTypeBottom(label="Guid")), ("ftDriverDate", SimTypeRef("FILETIME", SimStruct)), ("dwlDriverVersion", SimTypeLongLong(signed=False, label="UInt64")), ("szPackageID", SimTypeArray(SimTypeChar(label="Char"), 260)),)), name="CORE_PRINTER_DRIVERW", pack=False, align=None),
    "CORRECTIVE_ACTION": SimTypeInt(signed=False, label="CORRECTIVE_ACTION"),
    "CORRELATION_VECTOR": SimStruct(OrderedDict((("Version", SimTypeChar(label="SByte")), ("Vector", SimTypeArray(SimTypeChar(label="SByte"), 129)),)), name="CORRELATION_VECTOR", pack=False, align=None),
    "COR_DEBUG_IL_TO_NATIVE_MAP": SimStruct(OrderedDict((("ilOffset", SimTypeInt(signed=False, label="UInt32")), ("nativeStartOffset", SimTypeInt(signed=False, label="UInt32")), ("nativeEndOffset", SimTypeInt(signed=False, label="UInt32")),)), name="COR_DEBUG_IL_TO_NATIVE_MAP", pack=False, align=None),
    "COR_GC_STATS": SimStruct(OrderedDict((("Flags", SimTypeInt(signed=False, label="UInt32")), ("ExplicitGCCount", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("GenCollectionsTaken", SimTypeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 3)), ("CommittedKBytes", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ReservedKBytes", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("Gen0HeapSizeKBytes", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("Gen1HeapSizeKBytes", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("Gen2HeapSizeKBytes", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("LargeObjectHeapSizeKBytes", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("KBytesPromotedFromGen0", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("KBytesPromotedFromGen1", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="COR_GC_STATS", pack=False, align=None),
    "COR_GC_STAT_TYPES": SimTypeInt(signed=False, label="COR_GC_STAT_TYPES"),
    "COR_GC_THREAD_STATS": SimStruct(OrderedDict((("PerThreadAllocation", SimTypeLongLong(signed=False, label="UInt64")), ("Flags", SimTypeInt(signed=False, label="UInt32")),)), name="COR_GC_THREAD_STATS", pack=False, align=None),
    "COR_GC_THREAD_STATS_TYPES": SimTypeInt(signed=False, label="COR_GC_THREAD_STATS_TYPES"),
    "COR_IL_MAP": SimStruct(OrderedDict((("oldOffset", SimTypeInt(signed=False, label="UInt32")), ("newOffset", SimTypeInt(signed=False, label="UInt32")), ("fAccurate", SimTypeInt(signed=True, label="Int32")),)), name="COR_IL_MAP", pack=False, align=None),
    "COR_PRF_CLAUSE_TYPE": SimTypeInt(signed=False, label="COR_PRF_CLAUSE_TYPE"),
    "COR_PRF_CODEGEN_FLAGS": SimTypeInt(signed=False, label="COR_PRF_CODEGEN_FLAGS"),
    "COR_PRF_CODE_INFO": SimStruct(OrderedDict((("startAddress", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("size", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="COR_PRF_CODE_INFO", pack=False, align=None),
    "COR_PRF_EVENTPIPE_LEVEL": SimTypeInt(signed=False, label="COR_PRF_EVENTPIPE_LEVEL"),
    "COR_PRF_EVENTPIPE_PARAM_DESC": SimStruct(OrderedDict((("type", SimTypeInt(signed=False, label="UInt32")), ("elementType", SimTypeInt(signed=False, label="UInt32")), ("name", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="COR_PRF_EVENTPIPE_PARAM_DESC", pack=False, align=None),
    "COR_PRF_EVENTPIPE_PARAM_TYPE": SimTypeInt(signed=False, label="COR_PRF_EVENTPIPE_PARAM_TYPE"),
    "COR_PRF_EVENTPIPE_PROVIDER_CONFIG": SimStruct(OrderedDict((("providerName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("keywords", SimTypeLongLong(signed=False, label="UInt64")), ("loggingLevel", SimTypeInt(signed=False, label="UInt32")), ("filterData", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="COR_PRF_EVENTPIPE_PROVIDER_CONFIG", pack=False, align=None),
    "COR_PRF_EVENT_DATA": SimStruct(OrderedDict((("ptr", SimTypeLongLong(signed=False, label="UInt64")), ("size", SimTypeInt(signed=False, label="UInt32")), ("reserved", SimTypeInt(signed=False, label="UInt32")),)), name="COR_PRF_EVENT_DATA", pack=False, align=None),
    "COR_PRF_EX_CLAUSE_INFO": SimStruct(OrderedDict((("clauseType", SimTypeInt(signed=False, label="COR_PRF_CLAUSE_TYPE")), ("programCounter", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("framePointer", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("shadowStackPointer", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="COR_PRF_EX_CLAUSE_INFO", pack=False, align=None),
    "COR_PRF_FILTER_DATA": SimStruct(OrderedDict((("Ptr", SimTypeLongLong(signed=False, label="UInt64")), ("Size", SimTypeInt(signed=False, label="UInt32")), ("Type", SimTypeInt(signed=False, label="UInt32")),)), name="COR_PRF_FILTER_DATA", pack=False, align=None),
    "COR_PRF_FINALIZER_FLAGS": SimTypeInt(signed=False, label="COR_PRF_FINALIZER_FLAGS"),
    "COR_PRF_FUNCTION": SimStruct(OrderedDict((("functionId", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("reJitId", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="COR_PRF_FUNCTION", pack=False, align=None),
    "COR_PRF_FUNCTION_ARGUMENT_INFO": SimStruct(OrderedDict((("numRanges", SimTypeInt(signed=False, label="UInt32")), ("totalArgumentSize", SimTypeInt(signed=False, label="UInt32")), ("ranges", SimTypePointer(SimTypeRef("COR_PRF_FUNCTION_ARGUMENT_RANGE", SimStruct), offset=0)),)), name="COR_PRF_FUNCTION_ARGUMENT_INFO", pack=False, align=None),
    "COR_PRF_FUNCTION_ARGUMENT_RANGE": SimStruct(OrderedDict((("startAddress", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("length", SimTypeInt(signed=False, label="UInt32")),)), name="COR_PRF_FUNCTION_ARGUMENT_RANGE", pack=False, align=None),
    "COR_PRF_GC_GENERATION": SimTypeInt(signed=False, label="COR_PRF_GC_GENERATION"),
    "COR_PRF_GC_GENERATION_RANGE": SimStruct(OrderedDict((("generation", SimTypeInt(signed=False, label="COR_PRF_GC_GENERATION")), ("rangeStart", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("rangeLength", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("rangeLengthReserved", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="COR_PRF_GC_GENERATION_RANGE", pack=False, align=None),
    "COR_PRF_GC_REASON": SimTypeInt(signed=False, label="COR_PRF_GC_REASON"),
    "COR_PRF_GC_ROOT_FLAGS": SimTypeInt(signed=False, label="COR_PRF_GC_ROOT_FLAGS"),
    "COR_PRF_GC_ROOT_KIND": SimTypeInt(signed=False, label="COR_PRF_GC_ROOT_KIND"),
    "COR_PRF_HANDLE_TYPE": SimTypeInt(signed=False, label="COR_PRF_HANDLE_TYPE"),
    "COR_PRF_HIGH_MONITOR": SimTypeInt(signed=False, label="COR_PRF_HIGH_MONITOR"),
    "COR_PRF_JIT_CACHE": SimTypeInt(signed=False, label="COR_PRF_JIT_CACHE"),
    "COR_PRF_METHOD": SimStruct(OrderedDict((("moduleId", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("methodId", SimTypeInt(signed=False, label="UInt32")),)), name="COR_PRF_METHOD", pack=False, align=None),
    "COR_PRF_MISC": SimTypeInt(signed=False, label="COR_PRF_MISC"),
    "COR_PRF_MODULE_FLAGS": SimTypeInt(signed=False, label="COR_PRF_MODULE_FLAGS"),
    "COR_PRF_MONITOR": SimTypeInt(signed=False, label="COR_PRF_MONITOR"),
    "COR_PRF_NONGC_HEAP_RANGE": SimStruct(OrderedDict((("rangeStart", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("rangeLength", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("rangeLengthReserved", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="COR_PRF_NONGC_HEAP_RANGE", pack=False, align=None),
    "COR_PRF_REJIT_FLAGS": SimTypeInt(signed=False, label="COR_PRF_REJIT_FLAGS"),
    "COR_PRF_RUNTIME_TYPE": SimTypeInt(signed=False, label="COR_PRF_RUNTIME_TYPE"),
    "COR_PRF_SNAPSHOT_INFO": SimTypeInt(signed=False, label="COR_PRF_SNAPSHOT_INFO"),
    "COR_PRF_STATIC_TYPE": SimTypeInt(signed=False, label="COR_PRF_STATIC_TYPE"),
    "COR_PRF_SUSPEND_REASON": SimTypeInt(signed=False, label="COR_PRF_SUSPEND_REASON"),
    "COR_PRF_TRANSITION_REASON": SimTypeInt(signed=False, label="COR_PRF_TRANSITION_REASON"),
    "COSERVERINFO": SimStruct(OrderedDict((("dwReserved1", SimTypeInt(signed=False, label="UInt32")), ("pwszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pAuthInfo", SimTypePointer(SimTypeRef("COAUTHINFO", SimStruct), offset=0)), ("dwReserved2", SimTypeInt(signed=False, label="UInt32")),)), name="COSERVERINFO", pack=False, align=None),
    "COUNTED_REASON_CONTEXT": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"Anonymous": SimStruct(OrderedDict((("ResourceFileName", SimTypeRef("UNICODE_STRING", SimStruct)), ("ResourceReasonId", SimTypeShort(signed=False, label="UInt16")), ("StringCount", SimTypeInt(signed=False, label="UInt32")), ("ReasonStrings", SimTypePointer(SimTypeRef("UNICODE_STRING", SimStruct), offset=0)),)), name="_Anonymous_e__Struct", pack=False, align=None), "SimpleString": SimTypeRef("UNICODE_STRING", SimStruct)}, name="<anon>", label="None")),)), name="COUNTED_REASON_CONTEXT", pack=False, align=None),
    "COWAIT_FLAGS": SimTypeInt(signed=False, label="COWAIT_FLAGS"),
    "CO_ADDRESS": SimStruct(OrderedDict((("AddressSize", SimTypeInt(signed=False, label="UInt32")), ("Address", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CO_ADDRESS", pack=False, align=None),
    "CO_ADDRESS_FAMILY": SimStruct(OrderedDict((("AddressFamily", SimTypeInt(signed=False, label="UInt32")), ("MajorVersion", SimTypeInt(signed=False, label="UInt32")), ("MinorVersion", SimTypeInt(signed=False, label="UInt32")),)), name="CO_ADDRESS_FAMILY", pack=False, align=None),
    "CO_ADDRESS_LIST": SimStruct(OrderedDict((("NumberOfAddressesAvailable", SimTypeInt(signed=False, label="UInt32")), ("NumberOfAddresses", SimTypeInt(signed=False, label="UInt32")), ("AddressList", SimTypeRef("CO_ADDRESS", SimStruct)),)), name="CO_ADDRESS_LIST", pack=False, align=None),
    "CO_AF_REGISTER_NOTIFY_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0),
    "CO_CALL_MANAGER_PARAMETERS": SimStruct(OrderedDict((("Transmit", SimTypeRef("FLOWSPEC", SimStruct)), ("Receive", SimTypeRef("FLOWSPEC", SimStruct)), ("CallMgrSpecific", SimTypeRef("CO_SPECIFIC_PARAMETERS", SimStruct)),)), name="CO_CALL_MANAGER_PARAMETERS", pack=False, align=None),
    "CO_CALL_PARAMETERS": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "CO_CREATE_VC_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CO_DELETE_VC_HANDLER": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CO_DEVICE_CATALOG_COOKIE": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "CO_MARSHALING_CONTEXT_ATTRIBUTES": SimTypeInt(signed=False, label="CO_MARSHALING_CONTEXT_ATTRIBUTES"),
    "CO_MEDIA_PARAMETERS": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "CO_MTA_USAGE_COOKIE": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "CO_PVC": SimStruct(OrderedDict((("NdisAfHandle", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("PvcParameters", SimTypeRef("CO_SPECIFIC_PARAMETERS", SimStruct)),)), name="CO_PVC", pack=False, align=None),
    "CO_SAP": SimStruct(OrderedDict((("SapType", SimTypeInt(signed=False, label="UInt32")), ("SapLength", SimTypeInt(signed=False, label="UInt32")), ("Sap", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CO_SAP", pack=False, align=None),
    "CO_SPECIFIC_PARAMETERS": SimStruct(OrderedDict((("ParamType", SimTypeInt(signed=False, label="UInt32")), ("Length", SimTypeInt(signed=False, label="UInt32")), ("Parameters", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CO_SPECIFIC_PARAMETERS", pack=False, align=None),
    "CPE_DRIVER_INFO": SimStruct(OrderedDict((("ExceptionCallback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeRef("MCA_EXCEPTION", SimStruct), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context", "CmcLog"]), offset=0)), ("DpcCallback", SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0)), ("DeviceContext", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CPE_DRIVER_INFO", pack=False, align=None),
    "CPEventBitShift": SimTypeInt(signed=False, label="CPEventBitShift"),
    "CPEvents": SimTypeInt(signed=False, label="CPEvents"),
    "CPINFO": SimStruct(OrderedDict((("MaxCharSize", SimTypeInt(signed=False, label="UInt32")), ("DefaultChar", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("LeadByte", SimTypeArray(SimTypeChar(label="Byte"), 12)),)), name="CPINFO", pack=False, align=None),
    "CPINFOEXA": SimStruct(OrderedDict((("MaxCharSize", SimTypeInt(signed=False, label="UInt32")), ("DefaultChar", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("LeadByte", SimTypeArray(SimTypeChar(label="Byte"), 12)), ("UnicodeDefaultChar", SimTypeChar(label="Char")), ("CodePage", SimTypeInt(signed=False, label="UInt32")), ("CodePageName", SimTypeArray(SimTypeChar(label="SByte"), 260)),)), name="CPINFOEXA", pack=False, align=None),
    "CPINFOEXW": SimStruct(OrderedDict((("MaxCharSize", SimTypeInt(signed=False, label="UInt32")), ("DefaultChar", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("LeadByte", SimTypeArray(SimTypeChar(label="Byte"), 12)), ("UnicodeDefaultChar", SimTypeChar(label="Char")), ("CodePage", SimTypeInt(signed=False, label="UInt32")), ("CodePageName", SimTypeArray(SimTypeChar(label="Char"), 260)),)), name="CPINFOEXW", pack=False, align=None),
    "CPLINFO": SimStruct(OrderedDict((("idIcon", SimTypeInt(signed=True, label="Int32")), ("idName", SimTypeInt(signed=True, label="Int32")), ("idInfo", SimTypeInt(signed=True, label="Int32")), ("lData", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CPLINFO", pack=False, align=None),
    "CPOINT": SimStruct(OrderedDict((("lP", SimTypeInt(signed=True, label="Int32")), ("dwLog", SimTypeInt(signed=False, label="UInt32")),)), name="CPOINT", pack=False, align=None),
    "CPRecordingStatus": SimTypeInt(signed=False, label="CPRecordingStatus"),
    "CPSUICBPARAM": SimStruct(OrderedDict((("cbSize", SimTypeShort(signed=False, label="UInt16")), ("Reason", SimTypeShort(signed=False, label="UInt16")), ("hDlg", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pOptItem", SimTypePointer(SimTypeRef("OPTITEM", SimStruct), offset=0)), ("cOptItem", SimTypeShort(signed=False, label="UInt16")), ("Flags", SimTypeShort(signed=False, label="UInt16")), ("pCurItem", SimTypePointer(SimTypeRef("OPTITEM", SimStruct), offset=0)), ("Anonymous", SimUnion({"OldSel": SimTypeInt(signed=True, label="Int32"), "pOldSel": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="<anon>", label="None")), ("UserData", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("Result", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="CPSUICBPARAM", pack=False, align=None),
    "CPSUIDATABLOCK": SimStruct(OrderedDict((("cbData", SimTypeInt(signed=False, label="UInt32")), ("pbData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CPSUIDATABLOCK", pack=False, align=None),
    "CPS_URLS": SimStruct(OrderedDict((("pszURL", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pAlgorithm", SimTypePointer(SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct), offset=0)), ("pDigest", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)),)), name="CPS_URLS", pack=False, align=None),
    "CPTABLEINFO": SimStruct(OrderedDict((("CodePage", SimTypeShort(signed=False, label="UInt16")), ("MaximumCharacterSize", SimTypeShort(signed=False, label="UInt16")), ("DefaultChar", SimTypeShort(signed=False, label="UInt16")), ("UniDefaultChar", SimTypeShort(signed=False, label="UInt16")), ("TransDefaultChar", SimTypeShort(signed=False, label="UInt16")), ("TransUniDefaultChar", SimTypeShort(signed=False, label="UInt16")), ("DBCSCodePage", SimTypeShort(signed=False, label="UInt16")), ("LeadByte", SimTypeArray(SimTypeChar(label="Byte"), 12)), ("MultiByteTable", SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)), ("WideCharTable", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("DBCSRanges", SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)), ("DBCSOffsets", SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)),)), name="CPTABLEINFO", pack=False, align=None),
    "CPU_ARCHITECTURE": SimTypeInt(signed=False, label="CPU_ARCHITECTURE"),
    "CPU_INFO": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="UInt32")), ("NumCPUs", SimTypeInt(signed=False, label="UInt32")), ("CurrentProc", SimTypeInt(signed=False, label="UInt32")), ("ProcInfo", SimTypeArray(SimUnion({"Alpha": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_ALPHA", SimStruct), "Amd64": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_AMD64", SimStruct), "Ia64": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_IA64", SimStruct), "X86": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_X86", SimStruct), "Arm": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_ARM", SimStruct), "Arm64": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_ARM64", SimStruct)}, name="<anon>", label="None"), 2048)), ("Mhz", SimTypeInt(signed=False, label="UInt32")),)), name="CPU_INFO", pack=False, align=None),
    "CPU_INFORMATION": SimUnion({"X86CpuInfo": SimTypeRef("_X86CpuInfo_e__Struct", SimStruct), "OtherCpuInfo": SimTypeRef("_OtherCpuInfo_e__Struct", SimStruct)}, name="<anon>", label="None"),
    "CPU_INFO_v1": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="UInt32")), ("NumCPUs", SimTypeInt(signed=False, label="UInt32")), ("CurrentProc", SimTypeInt(signed=False, label="UInt32")), ("ProcInfo", SimTypeArray(SimUnion({"Alpha": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_ALPHA", SimStruct), "Amd64": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_AMD64", SimStruct), "Ia64": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_IA64", SimStruct), "X86": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_X86", SimStruct), "Arm": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_ARM", SimStruct), "Arm64": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_ARM64", SimStruct)}, name="<anon>", label="None"), 32)), ("Mhz", SimTypeInt(signed=False, label="UInt32")),)), name="CPU_INFO_v1", pack=False, align=None),
    "CPU_INFO_v2": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="UInt32")), ("NumCPUs", SimTypeInt(signed=False, label="UInt32")), ("CurrentProc", SimTypeInt(signed=False, label="UInt32")), ("ProcInfo", SimTypeArray(SimUnion({"Alpha": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_ALPHA", SimStruct), "Amd64": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_AMD64", SimStruct), "Ia64": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_IA64", SimStruct), "X86": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_X86", SimStruct), "Arm": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_ARM", SimStruct), "Arm64": SimTypeRef("DEBUG_PROCESSOR_IDENTIFICATION_ARM64", SimStruct)}, name="<anon>", label="None"), 1280)), ("Mhz", SimTypeInt(signed=False, label="UInt32")),)), name="CPU_INFO_v2", pack=False, align=None),
    "CPU_SET_INFORMATION_TYPE": SimTypeInt(signed=False, label="CPU_SET_INFORMATION_TYPE"),
    "CPVIEW": SimTypeInt(signed=False, label="CPVIEW"),
    "CProperty": SimStruct(OrderedDict((("dwPropID", SimTypeInt(signed=False, label="UInt32")), ("cbData", SimTypeInt(signed=False, label="UInt32")), ("dwType", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"lpszwData": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwValue": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("fPersist", SimTypeInt(signed=True, label="Int32")),)), name="CProperty", pack=False, align=None),
    "CQFORM": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("clsid", SimTypeBottom(label="Guid")), ("hIcon", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pszTitle", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CQFORM", pack=False, align=None),
    "CQPAGE": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("pPageProc", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CQPAGE", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPage", "hwnd", "uMsg", "wParam", "lParam"]), offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("idPageName", SimTypeInt(signed=True, label="Int32")), ("idPageTemplate", SimTypeInt(signed=True, label="Int32")), ("pDlgProc", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0)), ("lParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CQPAGE", pack=False, align=None),
    "CRASHDUMP_FUNCTIONS_INTERFACE": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Context", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("InterfaceReference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("InterfaceDereference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("PowerOn", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Context"]), offset=0)),)), name="CRASHDUMP_FUNCTIONS_INTERFACE", pack=False, align=None),
    "CREATEFILE2_EXTENDED_PARAMETERS": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwFileAttributes", SimTypeInt(signed=False, label="UInt32")), ("dwFileFlags", SimTypeInt(signed=False, label="UInt32")), ("dwSecurityQosFlags", SimTypeInt(signed=False, label="UInt32")), ("lpSecurityAttributes", SimTypePointer(SimTypeRef("SECURITY_ATTRIBUTES", SimStruct), offset=0)), ("hTemplateFile", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CREATEFILE2_EXTENDED_PARAMETERS", pack=False, align=None),
    "CREATELINKSTATES": SimTypeInt(signed=False, label="CREATELINKSTATES"),
    "CREATESTRUCTA": SimStruct(OrderedDict((("lpCreateParams", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hMenu", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("cy", SimTypeInt(signed=True, label="Int32")), ("cx", SimTypeInt(signed=True, label="Int32")), ("y", SimTypeInt(signed=True, label="Int32")), ("x", SimTypeInt(signed=True, label="Int32")), ("style", SimTypeInt(signed=True, label="Int32")), ("lpszName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpszClass", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwExStyle", SimTypeInt(signed=False, label="UInt32")),)), name="CREATESTRUCTA", pack=False, align=None),
    "CREATESTRUCTW": SimStruct(OrderedDict((("lpCreateParams", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("hInstance", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hMenu", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("cy", SimTypeInt(signed=True, label="Int32")), ("cx", SimTypeInt(signed=True, label="Int32")), ("y", SimTypeInt(signed=True, label="Int32")), ("x", SimTypeInt(signed=True, label="Int32")), ("style", SimTypeInt(signed=True, label="Int32")), ("lpszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpszClass", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwExStyle", SimTypeInt(signed=False, label="UInt32")),)), name="CREATESTRUCTW", pack=False, align=None),
    "CREATESUBSCRIPTIONFLAGS": SimTypeInt(signed=False, label="CREATESUBSCRIPTIONFLAGS"),
    "CREATE_ASM_NAME_OBJ_FLAGS": SimTypeInt(signed=False, label="CREATE_ASM_NAME_OBJ_FLAGS"),
    "CREATE_CLUSTER_CONFIG": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("lpszClusterName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cNodes", SimTypeInt(signed=False, label="UInt32")), ("ppszNodeNames", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)), ("cIpEntries", SimTypeInt(signed=False, label="UInt32")), ("pIpEntries", SimTypePointer(SimTypeRef("CLUSTER_IP_ENTRY", SimStruct), offset=0)), ("fEmptyCluster", SimTypeChar(label="Byte")), ("managementPointType", SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_TYPE")), ("managementPointResType", SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_RESTYPE")),)), name="CREATE_CLUSTER_CONFIG", pack=False, align=None),
    "CREATE_CLUSTER_NAME_ACCOUNT": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("lpszClusterName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("pszUserName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszPassword", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszDomain", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("managementPointType", SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_TYPE")), ("managementPointResType", SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_RESTYPE")), ("bUpgradeVCOs", SimTypeChar(label="Byte")),)), name="CREATE_CLUSTER_NAME_ACCOUNT", pack=False, align=None),
    "CREATE_DISK": SimStruct(OrderedDict((("PartitionStyle", SimTypeInt(signed=False, label="PARTITION_STYLE")), ("Anonymous", SimUnion({"Mbr": SimTypeRef("CREATE_DISK_MBR", SimStruct), "Gpt": SimTypeRef("CREATE_DISK_GPT", SimStruct)}, name="<anon>", label="None")),)), name="CREATE_DISK", pack=False, align=None),
    "CREATE_DISK_GPT": SimStruct(OrderedDict((("DiskId", SimTypeBottom(label="Guid")), ("MaxPartitionCount", SimTypeInt(signed=False, label="UInt32")),)), name="CREATE_DISK_GPT", pack=False, align=None),
    "CREATE_DISK_MBR": SimStruct(OrderedDict((("Signature", SimTypeInt(signed=False, label="UInt32")),)), name="CREATE_DISK_MBR", pack=False, align=None),
    "CREATE_EVENT": SimTypeInt(signed=False, label="CREATE_EVENT"),
    "CREATE_FILE_TYPE": SimTypeInt(signed=False, label="CREATE_FILE_TYPE"),
    "CREATE_FONT_PACKAGE_SUBSET_ENCODING": SimTypeInt(signed=False, label="CREATE_FONT_PACKAGE_SUBSET_ENCODING"),
    "CREATE_FONT_PACKAGE_SUBSET_PLATFORM": SimTypeInt(signed=False, label="CREATE_FONT_PACKAGE_SUBSET_PLATFORM"),
    "CREATE_PARTITION_PARAMETERS": SimStruct(OrderedDict((("style", SimTypeInt(signed=False, label="VDS_PARTITION_STYLE")), ("Anonymous", SimUnion({"MbrPartInfo": SimTypeRef("_MbrPartInfo_e__Struct", SimStruct), "GptPartInfo": SimTypeRef("_GptPartInfo_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="CREATE_PARTITION_PARAMETERS", pack=False, align=None),
    "CREATE_POLYGON_RGN_MODE": SimTypeInt(signed=False, label="CREATE_POLYGON_RGN_MODE"),
    "CREATE_PROCESS_DEBUG_INFO": SimStruct(OrderedDict((("hFile", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hProcess", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hThread", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpBaseOfImage", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("dwDebugInfoFileOffset", SimTypeInt(signed=False, label="UInt32")), ("nDebugInfoSize", SimTypeInt(signed=False, label="UInt32")), ("lpThreadLocalBase", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("lpStartAddress", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpThreadParameter"]), offset=0)), ("lpImageName", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("fUnicode", SimTypeShort(signed=False, label="UInt16")),)), name="CREATE_PROCESS_DEBUG_INFO", pack=False, align=None),
    "CREATE_PROCESS_LOGON_FLAGS": SimTypeInt(signed=False, label="CREATE_PROCESS_LOGON_FLAGS"),
    "CREATE_REDIRECTION_ECP_CONTEXT": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Flags", SimTypeShort(signed=False, label="UInt16")), ("FileId", SimTypeRef("FILE_ID_128", SimStruct)), ("VolumeGuid", SimTypeBottom(label="Guid")),)), name="CREATE_REDIRECTION_ECP_CONTEXT", pack=False, align=None),
    "CREATE_RESTRICTED_TOKEN_FLAGS": SimTypeInt(signed=False, label="CREATE_RESTRICTED_TOKEN_FLAGS"),
    "CREATE_TAPE_PARTITION_METHOD": SimTypeInt(signed=False, label="CREATE_TAPE_PARTITION_METHOD"),
    "CREATE_THREAD_DEBUG_INFO": SimStruct(OrderedDict((("hThread", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lpThreadLocalBase", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("lpStartAddress", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpThreadParameter"]), offset=0)),)), name="CREATE_THREAD_DEBUG_INFO", pack=False, align=None),
    "CREATE_TOOLHELP_SNAPSHOT_FLAGS": SimTypeInt(signed=False, label="CREATE_TOOLHELP_SNAPSHOT_FLAGS"),
    "CREATE_USER_PROCESS_ECP_CONTEXT": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Reserved", SimTypeShort(signed=False, label="UInt16")), ("AccessToken", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CREATE_USER_PROCESS_ECP_CONTEXT", pack=False, align=None),
    "CREATE_USN_JOURNAL_DATA": SimStruct(OrderedDict((("MaximumSize", SimTypeLongLong(signed=False, label="UInt64")), ("AllocationDelta", SimTypeLongLong(signed=False, label="UInt64")),)), name="CREATE_USN_JOURNAL_DATA", pack=False, align=None),
    "CREATE_VIRTUAL_DISK_FLAG": SimTypeInt(signed=False, label="CREATE_VIRTUAL_DISK_FLAG"),
    "CREATE_VIRTUAL_DISK_PARAMETERS": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="CREATE_VIRTUAL_DISK_VERSION")), ("Anonymous", SimUnion({"Version1": SimTypeRef("_Version1_e__Struct", SimStruct), "Version2": SimTypeRef("_Version2_e__Struct", SimStruct), "Version3": SimTypeRef("_Version3_e__Struct", SimStruct), "Version4": SimTypeRef("_Version4_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="CREATE_VIRTUAL_DISK_PARAMETERS", pack=False, align=None),
    "CREATE_VIRTUAL_DISK_VERSION": SimTypeInt(signed=False, label="CREATE_VIRTUAL_DISK_VERSION"),
    "CREATIVEADPCMWAVEFORMAT": SimStruct(OrderedDict((("wfx", SimTypeRef("WAVEFORMATEX", SimStruct)), ("wRevision", SimTypeShort(signed=False, label="UInt16")),)), name="CREATIVEADPCMWAVEFORMAT", pack=False, align=None),
    "CREATIVEFASTSPEECH10WAVEFORMAT": SimStruct(OrderedDict((("wfx", SimTypeRef("WAVEFORMATEX", SimStruct)), ("wRevision", SimTypeShort(signed=False, label="UInt16")),)), name="CREATIVEFASTSPEECH10WAVEFORMAT", pack=False, align=None),
    "CREATIVEFASTSPEECH8WAVEFORMAT": SimStruct(OrderedDict((("wfx", SimTypeRef("WAVEFORMATEX", SimStruct)), ("wRevision", SimTypeShort(signed=False, label="UInt16")),)), name="CREATIVEFASTSPEECH8WAVEFORMAT", pack=False, align=None),
    "CREDENTIALA": SimStruct(OrderedDict((("Flags", SimTypeInt(signed=False, label="CRED_FLAGS")), ("Type", SimTypeInt(signed=False, label="CRED_TYPE")), ("TargetName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Comment", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("LastWritten", SimTypeRef("FILETIME", SimStruct)), ("CredentialBlobSize", SimTypeInt(signed=False, label="UInt32")), ("CredentialBlob", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Persist", SimTypeInt(signed=False, label="CRED_PERSIST")), ("AttributeCount", SimTypeInt(signed=False, label="UInt32")), ("Attributes", SimTypePointer(SimTypeRef("CREDENTIAL_ATTRIBUTEA", SimStruct), offset=0)), ("TargetAlias", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("UserName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CREDENTIALA", pack=False, align=None),
    "CREDENTIALW": SimStruct(OrderedDict((("Flags", SimTypeInt(signed=False, label="CRED_FLAGS")), ("Type", SimTypeInt(signed=False, label="CRED_TYPE")), ("TargetName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Comment", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("LastWritten", SimTypeRef("FILETIME", SimStruct)), ("CredentialBlobSize", SimTypeInt(signed=False, label="UInt32")), ("CredentialBlob", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Persist", SimTypeInt(signed=False, label="CRED_PERSIST")), ("AttributeCount", SimTypeInt(signed=False, label="UInt32")), ("Attributes", SimTypePointer(SimTypeRef("CREDENTIAL_ATTRIBUTEW", SimStruct), offset=0)), ("TargetAlias", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("UserName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CREDENTIALW", pack=False, align=None),
    "CREDENTIAL_ATTRIBUTEA": SimStruct(OrderedDict((("Keyword", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("ValueSize", SimTypeInt(signed=False, label="UInt32")), ("Value", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CREDENTIAL_ATTRIBUTEA", pack=False, align=None),
    "CREDENTIAL_ATTRIBUTEW": SimStruct(OrderedDict((("Keyword", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("ValueSize", SimTypeInt(signed=False, label="UInt32")), ("Value", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CREDENTIAL_ATTRIBUTEW", pack=False, align=None),
    "CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS": SimTypeInt(signed=False, label="CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS"),
    "CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS": SimTypeInt(signed=False, label="CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS"),
    "CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION": SimStruct(OrderedDict((("ulAuthenticationPackage", SimTypeInt(signed=False, label="UInt32")), ("clsidCredentialProvider", SimTypeBottom(label="Guid")), ("cbSerialization", SimTypeInt(signed=False, label="UInt32")), ("rgbSerialization", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION", pack=False, align=None),
    "CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR": SimStruct(OrderedDict((("dwFieldID", SimTypeInt(signed=False, label="UInt32")), ("cpft", SimTypeInt(signed=False, label="CREDENTIAL_PROVIDER_FIELD_TYPE")), ("pszLabel", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("guidFieldType", SimTypeBottom(label="Guid")),)), name="CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR", pack=False, align=None),
    "CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE": SimTypeInt(signed=False, label="CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE"),
    "CREDENTIAL_PROVIDER_FIELD_STATE": SimTypeInt(signed=False, label="CREDENTIAL_PROVIDER_FIELD_STATE"),
    "CREDENTIAL_PROVIDER_FIELD_TYPE": SimTypeInt(signed=False, label="CREDENTIAL_PROVIDER_FIELD_TYPE"),
    "CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE": SimTypeInt(signed=False, label="CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE"),
    "CREDENTIAL_PROVIDER_STATUS_ICON": SimTypeInt(signed=False, label="CREDENTIAL_PROVIDER_STATUS_ICON"),
    "CREDENTIAL_PROVIDER_USAGE_SCENARIO": SimTypeInt(signed=False, label="CREDENTIAL_PROVIDER_USAGE_SCENARIO"),
    "CREDENTIAL_TARGET_INFORMATIONA": SimStruct(OrderedDict((("TargetName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("NetbiosServerName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("DnsServerName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("NetbiosDomainName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("DnsDomainName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("DnsTreeName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("PackageName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("CredTypeCount", SimTypeInt(signed=False, label="UInt32")), ("CredTypes", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="CREDENTIAL_TARGET_INFORMATIONA", pack=False, align=None),
    "CREDENTIAL_TARGET_INFORMATIONW": SimStruct(OrderedDict((("TargetName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("NetbiosServerName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("DnsServerName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("NetbiosDomainName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("DnsDomainName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("DnsTreeName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("PackageName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("CredTypeCount", SimTypeInt(signed=False, label="UInt32")), ("CredTypes", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="CREDENTIAL_TARGET_INFORMATIONW", pack=False, align=None),
    "CREDSPP_SUBMIT_TYPE": SimTypeInt(signed=False, label="CREDSPP_SUBMIT_TYPE"),
    "CREDSSP_CRED": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="CREDSPP_SUBMIT_TYPE")), ("pSchannelCred", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pSpnegoCred", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CREDSSP_CRED", pack=False, align=None),
    "CREDSSP_CRED_EX": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="CREDSPP_SUBMIT_TYPE")), ("Version", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("Reserved", SimTypeInt(signed=False, label="UInt32")), ("Cred", SimTypeRef("CREDSSP_CRED", SimStruct)),)), name="CREDSSP_CRED_EX", pack=False, align=None),
    "CREDUIWIN_FLAGS": SimTypeInt(signed=False, label="CREDUIWIN_FLAGS"),
    "CREDUI_FLAGS": SimTypeInt(signed=False, label="CREDUI_FLAGS"),
    "CREDUI_INFOA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pszMessageText", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pszCaptionText", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("hbmBanner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CREDUI_INFOA", pack=False, align=None),
    "CREDUI_INFOW": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pszMessageText", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszCaptionText", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("hbmBanner", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CREDUI_INFOW", pack=False, align=None),
    "CRED_ENUMERATE_FLAGS": SimTypeInt(signed=False, label="CRED_ENUMERATE_FLAGS"),
    "CRED_FETCH": SimTypeInt(signed=False, label="CRED_FETCH"),
    "CRED_FLAGS": SimTypeInt(signed=False, label="CRED_FLAGS"),
    "CRED_MARSHAL_TYPE": SimTypeInt(signed=False, label="CRED_MARSHAL_TYPE"),
    "CRED_PACK_FLAGS": SimTypeInt(signed=False, label="CRED_PACK_FLAGS"),
    "CRED_PERSIST": SimTypeInt(signed=False, label="CRED_PERSIST"),
    "CRED_PROTECTION_TYPE": SimTypeInt(signed=False, label="CRED_PROTECTION_TYPE"),
    "CRED_TYPE": SimTypeInt(signed=False, label="CRED_TYPE"),
    "CRID_LOCATION": SimTypeInt(signed=False, label="CRID_LOCATION"),
    "CRITICAL_SECTION": SimStruct(OrderedDict((("DebugInfo", SimTypePointer(SimTypeRef("CRITICAL_SECTION_DEBUG", SimStruct), offset=0)), ("LockCount", SimTypeInt(signed=True, label="Int32")), ("RecursionCount", SimTypeInt(signed=True, label="Int32")), ("OwningThread", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("LockSemaphore", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("SpinCount", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="CRITICAL_SECTION", pack=False, align=None),
    "CRITICAL_SECTION_DEBUG": SimStruct(OrderedDict((("Type", SimTypeShort(signed=False, label="UInt16")), ("CreatorBackTraceIndex", SimTypeShort(signed=False, label="UInt16")), ("CriticalSection", SimTypePointer(SimTypeRef("CRITICAL_SECTION", SimStruct), offset=0)), ("ProcessLocksList", SimTypeRef("LIST_ENTRY", SimStruct)), ("EntryCount", SimTypeInt(signed=False, label="UInt32")), ("ContentionCount", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("CreatorBackTraceIndexHigh", SimTypeShort(signed=False, label="UInt16")), ("Identifier", SimTypeShort(signed=False, label="UInt16")),)), name="CRITICAL_SECTION_DEBUG", pack=False, align=None),
    "CRLRevocationReason": SimTypeInt(signed=False, label="CRLRevocationReason"),
    "CRL_CONTEXT": SimStruct(OrderedDict((("dwCertEncodingType", SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE")), ("pbCrlEncoded", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbCrlEncoded", SimTypeInt(signed=False, label="UInt32")), ("pCrlInfo", SimTypePointer(SimTypeRef("CRL_INFO", SimStruct), offset=0)), ("hCertStore", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRL_CONTEXT", pack=False, align=None),
    "CRL_DIST_POINT": SimStruct(OrderedDict((("DistPointName", SimTypeRef("CRL_DIST_POINT_NAME", SimStruct)), ("ReasonFlags", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)), ("CRLIssuer", SimTypeRef("CERT_ALT_NAME_INFO", SimStruct)),)), name="CRL_DIST_POINT", pack=False, align=None),
    "CRL_DIST_POINTS_INFO": SimStruct(OrderedDict((("cDistPoint", SimTypeInt(signed=False, label="UInt32")), ("rgDistPoint", SimTypePointer(SimTypeRef("CRL_DIST_POINT", SimStruct), offset=0)),)), name="CRL_DIST_POINTS_INFO", pack=False, align=None),
    "CRL_DIST_POINT_NAME": SimStruct(OrderedDict((("dwDistPointNameChoice", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"FullName": SimTypeRef("CERT_ALT_NAME_INFO", SimStruct)}, name="<anon>", label="None")),)), name="CRL_DIST_POINT_NAME", pack=False, align=None),
    "CRL_ENTRY": SimStruct(OrderedDict((("SerialNumber", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("RevocationDate", SimTypeRef("FILETIME", SimStruct)), ("cExtension", SimTypeInt(signed=False, label="UInt32")), ("rgExtension", SimTypePointer(SimTypeRef("CERT_EXTENSION", SimStruct), offset=0)),)), name="CRL_ENTRY", pack=False, align=None),
    "CRL_FIND_ISSUED_FOR_PARA": SimStruct(OrderedDict((("pSubjectCert", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("pIssuerCert", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)),)), name="CRL_FIND_ISSUED_FOR_PARA", pack=False, align=None),
    "CRL_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("SignatureAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("Issuer", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("ThisUpdate", SimTypeRef("FILETIME", SimStruct)), ("NextUpdate", SimTypeRef("FILETIME", SimStruct)), ("cCRLEntry", SimTypeInt(signed=False, label="UInt32")), ("rgCRLEntry", SimTypePointer(SimTypeRef("CRL_ENTRY", SimStruct), offset=0)), ("cExtension", SimTypeInt(signed=False, label="UInt32")), ("rgExtension", SimTypePointer(SimTypeRef("CERT_EXTENSION", SimStruct), offset=0)),)), name="CRL_INFO", pack=False, align=None),
    "CRL_ISSUING_DIST_POINT": SimStruct(OrderedDict((("DistPointName", SimTypeRef("CRL_DIST_POINT_NAME", SimStruct)), ("fOnlyContainsUserCerts", SimTypeInt(signed=True, label="Int32")), ("fOnlyContainsCACerts", SimTypeInt(signed=True, label="Int32")), ("OnlySomeReasonFlags", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)), ("fIndirectCRL", SimTypeInt(signed=True, label="Int32")),)), name="CRL_ISSUING_DIST_POINT", pack=False, align=None),
    "CRL_REVOCATION_INFO": SimStruct(OrderedDict((("pCrlEntry", SimTypePointer(SimTypeRef("CRL_ENTRY", SimStruct), offset=0)), ("pCrlContext", SimTypePointer(SimTypeRef("CRL_CONTEXT", SimStruct), offset=0)), ("pCrlIssuerChain", SimTypePointer(SimTypeRef("CERT_CHAIN_CONTEXT", SimStruct), offset=0)),)), name="CRL_REVOCATION_INFO", pack=False, align=None),
    "CRMFLAGS": SimTypeInt(signed=False, label="CRMFLAGS"),
    "CRMREGFLAGS": SimTypeInt(signed=False, label="CRMREGFLAGS"),
    "CROSSBAR_DEFAULT_FLAGS": SimTypeInt(signed=False, label="CROSSBAR_DEFAULT_FLAGS"),
    "CROSS_CERT_DIST_POINTS_INFO": SimStruct(OrderedDict((("dwSyncDeltaTime", SimTypeInt(signed=False, label="UInt32")), ("cDistPoint", SimTypeInt(signed=False, label="UInt32")), ("rgDistPoint", SimTypePointer(SimTypeRef("CERT_ALT_NAME_INFO", SimStruct), offset=0)),)), name="CROSS_CERT_DIST_POINTS_INFO", pack=False, align=None),
    "CROSS_SLIDE_FLAGS": SimTypeInt(signed=False, label="CROSS_SLIDE_FLAGS"),
    "CROSS_SLIDE_PARAMETER": SimStruct(OrderedDict((("threshold", SimTypeInt(signed=False, label="CROSS_SLIDE_THRESHOLD")), ("distance", SimTypeFloat(size=32)),)), name="CROSS_SLIDE_PARAMETER", pack=False, align=None),
    "CROSS_SLIDE_THRESHOLD": SimTypeInt(signed=False, label="CROSS_SLIDE_THRESHOLD"),
    "CRYPTCATATTRIBUTE": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("pwszReferenceTag", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwAttrTypeAndAction", SimTypeInt(signed=False, label="UInt32")), ("cbValue", SimTypeInt(signed=False, label="UInt32")), ("pbValue", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwReserved", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPTCATATTRIBUTE", pack=False, align=None),
    "CRYPTCATCDF": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("hFile", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("dwCurFilePos", SimTypeInt(signed=False, label="UInt32")), ("dwLastMemberOffset", SimTypeInt(signed=False, label="UInt32")), ("fEOF", SimTypeInt(signed=True, label="Int32")), ("pwszResultDir", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("hCATStore", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CRYPTCATCDF", pack=False, align=None),
    "CRYPTCATMEMBER": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("pwszReferenceTag", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pwszFileName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("gSubjectType", SimTypeBottom(label="Guid")), ("fdwMemberFlags", SimTypeInt(signed=False, label="UInt32")), ("pIndirectData", SimTypePointer(SimTypeRef("SIP_INDIRECT_DATA", SimStruct), offset=0)), ("dwCertVersion", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeInt(signed=False, label="UInt32")), ("hReserved", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("sEncodedIndirectData", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("sEncodedMemberInfo", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPTCATMEMBER", pack=False, align=None),
    "CRYPTCATSTORE": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("dwPublicVersion", SimTypeInt(signed=False, label="UInt32")), ("pwszP7File", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("hProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("dwEncodingType", SimTypeInt(signed=False, label="UInt32")), ("fdwStoreFlags", SimTypeInt(signed=False, label="CRYPTCAT_OPEN_FLAGS")), ("hReserved", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hAttrs", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("hCryptMsg", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("hSorted", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CRYPTCATSTORE", pack=False, align=None),
    "CRYPTCAT_OPEN_FLAGS": SimTypeInt(signed=False, label="CRYPTCAT_OPEN_FLAGS"),
    "CRYPTCAT_VERSION": SimTypeInt(signed=False, label="CRYPTCAT_VERSION"),
    "CRYPTNET_URL_CACHE_FLUSH_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwExemptSeconds", SimTypeInt(signed=False, label="UInt32")), ("ExpireTime", SimTypeRef("FILETIME", SimStruct)),)), name="CRYPTNET_URL_CACHE_FLUSH_INFO", pack=False, align=None),
    "CRYPTNET_URL_CACHE_PRE_FETCH_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwObjectType", SimTypeInt(signed=False, label="UInt32")), ("dwError", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeInt(signed=False, label="UInt32")), ("ThisUpdateTime", SimTypeRef("FILETIME", SimStruct)), ("NextUpdateTime", SimTypeRef("FILETIME", SimStruct)), ("PublishTime", SimTypeRef("FILETIME", SimStruct)),)), name="CRYPTNET_URL_CACHE_PRE_FETCH_INFO", pack=False, align=None),
    "CRYPTNET_URL_CACHE_RESPONSE_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("wResponseType", SimTypeShort(signed=False, label="UInt16")), ("wResponseFlags", SimTypeShort(signed=False, label="UInt16")), ("LastModifiedTime", SimTypeRef("FILETIME", SimStruct)), ("dwMaxAge", SimTypeInt(signed=False, label="UInt32")), ("pwszETag", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwProxyId", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPTNET_URL_CACHE_RESPONSE_INFO", pack=False, align=None),
    "CRYPTO_SETTINGS": SimStruct(OrderedDict((("eAlgorithmUsage", SimTypeInt(signed=False, label="eTlsAlgorithmUsage")), ("strCngAlgId", SimTypeRef("LSA_UNICODE_STRING", SimStruct)), ("cChainingModes", SimTypeInt(signed=False, label="UInt32")), ("rgstrChainingModes", SimTypePointer(SimTypeRef("LSA_UNICODE_STRING", SimStruct), offset=0)), ("dwMinBitLength", SimTypeInt(signed=False, label="UInt32")), ("dwMaxBitLength", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPTO_SETTINGS", pack=False, align=None),
    "CRYPTPROTECT_PROMPTSTRUCT": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwPromptFlags", SimTypeInt(signed=False, label="UInt32")), ("hwndApp", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("szPrompt", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CRYPTPROTECT_PROMPTSTRUCT", pack=False, align=None),
    "CRYPTUI_CERT_MGR_STRUCT": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("pwszTitle", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszInitUsageOID", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CRYPTUI_CERT_MGR_STRUCT", pack=False, align=None),
    "CRYPTUI_INITDIALOG_STRUCT": SimStruct(OrderedDict((("lParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pCertContext", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)),)), name="CRYPTUI_INITDIALOG_STRUCT", pack=False, align=None),
    "CRYPTUI_VIEWCERTIFICATE_FLAGS": SimTypeInt(signed=False, label="CRYPTUI_VIEWCERTIFICATE_FLAGS"),
    "CRYPTUI_VIEWCERTIFICATE_STRUCTA": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("dwFlags", SimTypeInt(signed=False, label="CRYPTUI_VIEWCERTIFICATE_FLAGS")), ("szTitle", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pCertContext", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("rgszPurposes", SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)), ("cPurposes", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"pCryptProviderData": SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0), "hWVTStateData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="<anon>", label="None")), ("fpCryptProviderDataTrustedUsage", SimTypeInt(signed=True, label="Int32")), ("idxSigner", SimTypeInt(signed=False, label="UInt32")), ("idxCert", SimTypeInt(signed=False, label="UInt32")), ("fCounterSigner", SimTypeInt(signed=True, label="Int32")), ("idxCounterSigner", SimTypeInt(signed=False, label="UInt32")), ("cStores", SimTypeInt(signed=False, label="UInt32")), ("rghStores", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("cPropSheetPages", SimTypeInt(signed=False, label="UInt32")), ("rgPropSheetPages", SimTypePointer(SimTypeRef("PROPSHEETPAGEA", SimStruct), offset=0)), ("nStartPage", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPTUI_VIEWCERTIFICATE_STRUCTA", pack=False, align=None),
    "CRYPTUI_VIEWCERTIFICATE_STRUCTW": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("hwndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("dwFlags", SimTypeInt(signed=False, label="CRYPTUI_VIEWCERTIFICATE_FLAGS")), ("szTitle", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pCertContext", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("rgszPurposes", SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)), ("cPurposes", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"pCryptProviderData": SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0), "hWVTStateData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="<anon>", label="None")), ("fpCryptProviderDataTrustedUsage", SimTypeInt(signed=True, label="Int32")), ("idxSigner", SimTypeInt(signed=False, label="UInt32")), ("idxCert", SimTypeInt(signed=False, label="UInt32")), ("fCounterSigner", SimTypeInt(signed=True, label="Int32")), ("idxCounterSigner", SimTypeInt(signed=False, label="UInt32")), ("cStores", SimTypeInt(signed=False, label="UInt32")), ("rghStores", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("cPropSheetPages", SimTypeInt(signed=False, label="UInt32")), ("rgPropSheetPages", SimTypePointer(SimTypeRef("PROPSHEETPAGEW", SimStruct), offset=0)), ("nStartPage", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPTUI_VIEWCERTIFICATE_STRUCTW", pack=False, align=None),
    "CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE": SimTypeInt(signed=False, label="CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE"),
    "CRYPTUI_WIZ_DIGITAL_SIGN": SimTypeInt(signed=False, label="CRYPTUI_WIZ_DIGITAL_SIGN"),
    "CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("pGuidSubject", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)), ("cbBlob", SimTypeInt(signed=False, label="UInt32")), ("pbBlob", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pwszDisplayName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO", pack=False, align=None),
    "CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("pwszSigningCertFileName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwPvkChoice", SimTypeInt(signed=False, label="CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION")), ("Anonymous", SimUnion({"pPvkFileInfo": SimTypePointer(SimTypeRef("CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO", SimStruct), offset=0), "pPvkProvInfo": SimTypePointer(SimTypeRef("CRYPT_KEY_PROV_INFO", SimStruct), offset=0)}, name="<anon>", label="None")),)), name="CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO", pack=False, align=None),
    "CRYPTUI_WIZ_DIGITAL_SIGN_CONTEXT": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("cbBlob", SimTypeInt(signed=False, label="UInt32")), ("pbBlob", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CRYPTUI_WIZ_DIGITAL_SIGN_CONTEXT", pack=False, align=None),
    "CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwAttrFlags", SimTypeInt(signed=False, label="CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE")), ("pwszDescription", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pwszMoreInfoLocation", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszHashAlg", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pwszSigningCertDisplayString", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("hAdditionalCertStore", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("psAuthenticated", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTES", SimStruct), offset=0)), ("psUnauthenticated", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTES", SimStruct), offset=0)),)), name="CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO", pack=False, align=None),
    "CRYPTUI_WIZ_DIGITAL_SIGN_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwSubjectChoice", SimTypeInt(signed=False, label="CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT")), ("Anonymous1", SimUnion({"pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pSignBlobInfo": SimTypePointer(SimTypeRef("CRYPTUI_WIZ_DIGITAL_SIGN_BLOB_INFO", SimStruct), offset=0)}, name="<anon>", label="None")), ("dwSigningCertChoice", SimTypeInt(signed=False, label="CRYPTUI_WIZ_DIGITAL_SIGN")), ("Anonymous2", SimUnion({"pSigningCertContext": SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), "pSigningCertStore": SimTypePointer(SimTypeRef("CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO", SimStruct), offset=0), "pSigningCertPvkInfo": SimTypePointer(SimTypeRef("CRYPTUI_WIZ_DIGITAL_SIGN_CERT_PVK_INFO", SimStruct), offset=0)}, name="<anon>", label="None")), ("pwszTimestampURL", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwAdditionalCertChoice", SimTypeInt(signed=False, label="CRYPTUI_WIZ_DIGITAL_ADDITIONAL_CERT_CHOICE")), ("pSignExtInfo", SimTypePointer(SimTypeRef("CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO", SimStruct), offset=0)),)), name="CRYPTUI_WIZ_DIGITAL_SIGN_INFO", pack=False, align=None),
    "CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("pwszPvkFileName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pwszProvName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwProvType", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE_INFO", pack=False, align=None),
    "CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION": SimTypeInt(signed=False, label="CRYPTUI_WIZ_DIGITAL_SIGN_PVK_OPTION"),
    "CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE": SimTypeInt(signed=False, label="CRYPTUI_WIZ_DIGITAL_SIGN_SIG_TYPE"),
    "CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("cCertStore", SimTypeInt(signed=False, label="UInt32")), ("rghCertStore", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("pFilterCallback", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "pfInitialSelectedCert", "pvCallbackData"]), offset=0)), ("pvCallbackData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPTUI_WIZ_DIGITAL_SIGN_STORE_INFO", pack=False, align=None),
    "CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT": SimTypeInt(signed=False, label="CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT"),
    "CRYPTUI_WIZ_EXPORT_CERTCONTEXT_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwExportFormat", SimTypeInt(signed=False, label="CRYPTUI_WIZ_EXPORT_FORMAT")), ("fExportChain", SimTypeInt(signed=True, label="Int32")), ("fExportPrivateKeys", SimTypeInt(signed=True, label="Int32")), ("pwszPassword", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("fStrongEncryption", SimTypeInt(signed=True, label="Int32")),)), name="CRYPTUI_WIZ_EXPORT_CERTCONTEXT_INFO", pack=False, align=None),
    "CRYPTUI_WIZ_EXPORT_FORMAT": SimTypeInt(signed=False, label="CRYPTUI_WIZ_EXPORT_FORMAT"),
    "CRYPTUI_WIZ_EXPORT_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("pwszExportFileName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwSubjectChoice", SimTypeInt(signed=False, label="CRYPTUI_WIZ_EXPORT_SUBJECT")), ("Anonymous", SimUnion({"pCertContext": SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), "pCTLContext": SimTypePointer(SimTypeRef("CTL_CONTEXT", SimStruct), offset=0), "pCRLContext": SimTypePointer(SimTypeRef("CRL_CONTEXT", SimStruct), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None")), ("cStores", SimTypeInt(signed=False, label="UInt32")), ("rghStores", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)),)), name="CRYPTUI_WIZ_EXPORT_INFO", pack=False, align=None),
    "CRYPTUI_WIZ_EXPORT_SUBJECT": SimTypeInt(signed=False, label="CRYPTUI_WIZ_EXPORT_SUBJECT"),
    "CRYPTUI_WIZ_FLAGS": SimTypeInt(signed=False, label="CRYPTUI_WIZ_FLAGS"),
    "CRYPTUI_WIZ_IMPORT_SRC_INFO": SimStruct(OrderedDict((("dwSize", SimTypeInt(signed=False, label="UInt32")), ("dwSubjectChoice", SimTypeInt(signed=False, label="CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION")), ("Anonymous", SimUnion({"pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pCertContext": SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), "pCTLContext": SimTypePointer(SimTypeRef("CTL_CONTEXT", SimStruct), offset=0), "pCRLContext": SimTypePointer(SimTypeRef("CRL_CONTEXT", SimStruct), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None")), ("dwFlags", SimTypeInt(signed=False, label="CRYPT_KEY_FLAGS")), ("pwszPassword", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CRYPTUI_WIZ_IMPORT_SRC_INFO", pack=False, align=None),
    "CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION": SimTypeInt(signed=False, label="CRYPTUI_WIZ_IMPORT_SUBJECT_OPTION"),
    "CRYPT_3DES_KEY_STATE": SimStruct(OrderedDict((("Key", SimTypeArray(SimTypeChar(label="Byte"), 24)), ("IV", SimTypeArray(SimTypeChar(label="Byte"), 8)), ("Feedback", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="CRYPT_3DES_KEY_STATE", pack=False, align=None),
    "CRYPT_ACQUIRE_FLAGS": SimTypeInt(signed=False, label="CRYPT_ACQUIRE_FLAGS"),
    "CRYPT_AES_128_KEY_STATE": SimStruct(OrderedDict((("Key", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("IV", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("EncryptionState", SimTypeArray(SimTypeChar(label="Byte"), 176)), ("DecryptionState", SimTypeArray(SimTypeChar(label="Byte"), 176)), ("Feedback", SimTypeArray(SimTypeChar(label="Byte"), 16)),)), name="CRYPT_AES_128_KEY_STATE", pack=False, align=None),
    "CRYPT_AES_256_KEY_STATE": SimStruct(OrderedDict((("Key", SimTypeArray(SimTypeChar(label="Byte"), 32)), ("IV", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("EncryptionState", SimTypeArray(SimTypeChar(label="Byte"), 240)), ("DecryptionState", SimTypeArray(SimTypeChar(label="Byte"), 240)), ("Feedback", SimTypeArray(SimTypeChar(label="Byte"), 16)),)), name="CRYPT_AES_256_KEY_STATE", pack=False, align=None),
    "CRYPT_ALGORITHM_IDENTIFIER": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Parameters", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None),
    "CRYPT_ASYNC_RETRIEVAL_COMPLETION": SimStruct(OrderedDict((("pfnCompletion", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pvCompletion", "dwCompletionCode", "pszUrl", "pszObjectOid", "pvObject"]), offset=0)), ("pvCompletion", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPT_ASYNC_RETRIEVAL_COMPLETION", pack=False, align=None),
    "CRYPT_ATTRIBUTE": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cValue", SimTypeInt(signed=False, label="UInt32")), ("rgValue", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)),)), name="CRYPT_ATTRIBUTE", pack=False, align=None),
    "CRYPT_ATTRIBUTES": SimStruct(OrderedDict((("cAttr", SimTypeInt(signed=False, label="UInt32")), ("rgAttr", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE", SimStruct), offset=0)),)), name="CRYPT_ATTRIBUTES", pack=False, align=None),
    "CRYPT_ATTRIBUTE_TYPE_VALUE": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Value", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None),
    "CRYPT_BIT_BLOB": SimStruct(OrderedDict((("cbData", SimTypeInt(signed=False, label="UInt32")), ("pbData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cUnusedBits", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_BIT_BLOB", pack=False, align=None),
    "CRYPT_BLOB_ARRAY": SimStruct(OrderedDict((("cBlob", SimTypeInt(signed=False, label="UInt32")), ("rgBlob", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)),)), name="CRYPT_BLOB_ARRAY", pack=False, align=None),
    "CRYPT_CONTENT_INFO": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Content", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPT_CONTENT_INFO", pack=False, align=None),
    "CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cValue", SimTypeInt(signed=False, label="UInt32")), ("rgValue", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)),)), name="CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY", pack=False, align=None),
    "CRYPT_CONTEXTS": SimStruct(OrderedDict((("cContexts", SimTypeInt(signed=False, label="UInt32")), ("rgpszContexts", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="CRYPT_CONTEXTS", pack=False, align=None),
    "CRYPT_CONTEXT_CONFIG": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="CRYPT_CONTEXT_CONFIG_FLAGS")), ("dwReserved", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_CONTEXT_CONFIG", pack=False, align=None),
    "CRYPT_CONTEXT_CONFIG_FLAGS": SimTypeInt(signed=False, label="CRYPT_CONTEXT_CONFIG_FLAGS"),
    "CRYPT_CONTEXT_FUNCTIONS": SimStruct(OrderedDict((("cFunctions", SimTypeInt(signed=False, label="UInt32")), ("rgpszFunctions", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="CRYPT_CONTEXT_FUNCTIONS", pack=False, align=None),
    "CRYPT_CONTEXT_FUNCTION_CONFIG": SimStruct(OrderedDict((("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_CONTEXT_FUNCTION_CONFIG", pack=False, align=None),
    "CRYPT_CONTEXT_FUNCTION_PROVIDERS": SimStruct(OrderedDict((("cProviders", SimTypeInt(signed=False, label="UInt32")), ("rgpszProviders", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="CRYPT_CONTEXT_FUNCTION_PROVIDERS", pack=False, align=None),
    "CRYPT_CREDENTIALS": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pszCredentialsOid", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pvCredentials", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPT_CREDENTIALS", pack=False, align=None),
    "CRYPT_CSP_PROVIDER": SimStruct(OrderedDict((("dwKeySpec", SimTypeInt(signed=False, label="UInt32")), ("pwszProviderName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Signature", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)),)), name="CRYPT_CSP_PROVIDER", pack=False, align=None),
    "CRYPT_DECODE_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pfnAlloc", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbSize"]), offset=0)), ("pfnFree", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0)),)), name="CRYPT_DECODE_PARA", pack=False, align=None),
    "CRYPT_DECRYPT_MESSAGE_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMsgAndCertEncodingType", SimTypeInt(signed=False, label="UInt32")), ("cCertStore", SimTypeInt(signed=False, label="UInt32")), ("rghCertStore", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)),)), name="CRYPT_DECRYPT_MESSAGE_PARA", pack=False, align=None),
    "CRYPT_DEFAULT_CONTEXT_FLAGS": SimTypeInt(signed=False, label="CRYPT_DEFAULT_CONTEXT_FLAGS"),
    "CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA": SimStruct(OrderedDict((("cOID", SimTypeInt(signed=False, label="UInt32")), ("rgpszOID", SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)),)), name="CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA", pack=False, align=None),
    "CRYPT_DEFAULT_CONTEXT_TYPE": SimTypeInt(signed=False, label="CRYPT_DEFAULT_CONTEXT_TYPE"),
    "CRYPT_DES_KEY_STATE": SimStruct(OrderedDict((("Key", SimTypeArray(SimTypeChar(label="Byte"), 8)), ("IV", SimTypeArray(SimTypeChar(label="Byte"), 8)), ("Feedback", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="CRYPT_DES_KEY_STATE", pack=False, align=None),
    "CRYPT_ECC_CMS_SHARED_INFO": SimStruct(OrderedDict((("Algorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("EntityUInfo", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("rgbSuppPubInfo", SimTypeArray(SimTypeChar(label="Byte"), 4)),)), name="CRYPT_ECC_CMS_SHARED_INFO", pack=False, align=None),
    "CRYPT_ECC_PRIVATE_KEY_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("PrivateKey", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("szCurveOid", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("PublicKey", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)),)), name="CRYPT_ECC_PRIVATE_KEY_INFO", pack=False, align=None),
    "CRYPT_ENCODE_OBJECT_FLAGS": SimTypeInt(signed=False, label="CRYPT_ENCODE_OBJECT_FLAGS"),
    "CRYPT_ENCODE_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pfnAlloc", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbSize"]), offset=0)), ("pfnFree", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0)),)), name="CRYPT_ENCODE_PARA", pack=False, align=None),
    "CRYPT_ENCRYPTED_PRIVATE_KEY_INFO": SimStruct(OrderedDict((("EncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("EncryptedPrivateKey", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPT_ENCRYPTED_PRIVATE_KEY_INFO", pack=False, align=None),
    "CRYPT_ENCRYPT_MESSAGE_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMsgEncodingType", SimTypeInt(signed=False, label="UInt32")), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("ContentEncryptionAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvEncryptionAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwInnerContentType", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_ENCRYPT_MESSAGE_PARA", pack=False, align=None),
    "CRYPT_ENROLLMENT_NAME_VALUE_PAIR": SimStruct(OrderedDict((("pwszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pwszValue", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CRYPT_ENROLLMENT_NAME_VALUE_PAIR", pack=False, align=None),
    "CRYPT_FIND_FLAGS": SimTypeInt(signed=False, label="CRYPT_FIND_FLAGS"),
    "CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("iDeltaCrlIndicator", SimTypeInt(signed=True, label="Int32")), ("pftCacheResync", SimTypePointer(SimTypeRef("FILETIME", SimStruct), offset=0)), ("pLastSyncTime", SimTypePointer(SimTypeRef("FILETIME", SimStruct), offset=0)), ("pMaxAgeTime", SimTypePointer(SimTypeRef("FILETIME", SimStruct), offset=0)), ("pChainPara", SimTypePointer(SimTypeRef("CERT_REVOCATION_CHAIN_PARA", SimStruct), offset=0)), ("pDeltaCrlIndicator", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)),)), name="CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO", pack=False, align=None),
    "CRYPT_GET_URL_FLAGS": SimTypeInt(signed=False, label="CRYPT_GET_URL_FLAGS"),
    "CRYPT_HASH_INFO": SimStruct(OrderedDict((("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("Hash", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPT_HASH_INFO", pack=False, align=None),
    "CRYPT_HASH_MESSAGE_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMsgEncodingType", SimTypeInt(signed=False, label="UInt32")), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvHashAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPT_HASH_MESSAGE_PARA", pack=False, align=None),
    "CRYPT_IMAGE_REF": SimStruct(OrderedDict((("pszImage", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="CRYPT_IMAGE_REF_FLAGS")),)), name="CRYPT_IMAGE_REF", pack=False, align=None),
    "CRYPT_IMAGE_REF_FLAGS": SimTypeInt(signed=False, label="CRYPT_IMAGE_REF_FLAGS"),
    "CRYPT_IMAGE_REG": SimStruct(OrderedDict((("pszImage", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cInterfaces", SimTypeInt(signed=False, label="UInt32")), ("rgpInterfaces", SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_INTERFACE_REG", SimStruct), offset=0), offset=0)),)), name="CRYPT_IMAGE_REG", pack=False, align=None),
    "CRYPT_IMPORT_PUBLIC_KEY_FLAGS": SimTypeInt(signed=False, label="CRYPT_IMPORT_PUBLIC_KEY_FLAGS"),
    "CRYPT_INTEGER_BLOB": SimStruct(OrderedDict((("cbData", SimTypeInt(signed=False, label="UInt32")), ("pbData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CRYPT_INTEGER_BLOB", pack=False, align=None),
    "CRYPT_INTERFACE_REG": SimStruct(OrderedDict((("dwInterface", SimTypeInt(signed=False, label="BCRYPT_INTERFACE")), ("dwFlags", SimTypeInt(signed=False, label="BCRYPT_TABLE")), ("cFunctions", SimTypeInt(signed=False, label="UInt32")), ("rgpszFunctions", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="CRYPT_INTERFACE_REG", pack=False, align=None),
    "CRYPT_KEY_FLAGS": SimTypeInt(signed=False, label="CRYPT_KEY_FLAGS"),
    "CRYPT_KEY_PARAM_ID": SimTypeInt(signed=False, label="CRYPT_KEY_PARAM_ID"),
    "CRYPT_KEY_PROV_INFO": SimStruct(OrderedDict((("pwszContainerName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pwszProvName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwProvType", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="CRYPT_KEY_FLAGS")), ("cProvParam", SimTypeInt(signed=False, label="UInt32")), ("rgProvParam", SimTypePointer(SimTypeRef("CRYPT_KEY_PROV_PARAM", SimStruct), offset=0)), ("dwKeySpec", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_KEY_PROV_INFO", pack=False, align=None),
    "CRYPT_KEY_PROV_PARAM": SimStruct(OrderedDict((("dwParam", SimTypeInt(signed=False, label="UInt32")), ("pbData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbData", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_KEY_PROV_PARAM", pack=False, align=None),
    "CRYPT_KEY_SIGN_MESSAGE_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMsgAndCertEncodingType", SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE")), ("Anonymous", SimUnion({"hCryptProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "hNCryptKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None")), ("dwKeySpec", SimTypeInt(signed=False, label="CERT_KEY_SPEC")), ("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvHashAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("PubKeyAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)),)), name="CRYPT_KEY_SIGN_MESSAGE_PARA", pack=False, align=None),
    "CRYPT_KEY_VERIFY_MESSAGE_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMsgEncodingType", SimTypeInt(signed=False, label="UInt32")), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="CRYPT_KEY_VERIFY_MESSAGE_PARA", pack=False, align=None),
    "CRYPT_MASK_GEN_ALGORITHM": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)),)), name="CRYPT_MASK_GEN_ALGORITHM", pack=False, align=None),
    "CRYPT_MSG_TYPE": SimTypeInt(signed=False, label="CRYPT_MSG_TYPE"),
    "CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pfnGet", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPluginContext", "pIdentifier", "dwNameType", "pNameBlob", "ppbContent", "pcbContent", "ppwszPassword", "ppIdentifier"]), offset=0)), ("pfnRelease", SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="CRYPT_OBJECT_LOCATOR_RELEASE_REASON"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwReason", "pPluginContext"]), offset=0)), ("pfnFreePassword", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pPluginContext", "pwszPassword"]), offset=0)), ("pfnFree", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pPluginContext", "pbData"]), offset=0)), ("pfnFreeIdentifier", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)], SimTypeBottom(label="Void"), arg_names=["pPluginContext", "pIdentifier"]), offset=0)),)), name="CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE", pack=False, align=None),
    "CRYPT_OBJECT_LOCATOR_RELEASE_REASON": SimTypeInt(signed=False, label="CRYPT_OBJECT_LOCATOR_RELEASE_REASON"),
    "CRYPT_OBJID_TABLE": SimStruct(OrderedDict((("dwAlgId", SimTypeInt(signed=False, label="UInt32")), ("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CRYPT_OBJID_TABLE", pack=False, align=None),
    "CRYPT_OID_FUNC_ENTRY": SimStruct(OrderedDict((("pszOID", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pvFuncAddr", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPT_OID_FUNC_ENTRY", pack=False, align=None),
    "CRYPT_OID_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pszOID", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pwszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwGroupId", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"dwValue": SimTypeInt(signed=False, label="UInt32"), "Algid": SimTypeInt(signed=False, label="ALG_ID"), "dwLength": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("ExtraInfo", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPT_OID_INFO", pack=False, align=None),
    "CRYPT_PASSWORD_CREDENTIALSA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pszUsername", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pszPassword", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CRYPT_PASSWORD_CREDENTIALSA", pack=False, align=None),
    "CRYPT_PASSWORD_CREDENTIALSW": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pszUsername", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszPassword", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CRYPT_PASSWORD_CREDENTIALSW", pack=False, align=None),
    "CRYPT_PKCS12_PBE_PARAMS": SimStruct(OrderedDict((("iIterations", SimTypeInt(signed=True, label="Int32")), ("cbSalt", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_PKCS12_PBE_PARAMS", pack=False, align=None),
    "CRYPT_PKCS8_EXPORT_PARAMS": SimStruct(OrderedDict((("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("dwKeySpec", SimTypeInt(signed=False, label="UInt32")), ("pszPrivateKeyObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pEncryptPrivateKeyFunc", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct), offset=0), SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAlgorithm", "pClearTextPrivateKey", "pbEncryptedKey", "pcbEncryptedKey", "pVoidEncryptFunc"]), offset=0)), ("pVoidEncryptFunc", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPT_PKCS8_EXPORT_PARAMS", pack=False, align=None),
    "CRYPT_PKCS8_IMPORT_PARAMS": SimStruct(OrderedDict((("PrivateKey", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("pResolvehCryptProvFunc", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PRIVATE_KEY_INFO", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPrivateKeyInfo", "phCryptProv", "pVoidResolveFunc"]), offset=0)), ("pVoidResolveFunc", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pDecryptPrivateKeyFunc", SimTypePointer(SimTypeFunction([SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct), SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Algorithm", "EncryptedPrivateKey", "pbClearTextKey", "pcbClearTextKey", "pVoidDecryptFunc"]), offset=0)), ("pVoidDecryptFunc", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPT_PKCS8_IMPORT_PARAMS", pack=False, align=None),
    "CRYPT_PRIVATE_KEY_INFO": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("Algorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("PrivateKey", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("pAttributes", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTES", SimStruct), offset=0)),)), name="CRYPT_PRIVATE_KEY_INFO", pack=False, align=None),
    "CRYPT_PROPERTY_REF": SimStruct(OrderedDict((("pszProperty", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cbValue", SimTypeInt(signed=False, label="UInt32")), ("pbValue", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CRYPT_PROPERTY_REF", pack=False, align=None),
    "CRYPT_PROVIDERS": SimStruct(OrderedDict((("cProviders", SimTypeInt(signed=False, label="UInt32")), ("rgpszProviders", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="CRYPT_PROVIDERS", pack=False, align=None),
    "CRYPT_PROVIDER_CERT": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("pCert", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("fCommercial", SimTypeInt(signed=True, label="Int32")), ("fTrustedRoot", SimTypeInt(signed=True, label="Int32")), ("fSelfSigned", SimTypeInt(signed=True, label="Int32")), ("fTestCert", SimTypeInt(signed=True, label="Int32")), ("dwRevokedReason", SimTypeInt(signed=False, label="UInt32")), ("dwConfidence", SimTypeInt(signed=False, label="UInt32")), ("dwError", SimTypeInt(signed=False, label="UInt32")), ("pTrustListContext", SimTypePointer(SimTypeRef("CTL_CONTEXT", SimStruct), offset=0)), ("fTrustListSignerCert", SimTypeInt(signed=True, label="Int32")), ("pCtlContext", SimTypePointer(SimTypeRef("CTL_CONTEXT", SimStruct), offset=0)), ("dwCtlError", SimTypeInt(signed=False, label="UInt32")), ("fIsCyclic", SimTypeInt(signed=True, label="Int32")), ("pChainElement", SimTypePointer(SimTypeRef("CERT_CHAIN_ELEMENT", SimStruct), offset=0)),)), name="CRYPT_PROVIDER_CERT", pack=False, align=None),
    "CRYPT_PROVIDER_DATA": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("pWintrustData", SimTypePointer(SimTypeRef("WINTRUST_DATA", SimStruct), offset=0)), ("fOpenedFile", SimTypeInt(signed=True, label="Int32")), ("hWndParent", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pgActionID", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)), ("hProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("dwError", SimTypeInt(signed=False, label="UInt32")), ("dwRegSecuritySettings", SimTypeInt(signed=False, label="UInt32")), ("dwRegPolicySettings", SimTypeInt(signed=False, label="UInt32")), ("psPfns", SimTypePointer(SimTypeRef("CRYPT_PROVIDER_FUNCTIONS", SimStruct), offset=0)), ("cdwTrustStepErrors", SimTypeInt(signed=False, label="UInt32")), ("padwTrustStepErrors", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("chStores", SimTypeInt(signed=False, label="UInt32")), ("pahStores", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("dwEncoding", SimTypeInt(signed=False, label="UInt32")), ("hMsg", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("csSigners", SimTypeInt(signed=False, label="UInt32")), ("pasSigners", SimTypePointer(SimTypeRef("CRYPT_PROVIDER_SGNR", SimStruct), offset=0)), ("csProvPrivData", SimTypeInt(signed=False, label="UInt32")), ("pasProvPrivData", SimTypePointer(SimTypeRef("CRYPT_PROVIDER_PRIVDATA", SimStruct), offset=0)), ("dwSubjectChoice", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"pPDSip": SimTypePointer(SimTypeRef("PROVDATA_SIP", SimStruct), offset=0)}, name="<anon>", label="None")), ("pszUsageOID", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("fRecallWithState", SimTypeInt(signed=True, label="Int32")), ("sftSystemTime", SimTypeRef("FILETIME", SimStruct)), ("pszCTLSignerUsageOID", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("dwProvFlags", SimTypeInt(signed=False, label="UInt32")), ("dwFinalError", SimTypeInt(signed=False, label="UInt32")), ("pRequestUsage", SimTypePointer(SimTypeRef("CERT_USAGE_MATCH", SimStruct), offset=0)), ("dwTrustPubSettings", SimTypeInt(signed=False, label="UInt32")), ("dwUIStateFlags", SimTypeInt(signed=False, label="UInt32")), ("pSigState", SimTypePointer(SimTypeRef("CRYPT_PROVIDER_SIGSTATE", SimStruct), offset=0)), ("pSigSettings", SimTypePointer(SimTypeRef("WINTRUST_SIGNATURE_SETTINGS", SimStruct), offset=0)),)), name="CRYPT_PROVIDER_DATA", pack=False, align=None),
    "CRYPT_PROVIDER_DEFUSAGE": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("gActionID", SimTypeBottom(label="Guid")), ("pDefPolicyCallbackData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pDefSIPClientData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPT_PROVIDER_DEFUSAGE", pack=False, align=None),
    "CRYPT_PROVIDER_FUNCTIONS": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("pfnAlloc", SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbSize"]), offset=0)), ("pfnFree", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pvMem2Free"]), offset=0)), ("pfnAddStore2Chain", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData", "hStore2Add"]), offset=0)), ("pfnAddSgnr2Chain", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("CRYPT_PROVIDER_SGNR", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData", "fCounterSigner", "idxSigner", "pSgnr2Add"]), offset=0)), ("pfnAddCert2Chain", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData", "idxSigner", "fCounterSigner", "idxCounterSigner", "pCert2Add"]), offset=0)), ("pfnAddPrivData2Chain", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0), SimTypePointer(SimTypeRef("CRYPT_PROVIDER_PRIVDATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData", "pPrivData2Add"]), offset=0)), ("pfnInitialize", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0)), ("pfnObjectTrust", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0)), ("pfnSignatureTrust", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0)), ("pfnCertificateTrust", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0)), ("pfnFinalPolicy", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0)), ("pfnCertCheckPolicy", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData", "idxSigner", "fCounterSignerChain", "idxCounterSigner"]), offset=0)), ("pfnTestFinalPolicy", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0)), ("psUIpfns", SimTypePointer(SimTypeRef("CRYPT_PROVUI_FUNCS", SimStruct), offset=0)), ("pfnCleanupPolicy", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0)),)), name="CRYPT_PROVIDER_FUNCTIONS", pack=False, align=None),
    "CRYPT_PROVIDER_PRIVDATA": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("gProviderID", SimTypeBottom(label="Guid")), ("cbProvData", SimTypeInt(signed=False, label="UInt32")), ("pvProvData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPT_PROVIDER_PRIVDATA", pack=False, align=None),
    "CRYPT_PROVIDER_REF": SimStruct(OrderedDict((("dwInterface", SimTypeInt(signed=False, label="UInt32")), ("pszFunction", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pszProvider", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cProperties", SimTypeInt(signed=False, label="UInt32")), ("rgpProperties", SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_PROPERTY_REF", SimStruct), offset=0), offset=0)), ("pUM", SimTypePointer(SimTypeRef("CRYPT_IMAGE_REF", SimStruct), offset=0)), ("pKM", SimTypePointer(SimTypeRef("CRYPT_IMAGE_REF", SimStruct), offset=0)),)), name="CRYPT_PROVIDER_REF", pack=False, align=None),
    "CRYPT_PROVIDER_REFS": SimStruct(OrderedDict((("cProviders", SimTypeInt(signed=False, label="UInt32")), ("rgpProviders", SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_PROVIDER_REF", SimStruct), offset=0), offset=0)),)), name="CRYPT_PROVIDER_REFS", pack=False, align=None),
    "CRYPT_PROVIDER_REG": SimStruct(OrderedDict((("cAliases", SimTypeInt(signed=False, label="UInt32")), ("rgpszAliases", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)), ("pUM", SimTypePointer(SimTypeRef("CRYPT_IMAGE_REG", SimStruct), offset=0)), ("pKM", SimTypePointer(SimTypeRef("CRYPT_IMAGE_REG", SimStruct), offset=0)),)), name="CRYPT_PROVIDER_REG", pack=False, align=None),
    "CRYPT_PROVIDER_REGDEFUSAGE": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("pgActionID", SimTypePointer(SimTypeBottom(label="Guid"), offset=0)), ("pwszDllName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pwszLoadCallbackDataFunctionName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pwszFreeCallbackDataFunctionName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CRYPT_PROVIDER_REGDEFUSAGE", pack=False, align=None),
    "CRYPT_PROVIDER_SGNR": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("sftVerifyAsOf", SimTypeRef("FILETIME", SimStruct)), ("csCertChain", SimTypeInt(signed=False, label="UInt32")), ("pasCertChain", SimTypePointer(SimTypeRef("CRYPT_PROVIDER_CERT", SimStruct), offset=0)), ("dwSignerType", SimTypeInt(signed=False, label="UInt32")), ("psSigner", SimTypePointer(SimTypeRef("CMSG_SIGNER_INFO", SimStruct), offset=0)), ("dwError", SimTypeInt(signed=False, label="UInt32")), ("csCounterSigners", SimTypeInt(signed=False, label="UInt32")), ("pasCounterSigners", SimTypePointer(SimTypeRef("CRYPT_PROVIDER_SGNR", SimStruct), offset=0)), ("pChainContext", SimTypePointer(SimTypeRef("CERT_CHAIN_CONTEXT", SimStruct), offset=0)),)), name="CRYPT_PROVIDER_SGNR", pack=False, align=None),
    "CRYPT_PROVIDER_SIGSTATE": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("rhSecondarySigs", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("hPrimarySig", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("fFirstAttemptMade", SimTypeInt(signed=True, label="Int32")), ("fNoMoreSigs", SimTypeInt(signed=True, label="Int32")), ("cSecondarySigs", SimTypeInt(signed=False, label="UInt32")), ("dwCurrentIndex", SimTypeInt(signed=False, label="UInt32")), ("fSupportMultiSig", SimTypeInt(signed=True, label="Int32")), ("dwCryptoPolicySupport", SimTypeInt(signed=False, label="UInt32")), ("iAttemptCount", SimTypeInt(signed=False, label="UInt32")), ("fCheckedSealing", SimTypeInt(signed=True, label="Int32")), ("pSealingSignature", SimTypePointer(SimTypeRef("SEALING_SIGNATURE_ATTRIBUTE", SimStruct), offset=0)),)), name="CRYPT_PROVIDER_SIGSTATE", pack=False, align=None),
    "CRYPT_PROVUI_DATA": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("dwFinalError", SimTypeInt(signed=False, label="UInt32")), ("pYesButtonText", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pNoButtonText", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pMoreInfoButtonText", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pAdvancedLinkText", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pCopyActionText", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pCopyActionTextNoTS", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pCopyActionTextNotSigned", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CRYPT_PROVUI_DATA", pack=False, align=None),
    "CRYPT_PROVUI_FUNCS": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("psUIData", SimTypePointer(SimTypeRef("CRYPT_PROVUI_DATA", SimStruct), offset=0)), ("pfnOnMoreInfoClick", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWndSecurityDialog", "pProvData"]), offset=0)), ("pfnOnMoreInfoClickDefault", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWndSecurityDialog", "pProvData"]), offset=0)), ("pfnOnAdvancedClick", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWndSecurityDialog", "pProvData"]), offset=0)), ("pfnOnAdvancedClickDefault", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("CRYPT_PROVIDER_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWndSecurityDialog", "pProvData"]), offset=0)),)), name="CRYPT_PROVUI_FUNCS", pack=False, align=None),
    "CRYPT_PSOURCE_ALGORITHM": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("EncodingParameters", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPT_PSOURCE_ALGORITHM", pack=False, align=None),
    "CRYPT_RC2_CBC_PARAMETERS": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("fIV", SimTypeInt(signed=True, label="Int32")), ("rgbIV", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="CRYPT_RC2_CBC_PARAMETERS", pack=False, align=None),
    "CRYPT_RC4_KEY_STATE": SimStruct(OrderedDict((("Key", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("SBox", SimTypeArray(SimTypeChar(label="Byte"), 256)), ("i", SimTypeChar(label="Byte")), ("j", SimTypeChar(label="Byte")),)), name="CRYPT_RC4_KEY_STATE", pack=False, align=None),
    "CRYPT_REGISTER_ACTIONID": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("sInitProvider", SimTypeRef("CRYPT_TRUST_REG_ENTRY", SimStruct)), ("sObjectProvider", SimTypeRef("CRYPT_TRUST_REG_ENTRY", SimStruct)), ("sSignatureProvider", SimTypeRef("CRYPT_TRUST_REG_ENTRY", SimStruct)), ("sCertificateProvider", SimTypeRef("CRYPT_TRUST_REG_ENTRY", SimStruct)), ("sCertificatePolicyProvider", SimTypeRef("CRYPT_TRUST_REG_ENTRY", SimStruct)), ("sFinalPolicyProvider", SimTypeRef("CRYPT_TRUST_REG_ENTRY", SimStruct)), ("sTestPolicyProvider", SimTypeRef("CRYPT_TRUST_REG_ENTRY", SimStruct)), ("sCleanupProvider", SimTypeRef("CRYPT_TRUST_REG_ENTRY", SimStruct)),)), name="CRYPT_REGISTER_ACTIONID", pack=False, align=None),
    "CRYPT_RETRIEVE_AUX_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pLastSyncTime", SimTypePointer(SimTypeRef("FILETIME", SimStruct), offset=0)), ("dwMaxUrlRetrievalByteCount", SimTypeInt(signed=False, label="UInt32")), ("pPreFetchInfo", SimTypePointer(SimTypeRef("CRYPTNET_URL_CACHE_PRE_FETCH_INFO", SimStruct), offset=0)), ("pFlushInfo", SimTypePointer(SimTypeRef("CRYPTNET_URL_CACHE_FLUSH_INFO", SimStruct), offset=0)), ("ppResponseInfo", SimTypePointer(SimTypePointer(SimTypeRef("CRYPTNET_URL_CACHE_RESPONSE_INFO", SimStruct), offset=0), offset=0)), ("pwszCacheFileNamePrefix", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pftCacheResync", SimTypePointer(SimTypeRef("FILETIME", SimStruct), offset=0)), ("fProxyCacheRetrieval", SimTypeInt(signed=True, label="Int32")), ("dwHttpStatusCode", SimTypeInt(signed=False, label="UInt32")), ("ppwszErrorResponseHeaders", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)), ("ppErrorContentBlob", SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0), offset=0)),)), name="CRYPT_RETRIEVE_AUX_INFO", pack=False, align=None),
    "CRYPT_RSAES_OAEP_PARAMETERS": SimStruct(OrderedDict((("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("MaskGenAlgorithm", SimTypeRef("CRYPT_MASK_GEN_ALGORITHM", SimStruct)), ("PSourceAlgorithm", SimTypeRef("CRYPT_PSOURCE_ALGORITHM", SimStruct)),)), name="CRYPT_RSAES_OAEP_PARAMETERS", pack=False, align=None),
    "CRYPT_RSA_SSA_PSS_PARAMETERS": SimStruct(OrderedDict((("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("MaskGenAlgorithm", SimTypeRef("CRYPT_MASK_GEN_ALGORITHM", SimStruct)), ("dwSaltLength", SimTypeInt(signed=False, label="UInt32")), ("dwTrailerField", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_RSA_SSA_PSS_PARAMETERS", pack=False, align=None),
    "CRYPT_SEQUENCE_OF_ANY": SimStruct(OrderedDict((("cValue", SimTypeInt(signed=False, label="UInt32")), ("rgValue", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)),)), name="CRYPT_SEQUENCE_OF_ANY", pack=False, align=None),
    "CRYPT_SET_HASH_PARAM": SimTypeInt(signed=False, label="CRYPT_SET_HASH_PARAM"),
    "CRYPT_SET_PROV_PARAM_ID": SimTypeInt(signed=False, label="CRYPT_SET_PROV_PARAM_ID"),
    "CRYPT_SIGN_MESSAGE_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMsgEncodingType", SimTypeInt(signed=False, label="UInt32")), ("pSigningCert", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("pvHashAuxInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cMsgCert", SimTypeInt(signed=False, label="UInt32")), ("rgpMsgCert", SimTypePointer(SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), offset=0)), ("cMsgCrl", SimTypeInt(signed=False, label="UInt32")), ("rgpMsgCrl", SimTypePointer(SimTypePointer(SimTypeRef("CRL_CONTEXT", SimStruct), offset=0), offset=0)), ("cAuthAttr", SimTypeInt(signed=False, label="UInt32")), ("rgAuthAttr", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE", SimStruct), offset=0)), ("cUnauthAttr", SimTypeInt(signed=False, label="UInt32")), ("rgUnauthAttr", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE", SimStruct), offset=0)), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("dwInnerContentType", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_SIGN_MESSAGE_PARA", pack=False, align=None),
    "CRYPT_SMART_CARD_ROOT_INFO": SimStruct(OrderedDict((("rgbCardID", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("luid", SimTypeRef("ROOT_INFO_LUID", SimStruct)),)), name="CRYPT_SMART_CARD_ROOT_INFO", pack=False, align=None),
    "CRYPT_SMIME_CAPABILITIES": SimStruct(OrderedDict((("cCapability", SimTypeInt(signed=False, label="UInt32")), ("rgCapability", SimTypePointer(SimTypeRef("CRYPT_SMIME_CAPABILITY", SimStruct), offset=0)),)), name="CRYPT_SMIME_CAPABILITIES", pack=False, align=None),
    "CRYPT_SMIME_CAPABILITY": SimStruct(OrderedDict((("pszObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Parameters", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPT_SMIME_CAPABILITY", pack=False, align=None),
    "CRYPT_STRING": SimTypeInt(signed=False, label="CRYPT_STRING"),
    "CRYPT_TIMESTAMP_ACCURACY": SimStruct(OrderedDict((("dwSeconds", SimTypeInt(signed=False, label="UInt32")), ("dwMillis", SimTypeInt(signed=False, label="UInt32")), ("dwMicros", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_TIMESTAMP_ACCURACY", pack=False, align=None),
    "CRYPT_TIMESTAMP_CONTEXT": SimStruct(OrderedDict((("cbEncoded", SimTypeInt(signed=False, label="UInt32")), ("pbEncoded", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pTimeStamp", SimTypePointer(SimTypeRef("CRYPT_TIMESTAMP_INFO", SimStruct), offset=0)),)), name="CRYPT_TIMESTAMP_CONTEXT", pack=False, align=None),
    "CRYPT_TIMESTAMP_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("pszTSAPolicyId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("HashedMessage", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("SerialNumber", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("ftTime", SimTypeRef("FILETIME", SimStruct)), ("pvAccuracy", SimTypePointer(SimTypeRef("CRYPT_TIMESTAMP_ACCURACY", SimStruct), offset=0)), ("fOrdering", SimTypeInt(signed=True, label="Int32")), ("Nonce", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("Tsa", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("cExtension", SimTypeInt(signed=False, label="UInt32")), ("rgExtension", SimTypePointer(SimTypeRef("CERT_EXTENSION", SimStruct), offset=0)),)), name="CRYPT_TIMESTAMP_INFO", pack=False, align=None),
    "CRYPT_TIMESTAMP_PARA": SimStruct(OrderedDict((("pszTSAPolicyId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("fRequestCerts", SimTypeInt(signed=True, label="Int32")), ("Nonce", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("cExtension", SimTypeInt(signed=False, label="UInt32")), ("rgExtension", SimTypePointer(SimTypeRef("CERT_EXTENSION", SimStruct), offset=0)),)), name="CRYPT_TIMESTAMP_PARA", pack=False, align=None),
    "CRYPT_TIMESTAMP_REQUEST": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="CRYPT_TIMESTAMP_VERSION")), ("HashAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("HashedMessage", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("pszTSAPolicyId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Nonce", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("fCertReq", SimTypeInt(signed=True, label="Int32")), ("cExtension", SimTypeInt(signed=False, label="UInt32")), ("rgExtension", SimTypePointer(SimTypeRef("CERT_EXTENSION", SimStruct), offset=0)),)), name="CRYPT_TIMESTAMP_REQUEST", pack=False, align=None),
    "CRYPT_TIMESTAMP_RESPONSE": SimStruct(OrderedDict((("dwStatus", SimTypeInt(signed=False, label="CRYPT_TIMESTAMP_RESPONSE_STATUS")), ("cFreeText", SimTypeInt(signed=False, label="UInt32")), ("rgFreeText", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)), ("FailureInfo", SimTypeRef("CRYPT_BIT_BLOB", SimStruct)), ("ContentInfo", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPT_TIMESTAMP_RESPONSE", pack=False, align=None),
    "CRYPT_TIMESTAMP_RESPONSE_STATUS": SimTypeInt(signed=False, label="CRYPT_TIMESTAMP_RESPONSE_STATUS"),
    "CRYPT_TIMESTAMP_VERSION": SimTypeInt(signed=False, label="CRYPT_TIMESTAMP_VERSION"),
    "CRYPT_TIME_STAMP_REQUEST_INFO": SimStruct(OrderedDict((("pszTimeStampAlgorithm", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pszContentType", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Content", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("cAttribute", SimTypeInt(signed=False, label="UInt32")), ("rgAttribute", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE", SimStruct), offset=0)),)), name="CRYPT_TIME_STAMP_REQUEST_INFO", pack=False, align=None),
    "CRYPT_TRUST_REG_ENTRY": SimStruct(OrderedDict((("cbStruct", SimTypeInt(signed=False, label="UInt32")), ("pwszDLLName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pwszFunctionName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CRYPT_TRUST_REG_ENTRY", pack=False, align=None),
    "CRYPT_URL_ARRAY": SimStruct(OrderedDict((("cUrl", SimTypeInt(signed=False, label="UInt32")), ("rgwszUrl", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)),)), name="CRYPT_URL_ARRAY", pack=False, align=None),
    "CRYPT_URL_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwSyncDeltaTime", SimTypeInt(signed=False, label="UInt32")), ("cGroup", SimTypeInt(signed=False, label="UInt32")), ("rgcGroupEntry", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="CRYPT_URL_INFO", pack=False, align=None),
    "CRYPT_VERIFY_CERT_FLAGS": SimTypeInt(signed=False, label="CRYPT_VERIFY_CERT_FLAGS"),
    "CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO": SimStruct(OrderedDict((("CertSignHashCNGAlgPropData", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("CertIssuerPubKeyBitLengthPropData", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO", pack=False, align=None),
    "CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO": SimStruct(OrderedDict((("cCNGHashAlgid", SimTypeInt(signed=False, label="UInt32")), ("rgpwszCNGHashAlgid", SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)), ("dwWeakIndex", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO", pack=False, align=None),
    "CRYPT_VERIFY_MESSAGE_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwMsgAndCertEncodingType", SimTypeInt(signed=False, label="UInt32")), ("hCryptProv", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("pfnGetSignerCertificate", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE"), SimTypePointer(SimTypeRef("CERT_INFO", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), arg_names=["pvGetArg", "dwCertEncodingType", "pSignerId", "hMsgCertStore"]), offset=0)), ("pvGetArg", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPT_VERIFY_MESSAGE_PARA", pack=False, align=None),
    "CRYPT_X942_OTHER_INFO": SimStruct(OrderedDict((("pszContentEncryptionObjId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("rgbCounter", SimTypeArray(SimTypeChar(label="Byte"), 4)), ("rgbKeyLength", SimTypeArray(SimTypeChar(label="Byte"), 4)), ("PubInfo", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CRYPT_X942_OTHER_INFO", pack=False, align=None),
    "CRYPT_XML_ALGORITHM": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("wszAlgorithm", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Encoded", SimTypeRef("CRYPT_XML_BLOB", SimStruct)),)), name="CRYPT_XML_ALGORITHM", pack=False, align=None),
    "CRYPT_XML_ALGORITHM_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("wszAlgorithmURI", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("wszName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwGroupId", SimTypeInt(signed=False, label="CRYPT_XML_GROUP_ID")), ("wszCNGAlgid", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("wszCNGExtraAlgid", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("dwSignFlags", SimTypeInt(signed=False, label="UInt32")), ("dwVerifyFlags", SimTypeInt(signed=False, label="UInt32")), ("pvPaddingInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pvExtraInfo", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPT_XML_ALGORITHM_INFO", pack=False, align=None),
    "CRYPT_XML_BLOB": SimStruct(OrderedDict((("dwCharset", SimTypeInt(signed=False, label="CRYPT_XML_CHARSET")), ("cbData", SimTypeInt(signed=False, label="UInt32")), ("pbData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CRYPT_XML_BLOB", pack=False, align=None),
    "CRYPT_XML_CHARSET": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"),
    "CRYPT_XML_CRYPTOGRAPHIC_INTERFACE": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("fpCryptXmlEncodeAlgorithm", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM_INFO", SimStruct), offset=0), SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAlgInfo", "dwCharset", "pvCallbackState", "pfnWrite"]), offset=0)), ("fpCryptXmlCreateDigest", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDigestMethod", "pcbSize", "phDigest"]), offset=0)), ("fpCryptXmlDigestData", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hDigest", "pbData", "cbData"]), offset=0)), ("fpCryptXmlFinalizeDigest", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hDigest", "pbDigest", "cbDigest"]), offset=0)), ("fpCryptXmlCloseDigest", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hDigest"]), offset=0)), ("fpCryptXmlSignData", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSignatureMethod", "hCryptProvOrNCryptKey", "dwKeySpec", "pbInput", "cbInput", "pbOutput", "cbOutput", "pcbResult"]), offset=0)), ("fpCryptXmlVerifySignature", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSignatureMethod", "hKey", "pbInput", "cbInput", "pbSignature", "cbSignature"]), offset=0)), ("fpCryptXmlGetAlgorithmInfo", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM_INFO", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pXmlAlgorithm", "ppAlgInfo"]), offset=0)),)), name="CRYPT_XML_CRYPTOGRAPHIC_INTERFACE", pack=False, align=None),
    "CRYPT_XML_DATA_BLOB": SimStruct(OrderedDict((("cbData", SimTypeInt(signed=False, label="UInt32")), ("pbData", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CRYPT_XML_DATA_BLOB", pack=False, align=None),
    "CRYPT_XML_DATA_PROVIDER": SimStruct(OrderedDict((("pvCallbackState", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cbBufferSize", SimTypeInt(signed=False, label="UInt32")), ("pfnRead", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData", "pcbRead"]), offset=0)), ("pfnClose", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState"]), offset=0)),)), name="CRYPT_XML_DATA_PROVIDER", pack=False, align=None),
    "CRYPT_XML_DOC_CTXT": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hDocCtxt", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pTransformsConfig", SimTypePointer(SimTypeRef("CRYPT_XML_TRANSFORM_CHAIN_CONFIG", SimStruct), offset=0)), ("cSignature", SimTypeInt(signed=False, label="UInt32")), ("rgpSignature", SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_XML_SIGNATURE", SimStruct), offset=0), offset=0)),)), name="CRYPT_XML_DOC_CTXT", pack=False, align=None),
    "CRYPT_XML_FLAGS": SimTypeInt(signed=False, label="CRYPT_XML_FLAGS"),
    "CRYPT_XML_GROUP_ID": SimTypeInt(signed=False, label="CRYPT_XML_GROUP_ID"),
    "CRYPT_XML_ISSUER_SERIAL": SimStruct(OrderedDict((("wszIssuer", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("wszSerial", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CRYPT_XML_ISSUER_SERIAL", pack=False, align=None),
    "CRYPT_XML_KEYINFO_PARAM": SimStruct(OrderedDict((("wszId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("wszKeyName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("SKI", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("wszSubjectName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cCertificate", SimTypeInt(signed=False, label="UInt32")), ("rgCertificate", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)), ("cCRL", SimTypeInt(signed=False, label="UInt32")), ("rgCRL", SimTypePointer(SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct), offset=0)),)), name="CRYPT_XML_KEYINFO_PARAM", pack=False, align=None),
    "CRYPT_XML_KEYINFO_SPEC": SimTypeInt(signed=False, label="CRYPT_XML_KEYINFO_SPEC"),
    "CRYPT_XML_KEYINFO_TYPE": SimTypeInt(signed=False, label="CRYPT_XML_KEYINFO_TYPE"),
    "CRYPT_XML_KEY_DSA_KEY_VALUE": SimStruct(OrderedDict((("P", SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct)), ("Q", SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct)), ("G", SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct)), ("Y", SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct)), ("J", SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct)), ("Seed", SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct)), ("Counter", SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct)),)), name="CRYPT_XML_KEY_DSA_KEY_VALUE", pack=False, align=None),
    "CRYPT_XML_KEY_ECDSA_KEY_VALUE": SimStruct(OrderedDict((("wszNamedCurve", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("X", SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct)), ("Y", SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct)), ("ExplicitPara", SimTypeRef("CRYPT_XML_BLOB", SimStruct)),)), name="CRYPT_XML_KEY_ECDSA_KEY_VALUE", pack=False, align=None),
    "CRYPT_XML_KEY_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("wszId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cKeyInfo", SimTypeInt(signed=False, label="UInt32")), ("rgKeyInfo", SimTypePointer(SimTypeRef("CRYPT_XML_KEY_INFO_ITEM", SimStruct), offset=0)), ("hVerifyKey", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CRYPT_XML_KEY_INFO", pack=False, align=None),
    "CRYPT_XML_KEY_INFO_ITEM": SimStruct(OrderedDict((("dwType", SimTypeInt(signed=False, label="CRYPT_XML_KEYINFO_TYPE")), ("Anonymous", SimUnion({"wszKeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyValue": SimTypeRef("CRYPT_XML_KEY_VALUE", SimStruct), "RetrievalMethod": SimTypeRef("CRYPT_XML_BLOB", SimStruct), "X509Data": SimTypeRef("CRYPT_XML_X509DATA", SimStruct), "Custom": SimTypeRef("CRYPT_XML_BLOB", SimStruct)}, name="<anon>", label="None")),)), name="CRYPT_XML_KEY_INFO_ITEM", pack=False, align=None),
    "CRYPT_XML_KEY_RSA_KEY_VALUE": SimStruct(OrderedDict((("Modulus", SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct)), ("Exponent", SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct)),)), name="CRYPT_XML_KEY_RSA_KEY_VALUE", pack=False, align=None),
    "CRYPT_XML_KEY_VALUE": SimStruct(OrderedDict((("dwType", SimTypeInt(signed=False, label="CRYPT_XML_KEY_VALUE_TYPE")), ("Anonymous", SimUnion({"DSAKeyValue": SimTypeRef("CRYPT_XML_KEY_DSA_KEY_VALUE", SimStruct), "RSAKeyValue": SimTypeRef("CRYPT_XML_KEY_RSA_KEY_VALUE", SimStruct), "ECDSAKeyValue": SimTypeRef("CRYPT_XML_KEY_ECDSA_KEY_VALUE", SimStruct), "Custom": SimTypeRef("CRYPT_XML_BLOB", SimStruct)}, name="<anon>", label="None")),)), name="CRYPT_XML_KEY_VALUE", pack=False, align=None),
    "CRYPT_XML_KEY_VALUE_TYPE": SimTypeInt(signed=False, label="CRYPT_XML_KEY_VALUE_TYPE"),
    "CRYPT_XML_OBJECT": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hObject", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("wszId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("wszMimeType", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("wszEncoding", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Manifest", SimTypeRef("CRYPT_XML_REFERENCES", SimStruct)), ("Encoded", SimTypeRef("CRYPT_XML_BLOB", SimStruct)),)), name="CRYPT_XML_OBJECT", pack=False, align=None),
    "CRYPT_XML_PROPERTY": SimStruct(OrderedDict((("dwPropId", SimTypeInt(signed=False, label="CRYPT_XML_PROPERTY_ID")), ("pvValue", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("cbValue", SimTypeInt(signed=False, label="UInt32")),)), name="CRYPT_XML_PROPERTY", pack=False, align=None),
    "CRYPT_XML_PROPERTY_ID": SimTypeInt(signed=False, label="CRYPT_XML_PROPERTY_ID"),
    "CRYPT_XML_REFERENCE": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hReference", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("wszId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("wszUri", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("wszType", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("DigestMethod", SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct)), ("DigestValue", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("cTransform", SimTypeInt(signed=False, label="UInt32")), ("rgTransform", SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct), offset=0)),)), name="CRYPT_XML_REFERENCE", pack=False, align=None),
    "CRYPT_XML_REFERENCES": SimStruct(OrderedDict((("cReference", SimTypeInt(signed=False, label="UInt32")), ("rgpReference", SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_XML_REFERENCE", SimStruct), offset=0), offset=0)),)), name="CRYPT_XML_REFERENCES", pack=False, align=None),
    "CRYPT_XML_SIGNATURE": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("hSignature", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("wszId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("SignedInfo", SimTypeRef("CRYPT_XML_SIGNED_INFO", SimStruct)), ("SignatureValue", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("pKeyInfo", SimTypePointer(SimTypeRef("CRYPT_XML_KEY_INFO", SimStruct), offset=0)), ("cObject", SimTypeInt(signed=False, label="UInt32")), ("rgpObject", SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_XML_OBJECT", SimStruct), offset=0), offset=0)),)), name="CRYPT_XML_SIGNATURE", pack=False, align=None),
    "CRYPT_XML_SIGNED_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("wszId", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Canonicalization", SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct)), ("SignatureMethod", SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct)), ("cReference", SimTypeInt(signed=False, label="UInt32")), ("rgpReference", SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_XML_REFERENCE", SimStruct), offset=0), offset=0)), ("Encoded", SimTypeRef("CRYPT_XML_BLOB", SimStruct)),)), name="CRYPT_XML_SIGNED_INFO", pack=False, align=None),
    "CRYPT_XML_STATUS": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwErrorStatus", SimTypeInt(signed=False, label="CRYPT_XML_STATUS_ERROR_STATUS")), ("dwInfoStatus", SimTypeInt(signed=False, label="CRYPT_XML_STATUS_INFO_STATUS")),)), name="CRYPT_XML_STATUS", pack=False, align=None),
    "CRYPT_XML_STATUS_ERROR_STATUS": SimTypeInt(signed=False, label="CRYPT_XML_STATUS_ERROR_STATUS"),
    "CRYPT_XML_STATUS_INFO_STATUS": SimTypeInt(signed=False, label="CRYPT_XML_STATUS_INFO_STATUS"),
    "CRYPT_XML_TRANSFORM_CHAIN_CONFIG": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("cTransformInfo", SimTypeInt(signed=False, label="UInt32")), ("rgpTransformInfo", SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_XML_TRANSFORM_INFO", SimStruct), offset=0), offset=0)),)), name="CRYPT_XML_TRANSFORM_CHAIN_CONFIG", pack=False, align=None),
    "CRYPT_XML_TRANSFORM_FLAGS": SimTypeInt(signed=False, label="CRYPT_XML_TRANSFORM_FLAGS"),
    "CRYPT_XML_TRANSFORM_INFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("wszAlgorithm", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("cbBufferSize", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="CRYPT_XML_TRANSFORM_FLAGS")), ("pfnCreateTransform", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct), offset=0), SimTypePointer(SimTypeRef("CRYPT_XML_DATA_PROVIDER", SimStruct), offset=0), SimTypePointer(SimTypeRef("CRYPT_XML_DATA_PROVIDER", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTransform", "pProviderIn", "pProviderOut"]), offset=0)),)), name="CRYPT_XML_TRANSFORM_INFO", pack=False, align=None),
    "CRYPT_XML_X509DATA": SimStruct(OrderedDict((("cX509Data", SimTypeInt(signed=False, label="UInt32")), ("rgX509Data", SimTypePointer(SimTypeRef("CRYPT_XML_X509DATA_ITEM", SimStruct), offset=0)),)), name="CRYPT_XML_X509DATA", pack=False, align=None),
    "CRYPT_XML_X509DATA_ITEM": SimStruct(OrderedDict((("dwType", SimTypeInt(signed=False, label="CRYPT_XML_X509DATA_TYPE")), ("Anonymous", SimUnion({"IssuerSerial": SimTypeRef("CRYPT_XML_ISSUER_SERIAL", SimStruct), "SKI": SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct), "wszSubjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Certificate": SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct), "CRL": SimTypeRef("CRYPT_XML_DATA_BLOB", SimStruct), "Custom": SimTypeRef("CRYPT_XML_BLOB", SimStruct)}, name="<anon>", label="None")),)), name="CRYPT_XML_X509DATA_ITEM", pack=False, align=None),
    "CRYPT_XML_X509DATA_TYPE": SimTypeInt(signed=False, label="CRYPT_XML_X509DATA_TYPE"),
    "CR_DISP": SimTypeInt(signed=False, label="CR_DISP"),
    "CSADDR_INFO": SimStruct(OrderedDict((("LocalAddr", SimTypeRef("SOCKET_ADDRESS", SimStruct)), ("RemoteAddr", SimTypeRef("SOCKET_ADDRESS", SimStruct)), ("iSocketType", SimTypeInt(signed=True, label="Int32")), ("iProtocol", SimTypeInt(signed=True, label="Int32")),)), name="CSADDR_INFO", pack=False, align=None),
    "CSBACKUP_TYPE": SimTypeInt(signed=False, label="CSBACKUP_TYPE"),
    "CSC_Binding": SimTypeInt(signed=False, label="CSC_Binding"),
    "CSC_COMTIIntrinsicsConfig": SimTypeInt(signed=False, label="CSC_COMTIIntrinsicsConfig"),
    "CSC_IISIntrinsicsConfig": SimTypeInt(signed=False, label="CSC_IISIntrinsicsConfig"),
    "CSC_InheritanceConfig": SimTypeInt(signed=False, label="CSC_InheritanceConfig"),
    "CSC_PartitionConfig": SimTypeInt(signed=False, label="CSC_PartitionConfig"),
    "CSC_SxsConfig": SimTypeInt(signed=False, label="CSC_SxsConfig"),
    "CSC_SynchronizationConfig": SimTypeInt(signed=False, label="CSC_SynchronizationConfig"),
    "CSC_ThreadPool": SimTypeInt(signed=False, label="CSC_ThreadPool"),
    "CSC_TrackerConfig": SimTypeInt(signed=False, label="CSC_TrackerConfig"),
    "CSC_TransactionConfig": SimTypeInt(signed=False, label="CSC_TransactionConfig"),
    "CSEDB_RSTMAPW": SimStruct(OrderedDict((("pwszDatabaseName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("pwszNewDatabaseName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CSEDB_RSTMAPW", pack=False, align=None),
    "CSFV": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pshf", SimTypeBottom(label="IShellFolder")), ("psvOuter", SimTypeBottom(label="IShellView")), ("pidl", SimTypePointer(SimTypeRef("ITEMIDLIST", SimStruct), offset=0)), ("lEvents", SimTypeInt(signed=True, label="Int32")), ("pfnCallback", SimTypePointer(SimTypeFunction([SimTypeBottom(label="IShellView"), SimTypeBottom(label="IShellFolder"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psvOuter", "psf", "hwndMain", "uMsg", "wParam", "lParam"]), offset=0)), ("fvm", SimTypeInt(signed=False, label="FOLDERVIEWMODE")),)), name="CSFV", pack=False, align=None),
    "CSIMAADPCMWAVEFORMAT": SimStruct(OrderedDict((("wfx", SimTypeRef("WAVEFORMATEX", SimStruct)),)), name="CSIMAADPCMWAVEFORMAT", pack=False, align=None),
    "CSPLATFORM": SimStruct(OrderedDict((("dwPlatformId", SimTypeInt(signed=False, label="UInt32")), ("dwVersionHi", SimTypeInt(signed=False, label="UInt32")), ("dwVersionLo", SimTypeInt(signed=False, label="UInt32")), ("dwProcessorArch", SimTypeInt(signed=False, label="UInt32")),)), name="CSPLATFORM", pack=False, align=None),
    "CSTRING": SimStruct(OrderedDict((("Length", SimTypeShort(signed=False, label="UInt16")), ("MaximumLength", SimTypeShort(signed=False, label="UInt16")), ("Buffer", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CSTRING", pack=False, align=None),
    "CSVFS_DISK_CONNECTIVITY": SimTypeInt(signed=False, label="CSVFS_DISK_CONNECTIVITY"),
    "CSV_CONTROL_OP": SimTypeInt(signed=False, label="CSV_CONTROL_OP"),
    "CSV_CONTROL_PARAM": SimStruct(OrderedDict((("Operation", SimTypeInt(signed=False, label="CSV_CONTROL_OP")), ("Unused", SimTypeLongLong(signed=True, label="Int64")),)), name="CSV_CONTROL_PARAM", pack=False, align=None),
    "CSV_DOWN_LEVEL_FILE_TYPE": SimTypeInt(signed=False, label="CSV_DOWN_LEVEL_FILE_TYPE"),
    "CSV_DOWN_LEVEL_OPEN_ECP_CONTEXT": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("IsResume", SimTypeChar(label="Byte")), ("FileType", SimTypeInt(signed=False, label="CSV_DOWN_LEVEL_FILE_TYPE")), ("SourceNodeId", SimTypeInt(signed=False, label="UInt32")), ("DestinationNodeId", SimTypeInt(signed=False, label="UInt32")),)), name="CSV_DOWN_LEVEL_OPEN_ECP_CONTEXT", pack=False, align=None),
    "CSV_IS_OWNED_BY_CSVFS": SimStruct(OrderedDict((("OwnedByCSVFS", SimTypeChar(label="Byte")),)), name="CSV_IS_OWNED_BY_CSVFS", pack=False, align=None),
    "CSV_MGMT_LOCK": SimStruct(OrderedDict((("Flags", SimTypeInt(signed=False, label="UInt32")),)), name="CSV_MGMT_LOCK", pack=False, align=None),
    "CSV_NAMESPACE_INFO": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("DeviceNumber", SimTypeInt(signed=False, label="UInt32")), ("StartingOffset", SimTypeLongLong(signed=True, label="Int64")), ("SectorSize", SimTypeInt(signed=False, label="UInt32")),)), name="CSV_NAMESPACE_INFO", pack=False, align=None),
    "CSV_QUERY_FILE_REVISION": SimStruct(OrderedDict((("FileId", SimTypeLongLong(signed=True, label="Int64")), ("FileRevision", SimTypeArray(SimTypeLongLong(signed=True, label="Int64"), 3)),)), name="CSV_QUERY_FILE_REVISION", pack=False, align=None),
    "CSV_QUERY_FILE_REVISION_ECP_CONTEXT": SimStruct(OrderedDict((("FileId", SimTypeLongLong(signed=True, label="Int64")), ("FileRevision", SimTypeArray(SimTypeLongLong(signed=True, label="Int64"), 3)),)), name="CSV_QUERY_FILE_REVISION_ECP_CONTEXT", pack=False, align=None),
    "CSV_QUERY_FILE_REVISION_ECP_CONTEXT_FILE_ID_128": SimStruct(OrderedDict((("FileId", SimTypeRef("FILE_ID_128", SimStruct)), ("FileRevision", SimTypeArray(SimTypeLongLong(signed=True, label="Int64"), 3)),)), name="CSV_QUERY_FILE_REVISION_ECP_CONTEXT_FILE_ID_128", pack=False, align=None),
    "CSV_QUERY_FILE_REVISION_FILE_ID_128": SimStruct(OrderedDict((("FileId", SimTypeRef("FILE_ID_128", SimStruct)), ("FileRevision", SimTypeArray(SimTypeLongLong(signed=True, label="Int64"), 3)),)), name="CSV_QUERY_FILE_REVISION_FILE_ID_128", pack=False, align=None),
    "CSV_QUERY_MDS_PATH": SimStruct(OrderedDict((("MdsNodeId", SimTypeInt(signed=False, label="UInt32")), ("DsNodeId", SimTypeInt(signed=False, label="UInt32")), ("PathLength", SimTypeInt(signed=False, label="UInt32")), ("Path", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CSV_QUERY_MDS_PATH", pack=False, align=None),
    "CSV_QUERY_MDS_PATH_V2": SimStruct(OrderedDict((("Version", SimTypeLongLong(signed=True, label="Int64")), ("RequiredSize", SimTypeInt(signed=False, label="UInt32")), ("MdsNodeId", SimTypeInt(signed=False, label="UInt32")), ("DsNodeId", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("DiskConnectivity", SimTypeInt(signed=False, label="CSVFS_DISK_CONNECTIVITY")), ("VolumeId", SimTypeBottom(label="Guid")), ("IpAddressOffset", SimTypeInt(signed=False, label="UInt32")), ("IpAddressLength", SimTypeInt(signed=False, label="UInt32")), ("PathOffset", SimTypeInt(signed=False, label="UInt32")), ("PathLength", SimTypeInt(signed=False, label="UInt32")),)), name="CSV_QUERY_MDS_PATH_V2", pack=False, align=None),
    "CSV_QUERY_REDIRECT_STATE": SimStruct(OrderedDict((("MdsNodeId", SimTypeInt(signed=False, label="UInt32")), ("DsNodeId", SimTypeInt(signed=False, label="UInt32")), ("FileRedirected", SimTypeChar(label="Byte")),)), name="CSV_QUERY_REDIRECT_STATE", pack=False, align=None),
    "CSV_QUERY_VETO_FILE_DIRECT_IO_OUTPUT": SimStruct(OrderedDict((("VetoedFromAltitudeIntegral", SimTypeLongLong(signed=False, label="UInt64")), ("VetoedFromAltitudeDecimal", SimTypeLongLong(signed=False, label="UInt64")), ("Reason", SimTypeArray(SimTypeChar(label="Char"), 256)),)), name="CSV_QUERY_VETO_FILE_DIRECT_IO_OUTPUT", pack=False, align=None),
    "CSV_QUERY_VOLUME_ID": SimStruct(OrderedDict((("VolumeId", SimTypeBottom(label="Guid")),)), name="CSV_QUERY_VOLUME_ID", pack=False, align=None),
    "CSV_QUERY_VOLUME_REDIRECT_STATE": SimStruct(OrderedDict((("MdsNodeId", SimTypeInt(signed=False, label="UInt32")), ("DsNodeId", SimTypeInt(signed=False, label="UInt32")), ("IsDiskConnected", SimTypeChar(label="Byte")), ("ClusterEnableDirectIo", SimTypeChar(label="Byte")), ("DiskConnectivity", SimTypeInt(signed=False, label="CSVFS_DISK_CONNECTIVITY")),)), name="CSV_QUERY_VOLUME_REDIRECT_STATE", pack=False, align=None),
    "CSV_SET_HANDLE_PROPERTIES_ECP_CONTEXT": SimStruct(OrderedDict((("Size", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("PauseTimeoutInSeconds", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")),)), name="CSV_SET_HANDLE_PROPERTIES_ECP_CONTEXT", pack=False, align=None),
    "CSV_SET_VOLUME_ID": SimStruct(OrderedDict((("VolumeId", SimTypeBottom(label="Guid")),)), name="CSV_SET_VOLUME_ID", pack=False, align=None),
    "CS_DES": SimStruct(OrderedDict((("CSD_SignatureLength", SimTypeInt(signed=False, label="UInt32")), ("CSD_LegacyDataOffset", SimTypeInt(signed=False, label="UInt32")), ("CSD_LegacyDataSize", SimTypeInt(signed=False, label="UInt32")), ("CSD_Flags", SimTypeInt(signed=False, label="UInt32")), ("CSD_ClassGuid", SimTypeBottom(label="Guid")), ("CSD_Signature", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CS_DES", pack=False, align=None),
    "CS_RESOURCE": SimStruct(OrderedDict((("CS_Header", SimTypeRef("CS_DES", SimStruct)),)), name="CS_RESOURCE", pack=False, align=None),
    "CS_TAG_GETTING_ROUTINE": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "fServerSide", "pulSendingTag", "pulDesiredReceivingTag", "pulReceivingTag", "pStatus"]), offset=0),
    "CS_TYPE_FROM_NETCS_ROUTINE": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "pNetworkData", "ulNetworkDataLength", "ulLocalBufferSize", "pLocalData", "pulLocalDataLength", "pStatus"]), offset=0),
    "CS_TYPE_LOCAL_SIZE_ROUTINE": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="IDL_CS_CONVERT"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "ulNetworkBufferSize", "conversionType", "pulLocalBufferSize", "pStatus"]), offset=0),
    "CS_TYPE_NET_SIZE_ROUTINE": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="IDL_CS_CONVERT"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "ulLocalBufferSize", "conversionType", "pulNetworkBufferSize", "pStatus"]), offset=0),
    "CS_TYPE_TO_NETCS_ROUTINE": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "pLocalData", "ulLocalDataLength", "pNetworkData", "pulNetworkDataLength", "pStatus"]), offset=0),
    "CTAPCBOR_HYBRID_STORAGE_LINKED_DATA": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("cbContactId", SimTypeInt(signed=False, label="UInt32")), ("pbContactId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbLinkId", SimTypeInt(signed=False, label="UInt32")), ("pbLinkId", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbLinkSecret", SimTypeInt(signed=False, label="UInt32")), ("pbLinkSecret", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbPublicKey", SimTypeInt(signed=False, label="UInt32")), ("pbPublicKey", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("pwszAuthenticatorName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("wEncodedTunnelServerDomain", SimTypeShort(signed=False, label="UInt16")),)), name="CTAPCBOR_HYBRID_STORAGE_LINKED_DATA", pack=False, align=None),
    "CTL_ANY_SUBJECT_INFO": SimStruct(OrderedDict((("SubjectAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("SubjectIdentifier", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)),)), name="CTL_ANY_SUBJECT_INFO", pack=False, align=None),
    "CTL_CONTEXT": SimStruct(OrderedDict((("dwMsgAndCertEncodingType", SimTypeInt(signed=False, label="UInt32")), ("pbCtlEncoded", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbCtlEncoded", SimTypeInt(signed=False, label="UInt32")), ("pCtlInfo", SimTypePointer(SimTypeRef("CTL_INFO", SimStruct), offset=0)), ("hCertStore", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("hCryptMsg", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("pbCtlContent", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("cbCtlContent", SimTypeInt(signed=False, label="UInt32")),)), name="CTL_CONTEXT", pack=False, align=None),
    "CTL_ENTRY": SimStruct(OrderedDict((("SubjectIdentifier", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("cAttribute", SimTypeInt(signed=False, label="UInt32")), ("rgAttribute", SimTypePointer(SimTypeRef("CRYPT_ATTRIBUTE", SimStruct), offset=0)),)), name="CTL_ENTRY", pack=False, align=None),
    "CTL_FIND_SUBJECT_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("pUsagePara", SimTypePointer(SimTypeRef("CTL_FIND_USAGE_PARA", SimStruct), offset=0)), ("dwSubjectType", SimTypeInt(signed=False, label="UInt32")), ("pvSubject", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="CTL_FIND_SUBJECT_PARA", pack=False, align=None),
    "CTL_FIND_USAGE_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("SubjectUsage", SimTypeRef("CTL_USAGE", SimStruct)), ("ListIdentifier", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("pSigner", SimTypePointer(SimTypeRef("CERT_INFO", SimStruct), offset=0)),)), name="CTL_FIND_USAGE_PARA", pack=False, align=None),
    "CTL_INFO": SimStruct(OrderedDict((("dwVersion", SimTypeInt(signed=False, label="UInt32")), ("SubjectUsage", SimTypeRef("CTL_USAGE", SimStruct)), ("ListIdentifier", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("SequenceNumber", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("ThisUpdate", SimTypeRef("FILETIME", SimStruct)), ("NextUpdate", SimTypeRef("FILETIME", SimStruct)), ("SubjectAlgorithm", SimTypeRef("CRYPT_ALGORITHM_IDENTIFIER", SimStruct)), ("cCTLEntry", SimTypeInt(signed=False, label="UInt32")), ("rgCTLEntry", SimTypePointer(SimTypeRef("CTL_ENTRY", SimStruct), offset=0)), ("cExtension", SimTypeInt(signed=False, label="UInt32")), ("rgExtension", SimTypePointer(SimTypeRef("CERT_EXTENSION", SimStruct), offset=0)),)), name="CTL_INFO", pack=False, align=None),
    "CTL_MODIFY_REQUEST": SimStruct(OrderedDict((("pccert", SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0)), ("dwOperation", SimTypeInt(signed=False, label="CTL_MODIFY_REQUEST_OPERATION")), ("dwError", SimTypeInt(signed=False, label="UInt32")),)), name="CTL_MODIFY_REQUEST", pack=False, align=None),
    "CTL_MODIFY_REQUEST_OPERATION": SimTypeInt(signed=False, label="CTL_MODIFY_REQUEST_OPERATION"),
    "CTL_USAGE": SimStruct(OrderedDict((("cUsageIdentifier", SimTypeInt(signed=False, label="UInt32")), ("rgpszUsageIdentifier", SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)),)), name="CTL_USAGE", pack=False, align=None),
    "CTL_USAGE_MATCH": SimStruct(OrderedDict((("dwType", SimTypeInt(signed=False, label="UInt32")), ("Usage", SimTypeRef("CTL_USAGE", SimStruct)),)), name="CTL_USAGE_MATCH", pack=False, align=None),
    "CTL_VERIFY_USAGE_PARA": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("ListIdentifier", SimTypeRef("CRYPT_INTEGER_BLOB", SimStruct)), ("cCtlStore", SimTypeInt(signed=False, label="UInt32")), ("rghCtlStore", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)), ("cSignerStore", SimTypeInt(signed=False, label="UInt32")), ("rghSignerStore", SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)),)), name="CTL_VERIFY_USAGE_PARA", pack=False, align=None),
    "CTL_VERIFY_USAGE_STATUS": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("dwError", SimTypeInt(signed=False, label="UInt32")), ("dwFlags", SimTypeInt(signed=False, label="UInt32")), ("ppCtl", SimTypePointer(SimTypePointer(SimTypeRef("CTL_CONTEXT", SimStruct), offset=0), offset=0)), ("dwCtlEntryIndex", SimTypeInt(signed=False, label="UInt32")), ("ppSigner", SimTypePointer(SimTypePointer(SimTypeRef("CERT_CONTEXT", SimStruct), offset=0), offset=0)), ("dwSignerIndex", SimTypeInt(signed=False, label="UInt32")),)), name="CTL_VERIFY_USAGE_STATUS", pack=False, align=None),
    "CTRLINFO": SimTypeInt(signed=False, label="CTRLINFO"),
    "CTRL_LEVEL": SimTypeInt(signed=False, label="CTRL_LEVEL"),
    "CUEBANNERSTATES": SimTypeInt(signed=False, label="CUEBANNERSTATES"),
    "CURRENCYFMTA": SimStruct(OrderedDict((("NumDigits", SimTypeInt(signed=False, label="UInt32")), ("LeadingZero", SimTypeInt(signed=False, label="UInt32")), ("Grouping", SimTypeInt(signed=False, label="UInt32")), ("lpDecimalSep", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("lpThousandSep", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("NegativeOrder", SimTypeInt(signed=False, label="UInt32")), ("PositiveOrder", SimTypeInt(signed=False, label="UInt32")), ("lpCurrencySymbol", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="CURRENCYFMTA", pack=False, align=None),
    "CURRENCYFMTW": SimStruct(OrderedDict((("NumDigits", SimTypeInt(signed=False, label="UInt32")), ("LeadingZero", SimTypeInt(signed=False, label="UInt32")), ("Grouping", SimTypeInt(signed=False, label="UInt32")), ("lpDecimalSep", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("lpThousandSep", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("NegativeOrder", SimTypeInt(signed=False, label="UInt32")), ("PositiveOrder", SimTypeInt(signed=False, label="UInt32")), ("lpCurrencySymbol", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CURRENCYFMTW", pack=False, align=None),
    "CURSORINFO": SimStruct(OrderedDict((("cbSize", SimTypeInt(signed=False, label="UInt32")), ("flags", SimTypeInt(signed=False, label="CURSORINFO_FLAGS")), ("hCursor", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("ptScreenPos", SimTypeRef("POINT", SimStruct)),)), name="CURSORINFO", pack=False, align=None),
    "CURSORINFO_FLAGS": SimTypeInt(signed=False, label="CURSORINFO_FLAGS"),
    "CURSORSHAPE": SimStruct(OrderedDict((("xHotSpot", SimTypeInt(signed=True, label="Int32")), ("yHotSpot", SimTypeInt(signed=True, label="Int32")), ("cx", SimTypeInt(signed=True, label="Int32")), ("cy", SimTypeInt(signed=True, label="Int32")), ("cbWidth", SimTypeInt(signed=True, label="Int32")), ("Planes", SimTypeChar(label="Byte")), ("BitsPixel", SimTypeChar(label="Byte")),)), name="CURSORSHAPE", pack=False, align=None),
    "CUSTDATA": SimStruct(OrderedDict((("cCustData", SimTypeInt(signed=False, label="UInt32")), ("prgCustData", SimTypePointer(SimTypeRef("CUSTDATAITEM", SimStruct), offset=0)),)), name="CUSTDATA", pack=False, align=None),
    "CUSTDATAITEM": SimStruct(OrderedDict((("guid", SimTypeBottom(label="Guid")), ("varValue", SimTypeRef("VARIANT", SimStruct)),)), name="CUSTDATAITEM", pack=False, align=None),
    "CUSTOMSIZEPARAM": SimStruct(OrderedDict((("dwOrder", SimTypeInt(signed=True, label="Int32")), ("lMinVal", SimTypeInt(signed=True, label="Int32")), ("lMaxVal", SimTypeInt(signed=True, label="Int32")),)), name="CUSTOMSIZEPARAM", pack=False, align=None),
    "CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG": SimStruct(OrderedDict((("Size", SimTypeInt(signed=False, label="UInt32")), ("TriggerId", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG", pack=False, align=None),
    "CVRC_COLUMN": SimTypeInt(signed=False, label="CVRC_COLUMN"),
    "CVRC_TABLE": SimTypeInt(signed=False, label="CVRC_TABLE"),
    "CWMO_FLAGS": SimTypeInt(signed=False, label="CWMO_FLAGS"),
    "CWPRETSTRUCT": SimStruct(OrderedDict((("lResult", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("lParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("wParam", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("message", SimTypeInt(signed=False, label="UInt32")), ("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CWPRETSTRUCT", pack=False, align=None),
    "CWPSTRUCT": SimStruct(OrderedDict((("lParam", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("wParam", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("message", SimTypeInt(signed=False, label="UInt32")), ("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="CWPSTRUCT", pack=False, align=None),
    "CWP_FLAGS": SimTypeInt(signed=False, label="CWP_FLAGS"),
    "CY": SimUnion({"Anonymous": SimStruct(OrderedDict((("Lo", SimTypeInt(signed=False, label="UInt32")), ("Hi", SimTypeInt(signed=True, label="Int32")),)), name="_Anonymous_e__Struct", pack=False, align=None), "int64": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"),
    "CYPHER_BLOCK": SimStruct(OrderedDict((("data", SimTypeArray(SimTypeChar(label="SByte"), 8)),)), name="CYPHER_BLOCK", pack=False, align=None),
    "CachedBitmap": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "CallbackThreadSetFnPtr": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CallbackThreadUnsetFnPtr": SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0),
    "CallingConventionKind": SimTypeInt(signed=False, label="CallingConventionKind"),
    "CameraControlFlags": SimTypeInt(signed=False, label="CameraControlFlags"),
    "CameraControlProperty": SimTypeInt(signed=False, label="CameraControlProperty"),
    "CameraUIControlCaptureMode": SimTypeInt(signed=False, label="CameraUIControlCaptureMode"),
    "CameraUIControlLinearSelectionMode": SimTypeInt(signed=False, label="CameraUIControlLinearSelectionMode"),
    "CameraUIControlMode": SimTypeInt(signed=False, label="CameraUIControlMode"),
    "CameraUIControlPhotoFormat": SimTypeInt(signed=False, label="CameraUIControlPhotoFormat"),
    "CameraUIControlVideoFormat": SimTypeInt(signed=False, label="CameraUIControlVideoFormat"),
    "CameraUIControlViewType": SimTypeInt(signed=False, label="CameraUIControlViewType"),
    "CapStyle": SimTypeInt(signed=False, label="CapStyle"),
    "CapturedMetadataExposureCompensation": SimStruct(OrderedDict((("Flags", SimTypeLongLong(signed=False, label="UInt64")), ("Value", SimTypeInt(signed=True, label="Int32")),)), name="CapturedMetadataExposureCompensation", pack=False, align=None),
    "CapturedMetadataISOGains": SimStruct(OrderedDict((("AnalogGain", SimTypeFloat(size=32)), ("DigitalGain", SimTypeFloat(size=32)),)), name="CapturedMetadataISOGains", pack=False, align=None),
    "CapturedMetadataWhiteBalanceGains": SimStruct(OrderedDict((("R", SimTypeFloat(size=32)), ("G", SimTypeFloat(size=32)), ("B", SimTypeFloat(size=32)),)), name="CapturedMetadataWhiteBalanceGains", pack=False, align=None),
    "CaretBidiMode": SimTypeInt(signed=False, label="CaretBidiMode"),
    "CaretPosition": SimTypeInt(signed=False, label="CaretPosition"),
    "CatalogPausedReason": SimTypeInt(signed=False, label="CatalogPausedReason"),
    "CatalogStatus": SimTypeInt(signed=False, label="CatalogStatus"),
    "CertKeyType": SimTypeInt(signed=False, label="CertKeyType"),
    "ChannelChangeInfo": SimStruct(OrderedDict((("state", SimTypeInt(signed=False, label="ChannelChangeSpanningEvent_State")), ("TimeStamp", SimTypeLongLong(signed=False, label="UInt64")),)), name="ChannelChangeInfo", pack=False, align=None),
    "ChannelChangeSpanningEvent_State": SimTypeInt(signed=False, label="ChannelChangeSpanningEvent_State"),
    "ChannelInfo": SimStruct(OrderedDict((("lFrequency", SimTypeInt(signed=True, label="Int32")), ("Anonymous", SimUnion({"DVB": SimTypeRef("_DVB_e__Struct", SimStruct), "DC": SimTypeRef("_DC_e__Struct", SimStruct), "ATSC": SimTypeRef("_ATSC_e__Struct", SimStruct)}, name="<anon>", label="None")),)), name="ChannelInfo", pack=False, align=None),
    "ChannelType": SimTypeInt(signed=False, label="ChannelType"),
    "ChannelTypeInfo": SimStruct(OrderedDict((("channelType", SimTypeInt(signed=False, label="ChannelType")), ("timeStamp", SimTypeLongLong(signed=False, label="UInt64")),)), name="ChannelTypeInfo", pack=False, align=None),
    "CharacterRange": SimStruct(OrderedDict((("First", SimTypeInt(signed=True, label="Int32")), ("Length", SimTypeInt(signed=True, label="Int32")),)), name="CharacterRange", pack=False, align=None),
    "ClockType": SimTypeInt(signed=False, label="ClockType"),
    "CoalesceEventsOptions": SimTypeInt(signed=False, label="CoalesceEventsOptions"),
    "CodecAPIEventData": SimStruct(OrderedDict((("guid", SimTypeBottom(label="Guid")), ("dataLength", SimTypeInt(signed=False, label="UInt32")), ("reserved", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 3)),)), name="CodecAPIEventData", pack=False, align=None),
    "CollectionElementValue": SimStruct(OrderedDict((("Index", SimTypeInt(signed=False, label="UInt32")), ("ValueType", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("Value", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("MetadataBits", SimTypeLongLong(signed=True, label="Int64")),)), name="CollectionElementValue", pack=False, align=None),
    "Color": SimStruct(OrderedDict((("Argb", SimTypeInt(signed=False, label="UInt32")),)), name="Color", pack=False, align=None),
    "ColorAdjustType": SimTypeInt(signed=False, label="ColorAdjustType"),
    "ColorBalance": SimStruct(OrderedDict((("Base", SimTypeRef("Effect", SimStruct)),)), name="ColorBalance", pack=False, align=None),
    "ColorBalanceParams": SimStruct(OrderedDict((("cyanRed", SimTypeInt(signed=True, label="Int32")), ("magentaGreen", SimTypeInt(signed=True, label="Int32")), ("yellowBlue", SimTypeInt(signed=True, label="Int32")),)), name="ColorBalanceParams", pack=False, align=None),
    "ColorChannelFlags": SimTypeInt(signed=False, label="ColorChannelFlags"),
    "ColorCurve": SimStruct(OrderedDict((("Base", SimTypeRef("Effect", SimStruct)),)), name="ColorCurve", pack=False, align=None),
    "ColorCurveParams": SimStruct(OrderedDict((("adjustment", SimTypeInt(signed=False, label="CurveAdjustments")), ("channel", SimTypeInt(signed=False, label="CurveChannel")), ("adjustValue", SimTypeInt(signed=True, label="Int32")),)), name="ColorCurveParams", pack=False, align=None),
    "ColorLUT": SimStruct(OrderedDict((("Base", SimTypeRef("Effect", SimStruct)),)), name="ColorLUT", pack=False, align=None),
    "ColorLUTParams": SimStruct(OrderedDict((("lutB", SimTypeArray(SimTypeChar(label="Byte"), 256)), ("lutG", SimTypeArray(SimTypeChar(label="Byte"), 256)), ("lutR", SimTypeArray(SimTypeChar(label="Byte"), 256)), ("lutA", SimTypeArray(SimTypeChar(label="Byte"), 256)),)), name="ColorLUTParams", pack=False, align=None),
    "ColorMap": SimStruct(OrderedDict((("oldColor", SimTypeRef("Color", SimStruct)), ("newColor", SimTypeRef("Color", SimStruct)),)), name="ColorMap", pack=False, align=None),
    "ColorMatrix": SimStruct(OrderedDict((("m", SimTypeArray(SimTypeFloat(size=32), 25)),)), name="ColorMatrix", pack=False, align=None),
    "ColorMatrixEffect": SimStruct(OrderedDict((("Base", SimTypeRef("Effect", SimStruct)),)), name="ColorMatrixEffect", pack=False, align=None),
    "ColorMatrixFlags": SimTypeInt(signed=False, label="ColorMatrixFlags"),
    "ColorMode": SimTypeInt(signed=False, label="ColorMode"),
    "ColorPalette": SimStruct(OrderedDict((("Flags", SimTypeInt(signed=False, label="UInt32")), ("Count", SimTypeInt(signed=False, label="UInt32")), ("Entries", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)),)), name="ColorPalette", pack=False, align=None),
    "Column": SimTypeBottom(label="Column"),
    "Columns": SimTypeBottom(label="Columns"),
    "ComCallData": SimStruct(OrderedDict((("dwDispid", SimTypeInt(signed=False, label="UInt32")), ("dwReserved", SimTypeInt(signed=False, label="UInt32")), ("pUserDefined", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="ComCallData", pack=False, align=None),
    "CombineMode": SimTypeInt(signed=False, label="CombineMode"),
    "CommandStateChangeConstants": SimTypeInt(signed=False, label="CommandStateChangeConstants"),
    "CommitMode": SimTypeInt(signed=False, label="CommitMode"),
    "CommitTemplateFlags": SimTypeInt(signed=False, label="CommitTemplateFlags"),
    "ComponentCategory": SimTypeInt(signed=False, label="ComponentCategory"),
    "ComponentHangMonitorInfo": SimStruct(OrderedDict((("IsMonitored", SimTypeInt(signed=True, label="Int32")), ("TerminateOnHang", SimTypeInt(signed=True, label="Int32")), ("AvgCallThresholdInMs", SimTypeInt(signed=False, label="UInt32")),)), name="ComponentHangMonitorInfo", pack=False, align=None),
    "ComponentStatistics": SimStruct(OrderedDict((("NumInstances", SimTypeInt(signed=False, label="UInt32")), ("NumBoundReferences", SimTypeInt(signed=False, label="UInt32")), ("NumPooledObjects", SimTypeInt(signed=False, label="UInt32")), ("NumObjectsInCall", SimTypeInt(signed=False, label="UInt32")), ("AvgResponseTimeInMs", SimTypeInt(signed=False, label="UInt32")), ("NumCallsCompletedRecent", SimTypeInt(signed=False, label="UInt32")), ("NumCallsFailedRecent", SimTypeInt(signed=False, label="UInt32")), ("NumCallsCompletedTotal", SimTypeInt(signed=False, label="UInt32")), ("NumCallsFailedTotal", SimTypeInt(signed=False, label="UInt32")), ("Reserved1", SimTypeInt(signed=False, label="UInt32")), ("Reserved2", SimTypeInt(signed=False, label="UInt32")), ("Reserved3", SimTypeInt(signed=False, label="UInt32")), ("Reserved4", SimTypeInt(signed=False, label="UInt32")),)), name="ComponentStatistics", pack=False, align=None),
    "ComponentStatus": SimTypeInt(signed=False, label="ComponentStatus"),
    "ComponentSummary": SimStruct(OrderedDict((("ApplicationInstanceId", SimTypeBottom(label="Guid")), ("PartitionId", SimTypeBottom(label="Guid")), ("ApplicationId", SimTypeBottom(label="Guid")), ("Clsid", SimTypeBottom(label="Guid")), ("ClassName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("ApplicationName", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="ComponentSummary", pack=False, align=None),
    "CompositingMode": SimTypeInt(signed=False, label="CompositingMode"),
    "CompositingQuality": SimTypeInt(signed=False, label="CompositingQuality"),
    "CompositionFrameDisplayInstance": SimStruct(OrderedDict((("displayAdapterLUID", SimTypeRef("LUID", SimStruct)), ("displayVidPnSourceId", SimTypeInt(signed=False, label="UInt32")), ("displayUniqueId", SimTypeInt(signed=False, label="UInt32")), ("renderAdapterLUID", SimTypeRef("LUID", SimStruct)), ("instanceKind", SimTypeInt(signed=False, label="CompositionFrameInstanceKind")), ("finalTransform", SimTypeRef("PresentationTransform", SimStruct)), ("requiredCrossAdapterCopy", SimTypeChar(label="Byte")), ("colorSpace", SimTypeInt(signed=False, label="DXGI_COLOR_SPACE_TYPE")),)), name="CompositionFrameDisplayInstance", pack=False, align=None),
    "CompositionFrameInstanceKind": SimTypeInt(signed=False, label="CompositionFrameInstanceKind"),
    "CompressionCaps": SimTypeInt(signed=False, label="CompressionCaps"),
    "ConditionType": SimTypeInt(signed=False, label="ConditionType"),
    "ConnectionRecoveryBehaviorOptions": SimTypeInt(signed=False, label="ConnectionRecoveryBehaviorOptions"),
    "ConnectorType": SimTypeInt(signed=False, label="ConnectorType"),
    "ContextInfo": SimTypeBottom(label="ContextInfo"),
    "ContextInfo2": SimTypeBottom(label="ContextInfo2"),
    "ContextMenu": SimTypeBottom(label="ContextMenu"),
    "ContextProperty": SimStruct(OrderedDict((("policyId", SimTypeBottom(label="Guid")), ("flags", SimTypeInt(signed=False, label="UInt32")), ("pUnk", SimTypeBottom(label="IUnknown")),)), name="ContextProperty", pack=False, align=None),
    "ConvertToEmfPlusFlags": SimTypeInt(signed=False, label="ConvertToEmfPlusFlags"),
    "CookieDecision": SimStruct(OrderedDict((("dwCookieState", SimTypeInt(signed=False, label="UInt32")), ("fAllowSession", SimTypeInt(signed=True, label="Int32")),)), name="CookieDecision", pack=False, align=None),
    "CoordinateSpace": SimTypeInt(signed=False, label="CoordinateSpace"),
    "CorDebugIlToNativeMappingTypes": SimTypeInt(signed=False, label="CorDebugIlToNativeMappingTypes"),
    "CorrectionMode": SimTypeInt(signed=False, label="CorrectionMode"),
    "CorrectionPosition": SimTypeInt(signed=False, label="CorrectionPosition"),
    "CorrelationId": SimStruct(OrderedDict((("connId", SimTypeBottom(label="Guid")), ("timeStamp", SimTypeRef("FILETIME", SimStruct)),)), name="CorrelationId", pack=False, align=None),
    "CountedString": SimStruct(OrderedDict((("length", SimTypeShort(signed=False, label="UInt16")), ("string", SimTypePointer(SimTypeChar(label="Char"), offset=0)),)), name="CountedString", pack=False, align=None),
    "CounterPathCallBack": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0),
    "CreateInterfaceFnPtr": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["clsid", "riid", "ppInterface"]), offset=0),
    "CreatePackageDependencyOptions": SimTypeInt(signed=False, label="CreatePackageDependencyOptions"),
    "CredFreeCredentialsFn": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeRef("ENCRYPTED_CREDENTIALW", SimStruct), offset=0), label="LPArray", offset=0)], SimTypeBottom(label="Void"), arg_names=["Count", "Credentials"]), offset=0),
    "CredReadDomainCredentialsFn": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("LUID", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("CREDENTIAL_TARGET_INFORMATIONW", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("ENCRYPTED_CREDENTIALW", SimStruct), offset=0), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LogonId", "CredFlags", "TargetInfo", "Flags", "Count", "Credential"]), offset=0),
    "CredReadFn": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("LUID", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeRef("ENCRYPTED_CREDENTIALW", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LogonId", "CredFlags", "TargetName", "Type", "Flags", "Credential"]), offset=0),
    "CredWriteFn": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("LUID", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("ENCRYPTED_CREDENTIALW", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["LogonId", "CredFlags", "Credential", "Flags"]), offset=0),
    "CrediUnmarshalandDecodeStringFn": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MarshaledString", "Blob", "BlobSize", "IsFailureFatal"]), offset=0),
    "CrmLogRecordRead": SimStruct(OrderedDict((("dwCrmFlags", SimTypeInt(signed=False, label="UInt32")), ("dwSequenceNumber", SimTypeInt(signed=False, label="UInt32")), ("blobUserData", SimTypeRef("BLOB", SimStruct)),)), name="CrmLogRecordRead", pack=False, align=None),
    "CrmTransactionState": SimTypeInt(signed=False, label="CrmTransactionState"),
    "CryptXmlDllCloseDigest": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hDigest"]), offset=0),
    "CryptXmlDllCreateDigest": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDigestMethod", "pcbSize", "phDigest"]), offset=0),
    "CryptXmlDllCreateKey": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_BLOB", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pEncoded", "phKey"]), offset=0),
    "CryptXmlDllDigestData": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hDigest", "pbData", "cbData"]), offset=0),
    "CryptXmlDllEncodeAlgorithm": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM_INFO", SimStruct), offset=0), SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAlgInfo", "dwCharset", "pvCallbackState", "pfnWrite"]), offset=0),
    "CryptXmlDllEncodeKeyValue": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwCharset", "pvCallbackState", "pfnWrite"]), offset=0),
    "CryptXmlDllFinalizeDigest": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hDigest", "pbDigest", "cbDigest"]), offset=0),
    "CryptXmlDllGetAlgorithmInfo": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM_INFO", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pXmlAlgorithm", "ppAlgInfo"]), offset=0),
    "CryptXmlDllGetInterface": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM_INFO", SimStruct), offset=0), SimTypePointer(SimTypeRef("CRYPT_XML_CRYPTOGRAPHIC_INTERFACE", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwFlags", "pMethod", "pInterface"]), offset=0),
    "CryptXmlDllSignData": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSignatureMethod", "hCryptProvOrNCryptKey", "dwKeySpec", "pbInput", "cbInput", "pbOutput", "cbOutput", "pcbResult"]), offset=0),
    "CryptXmlDllVerifySignature": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeRef("CRYPT_XML_ALGORITHM", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSignatureMethod", "hKey", "pbInput", "cbInput", "pbSignature", "cbSignature"]), offset=0),
    "CtrlLoadFlowspec": SimStruct(OrderedDict((("CL_spec_serv_hdr", SimTypeRef("IntServServiceHdr", SimStruct)), ("CL_spec_parm_hdr", SimTypeRef("IntServParmHdr", SimStruct)), ("CL_spec_parms", SimTypeRef("GenTspecParms", SimStruct)),)), name="CtrlLoadFlowspec", pack=False, align=None),
    "CurveAdjustments": SimTypeInt(signed=False, label="CurveAdjustments"),
    "CurveChannel": SimTypeInt(signed=False, label="CurveChannel"),
    "CustomDumpItem": SimStruct(OrderedDict((("itemKind", SimTypeInt(signed=False, label="ECustomDumpItemKind")), ("Anonymous", SimUnion({"pReserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="<anon>", label="None")),)), name="CustomDumpItem", pack=False, align=None),
    "CustomLineCap": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0),
    "CustomLineCapType": SimTypeInt(signed=False, label="CustomLineCapType"),
    "D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE": SimTypeInt(signed=False, label="D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE"),
    "D2D1_2DAFFINETRANSFORM_PROP": SimTypeInt(signed=False, label="D2D1_2DAFFINETRANSFORM_PROP"),
    "D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE": SimTypeInt(signed=False, label="D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE"),
    "D2D1_3DPERSPECTIVETRANSFORM_PROP": SimTypeInt(signed=False, label="D2D1_3DPERSPECTIVETRANSFORM_PROP"),
    "D2D1_3DTRANSFORM_INTERPOLATION_MODE": SimTypeInt(signed=False, label="D2D1_3DTRANSFORM_INTERPOLATION_MODE"),
    "D2D1_3DTRANSFORM_PROP": SimTypeInt(signed=False, label="D2D1_3DTRANSFORM_PROP"),
    "D2D1_ALPHA_MODE": SimTypeInt(signed=False, label="D2D1_ALPHA_MODE"),
    "D2D1_ANTIALIAS_MODE": SimTypeInt(signed=False, label="D2D1_ANTIALIAS_MODE"),
    "D2D1_ARC_SEGMENT": SimStruct(OrderedDict((("point", SimTypeRef("D2D_POINT_2F", SimStruct)), ("size", SimTypeRef("D2D_SIZE_F", SimStruct)), ("rotationAngle", SimTypeFloat(size=32)), ("sweepDirection", SimTypeInt(signed=False, label="D2D1_SWEEP_DIRECTION")), ("arcSize", SimTypeInt(signed=False, label="D2D1_ARC_SIZE")),)), name="D2D1_ARC_SEGMENT", pack=False, align=None),
    "D2D1_ARC_SIZE": SimTypeInt(signed=False, label="D2D1_ARC_SIZE"),
    "D2D1_ARITHMETICCOMPOSITE_PROP": SimTypeInt(signed=False, label="D2D1_ARITHMETICCOMPOSITE_PROP"),
    "D2D1_ATLAS_PROP": SimTypeInt(signed=False, label="D2D1_ATLAS_PROP"),
    "D2D1_BEZIER_SEGMENT": SimStruct(OrderedDict((("point1", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point2", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point3", SimTypeRef("D2D_POINT_2F", SimStruct)),)), name="D2D1_BEZIER_SEGMENT", pack=False, align=None),
    "D2D1_BITMAPSOURCE_ALPHA_MODE": SimTypeInt(signed=False, label="D2D1_BITMAPSOURCE_ALPHA_MODE"),
    "D2D1_BITMAPSOURCE_INTERPOLATION_MODE": SimTypeInt(signed=False, label="D2D1_BITMAPSOURCE_INTERPOLATION_MODE"),
    "D2D1_BITMAPSOURCE_ORIENTATION": SimTypeInt(signed=False, label="D2D1_BITMAPSOURCE_ORIENTATION"),
    "D2D1_BITMAPSOURCE_PROP": SimTypeInt(signed=False, label="D2D1_BITMAPSOURCE_PROP"),
    "D2D1_BITMAP_BRUSH_PROPERTIES": SimStruct(OrderedDict((("extendModeX", SimTypeInt(signed=False, label="D2D1_EXTEND_MODE")), ("extendModeY", SimTypeInt(signed=False, label="D2D1_EXTEND_MODE")), ("interpolationMode", SimTypeInt(signed=False, label="D2D1_BITMAP_INTERPOLATION_MODE")),)), name="D2D1_BITMAP_BRUSH_PROPERTIES", pack=False, align=None),
    "D2D1_BITMAP_BRUSH_PROPERTIES1": SimStruct(OrderedDict((("extendModeX", SimTypeInt(signed=False, label="D2D1_EXTEND_MODE")), ("extendModeY", SimTypeInt(signed=False, label="D2D1_EXTEND_MODE")), ("interpolationMode", SimTypeInt(signed=False, label="D2D1_INTERPOLATION_MODE")),)), name="D2D1_BITMAP_BRUSH_PROPERTIES1", pack=False, align=None),
    "D2D1_BITMAP_INTERPOLATION_MODE": SimTypeInt(signed=False, label="D2D1_BITMAP_INTERPOLATION_MODE"),
    "D2D1_BITMAP_OPTIONS": SimTypeInt(signed=False, label="D2D1_BITMAP_OPTIONS"),
    "D2D1_BITMAP_PROPERTIES": SimStruct(OrderedDict((("pixelFormat", SimTypeRef("D2D1_PIXEL_FORMAT", SimStruct)), ("dpiX", SimTypeFloat(size=32)), ("dpiY", SimTypeFloat(size=32)),)), name="D2D1_BITMAP_PROPERTIES", pack=False, align=None),
    "D2D1_BITMAP_PROPERTIES1": SimStruct(OrderedDict((("pixelFormat", SimTypeRef("D2D1_PIXEL_FORMAT", SimStruct)), ("dpiX", SimTypeFloat(size=32)), ("dpiY", SimTypeFloat(size=32)), ("bitmapOptions", SimTypeInt(signed=False, label="D2D1_BITMAP_OPTIONS")), ("colorContext", SimTypeBottom(label="ID2D1ColorContext")),)), name="D2D1_BITMAP_PROPERTIES1", pack=False, align=None),
    "D2D1_BLEND": SimTypeInt(signed=False, label="D2D1_BLEND"),
    "D2D1_BLEND_DESCRIPTION": SimStruct(OrderedDict((("sourceBlend", SimTypeInt(signed=False, label="D2D1_BLEND")), ("destinationBlend", SimTypeInt(signed=False, label="D2D1_BLEND")), ("blendOperation", SimTypeInt(signed=False, label="D2D1_BLEND_OPERATION")), ("sourceBlendAlpha", SimTypeInt(signed=False, label="D2D1_BLEND")), ("destinationBlendAlpha", SimTypeInt(signed=False, label="D2D1_BLEND")), ("blendOperationAlpha", SimTypeInt(signed=False, label="D2D1_BLEND_OPERATION")), ("blendFactor", SimTypeArray(SimTypeFloat(size=32), 4)),)), name="D2D1_BLEND_DESCRIPTION", pack=False, align=None),
    "D2D1_BLEND_MODE": SimTypeInt(signed=False, label="D2D1_BLEND_MODE"),
    "D2D1_BLEND_OPERATION": SimTypeInt(signed=False, label="D2D1_BLEND_OPERATION"),
    "D2D1_BLEND_PROP": SimTypeInt(signed=False, label="D2D1_BLEND_PROP"),
    "D2D1_BORDER_EDGE_MODE": SimTypeInt(signed=False, label="D2D1_BORDER_EDGE_MODE"),
    "D2D1_BORDER_MODE": SimTypeInt(signed=False, label="D2D1_BORDER_MODE"),
    "D2D1_BORDER_PROP": SimTypeInt(signed=False, label="D2D1_BORDER_PROP"),
    "D2D1_BRIGHTNESS_PROP": SimTypeInt(signed=False, label="D2D1_BRIGHTNESS_PROP"),
    "D2D1_BRUSH_PROPERTIES": SimStruct(OrderedDict((("opacity", SimTypeFloat(size=32)), ("transform", SimTypeRef("D2D_MATRIX_3X2_F", SimStruct)),)), name="D2D1_BRUSH_PROPERTIES", pack=False, align=None),
    "D2D1_BUFFER_PRECISION": SimTypeInt(signed=False, label="D2D1_BUFFER_PRECISION"),
    "D2D1_CAP_STYLE": SimTypeInt(signed=False, label="D2D1_CAP_STYLE"),
    "D2D1_CHANGE_TYPE": SimTypeInt(signed=False, label="D2D1_CHANGE_TYPE"),
    "D2D1_CHANNEL_DEPTH": SimTypeInt(signed=False, label="D2D1_CHANNEL_DEPTH"),
    "D2D1_CHANNEL_SELECTOR": SimTypeInt(signed=False, label="D2D1_CHANNEL_SELECTOR"),
    "D2D1_CHROMAKEY_PROP": SimTypeInt(signed=False, label="D2D1_CHROMAKEY_PROP"),
    "D2D1_COLORMANAGEMENT_ALPHA_MODE": SimTypeInt(signed=False, label="D2D1_COLORMANAGEMENT_ALPHA_MODE"),
    "D2D1_COLORMANAGEMENT_PROP": SimTypeInt(signed=False, label="D2D1_COLORMANAGEMENT_PROP"),
    "D2D1_COLORMANAGEMENT_QUALITY": SimTypeInt(signed=False, label="D2D1_COLORMANAGEMENT_QUALITY"),
    "D2D1_COLORMANAGEMENT_RENDERING_INTENT": SimTypeInt(signed=False, label="D2D1_COLORMANAGEMENT_RENDERING_INTENT"),
    "D2D1_COLORMATRIX_ALPHA_MODE": SimTypeInt(signed=False, label="D2D1_COLORMATRIX_ALPHA_MODE"),
    "D2D1_COLORMATRIX_PROP": SimTypeInt(signed=False, label="D2D1_COLORMATRIX_PROP"),
    "D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION": SimTypeInt(signed=False, label="D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION"),
    "D2D1_COLOR_CONTEXT_TYPE": SimTypeInt(signed=False, label="D2D1_COLOR_CONTEXT_TYPE"),
    "D2D1_COLOR_F": SimStruct(OrderedDict((("r", SimTypeFloat(size=32)), ("g", SimTypeFloat(size=32)), ("b", SimTypeFloat(size=32)), ("a", SimTypeFloat(size=32)),)), name="D2D1_COLOR_F", pack=False, align=None),
    "D2D1_COLOR_INTERPOLATION_MODE": SimTypeInt(signed=False, label="D2D1_COLOR_INTERPOLATION_MODE"),
    "D2D1_COLOR_SPACE": SimTypeInt(signed=False, label="D2D1_COLOR_SPACE"),
    "D2D1_COMBINE_MODE": SimTypeInt(signed=False, label="D2D1_COMBINE_MODE"),
    "D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS": SimTypeInt(signed=False, label="D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS"),
    "D2D1_COMPOSITE_MODE": SimTypeInt(signed=False, label="D2D1_COMPOSITE_MODE"),
    "D2D1_COMPOSITE_PROP": SimTypeInt(signed=False, label="D2D1_COMPOSITE_PROP"),
    "D2D1_CONTRAST_PROP": SimTypeInt(signed=False, label="D2D1_CONTRAST_PROP"),
    "D2D1_CONVOLVEMATRIX_PROP": SimTypeInt(signed=False, label="D2D1_CONVOLVEMATRIX_PROP"),
    "D2D1_CONVOLVEMATRIX_SCALE_MODE": SimTypeInt(signed=False, label="D2D1_CONVOLVEMATRIX_SCALE_MODE"),
    "D2D1_CREATION_PROPERTIES": SimStruct(OrderedDict((("threadingMode", SimTypeInt(signed=False, label="D2D1_THREADING_MODE")), ("debugLevel", SimTypeInt(signed=False, label="D2D1_DEBUG_LEVEL")), ("options", SimTypeInt(signed=False, label="D2D1_DEVICE_CONTEXT_OPTIONS")),)), name="D2D1_CREATION_PROPERTIES", pack=False, align=None),
    "D2D1_CROP_PROP": SimTypeInt(signed=False, label="D2D1_CROP_PROP"),
    "D2D1_CROSSFADE_PROP": SimTypeInt(signed=False, label="D2D1_CROSSFADE_PROP"),
    "D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES": SimStruct(OrderedDict((("shaderBufferWithInputSignature", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("shaderBufferSize", SimTypeInt(signed=False, label="UInt32")), ("inputElements", SimTypePointer(SimTypeRef("D2D1_INPUT_ELEMENT_DESC", SimStruct), offset=0)), ("elementCount", SimTypeInt(signed=False, label="UInt32")), ("stride", SimTypeInt(signed=False, label="UInt32")),)), name="D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES", pack=False, align=None),
    "D2D1_DASH_STYLE": SimTypeInt(signed=False, label="D2D1_DASH_STYLE"),
    "D2D1_DC_INITIALIZE_MODE": SimTypeInt(signed=False, label="D2D1_DC_INITIALIZE_MODE"),
    "D2D1_DEBUG_LEVEL": SimTypeInt(signed=False, label="D2D1_DEBUG_LEVEL"),
    "D2D1_DEVICE_CONTEXT_OPTIONS": SimTypeInt(signed=False, label="D2D1_DEVICE_CONTEXT_OPTIONS"),
    "D2D1_DIRECTIONALBLUR_OPTIMIZATION": SimTypeInt(signed=False, label="D2D1_DIRECTIONALBLUR_OPTIMIZATION"),
    "D2D1_DIRECTIONALBLUR_PROP": SimTypeInt(signed=False, label="D2D1_DIRECTIONALBLUR_PROP"),
    "D2D1_DISCRETETRANSFER_PROP": SimTypeInt(signed=False, label="D2D1_DISCRETETRANSFER_PROP"),
    "D2D1_DISPLACEMENTMAP_PROP": SimTypeInt(signed=False, label="D2D1_DISPLACEMENTMAP_PROP"),
    "D2D1_DISTANTDIFFUSE_PROP": SimTypeInt(signed=False, label="D2D1_DISTANTDIFFUSE_PROP"),
    "D2D1_DISTANTDIFFUSE_SCALE_MODE": SimTypeInt(signed=False, label="D2D1_DISTANTDIFFUSE_SCALE_MODE"),
    "D2D1_DISTANTSPECULAR_PROP": SimTypeInt(signed=False, label="D2D1_DISTANTSPECULAR_PROP"),
    "D2D1_DISTANTSPECULAR_SCALE_MODE": SimTypeInt(signed=False, label="D2D1_DISTANTSPECULAR_SCALE_MODE"),
    "D2D1_DPICOMPENSATION_INTERPOLATION_MODE": SimTypeInt(signed=False, label="D2D1_DPICOMPENSATION_INTERPOLATION_MODE"),
    "D2D1_DPICOMPENSATION_PROP": SimTypeInt(signed=False, label="D2D1_DPICOMPENSATION_PROP"),
    "D2D1_DRAWING_STATE_DESCRIPTION": SimStruct(OrderedDict((("antialiasMode", SimTypeInt(signed=False, label="D2D1_ANTIALIAS_MODE")), ("textAntialiasMode", SimTypeInt(signed=False, label="D2D1_TEXT_ANTIALIAS_MODE")), ("tag1", SimTypeLongLong(signed=False, label="UInt64")), ("tag2", SimTypeLongLong(signed=False, label="UInt64")), ("transform", SimTypeRef("D2D_MATRIX_3X2_F", SimStruct)),)), name="D2D1_DRAWING_STATE_DESCRIPTION", pack=False, align=None),
    "D2D1_DRAWING_STATE_DESCRIPTION1": SimStruct(OrderedDict((("antialiasMode", SimTypeInt(signed=False, label="D2D1_ANTIALIAS_MODE")), ("textAntialiasMode", SimTypeInt(signed=False, label="D2D1_TEXT_ANTIALIAS_MODE")), ("tag1", SimTypeLongLong(signed=False, label="UInt64")), ("tag2", SimTypeLongLong(signed=False, label="UInt64")), ("transform", SimTypeRef("D2D_MATRIX_3X2_F", SimStruct)), ("primitiveBlend", SimTypeInt(signed=False, label="D2D1_PRIMITIVE_BLEND")), ("unitMode", SimTypeInt(signed=False, label="D2D1_UNIT_MODE")),)), name="D2D1_DRAWING_STATE_DESCRIPTION1", pack=False, align=None),
    "D2D1_DRAW_TEXT_OPTIONS": SimTypeInt(signed=False, label="D2D1_DRAW_TEXT_OPTIONS"),
    "D2D1_EDGEDETECTION_MODE": SimTypeInt(signed=False, label="D2D1_EDGEDETECTION_MODE"),
    "D2D1_EDGEDETECTION_PROP": SimTypeInt(signed=False, label="D2D1_EDGEDETECTION_PROP"),
    "D2D1_EFFECT_INPUT_DESCRIPTION": SimStruct(OrderedDict((("effect", SimTypeBottom(label="ID2D1Effect")), ("inputIndex", SimTypeInt(signed=False, label="UInt32")), ("inputRectangle", SimTypeRef("D2D_RECT_F", SimStruct)),)), name="D2D1_EFFECT_INPUT_DESCRIPTION", pack=False, align=None),
    "D2D1_ELLIPSE": SimStruct(OrderedDict((("point", SimTypeRef("D2D_POINT_2F", SimStruct)), ("radiusX", SimTypeFloat(size=32)), ("radiusY", SimTypeFloat(size=32)),)), name="D2D1_ELLIPSE", pack=False, align=None),
    "D2D1_EMBOSS_PROP": SimTypeInt(signed=False, label="D2D1_EMBOSS_PROP"),
    "D2D1_EXPOSURE_PROP": SimTypeInt(signed=False, label="D2D1_EXPOSURE_PROP"),
    "D2D1_EXTEND_MODE": SimTypeInt(signed=False, label="D2D1_EXTEND_MODE"),
    "D2D1_FACTORY_OPTIONS": SimStruct(OrderedDict((("debugLevel", SimTypeInt(signed=False, label="D2D1_DEBUG_LEVEL")),)), name="D2D1_FACTORY_OPTIONS", pack=False, align=None),
    "D2D1_FACTORY_TYPE": SimTypeInt(signed=False, label="D2D1_FACTORY_TYPE"),
    "D2D1_FEATURE": SimTypeInt(signed=False, label="D2D1_FEATURE"),
    "D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS": SimStruct(OrderedDict((("computeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x", SimTypeInt(signed=True, label="Int32")),)), name="D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS", pack=False, align=None),
    "D2D1_FEATURE_DATA_DOUBLES": SimStruct(OrderedDict((("doublePrecisionFloatShaderOps", SimTypeInt(signed=True, label="Int32")),)), name="D2D1_FEATURE_DATA_DOUBLES", pack=False, align=None),
    "D2D1_FEATURE_LEVEL": SimTypeInt(signed=False, label="D2D1_FEATURE_LEVEL"),
    "D2D1_FIGURE_BEGIN": SimTypeInt(signed=False, label="D2D1_FIGURE_BEGIN"),
    "D2D1_FIGURE_END": SimTypeInt(signed=False, label="D2D1_FIGURE_END"),
    "D2D1_FILL_MODE": SimTypeInt(signed=False, label="D2D1_FILL_MODE"),
    "D2D1_FILTER": SimTypeInt(signed=False, label="D2D1_FILTER"),
    "D2D1_FLOOD_PROP": SimTypeInt(signed=False, label="D2D1_FLOOD_PROP"),
    "D2D1_GAMMA": SimTypeInt(signed=False, label="D2D1_GAMMA"),
    "D2D1_GAMMA1": SimTypeInt(signed=False, label="D2D1_GAMMA1"),
    "D2D1_GAMMATRANSFER_PROP": SimTypeInt(signed=False, label="D2D1_GAMMATRANSFER_PROP"),
    "D2D1_GAUSSIANBLUR_OPTIMIZATION": SimTypeInt(signed=False, label="D2D1_GAUSSIANBLUR_OPTIMIZATION"),
    "D2D1_GAUSSIANBLUR_PROP": SimTypeInt(signed=False, label="D2D1_GAUSSIANBLUR_PROP"),
    "D2D1_GEOMETRY_RELATION": SimTypeInt(signed=False, label="D2D1_GEOMETRY_RELATION"),
    "D2D1_GEOMETRY_SIMPLIFICATION_OPTION": SimTypeInt(signed=False, label="D2D1_GEOMETRY_SIMPLIFICATION_OPTION"),
    "D2D1_GRADIENT_MESH_PATCH": SimStruct(OrderedDict((("point00", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point01", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point02", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point03", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point10", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point11", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point12", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point13", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point20", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point21", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point22", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point23", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point30", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point31", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point32", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point33", SimTypeRef("D2D_POINT_2F", SimStruct)), ("color00", SimTypeRef("D2D1_COLOR_F", SimStruct)), ("color03", SimTypeRef("D2D1_COLOR_F", SimStruct)), ("color30", SimTypeRef("D2D1_COLOR_F", SimStruct)), ("color33", SimTypeRef("D2D1_COLOR_F", SimStruct)), ("topEdgeMode", SimTypeInt(signed=False, label="D2D1_PATCH_EDGE_MODE")), ("leftEdgeMode", SimTypeInt(signed=False, label="D2D1_PATCH_EDGE_MODE")), ("bottomEdgeMode", SimTypeInt(signed=False, label="D2D1_PATCH_EDGE_MODE")), ("rightEdgeMode", SimTypeInt(signed=False, label="D2D1_PATCH_EDGE_MODE")),)), name="D2D1_GRADIENT_MESH_PATCH", pack=False, align=None),
    "D2D1_GRADIENT_STOP": SimStruct(OrderedDict((("position", SimTypeFloat(size=32)), ("color", SimTypeRef("D2D1_COLOR_F", SimStruct)),)), name="D2D1_GRADIENT_STOP", pack=False, align=None),
    "D2D1_HDRTONEMAP_DISPLAY_MODE": SimTypeInt(signed=False, label="D2D1_HDRTONEMAP_DISPLAY_MODE"),
    "D2D1_HDRTONEMAP_PROP": SimTypeInt(signed=False, label="D2D1_HDRTONEMAP_PROP"),
    "D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA": SimTypeInt(signed=False, label="D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA"),
    "D2D1_HIGHLIGHTSANDSHADOWS_PROP": SimTypeInt(signed=False, label="D2D1_HIGHLIGHTSANDSHADOWS_PROP"),
    "D2D1_HISTOGRAM_PROP": SimTypeInt(signed=False, label="D2D1_HISTOGRAM_PROP"),
    "D2D1_HUEROTATION_PROP": SimTypeInt(signed=False, label="D2D1_HUEROTATION_PROP"),
    "D2D1_HUETORGB_INPUT_COLOR_SPACE": SimTypeInt(signed=False, label="D2D1_HUETORGB_INPUT_COLOR_SPACE"),
    "D2D1_HUETORGB_PROP": SimTypeInt(signed=False, label="D2D1_HUETORGB_PROP"),
    "D2D1_HWND_RENDER_TARGET_PROPERTIES": SimStruct(OrderedDict((("hwnd", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("pixelSize", SimTypeRef("D2D_SIZE_U", SimStruct)), ("presentOptions", SimTypeInt(signed=False, label="D2D1_PRESENT_OPTIONS")),)), name="D2D1_HWND_RENDER_TARGET_PROPERTIES", pack=False, align=None),
    "D2D1_IMAGE_BRUSH_PROPERTIES": SimStruct(OrderedDict((("sourceRectangle", SimTypeRef("D2D_RECT_F", SimStruct)), ("extendModeX", SimTypeInt(signed=False, label="D2D1_EXTEND_MODE")), ("extendModeY", SimTypeInt(signed=False, label="D2D1_EXTEND_MODE")), ("interpolationMode", SimTypeInt(signed=False, label="D2D1_INTERPOLATION_MODE")),)), name="D2D1_IMAGE_BRUSH_PROPERTIES", pack=False, align=None),
    "D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS": SimTypeInt(signed=False, label="D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS"),
    "D2D1_IMAGE_SOURCE_LOADING_OPTIONS": SimTypeInt(signed=False, label="D2D1_IMAGE_SOURCE_LOADING_OPTIONS"),
    "D2D1_INK_BEZIER_SEGMENT": SimStruct(OrderedDict((("point1", SimTypeRef("D2D1_INK_POINT", SimStruct)), ("point2", SimTypeRef("D2D1_INK_POINT", SimStruct)), ("point3", SimTypeRef("D2D1_INK_POINT", SimStruct)),)), name="D2D1_INK_BEZIER_SEGMENT", pack=False, align=None),
    "D2D1_INK_NIB_SHAPE": SimTypeInt(signed=False, label="D2D1_INK_NIB_SHAPE"),
    "D2D1_INK_POINT": SimStruct(OrderedDict((("x", SimTypeFloat(size=32)), ("y", SimTypeFloat(size=32)), ("radius", SimTypeFloat(size=32)),)), name="D2D1_INK_POINT", pack=False, align=None),
    "D2D1_INK_STYLE_PROPERTIES": SimStruct(OrderedDict((("nibShape", SimTypeInt(signed=False, label="D2D1_INK_NIB_SHAPE")), ("nibTransform", SimTypeRef("D2D_MATRIX_3X2_F", SimStruct)),)), name="D2D1_INK_STYLE_PROPERTIES", pack=False, align=None),
    "D2D1_INPUT_DESCRIPTION": SimStruct(OrderedDict((("filter", SimTypeInt(signed=False, label="D2D1_FILTER")), ("levelOfDetailCount", SimTypeInt(signed=False, label="UInt32")),)), name="D2D1_INPUT_DESCRIPTION", pack=False, align=None),
    "D2D1_INPUT_ELEMENT_DESC": SimStruct(OrderedDict((("semanticName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("semanticIndex", SimTypeInt(signed=False, label="UInt32")), ("format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("inputSlot", SimTypeInt(signed=False, label="UInt32")), ("alignedByteOffset", SimTypeInt(signed=False, label="UInt32")),)), name="D2D1_INPUT_ELEMENT_DESC", pack=False, align=None),
    "D2D1_INTERPOLATION_MODE": SimTypeInt(signed=False, label="D2D1_INTERPOLATION_MODE"),
    "D2D1_INTERPOLATION_MODE_DEFINITION": SimTypeInt(signed=False, label="D2D1_INTERPOLATION_MODE_DEFINITION"),
    "D2D1_LAYER_OPTIONS": SimTypeInt(signed=False, label="D2D1_LAYER_OPTIONS"),
    "D2D1_LAYER_OPTIONS1": SimTypeInt(signed=False, label="D2D1_LAYER_OPTIONS1"),
    "D2D1_LAYER_PARAMETERS": SimStruct(OrderedDict((("contentBounds", SimTypeRef("D2D_RECT_F", SimStruct)), ("geometricMask", SimTypeBottom(label="ID2D1Geometry")), ("maskAntialiasMode", SimTypeInt(signed=False, label="D2D1_ANTIALIAS_MODE")), ("maskTransform", SimTypeRef("D2D_MATRIX_3X2_F", SimStruct)), ("opacity", SimTypeFloat(size=32)), ("opacityBrush", SimTypeBottom(label="ID2D1Brush")), ("layerOptions", SimTypeInt(signed=False, label="D2D1_LAYER_OPTIONS")),)), name="D2D1_LAYER_PARAMETERS", pack=False, align=None),
    "D2D1_LAYER_PARAMETERS1": SimStruct(OrderedDict((("contentBounds", SimTypeRef("D2D_RECT_F", SimStruct)), ("geometricMask", SimTypeBottom(label="ID2D1Geometry")), ("maskAntialiasMode", SimTypeInt(signed=False, label="D2D1_ANTIALIAS_MODE")), ("maskTransform", SimTypeRef("D2D_MATRIX_3X2_F", SimStruct)), ("opacity", SimTypeFloat(size=32)), ("opacityBrush", SimTypeBottom(label="ID2D1Brush")), ("layerOptions", SimTypeInt(signed=False, label="D2D1_LAYER_OPTIONS1")),)), name="D2D1_LAYER_PARAMETERS1", pack=False, align=None),
    "D2D1_LINEARTRANSFER_PROP": SimTypeInt(signed=False, label="D2D1_LINEARTRANSFER_PROP"),
    "D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES": SimStruct(OrderedDict((("startPoint", SimTypeRef("D2D_POINT_2F", SimStruct)), ("endPoint", SimTypeRef("D2D_POINT_2F", SimStruct)),)), name="D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES", pack=False, align=None),
    "D2D1_LINE_JOIN": SimTypeInt(signed=False, label="D2D1_LINE_JOIN"),
    "D2D1_LOOKUPTABLE3D_PROP": SimTypeInt(signed=False, label="D2D1_LOOKUPTABLE3D_PROP"),
    "D2D1_MAPPED_RECT": SimStruct(OrderedDict((("pitch", SimTypeInt(signed=False, label="UInt32")), ("bits", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="D2D1_MAPPED_RECT", pack=False, align=None),
    "D2D1_MAP_OPTIONS": SimTypeInt(signed=False, label="D2D1_MAP_OPTIONS"),
    "D2D1_MORPHOLOGY_MODE": SimTypeInt(signed=False, label="D2D1_MORPHOLOGY_MODE"),
    "D2D1_MORPHOLOGY_PROP": SimTypeInt(signed=False, label="D2D1_MORPHOLOGY_PROP"),
    "D2D1_OPACITYMETADATA_PROP": SimTypeInt(signed=False, label="D2D1_OPACITYMETADATA_PROP"),
    "D2D1_OPACITY_MASK_CONTENT": SimTypeInt(signed=False, label="D2D1_OPACITY_MASK_CONTENT"),
    "D2D1_OPACITY_PROP": SimTypeInt(signed=False, label="D2D1_OPACITY_PROP"),
    "D2D1_ORIENTATION": SimTypeInt(signed=False, label="D2D1_ORIENTATION"),
    "D2D1_PATCH_EDGE_MODE": SimTypeInt(signed=False, label="D2D1_PATCH_EDGE_MODE"),
    "D2D1_PATH_SEGMENT": SimTypeInt(signed=False, label="D2D1_PATH_SEGMENT"),
    "D2D1_PIXEL_FORMAT": SimStruct(OrderedDict((("format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("alphaMode", SimTypeInt(signed=False, label="D2D1_ALPHA_MODE")),)), name="D2D1_PIXEL_FORMAT", pack=False, align=None),
    "D2D1_PIXEL_OPTIONS": SimTypeInt(signed=False, label="D2D1_PIXEL_OPTIONS"),
    "D2D1_POINTDIFFUSE_PROP": SimTypeInt(signed=False, label="D2D1_POINTDIFFUSE_PROP"),
    "D2D1_POINTDIFFUSE_SCALE_MODE": SimTypeInt(signed=False, label="D2D1_POINTDIFFUSE_SCALE_MODE"),
    "D2D1_POINTSPECULAR_PROP": SimTypeInt(signed=False, label="D2D1_POINTSPECULAR_PROP"),
    "D2D1_POINTSPECULAR_SCALE_MODE": SimTypeInt(signed=False, label="D2D1_POINTSPECULAR_SCALE_MODE"),
    "D2D1_POINT_DESCRIPTION": SimStruct(OrderedDict((("point", SimTypeRef("D2D_POINT_2F", SimStruct)), ("unitTangentVector", SimTypeRef("D2D_POINT_2F", SimStruct)), ("endSegment", SimTypeInt(signed=False, label="UInt32")), ("endFigure", SimTypeInt(signed=False, label="UInt32")), ("lengthToEndSegment", SimTypeFloat(size=32)),)), name="D2D1_POINT_DESCRIPTION", pack=False, align=None),
    "D2D1_POSTERIZE_PROP": SimTypeInt(signed=False, label="D2D1_POSTERIZE_PROP"),
    "D2D1_PRESENT_OPTIONS": SimTypeInt(signed=False, label="D2D1_PRESENT_OPTIONS"),
    "D2D1_PRIMITIVE_BLEND": SimTypeInt(signed=False, label="D2D1_PRIMITIVE_BLEND"),
    "D2D1_PRINT_CONTROL_PROPERTIES": SimStruct(OrderedDict((("fontSubset", SimTypeInt(signed=False, label="D2D1_PRINT_FONT_SUBSET_MODE")), ("rasterDPI", SimTypeFloat(size=32)), ("colorSpace", SimTypeInt(signed=False, label="D2D1_COLOR_SPACE")),)), name="D2D1_PRINT_CONTROL_PROPERTIES", pack=False, align=None),
    "D2D1_PRINT_FONT_SUBSET_MODE": SimTypeInt(signed=False, label="D2D1_PRINT_FONT_SUBSET_MODE"),
    "D2D1_PROPERTY": SimTypeInt(signed=False, label="D2D1_PROPERTY"),
    "D2D1_PROPERTY_BINDING": SimStruct(OrderedDict((("propertyName", SimTypePointer(SimTypeChar(label="Char"), offset=0)), ("setFunction", SimTypePointer(SimTypeFunction([SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["effect", "data", "dataSize"]), offset=0)), ("getFunction", SimTypePointer(SimTypeFunction([SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["effect", "data", "dataSize", "actualSize"]), offset=0)),)), name="D2D1_PROPERTY_BINDING", pack=False, align=None),
    "D2D1_PROPERTY_TYPE": SimTypeInt(signed=False, label="D2D1_PROPERTY_TYPE"),
    "D2D1_QUADRATIC_BEZIER_SEGMENT": SimStruct(OrderedDict((("point1", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point2", SimTypeRef("D2D_POINT_2F", SimStruct)),)), name="D2D1_QUADRATIC_BEZIER_SEGMENT", pack=False, align=None),
    "D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES": SimStruct(OrderedDict((("center", SimTypeRef("D2D_POINT_2F", SimStruct)), ("gradientOriginOffset", SimTypeRef("D2D_POINT_2F", SimStruct)), ("radiusX", SimTypeFloat(size=32)), ("radiusY", SimTypeFloat(size=32)),)), name="D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES", pack=False, align=None),
    "D2D1_RENDERING_CONTROLS": SimStruct(OrderedDict((("bufferPrecision", SimTypeInt(signed=False, label="D2D1_BUFFER_PRECISION")), ("tileSize", SimTypeRef("D2D_SIZE_U", SimStruct)),)), name="D2D1_RENDERING_CONTROLS", pack=False, align=None),
    "D2D1_RENDERING_PRIORITY": SimTypeInt(signed=False, label="D2D1_RENDERING_PRIORITY"),
    "D2D1_RENDER_TARGET_PROPERTIES": SimStruct(OrderedDict((("type", SimTypeInt(signed=False, label="D2D1_RENDER_TARGET_TYPE")), ("pixelFormat", SimTypeRef("D2D1_PIXEL_FORMAT", SimStruct)), ("dpiX", SimTypeFloat(size=32)), ("dpiY", SimTypeFloat(size=32)), ("usage", SimTypeInt(signed=False, label="D2D1_RENDER_TARGET_USAGE")), ("minLevel", SimTypeInt(signed=False, label="D2D1_FEATURE_LEVEL")),)), name="D2D1_RENDER_TARGET_PROPERTIES", pack=False, align=None),
    "D2D1_RENDER_TARGET_TYPE": SimTypeInt(signed=False, label="D2D1_RENDER_TARGET_TYPE"),
    "D2D1_RENDER_TARGET_USAGE": SimTypeInt(signed=False, label="D2D1_RENDER_TARGET_USAGE"),
    "D2D1_RESOURCE_TEXTURE_PROPERTIES": SimStruct(OrderedDict((("extents", SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)), ("dimensions", SimTypeInt(signed=False, label="UInt32")), ("bufferPrecision", SimTypeInt(signed=False, label="D2D1_BUFFER_PRECISION")), ("channelDepth", SimTypeInt(signed=False, label="D2D1_CHANNEL_DEPTH")), ("filter", SimTypeInt(signed=False, label="D2D1_FILTER")), ("extendModes", SimTypePointer(SimTypeInt(signed=False, label="D2D1_EXTEND_MODE"), offset=0)),)), name="D2D1_RESOURCE_TEXTURE_PROPERTIES", pack=False, align=None),
    "D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE": SimTypeInt(signed=False, label="D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE"),
    "D2D1_RGBTOHUE_PROP": SimTypeInt(signed=False, label="D2D1_RGBTOHUE_PROP"),
    "D2D1_ROUNDED_RECT": SimStruct(OrderedDict((("rect", SimTypeRef("D2D_RECT_F", SimStruct)), ("radiusX", SimTypeFloat(size=32)), ("radiusY", SimTypeFloat(size=32)),)), name="D2D1_ROUNDED_RECT", pack=False, align=None),
    "D2D1_SATURATION_PROP": SimTypeInt(signed=False, label="D2D1_SATURATION_PROP"),
    "D2D1_SCALE_INTERPOLATION_MODE": SimTypeInt(signed=False, label="D2D1_SCALE_INTERPOLATION_MODE"),
    "D2D1_SCALE_PROP": SimTypeInt(signed=False, label="D2D1_SCALE_PROP"),
    "D2D1_SEPIA_PROP": SimTypeInt(signed=False, label="D2D1_SEPIA_PROP"),
    "D2D1_SHADOW_OPTIMIZATION": SimTypeInt(signed=False, label="D2D1_SHADOW_OPTIMIZATION"),
    "D2D1_SHADOW_PROP": SimTypeInt(signed=False, label="D2D1_SHADOW_PROP"),
    "D2D1_SHARPEN_PROP": SimTypeInt(signed=False, label="D2D1_SHARPEN_PROP"),
    "D2D1_SIMPLE_COLOR_PROFILE": SimStruct(OrderedDict((("redPrimary", SimTypeRef("D2D_POINT_2F", SimStruct)), ("greenPrimary", SimTypeRef("D2D_POINT_2F", SimStruct)), ("bluePrimary", SimTypeRef("D2D_POINT_2F", SimStruct)), ("whitePointXZ", SimTypeRef("D2D_POINT_2F", SimStruct)), ("gamma", SimTypeInt(signed=False, label="D2D1_GAMMA1")),)), name="D2D1_SIMPLE_COLOR_PROFILE", pack=False, align=None),
    "D2D1_SPOTDIFFUSE_PROP": SimTypeInt(signed=False, label="D2D1_SPOTDIFFUSE_PROP"),
    "D2D1_SPOTDIFFUSE_SCALE_MODE": SimTypeInt(signed=False, label="D2D1_SPOTDIFFUSE_SCALE_MODE"),
    "D2D1_SPOTSPECULAR_PROP": SimTypeInt(signed=False, label="D2D1_SPOTSPECULAR_PROP"),
    "D2D1_SPOTSPECULAR_SCALE_MODE": SimTypeInt(signed=False, label="D2D1_SPOTSPECULAR_SCALE_MODE"),
    "D2D1_SPRITE_OPTIONS": SimTypeInt(signed=False, label="D2D1_SPRITE_OPTIONS"),
    "D2D1_STRAIGHTEN_PROP": SimTypeInt(signed=False, label="D2D1_STRAIGHTEN_PROP"),
    "D2D1_STRAIGHTEN_SCALE_MODE": SimTypeInt(signed=False, label="D2D1_STRAIGHTEN_SCALE_MODE"),
    "D2D1_STROKE_STYLE_PROPERTIES": SimStruct(OrderedDict((("startCap", SimTypeInt(signed=False, label="D2D1_CAP_STYLE")), ("endCap", SimTypeInt(signed=False, label="D2D1_CAP_STYLE")), ("dashCap", SimTypeInt(signed=False, label="D2D1_CAP_STYLE")), ("lineJoin", SimTypeInt(signed=False, label="D2D1_LINE_JOIN")), ("miterLimit", SimTypeFloat(size=32)), ("dashStyle", SimTypeInt(signed=False, label="D2D1_DASH_STYLE")), ("dashOffset", SimTypeFloat(size=32)),)), name="D2D1_STROKE_STYLE_PROPERTIES", pack=False, align=None),
    "D2D1_STROKE_STYLE_PROPERTIES1": SimStruct(OrderedDict((("startCap", SimTypeInt(signed=False, label="D2D1_CAP_STYLE")), ("endCap", SimTypeInt(signed=False, label="D2D1_CAP_STYLE")), ("dashCap", SimTypeInt(signed=False, label="D2D1_CAP_STYLE")), ("lineJoin", SimTypeInt(signed=False, label="D2D1_LINE_JOIN")), ("miterLimit", SimTypeFloat(size=32)), ("dashStyle", SimTypeInt(signed=False, label="D2D1_DASH_STYLE")), ("dashOffset", SimTypeFloat(size=32)), ("transformType", SimTypeInt(signed=False, label="D2D1_STROKE_TRANSFORM_TYPE")),)), name="D2D1_STROKE_STYLE_PROPERTIES1", pack=False, align=None),
    "D2D1_STROKE_TRANSFORM_TYPE": SimTypeInt(signed=False, label="D2D1_STROKE_TRANSFORM_TYPE"),
    "D2D1_SUBPROPERTY": SimTypeInt(signed=False, label="D2D1_SUBPROPERTY"),
    "D2D1_SVG_ASPECT_ALIGN": SimTypeInt(signed=False, label="D2D1_SVG_ASPECT_ALIGN"),
    "D2D1_SVG_ASPECT_SCALING": SimTypeInt(signed=False, label="D2D1_SVG_ASPECT_SCALING"),
    "D2D1_SVG_ATTRIBUTE_POD_TYPE": SimTypeInt(signed=False, label="D2D1_SVG_ATTRIBUTE_POD_TYPE"),
    "D2D1_SVG_ATTRIBUTE_STRING_TYPE": SimTypeInt(signed=False, label="D2D1_SVG_ATTRIBUTE_STRING_TYPE"),
    "D2D1_SVG_DISPLAY": SimTypeInt(signed=False, label="D2D1_SVG_DISPLAY"),
    "D2D1_SVG_LENGTH": SimStruct(OrderedDict((("value", SimTypeFloat(size=32)), ("units", SimTypeInt(signed=False, label="D2D1_SVG_LENGTH_UNITS")),)), name="D2D1_SVG_LENGTH", pack=False, align=None),
    "D2D1_SVG_LENGTH_UNITS": SimTypeInt(signed=False, label="D2D1_SVG_LENGTH_UNITS"),
    "D2D1_SVG_LINE_CAP": SimTypeInt(signed=False, label="D2D1_SVG_LINE_CAP"),
    "D2D1_SVG_LINE_JOIN": SimTypeInt(signed=False, label="D2D1_SVG_LINE_JOIN"),
    "D2D1_SVG_OVERFLOW": SimTypeInt(signed=False, label="D2D1_SVG_OVERFLOW"),
    "D2D1_SVG_PAINT_TYPE": SimTypeInt(signed=False, label="D2D1_SVG_PAINT_TYPE"),
    "D2D1_SVG_PATH_COMMAND": SimTypeInt(signed=False, label="D2D1_SVG_PATH_COMMAND"),
    "D2D1_SVG_PRESERVE_ASPECT_RATIO": SimStruct(OrderedDict((("defer", SimTypeInt(signed=True, label="Int32")), ("align", SimTypeInt(signed=False, label="D2D1_SVG_ASPECT_ALIGN")), ("meetOrSlice", SimTypeInt(signed=False, label="D2D1_SVG_ASPECT_SCALING")),)), name="D2D1_SVG_PRESERVE_ASPECT_RATIO", pack=False, align=None),
    "D2D1_SVG_UNIT_TYPE": SimTypeInt(signed=False, label="D2D1_SVG_UNIT_TYPE"),
    "D2D1_SVG_VIEWBOX": SimStruct(OrderedDict((("x", SimTypeFloat(size=32)), ("y", SimTypeFloat(size=32)), ("width", SimTypeFloat(size=32)), ("height", SimTypeFloat(size=32)),)), name="D2D1_SVG_VIEWBOX", pack=False, align=None),
    "D2D1_SVG_VISIBILITY": SimTypeInt(signed=False, label="D2D1_SVG_VISIBILITY"),
    "D2D1_SWEEP_DIRECTION": SimTypeInt(signed=False, label="D2D1_SWEEP_DIRECTION"),
    "D2D1_TABLETRANSFER_PROP": SimTypeInt(signed=False, label="D2D1_TABLETRANSFER_PROP"),
    "D2D1_TEMPERATUREANDTINT_PROP": SimTypeInt(signed=False, label="D2D1_TEMPERATUREANDTINT_PROP"),
    "D2D1_TEXT_ANTIALIAS_MODE": SimTypeInt(signed=False, label="D2D1_TEXT_ANTIALIAS_MODE"),
    "D2D1_THREADING_MODE": SimTypeInt(signed=False, label="D2D1_THREADING_MODE"),
    "D2D1_TILE_PROP": SimTypeInt(signed=False, label="D2D1_TILE_PROP"),
    "D2D1_TINT_PROP": SimTypeInt(signed=False, label="D2D1_TINT_PROP"),
    "D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS": SimTypeInt(signed=False, label="D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS"),
    "D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES": SimStruct(OrderedDict((("orientation", SimTypeInt(signed=False, label="D2D1_ORIENTATION")), ("scaleX", SimTypeFloat(size=32)), ("scaleY", SimTypeFloat(size=32)), ("interpolationMode", SimTypeInt(signed=False, label="D2D1_INTERPOLATION_MODE")), ("options", SimTypeInt(signed=False, label="D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS")),)), name="D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES", pack=False, align=None),
    "D2D1_TRIANGLE": SimStruct(OrderedDict((("point1", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point2", SimTypeRef("D2D_POINT_2F", SimStruct)), ("point3", SimTypeRef("D2D_POINT_2F", SimStruct)),)), name="D2D1_TRIANGLE", pack=False, align=None),
    "D2D1_TURBULENCE_NOISE": SimTypeInt(signed=False, label="D2D1_TURBULENCE_NOISE"),
    "D2D1_TURBULENCE_PROP": SimTypeInt(signed=False, label="D2D1_TURBULENCE_PROP"),
    "D2D1_UNIT_MODE": SimTypeInt(signed=False, label="D2D1_UNIT_MODE"),
    "D2D1_VERTEX_BUFFER_PROPERTIES": SimStruct(OrderedDict((("inputCount", SimTypeInt(signed=False, label="UInt32")), ("usage", SimTypeInt(signed=False, label="D2D1_VERTEX_USAGE")), ("data", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("byteWidth", SimTypeInt(signed=False, label="UInt32")),)), name="D2D1_VERTEX_BUFFER_PROPERTIES", pack=False, align=None),
    "D2D1_VERTEX_OPTIONS": SimTypeInt(signed=False, label="D2D1_VERTEX_OPTIONS"),
    "D2D1_VERTEX_RANGE": SimStruct(OrderedDict((("startVertex", SimTypeInt(signed=False, label="UInt32")), ("vertexCount", SimTypeInt(signed=False, label="UInt32")),)), name="D2D1_VERTEX_RANGE", pack=False, align=None),
    "D2D1_VERTEX_USAGE": SimTypeInt(signed=False, label="D2D1_VERTEX_USAGE"),
    "D2D1_VIGNETTE_PROP": SimTypeInt(signed=False, label="D2D1_VIGNETTE_PROP"),
    "D2D1_WHITELEVELADJUSTMENT_PROP": SimTypeInt(signed=False, label="D2D1_WHITELEVELADJUSTMENT_PROP"),
    "D2D1_WINDOW_STATE": SimTypeInt(signed=False, label="D2D1_WINDOW_STATE"),
    "D2D1_YCBCR_CHROMA_SUBSAMPLING": SimTypeInt(signed=False, label="D2D1_YCBCR_CHROMA_SUBSAMPLING"),
    "D2D1_YCBCR_INTERPOLATION_MODE": SimTypeInt(signed=False, label="D2D1_YCBCR_INTERPOLATION_MODE"),
    "D2D1_YCBCR_PROP": SimTypeInt(signed=False, label="D2D1_YCBCR_PROP"),
    "D2D_COLOR_F": SimStruct(OrderedDict((("r", SimTypeFloat(size=32)), ("g", SimTypeFloat(size=32)), ("b", SimTypeFloat(size=32)), ("a", SimTypeFloat(size=32)),)), name="D2D_COLOR_F", pack=False, align=None),
    "D2D_MATRIX_3X2_F": SimStruct(OrderedDict((("Anonymous", SimUnion({"Anonymous1": SimStruct(OrderedDict((("m11", SimTypeFloat(size=32)), ("m12", SimTypeFloat(size=32)), ("m21", SimTypeFloat(size=32)), ("m22", SimTypeFloat(size=32)), ("dx", SimTypeFloat(size=32)), ("dy", SimTypeFloat(size=32)),)), name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct(OrderedDict((("_11", SimTypeFloat(size=32)), ("_12", SimTypeFloat(size=32)), ("_21", SimTypeFloat(size=32)), ("_22", SimTypeFloat(size=32)), ("_31", SimTypeFloat(size=32)), ("_32", SimTypeFloat(size=32)),)), name="_Anonymous2_e__Struct", pack=False, align=None), "m": SimTypeArray(SimTypeFloat(size=32), 6)}, name="<anon>", label="None")),)), name="D2D_MATRIX_3X2_F", pack=False, align=None),
    "D2D_MATRIX_4X3_F": SimStruct(OrderedDict((("Anonymous", SimUnion({"Anonymous": SimStruct(OrderedDict((("_11", SimTypeFloat(size=32)), ("_12", SimTypeFloat(size=32)), ("_13", SimTypeFloat(size=32)), ("_21", SimTypeFloat(size=32)), ("_22", SimTypeFloat(size=32)), ("_23", SimTypeFloat(size=32)), ("_31", SimTypeFloat(size=32)), ("_32", SimTypeFloat(size=32)), ("_33", SimTypeFloat(size=32)), ("_41", SimTypeFloat(size=32)), ("_42", SimTypeFloat(size=32)), ("_43", SimTypeFloat(size=32)),)), name="_Anonymous_e__Struct", pack=False, align=None), "m": SimTypeArray(SimTypeFloat(size=32), 12)}, name="<anon>", label="None")),)), name="D2D_MATRIX_4X3_F", pack=False, align=None),
    "D2D_MATRIX_4X4_F": SimStruct(OrderedDict((("Anonymous", SimUnion({"Anonymous": SimStruct(OrderedDict((("_11", SimTypeFloat(size=32)), ("_12", SimTypeFloat(size=32)), ("_13", SimTypeFloat(size=32)), ("_14", SimTypeFloat(size=32)), ("_21", SimTypeFloat(size=32)), ("_22", SimTypeFloat(size=32)), ("_23", SimTypeFloat(size=32)), ("_24", SimTypeFloat(size=32)), ("_31", SimTypeFloat(size=32)), ("_32", SimTypeFloat(size=32)), ("_33", SimTypeFloat(size=32)), ("_34", SimTypeFloat(size=32)), ("_41", SimTypeFloat(size=32)), ("_42", SimTypeFloat(size=32)), ("_43", SimTypeFloat(size=32)), ("_44", SimTypeFloat(size=32)),)), name="_Anonymous_e__Struct", pack=False, align=None), "m": SimTypeArray(SimTypeFloat(size=32), 16)}, name="<anon>", label="None")),)), name="D2D_MATRIX_4X4_F", pack=False, align=None),
    "D2D_MATRIX_5X4_F": SimStruct(OrderedDict((("Anonymous", SimUnion({"Anonymous": SimStruct(OrderedDict((("_11", SimTypeFloat(size=32)), ("_12", SimTypeFloat(size=32)), ("_13", SimTypeFloat(size=32)), ("_14", SimTypeFloat(size=32)), ("_21", SimTypeFloat(size=32)), ("_22", SimTypeFloat(size=32)), ("_23", SimTypeFloat(size=32)), ("_24", SimTypeFloat(size=32)), ("_31", SimTypeFloat(size=32)), ("_32", SimTypeFloat(size=32)), ("_33", SimTypeFloat(size=32)), ("_34", SimTypeFloat(size=32)), ("_41", SimTypeFloat(size=32)), ("_42", SimTypeFloat(size=32)), ("_43", SimTypeFloat(size=32)), ("_44", SimTypeFloat(size=32)), ("_51", SimTypeFloat(size=32)), ("_52", SimTypeFloat(size=32)), ("_53", SimTypeFloat(size=32)), ("_54", SimTypeFloat(size=32)),)), name="_Anonymous_e__Struct", pack=False, align=None), "m": SimTypeArray(SimTypeFloat(size=32), 20)}, name="<anon>", label="None")),)), name="D2D_MATRIX_5X4_F", pack=False, align=None),
    "D2D_POINT_2F": SimStruct(OrderedDict((("x", SimTypeFloat(size=32)), ("y", SimTypeFloat(size=32)),)), name="D2D_POINT_2F", pack=False, align=None),
    "D2D_POINT_2U": SimStruct(OrderedDict((("x", SimTypeInt(signed=False, label="UInt32")), ("y", SimTypeInt(signed=False, label="UInt32")),)), name="D2D_POINT_2U", pack=False, align=None),
    "D2D_RECT_F": SimStruct(OrderedDict((("left", SimTypeFloat(size=32)), ("top", SimTypeFloat(size=32)), ("right", SimTypeFloat(size=32)), ("bottom", SimTypeFloat(size=32)),)), name="D2D_RECT_F", pack=False, align=None),
    "D2D_RECT_U": SimStruct(OrderedDict((("left", SimTypeInt(signed=False, label="UInt32")), ("top", SimTypeInt(signed=False, label="UInt32")), ("right", SimTypeInt(signed=False, label="UInt32")), ("bottom", SimTypeInt(signed=False, label="UInt32")),)), name="D2D_RECT_U", pack=False, align=None),
    "D2D_SIZE_F": SimStruct(OrderedDict((("width", SimTypeFloat(size=32)), ("height", SimTypeFloat(size=32)),)), name="D2D_SIZE_F", pack=False, align=None),
    "D2D_SIZE_U": SimStruct(OrderedDict((("width", SimTypeInt(signed=False, label="UInt32")), ("height", SimTypeInt(signed=False, label="UInt32")),)), name="D2D_SIZE_U", pack=False, align=None),
    "D2D_VECTOR_2F": SimStruct(OrderedDict((("x", SimTypeFloat(size=32)), ("y", SimTypeFloat(size=32)),)), name="D2D_VECTOR_2F", pack=False, align=None),
    "D2D_VECTOR_3F": SimStruct(OrderedDict((("x", SimTypeFloat(size=32)), ("y", SimTypeFloat(size=32)), ("z", SimTypeFloat(size=32)),)), name="D2D_VECTOR_3F", pack=False, align=None),
    "D2D_VECTOR_4F": SimStruct(OrderedDict((("x", SimTypeFloat(size=32)), ("y", SimTypeFloat(size=32)), ("z", SimTypeFloat(size=32)), ("w", SimTypeFloat(size=32)),)), name="D2D_VECTOR_4F", pack=False, align=None),
    "D3COLD_AUX_POWER_AND_TIMING_INTERFACE": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Context", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("InterfaceReference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("InterfaceDereference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("RequestCorePowerRail", SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0)), ("RequestAuxPower", SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0)), ("RequestPerstDelay", SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0)),)), name="D3COLD_AUX_POWER_AND_TIMING_INTERFACE", pack=False, align=None),
    "D3COLD_LAST_TRANSITION_STATUS": SimTypeInt(signed=False, label="D3COLD_LAST_TRANSITION_STATUS"),
    "D3COLD_REQUEST_AUX_POWER": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Context", "AuxPowerInMilliWatts", "RetryInSeconds"]), offset=0),
    "D3COLD_REQUEST_CORE_POWER_RAIL": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte")], SimTypeBottom(label="Void"), arg_names=["Context", "CorePowerRailNeeded"]), offset=0),
    "D3COLD_REQUEST_PERST_DELAY": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Context", "DelayInMicroSeconds"]), offset=0),
    "D3COLD_SUPPORT_INTERFACE": SimStruct(OrderedDict((("Size", SimTypeShort(signed=False, label="UInt16")), ("Version", SimTypeShort(signed=False, label="UInt16")), ("Context", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("InterfaceReference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("InterfaceDereference", SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Context"]), offset=0)), ("SetD3ColdSupport", SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0)), ("GetIdleWakeInfo", SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0)), ("GetD3ColdCapability", SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0)), ("GetBusDriverD3ColdSupport", SimTypePointer(SimTypeFunction([], SimTypeInt(signed=True, label="Int32")), offset=0)), ("GetLastTransitionStatus", SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0)),)), name="D3COLD_SUPPORT_INTERFACE", pack=False, align=None),
    "D3D10_ASYNC_GETDATA_FLAG": SimTypeInt(signed=False, label="D3D10_ASYNC_GETDATA_FLAG"),
    "D3D10_BIND_FLAG": SimTypeInt(signed=False, label="D3D10_BIND_FLAG"),
    "D3D10_BLEND": SimTypeInt(signed=False, label="D3D10_BLEND"),
    "D3D10_BLEND_DESC": SimStruct(OrderedDict((("AlphaToCoverageEnable", SimTypeInt(signed=True, label="Int32")), ("BlendEnable", SimTypeArray(SimTypeInt(signed=True, label="Int32"), 8)), ("SrcBlend", SimTypeInt(signed=False, label="D3D10_BLEND")), ("DestBlend", SimTypeInt(signed=False, label="D3D10_BLEND")), ("BlendOp", SimTypeInt(signed=False, label="D3D10_BLEND_OP")), ("SrcBlendAlpha", SimTypeInt(signed=False, label="D3D10_BLEND")), ("DestBlendAlpha", SimTypeInt(signed=False, label="D3D10_BLEND")), ("BlendOpAlpha", SimTypeInt(signed=False, label="D3D10_BLEND_OP")), ("RenderTargetWriteMask", SimTypeArray(SimTypeChar(label="Byte"), 8)),)), name="D3D10_BLEND_DESC", pack=False, align=None),
    "D3D10_BLEND_DESC1": SimStruct(OrderedDict((("AlphaToCoverageEnable", SimTypeInt(signed=True, label="Int32")), ("IndependentBlendEnable", SimTypeInt(signed=True, label="Int32")), ("RenderTarget", SimTypeArray(SimTypeRef("D3D10_RENDER_TARGET_BLEND_DESC1", SimStruct), 8)),)), name="D3D10_BLEND_DESC1", pack=False, align=None),
    "D3D10_BLEND_OP": SimTypeInt(signed=False, label="D3D10_BLEND_OP"),
    "D3D10_BOX": SimStruct(OrderedDict((("left", SimTypeInt(signed=False, label="UInt32")), ("top", SimTypeInt(signed=False, label="UInt32")), ("front", SimTypeInt(signed=False, label="UInt32")), ("right", SimTypeInt(signed=False, label="UInt32")), ("bottom", SimTypeInt(signed=False, label="UInt32")), ("back", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_BOX", pack=False, align=None),
    "D3D10_BUFFER_DESC": SimStruct(OrderedDict((("ByteWidth", SimTypeInt(signed=False, label="UInt32")), ("Usage", SimTypeInt(signed=False, label="D3D10_USAGE")), ("BindFlags", SimTypeInt(signed=False, label="UInt32")), ("CPUAccessFlags", SimTypeInt(signed=False, label="UInt32")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_BUFFER_DESC", pack=False, align=None),
    "D3D10_BUFFER_RTV": SimStruct(OrderedDict((("Anonymous1", SimUnion({"FirstElement": SimTypeInt(signed=False, label="UInt32"), "ElementOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("Anonymous2", SimUnion({"NumElements": SimTypeInt(signed=False, label="UInt32"), "ElementWidth": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")),)), name="D3D10_BUFFER_RTV", pack=False, align=None),
    "D3D10_BUFFER_SRV": SimStruct(OrderedDict((("Anonymous1", SimUnion({"FirstElement": SimTypeInt(signed=False, label="UInt32"), "ElementOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("Anonymous2", SimUnion({"NumElements": SimTypeInt(signed=False, label="UInt32"), "ElementWidth": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")),)), name="D3D10_BUFFER_SRV", pack=False, align=None),
    "D3D10_CLEAR_FLAG": SimTypeInt(signed=False, label="D3D10_CLEAR_FLAG"),
    "D3D10_COLOR_WRITE_ENABLE": SimTypeInt(signed=False, label="D3D10_COLOR_WRITE_ENABLE"),
    "D3D10_COMPARISON_FUNC": SimTypeInt(signed=False, label="D3D10_COMPARISON_FUNC"),
    "D3D10_COUNTER": SimTypeInt(signed=False, label="D3D10_COUNTER"),
    "D3D10_COUNTER_DESC": SimStruct(OrderedDict((("Counter", SimTypeInt(signed=False, label="D3D10_COUNTER")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_COUNTER_DESC", pack=False, align=None),
    "D3D10_COUNTER_INFO": SimStruct(OrderedDict((("LastDeviceDependentCounter", SimTypeInt(signed=False, label="D3D10_COUNTER")), ("NumSimultaneousCounters", SimTypeInt(signed=False, label="UInt32")), ("NumDetectableParallelUnits", SimTypeChar(label="Byte")),)), name="D3D10_COUNTER_INFO", pack=False, align=None),
    "D3D10_COUNTER_TYPE": SimTypeInt(signed=False, label="D3D10_COUNTER_TYPE"),
    "D3D10_CPU_ACCESS_FLAG": SimTypeInt(signed=False, label="D3D10_CPU_ACCESS_FLAG"),
    "D3D10_CREATE_DEVICE_FLAG": SimTypeInt(signed=False, label="D3D10_CREATE_DEVICE_FLAG"),
    "D3D10_CULL_MODE": SimTypeInt(signed=False, label="D3D10_CULL_MODE"),
    "D3D10_DEPTH_STENCILOP_DESC": SimStruct(OrderedDict((("StencilFailOp", SimTypeInt(signed=False, label="D3D10_STENCIL_OP")), ("StencilDepthFailOp", SimTypeInt(signed=False, label="D3D10_STENCIL_OP")), ("StencilPassOp", SimTypeInt(signed=False, label="D3D10_STENCIL_OP")), ("StencilFunc", SimTypeInt(signed=False, label="D3D10_COMPARISON_FUNC")),)), name="D3D10_DEPTH_STENCILOP_DESC", pack=False, align=None),
    "D3D10_DEPTH_STENCIL_DESC": SimStruct(OrderedDict((("DepthEnable", SimTypeInt(signed=True, label="Int32")), ("DepthWriteMask", SimTypeInt(signed=False, label="D3D10_DEPTH_WRITE_MASK")), ("DepthFunc", SimTypeInt(signed=False, label="D3D10_COMPARISON_FUNC")), ("StencilEnable", SimTypeInt(signed=True, label="Int32")), ("StencilReadMask", SimTypeChar(label="Byte")), ("StencilWriteMask", SimTypeChar(label="Byte")), ("FrontFace", SimTypeRef("D3D10_DEPTH_STENCILOP_DESC", SimStruct)), ("BackFace", SimTypeRef("D3D10_DEPTH_STENCILOP_DESC", SimStruct)),)), name="D3D10_DEPTH_STENCIL_DESC", pack=False, align=None),
    "D3D10_DEPTH_STENCIL_VIEW_DESC": SimStruct(OrderedDict((("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("ViewDimension", SimTypeInt(signed=False, label="D3D10_DSV_DIMENSION")), ("Anonymous", SimUnion({"Texture1D": SimTypeRef("D3D10_TEX1D_DSV", SimStruct), "Texture1DArray": SimTypeRef("D3D10_TEX1D_ARRAY_DSV", SimStruct), "Texture2D": SimTypeRef("D3D10_TEX2D_DSV", SimStruct), "Texture2DArray": SimTypeRef("D3D10_TEX2D_ARRAY_DSV", SimStruct), "Texture2DMS": SimTypeRef("D3D10_TEX2DMS_DSV", SimStruct), "Texture2DMSArray": SimTypeRef("D3D10_TEX2DMS_ARRAY_DSV", SimStruct)}, name="<anon>", label="None")),)), name="D3D10_DEPTH_STENCIL_VIEW_DESC", pack=False, align=None),
    "D3D10_DEPTH_WRITE_MASK": SimTypeInt(signed=False, label="D3D10_DEPTH_WRITE_MASK"),
    "D3D10_DEVICE_STATE_TYPES": SimTypeInt(signed=False, label="D3D10_DEVICE_STATE_TYPES"),
    "D3D10_DRIVER_TYPE": SimTypeInt(signed=False, label="D3D10_DRIVER_TYPE"),
    "D3D10_DSV_DIMENSION": SimTypeInt(signed=False, label="D3D10_DSV_DIMENSION"),
    "D3D10_EFFECT_DESC": SimStruct(OrderedDict((("IsChildEffect", SimTypeInt(signed=True, label="Int32")), ("ConstantBuffers", SimTypeInt(signed=False, label="UInt32")), ("SharedConstantBuffers", SimTypeInt(signed=False, label="UInt32")), ("GlobalVariables", SimTypeInt(signed=False, label="UInt32")), ("SharedGlobalVariables", SimTypeInt(signed=False, label="UInt32")), ("Techniques", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_EFFECT_DESC", pack=False, align=None),
    "D3D10_EFFECT_SHADER_DESC": SimStruct(OrderedDict((("pInputSignature", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("IsInline", SimTypeInt(signed=True, label="Int32")), ("pBytecode", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("BytecodeLength", SimTypeInt(signed=False, label="UInt32")), ("SODecl", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("NumInputSignatureEntries", SimTypeInt(signed=False, label="UInt32")), ("NumOutputSignatureEntries", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_EFFECT_SHADER_DESC", pack=False, align=None),
    "D3D10_EFFECT_TYPE_DESC": SimStruct(OrderedDict((("TypeName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Class", SimTypeInt(signed=False, label="D3D_SHADER_VARIABLE_CLASS")), ("Type", SimTypeInt(signed=False, label="D3D_SHADER_VARIABLE_TYPE")), ("Elements", SimTypeInt(signed=False, label="UInt32")), ("Members", SimTypeInt(signed=False, label="UInt32")), ("Rows", SimTypeInt(signed=False, label="UInt32")), ("Columns", SimTypeInt(signed=False, label="UInt32")), ("PackedSize", SimTypeInt(signed=False, label="UInt32")), ("UnpackedSize", SimTypeInt(signed=False, label="UInt32")), ("Stride", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_EFFECT_TYPE_DESC", pack=False, align=None),
    "D3D10_EFFECT_VARIABLE_DESC": SimStruct(OrderedDict((("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Semantic", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("Annotations", SimTypeInt(signed=False, label="UInt32")), ("BufferOffset", SimTypeInt(signed=False, label="UInt32")), ("ExplicitBindPoint", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_EFFECT_VARIABLE_DESC", pack=False, align=None),
    "D3D10_FEATURE_LEVEL1": SimTypeInt(signed=False, label="D3D10_FEATURE_LEVEL1"),
    "D3D10_FILL_MODE": SimTypeInt(signed=False, label="D3D10_FILL_MODE"),
    "D3D10_FILTER": SimTypeInt(signed=False, label="D3D10_FILTER"),
    "D3D10_FILTER_TYPE": SimTypeInt(signed=False, label="D3D10_FILTER_TYPE"),
    "D3D10_FORMAT_SUPPORT": SimTypeInt(signed=False, label="D3D10_FORMAT_SUPPORT"),
    "D3D10_INFO_QUEUE_FILTER": SimStruct(OrderedDict((("AllowList", SimTypeRef("D3D10_INFO_QUEUE_FILTER_DESC", SimStruct)), ("DenyList", SimTypeRef("D3D10_INFO_QUEUE_FILTER_DESC", SimStruct)),)), name="D3D10_INFO_QUEUE_FILTER", pack=False, align=None),
    "D3D10_INFO_QUEUE_FILTER_DESC": SimStruct(OrderedDict((("NumCategories", SimTypeInt(signed=False, label="UInt32")), ("pCategoryList", SimTypePointer(SimTypeInt(signed=False, label="D3D10_MESSAGE_CATEGORY"), offset=0)), ("NumSeverities", SimTypeInt(signed=False, label="UInt32")), ("pSeverityList", SimTypePointer(SimTypeInt(signed=False, label="D3D10_MESSAGE_SEVERITY"), offset=0)), ("NumIDs", SimTypeInt(signed=False, label="UInt32")), ("pIDList", SimTypePointer(SimTypeInt(signed=False, label="D3D10_MESSAGE_ID"), offset=0)),)), name="D3D10_INFO_QUEUE_FILTER_DESC", pack=False, align=None),
    "D3D10_INPUT_CLASSIFICATION": SimTypeInt(signed=False, label="D3D10_INPUT_CLASSIFICATION"),
    "D3D10_INPUT_ELEMENT_DESC": SimStruct(OrderedDict((("SemanticName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("SemanticIndex", SimTypeInt(signed=False, label="UInt32")), ("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("InputSlot", SimTypeInt(signed=False, label="UInt32")), ("AlignedByteOffset", SimTypeInt(signed=False, label="UInt32")), ("InputSlotClass", SimTypeInt(signed=False, label="D3D10_INPUT_CLASSIFICATION")), ("InstanceDataStepRate", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_INPUT_ELEMENT_DESC", pack=False, align=None),
    "D3D10_MAP": SimTypeInt(signed=False, label="D3D10_MAP"),
    "D3D10_MAPPED_TEXTURE2D": SimStruct(OrderedDict((("pData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("RowPitch", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_MAPPED_TEXTURE2D", pack=False, align=None),
    "D3D10_MAPPED_TEXTURE3D": SimStruct(OrderedDict((("pData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("RowPitch", SimTypeInt(signed=False, label="UInt32")), ("DepthPitch", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_MAPPED_TEXTURE3D", pack=False, align=None),
    "D3D10_MAP_FLAG": SimTypeInt(signed=False, label="D3D10_MAP_FLAG"),
    "D3D10_MESSAGE": SimStruct(OrderedDict((("Category", SimTypeInt(signed=False, label="D3D10_MESSAGE_CATEGORY")), ("Severity", SimTypeInt(signed=False, label="D3D10_MESSAGE_SEVERITY")), ("ID", SimTypeInt(signed=False, label="D3D10_MESSAGE_ID")), ("pDescription", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("DescriptionByteLength", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="D3D10_MESSAGE", pack=False, align=None),
    "D3D10_MESSAGE_CATEGORY": SimTypeInt(signed=False, label="D3D10_MESSAGE_CATEGORY"),
    "D3D10_MESSAGE_ID": SimTypeInt(signed=False, label="D3D10_MESSAGE_ID"),
    "D3D10_MESSAGE_SEVERITY": SimTypeInt(signed=False, label="D3D10_MESSAGE_SEVERITY"),
    "D3D10_PASS_DESC": SimStruct(OrderedDict((("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Annotations", SimTypeInt(signed=False, label="UInt32")), ("pIAInputSignature", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("IAInputSignatureSize", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)), ("StencilRef", SimTypeInt(signed=False, label="UInt32")), ("SampleMask", SimTypeInt(signed=False, label="UInt32")), ("BlendFactor", SimTypeArray(SimTypeFloat(size=32), 4)),)), name="D3D10_PASS_DESC", pack=False, align=None),
    "D3D10_PASS_SHADER_DESC": SimStruct(OrderedDict((("pShaderVariable", SimTypeBottom(label="ID3D10EffectShaderVariable")), ("ShaderIndex", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_PASS_SHADER_DESC", pack=False, align=None),
    "D3D10_QUERY": SimTypeInt(signed=False, label="D3D10_QUERY"),
    "D3D10_QUERY_DATA_PIPELINE_STATISTICS": SimStruct(OrderedDict((("IAVertices", SimTypeLongLong(signed=False, label="UInt64")), ("IAPrimitives", SimTypeLongLong(signed=False, label="UInt64")), ("VSInvocations", SimTypeLongLong(signed=False, label="UInt64")), ("GSInvocations", SimTypeLongLong(signed=False, label="UInt64")), ("GSPrimitives", SimTypeLongLong(signed=False, label="UInt64")), ("CInvocations", SimTypeLongLong(signed=False, label="UInt64")), ("CPrimitives", SimTypeLongLong(signed=False, label="UInt64")), ("PSInvocations", SimTypeLongLong(signed=False, label="UInt64")),)), name="D3D10_QUERY_DATA_PIPELINE_STATISTICS", pack=False, align=None),
    "D3D10_QUERY_DATA_SO_STATISTICS": SimStruct(OrderedDict((("NumPrimitivesWritten", SimTypeLongLong(signed=False, label="UInt64")), ("PrimitivesStorageNeeded", SimTypeLongLong(signed=False, label="UInt64")),)), name="D3D10_QUERY_DATA_SO_STATISTICS", pack=False, align=None),
    "D3D10_QUERY_DATA_TIMESTAMP_DISJOINT": SimStruct(OrderedDict((("Frequency", SimTypeLongLong(signed=False, label="UInt64")), ("Disjoint", SimTypeInt(signed=True, label="Int32")),)), name="D3D10_QUERY_DATA_TIMESTAMP_DISJOINT", pack=False, align=None),
    "D3D10_QUERY_DESC": SimStruct(OrderedDict((("Query", SimTypeInt(signed=False, label="D3D10_QUERY")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_QUERY_DESC", pack=False, align=None),
    "D3D10_QUERY_MISC_FLAG": SimTypeInt(signed=False, label="D3D10_QUERY_MISC_FLAG"),
    "D3D10_RAISE_FLAG": SimTypeInt(signed=False, label="D3D10_RAISE_FLAG"),
    "D3D10_RASTERIZER_DESC": SimStruct(OrderedDict((("FillMode", SimTypeInt(signed=False, label="D3D10_FILL_MODE")), ("CullMode", SimTypeInt(signed=False, label="D3D10_CULL_MODE")), ("FrontCounterClockwise", SimTypeInt(signed=True, label="Int32")), ("DepthBias", SimTypeInt(signed=True, label="Int32")), ("DepthBiasClamp", SimTypeFloat(size=32)), ("SlopeScaledDepthBias", SimTypeFloat(size=32)), ("DepthClipEnable", SimTypeInt(signed=True, label="Int32")), ("ScissorEnable", SimTypeInt(signed=True, label="Int32")), ("MultisampleEnable", SimTypeInt(signed=True, label="Int32")), ("AntialiasedLineEnable", SimTypeInt(signed=True, label="Int32")),)), name="D3D10_RASTERIZER_DESC", pack=False, align=None),
    "D3D10_RENDER_TARGET_BLEND_DESC1": SimStruct(OrderedDict((("BlendEnable", SimTypeInt(signed=True, label="Int32")), ("SrcBlend", SimTypeInt(signed=False, label="D3D10_BLEND")), ("DestBlend", SimTypeInt(signed=False, label="D3D10_BLEND")), ("BlendOp", SimTypeInt(signed=False, label="D3D10_BLEND_OP")), ("SrcBlendAlpha", SimTypeInt(signed=False, label="D3D10_BLEND")), ("DestBlendAlpha", SimTypeInt(signed=False, label="D3D10_BLEND")), ("BlendOpAlpha", SimTypeInt(signed=False, label="D3D10_BLEND_OP")), ("RenderTargetWriteMask", SimTypeChar(label="Byte")),)), name="D3D10_RENDER_TARGET_BLEND_DESC1", pack=False, align=None),
    "D3D10_RENDER_TARGET_VIEW_DESC": SimStruct(OrderedDict((("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("ViewDimension", SimTypeInt(signed=False, label="D3D10_RTV_DIMENSION")), ("Anonymous", SimUnion({"Buffer": SimTypeRef("D3D10_BUFFER_RTV", SimStruct), "Texture1D": SimTypeRef("D3D10_TEX1D_RTV", SimStruct), "Texture1DArray": SimTypeRef("D3D10_TEX1D_ARRAY_RTV", SimStruct), "Texture2D": SimTypeRef("D3D10_TEX2D_RTV", SimStruct), "Texture2DArray": SimTypeRef("D3D10_TEX2D_ARRAY_RTV", SimStruct), "Texture2DMS": SimTypeRef("D3D10_TEX2DMS_RTV", SimStruct), "Texture2DMSArray": SimTypeRef("D3D10_TEX2DMS_ARRAY_RTV", SimStruct), "Texture3D": SimTypeRef("D3D10_TEX3D_RTV", SimStruct)}, name="<anon>", label="None")),)), name="D3D10_RENDER_TARGET_VIEW_DESC", pack=False, align=None),
    "D3D10_RESOURCE_DIMENSION": SimTypeInt(signed=False, label="D3D10_RESOURCE_DIMENSION"),
    "D3D10_RESOURCE_MISC_FLAG": SimTypeInt(signed=False, label="D3D10_RESOURCE_MISC_FLAG"),
    "D3D10_RTV_DIMENSION": SimTypeInt(signed=False, label="D3D10_RTV_DIMENSION"),
    "D3D10_SAMPLER_DESC": SimStruct(OrderedDict((("Filter", SimTypeInt(signed=False, label="D3D10_FILTER")), ("AddressU", SimTypeInt(signed=False, label="D3D10_TEXTURE_ADDRESS_MODE")), ("AddressV", SimTypeInt(signed=False, label="D3D10_TEXTURE_ADDRESS_MODE")), ("AddressW", SimTypeInt(signed=False, label="D3D10_TEXTURE_ADDRESS_MODE")), ("MipLODBias", SimTypeFloat(size=32)), ("MaxAnisotropy", SimTypeInt(signed=False, label="UInt32")), ("ComparisonFunc", SimTypeInt(signed=False, label="D3D10_COMPARISON_FUNC")), ("BorderColor", SimTypeArray(SimTypeFloat(size=32), 4)), ("MinLOD", SimTypeFloat(size=32)), ("MaxLOD", SimTypeFloat(size=32)),)), name="D3D10_SAMPLER_DESC", pack=False, align=None),
    "D3D10_SHADER_BUFFER_DESC": SimStruct(OrderedDict((("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Type", SimTypeInt(signed=False, label="D3D_CBUFFER_TYPE")), ("Variables", SimTypeInt(signed=False, label="UInt32")), ("Size", SimTypeInt(signed=False, label="UInt32")), ("uFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_BUFFER_DESC", pack=False, align=None),
    "D3D10_SHADER_DEBUG_FILE_INFO": SimStruct(OrderedDict((("FileName", SimTypeInt(signed=False, label="UInt32")), ("FileNameLen", SimTypeInt(signed=False, label="UInt32")), ("FileData", SimTypeInt(signed=False, label="UInt32")), ("FileLen", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_DEBUG_FILE_INFO", pack=False, align=None),
    "D3D10_SHADER_DEBUG_INFO": SimStruct(OrderedDict((("Size", SimTypeInt(signed=False, label="UInt32")), ("Creator", SimTypeInt(signed=False, label="UInt32")), ("EntrypointName", SimTypeInt(signed=False, label="UInt32")), ("ShaderTarget", SimTypeInt(signed=False, label="UInt32")), ("CompileFlags", SimTypeInt(signed=False, label="UInt32")), ("Files", SimTypeInt(signed=False, label="UInt32")), ("FileInfo", SimTypeInt(signed=False, label="UInt32")), ("Instructions", SimTypeInt(signed=False, label="UInt32")), ("InstructionInfo", SimTypeInt(signed=False, label="UInt32")), ("Variables", SimTypeInt(signed=False, label="UInt32")), ("VariableInfo", SimTypeInt(signed=False, label="UInt32")), ("InputVariables", SimTypeInt(signed=False, label="UInt32")), ("InputVariableInfo", SimTypeInt(signed=False, label="UInt32")), ("Tokens", SimTypeInt(signed=False, label="UInt32")), ("TokenInfo", SimTypeInt(signed=False, label="UInt32")), ("Scopes", SimTypeInt(signed=False, label="UInt32")), ("ScopeInfo", SimTypeInt(signed=False, label="UInt32")), ("ScopeVariables", SimTypeInt(signed=False, label="UInt32")), ("ScopeVariableInfo", SimTypeInt(signed=False, label="UInt32")), ("UintOffset", SimTypeInt(signed=False, label="UInt32")), ("StringOffset", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_DEBUG_INFO", pack=False, align=None),
    "D3D10_SHADER_DEBUG_INPUT_INFO": SimStruct(OrderedDict((("Var", SimTypeInt(signed=False, label="UInt32")), ("InitialRegisterSet", SimTypeInt(signed=False, label="D3D10_SHADER_DEBUG_REGTYPE")), ("InitialBank", SimTypeInt(signed=False, label="UInt32")), ("InitialRegister", SimTypeInt(signed=False, label="UInt32")), ("InitialComponent", SimTypeInt(signed=False, label="UInt32")), ("InitialValue", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_DEBUG_INPUT_INFO", pack=False, align=None),
    "D3D10_SHADER_DEBUG_INST_INFO": SimStruct(OrderedDict((("Id", SimTypeInt(signed=False, label="UInt32")), ("Opcode", SimTypeInt(signed=False, label="UInt32")), ("uOutputs", SimTypeInt(signed=False, label="UInt32")), ("pOutputs", SimTypeArray(SimTypeRef("D3D10_SHADER_DEBUG_OUTPUTREG_INFO", SimStruct), 2)), ("TokenId", SimTypeInt(signed=False, label="UInt32")), ("NestingLevel", SimTypeInt(signed=False, label="UInt32")), ("Scopes", SimTypeInt(signed=False, label="UInt32")), ("ScopeInfo", SimTypeInt(signed=False, label="UInt32")), ("AccessedVars", SimTypeInt(signed=False, label="UInt32")), ("AccessedVarsInfo", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_DEBUG_INST_INFO", pack=False, align=None),
    "D3D10_SHADER_DEBUG_OUTPUTREG_INFO": SimStruct(OrderedDict((("OutputRegisterSet", SimTypeInt(signed=False, label="D3D10_SHADER_DEBUG_REGTYPE")), ("OutputReg", SimTypeInt(signed=False, label="UInt32")), ("TempArrayReg", SimTypeInt(signed=False, label="UInt32")), ("OutputComponents", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)), ("OutputVars", SimTypeArray(SimTypeRef("D3D10_SHADER_DEBUG_OUTPUTVAR", SimStruct), 4)), ("IndexReg", SimTypeInt(signed=False, label="UInt32")), ("IndexComp", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_DEBUG_OUTPUTREG_INFO", pack=False, align=None),
    "D3D10_SHADER_DEBUG_OUTPUTVAR": SimStruct(OrderedDict((("Var", SimTypeInt(signed=False, label="UInt32")), ("uValueMin", SimTypeInt(signed=False, label="UInt32")), ("uValueMax", SimTypeInt(signed=False, label="UInt32")), ("iValueMin", SimTypeInt(signed=True, label="Int32")), ("iValueMax", SimTypeInt(signed=True, label="Int32")), ("fValueMin", SimTypeFloat(size=32)), ("fValueMax", SimTypeFloat(size=32)), ("bNaNPossible", SimTypeInt(signed=True, label="Int32")), ("bInfPossible", SimTypeInt(signed=True, label="Int32")),)), name="D3D10_SHADER_DEBUG_OUTPUTVAR", pack=False, align=None),
    "D3D10_SHADER_DEBUG_REGTYPE": SimTypeInt(signed=False, label="D3D10_SHADER_DEBUG_REGTYPE"),
    "D3D10_SHADER_DEBUG_SCOPETYPE": SimTypeInt(signed=False, label="D3D10_SHADER_DEBUG_SCOPETYPE"),
    "D3D10_SHADER_DEBUG_SCOPEVAR_INFO": SimStruct(OrderedDict((("TokenId", SimTypeInt(signed=False, label="UInt32")), ("VarType", SimTypeInt(signed=False, label="D3D10_SHADER_DEBUG_VARTYPE")), ("Class", SimTypeInt(signed=False, label="D3D_SHADER_VARIABLE_CLASS")), ("Rows", SimTypeInt(signed=False, label="UInt32")), ("Columns", SimTypeInt(signed=False, label="UInt32")), ("StructMemberScope", SimTypeInt(signed=False, label="UInt32")), ("uArrayIndices", SimTypeInt(signed=False, label="UInt32")), ("ArrayElements", SimTypeInt(signed=False, label="UInt32")), ("ArrayStrides", SimTypeInt(signed=False, label="UInt32")), ("uVariables", SimTypeInt(signed=False, label="UInt32")), ("uFirstVariable", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_DEBUG_SCOPEVAR_INFO", pack=False, align=None),
    "D3D10_SHADER_DEBUG_SCOPE_INFO": SimStruct(OrderedDict((("ScopeType", SimTypeInt(signed=False, label="D3D10_SHADER_DEBUG_SCOPETYPE")), ("Name", SimTypeInt(signed=False, label="UInt32")), ("uNameLen", SimTypeInt(signed=False, label="UInt32")), ("uVariables", SimTypeInt(signed=False, label="UInt32")), ("VariableData", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_DEBUG_SCOPE_INFO", pack=False, align=None),
    "D3D10_SHADER_DEBUG_TOKEN_INFO": SimStruct(OrderedDict((("File", SimTypeInt(signed=False, label="UInt32")), ("Line", SimTypeInt(signed=False, label="UInt32")), ("Column", SimTypeInt(signed=False, label="UInt32")), ("TokenLength", SimTypeInt(signed=False, label="UInt32")), ("TokenId", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_DEBUG_TOKEN_INFO", pack=False, align=None),
    "D3D10_SHADER_DEBUG_VARTYPE": SimTypeInt(signed=False, label="D3D10_SHADER_DEBUG_VARTYPE"),
    "D3D10_SHADER_DEBUG_VAR_INFO": SimStruct(OrderedDict((("TokenId", SimTypeInt(signed=False, label="UInt32")), ("Type", SimTypeInt(signed=False, label="D3D_SHADER_VARIABLE_TYPE")), ("Register", SimTypeInt(signed=False, label="UInt32")), ("Component", SimTypeInt(signed=False, label="UInt32")), ("ScopeVar", SimTypeInt(signed=False, label="UInt32")), ("ScopeVarOffset", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_DEBUG_VAR_INFO", pack=False, align=None),
    "D3D10_SHADER_DESC": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("Creator", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("ConstantBuffers", SimTypeInt(signed=False, label="UInt32")), ("BoundResources", SimTypeInt(signed=False, label="UInt32")), ("InputParameters", SimTypeInt(signed=False, label="UInt32")), ("OutputParameters", SimTypeInt(signed=False, label="UInt32")), ("InstructionCount", SimTypeInt(signed=False, label="UInt32")), ("TempRegisterCount", SimTypeInt(signed=False, label="UInt32")), ("TempArrayCount", SimTypeInt(signed=False, label="UInt32")), ("DefCount", SimTypeInt(signed=False, label="UInt32")), ("DclCount", SimTypeInt(signed=False, label="UInt32")), ("TextureNormalInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureLoadInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureCompInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureBiasInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureGradientInstructions", SimTypeInt(signed=False, label="UInt32")), ("FloatInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("IntInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("UintInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("StaticFlowControlCount", SimTypeInt(signed=False, label="UInt32")), ("DynamicFlowControlCount", SimTypeInt(signed=False, label="UInt32")), ("MacroInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("ArrayInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("CutInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("EmitInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("GSOutputTopology", SimTypeInt(signed=False, label="D3D_PRIMITIVE_TOPOLOGY")), ("GSMaxOutputVertexCount", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_DESC", pack=False, align=None),
    "D3D10_SHADER_INPUT_BIND_DESC": SimStruct(OrderedDict((("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Type", SimTypeInt(signed=False, label="D3D_SHADER_INPUT_TYPE")), ("BindPoint", SimTypeInt(signed=False, label="UInt32")), ("BindCount", SimTypeInt(signed=False, label="UInt32")), ("uFlags", SimTypeInt(signed=False, label="UInt32")), ("ReturnType", SimTypeInt(signed=False, label="D3D_RESOURCE_RETURN_TYPE")), ("Dimension", SimTypeInt(signed=False, label="D3D_SRV_DIMENSION")), ("NumSamples", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_INPUT_BIND_DESC", pack=False, align=None),
    "D3D10_SHADER_RESOURCE_VIEW_DESC": SimStruct(OrderedDict((("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("ViewDimension", SimTypeInt(signed=False, label="D3D_SRV_DIMENSION")), ("Anonymous", SimUnion({"Buffer": SimTypeRef("D3D10_BUFFER_SRV", SimStruct), "Texture1D": SimTypeRef("D3D10_TEX1D_SRV", SimStruct), "Texture1DArray": SimTypeRef("D3D10_TEX1D_ARRAY_SRV", SimStruct), "Texture2D": SimTypeRef("D3D10_TEX2D_SRV", SimStruct), "Texture2DArray": SimTypeRef("D3D10_TEX2D_ARRAY_SRV", SimStruct), "Texture2DMS": SimTypeRef("D3D10_TEX2DMS_SRV", SimStruct), "Texture2DMSArray": SimTypeRef("D3D10_TEX2DMS_ARRAY_SRV", SimStruct), "Texture3D": SimTypeRef("D3D10_TEX3D_SRV", SimStruct), "TextureCube": SimTypeRef("D3D10_TEXCUBE_SRV", SimStruct)}, name="<anon>", label="None")),)), name="D3D10_SHADER_RESOURCE_VIEW_DESC", pack=False, align=None),
    "D3D10_SHADER_RESOURCE_VIEW_DESC1": SimStruct(OrderedDict((("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("ViewDimension", SimTypeInt(signed=False, label="D3D_SRV_DIMENSION")), ("Anonymous", SimUnion({"Buffer": SimTypeRef("D3D10_BUFFER_SRV", SimStruct), "Texture1D": SimTypeRef("D3D10_TEX1D_SRV", SimStruct), "Texture1DArray": SimTypeRef("D3D10_TEX1D_ARRAY_SRV", SimStruct), "Texture2D": SimTypeRef("D3D10_TEX2D_SRV", SimStruct), "Texture2DArray": SimTypeRef("D3D10_TEX2D_ARRAY_SRV", SimStruct), "Texture2DMS": SimTypeRef("D3D10_TEX2DMS_SRV", SimStruct), "Texture2DMSArray": SimTypeRef("D3D10_TEX2DMS_ARRAY_SRV", SimStruct), "Texture3D": SimTypeRef("D3D10_TEX3D_SRV", SimStruct), "TextureCube": SimTypeRef("D3D10_TEXCUBE_SRV", SimStruct), "TextureCubeArray": SimTypeRef("D3D10_TEXCUBE_ARRAY_SRV1", SimStruct)}, name="<anon>", label="None")),)), name="D3D10_SHADER_RESOURCE_VIEW_DESC1", pack=False, align=None),
    "D3D10_SHADER_TYPE_DESC": SimStruct(OrderedDict((("Class", SimTypeInt(signed=False, label="D3D_SHADER_VARIABLE_CLASS")), ("Type", SimTypeInt(signed=False, label="D3D_SHADER_VARIABLE_TYPE")), ("Rows", SimTypeInt(signed=False, label="UInt32")), ("Columns", SimTypeInt(signed=False, label="UInt32")), ("Elements", SimTypeInt(signed=False, label="UInt32")), ("Members", SimTypeInt(signed=False, label="UInt32")), ("Offset", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SHADER_TYPE_DESC", pack=False, align=None),
    "D3D10_SHADER_VARIABLE_DESC": SimStruct(OrderedDict((("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("StartOffset", SimTypeInt(signed=False, label="UInt32")), ("Size", SimTypeInt(signed=False, label="UInt32")), ("uFlags", SimTypeInt(signed=False, label="UInt32")), ("DefaultValue", SimTypePointer(SimTypeBottom(label="Void"), offset=0)),)), name="D3D10_SHADER_VARIABLE_DESC", pack=False, align=None),
    "D3D10_SIGNATURE_PARAMETER_DESC": SimStruct(OrderedDict((("SemanticName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("SemanticIndex", SimTypeInt(signed=False, label="UInt32")), ("Register", SimTypeInt(signed=False, label="UInt32")), ("SystemValueType", SimTypeInt(signed=False, label="D3D_NAME")), ("ComponentType", SimTypeInt(signed=False, label="D3D_REGISTER_COMPONENT_TYPE")), ("Mask", SimTypeChar(label="Byte")), ("ReadWriteMask", SimTypeChar(label="Byte")),)), name="D3D10_SIGNATURE_PARAMETER_DESC", pack=False, align=None),
    "D3D10_SO_DECLARATION_ENTRY": SimStruct(OrderedDict((("SemanticName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("SemanticIndex", SimTypeInt(signed=False, label="UInt32")), ("StartComponent", SimTypeChar(label="Byte")), ("ComponentCount", SimTypeChar(label="Byte")), ("OutputSlot", SimTypeChar(label="Byte")),)), name="D3D10_SO_DECLARATION_ENTRY", pack=False, align=None),
    "D3D10_STANDARD_MULTISAMPLE_QUALITY_LEVELS": SimTypeInt(signed=False, label="D3D10_STANDARD_MULTISAMPLE_QUALITY_LEVELS"),
    "D3D10_STATE_BLOCK_MASK": SimStruct(OrderedDict((("VS", SimTypeChar(label="Byte")), ("VSSamplers", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("VSShaderResources", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("VSConstantBuffers", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("GS", SimTypeChar(label="Byte")), ("GSSamplers", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("GSShaderResources", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("GSConstantBuffers", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("PS", SimTypeChar(label="Byte")), ("PSSamplers", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("PSShaderResources", SimTypeArray(SimTypeChar(label="Byte"), 16)), ("PSConstantBuffers", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("IAVertexBuffers", SimTypeArray(SimTypeChar(label="Byte"), 2)), ("IAIndexBuffer", SimTypeChar(label="Byte")), ("IAInputLayout", SimTypeChar(label="Byte")), ("IAPrimitiveTopology", SimTypeChar(label="Byte")), ("OMRenderTargets", SimTypeChar(label="Byte")), ("OMDepthStencilState", SimTypeChar(label="Byte")), ("OMBlendState", SimTypeChar(label="Byte")), ("RSViewports", SimTypeChar(label="Byte")), ("RSScissorRects", SimTypeChar(label="Byte")), ("RSRasterizerState", SimTypeChar(label="Byte")), ("SOBuffers", SimTypeChar(label="Byte")), ("Predication", SimTypeChar(label="Byte")),)), name="D3D10_STATE_BLOCK_MASK", pack=False, align=None),
    "D3D10_STENCIL_OP": SimTypeInt(signed=False, label="D3D10_STENCIL_OP"),
    "D3D10_SUBRESOURCE_DATA": SimStruct(OrderedDict((("pSysMem", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("SysMemPitch", SimTypeInt(signed=False, label="UInt32")), ("SysMemSlicePitch", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_SUBRESOURCE_DATA", pack=False, align=None),
    "D3D10_TECHNIQUE_DESC": SimStruct(OrderedDict((("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Passes", SimTypeInt(signed=False, label="UInt32")), ("Annotations", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TECHNIQUE_DESC", pack=False, align=None),
    "D3D10_TEX1D_ARRAY_DSV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX1D_ARRAY_DSV", pack=False, align=None),
    "D3D10_TEX1D_ARRAY_RTV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX1D_ARRAY_RTV", pack=False, align=None),
    "D3D10_TEX1D_ARRAY_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX1D_ARRAY_SRV", pack=False, align=None),
    "D3D10_TEX1D_DSV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX1D_DSV", pack=False, align=None),
    "D3D10_TEX1D_RTV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX1D_RTV", pack=False, align=None),
    "D3D10_TEX1D_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX1D_SRV", pack=False, align=None),
    "D3D10_TEX2DMS_ARRAY_DSV": SimStruct(OrderedDict((("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2DMS_ARRAY_DSV", pack=False, align=None),
    "D3D10_TEX2DMS_ARRAY_RTV": SimStruct(OrderedDict((("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2DMS_ARRAY_RTV", pack=False, align=None),
    "D3D10_TEX2DMS_ARRAY_SRV": SimStruct(OrderedDict((("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2DMS_ARRAY_SRV", pack=False, align=None),
    "D3D10_TEX2DMS_DSV": SimStruct(OrderedDict((("UnusedField_NothingToDefine", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2DMS_DSV", pack=False, align=None),
    "D3D10_TEX2DMS_RTV": SimStruct(OrderedDict((("UnusedField_NothingToDefine", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2DMS_RTV", pack=False, align=None),
    "D3D10_TEX2DMS_SRV": SimStruct(OrderedDict((("UnusedField_NothingToDefine", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2DMS_SRV", pack=False, align=None),
    "D3D10_TEX2D_ARRAY_DSV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2D_ARRAY_DSV", pack=False, align=None),
    "D3D10_TEX2D_ARRAY_RTV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2D_ARRAY_RTV", pack=False, align=None),
    "D3D10_TEX2D_ARRAY_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2D_ARRAY_SRV", pack=False, align=None),
    "D3D10_TEX2D_DSV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2D_DSV", pack=False, align=None),
    "D3D10_TEX2D_RTV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2D_RTV", pack=False, align=None),
    "D3D10_TEX2D_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX2D_SRV", pack=False, align=None),
    "D3D10_TEX3D_RTV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstWSlice", SimTypeInt(signed=False, label="UInt32")), ("WSize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX3D_RTV", pack=False, align=None),
    "D3D10_TEX3D_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEX3D_SRV", pack=False, align=None),
    "D3D10_TEXCUBE_ARRAY_SRV1": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("First2DArrayFace", SimTypeInt(signed=False, label="UInt32")), ("NumCubes", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEXCUBE_ARRAY_SRV1", pack=False, align=None),
    "D3D10_TEXCUBE_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEXCUBE_SRV", pack=False, align=None),
    "D3D10_TEXTURE1D_DESC": SimStruct(OrderedDict((("Width", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")), ("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("Usage", SimTypeInt(signed=False, label="D3D10_USAGE")), ("BindFlags", SimTypeInt(signed=False, label="UInt32")), ("CPUAccessFlags", SimTypeInt(signed=False, label="UInt32")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEXTURE1D_DESC", pack=False, align=None),
    "D3D10_TEXTURE2D_DESC": SimStruct(OrderedDict((("Width", SimTypeInt(signed=False, label="UInt32")), ("Height", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")), ("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("SampleDesc", SimTypeRef("DXGI_SAMPLE_DESC", SimStruct)), ("Usage", SimTypeInt(signed=False, label="D3D10_USAGE")), ("BindFlags", SimTypeInt(signed=False, label="UInt32")), ("CPUAccessFlags", SimTypeInt(signed=False, label="UInt32")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEXTURE2D_DESC", pack=False, align=None),
    "D3D10_TEXTURE3D_DESC": SimStruct(OrderedDict((("Width", SimTypeInt(signed=False, label="UInt32")), ("Height", SimTypeInt(signed=False, label="UInt32")), ("Depth", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("Usage", SimTypeInt(signed=False, label="D3D10_USAGE")), ("BindFlags", SimTypeInt(signed=False, label="UInt32")), ("CPUAccessFlags", SimTypeInt(signed=False, label="UInt32")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D10_TEXTURE3D_DESC", pack=False, align=None),
    "D3D10_TEXTURECUBE_FACE": SimTypeInt(signed=False, label="D3D10_TEXTURECUBE_FACE"),
    "D3D10_TEXTURE_ADDRESS_MODE": SimTypeInt(signed=False, label="D3D10_TEXTURE_ADDRESS_MODE"),
    "D3D10_USAGE": SimTypeInt(signed=False, label="D3D10_USAGE"),
    "D3D10_VIEWPORT": SimStruct(OrderedDict((("TopLeftX", SimTypeInt(signed=True, label="Int32")), ("TopLeftY", SimTypeInt(signed=True, label="Int32")), ("Width", SimTypeInt(signed=False, label="UInt32")), ("Height", SimTypeInt(signed=False, label="UInt32")), ("MinDepth", SimTypeFloat(size=32)), ("MaxDepth", SimTypeFloat(size=32)),)), name="D3D10_VIEWPORT", pack=False, align=None),
    "D3D11_1_CREATE_DEVICE_CONTEXT_STATE_FLAG": SimTypeInt(signed=False, label="D3D11_1_CREATE_DEVICE_CONTEXT_STATE_FLAG"),
    "D3D11_AES_CTR_IV": SimStruct(OrderedDict((("IV", SimTypeLongLong(signed=False, label="UInt64")), ("Count", SimTypeLongLong(signed=False, label="UInt64")),)), name="D3D11_AES_CTR_IV", pack=False, align=None),
    "D3D11_ASYNC_GETDATA_FLAG": SimTypeInt(signed=False, label="D3D11_ASYNC_GETDATA_FLAG"),
    "D3D11_AUTHENTICATED_CHANNEL_TYPE": SimTypeInt(signed=False, label="D3D11_AUTHENTICATED_CHANNEL_TYPE"),
    "D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT": SimStruct(OrderedDict((("Parameters", SimTypeRef("D3D11_AUTHENTICATED_CONFIGURE_INPUT", SimStruct)), ("EncryptionGuid", SimTypeBottom(label="Guid")),)), name="D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT": SimStruct(OrderedDict((("Parameters", SimTypeRef("D3D11_AUTHENTICATED_CONFIGURE_INPUT", SimStruct)), ("DecoderHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("CryptoSessionHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("DeviceHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT": SimStruct(OrderedDict((("Parameters", SimTypeRef("D3D11_AUTHENTICATED_CONFIGURE_INPUT", SimStruct)), ("StartSequenceQuery", SimTypeInt(signed=False, label="UInt32")), ("StartSequenceConfigure", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_CONFIGURE_INPUT": SimStruct(OrderedDict((("omac", SimTypeRef("D3D11_OMAC", SimStruct)), ("ConfigureType", SimTypeBottom(label="Guid")), ("hChannel", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("SequenceNumber", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_AUTHENTICATED_CONFIGURE_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_CONFIGURE_OUTPUT": SimStruct(OrderedDict((("omac", SimTypeRef("D3D11_OMAC", SimStruct)), ("ConfigureType", SimTypeBottom(label="Guid")), ("hChannel", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("SequenceNumber", SimTypeInt(signed=False, label="UInt32")), ("ReturnCode", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_AUTHENTICATED_CONFIGURE_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT": SimStruct(OrderedDict((("Parameters", SimTypeRef("D3D11_AUTHENTICATED_CONFIGURE_INPUT", SimStruct)), ("Protections", SimUnion({"Flags": SimTypeRef("_Flags_e__Struct", SimStruct), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")),)), name="D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT": SimStruct(OrderedDict((("Parameters", SimTypeRef("D3D11_AUTHENTICATED_CONFIGURE_INPUT", SimStruct)), ("ProcessType", SimTypeInt(signed=False, label="D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE")), ("ProcessHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("AllowAccess", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE": SimTypeInt(signed=False, label="D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE"),
    "D3D11_AUTHENTICATED_PROTECTION_FLAGS": SimUnion({"Flags": SimTypeRef("_Flags_e__Struct", SimStruct), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"),
    "D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("EncryptionGuidCount", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT": SimStruct(OrderedDict((("Input", SimTypeRef("D3D11_AUTHENTICATED_QUERY_INPUT", SimStruct)), ("EncryptionGuidIndex", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("EncryptionGuidIndex", SimTypeInt(signed=False, label="UInt32")), ("EncryptionGuid", SimTypeBottom(label="Guid")),)), name="D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("BusType", SimTypeInt(signed=False, label="D3D11_BUS_TYPE")), ("AccessibleInContiguousBlocks", SimTypeInt(signed=True, label="Int32")), ("AccessibleInNonContiguousBlocks", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("ChannelType", SimTypeInt(signed=False, label="D3D11_AUTHENTICATED_CHANNEL_TYPE")),)), name="D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT": SimStruct(OrderedDict((("Input", SimTypeRef("D3D11_AUTHENTICATED_QUERY_INPUT", SimStruct)), ("DecoderHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("DecoderHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("CryptoSessionHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("DeviceHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("EncryptionGuid", SimTypeBottom(label="Guid")),)), name="D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("DeviceHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_INPUT": SimStruct(OrderedDict((("QueryType", SimTypeBottom(label="Guid")), ("hChannel", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("SequenceNumber", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_AUTHENTICATED_QUERY_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_OUTPUT": SimStruct(OrderedDict((("omac", SimTypeRef("D3D11_OMAC", SimStruct)), ("QueryType", SimTypeBottom(label="Guid")), ("hChannel", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("SequenceNumber", SimTypeInt(signed=False, label="UInt32")), ("ReturnCode", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_AUTHENTICATED_QUERY_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT": SimStruct(OrderedDict((("Input", SimTypeRef("D3D11_AUTHENTICATED_QUERY_INPUT", SimStruct)), ("DeviceHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("CryptoSessionHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("DeviceHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("CryptoSessionHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("OutputIDCount", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT": SimStruct(OrderedDict((("Input", SimTypeRef("D3D11_AUTHENTICATED_QUERY_INPUT", SimStruct)), ("DeviceHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("CryptoSessionHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("OutputIDIndex", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("DeviceHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("CryptoSessionHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), ("OutputIDIndex", SimTypeInt(signed=False, label="UInt32")), ("OutputID", SimTypeLongLong(signed=False, label="UInt64")),)), name="D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("ProtectionFlags", SimUnion({"Flags": SimTypeRef("_Flags_e__Struct", SimStruct), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")),)), name="D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("RestrictedSharedResourceProcessCount", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT": SimStruct(OrderedDict((("Input", SimTypeRef("D3D11_AUTHENTICATED_QUERY_INPUT", SimStruct)), ("ProcessIndex", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("ProcessIndex", SimTypeInt(signed=False, label="UInt32")), ("ProcessIdentifier", SimTypeInt(signed=False, label="D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE")), ("ProcessHandle", SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),)), name="D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT", pack=False, align=None),
    "D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT": SimStruct(OrderedDict((("Output", SimTypeRef("D3D11_AUTHENTICATED_QUERY_OUTPUT", SimStruct)), ("UnrestrictedProtectedSharedResourceCount", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT", pack=False, align=None),
    "D3D11_BIND_FLAG": SimTypeInt(signed=False, label="D3D11_BIND_FLAG"),
    "D3D11_BLEND": SimTypeInt(signed=False, label="D3D11_BLEND"),
    "D3D11_BLEND_DESC": SimStruct(OrderedDict((("AlphaToCoverageEnable", SimTypeInt(signed=True, label="Int32")), ("IndependentBlendEnable", SimTypeInt(signed=True, label="Int32")), ("RenderTarget", SimTypeArray(SimTypeRef("D3D11_RENDER_TARGET_BLEND_DESC", SimStruct), 8)),)), name="D3D11_BLEND_DESC", pack=False, align=None),
    "D3D11_BLEND_DESC1": SimStruct(OrderedDict((("AlphaToCoverageEnable", SimTypeInt(signed=True, label="Int32")), ("IndependentBlendEnable", SimTypeInt(signed=True, label="Int32")), ("RenderTarget", SimTypeArray(SimTypeRef("D3D11_RENDER_TARGET_BLEND_DESC1", SimStruct), 8)),)), name="D3D11_BLEND_DESC1", pack=False, align=None),
    "D3D11_BLEND_OP": SimTypeInt(signed=False, label="D3D11_BLEND_OP"),
    "D3D11_BOX": SimStruct(OrderedDict((("left", SimTypeInt(signed=False, label="UInt32")), ("top", SimTypeInt(signed=False, label="UInt32")), ("front", SimTypeInt(signed=False, label="UInt32")), ("right", SimTypeInt(signed=False, label="UInt32")), ("bottom", SimTypeInt(signed=False, label="UInt32")), ("back", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_BOX", pack=False, align=None),
    "D3D11_BUFFEREX_SRV": SimStruct(OrderedDict((("FirstElement", SimTypeInt(signed=False, label="UInt32")), ("NumElements", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_BUFFEREX_SRV", pack=False, align=None),
    "D3D11_BUFFEREX_SRV_FLAG": SimTypeInt(signed=False, label="D3D11_BUFFEREX_SRV_FLAG"),
    "D3D11_BUFFER_DESC": SimStruct(OrderedDict((("ByteWidth", SimTypeInt(signed=False, label="UInt32")), ("Usage", SimTypeInt(signed=False, label="D3D11_USAGE")), ("BindFlags", SimTypeInt(signed=False, label="UInt32")), ("CPUAccessFlags", SimTypeInt(signed=False, label="UInt32")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")), ("StructureByteStride", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_BUFFER_DESC", pack=False, align=None),
    "D3D11_BUFFER_RTV": SimStruct(OrderedDict((("Anonymous1", SimUnion({"FirstElement": SimTypeInt(signed=False, label="UInt32"), "ElementOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("Anonymous2", SimUnion({"NumElements": SimTypeInt(signed=False, label="UInt32"), "ElementWidth": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")),)), name="D3D11_BUFFER_RTV", pack=False, align=None),
    "D3D11_BUFFER_SRV": SimStruct(OrderedDict((("Anonymous1", SimUnion({"FirstElement": SimTypeInt(signed=False, label="UInt32"), "ElementOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")), ("Anonymous2", SimUnion({"NumElements": SimTypeInt(signed=False, label="UInt32"), "ElementWidth": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")),)), name="D3D11_BUFFER_SRV", pack=False, align=None),
    "D3D11_BUFFER_UAV": SimStruct(OrderedDict((("FirstElement", SimTypeInt(signed=False, label="UInt32")), ("NumElements", SimTypeInt(signed=False, label="UInt32")), ("Flags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_BUFFER_UAV", pack=False, align=None),
    "D3D11_BUFFER_UAV_FLAG": SimTypeInt(signed=False, label="D3D11_BUFFER_UAV_FLAG"),
    "D3D11_BUS_TYPE": SimTypeInt(signed=False, label="D3D11_BUS_TYPE"),
    "D3D11_CHECK_MULTISAMPLE_QUALITY_LEVELS_FLAG": SimTypeInt(signed=False, label="D3D11_CHECK_MULTISAMPLE_QUALITY_LEVELS_FLAG"),
    "D3D11_CLASS_INSTANCE_DESC": SimStruct(OrderedDict((("InstanceId", SimTypeInt(signed=False, label="UInt32")), ("InstanceIndex", SimTypeInt(signed=False, label="UInt32")), ("TypeId", SimTypeInt(signed=False, label="UInt32")), ("ConstantBuffer", SimTypeInt(signed=False, label="UInt32")), ("BaseConstantBufferOffset", SimTypeInt(signed=False, label="UInt32")), ("BaseTexture", SimTypeInt(signed=False, label="UInt32")), ("BaseSampler", SimTypeInt(signed=False, label="UInt32")), ("Created", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_CLASS_INSTANCE_DESC", pack=False, align=None),
    "D3D11_CLEAR_FLAG": SimTypeInt(signed=False, label="D3D11_CLEAR_FLAG"),
    "D3D11_COLOR_WRITE_ENABLE": SimTypeInt(signed=False, label="D3D11_COLOR_WRITE_ENABLE"),
    "D3D11_COMPARISON_FUNC": SimTypeInt(signed=False, label="D3D11_COMPARISON_FUNC"),
    "D3D11_COMPUTE_SHADER_TRACE_DESC": SimStruct(OrderedDict((("Invocation", SimTypeLongLong(signed=False, label="UInt64")), ("ThreadIDInGroup", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 3)), ("ThreadGroupID", SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 3)),)), name="D3D11_COMPUTE_SHADER_TRACE_DESC", pack=False, align=None),
    "D3D11_CONSERVATIVE_RASTERIZATION_MODE": SimTypeInt(signed=False, label="D3D11_CONSERVATIVE_RASTERIZATION_MODE"),
    "D3D11_CONSERVATIVE_RASTERIZATION_TIER": SimTypeInt(signed=False, label="D3D11_CONSERVATIVE_RASTERIZATION_TIER"),
    "D3D11_CONTENT_PROTECTION_CAPS": SimTypeInt(signed=False, label="D3D11_CONTENT_PROTECTION_CAPS"),
    "D3D11_CONTEXT_TYPE": SimTypeInt(signed=False, label="D3D11_CONTEXT_TYPE"),
    "D3D11_COPY_FLAGS": SimTypeInt(signed=False, label="D3D11_COPY_FLAGS"),
    "D3D11_COUNTER": SimTypeInt(signed=False, label="D3D11_COUNTER"),
    "D3D11_COUNTER_DESC": SimStruct(OrderedDict((("Counter", SimTypeInt(signed=False, label="D3D11_COUNTER")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_COUNTER_DESC", pack=False, align=None),
    "D3D11_COUNTER_INFO": SimStruct(OrderedDict((("LastDeviceDependentCounter", SimTypeInt(signed=False, label="D3D11_COUNTER")), ("NumSimultaneousCounters", SimTypeInt(signed=False, label="UInt32")), ("NumDetectableParallelUnits", SimTypeChar(label="Byte")),)), name="D3D11_COUNTER_INFO", pack=False, align=None),
    "D3D11_COUNTER_TYPE": SimTypeInt(signed=False, label="D3D11_COUNTER_TYPE"),
    "D3D11_CPU_ACCESS_FLAG": SimTypeInt(signed=False, label="D3D11_CPU_ACCESS_FLAG"),
    "D3D11_CREATE_DEVICE_FLAG": SimTypeInt(signed=False, label="D3D11_CREATE_DEVICE_FLAG"),
    "D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS": SimTypeInt(signed=False, label="D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS"),
    "D3D11_CRYPTO_SESSION_STATUS": SimTypeInt(signed=False, label="D3D11_CRYPTO_SESSION_STATUS"),
    "D3D11_CULL_MODE": SimTypeInt(signed=False, label="D3D11_CULL_MODE"),
    "D3D11_DEPTH_STENCILOP_DESC": SimStruct(OrderedDict((("StencilFailOp", SimTypeInt(signed=False, label="D3D11_STENCIL_OP")), ("StencilDepthFailOp", SimTypeInt(signed=False, label="D3D11_STENCIL_OP")), ("StencilPassOp", SimTypeInt(signed=False, label="D3D11_STENCIL_OP")), ("StencilFunc", SimTypeInt(signed=False, label="D3D11_COMPARISON_FUNC")),)), name="D3D11_DEPTH_STENCILOP_DESC", pack=False, align=None),
    "D3D11_DEPTH_STENCIL_DESC": SimStruct(OrderedDict((("DepthEnable", SimTypeInt(signed=True, label="Int32")), ("DepthWriteMask", SimTypeInt(signed=False, label="D3D11_DEPTH_WRITE_MASK")), ("DepthFunc", SimTypeInt(signed=False, label="D3D11_COMPARISON_FUNC")), ("StencilEnable", SimTypeInt(signed=True, label="Int32")), ("StencilReadMask", SimTypeChar(label="Byte")), ("StencilWriteMask", SimTypeChar(label="Byte")), ("FrontFace", SimTypeRef("D3D11_DEPTH_STENCILOP_DESC", SimStruct)), ("BackFace", SimTypeRef("D3D11_DEPTH_STENCILOP_DESC", SimStruct)),)), name="D3D11_DEPTH_STENCIL_DESC", pack=False, align=None),
    "D3D11_DEPTH_STENCIL_VIEW_DESC": SimStruct(OrderedDict((("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("ViewDimension", SimTypeInt(signed=False, label="D3D11_DSV_DIMENSION")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"Texture1D": SimTypeRef("D3D11_TEX1D_DSV", SimStruct), "Texture1DArray": SimTypeRef("D3D11_TEX1D_ARRAY_DSV", SimStruct), "Texture2D": SimTypeRef("D3D11_TEX2D_DSV", SimStruct), "Texture2DArray": SimTypeRef("D3D11_TEX2D_ARRAY_DSV", SimStruct), "Texture2DMS": SimTypeRef("D3D11_TEX2DMS_DSV", SimStruct), "Texture2DMSArray": SimTypeRef("D3D11_TEX2DMS_ARRAY_DSV", SimStruct)}, name="<anon>", label="None")),)), name="D3D11_DEPTH_STENCIL_VIEW_DESC", pack=False, align=None),
    "D3D11_DEPTH_WRITE_MASK": SimTypeInt(signed=False, label="D3D11_DEPTH_WRITE_MASK"),
    "D3D11_DEVICE_CONTEXT_TYPE": SimTypeInt(signed=False, label="D3D11_DEVICE_CONTEXT_TYPE"),
    "D3D11_DOMAIN_SHADER_TRACE_DESC": SimStruct(OrderedDict((("Invocation", SimTypeLongLong(signed=False, label="UInt64")),)), name="D3D11_DOMAIN_SHADER_TRACE_DESC", pack=False, align=None),
    "D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS": SimStruct(OrderedDict((("IndexCountPerInstance", SimTypeInt(signed=False, label="UInt32")), ("InstanceCount", SimTypeInt(signed=False, label="UInt32")), ("StartIndexLocation", SimTypeInt(signed=False, label="UInt32")), ("BaseVertexLocation", SimTypeInt(signed=True, label="Int32")), ("StartInstanceLocation", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS", pack=False, align=None),
    "D3D11_DRAW_INSTANCED_INDIRECT_ARGS": SimStruct(OrderedDict((("VertexCountPerInstance", SimTypeInt(signed=False, label="UInt32")), ("InstanceCount", SimTypeInt(signed=False, label="UInt32")), ("StartVertexLocation", SimTypeInt(signed=False, label="UInt32")), ("StartInstanceLocation", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_DRAW_INSTANCED_INDIRECT_ARGS", pack=False, align=None),
    "D3D11_DSV_DIMENSION": SimTypeInt(signed=False, label="D3D11_DSV_DIMENSION"),
    "D3D11_DSV_FLAG": SimTypeInt(signed=False, label="D3D11_DSV_FLAG"),
    "D3D11_ENCRYPTED_BLOCK_INFO": SimStruct(OrderedDict((("NumEncryptedBytesAtBeginning", SimTypeInt(signed=False, label="UInt32")), ("NumBytesInSkipPattern", SimTypeInt(signed=False, label="UInt32")), ("NumBytesInEncryptPattern", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_ENCRYPTED_BLOCK_INFO", pack=False, align=None),
    "D3D11_FEATURE": SimTypeInt(signed=False, label="D3D11_FEATURE"),
    "D3D11_FEATURE_DATA_ARCHITECTURE_INFO": SimStruct(OrderedDict((("TileBasedDeferredRenderer", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_ARCHITECTURE_INFO", pack=False, align=None),
    "D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS": SimStruct(OrderedDict((("ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS", pack=False, align=None),
    "D3D11_FEATURE_DATA_D3D11_OPTIONS": SimStruct(OrderedDict((("OutputMergerLogicOp", SimTypeInt(signed=True, label="Int32")), ("UAVOnlyRenderingForcedSampleCount", SimTypeInt(signed=True, label="Int32")), ("DiscardAPIsSeenByDriver", SimTypeInt(signed=True, label="Int32")), ("FlagsForUpdateAndCopySeenByDriver", SimTypeInt(signed=True, label="Int32")), ("ClearView", SimTypeInt(signed=True, label="Int32")), ("CopyWithOverlap", SimTypeInt(signed=True, label="Int32")), ("ConstantBufferPartialUpdate", SimTypeInt(signed=True, label="Int32")), ("ConstantBufferOffsetting", SimTypeInt(signed=True, label="Int32")), ("MapNoOverwriteOnDynamicConstantBuffer", SimTypeInt(signed=True, label="Int32")), ("MapNoOverwriteOnDynamicBufferSRV", SimTypeInt(signed=True, label="Int32")), ("MultisampleRTVWithForcedSampleCountOne", SimTypeInt(signed=True, label="Int32")), ("SAD4ShaderInstructions", SimTypeInt(signed=True, label="Int32")), ("ExtendedDoublesShaderInstructions", SimTypeInt(signed=True, label="Int32")), ("ExtendedResourceSharing", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_D3D11_OPTIONS", pack=False, align=None),
    "D3D11_FEATURE_DATA_D3D11_OPTIONS1": SimStruct(OrderedDict((("TiledResourcesTier", SimTypeInt(signed=False, label="D3D11_TILED_RESOURCES_TIER")), ("MinMaxFiltering", SimTypeInt(signed=True, label="Int32")), ("ClearViewAlsoSupportsDepthOnlyFormats", SimTypeInt(signed=True, label="Int32")), ("MapOnDefaultBuffers", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_D3D11_OPTIONS1", pack=False, align=None),
    "D3D11_FEATURE_DATA_D3D11_OPTIONS2": SimStruct(OrderedDict((("PSSpecifiedStencilRefSupported", SimTypeInt(signed=True, label="Int32")), ("TypedUAVLoadAdditionalFormats", SimTypeInt(signed=True, label="Int32")), ("ROVsSupported", SimTypeInt(signed=True, label="Int32")), ("ConservativeRasterizationTier", SimTypeInt(signed=False, label="D3D11_CONSERVATIVE_RASTERIZATION_TIER")), ("TiledResourcesTier", SimTypeInt(signed=False, label="D3D11_TILED_RESOURCES_TIER")), ("MapOnDefaultTextures", SimTypeInt(signed=True, label="Int32")), ("StandardSwizzle", SimTypeInt(signed=True, label="Int32")), ("UnifiedMemoryArchitecture", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_D3D11_OPTIONS2", pack=False, align=None),
    "D3D11_FEATURE_DATA_D3D11_OPTIONS3": SimStruct(OrderedDict((("VPAndRTArrayIndexFromAnyShaderFeedingRasterizer", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_D3D11_OPTIONS3", pack=False, align=None),
    "D3D11_FEATURE_DATA_D3D11_OPTIONS4": SimStruct(OrderedDict((("ExtendedNV12SharedTextureSupported", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_D3D11_OPTIONS4", pack=False, align=None),
    "D3D11_FEATURE_DATA_D3D11_OPTIONS5": SimStruct(OrderedDict((("SharedResourceTier", SimTypeInt(signed=False, label="D3D11_SHARED_RESOURCE_TIER")),)), name="D3D11_FEATURE_DATA_D3D11_OPTIONS5", pack=False, align=None),
    "D3D11_FEATURE_DATA_D3D9_OPTIONS": SimStruct(OrderedDict((("FullNonPow2TextureSupport", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_D3D9_OPTIONS", pack=False, align=None),
    "D3D11_FEATURE_DATA_D3D9_OPTIONS1": SimStruct(OrderedDict((("FullNonPow2TextureSupported", SimTypeInt(signed=True, label="Int32")), ("DepthAsTextureWithLessEqualComparisonFilterSupported", SimTypeInt(signed=True, label="Int32")), ("SimpleInstancingSupported", SimTypeInt(signed=True, label="Int32")), ("TextureCubeFaceRenderTargetWithNonCubeDepthStencilSupported", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_D3D9_OPTIONS1", pack=False, align=None),
    "D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT": SimStruct(OrderedDict((("SupportsDepthAsTextureWithLessEqualComparisonFilter", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT", pack=False, align=None),
    "D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT": SimStruct(OrderedDict((("SimpleInstancingSupported", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT", pack=False, align=None),
    "D3D11_FEATURE_DATA_DISPLAYABLE": SimStruct(OrderedDict((("DisplayableTexture", SimTypeInt(signed=True, label="Int32")), ("SharedResourceTier", SimTypeInt(signed=False, label="D3D11_SHARED_RESOURCE_TIER")),)), name="D3D11_FEATURE_DATA_DISPLAYABLE", pack=False, align=None),
    "D3D11_FEATURE_DATA_DOUBLES": SimStruct(OrderedDict((("DoublePrecisionFloatShaderOps", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_DOUBLES", pack=False, align=None),
    "D3D11_FEATURE_DATA_FORMAT_SUPPORT": SimStruct(OrderedDict((("InFormat", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("OutFormatSupport", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_FEATURE_DATA_FORMAT_SUPPORT", pack=False, align=None),
    "D3D11_FEATURE_DATA_FORMAT_SUPPORT2": SimStruct(OrderedDict((("InFormat", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("OutFormatSupport2", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_FEATURE_DATA_FORMAT_SUPPORT2", pack=False, align=None),
    "D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT": SimStruct(OrderedDict((("MaxGPUVirtualAddressBitsPerResource", SimTypeInt(signed=False, label="UInt32")), ("MaxGPUVirtualAddressBitsPerProcess", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT", pack=False, align=None),
    "D3D11_FEATURE_DATA_MARKER_SUPPORT": SimStruct(OrderedDict((("Profile", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_MARKER_SUPPORT", pack=False, align=None),
    "D3D11_FEATURE_DATA_SHADER_CACHE": SimStruct(OrderedDict((("SupportFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_FEATURE_DATA_SHADER_CACHE", pack=False, align=None),
    "D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT": SimStruct(OrderedDict((("PixelShaderMinPrecision", SimTypeInt(signed=False, label="UInt32")), ("AllOtherShaderStagesMinPrecision", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT", pack=False, align=None),
    "D3D11_FEATURE_DATA_THREADING": SimStruct(OrderedDict((("DriverConcurrentCreates", SimTypeInt(signed=True, label="Int32")), ("DriverCommandLists", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FEATURE_DATA_THREADING", pack=False, align=None),
    "D3D11_FEATURE_DATA_VIDEO_DECODER_HISTOGRAM": SimStruct(OrderedDict((("DecoderDesc", SimTypeRef("D3D11_VIDEO_DECODER_DESC", SimStruct)), ("Components", SimTypeInt(signed=False, label="D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS")), ("BinCount", SimTypeInt(signed=False, label="UInt32")), ("CounterBitDepth", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_FEATURE_DATA_VIDEO_DECODER_HISTOGRAM", pack=False, align=None),
    "D3D11_FEATURE_VIDEO": SimTypeInt(signed=False, label="D3D11_FEATURE_VIDEO"),
    "D3D11_FENCE_FLAG": SimTypeInt(signed=False, label="D3D11_FENCE_FLAG"),
    "D3D11_FILL_MODE": SimTypeInt(signed=False, label="D3D11_FILL_MODE"),
    "D3D11_FILTER": SimTypeInt(signed=False, label="D3D11_FILTER"),
    "D3D11_FILTER_REDUCTION_TYPE": SimTypeInt(signed=False, label="D3D11_FILTER_REDUCTION_TYPE"),
    "D3D11_FILTER_TYPE": SimTypeInt(signed=False, label="D3D11_FILTER_TYPE"),
    "D3D11_FORMAT_SUPPORT": SimTypeInt(signed=False, label="D3D11_FORMAT_SUPPORT"),
    "D3D11_FORMAT_SUPPORT2": SimTypeInt(signed=False, label="D3D11_FORMAT_SUPPORT2"),
    "D3D11_FUNCTION_DESC": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("Creator", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("ConstantBuffers", SimTypeInt(signed=False, label="UInt32")), ("BoundResources", SimTypeInt(signed=False, label="UInt32")), ("InstructionCount", SimTypeInt(signed=False, label="UInt32")), ("TempRegisterCount", SimTypeInt(signed=False, label="UInt32")), ("TempArrayCount", SimTypeInt(signed=False, label="UInt32")), ("DefCount", SimTypeInt(signed=False, label="UInt32")), ("DclCount", SimTypeInt(signed=False, label="UInt32")), ("TextureNormalInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureLoadInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureCompInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureBiasInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureGradientInstructions", SimTypeInt(signed=False, label="UInt32")), ("FloatInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("IntInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("UintInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("StaticFlowControlCount", SimTypeInt(signed=False, label="UInt32")), ("DynamicFlowControlCount", SimTypeInt(signed=False, label="UInt32")), ("MacroInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("ArrayInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("MovInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("MovcInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("ConversionInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("BitwiseInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("MinFeatureLevel", SimTypeInt(signed=False, label="D3D_FEATURE_LEVEL")), ("RequiredFeatureFlags", SimTypeLongLong(signed=False, label="UInt64")), ("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("FunctionParameterCount", SimTypeInt(signed=True, label="Int32")), ("HasReturn", SimTypeInt(signed=True, label="Int32")), ("Has10Level9VertexShader", SimTypeInt(signed=True, label="Int32")), ("Has10Level9PixelShader", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_FUNCTION_DESC", pack=False, align=None),
    "D3D11_GEOMETRY_SHADER_TRACE_DESC": SimStruct(OrderedDict((("Invocation", SimTypeLongLong(signed=False, label="UInt64")),)), name="D3D11_GEOMETRY_SHADER_TRACE_DESC", pack=False, align=None),
    "D3D11_HULL_SHADER_TRACE_DESC": SimStruct(OrderedDict((("Invocation", SimTypeLongLong(signed=False, label="UInt64")),)), name="D3D11_HULL_SHADER_TRACE_DESC", pack=False, align=None),
    "D3D11_INFO_QUEUE_FILTER": SimStruct(OrderedDict((("AllowList", SimTypeRef("D3D11_INFO_QUEUE_FILTER_DESC", SimStruct)), ("DenyList", SimTypeRef("D3D11_INFO_QUEUE_FILTER_DESC", SimStruct)),)), name="D3D11_INFO_QUEUE_FILTER", pack=False, align=None),
    "D3D11_INFO_QUEUE_FILTER_DESC": SimStruct(OrderedDict((("NumCategories", SimTypeInt(signed=False, label="UInt32")), ("pCategoryList", SimTypePointer(SimTypeInt(signed=False, label="D3D11_MESSAGE_CATEGORY"), offset=0)), ("NumSeverities", SimTypeInt(signed=False, label="UInt32")), ("pSeverityList", SimTypePointer(SimTypeInt(signed=False, label="D3D11_MESSAGE_SEVERITY"), offset=0)), ("NumIDs", SimTypeInt(signed=False, label="UInt32")), ("pIDList", SimTypePointer(SimTypeInt(signed=False, label="D3D11_MESSAGE_ID"), offset=0)),)), name="D3D11_INFO_QUEUE_FILTER_DESC", pack=False, align=None),
    "D3D11_INPUT_CLASSIFICATION": SimTypeInt(signed=False, label="D3D11_INPUT_CLASSIFICATION"),
    "D3D11_INPUT_ELEMENT_DESC": SimStruct(OrderedDict((("SemanticName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("SemanticIndex", SimTypeInt(signed=False, label="UInt32")), ("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("InputSlot", SimTypeInt(signed=False, label="UInt32")), ("AlignedByteOffset", SimTypeInt(signed=False, label="UInt32")), ("InputSlotClass", SimTypeInt(signed=False, label="D3D11_INPUT_CLASSIFICATION")), ("InstanceDataStepRate", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_INPUT_ELEMENT_DESC", pack=False, align=None),
    "D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA": SimStruct(OrderedDict((("HWProtectionFunctionID", SimTypeInt(signed=False, label="UInt32")), ("pInputData", SimTypePointer(SimTypeRef("D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA", SimStruct), offset=0)), ("pOutputData", SimTypePointer(SimTypeRef("D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA", SimStruct), offset=0)), ("Status", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA", pack=False, align=None),
    "D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA": SimStruct(OrderedDict((("PrivateDataSize", SimTypeInt(signed=False, label="UInt32")), ("HWProtectionDataSize", SimTypeInt(signed=False, label="UInt32")), ("pbInput", SimTypeArray(SimTypeChar(label="Byte"), 4)),)), name="D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA", pack=False, align=None),
    "D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA": SimStruct(OrderedDict((("PrivateDataSize", SimTypeInt(signed=False, label="UInt32")), ("MaxHWProtectionDataSize", SimTypeInt(signed=False, label="UInt32")), ("HWProtectionDataSize", SimTypeInt(signed=False, label="UInt32")), ("TransportTime", SimTypeLongLong(signed=False, label="UInt64")), ("ExecutionTime", SimTypeLongLong(signed=False, label="UInt64")), ("pbOutput", SimTypeArray(SimTypeChar(label="Byte"), 4)),)), name="D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA", pack=False, align=None),
    "D3D11_LIBRARY_DESC": SimStruct(OrderedDict((("Creator", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("FunctionCount", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_LIBRARY_DESC", pack=False, align=None),
    "D3D11_LOGIC_OP": SimTypeInt(signed=False, label="D3D11_LOGIC_OP"),
    "D3D11_MAP": SimTypeInt(signed=False, label="D3D11_MAP"),
    "D3D11_MAPPED_SUBRESOURCE": SimStruct(OrderedDict((("pData", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("RowPitch", SimTypeInt(signed=False, label="UInt32")), ("DepthPitch", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_MAPPED_SUBRESOURCE", pack=False, align=None),
    "D3D11_MAP_FLAG": SimTypeInt(signed=False, label="D3D11_MAP_FLAG"),
    "D3D11_MESSAGE": SimStruct(OrderedDict((("Category", SimTypeInt(signed=False, label="D3D11_MESSAGE_CATEGORY")), ("Severity", SimTypeInt(signed=False, label="D3D11_MESSAGE_SEVERITY")), ("ID", SimTypeInt(signed=False, label="D3D11_MESSAGE_ID")), ("pDescription", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("DescriptionByteLength", SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),)), name="D3D11_MESSAGE", pack=False, align=None),
    "D3D11_MESSAGE_CATEGORY": SimTypeInt(signed=False, label="D3D11_MESSAGE_CATEGORY"),
    "D3D11_MESSAGE_ID": SimTypeInt(signed=False, label="D3D11_MESSAGE_ID"),
    "D3D11_MESSAGE_SEVERITY": SimTypeInt(signed=False, label="D3D11_MESSAGE_SEVERITY"),
    "D3D11_OMAC": SimStruct(OrderedDict((("Omac", SimTypeArray(SimTypeChar(label="Byte"), 16)),)), name="D3D11_OMAC", pack=False, align=None),
    "D3D11_PACKED_MIP_DESC": SimStruct(OrderedDict((("NumStandardMips", SimTypeChar(label="Byte")), ("NumPackedMips", SimTypeChar(label="Byte")), ("NumTilesForPackedMips", SimTypeInt(signed=False, label="UInt32")), ("StartTileIndexInOverallResource", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_PACKED_MIP_DESC", pack=False, align=None),
    "D3D11_PARAMETER_DESC": SimStruct(OrderedDict((("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("SemanticName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Type", SimTypeInt(signed=False, label="D3D_SHADER_VARIABLE_TYPE")), ("Class", SimTypeInt(signed=False, label="D3D_SHADER_VARIABLE_CLASS")), ("Rows", SimTypeInt(signed=False, label="UInt32")), ("Columns", SimTypeInt(signed=False, label="UInt32")), ("InterpolationMode", SimTypeInt(signed=False, label="D3D_INTERPOLATION_MODE")), ("Flags", SimTypeInt(signed=False, label="D3D_PARAMETER_FLAGS")), ("FirstInRegister", SimTypeInt(signed=False, label="UInt32")), ("FirstInComponent", SimTypeInt(signed=False, label="UInt32")), ("FirstOutRegister", SimTypeInt(signed=False, label="UInt32")), ("FirstOutComponent", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_PARAMETER_DESC", pack=False, align=None),
    "D3D11_PIXEL_SHADER_TRACE_DESC": SimStruct(OrderedDict((("Invocation", SimTypeLongLong(signed=False, label="UInt64")), ("X", SimTypeInt(signed=True, label="Int32")), ("Y", SimTypeInt(signed=True, label="Int32")), ("SampleMask", SimTypeLongLong(signed=False, label="UInt64")),)), name="D3D11_PIXEL_SHADER_TRACE_DESC", pack=False, align=None),
    "D3D11_QUERY": SimTypeInt(signed=False, label="D3D11_QUERY"),
    "D3D11_QUERY_DATA_PIPELINE_STATISTICS": SimStruct(OrderedDict((("IAVertices", SimTypeLongLong(signed=False, label="UInt64")), ("IAPrimitives", SimTypeLongLong(signed=False, label="UInt64")), ("VSInvocations", SimTypeLongLong(signed=False, label="UInt64")), ("GSInvocations", SimTypeLongLong(signed=False, label="UInt64")), ("GSPrimitives", SimTypeLongLong(signed=False, label="UInt64")), ("CInvocations", SimTypeLongLong(signed=False, label="UInt64")), ("CPrimitives", SimTypeLongLong(signed=False, label="UInt64")), ("PSInvocations", SimTypeLongLong(signed=False, label="UInt64")), ("HSInvocations", SimTypeLongLong(signed=False, label="UInt64")), ("DSInvocations", SimTypeLongLong(signed=False, label="UInt64")), ("CSInvocations", SimTypeLongLong(signed=False, label="UInt64")),)), name="D3D11_QUERY_DATA_PIPELINE_STATISTICS", pack=False, align=None),
    "D3D11_QUERY_DATA_SO_STATISTICS": SimStruct(OrderedDict((("NumPrimitivesWritten", SimTypeLongLong(signed=False, label="UInt64")), ("PrimitivesStorageNeeded", SimTypeLongLong(signed=False, label="UInt64")),)), name="D3D11_QUERY_DATA_SO_STATISTICS", pack=False, align=None),
    "D3D11_QUERY_DATA_TIMESTAMP_DISJOINT": SimStruct(OrderedDict((("Frequency", SimTypeLongLong(signed=False, label="UInt64")), ("Disjoint", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_QUERY_DATA_TIMESTAMP_DISJOINT", pack=False, align=None),
    "D3D11_QUERY_DESC": SimStruct(OrderedDict((("Query", SimTypeInt(signed=False, label="D3D11_QUERY")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_QUERY_DESC", pack=False, align=None),
    "D3D11_QUERY_DESC1": SimStruct(OrderedDict((("Query", SimTypeInt(signed=False, label="D3D11_QUERY")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")), ("ContextType", SimTypeInt(signed=False, label="D3D11_CONTEXT_TYPE")),)), name="D3D11_QUERY_DESC1", pack=False, align=None),
    "D3D11_QUERY_MISC_FLAG": SimTypeInt(signed=False, label="D3D11_QUERY_MISC_FLAG"),
    "D3D11_RAISE_FLAG": SimTypeInt(signed=False, label="D3D11_RAISE_FLAG"),
    "D3D11_RASTERIZER_DESC": SimStruct(OrderedDict((("FillMode", SimTypeInt(signed=False, label="D3D11_FILL_MODE")), ("CullMode", SimTypeInt(signed=False, label="D3D11_CULL_MODE")), ("FrontCounterClockwise", SimTypeInt(signed=True, label="Int32")), ("DepthBias", SimTypeInt(signed=True, label="Int32")), ("DepthBiasClamp", SimTypeFloat(size=32)), ("SlopeScaledDepthBias", SimTypeFloat(size=32)), ("DepthClipEnable", SimTypeInt(signed=True, label="Int32")), ("ScissorEnable", SimTypeInt(signed=True, label="Int32")), ("MultisampleEnable", SimTypeInt(signed=True, label="Int32")), ("AntialiasedLineEnable", SimTypeInt(signed=True, label="Int32")),)), name="D3D11_RASTERIZER_DESC", pack=False, align=None),
    "D3D11_RASTERIZER_DESC1": SimStruct(OrderedDict((("FillMode", SimTypeInt(signed=False, label="D3D11_FILL_MODE")), ("CullMode", SimTypeInt(signed=False, label="D3D11_CULL_MODE")), ("FrontCounterClockwise", SimTypeInt(signed=True, label="Int32")), ("DepthBias", SimTypeInt(signed=True, label="Int32")), ("DepthBiasClamp", SimTypeFloat(size=32)), ("SlopeScaledDepthBias", SimTypeFloat(size=32)), ("DepthClipEnable", SimTypeInt(signed=True, label="Int32")), ("ScissorEnable", SimTypeInt(signed=True, label="Int32")), ("MultisampleEnable", SimTypeInt(signed=True, label="Int32")), ("AntialiasedLineEnable", SimTypeInt(signed=True, label="Int32")), ("ForcedSampleCount", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_RASTERIZER_DESC1", pack=False, align=None),
    "D3D11_RASTERIZER_DESC2": SimStruct(OrderedDict((("FillMode", SimTypeInt(signed=False, label="D3D11_FILL_MODE")), ("CullMode", SimTypeInt(signed=False, label="D3D11_CULL_MODE")), ("FrontCounterClockwise", SimTypeInt(signed=True, label="Int32")), ("DepthBias", SimTypeInt(signed=True, label="Int32")), ("DepthBiasClamp", SimTypeFloat(size=32)), ("SlopeScaledDepthBias", SimTypeFloat(size=32)), ("DepthClipEnable", SimTypeInt(signed=True, label="Int32")), ("ScissorEnable", SimTypeInt(signed=True, label="Int32")), ("MultisampleEnable", SimTypeInt(signed=True, label="Int32")), ("AntialiasedLineEnable", SimTypeInt(signed=True, label="Int32")), ("ForcedSampleCount", SimTypeInt(signed=False, label="UInt32")), ("ConservativeRaster", SimTypeInt(signed=False, label="D3D11_CONSERVATIVE_RASTERIZATION_MODE")),)), name="D3D11_RASTERIZER_DESC2", pack=False, align=None),
    "D3D11_RENDER_TARGET_BLEND_DESC": SimStruct(OrderedDict((("BlendEnable", SimTypeInt(signed=True, label="Int32")), ("SrcBlend", SimTypeInt(signed=False, label="D3D11_BLEND")), ("DestBlend", SimTypeInt(signed=False, label="D3D11_BLEND")), ("BlendOp", SimTypeInt(signed=False, label="D3D11_BLEND_OP")), ("SrcBlendAlpha", SimTypeInt(signed=False, label="D3D11_BLEND")), ("DestBlendAlpha", SimTypeInt(signed=False, label="D3D11_BLEND")), ("BlendOpAlpha", SimTypeInt(signed=False, label="D3D11_BLEND_OP")), ("RenderTargetWriteMask", SimTypeChar(label="Byte")),)), name="D3D11_RENDER_TARGET_BLEND_DESC", pack=False, align=None),
    "D3D11_RENDER_TARGET_BLEND_DESC1": SimStruct(OrderedDict((("BlendEnable", SimTypeInt(signed=True, label="Int32")), ("LogicOpEnable", SimTypeInt(signed=True, label="Int32")), ("SrcBlend", SimTypeInt(signed=False, label="D3D11_BLEND")), ("DestBlend", SimTypeInt(signed=False, label="D3D11_BLEND")), ("BlendOp", SimTypeInt(signed=False, label="D3D11_BLEND_OP")), ("SrcBlendAlpha", SimTypeInt(signed=False, label="D3D11_BLEND")), ("DestBlendAlpha", SimTypeInt(signed=False, label="D3D11_BLEND")), ("BlendOpAlpha", SimTypeInt(signed=False, label="D3D11_BLEND_OP")), ("LogicOp", SimTypeInt(signed=False, label="D3D11_LOGIC_OP")), ("RenderTargetWriteMask", SimTypeChar(label="Byte")),)), name="D3D11_RENDER_TARGET_BLEND_DESC1", pack=False, align=None),
    "D3D11_RENDER_TARGET_VIEW_DESC": SimStruct(OrderedDict((("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("ViewDimension", SimTypeInt(signed=False, label="D3D11_RTV_DIMENSION")), ("Anonymous", SimUnion({"Buffer": SimTypeRef("D3D11_BUFFER_RTV", SimStruct), "Texture1D": SimTypeRef("D3D11_TEX1D_RTV", SimStruct), "Texture1DArray": SimTypeRef("D3D11_TEX1D_ARRAY_RTV", SimStruct), "Texture2D": SimTypeRef("D3D11_TEX2D_RTV", SimStruct), "Texture2DArray": SimTypeRef("D3D11_TEX2D_ARRAY_RTV", SimStruct), "Texture2DMS": SimTypeRef("D3D11_TEX2DMS_RTV", SimStruct), "Texture2DMSArray": SimTypeRef("D3D11_TEX2DMS_ARRAY_RTV", SimStruct), "Texture3D": SimTypeRef("D3D11_TEX3D_RTV", SimStruct)}, name="<anon>", label="None")),)), name="D3D11_RENDER_TARGET_VIEW_DESC", pack=False, align=None),
    "D3D11_RENDER_TARGET_VIEW_DESC1": SimStruct(OrderedDict((("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("ViewDimension", SimTypeInt(signed=False, label="D3D11_RTV_DIMENSION")), ("Anonymous", SimUnion({"Buffer": SimTypeRef("D3D11_BUFFER_RTV", SimStruct), "Texture1D": SimTypeRef("D3D11_TEX1D_RTV", SimStruct), "Texture1DArray": SimTypeRef("D3D11_TEX1D_ARRAY_RTV", SimStruct), "Texture2D": SimTypeRef("D3D11_TEX2D_RTV1", SimStruct), "Texture2DArray": SimTypeRef("D3D11_TEX2D_ARRAY_RTV1", SimStruct), "Texture2DMS": SimTypeRef("D3D11_TEX2DMS_RTV", SimStruct), "Texture2DMSArray": SimTypeRef("D3D11_TEX2DMS_ARRAY_RTV", SimStruct), "Texture3D": SimTypeRef("D3D11_TEX3D_RTV", SimStruct)}, name="<anon>", label="None")),)), name="D3D11_RENDER_TARGET_VIEW_DESC1", pack=False, align=None),
    "D3D11_RESOURCE_DIMENSION": SimTypeInt(signed=False, label="D3D11_RESOURCE_DIMENSION"),
    "D3D11_RESOURCE_FLAGS": SimStruct(OrderedDict((("BindFlags", SimTypeInt(signed=False, label="UInt32")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")), ("CPUAccessFlags", SimTypeInt(signed=False, label="UInt32")), ("StructureByteStride", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_RESOURCE_FLAGS", pack=False, align=None),
    "D3D11_RESOURCE_MISC_FLAG": SimTypeInt(signed=False, label="D3D11_RESOURCE_MISC_FLAG"),
    "D3D11_RLDO_FLAGS": SimTypeInt(signed=False, label="D3D11_RLDO_FLAGS"),
    "D3D11_RTV_DIMENSION": SimTypeInt(signed=False, label="D3D11_RTV_DIMENSION"),
    "D3D11_SAMPLER_DESC": SimStruct(OrderedDict((("Filter", SimTypeInt(signed=False, label="D3D11_FILTER")), ("AddressU", SimTypeInt(signed=False, label="D3D11_TEXTURE_ADDRESS_MODE")), ("AddressV", SimTypeInt(signed=False, label="D3D11_TEXTURE_ADDRESS_MODE")), ("AddressW", SimTypeInt(signed=False, label="D3D11_TEXTURE_ADDRESS_MODE")), ("MipLODBias", SimTypeFloat(size=32)), ("MaxAnisotropy", SimTypeInt(signed=False, label="UInt32")), ("ComparisonFunc", SimTypeInt(signed=False, label="D3D11_COMPARISON_FUNC")), ("BorderColor", SimTypeArray(SimTypeFloat(size=32), 4)), ("MinLOD", SimTypeFloat(size=32)), ("MaxLOD", SimTypeFloat(size=32)),)), name="D3D11_SAMPLER_DESC", pack=False, align=None),
    "D3D11_SHADER_BUFFER_DESC": SimStruct(OrderedDict((("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Type", SimTypeInt(signed=False, label="D3D_CBUFFER_TYPE")), ("Variables", SimTypeInt(signed=False, label="UInt32")), ("Size", SimTypeInt(signed=False, label="UInt32")), ("uFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_SHADER_BUFFER_DESC", pack=False, align=None),
    "D3D11_SHADER_CACHE_SUPPORT_FLAGS": SimTypeInt(signed=False, label="D3D11_SHADER_CACHE_SUPPORT_FLAGS"),
    "D3D11_SHADER_DESC": SimStruct(OrderedDict((("Version", SimTypeInt(signed=False, label="UInt32")), ("Creator", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("ConstantBuffers", SimTypeInt(signed=False, label="UInt32")), ("BoundResources", SimTypeInt(signed=False, label="UInt32")), ("InputParameters", SimTypeInt(signed=False, label="UInt32")), ("OutputParameters", SimTypeInt(signed=False, label="UInt32")), ("InstructionCount", SimTypeInt(signed=False, label="UInt32")), ("TempRegisterCount", SimTypeInt(signed=False, label="UInt32")), ("TempArrayCount", SimTypeInt(signed=False, label="UInt32")), ("DefCount", SimTypeInt(signed=False, label="UInt32")), ("DclCount", SimTypeInt(signed=False, label="UInt32")), ("TextureNormalInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureLoadInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureCompInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureBiasInstructions", SimTypeInt(signed=False, label="UInt32")), ("TextureGradientInstructions", SimTypeInt(signed=False, label="UInt32")), ("FloatInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("IntInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("UintInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("StaticFlowControlCount", SimTypeInt(signed=False, label="UInt32")), ("DynamicFlowControlCount", SimTypeInt(signed=False, label="UInt32")), ("MacroInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("ArrayInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("CutInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("EmitInstructionCount", SimTypeInt(signed=False, label="UInt32")), ("GSOutputTopology", SimTypeInt(signed=False, label="D3D_PRIMITIVE_TOPOLOGY")), ("GSMaxOutputVertexCount", SimTypeInt(signed=False, label="UInt32")), ("InputPrimitive", SimTypeInt(signed=False, label="D3D_PRIMITIVE")), ("PatchConstantParameters", SimTypeInt(signed=False, label="UInt32")), ("cGSInstanceCount", SimTypeInt(signed=False, label="UInt32")), ("cControlPoints", SimTypeInt(signed=False, label="UInt32")), ("HSOutputPrimitive", SimTypeInt(signed=False, label="D3D_TESSELLATOR_OUTPUT_PRIMITIVE")), ("HSPartitioning", SimTypeInt(signed=False, label="D3D_TESSELLATOR_PARTITIONING")), ("TessellatorDomain", SimTypeInt(signed=False, label="D3D_TESSELLATOR_DOMAIN")), ("cBarrierInstructions", SimTypeInt(signed=False, label="UInt32")), ("cInterlockedInstructions", SimTypeInt(signed=False, label="UInt32")), ("cTextureStoreInstructions", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_SHADER_DESC", pack=False, align=None),
    "D3D11_SHADER_INPUT_BIND_DESC": SimStruct(OrderedDict((("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("Type", SimTypeInt(signed=False, label="D3D_SHADER_INPUT_TYPE")), ("BindPoint", SimTypeInt(signed=False, label="UInt32")), ("BindCount", SimTypeInt(signed=False, label="UInt32")), ("uFlags", SimTypeInt(signed=False, label="UInt32")), ("ReturnType", SimTypeInt(signed=False, label="D3D_RESOURCE_RETURN_TYPE")), ("Dimension", SimTypeInt(signed=False, label="D3D_SRV_DIMENSION")), ("NumSamples", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_SHADER_INPUT_BIND_DESC", pack=False, align=None),
    "D3D11_SHADER_MIN_PRECISION_SUPPORT": SimTypeInt(signed=False, label="D3D11_SHADER_MIN_PRECISION_SUPPORT"),
    "D3D11_SHADER_RESOURCE_VIEW_DESC": SimStruct(OrderedDict((("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("ViewDimension", SimTypeInt(signed=False, label="D3D_SRV_DIMENSION")), ("Anonymous", SimUnion({"Buffer": SimTypeRef("D3D11_BUFFER_SRV", SimStruct), "Texture1D": SimTypeRef("D3D11_TEX1D_SRV", SimStruct), "Texture1DArray": SimTypeRef("D3D11_TEX1D_ARRAY_SRV", SimStruct), "Texture2D": SimTypeRef("D3D11_TEX2D_SRV", SimStruct), "Texture2DArray": SimTypeRef("D3D11_TEX2D_ARRAY_SRV", SimStruct), "Texture2DMS": SimTypeRef("D3D11_TEX2DMS_SRV", SimStruct), "Texture2DMSArray": SimTypeRef("D3D11_TEX2DMS_ARRAY_SRV", SimStruct), "Texture3D": SimTypeRef("D3D11_TEX3D_SRV", SimStruct), "TextureCube": SimTypeRef("D3D11_TEXCUBE_SRV", SimStruct), "TextureCubeArray": SimTypeRef("D3D11_TEXCUBE_ARRAY_SRV", SimStruct), "BufferEx": SimTypeRef("D3D11_BUFFEREX_SRV", SimStruct)}, name="<anon>", label="None")),)), name="D3D11_SHADER_RESOURCE_VIEW_DESC", pack=False, align=None),
    "D3D11_SHADER_RESOURCE_VIEW_DESC1": SimStruct(OrderedDict((("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("ViewDimension", SimTypeInt(signed=False, label="D3D_SRV_DIMENSION")), ("Anonymous", SimUnion({"Buffer": SimTypeRef("D3D11_BUFFER_SRV", SimStruct), "Texture1D": SimTypeRef("D3D11_TEX1D_SRV", SimStruct), "Texture1DArray": SimTypeRef("D3D11_TEX1D_ARRAY_SRV", SimStruct), "Texture2D": SimTypeRef("D3D11_TEX2D_SRV1", SimStruct), "Texture2DArray": SimTypeRef("D3D11_TEX2D_ARRAY_SRV1", SimStruct), "Texture2DMS": SimTypeRef("D3D11_TEX2DMS_SRV", SimStruct), "Texture2DMSArray": SimTypeRef("D3D11_TEX2DMS_ARRAY_SRV", SimStruct), "Texture3D": SimTypeRef("D3D11_TEX3D_SRV", SimStruct), "TextureCube": SimTypeRef("D3D11_TEXCUBE_SRV", SimStruct), "TextureCubeArray": SimTypeRef("D3D11_TEXCUBE_ARRAY_SRV", SimStruct), "BufferEx": SimTypeRef("D3D11_BUFFEREX_SRV", SimStruct)}, name="<anon>", label="None")),)), name="D3D11_SHADER_RESOURCE_VIEW_DESC1", pack=False, align=None),
    "D3D11_SHADER_TRACE_DESC": SimStruct(OrderedDict((("Type", SimTypeInt(signed=False, label="D3D11_SHADER_TYPE")), ("Flags", SimTypeInt(signed=False, label="UInt32")), ("Anonymous", SimUnion({"VertexShaderTraceDesc": SimTypeRef("D3D11_VERTEX_SHADER_TRACE_DESC", SimStruct), "HullShaderTraceDesc": SimTypeRef("D3D11_HULL_SHADER_TRACE_DESC", SimStruct), "DomainShaderTraceDesc": SimTypeRef("D3D11_DOMAIN_SHADER_TRACE_DESC", SimStruct), "GeometryShaderTraceDesc": SimTypeRef("D3D11_GEOMETRY_SHADER_TRACE_DESC", SimStruct), "PixelShaderTraceDesc": SimTypeRef("D3D11_PIXEL_SHADER_TRACE_DESC", SimStruct), "ComputeShaderTraceDesc": SimTypeRef("D3D11_COMPUTE_SHADER_TRACE_DESC", SimStruct)}, name="<anon>", label="None")),)), name="D3D11_SHADER_TRACE_DESC", pack=False, align=None),
    "D3D11_SHADER_TRACKING_OPTIONS": SimTypeInt(signed=False, label="D3D11_SHADER_TRACKING_OPTIONS"),
    "D3D11_SHADER_TRACKING_RESOURCE_TYPE": SimTypeInt(signed=False, label="D3D11_SHADER_TRACKING_RESOURCE_TYPE"),
    "D3D11_SHADER_TYPE": SimTypeInt(signed=False, label="D3D11_SHADER_TYPE"),
    "D3D11_SHADER_TYPE_DESC": SimStruct(OrderedDict((("Class", SimTypeInt(signed=False, label="D3D_SHADER_VARIABLE_CLASS")), ("Type", SimTypeInt(signed=False, label="D3D_SHADER_VARIABLE_TYPE")), ("Rows", SimTypeInt(signed=False, label="UInt32")), ("Columns", SimTypeInt(signed=False, label="UInt32")), ("Elements", SimTypeInt(signed=False, label="UInt32")), ("Members", SimTypeInt(signed=False, label="UInt32")), ("Offset", SimTypeInt(signed=False, label="UInt32")), ("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)),)), name="D3D11_SHADER_TYPE_DESC", pack=False, align=None),
    "D3D11_SHADER_VARIABLE_DESC": SimStruct(OrderedDict((("Name", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("StartOffset", SimTypeInt(signed=False, label="UInt32")), ("Size", SimTypeInt(signed=False, label="UInt32")), ("uFlags", SimTypeInt(signed=False, label="UInt32")), ("DefaultValue", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("StartTexture", SimTypeInt(signed=False, label="UInt32")), ("TextureSize", SimTypeInt(signed=False, label="UInt32")), ("StartSampler", SimTypeInt(signed=False, label="UInt32")), ("SamplerSize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_SHADER_VARIABLE_DESC", pack=False, align=None),
    "D3D11_SHADER_VERSION_TYPE": SimTypeInt(signed=False, label="D3D11_SHADER_VERSION_TYPE"),
    "D3D11_SHARED_RESOURCE_TIER": SimTypeInt(signed=False, label="D3D11_SHARED_RESOURCE_TIER"),
    "D3D11_SIGNATURE_PARAMETER_DESC": SimStruct(OrderedDict((("SemanticName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("SemanticIndex", SimTypeInt(signed=False, label="UInt32")), ("Register", SimTypeInt(signed=False, label="UInt32")), ("SystemValueType", SimTypeInt(signed=False, label="D3D_NAME")), ("ComponentType", SimTypeInt(signed=False, label="D3D_REGISTER_COMPONENT_TYPE")), ("Mask", SimTypeChar(label="Byte")), ("ReadWriteMask", SimTypeChar(label="Byte")), ("Stream", SimTypeInt(signed=False, label="UInt32")), ("MinPrecision", SimTypeInt(signed=False, label="D3D_MIN_PRECISION")),)), name="D3D11_SIGNATURE_PARAMETER_DESC", pack=False, align=None),
    "D3D11_SO_DECLARATION_ENTRY": SimStruct(OrderedDict((("Stream", SimTypeInt(signed=False, label="UInt32")), ("SemanticName", SimTypePointer(SimTypeChar(label="Byte"), offset=0)), ("SemanticIndex", SimTypeInt(signed=False, label="UInt32")), ("StartComponent", SimTypeChar(label="Byte")), ("ComponentCount", SimTypeChar(label="Byte")), ("OutputSlot", SimTypeChar(label="Byte")),)), name="D3D11_SO_DECLARATION_ENTRY", pack=False, align=None),
    "D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS": SimTypeInt(signed=False, label="D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS"),
    "D3D11_STENCIL_OP": SimTypeInt(signed=False, label="D3D11_STENCIL_OP"),
    "D3D11_SUBRESOURCE_DATA": SimStruct(OrderedDict((("pSysMem", SimTypePointer(SimTypeBottom(label="Void"), offset=0)), ("SysMemPitch", SimTypeInt(signed=False, label="UInt32")), ("SysMemSlicePitch", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_SUBRESOURCE_DATA", pack=False, align=None),
    "D3D11_SUBRESOURCE_TILING": SimStruct(OrderedDict((("WidthInTiles", SimTypeInt(signed=False, label="UInt32")), ("HeightInTiles", SimTypeShort(signed=False, label="UInt16")), ("DepthInTiles", SimTypeShort(signed=False, label="UInt16")), ("StartTileIndexInOverallResource", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_SUBRESOURCE_TILING", pack=False, align=None),
    "D3D11_TEX1D_ARRAY_DSV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX1D_ARRAY_DSV", pack=False, align=None),
    "D3D11_TEX1D_ARRAY_RTV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX1D_ARRAY_RTV", pack=False, align=None),
    "D3D11_TEX1D_ARRAY_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX1D_ARRAY_SRV", pack=False, align=None),
    "D3D11_TEX1D_ARRAY_UAV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX1D_ARRAY_UAV", pack=False, align=None),
    "D3D11_TEX1D_DSV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX1D_DSV", pack=False, align=None),
    "D3D11_TEX1D_RTV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX1D_RTV", pack=False, align=None),
    "D3D11_TEX1D_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX1D_SRV", pack=False, align=None),
    "D3D11_TEX1D_UAV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX1D_UAV", pack=False, align=None),
    "D3D11_TEX2DMS_ARRAY_DSV": SimStruct(OrderedDict((("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2DMS_ARRAY_DSV", pack=False, align=None),
    "D3D11_TEX2DMS_ARRAY_RTV": SimStruct(OrderedDict((("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2DMS_ARRAY_RTV", pack=False, align=None),
    "D3D11_TEX2DMS_ARRAY_SRV": SimStruct(OrderedDict((("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2DMS_ARRAY_SRV", pack=False, align=None),
    "D3D11_TEX2DMS_DSV": SimStruct(OrderedDict((("UnusedField_NothingToDefine", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2DMS_DSV", pack=False, align=None),
    "D3D11_TEX2DMS_RTV": SimStruct(OrderedDict((("UnusedField_NothingToDefine", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2DMS_RTV", pack=False, align=None),
    "D3D11_TEX2DMS_SRV": SimStruct(OrderedDict((("UnusedField_NothingToDefine", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2DMS_SRV", pack=False, align=None),
    "D3D11_TEX2D_ARRAY_DSV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_ARRAY_DSV", pack=False, align=None),
    "D3D11_TEX2D_ARRAY_RTV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_ARRAY_RTV", pack=False, align=None),
    "D3D11_TEX2D_ARRAY_RTV1": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")), ("PlaneSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_ARRAY_RTV1", pack=False, align=None),
    "D3D11_TEX2D_ARRAY_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_ARRAY_SRV", pack=False, align=None),
    "D3D11_TEX2D_ARRAY_SRV1": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")), ("PlaneSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_ARRAY_SRV1", pack=False, align=None),
    "D3D11_TEX2D_ARRAY_UAV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_ARRAY_UAV", pack=False, align=None),
    "D3D11_TEX2D_ARRAY_UAV1": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")), ("PlaneSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_ARRAY_UAV1", pack=False, align=None),
    "D3D11_TEX2D_ARRAY_VPOV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstArraySlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_ARRAY_VPOV", pack=False, align=None),
    "D3D11_TEX2D_DSV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_DSV", pack=False, align=None),
    "D3D11_TEX2D_RTV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_RTV", pack=False, align=None),
    "D3D11_TEX2D_RTV1": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("PlaneSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_RTV1", pack=False, align=None),
    "D3D11_TEX2D_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_SRV", pack=False, align=None),
    "D3D11_TEX2D_SRV1": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("PlaneSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_SRV1", pack=False, align=None),
    "D3D11_TEX2D_UAV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_UAV", pack=False, align=None),
    "D3D11_TEX2D_UAV1": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("PlaneSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_UAV1", pack=False, align=None),
    "D3D11_TEX2D_VDOV": SimStruct(OrderedDict((("ArraySlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_VDOV", pack=False, align=None),
    "D3D11_TEX2D_VPIV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("ArraySlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_VPIV", pack=False, align=None),
    "D3D11_TEX2D_VPOV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX2D_VPOV", pack=False, align=None),
    "D3D11_TEX3D_RTV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstWSlice", SimTypeInt(signed=False, label="UInt32")), ("WSize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX3D_RTV", pack=False, align=None),
    "D3D11_TEX3D_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX3D_SRV", pack=False, align=None),
    "D3D11_TEX3D_UAV": SimStruct(OrderedDict((("MipSlice", SimTypeInt(signed=False, label="UInt32")), ("FirstWSlice", SimTypeInt(signed=False, label="UInt32")), ("WSize", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEX3D_UAV", pack=False, align=None),
    "D3D11_TEXCUBE_ARRAY_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("First2DArrayFace", SimTypeInt(signed=False, label="UInt32")), ("NumCubes", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEXCUBE_ARRAY_SRV", pack=False, align=None),
    "D3D11_TEXCUBE_SRV": SimStruct(OrderedDict((("MostDetailedMip", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEXCUBE_SRV", pack=False, align=None),
    "D3D11_TEXTURE1D_DESC": SimStruct(OrderedDict((("Width", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")), ("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("Usage", SimTypeInt(signed=False, label="D3D11_USAGE")), ("BindFlags", SimTypeInt(signed=False, label="UInt32")), ("CPUAccessFlags", SimTypeInt(signed=False, label="UInt32")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEXTURE1D_DESC", pack=False, align=None),
    "D3D11_TEXTURE2D_DESC": SimStruct(OrderedDict((("Width", SimTypeInt(signed=False, label="UInt32")), ("Height", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")), ("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("SampleDesc", SimTypeRef("DXGI_SAMPLE_DESC", SimStruct)), ("Usage", SimTypeInt(signed=False, label="D3D11_USAGE")), ("BindFlags", SimTypeInt(signed=False, label="UInt32")), ("CPUAccessFlags", SimTypeInt(signed=False, label="UInt32")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEXTURE2D_DESC", pack=False, align=None),
    "D3D11_TEXTURE2D_DESC1": SimStruct(OrderedDict((("Width", SimTypeInt(signed=False, label="UInt32")), ("Height", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("ArraySize", SimTypeInt(signed=False, label="UInt32")), ("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("SampleDesc", SimTypeRef("DXGI_SAMPLE_DESC", SimStruct)), ("Usage", SimTypeInt(signed=False, label="D3D11_USAGE")), ("BindFlags", SimTypeInt(signed=False, label="UInt32")), ("CPUAccessFlags", SimTypeInt(signed=False, label="UInt32")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")), ("TextureLayout", SimTypeInt(signed=False, label="D3D11_TEXTURE_LAYOUT")),)), name="D3D11_TEXTURE2D_DESC1", pack=False, align=None),
    "D3D11_TEXTURE3D_DESC": SimStruct(OrderedDict((("Width", SimTypeInt(signed=False, label="UInt32")), ("Height", SimTypeInt(signed=False, label="UInt32")), ("Depth", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("Usage", SimTypeInt(signed=False, label="D3D11_USAGE")), ("BindFlags", SimTypeInt(signed=False, label="UInt32")), ("CPUAccessFlags", SimTypeInt(signed=False, label="UInt32")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TEXTURE3D_DESC", pack=False, align=None),
    "D3D11_TEXTURE3D_DESC1": SimStruct(OrderedDict((("Width", SimTypeInt(signed=False, label="UInt32")), ("Height", SimTypeInt(signed=False, label="UInt32")), ("Depth", SimTypeInt(signed=False, label="UInt32")), ("MipLevels", SimTypeInt(signed=False, label="UInt32")), ("Format", SimTypeInt(signed=False, label="DXGI_FORMAT")), ("Usage", SimTypeInt(signed=False, label="D3D11_USAGE")), ("BindFlags", SimTypeInt(signed=False, label="UInt32")), ("CPUAccessFlags", SimTypeInt(signed=False, label="UInt32")), ("MiscFlags", SimTypeInt(signed=False, label="UInt32")), ("TextureLayout", SimTypeInt(signed=False, label="D3D11_TEXTURE_LAYOUT")),)), name="D3D11_TEXTURE3D_DESC1", pack=False, align=None),
    "D3D11_TEXTURECUBE_FACE": SimTypeInt(signed=False, label="D3D11_TEXTURECUBE_FACE"),
    "D3D11_TEXTURE_ADDRESS_MODE": SimTypeInt(signed=False, label="D3D11_TEXTURE_ADDRESS_MODE"),
    "D3D11_TEXTURE_LAYOUT": SimTypeInt(signed=False, label="D3D11_TEXTURE_LAYOUT"),
    "D3D11_TILED_RESOURCES_TIER": SimTypeInt(signed=False, label="D3D11_TILED_RESOURCES_TIER"),
    "D3D11_TILED_RESOURCE_COORDINATE": SimStruct(OrderedDict((("X", SimTypeInt(signed=False, label="UInt32")), ("Y", SimTypeInt(signed=False, label="UInt32")), ("Z", SimTypeInt(signed=False, label="UInt32")), ("Subresource", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TILED_RESOURCE_COORDINATE", pack=False, align=None),
    "D3D11_TILE_COPY_FLAG": SimTypeInt(signed=False, label="D3D11_TILE_COPY_FLAG"),
    "D3D11_TILE_MAPPING_FLAG": SimTypeInt(signed=False, label="D3D11_TILE_MAPPING_FLAG"),
    "D3D11_TILE_RANGE_FLAG": SimTypeInt(signed=False, label="D3D11_TILE_RANGE_FLAG"),
    "D3D11_TILE_REGION_SIZE": SimStruct(OrderedDict((("NumTiles", SimTypeInt(signed=False, label="UInt32")), ("bUseBox", SimTypeInt(signed=True, label="Int32")), ("Width", SimTypeInt(signed=False, label="UInt32")), ("Height", SimTypeShort(signed=False, label="UInt16")), ("Depth", SimTypeShort(signed=False, label="UInt16")),)), name="D3D11_TILE_REGION_SIZE", pack=False, align=None),
    "D3D11_TILE_SHAPE": SimStruct(OrderedDict((("WidthInTexels", SimTypeInt(signed=False, label="UInt32")), ("HeightInTexels", SimTypeInt(signed=False, label="UInt32")), ("DepthInTexels", SimTypeInt(signed=False, label="UInt32")),)), name="D3D11_TILE_SHAPE", pack=False, align=None),
    "D3D11_TRACE_GS_INPUT_PRIMITIVE": SimTypeInt(signed=False, label="D3D11_TRACE_GS_INPUT_PRIMITIVE"),
    "D3D11_TRACE_REGISTER": SimStruct(OrderedDict((("RegType", SimTypeInt(signed=False, label="D3D11_TRACE_REGISTER_TYPE")), ("Anonymous", SimUnion({"Index1D": SimTypeShort(signed=False, label="UInt16"), "Index2D": SimTypeArray(SimTypeShort(signed=False, label="UInt16"), 2)}, name="<anon>", label="None")), ("OperandIndex", SimTypeChar(label="Byte")), ("Flags", SimTypeChar(label="Byte")),)), name="D3D11_TRACE_REGISTER", pack=False, align=None),
    "D3D11_TRACE_REGISTER_TYPE": SimTypeInt(signed=False, label="D3D11_TRACE_REGISTER_TYPE"),
    "D3D11_TRACE_STATS": SimStruct(OrderedDict((("TraceDesc", SimTypeRef("D3D11_SHADER_TRACE_DESC", SimStruct)), ("NumInvocationsInStamp", SimTypeChar(label="Byte")), ("TargetStampIndex", SimTypeChar(label="Byte")), ("NumTraceSteps", SimTypeInt(signed=False, label="UInt32")), ("InputMask", SimTypeArray(SimTypeChar(label="Byte"), 32)), ("OutputMask", SimTypeArray(SimTypeChar(label="Byte"), 32)), ("NumTemps", SimTypeShort(signed=False, label="UInt16")), ("MaxIndexableTempIndex", SimTypeShort(signed=False, label="UInt16")), ("IndexableTempSize", SimTypeArray(SimTypeShort(signed=False, label="UInt16"), 4096)), ("ImmediateConstantBufferSize", SimTypeShort(signed=False, label=