/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.MultiValueMapLinkedHashSet;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.bean.ContentTypeBean;
import org.wiztools.restclient.bean.HTTPMethod;

public final class HttpUtil {
    public static final ContentType DEFAULT_CONTENT_TYPE = new ContentTypeBean("text/plain", Charsets.UTF_8);
    public static final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    private static List<String> TEXT_CT = Arrays.asList("application/x-javascript", "application/javascript");
    private static final List<String> entityEnclosingMethods = Collections.unmodifiableList(Arrays.asList("GET", "POST", "PUT", "PATCH", "DELETE"));

    public static ContentType getContentType(String header) {
        String[] arr = header.split("\\s*;\\s*");
        if (arr.length == 1) {
            return new ContentTypeBean(header, null);
        }
        String contentType = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            Pattern p;
            Matcher m3;
            String headerPart = arr[i];
            if (!headerPart.contains("charset=") || !(m3 = (p = Pattern.compile("charset=(.+)")).matcher(headerPart)).matches()) continue;
            Charset charset = Charset.forName(m3.group(1));
            return new ContentTypeBean(contentType, charset);
        }
        return new ContentTypeBean(contentType, null);
    }

    public static ContentType getContentType(MultiValueMap<String, String> headers) {
        for (String key : headers.keySet()) {
            if (!"content-type".equalsIgnoreCase(key.trim())) continue;
            return HttpUtil.getContentType(headers.get(key).iterator().next());
        }
        return null;
    }

    public static int getStatusCodeFromStatusLine(String statusLine) {
        int retVal = -1;
        String STATUS_PATTERN = "[^\\s]+\\s([0-9]{3})\\s.*";
        Pattern p = Pattern.compile("[^\\s]+\\s([0-9]{3})\\s.*");
        Matcher m3 = p.matcher(statusLine);
        if (m3.matches()) {
            retVal = Integer.parseInt(m3.group(1));
        }
        return retVal;
    }

    public static String getFormattedContentType(String contentType, String charset) {
        String charsetFormatted = StringUtil.isEmpty(charset) ? "" : "; charset=" + charset;
        return contentType + charsetFormatted;
    }

    public static String getFormattedContentType(String contentType, Charset charset) {
        return HttpUtil.getFormattedContentType(contentType, charset != null ? charset.name() : null);
    }

    public static String getFormattedContentType(ContentType contentType) {
        return HttpUtil.getFormattedContentType(contentType.getContentType(), contentType.getCharset());
    }

    public static String getCharsetFromContentType(String contentType) {
        Pattern p = Pattern.compile("^.+charset=([^;]+).*$");
        Matcher m3 = p.matcher(contentType);
        if (m3.matches()) {
            return m3.group(1).trim();
        }
        return null;
    }

    public static String getMimeFromContentType(String contentType) {
        int occurance = contentType.indexOf(59);
        if (occurance == -1) {
            return contentType;
        }
        return contentType.substring(0, occurance);
    }

    private static String getContentTypeBeforeSemiColon(String contentType) {
        return contentType.indexOf(59) != -1 ? contentType.split(";")[0] : contentType;
    }

    public static boolean isWebImageContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.equals("image/jpeg") || ct.equals("image/png") || ct.equals("image/gif");
    }

    public static boolean isTextContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.startsWith("text/") || HttpUtil.isXmlContentType(ct) || HttpUtil.isJsonContentType(ct) || HttpUtil.isFormUrlEncodedContentType(ct) || TEXT_CT.contains(ct);
    }

    public static boolean isXmlContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.startsWith("application/xml") || ct.startsWith("text/xml") || ct.endsWith("+xml");
    }

    public static boolean isJsonContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.startsWith("application/json") || ct.endsWith("+json");
    }

    public static boolean isJsContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.startsWith("application/javascript") || ct.startsWith("application/x-javascript") || ct.startsWith("text/javascript");
    }

    public static boolean isCssContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.startsWith("text/css");
    }

    public static boolean isHTMLContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.startsWith("text/html") || ct.endsWith("+html");
    }

    public static boolean isFormUrlEncodedContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.startsWith("application/x-www-form-urlencoded");
    }

    public static Charset getCharsetDefault(ContentType type) {
        return type != null ? (type.getCharset() != null ? type.getCharset() : DEFAULT_CHARSET) : DEFAULT_CHARSET;
    }

    public static boolean isEntityEnclosingMethod(String method) {
        return entityEnclosingMethods.contains(method);
    }

    public static boolean isEntityEnclosingMethod(HTTPMethod method) {
        return HttpUtil.isEntityEnclosingMethod(method.name());
    }

    public static MultiValueMap<String, String> getXWwwFormUrlEncoded2Map(String str) {
        String[] pairs;
        MultiValueMapLinkedHashSet<String, String> out = new MultiValueMapLinkedHashSet<String, String>();
        for (String pair : pairs = str.split("\\&")) {
            String[] fields = pair.split("=");
            if (fields.length != 2) continue;
            try {
                String key = URLDecoder.decode(fields[0], Charsets.UTF_8.name());
                String value = URLDecoder.decode(fields[1], Charsets.UTF_8.name());
                out.put(key, value);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return out;
    }
}

