/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    protected JScrollPane scrollpane;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    MouseWheelListener mouseWheelListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicScrollPaneUI();
    }

    protected void installDefaults(JScrollPane p) {
        this.scrollpane = p;
        LookAndFeel.installColorsAndFont(p, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        LookAndFeel.installBorder(p, "ScrollPane.border");
        p.setOpaque(true);
    }

    protected void uninstallDefaults(JScrollPane p) {
        p.setForeground(null);
        p.setBackground(null);
        p.setFont(null);
        p.setBorder(null);
        this.scrollpane = null;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.installDefaults((JScrollPane)c);
        this.installListeners((JScrollPane)c);
        this.installKeyboardActions((JScrollPane)c);
    }

    protected void installListeners(JScrollPane sp) {
        if (this.spPropertyChangeListener == null) {
            this.spPropertyChangeListener = this.createPropertyChangeListener();
        }
        sp.addPropertyChangeListener(this.spPropertyChangeListener);
        if (this.hsbChangeListener == null) {
            this.hsbChangeListener = this.createHSBChangeListener();
        }
        sp.getHorizontalScrollBar().getModel().addChangeListener(this.hsbChangeListener);
        if (this.vsbChangeListener == null) {
            this.vsbChangeListener = this.createVSBChangeListener();
        }
        sp.getVerticalScrollBar().getModel().addChangeListener(this.vsbChangeListener);
        if (this.viewportChangeListener == null) {
            this.viewportChangeListener = this.createViewportChangeListener();
        }
        sp.getViewport().addChangeListener(this.viewportChangeListener);
        if (this.mouseWheelListener == null) {
            this.mouseWheelListener = this.createMouseWheelListener();
        }
        sp.addMouseWheelListener(this.mouseWheelListener);
    }

    protected void installKeyboardActions(JScrollPane sp) {
    }

    protected ChangeListener createHSBChangeListener() {
        return new HSBChangeListener();
    }

    protected ChangeListener createVSBChangeListener() {
        return new VSBChangeListener();
    }

    protected ChangeListener createViewportChangeListener() {
        return new ViewportChangeHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults((JScrollPane)c);
        this.uninstallListeners((JScrollPane)c);
        this.installKeyboardActions((JScrollPane)c);
    }

    protected void uninstallListeners(JComponent c) {
        JScrollPane sp = (JScrollPane)c;
        sp.removePropertyChangeListener(this.spPropertyChangeListener);
        sp.getHorizontalScrollBar().getModel().removeChangeListener(this.hsbChangeListener);
        sp.getVerticalScrollBar().getModel().removeChangeListener(this.vsbChangeListener);
        sp.getViewport().removeChangeListener(this.viewportChangeListener);
        sp.removeMouseWheelListener(this.mouseWheelListener);
    }

    protected void uninstallKeyboardActions(JScrollPane sp) {
    }

    public Dimension getMinimumSize(JComponent c) {
        JScrollPane p = (JScrollPane)c;
        ScrollPaneLayout sl = (ScrollPaneLayout)p.getLayout();
        return sl.minimumLayoutSize(c);
    }

    public void paint(Graphics g, JComponent c) {
    }

    protected void syncScrollPaneWithViewport() {
        JViewport vp = this.scrollpane.getViewport();
        JScrollBar hsb = this.scrollpane.getHorizontalScrollBar();
        hsb.setMaximum(vp.getViewSize().width);
        hsb.setValue(vp.getViewPosition().x);
        hsb.setVisibleAmount(vp.getExtentSize().width);
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        vsb.setMaximum(vp.getViewSize().height);
        vsb.setValue(vp.getViewPosition().y);
        vsb.setVisibleAmount(vp.getExtentSize().height);
    }

    protected void updateColumnHeader(PropertyChangeEvent ev) {
    }

    protected void updateRowHeader(PropertyChangeEvent ev) {
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent ev) {
    }

    protected void updateViewport(PropertyChangeEvent ev) {
        JViewport oldViewport = (JViewport)ev.getOldValue();
        oldViewport.removeChangeListener(this.viewportChangeListener);
        JViewport newViewport = (JViewport)ev.getNewValue();
        oldViewport.addChangeListener(this.viewportChangeListener);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class HSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent event) {
            JScrollBar hsb = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
            JViewport vp = BasicScrollPaneUI.this.scrollpane.getViewport();
            Point viewPosition = vp.getViewPosition();
            int xpos = hsb.getValue();
            if (xpos != viewPosition.x) {
                viewPosition.x = xpos;
                vp.setViewPosition(viewPosition);
            }
            viewPosition.y = 0;
            JViewport columnHeader = BasicScrollPaneUI.this.scrollpane.getColumnHeader();
            if (columnHeader != null && !columnHeader.getViewPosition().equals(viewPosition)) {
                columnHeader.setViewPosition(viewPosition);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class VSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent event) {
            JScrollBar vsb = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
            JViewport vp = BasicScrollPaneUI.this.scrollpane.getViewport();
            Point viewPosition = vp.getViewPosition();
            int ypos = vsb.getValue();
            if (ypos != viewPosition.y) {
                viewPosition.y = ypos;
                vp.setViewPosition(viewPosition);
            }
            viewPosition.x = 0;
            JViewport rowHeader = BasicScrollPaneUI.this.scrollpane.getRowHeader();
            if (rowHeader != null && !rowHeader.getViewPosition().equals(viewPosition)) {
                rowHeader.setViewPosition(viewPosition);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ViewportChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent event) {
            JViewport vp = BasicScrollPaneUI.this.scrollpane.getViewport();
            JScrollBar hsb = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
            JScrollBar vsb = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
            BasicScrollPaneUI.this.syncScrollPaneWithViewport();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            if (propName.equals("viewport")) {
                BasicScrollPaneUI.this.updateViewport(e);
            } else if (propName.equals("rowHeader")) {
                BasicScrollPaneUI.this.updateRowHeader(e);
            } else if (propName.equals("columnHeader")) {
                BasicScrollPaneUI.this.updateColumnHeader(e);
            } else if (propName.equals("horizontalScrollBarPolicy") || e.getPropertyName().equals("verticalScrollBarPolicy")) {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(e);
            } else if (propName.equals("verticalScrollBar")) {
                JScrollBar oldSb = (JScrollBar)e.getOldValue();
                oldSb.getModel().removeChangeListener(BasicScrollPaneUI.this.vsbChangeListener);
                JScrollBar newSb = (JScrollBar)e.getNewValue();
                newSb.getModel().addChangeListener(BasicScrollPaneUI.this.vsbChangeListener);
            } else if (propName.equals("horizontalScrollBar")) {
                JScrollBar oldSb = (JScrollBar)e.getOldValue();
                oldSb.getModel().removeChangeListener(BasicScrollPaneUI.this.hsbChangeListener);
                JScrollBar newSb = (JScrollBar)e.getNewValue();
                newSb.getModel().addChangeListener(BasicScrollPaneUI.this.hsbChangeListener);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MouseWheelHandler
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent event) {
        }

        protected MouseWheelHandler() {
        }
    }
}

