/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class ChannelDispatchOperationInterface
 * \headerfile TelepathyQt/channel-dispatch-operation.h <TelepathyQt/ChannelDispatchOperation>
 * \ingroup clientchanneldispatchoperation
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.ChannelDispatchOperation".
 */
class TP_QT_EXPORT ChannelDispatchOperationInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.ChannelDispatchOperation", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.ChannelDispatchOperation");
    }

    /**
     * Creates a ChannelDispatchOperationInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelDispatchOperationInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelDispatchOperationInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelDispatchOperationInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelDispatchOperationInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelDispatchOperationInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c Interfaces of type \c QStringList.
     *
     * 
     * A list of the extra interfaces provided by this channel dispatch 
     * operation. This property cannot change.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInterfaces() const
    {
        return internalRequestProperty(QLatin1String("Interfaces"));
    }

    /**
     * Asynchronous getter for the remote object property \c Connection of type \c QDBusObjectPath.
     *
     * 
     * The Connection with which the Channels are associated. The well-known 
     * bus name to use can be derived from this object path by removing the 
     * leading &apos;/&apos; and replacing all subsequent &apos;/&apos; by 
     * &apos;.&apos;. This property cannot change.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyConnection() const
    {
        return internalRequestProperty(QLatin1String("Connection"));
    }

    /**
     * Asynchronous getter for the remote object property \c Account of type \c QDBusObjectPath.
     *
     * 
     * The Account with which the Connection and Channels are associated. This 
     * property cannot change.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAccount() const
    {
        return internalRequestProperty(QLatin1String("Account"));
    }

    /**
     * Asynchronous getter for the remote object property \c Channels of type \c Tp::ChannelDetailsList.
     *
     * 
     * The Channels to be dispatched, and their properties. Change 
     * notification is via the ChannelLost signal (channels cannot be added to 
     * this property, only removed).
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyChannels() const
    {
        return internalRequestProperty(QLatin1String("Channels"));
    }

    /**
     * Asynchronous getter for the remote object property \c PossibleHandlers of type \c QStringList.
     *
     * 
     * The well known bus names (starting with 
     * org.freedesktop.Telepathy.Client.) of the possible Handlers for these 
     * channels. The channel dispatcher MUST place the most preferred handlers 
     * first, according to some reasonable heuristic. As a result, approvers 
     * SHOULD use the first handler by default. The heuristic used to 
     * prioritize handlers SHOULD give a higher priority to handlers that are 
     * already running. If, for instance, Empathy and Kopete have similar 
     * functionality, and Empathy is running, we should prefer to send 
     * channels to it rather than launching Kopete via service activation.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyPossibleHandlers() const
    {
        return internalRequestProperty(QLatin1String("PossibleHandlers"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c HandleWith on the remote object.
     * 
     * \htmlonly
     * <p>Called by an approver to accept a channel bundle and request that
     *   the given handler be used to handle it.</p>
     * 
     * <p>If successful, this method will cause the ChannelDispatchOperation
     *   object to disappear, emitting
     *    \endhtmlonly Finished() \htmlonly .</p>
     * 
     * <p>However, this method may fail because the dispatch has already been
     *   completed and the object has already gone. If this occurs, it
     *   indicates that another approver has asked for the bundle to be
     *   handled by a particular handler. The approver MUST NOT attempt
     *   to interact with the channels further in this case, unless it is
     *   separately invoked as the handler.</p>
     * 
     * <p>Approvers which are also channel handlers SHOULD use
     *    \endhtmlonly Claim() \htmlonly  instead
     *   of HandleWith to request that they can handle a channel bundle
     *   themselves.</p>
     * 
     * <p>(FIXME: list some possible errors)</p>
     * 
     * <p>If the channel handler raises an error from  \endhtmlonly ClientHandlerInterface::HandleChannels() \htmlonly ,
     *   this method
     *   MAY respond by raising that same error, even if it is not
     *   specifically documented here.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param handler
     *     
     *     \htmlonly
     *     <p>The well-known bus name (starting with
     *       <code>org.freedesktop.Telepathy.Client.</code>) of the channel
     *       handler that should handle the channel, or the empty string
     *       if the client has no preferred channel handler.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> HandleWith(const QString& handler, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("HandleWith"));
        callMessage << QVariant::fromValue(handler);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Claim on the remote object.
     * 
     * \htmlonly
     * <p>Called by an approver to claim channels for handling
     *   internally. If this method is called successfully, the process
     *   calling this method becomes the handler for the channel, but
     *   <em>does not</em> have the  \endhtmlonly ClientHandlerInterface::HandleChannels() \htmlonly 
     *   method called on it.</p>
     * 
     * <p>Clients that call Claim on channels but do not immediately
     *   close them SHOULD implement the Handler interface and its
     *    \endhtmlonly \link ClientHandlerInterface::requestPropertyHandledChannels() ClientHandlerInterface::HandledChannels \endlink \htmlonly 
     *   property.</p>
     * 
     * <p>Approvers wishing to reject channels MUST call this method to
     *   claim ownership of them, and MUST NOT call
     *    \endhtmlonly ChannelInterface::Close() \htmlonly 
     *   on the channels unless/until this method returns successfully.</p>
     * 
     * <div class="rationale">
     *   <p>The channel dispatcher can't know how best to close arbitrary
     *     channel types, so it leaves it up to the approver to do so.
     *     For instance, for Text channels it is necessary
     *     to acknowledge any messages that have already been displayed to
     *     the user first - ideally, the approver would display and then
     *     acknowledge the messages - or to call  \endhtmlonly ChannelInterfaceDestroyableInterface::Destroy() \htmlonly 
     *     if the destructive behaviour of that method is desired.</p>
     * 
     *   <p>Similarly, an Approver for StreamedMedia channels can close the
     *     channel with a reason (e.g. "busy") if desired. The channel
     *     dispatcher, which is designed to have no specific knowledge
     *     of particular channel types, can't do that.</p>
     * </div>
     * 
     * <p>If successful, this method will cause the ChannelDispatchOperation
     *   object to disappear, emitting
     *    \endhtmlonly Finished() \htmlonly , in the same way as for
     *    \endhtmlonly HandleWith() \htmlonly .</p>
     * 
     * <p>This method may fail because the dispatch operation has already
     *   been completed. Again, see HandleWith for more details. The approver
     *   MUST NOT attempt to interact with the channels further in this
     *   case.</p>
     * 
     * <p>(FIXME: list some other possible errors)</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Claim(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Claim"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c HandleWithTime on the remote object.
     * 
     * \htmlonly
     * <p>A variant of  \endhtmlonly HandleWith() \htmlonly  allowing the
     *   approver to pass an user action time. This timestamp will be passed
     *   to the Handler when  \endhtmlonly ClientHandlerInterface::HandleChannels() \htmlonly 
     *   is called.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param handler
     *     
     *     \htmlonly
     *     <p>The well-known bus name (starting with
     *       <code>org.freedesktop.Telepathy.Client.</code>) of the channel
     *       handler that should handle the channel, or the empty string
     *       if the client has no preferred channel handler.</p>
     *     \endhtmlonly
     *
     * \param userActionTime
     *     
     *     \htmlonly
     *     <p>The time at which user action occurred.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> HandleWithTime(const QString& handler, qlonglong userActionTime, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("HandleWithTime"));
        callMessage << QVariant::fromValue(handler) << QVariant::fromValue(userActionTime);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c ChannelLost on the remote object.
     * 
     * \htmlonly
     * <p>A channel has closed before it could be claimed or handled. If
     *   this is emitted for the last remaining channel in a channel
     *   dispatch operation, it MUST immediately be followed by
     *    \endhtmlonly Finished() \htmlonly .</p>
     * 
     * <p>This signal MUST NOT be emitted until all Approvers that were
     *   invoked have returned (successfully or with an error) from
     *   their  \endhtmlonly ClientApproverInterface::AddDispatchOperation() \htmlonly 
     *   method.</p>
     * 
     * <div class="rationale">
     *   <p>This means that Approvers can connect to the ChannelLost signal
     *     in a race-free way. Non-approver processes that discover
     *     a channel dispatch operation in some way (such as observers)
     *     will have to follow the usual "connect to signals then recover
     *     state" model - first connect to ChannelLost and
     *      \endhtmlonly Finished() \htmlonly ,
     *     then download  \endhtmlonly \link requestPropertyChannels() Channels \endlink \htmlonly  (and
     *     on error, perhaps assume that the operation has already
     *     Finished).</p>
     * </div>
     * \endhtmlonly
     *
     * \param channel
     *     
     *     The Channel that closed.
     *
     * \param error
     *     
     *     \htmlonly
     *     <p>The name of a D-Bus error indicating why the channel closed. If
     *       no better reason can be found,
     *       <code>org.freedesktop.Telepathy.Error.NotAvailable</code> MAY
     *       be used as a fallback; this means that this error SHOULD NOT be
     *       given any more specific meaning.</p>
     *     \endhtmlonly
     *
     * \param message
     *     
     *     A string associated with the D-Bus error.
     */
    void ChannelLost(const QDBusObjectPath& channel, const QString& error, const QString& message);

    /**
     * Represents the signal \c Finished on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when this dispatch operation finishes. The dispatch
     *   operation is no longer present and further methods must not be
     *   called on it.</p>
     * 
     * <p>Approvers that have a user interface SHOULD stop notifying the user
     *   about the channels in response to this signal; they MAY assume that
     *   on errors, they would have received
     *    \endhtmlonly ChannelLost() \htmlonly  first.</p>
     * 
     * <p>Its object path SHOULD NOT be reused for a subsequent dispatch
     *   operation; the ChannelDispatcher MUST choose object paths
     *   in a way that avoids immediate re-use.</p>
     * 
     * <div class="rationale">
     *   <p>Otherwise, clients might accidentally call
     *      \endhtmlonly HandleWith() \htmlonly  or
     *      \endhtmlonly Claim() \htmlonly  on a new dispatch operation
     *     instead of the one they intended to handle.</p>
     * </div>
     * 
     * <p>This signal MUST NOT be emitted until all Approvers that were
     *   invoked have returned (successfully or with an error) from
     *   their  \endhtmlonly ClientApproverInterface::AddDispatchOperation() \htmlonly 
     *   method.</p>
     * 
     * <div class="rationale">
     *   <p>This means that Approvers can connect to the ChannelLost signal
     *     in a race-free way. Non-approver processes that discover
     *     a channel dispatch operation in some way (such as observers)
     *     will have to follow the usual "connect to signals then recover
     *     state" model - first connect to
     *      \endhtmlonly ChannelLost() \htmlonly  and
     *     Finished, then download  \endhtmlonly \link requestPropertyChannels() Channels \endlink \htmlonly 
     *     (and on error, perhaps assume that the operation has already
     *     Finished).</p>
     * </div>
     * \endhtmlonly
     */
    void Finished();

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::ChannelDispatchOperationInterface*)
