/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class ConnectionInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection".
 */
class TP_QT_EXPORT ConnectionInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection");
    }

    /**
     * Creates a ConnectionInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c Interfaces of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>The set of optional interfaces supported by this connection.
     *   Before the connection status changes to CONNECTED,
     *   this property may change at any time, but it is guaranteed that
     *   interfaces will only be added, not removed. After the connection
     *   status changes to CONNECTED, this property cannot
     *   change further.</p>
     * 
     * <p>There is no explicit change notification; reasonable behaviour
     *   for a client would be to retrieve the interfaces list once
     *   initially, and once more when it becomes CONNECTED.</p>
     * 
     * <div class="rationale">
     *   <p>In some connection managers, certain capabilities of a connection
     *     are known to be implemented for all connections (e.g. support
     *     for SimplePresence), and some interfaces (like SimplePresence) can
     *     even be used before connecting. Other capabilities may
     *     or may not exist, depending on server functionality; by the time
     *     the connection goes CONNECTED, the connection manager is expected
     *     to have evaluated the server's functionality and enabled any extra
     *     interfaces for the remainder of the Connection's lifetime.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInterfaces() const
    {
        return internalRequestProperty(QLatin1String("Interfaces"));
    }

    /**
     * Asynchronous getter for the remote object property \c SelfHandle of type \c uint.
     *
     * 
     * The handle which represents the user on this connection, which will 
     * remain valid for the lifetime of this connection, or until a change in 
     * the user&apos;s identifier is signalled by the SelfContactChanged 
     * signal. If the connection is not yet in the CONNECTED state, the value 
     * of this property MAY be zero.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySelfHandle() const
    {
        return internalRequestProperty(QLatin1String("SelfHandle"));
    }

    /**
     * Asynchronous getter for the remote object property \c SelfID of type \c QString.
     *
     * 
     * The identifier which represents the user on this connection, which will 
     * remain valid for the lifetime of this connection, or until a change in 
     * the user&apos;s identifier is signalled by the SelfContactChanged 
     * signal. If the connection is not yet in the CONNECTED state, the value 
     * of this property MAY be empty string.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySelfID() const
    {
        return internalRequestProperty(QLatin1String("SelfID"));
    }

    /**
     * Asynchronous getter for the remote object property \c Status of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The current status of the connection. Change notification is via
     *   the  \endhtmlonly StatusChanged() \htmlonly  signal.</p>
     * 
     * <p>If retrieval of property succeeds and yields the value Disconnected,
     *   this indicates that the connection has not yet been established.
     *   If connection has been attempted and failed, the Connection object
     *   SHOULD be removed from the bus entirely, meaning that retrieval of
     *   this property SHOULD fail.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyStatus() const
    {
        return internalRequestProperty(QLatin1String("Status"));
    }

    /**
     * Asynchronous getter for the remote object property \c HasImmortalHandles of type \c bool.
     *
     * 
     * \htmlonly
     * <p>True if handles last for the whole lifetime of the Connection.
     *   This SHOULD be the case in all connection managers, but clients
     *   MUST interoperate with older connection managers
     *   (which reference-count handles).</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHasImmortalHandles() const
    {
        return internalRequestProperty(QLatin1String("HasImmortalHandles"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Connect on the remote object.
     * 
     * \htmlonly
     * <p>Request that the connection be established. This will be done
     *   asynchronously and errors will be returned by emitting
     *    \endhtmlonly StatusChanged() \htmlonly  signals.</p>
     * 
     * <p>Calling this method on a Connection that is already connecting
     *   or connected is allowed, and has no effect.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Connect(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Connect"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Disconnect on the remote object.
     * 
     * Request that the connection be closed. This closes the connection if 
     * it&apos;s not already in DISCONNECTED state, and destroys the 
     * connection object.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Disconnect(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Disconnect"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetInterfaces on the remote object.
     * 
     * \htmlonly
     * <p>Returns the set of optional interfaces supported by this
     *   connection. See  \endhtmlonly \link requestPropertyInterfaces() Interfaces \endlink \htmlonly  for more
     *   details.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The value of the Interfaces property
     */
    inline QDBusPendingReply<QStringList> GetInterfaces(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QStringList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetInterfaces"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetProtocol on the remote object.
     * 
     * Get the protocol this connection is using.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A string identifier for the protocol
     */
    inline QDBusPendingReply<QString> GetProtocol(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QString>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetProtocol"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetSelfHandle on the remote object.
     * 
     * Returns the value of the SelfHandle property. Change notification is 
     * via the SelfHandleChanged signal.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The value of the SelfHandle property
     */
    inline QDBusPendingReply<uint> GetSelfHandle(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetSelfHandle"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetStatus on the remote object.
     * 
     * Get the current status as defined in the StatusChanged signal.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The value of the Status property
     */
    inline QDBusPendingReply<uint> GetStatus(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetStatus"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c HoldHandles on the remote object.
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertyHasImmortalHandles() HasImmortalHandles \endlink \htmlonly  is true,
     *   which SHOULD always be the case in this version of telepathy-spec,
     *   this method does nothing and returns successfully, unless
     *   the given handle type or any of the given handles is invalid.</p>
     * 
     * <p>In older connection managers, this method
     * notifies the connection manger that your client is holding a copy
     * of handles which may not be in use in any existing channel or
     * list, and were not obtained by using the
     *  \endhtmlonly RequestHandles() \htmlonly  method. For
     * example, a handle observed in an emitted signal, or displayed
     * somewhere in the UI that is not associated with a channel. The
     * connection manager must not deallocate a handle where any clients
     * have used this method to indicate it is in use until the
     *  \endhtmlonly ReleaseHandles() \htmlonly 
     * method is called, or the clients disappear from the bus.</p>
     * 
     * <p>Note that HoldHandles is idempotent - calling it multiple times
     *   is equivalent to calling it once. If a handle is "referenced" by
     *   several components which share a D-Bus unique name, the client
     *   should perform reference counting internally, and only call
     *   ReleaseHandles when none of the cooperating components need the
     *   handle any longer.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param handleType
     *     
     *     The type of handle to be held
     *
     * \param handles
     *     
     *     A array of integer handles to hold
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> HoldHandles(uint handleType, const Tp::UIntList& handles, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("HoldHandles"));
        callMessage << QVariant::fromValue(handleType) << QVariant::fromValue(handles);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c InspectHandles on the remote object.
     * 
     * Return a string representation for a number of handles of a given type.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param handleType
     *     
     *     The type of handle to be inspected
     *
     * \param handles
     *     
     *     An array of integer handles of this type
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of identifiers corresponding to the given handles, in the 
     *     same order.
     */
    inline QDBusPendingReply<QStringList> InspectHandles(uint handleType, const Tp::UIntList& handles, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QStringList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("InspectHandles"));
        callMessage << QVariant::fromValue(handleType) << QVariant::fromValue(handles);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ListChannels on the remote object.
     * 
     * List all the channels which currently exist on this connection.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of structs representing channels.
     */
    inline QDBusPendingReply<Tp::ChannelInfoList> ListChannels(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ChannelInfoList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ListChannels"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ReleaseHandles on the remote object.
     * 
     * If HasImmortalHandles is true, which SHOULD always be the case in this 
     * version of telepathy-spec, this method does nothing and returns 
     * successfully, unless the given handle type or any of the given handles 
     * is invalid. In older connection managers, this method explicitly 
     * notifies the connection manager that your client is no longer holding 
     * any references to the given handles, and that they may be deallocated 
     * if they are not held by any other clients or referenced by any existing 
     * channels. See HoldHandles for notes.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param handleType
     *     
     *     An integer handle type (as defined in RequestHandle)
     *
     * \param handles
     *     
     *     An array of integer handles being held by the client
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> ReleaseHandles(uint handleType, const Tp::UIntList& handles, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ReleaseHandles"));
        callMessage << QVariant::fromValue(handleType) << QVariant::fromValue(handles);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestChannel on the remote object.
     * 
     * \htmlonly
     * <p>Request a channel satisfying the specified type and communicating
     *   with the contact, room, list etc. indicated by the given
     *   handle_type and handle. The handle_type and handle may both be
     *   zero to request the creation of a new, empty channel, which may
     *   or may not be possible, depending on the protocol and channel
     *   type.</p>
     * 
     * <p>On success, the returned channel will always be of the requested
     *   type (i.e. implement the requested channel-type interface).</p>
     * 
     * <p>If a new, empty channel is requested, on success the returned
     *   channel will always be an "anonymous" channel for which the type
     *   and handle are both zero.</p>
     * 
     * <p>If a channel to a contact, room etc. is requested, on success, the
     *   returned channel may either be a new or existing channel to
     *   the requested entity (i.e. its
     *    \endhtmlonly \link ChannelInterface::requestPropertyTargetHandleType() ChannelInterface::TargetHandleType \endlink \htmlonly 
     *   and  \endhtmlonly \link ChannelInterface::requestPropertyTargetHandle() ChannelInterface::TargetHandle \endlink \htmlonly 
     *   properties are the
     *   requested handle type and handle), or a newly created "anonymous"
     *   channel associated with the requested handle in some
     *   implementation-specific way.</p>
     * 
     * <p>For example, for a contact handle, the returned channel
     *   might be "anonymous", but implement the groups interface and have
     *   the requested contact already present among the members.</p>
     * 
     * <p>If the request cannot be satisfied, an error is raised and no
     *   channel is created.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param type
     *     
     *     A D-Bus interface name representing base channel type
     *
     * \param handleType
     *     
     *     An integer representing the handle type, or Handle_Type_None if no 
     *     handle is specified
     *
     * \param handle
     *     
     *     A nonzero integer handle representing a contact, room, list etc. 
     *     according to handle_type, or zero if the handle_type is 
     *     Handle_Type_None
     *
     * \param suppressHandler
     *     
     *     Clients SHOULD always set this to true. The historical meaning was 
     *     that clients that did not intend to take responsibility for 
     *     displaying the channel to the user could set this to FALSE, in 
     *     which case the channel dispatcher would launch an appropriate 
     *     channel handler. However, clients whose functionality relies on 
     *     having a working channel dispatcher should obtain that 
     *     functionality by calling methods on the channel dispatcher, so that 
     *     they will get an appropriate error if the channel dispatcher is 
     *     missing or not working. The channel dispatcher itself should set 
     *     this to true too, so that it will ignore the NewChannel signal that 
     *     results from the creation of the channel. It can then dispatch the 
     *     channel returned from this method to an appropriate handler. So, 
     *     there is no sensible use-case for setting this to false, and 
     *     setting it to false can result in unhandled channels (in the case 
     *     where clients assume that a channel dispatcher is present, but it 
     *     isn&apos;t).
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The D-Bus object path for the channel created or retrieved
     */
    inline QDBusPendingReply<QDBusObjectPath> RequestChannel(const QString& type, uint handleType, uint handle, bool suppressHandler, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusObjectPath>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestChannel"));
        callMessage << QVariant::fromValue(type) << QVariant::fromValue(handleType) << QVariant::fromValue(handle) << QVariant::fromValue(suppressHandler);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestHandles on the remote object.
     * 
     * \htmlonly
     * <p>Request several handles from the connection manager which represent a
     *   number of contacts, rooms or server-stored lists on the service.</p>
     * 
     * <p>If  \endhtmlonly \link requestPropertyHasImmortalHandles() HasImmortalHandles \endlink \htmlonly  is true,
     *   which SHOULD always be the case in this version of telepathy-spec,
     *   the handles remain valid until the connection disconnects.</p>
     * 
     * <p>The implementation of this method in older connection managers
     * must record that these handles are in use by the
     * client who invokes this method, and must not deallocate the handles
     * until the client disconnects from the bus or calls the
     *  \endhtmlonly ReleaseHandles() \htmlonly 
     * method. Where the identifier refers to an entity that already has a
     * handle in this connection manager, this handle should be returned
     * instead. The handle number 0 must not be returned by the connection
     * manager.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param handleType
     *     
     *     The type of handle required
     *
     * \param identifiers
     *     
     *     An array of identifiers of entities to request handles for
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of integer handle numbers in the same order as the given 
     *     identifiers.
     */
    inline QDBusPendingReply<Tp::UIntList> RequestHandles(uint handleType, const QStringList& identifiers, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::UIntList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestHandles"));
        callMessage << QVariant::fromValue(handleType) << QVariant::fromValue(identifiers);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AddClientInterest on the remote object.
     * 
     * \htmlonly
     * <p>Register a client's interest in notifications related to one or
     *   more interfaces.</p>
     * 
     * <p>Groups of notifications are identified by a token which is either
     *   a D-Bus interface name, or a string that starts with a D-Bus
     *   interface name. The meaning of each token is given by that D-Bus
     *   interface, which MUST define it in its documentation.</p>
     * 
     * <div class="rationale">
     *   <p>Initially, all interests are in entire interface, but allowing
     *     other strings allows subscription to part of an interface; for
     *     instance, an interest in ...MailNotification/count could track
     *     the number of messages without caring about their detailed
     *     content.</p>
     * </div>
     * 
     * <p>For each token with which this method interacts, the
     *   Connection tracks an "interest count" (like a reference count) for
     *   each unique bus name that has called this method. When a client
     *   calls this method, for each token, the interest count for its
     *   unique bus name is incremented; when
     *    \endhtmlonly RemoveClientInterest() \htmlonly  is called,
     *   all interest counts for that unique bus name are decremented.
     *   If the unique bus name leaves the bus (for instance, if the
     *   client crashes or exits), all interest counts for that unique bus
     *   name are set to zero.</p>
     * 
     * <p>The Connection can then use these reference counts to
     *   avoid subscribing to protocol-level notifications unless at least
     *   one client has a non-zero interest count for the relevant
     *   token.</p>
     * 
     * <div class="rationale">
     *   <p>This method exists to reduce memory and network overhead when
     *     there is no active subscription.</p>
     * 
     *   <p>One situation where this is useful is  \endhtmlonly ConnectionInterfaceLocationInterface \htmlonly : on XMPP, location updates are received
     *     over PEP. If the Connection advertises the
     *     <code>geoloc+notify</code> capability, it will be sent location
     *     updates for all contacts. To avoid consuming resources for this,
     *     the connection should avoid advertising that capability until
     *     a client has expressed an interest in contacts' locations.</p>
     * 
     *   <p>Another example of a protocol that benefits from this method is
     *     the Google XMPP Mail Notification extension, which can be used
     *     to implement  \endhtmlonly ConnectionInterfaceMailNotificationInterface \htmlonly . In this protocol, the CM
     *     receives a notification that something has changed, but to get
     *     more information, the CM must request this information. Knowing
     *     that nobody is currently interested in this information, the CM
     *     can avoid generating useless network traffic. Similarly, the CM
     *     may free the list of unread messages to reduce memory overhead.</p>
     * </div>
     * 
     * <p>If this method is called for an interface that might require
     *   protocol-level subscription, but the connection cannot set up
     *   that subscription yet (for instance because the
     *    \endhtmlonly \link requestPropertyStatus() Status \endlink \htmlonly  is not Connected yet), the
     *   Connection MUST remember the client's interest, and attempt to
     *   subscribe to the appropriate protocol feature when this becomes
     *   possible.</p>
     * 
     * <p>Clients MAY ignore any errors raised by this method; it is intended
     *   to be called with the reply ignored.</p>
     * 
     * <div class="rationale">
     *   <p>The only reason it could fail is if it's unimplemented, in which
     *     case the only thing the client can usefully do is to proceed as if
     *     it had succeeded.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param tokens
     *     
     *     \htmlonly
     *     <p>Interfaces or parts of interfaces in which to register an
     *       interest, represented by either a
     *       <tp:type>DBus_Interface</tp:type>, or a string prefixed with a
     *       <tp:type>DBus_Interface</tp:type>.</p>
     *     
     *     <p>If the Connection does not support one of these tokens, this
     *       is not considered to be an error; the unsupported token is
     *       simply ignored.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AddClientInterest(const QStringList& tokens, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AddClientInterest"));
        callMessage << QVariant::fromValue(tokens);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RemoveClientInterest on the remote object.
     * 
     * \htmlonly
     * <p>Release an interest registered using
     *    \endhtmlonly AddClientInterest() \htmlonly . See that
     *   method's documentation for details.</p>
     * 
     * <p>Clients MAY ignore any errors raised by this method; it is intended
     *   to be called with the reply ignored.</p>
     * 
     * <div class="rationale">
     *   <p>The only reasons it could fail are if it's unimplemented, or if
     *     the client's reference-counting is wrong and it has tried to
     *     remove a client interest that it did not add. In both cases,
     *     there's nothing the client could do about it.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param tokens
     *     
     *     \htmlonly
     *     <p>Interfaces or parts of interfaces that were previously passed to
     *        \endhtmlonly AddClientInterest() \htmlonly .</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RemoveClientInterest(const QStringList& tokens, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RemoveClientInterest"));
        callMessage << QVariant::fromValue(tokens);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c SelfHandleChanged on the remote object.
     * 
     * Emitted whenever the SelfHandle property changes. If the connection is 
     * not yet in the CONNECTED state, this signal is not guaranteed to be 
     * emitted.
     *
     * \param selfHandle
     *     
     *     The new value of the SelfHandle property.
     */
    void SelfHandleChanged(uint selfHandle);

    /**
     * Represents the signal \c SelfContactChanged on the remote object.
     * 
     * Emitted whenever the SelfHandle and SelfID property changes. If the 
     * connection is not yet in the CONNECTED state, this signal is not 
     * guaranteed to be emitted.
     *
     * \param selfHandle
     *     
     *     The new value of the SelfHandle property.
     *
     * \param selfID
     *     
     *     The new value of the SelfID property.
     */
    void SelfContactChanged(uint selfHandle, const QString& selfID);

    /**
     * Represents the signal \c NewChannel on the remote object.
     * 
     * Emitted when a new Channel object is created, either through user 
     * request or incoming information from the service.
     *
     * \param objectPath
     *     
     *     A D-Bus object path for the channel object on this service
     *
     * \param channelType
     *     
     *     A D-Bus interface name representing the channel type
     *
     * \param handleType
     *     
     *     An integer representing the type of handle this channel 
     *     communicates with, or Handle_Type_None if no handle is specified
     *
     * \param handle
     *     
     *     A handle indicating the specific contact, room or list this channel 
     *     communicates with, or zero if no handle is specified
     *
     * \param suppressHandler
     *     
     *     \htmlonly
     *     <p>If true, the channel was requested by a client that intends to
     *       present it to the user itself (i.e. it passed suppress_handler=TRUE
     *       to the  \endhtmlonly RequestChannel() \htmlonly  method), so no
     *       other handler should be
     *       launched. Clients MAY assume that channels where this is true
     *       were created by a user request.</p>
     *     
     *     <p>If false, either the channel was created due to incoming
     *       information from the service, or the channel was requested by
     *       a local client that does not intend to handle the channel itself
     *       (this usage is deprecated).</p>
     *     
     *     <p>Clients MUST NOT assume that only incoming channels will have
     *       this flag set to false.</p>
     *     \endhtmlonly
     */
    void NewChannel(const QDBusObjectPath& objectPath, const QString& channelType, uint handleType, uint handle, bool suppressHandler);

    /**
     * Represents the signal \c ConnectionError on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when an error occurs that renders this connection unusable.
     * </p>
     * 
     * <p>Whenever this signal is emitted, it MUST immediately be followed by
     *   a  \endhtmlonly StatusChanged() \htmlonly  signal with status
     *   Connection_Status_Disconnected and an appropriate reason
     *   code.</p>
     * 
     * <p>Connection managers SHOULD emit this signal on disconnection, but
     *   need not do so. Clients MUST support connection managers that emit
     *   StatusChanged(Disconnected, ...) without first emitting
     *   ConnectionError.</p>
     * 
     * <div class="rationale">
     *   <p>This signal provides additional information about the reason
     *     for disconnection. The reason for connection is always
     *     straightforward - it was requested - so it does not need further
     *     explanation. However, on errors, it can be useful to provide
     *     additional information.</p>
     * 
     *   <p>The <tp:type>Connection_Status_Reason</tp:type> is not given
     *     here, since it will be signalled in
     *      \endhtmlonly StatusChanged() \htmlonly . A reasonable client
     *     implementation would be to store the information given by this
     *     signal until StatusChanged is received, at which point the
     *     information given by this signal can be used to supplement the
     *     StatusChanged signal.</p>
     * </div>
     * \endhtmlonly
     *
     * \param error
     *     
     *     The name of a D-Bus error describing the error that occurred, which 
     *     may correspond to a Connection_Status_Reason, or may be a more 
     *     specific Telepathy error (such as 
     *     org.freedesktop.Telepathy.Error.ConnectionRefused for 
     *     Connection_Status_Reason_Network_Error) or a protocol-specific or 
     *     connection-manager-specific error in a suitable namespace. For 
     *     instance, a SIP connection manager could signal &quot;402 Payment 
     *     Required&quot; as an error in a connection-manager-specific 
     *     namespace, or a link-local XMPP implementation that used Avahi 
     *     could provide the error given to it by the avahi-daemon.
     *
     * \param details
     *     
     *     \htmlonly
     *               <p>Additional information about the error, which may include
     *                 the following well-known keys:</p>
     *     
     *               <dl>
     *                 <dt>debug-message (s)</dt>
     *                 <dd>Debugging information on the change, corresponding to the
     *                   message part of a D-Bus error message, which SHOULD NOT be
     *                   displayed to users under normal circumstances</dd>
     *     
     *                 <dt>server-message (s)</dt>
     *                 <dd>A human-readable message from the server explaining what
     *                   happened. This may be in the user's native language, or in the
     *                   server operator's native language, or even in Lojban.</dd>
     *     
     *     	    <dt>user-requested (b), expected-hostname (s), certificate-hostname (s)</dt>
     *     	    <dd>The same details defined in <tp:type>TLS_Certificate_Rejection</tp:type>.</dd>
     *               </dl>
     *     \endhtmlonly
     */
    void ConnectionError(const QString& error, const QVariantMap& details);

    /**
     * Represents the signal \c StatusChanged on the remote object.
     * 
     * Emitted when the status of the connection changes. All states and 
     * reasons have numerical values, as defined in ConnectionStatus and 
     * ConnectionStatusReason.
     *
     * \param status
     *     
     *     An integer indicating the new status, as defined by ConnectionStatus
     *
     * \param reason
     *     
     *     An integer indicating the reason for the status change, as defined 
     *     by ConnectionStatusReason
     */
    void StatusChanged(uint status, uint reason);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceAddressingInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Addressing1".
 */
class TP_QT_EXPORT ConnectionInterfaceAddressingInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.Addressing1", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Addressing1");
    }

    /**
     * Creates a ConnectionInterfaceAddressingInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAddressingInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceAddressingInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAddressingInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceAddressingInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceAddressingInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceAddressingInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceAddressingInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceAddressingInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAddressingInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetContactsByVCardField on the remote object.
     * 
     * \htmlonly
     * <p>Request contacts and retrieve their attributes using a given field
     *   in their vCards.</p>
     * 
     * <p>The connection manager should record that these handles are in
     *   use by the client who invokes this method, and must not
     *   deallocate the handles until the client disconnects from the
     *   bus or calls the
     *    \endhtmlonly ConnectionInterface::ReleaseHandles() \htmlonly 
     *   method.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param field
     *     
     *     \htmlonly
     *     <p>The vCard field of the addresses we are requesting. The
     *       field name SHOULD be in lower case. Supported
     *       fields can be found in
     *        \endhtmlonly \link ProtocolInterfaceAddressingInterface::requestPropertyAddressableVCardFields() ProtocolInterfaceAddressingInterface::AddressableVCardFields \endlink \htmlonly .</p>
     *     
     *     <p>The <code>url</code> vCard field MUST NOT appear here; see
     *        \endhtmlonly GetContactsByURI() \htmlonly  instead.</p>
     *     
     *     <div class="rationale">
     *       <p>In practice, protocols have a limited set of URI
     *         schemes that make sense to resolve as a contact.</p>
     *     </div>
     *     \endhtmlonly
     *
     * \param addresses
     *     
     *     The addresses to get contact handles for. The address types should 
     *     match the given vCard field.
     *
     * \param interfaces
     *     
     *     \htmlonly
     *     <p>A list of strings indicating which D-Bus interfaces the calling
     *       process is interested in. All supported attributes from these
     *       interfaces, whose values can be obtained without additional network
     *       activity, will be in the reply.</p>
     *     
     *     <p>Attributes from this interface and from
     *        \endhtmlonly ConnectionInterface \htmlonly 
     *       are always returned, and need not be requested
     *       explicitly.</p>
     *     
     *     <p>The behavior of this parameter is similar to the same
     *       parameter in
     *        \endhtmlonly ConnectionInterfaceContactsInterface::GetContactAttributes() \htmlonly .</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>A mapping from requested vCard addresses to the corresponding
     *       contact handles.</p>
     *     
     *     <p>Requested addresses that are not valid or understood for this protocol
     *       MUST be omitted from the mapping.</p>
     *     \endhtmlonly
     *
     * \return
     *     
     *     \htmlonly
     *     <p>A dictionary mapping the contact handles to contact attributes.
     *       If any of the requested addresses are in fact invalid, they are
     *       simply omitted from this mapping. If contact attributes are not
     *       immediately known, the behaviour is defined by the interface;
     *       the attribute should either be omitted from the result or
     *       replaced with a default value.</p>
     *     
     *     <p>Requested addresses that are not valid or understood for this protocol
     *       MUST be omitted from the mapping.</p>
     *     
     *     <p>Each contact's attributes will always include at least the
     *       identifier that would be obtained by inspecting the handle
     *       (<code>org.freedesktop.Telepathy.Connection/contact-id</code>).
     *     </p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::AddressingNormalizationMap, Tp::ContactAttributesMap> GetContactsByVCardField(const QString& field, const QStringList& addresses, const QStringList& interfaces, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::AddressingNormalizationMap, Tp::ContactAttributesMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetContactsByVCardField"));
        callMessage << QVariant::fromValue(field) << QVariant::fromValue(addresses) << QVariant::fromValue(interfaces);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetContactsByURI on the remote object.
     * 
     * \htmlonly
     * <p>Request contacts and retrieve their attributes using URI addresses.</p>
     * 
     * <p>The connection manager should record that these handles are in
     *   use by the client who invokes this method, and must not
     *   deallocate the handles until the client disconnects from the
     *   bus or calls the
     *    \endhtmlonly ConnectionInterface::ReleaseHandles() \htmlonly 
     *   method.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param URIs
     *     
     *     The URI addresses to get contact handles for. Supported schemes can 
     *     be found in AddressableURISchemes.
     *
     * \param interfaces
     *     
     *     \htmlonly
     *     <p>A list of strings indicating which D-Bus interfaces the calling
     *       process is interested in. All supported attributes from these
     *       interfaces, whose values can be obtained without additional network
     *       activity, will be in the reply.</p>
     *     
     *     <p>Attributes from this interface and from
     *        \endhtmlonly ConnectionInterface \htmlonly 
     *       are always returned, and need not be requested
     *       explicitly.</p>
     *     
     *     <p>The behavior of this parameter is similar to the same
     *       parameter in
     *        \endhtmlonly ConnectionInterfaceContactsInterface::GetContactAttributes() \htmlonly .</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>A mapping of requested URIs to the corresponding contact handles.</p>
     *     
     *     <p>Requested URIs that are not valid or understood for this protocol
     *       MUST be omitted from the mapping.</p>
     *     \endhtmlonly
     *
     * \return
     *     
     *     \htmlonly
     *     <p>A dictionary mapping the contact handles to contact attributes.
     *       If any of the requested addresses are in fact invalid, they are
     *       simply omitted from this mapping. If contact attributes are not
     *       immediately known, the behaviour is defined by the interface;
     *       the attribute should either be omitted from the result or
     *       replaced with a default value.</p>
     *     
     *     <p>Requested URIs that are not valid or understood for this protocol
     *       MUST be omitted from the mapping.</p>
     *     
     *     <p>Each contact's attributes will always include at least the
     *       identifier that would be obtained by inspecting the handle
     *       (<code>org.freedesktop.Telepathy.Connection/contact-id</code>).
     *     </p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::AddressingNormalizationMap, Tp::ContactAttributesMap> GetContactsByURI(const QStringList& URIs, const QStringList& interfaces, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::AddressingNormalizationMap, Tp::ContactAttributesMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetContactsByURI"));
        callMessage << QVariant::fromValue(URIs) << QVariant::fromValue(interfaces);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceAliasingInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Aliasing".
 */
class TP_QT_EXPORT ConnectionInterfaceAliasingInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.Aliasing", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Aliasing");
    }

    /**
     * Creates a ConnectionInterfaceAliasingInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAliasingInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceAliasingInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAliasingInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceAliasingInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceAliasingInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceAliasingInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceAliasingInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceAliasingInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAliasingInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetAliasFlags on the remote object.
     * 
     * Return a bitwise OR of flags detailing the behaviour of aliases on this 
     * connection.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An integer with a bitwise OR of flags from ConnectionAliasFlags
     */
    inline QDBusPendingReply<uint> GetAliasFlags(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetAliasFlags"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestAliases on the remote object.
     * 
     * Request the value of several contacts&apos; aliases at once.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     An array of handles representing contacts
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A list of aliases in the same order as the contact handles
     */
    inline QDBusPendingReply<QStringList> RequestAliases(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QStringList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestAliases"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetAliases on the remote object.
     * 
     * Request the value of several contacts&apos; aliases at once. This 
     * SHOULD only return cached aliases, falling back on the contact 
     * identifier (i.e. the string corresponding to the handle) if none is 
     * present. Also if there was no cached alias, a request SHOULD be started 
     * of which the result is later signalled by AliasesChanged.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     An array of handles representing contacts
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A dictionary mapping contact handles to aliases
     */
    inline QDBusPendingReply<Tp::AliasMap> GetAliases(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::AliasMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetAliases"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetAliases on the remote object.
     * 
     * Request that the alias of the given contact be changed. Success will be 
     * indicated by emitting an AliasesChanged signal. On connections where 
     * the CONNECTION_ALIAS_FLAG_USER_SET flag is not set, this method will 
     * only ever succeed if the contact is the user&apos;s own handle (as 
     * returned by Connection.GetSelfHandle).
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param aliases
     *     
     *     A dictionary mapping integer handles of contacts to strings of the 
     *     new alias to set.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetAliases(const Tp::AliasMap& aliases, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetAliases"));
        callMessage << QVariant::fromValue(aliases);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c AliasesChanged on the remote object.
     * 
     * Signal emitted when a contact&apos;s alias (or that of the user) is 
     * changed.
     *
     * \param aliases
     *     
     *     \htmlonly
     *     An array containing structs of:
     *     <ul>
     *       <li>the handle representing the contact</li>
     *       <li>the new alias</li>
     *     </ul>
     *     \endhtmlonly
     */
    void AliasesChanged(const Tp::AliasPairList& aliases);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceAnonymityInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Anonymity".
 */
class TP_QT_EXPORT ConnectionInterfaceAnonymityInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.Anonymity", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Anonymity");
    }

    /**
     * Creates a ConnectionInterfaceAnonymityInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAnonymityInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceAnonymityInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAnonymityInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceAnonymityInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceAnonymityInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceAnonymityInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceAnonymityInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceAnonymityInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAnonymityInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c SupportedAnonymityModes of type \c uint.
     *
     * 
     * The anonymity modes supported by the CM for this connection. Once 
     * Connection.Status has moved to Connected, this property MUST NOT change.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySupportedAnonymityModes() const
    {
        return internalRequestProperty(QLatin1String("SupportedAnonymityModes"));
    }

    /**
     * Asynchronous getter for the remote object property \c AnonymityMandatory of type \c bool.
     *
     * 
     * This specifies whether or not the anonymity settings MUST be respected 
     * by the CM and any intermediaries between the local and remote contacts. 
     * If this is set to true but anonymity settings cannot be followed, then 
     * the session MUST be denied with a 
     * org.freedesktop.Telepathy.Error.WouldBreakAnonymity error. Any client 
     * that sets AnonymityModes SHOULD also set this property first (rather 
     * than accepting the CM&apos;s default value).
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAnonymityMandatory() const
    {
        return internalRequestProperty(QLatin1String("AnonymityMandatory"));
    }

    /**
     * Asynchronous setter for the remote object property \c AnonymityMandatory of type \c bool.
     *
     * 
     * This specifies whether or not the anonymity settings MUST be respected 
     * by the CM and any intermediaries between the local and remote contacts. 
     * If this is set to true but anonymity settings cannot be followed, then 
     * the session MUST be denied with a 
     * org.freedesktop.Telepathy.Error.WouldBreakAnonymity error. Any client 
     * that sets AnonymityModes SHOULD also set this property first (rather 
     * than accepting the CM&apos;s default value).
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyAnonymityMandatory(bool newValue)
    {
        return internalSetProperty(QLatin1String("AnonymityMandatory"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c AnonymityModes of type \c uint.
     *
     * 
     * The currently enabled anonymity modes for the connection. Setting has 
     * the effect of requesting new modes for the connection, and may raise an 
     * error if the unsupported modes are set. Successfully changing the modes 
     * will result in emission of AnonymityModesChanged signal.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAnonymityModes() const
    {
        return internalRequestProperty(QLatin1String("AnonymityModes"));
    }

    /**
     * Asynchronous setter for the remote object property \c AnonymityModes of type \c uint.
     *
     * 
     * The currently enabled anonymity modes for the connection. Setting has 
     * the effect of requesting new modes for the connection, and may raise an 
     * error if the unsupported modes are set. Successfully changing the modes 
     * will result in emission of AnonymityModesChanged signal.
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyAnonymityModes(uint newValue)
    {
        return internalSetProperty(QLatin1String("AnonymityModes"), QVariant::fromValue(newValue));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

Q_SIGNALS:
    /**
     * Represents the signal \c AnonymityModesChanged on the remote object.
     * 
     * Emitted when the anonymity mode has changed.
     *
     * \param modes
     *     
     *     The new anonymity modes for this connection.
     */
    void AnonymityModesChanged(uint modes);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceAvatarsInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Avatars".
 */
class TP_QT_EXPORT ConnectionInterfaceAvatarsInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.Avatars", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Avatars");
    }

    /**
     * Creates a ConnectionInterfaceAvatarsInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAvatarsInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceAvatarsInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAvatarsInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceAvatarsInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceAvatarsInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceAvatarsInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceAvatarsInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceAvatarsInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceAvatarsInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c SupportedAvatarMIMETypes of type \c QStringList.
     *
     * 
     * An array of supported MIME types (e.g. &quot;image/jpeg&quot;). Clients 
     * MAY assume that the first type in this array is preferred. This 
     * property cannot change after the Connection goes to the Connected state.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySupportedAvatarMIMETypes() const
    {
        return internalRequestProperty(QLatin1String("SupportedAvatarMIMETypes"));
    }

    /**
     * Asynchronous getter for the remote object property \c MinimumAvatarHeight of type \c uint.
     *
     * 
     * The minimum height in pixels of an avatar on this protocol, which MAY 
     * be 0. This property cannot change after the Connection goes to the 
     * Connected state.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMinimumAvatarHeight() const
    {
        return internalRequestProperty(QLatin1String("MinimumAvatarHeight"));
    }

    /**
     * Asynchronous getter for the remote object property \c MinimumAvatarWidth of type \c uint.
     *
     * 
     * The minimum width in pixels of an avatar on this protocol, which MAY be 
     * 0. This property cannot change after the Connection goes to the 
     * Connected state.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMinimumAvatarWidth() const
    {
        return internalRequestProperty(QLatin1String("MinimumAvatarWidth"));
    }

    /**
     * Asynchronous getter for the remote object property \c RecommendedAvatarHeight of type \c uint.
     *
     * 
     * The recommended height in pixels of an avatar on this protocol, or 0 if 
     * there is no preferred height. This property cannot change after the 
     * Connection goes to the Connected state. In XMPP a recommended width is 
     * given by the protocol specification; in proprietary protocols, using 
     * the same avatar size as the proprietary client is likely to lead to the 
     * best display to other users.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRecommendedAvatarHeight() const
    {
        return internalRequestProperty(QLatin1String("RecommendedAvatarHeight"));
    }

    /**
     * Asynchronous getter for the remote object property \c RecommendedAvatarWidth of type \c uint.
     *
     * 
     * The recommended width in pixels of an avatar on this protocol, or 0 if 
     * there is no preferred width. This property cannot change after the 
     * Connection goes to the Connected state. The rationale is the same as 
     * for RecommendedAvatarHeight.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRecommendedAvatarWidth() const
    {
        return internalRequestProperty(QLatin1String("RecommendedAvatarWidth"));
    }

    /**
     * Asynchronous getter for the remote object property \c MaximumAvatarHeight of type \c uint.
     *
     * 
     * The maximum height in pixels of an avatar on this protocol, or 0 if 
     * there is no limit. This property cannot change after the Connection 
     * goes to the Connected state.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMaximumAvatarHeight() const
    {
        return internalRequestProperty(QLatin1String("MaximumAvatarHeight"));
    }

    /**
     * Asynchronous getter for the remote object property \c MaximumAvatarWidth of type \c uint.
     *
     * 
     * The maximum width in pixels of an avatar on this protocol, or 0 if 
     * there is no limit. This property cannot change after the Connection 
     * goes to the Connected state.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMaximumAvatarWidth() const
    {
        return internalRequestProperty(QLatin1String("MaximumAvatarWidth"));
    }

    /**
     * Asynchronous getter for the remote object property \c MaximumAvatarBytes of type \c uint.
     *
     * 
     * The maximum size in bytes of an avatar on this protocol, or 0 if there 
     * is no limit. This property cannot change after the Connection goes to 
     * the Connected state.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMaximumAvatarBytes() const
    {
        return internalRequestProperty(QLatin1String("MaximumAvatarBytes"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetAvatarRequirements on the remote object.
     * 
     * Get the required format of avatars on this connection.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of supported MIME types (eg image/jpeg)
     *
     * \return
     *     
     *     The minimum image width in pixels
     *
     * \return
     *     
     *     The minimum image height in pixels
     *
     * \return
     *     
     *     The maximum image width in pixels, or 0 if there is no limit
     *
     * \return
     *     
     *     The maximum image height in pixels, or 0 if there is no limit
     *
     * \return
     *     
     *     The maximum image size in bytes, or 0 if there is no limit
     */
    inline QDBusPendingReply<QStringList, ushort, ushort, ushort, ushort, uint> GetAvatarRequirements(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QStringList, ushort, ushort, ushort, ushort, uint>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetAvatarRequirements"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetAvatarTokens on the remote object.
     * 
     * Get the unique tokens for all of the given contacts&apos; avatars. 
     * Using this method in new Telepathy clients is deprecated; use 
     * GetKnownAvatarTokens instead.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     An array of handles representing contacts
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of avatar tokens or empty strings (if no avatar is set) in 
     *     the same order as the given array of contact handles
     */
    inline QDBusPendingReply<QStringList> GetAvatarTokens(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QStringList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetAvatarTokens"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetKnownAvatarTokens on the remote object.
     * 
     * Get the unique tokens for the given contacts&apos; avatars. These 
     * tokens can be persisted across connections, and should be used by the 
     * client to check whether the avatars have been updated. For handles 
     * other than the self handle, only tokens that are already known are 
     * returned; an empty token means the given contact has no avatar. 
     * However, a CM must always have the tokens for the self handle if one is 
     * set (even if it is set to no avatar). On protocols where the avatar 
     * does not persist between connections, a CM should omit the self handle 
     * from the returned map until an avatar is explicitly set or cleared.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     An array of handles representing contacts
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A dictionary of handles mapped to avatar tokens, containing only 
     *     the known avatar tokens.
     */
    inline QDBusPendingReply<Tp::AvatarTokenMap> GetKnownAvatarTokens(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::AvatarTokenMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetKnownAvatarTokens"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestAvatar on the remote object.
     * 
     * Request the avatar for a given contact. Using this method in new 
     * Telepathy clients is deprecated; use RequestAvatars instead.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contact
     *     
     *     An integer handle for the contact to request the avatar for
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of bytes containing the image data
     *
     * \return
     *     
     *     A string containing the image MIME type (eg image/jpeg), or empty 
     *     if unknown
     */
    inline QDBusPendingReply<QByteArray, QString> RequestAvatar(uint contact, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QByteArray, QString>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestAvatar"));
        callMessage << QVariant::fromValue(contact);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestAvatars on the remote object.
     * 
     * Request avatars for a number of contacts. The AvatarRetrieved signal is 
     * emitted for each avatar retrieved. If the handles are valid but 
     * retrieving an avatar fails (for any reason, including the contact not 
     * having an avatar) the AvatarRetrieved signal is not emitted for that 
     * contact.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     The contacts to retrieve avatars for
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RequestAvatars(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestAvatars"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetAvatar on the remote object.
     * 
     * Set a new avatar image for this connection. The avatar image must 
     * respect the requirements obtained by GetAvatarRequirements.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param avatar
     *     
     *     An array of bytes representing the avatar image data
     *
     * \param MIMEType
     *     
     *     A string representing the image MIME type
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The string token of the new avatar
     */
    inline QDBusPendingReply<QString> SetAvatar(const QByteArray& avatar, const QString& MIMEType, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QString>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetAvatar"));
        callMessage << QVariant::fromValue(avatar) << QVariant::fromValue(MIMEType);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ClearAvatar on the remote object.
     * 
     * Remove the avatar image for this connection.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> ClearAvatar(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ClearAvatar"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c AvatarUpdated on the remote object.
     * 
     * Emitted when the avatar for a contact has been updated, or first 
     * discovered on this connection. If the token differs from the token 
     * associated with the client&apos;s cached avatar for this contact, the 
     * new avatar should be requested with RequestAvatars.
     *
     * \param contact
     *     
     *     An integer handle for the contact whose avatar has changed
     *
     * \param newAvatarToken
     *     
     *     Unique token for their new avatar
     */
    void AvatarUpdated(uint contact, const QString& newAvatarToken);

    /**
     * Represents the signal \c AvatarRetrieved on the remote object.
     * 
     * Emitted when the avatar for a contact has been retrieved.
     *
     * \param contact
     *     
     *     The contact whose avatar has been retrieved
     *
     * \param token
     *     
     *     The token corresponding to the avatar
     *
     * \param avatar
     *     
     *     An array of bytes containing the image data
     *
     * \param type
     *     
     *     A string containing the image MIME type (eg image/jpeg), or empty 
     *     if unknown
     */
    void AvatarRetrieved(uint contact, const QString& token, const QByteArray& avatar, const QString& type);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceBalanceInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Balance".
 */
class TP_QT_EXPORT ConnectionInterfaceBalanceInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.Balance", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Balance");
    }

    /**
     * Creates a ConnectionInterfaceBalanceInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceBalanceInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceBalanceInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceBalanceInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceBalanceInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceBalanceInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceBalanceInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceBalanceInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceBalanceInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceBalanceInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c AccountBalance of type \c Tp::CurrencyAmount.
     *
     * 
     * \htmlonly
     * <p>The user's balance on the account corresponding to this  \endhtmlonly ConnectionInterface \htmlonly .
     *   A negative amount may be possible on some services, and indicates
     *   that the user owes money to the service provider.</p>
     * 
     * <p>On initial connection, this property may have an unknown
     *   value, represented by <var>Amount</var> = <tt>0</tt>,
     *   <var>Scale</var> = <tt>2**32 - 1</tt> (the largest possible 32-bit
     *   unsigned integer) and <var>Currency</var> = <tt>""</tt>.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAccountBalance() const
    {
        return internalRequestProperty(QLatin1String("AccountBalance"));
    }

    /**
     * Asynchronous getter for the remote object property \c ManageCreditURI of type \c QString.
     *
     * 
     * A URI the user may visit via the web browser to manage and top-up their 
     * account balance. This property is not guaranteed to be well-defined 
     * until the connection becomes Connected; there is no change 
     * notification. Different protocols and even servers or gateways (e.g. 
     * SIP and XMPP PSTN gateways) will have a different website used to 
     * manage a user&apos;s account balance. This property enables the client 
     * to provide that to the user. A Connection Manager MAY set this itself 
     * (because it is static or discoverable), or expose it as a connection 
     * parameter.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyManageCreditURI() const
    {
        return internalRequestProperty(QLatin1String("ManageCreditURI"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

Q_SIGNALS:
    /**
     * Represents the signal \c BalanceChanged on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when the user's balance has changed.</p>
     * \endhtmlonly
     *
     * \param balance
     *     
     *     \htmlonly
     *     <p>The new value of the  \endhtmlonly \link requestPropertyAccountBalance() AccountBalance \endlink \htmlonly 
     *       property.</p>
     *     \endhtmlonly
     */
    void BalanceChanged(const Tp::CurrencyAmount& balance);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceCapabilitiesInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Capabilities".
 */
class TP_QT_EXPORT ConnectionInterfaceCapabilitiesInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.Capabilities", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Capabilities");
    }

    /**
     * Creates a ConnectionInterfaceCapabilitiesInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceCapabilitiesInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceCapabilitiesInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceCapabilitiesInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceCapabilitiesInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceCapabilitiesInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceCapabilitiesInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceCapabilitiesInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceCapabilitiesInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceCapabilitiesInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c AdvertiseCapabilities on the remote object.
     * 
     * \htmlonly
     * <p>Used by user interfaces to indicate which channel types they are able
     * to handle on this connection. Because these may be provided by
     * different client processes, this method accepts channel types to add
     * and remove from the set already advertised on this connection. The type
     * of advertised capabilities (create versus invite) is protocol-dependent
     * and hence cannot be set by the this method. In the case of a client
     * adding an already advertised channel type but with new channel type
     * specific flags, the connection manager should simply add the new flags
     * to the set of advertised capabilities.</p>
     * 
     * <p>Upon a successful invocation of this method, the
     *  \endhtmlonly CapabilitiesChanged() \htmlonly 
     * signal will be emitted for the user's own handle (  \endhtmlonly ConnectionInterface::GetSelfHandle() \htmlonly )
     * by the connection manager to indicate the changes
     * that have been made.  This signal should also be monitored to ensure
     * that the set is kept accurate - for example, a client may remove
     * capabilities or type specific capability flags when it exits
     * which are still provided by another client.</p>
     * 
     * <p>On connections managed by the  \endhtmlonly ChannelDispatcherInterface \htmlonly ,
     *   this method SHOULD NOT be used by clients other than the
     *   ChannelDispatcher itself.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param add
     *     
     *     \htmlonly
     *     An array of structures containing:
     *     <ul>
     *       <li>a string channel type</li>
     *       <li>a bitwise OR of type specific capability flags</li>
     *     </ul>
     *     \endhtmlonly
     *
     * \param remove
     *     
     *     An array of D-Bus interface names of channel types to remove
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of structures describing the current capabilities 
     *     containing: a string channel type a bitwise OR of type specific 
     *     capability flags
     */
    inline QDBusPendingReply<Tp::CapabilityPairList> AdvertiseCapabilities(const Tp::CapabilityPairList& add, const QStringList& remove, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::CapabilityPairList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AdvertiseCapabilities"));
        callMessage << QVariant::fromValue(add) << QVariant::fromValue(remove);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetCapabilities on the remote object.
     * 
     * Returns an array of capabilities for the given contact handles.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param handles
     *     
     *     \htmlonly
     *     <p>An array of contact handles for this connection.</p>
     *     
     *     <p>This may include zero, which originally meant a query for
     *       capabilities available on the connection itself. This usage
     *       is deprecated; clients SHOULD NOT do this, and connection managers
     *       SHOULD proceed as though zero had not been present in this
     *       list.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     An array of structures containing:
     *     <ul>
     *       <li>an integer handle representing the contact</li>
     *       <li>a string channel type</li>
     *       <li>a bitwise OR of generic capability flags for the type</li>
     *       <li>a bitwise OR of type specific capability flags for the type</li>
     *     </ul>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::ContactCapabilityList> GetCapabilities(const Tp::UIntList& handles, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ContactCapabilityList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetCapabilities"));
        callMessage << QVariant::fromValue(handles);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c CapabilitiesChanged on the remote object.
     * 
     * \htmlonly
     * <p>Announce that there has been a change of capabilities on the
     *   given handle.</p>
     * 
     * <p>If the handle is zero, the capabilities refer to the connection
     *   itself, in some poorly defined way. This usage is deprecated and
     *   clients should ignore it.</p>
     * \endhtmlonly
     *
     * \param caps
     *     
     *     \htmlonly
     *     An array of structures containing:
     *     <ul>
     *       <li>an integer handle representing the contact</li>
     *       <li>a string channel type</li>
     *       <li>a bitwise OR of the contact's old generic capability flags</li>
     *       <li>a bitwise OR of the contact's new generic capability flags</li>
     *       <li>a bitwise OR of the contact's old type specific capability flags</li>
     *       <li>a bitwise OR of the contact's new type specific capability flags</li>
     *     </ul>
     *     \endhtmlonly
     */
    void CapabilitiesChanged(const Tp::CapabilityChangeList& caps);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceCellularInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Cellular".
 */
class TP_QT_EXPORT ConnectionInterfaceCellularInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.Cellular", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Cellular");
    }

    /**
     * Creates a ConnectionInterfaceCellularInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceCellularInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceCellularInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceCellularInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceCellularInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceCellularInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceCellularInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceCellularInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceCellularInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceCellularInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c MessageValidityPeriod of type \c uint.
     *
     * 
     * \htmlonly
     * <p>Define how long should the service centre try message delivery before
     *   giving up, failing delivery and deleting the message. A value of 0
     *   means to use the service centre's default period.</p>
     * 
     * <p>The value specified is in seconds. Note that various protocols or
     *   implementations may round the value up (eg. to a minute or hour
     *   precision). The maximum validity period may vary depending on
     *   protocol or provider.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMessageValidityPeriod() const
    {
        return internalRequestProperty(QLatin1String("MessageValidityPeriod"));
    }

    /**
     * Asynchronous setter for the remote object property \c MessageValidityPeriod of type \c uint.
     *
     * 
     * \htmlonly
     * <p>Define how long should the service centre try message delivery before
     *   giving up, failing delivery and deleting the message. A value of 0
     *   means to use the service centre's default period.</p>
     * 
     * <p>The value specified is in seconds. Note that various protocols or
     *   implementations may round the value up (eg. to a minute or hour
     *   precision). The maximum validity period may vary depending on
     *   protocol or provider.</p>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyMessageValidityPeriod(uint newValue)
    {
        return internalSetProperty(QLatin1String("MessageValidityPeriod"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c OverrideMessageServiceCentre of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If <code>True</code>, SMSes will be sent via the service centre
     *   specified by  \endhtmlonly \link requestPropertyMessageServiceCentre() MessageServiceCentre \endlink \htmlonly . If
     *   <code>False</code>, the SIM's default SMSC will be used, ignoring the
     *   value of MessageServiceCentre.</p>
     * 
     * <div class="rationale">
     *   <p>It could be desirable for a configuration interface to remember
     *     the user's previous choice of custom SMSC, even if it's not in use.
     *     This boolean allows that choice to be saved as an account parameter
     *     by Mission Control, rather than the UI needing to save it elsewhere
     *     to be restored if the user wants to reactivate it.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyOverrideMessageServiceCentre() const
    {
        return internalRequestProperty(QLatin1String("OverrideMessageServiceCentre"));
    }

    /**
     * Asynchronous setter for the remote object property \c OverrideMessageServiceCentre of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If <code>True</code>, SMSes will be sent via the service centre
     *   specified by  \endhtmlonly \link requestPropertyMessageServiceCentre() MessageServiceCentre \endlink \htmlonly . If
     *   <code>False</code>, the SIM's default SMSC will be used, ignoring the
     *   value of MessageServiceCentre.</p>
     * 
     * <div class="rationale">
     *   <p>It could be desirable for a configuration interface to remember
     *     the user's previous choice of custom SMSC, even if it's not in use.
     *     This boolean allows that choice to be saved as an account parameter
     *     by Mission Control, rather than the UI needing to save it elsewhere
     *     to be restored if the user wants to reactivate it.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyOverrideMessageServiceCentre(bool newValue)
    {
        return internalSetProperty(QLatin1String("OverrideMessageServiceCentre"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c MessageServiceCentre of type \c QString.
     *
     * 
     * \htmlonly
     * <p>Address for the messaging service centre. Typically (as is the case
     *   for GSM's SMSC), it's the ISDN / telephony address (ie. a phone
     *   number). If
     *    \endhtmlonly \link requestPropertyOverrideMessageServiceCentre() OverrideMessageServiceCentre \endlink \htmlonly  is
     *   <code>False</code>, this property's value should be ignored by the CM
     *   in favour of the SIM's default SMSC.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMessageServiceCentre() const
    {
        return internalRequestProperty(QLatin1String("MessageServiceCentre"));
    }

    /**
     * Asynchronous setter for the remote object property \c MessageServiceCentre of type \c QString.
     *
     * 
     * \htmlonly
     * <p>Address for the messaging service centre. Typically (as is the case
     *   for GSM's SMSC), it's the ISDN / telephony address (ie. a phone
     *   number). If
     *    \endhtmlonly \link requestPropertyOverrideMessageServiceCentre() OverrideMessageServiceCentre \endlink \htmlonly  is
     *   <code>False</code>, this property's value should be ignored by the CM
     *   in favour of the SIM's default SMSC.</p>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyMessageServiceCentre(QString newValue)
    {
        return internalSetProperty(QLatin1String("MessageServiceCentre"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c IMSI of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The International Mobile Subscriber Identifier, if it exists. This
     *   would originate from a SIM card.  If the IMSI is unknown, this will
     *   contain an empty string ("").</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyIMSI() const
    {
        return internalRequestProperty(QLatin1String("IMSI"));
    }

    /**
     * Asynchronous getter for the remote object property \c MessageReducedCharacterSet of type \c bool.
     *
     * 
     * \htmlonly
     * <p>Determines how to encode SMSes containing characters that do not
     *   fit into a non-Unicode character set.
     *   If <code>False</code> (which SHOULD be the default), messages will
     *   be encoded as UCS-2 and sent with no loss of fidelity (at the
     *   potential financial cost of using twice as many SMSes); if
     *   <code>True</code>, the message will be recoded in an
     *   implementation‐specific way to fit into a GSM reduced character
     *   set.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMessageReducedCharacterSet() const
    {
        return internalRequestProperty(QLatin1String("MessageReducedCharacterSet"));
    }

    /**
     * Asynchronous setter for the remote object property \c MessageReducedCharacterSet of type \c bool.
     *
     * 
     * \htmlonly
     * <p>Determines how to encode SMSes containing characters that do not
     *   fit into a non-Unicode character set.
     *   If <code>False</code> (which SHOULD be the default), messages will
     *   be encoded as UCS-2 and sent with no loss of fidelity (at the
     *   potential financial cost of using twice as many SMSes); if
     *   <code>True</code>, the message will be recoded in an
     *   implementation‐specific way to fit into a GSM reduced character
     *   set.</p>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyMessageReducedCharacterSet(bool newValue)
    {
        return internalSetProperty(QLatin1String("MessageReducedCharacterSet"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c MessageNationalCharacterSet of type \c QString.
     *
     * 
     * \htmlonly
     * <p>Hint for the connection manager for the GSM character set that
     *   should be used to send SMSes. The connection manager SHOULD follow
     *   this hint unless it has other ways to determine a better encoding.
     *   If the value is <code>"gsm"</code> (which SHOULD be the default),
     *   SMSes will be encoded in the normal 7-bit GSM character set,
     *   eventually falling back to UCS-2; see the
     *    \endhtmlonly \link requestPropertyMessageReducedCharacterSet() MessageReducedCharacterSet \endlink \htmlonly  property
     *   for details.
     *   Other valid character sets are specified in the
     *   <a href="http://www.3gpp.org/ftp/specs/archive/23_series/23.038/">GSM standard</a> and are, for instance, <code>"turkey"</code>,
     *   <code>"spain"</code> or <code>"portugal"</code>.
     *   If the SMS cannot be encoded using the requested character set the
     *   behaviour is implementation-specific, but it is RECOMMENDED that
     *   the connection manager should behave as if this property was set
     *   to <code>"gsm"</code>.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMessageNationalCharacterSet() const
    {
        return internalRequestProperty(QLatin1String("MessageNationalCharacterSet"));
    }

    /**
     * Asynchronous setter for the remote object property \c MessageNationalCharacterSet of type \c QString.
     *
     * 
     * \htmlonly
     * <p>Hint for the connection manager for the GSM character set that
     *   should be used to send SMSes. The connection manager SHOULD follow
     *   this hint unless it has other ways to determine a better encoding.
     *   If the value is <code>"gsm"</code> (which SHOULD be the default),
     *   SMSes will be encoded in the normal 7-bit GSM character set,
     *   eventually falling back to UCS-2; see the
     *    \endhtmlonly \link requestPropertyMessageReducedCharacterSet() MessageReducedCharacterSet \endlink \htmlonly  property
     *   for details.
     *   Other valid character sets are specified in the
     *   <a href="http://www.3gpp.org/ftp/specs/archive/23_series/23.038/">GSM standard</a> and are, for instance, <code>"turkey"</code>,
     *   <code>"spain"</code> or <code>"portugal"</code>.
     *   If the SMS cannot be encoded using the requested character set the
     *   behaviour is implementation-specific, but it is RECOMMENDED that
     *   the connection manager should behave as if this property was set
     *   to <code>"gsm"</code>.</p>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyMessageNationalCharacterSet(QString newValue)
    {
        return internalSetProperty(QLatin1String("MessageNationalCharacterSet"), QVariant::fromValue(newValue));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

Q_SIGNALS:
    /**
     * Represents the signal \c IMSIChanged on the remote object.
     * 
     * Emitted when the IMSI for the connection changes. This sort of thing is 
     * rare, but could happen on cellular phones that allow hot-swapping of 
     * SIM cards. In the case of SIM swapping, this signal would be emitted 
     * twice; the first time while the SIM is being ejected (with an empty 
     * string), and the second time after a new SIM has been inserted 
     * (assuming that the IMSI can be determined from the new SIM).
     *
     * \param IMSI
     *     
     *     The new IMSI value. This may be an empty string in the case where 
     *     the IMSI is being reset or removed.
     */
    void IMSIChanged(const QString& IMSI);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceClientTypesInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ClientTypes".
 */
class TP_QT_EXPORT ConnectionInterfaceClientTypesInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.ClientTypes", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ClientTypes");
    }

    /**
     * Creates a ConnectionInterfaceClientTypesInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceClientTypesInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceClientTypesInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceClientTypesInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceClientTypesInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceClientTypesInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceClientTypesInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceClientTypesInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceClientTypesInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceClientTypesInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetClientTypes on the remote object.
     * 
     * Return the client types of the given contacts, if they are already 
     * known. If any of the given contacts&apos; client types are not known, 
     * request their current client types, but return immediately without 
     * waiting for a reply; if a reply with a non-empty client type array is 
     * later received for those contacts, the ClientTypesUpdated signal will 
     * be emitted for them. This method is appropriate for &quot;lazy&quot; 
     * client type finding, for instance displaying the client types (if 
     * available) of everyone in your contact list.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     The contacts whose client types should be returned or signalled.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The contacts&apos; client types, if already known. Contacts whose 
     *     client types are not already known are omitted from the mapping; 
     *     contacts known to have no client type information appear in the 
     *     mapping with an empty list.
     */
    inline QDBusPendingReply<Tp::ContactClientTypes> GetClientTypes(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ContactClientTypes>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetClientTypes"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestClientTypes on the remote object.
     * 
     * Return the current client types of the given contact. If necessary, 
     * make a request to the server for up-to-date information, and wait for a 
     * reply. This method is appropriate for use in a &quot;Contact 
     * Information...&quot; dialog; it can be used to show progress 
     * information (while waiting for the method to return), and can 
     * distinguish between various error conditions.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contact
     *     
     *     The contact whose client types should be returned.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The contact&apos;s client types. It MAY be empty, indicating that 
     *     no client type information was found.
     */
    inline QDBusPendingReply<QStringList> RequestClientTypes(uint contact, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QStringList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestClientTypes"));
        callMessage << QVariant::fromValue(contact);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c ClientTypesUpdated on the remote object.
     * 
     * Emitted when a contact&apos;s client types change or become known.
     *
     * \param contact
     *     
     *     The contact.
     *
     * \param clientTypes
     *     
     *     The contact&apos;s client types, or an empty list to indicate that 
     *     nothing is known about the contact&apos;s client types.
     */
    void ClientTypesUpdated(uint contact, const QStringList& clientTypes);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceContactBlockingInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ContactBlocking".
 */
class TP_QT_EXPORT ConnectionInterfaceContactBlockingInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.ContactBlocking", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ContactBlocking");
    }

    /**
     * Creates a ConnectionInterfaceContactBlockingInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactBlockingInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactBlockingInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactBlockingInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactBlockingInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceContactBlockingInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceContactBlockingInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceContactBlockingInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceContactBlockingInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactBlockingInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c ContactBlockingCapabilities of type \c uint.
     *
     * 
     * \htmlonly
     * <p>Additional capabilities for contact blocking; currently, this is
     *   limited to whether contacts may be reported as abusive.</p>
     * 
     * <p>Note that there is no capability for supporting blocking itself:
     *   the presence of this interface on a  \endhtmlonly ConnectionInterface \htmlonly  indicates that blocking
     *   contacts is supported.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyContactBlockingCapabilities() const
    {
        return internalRequestProperty(QLatin1String("ContactBlockingCapabilities"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c BlockContacts on the remote object.
     * 
     * \htmlonly
     * <p>Direct the server to block some contacts. The precise effect is
     *   protocol-dependent, but SHOULD include ignoring all current and
     *   subsequent communications from the given contacts, avoiding sending
     *   presence to them in future, and if they were already receiving the
     *   local user's presence, behaving as if the local user went
     *   offline.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     Some contacts to block. If some of the contacts in this list are 
     *     already blocked, the connection manager MUST act as if they were 
     *     not specified in this list.
     *
     * \param reportAbusive
     *     
     *     \htmlonly
     *     <p>In addition to blocking, report these contacts as abusive to the
     *       server administrators.</p>
     *     
     *     <p>Clients can determine whether this capability is available by
     *       checking the
     *        \endhtmlonly \link requestPropertyContactBlockingCapabilities() ContactBlockingCapabilities \endlink \htmlonly 
     *       property. If this argument is set to <code>True</code> by a client
     *       despite  \endhtmlonly \link requestPropertyContactBlockingCapabilities() ContactBlockingCapabilities \endlink \htmlonly 
     *       not containing the <code>Can_Report_Abusive</code> flag, the
     *       connection manager SHOULD act as if it were <code>False</code> and
     *       simply block the supplied contacts.</p>
     *     
     *     <div class="rationale">
     *       <p>A correct user interface shouldn't get this far without knowing
     *         that reporting abusive contacts is not supported. If it does,
     *         then the user has expressed their intention to block these
     *         contacts. Returning an error would leave the UI with three
     *         options:</p>
     *     
     *       <ul>
     *         <li>Ignore the error, leaving the contacts not actually blocked;</li>
     *         <li>Display an error to the user;</li>
     *         <li>Call this method again, passing <code>False</code> for this
     *         argument.</li>
     *       </ul>
     *     
     *       <p>None of these seem preferable to the CM just ignoring this flag
     *         if it doesn't support it: that way, the contacts will be blocked,
     *         as the user requested, and UIs have fewer ways to mess up
     *         entirely.</p>
     *     </div>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> BlockContacts(const Tp::UIntList& contacts, bool reportAbusive, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("BlockContacts"));
        callMessage << QVariant::fromValue(contacts) << QVariant::fromValue(reportAbusive);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c UnblockContacts on the remote object.
     * 
     * \htmlonly
     * <p>Direct the server to unblock some contacts.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     Some contacts to unblock. If some of the contacts in this list are 
     *     not currently blocked, the connection manager MUST act as if they 
     *     were not specified in this list.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> UnblockContacts(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("UnblockContacts"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestBlockedContacts on the remote object.
     * 
     * \htmlonly
     * <p>List the contacts that are blocked.</p>
     * 
     * <p>Clients SHOULD allow a relatively long timeout for calls to this
     *   method, since on some protocols contact blocking is part of the
     *   contact list, which can take a significant time to retrieve.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The blocked contacts’ handles, together with their identifiers.
     */
    inline QDBusPendingReply<Tp::HandleIdentifierMap> RequestBlockedContacts(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::HandleIdentifierMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestBlockedContacts"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c BlockedContactsChanged on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when the list of blocked contacts is first retrieved
     *   (before returning from any pending calls to
     *    \endhtmlonly RequestBlockedContacts() \htmlonly ), and
     *   whenever the list of blocked contacts subsequently changes.</p>
     * \endhtmlonly
     *
     * \param blockedContacts
     *     
     *     Contacts added to the result of RequestBlockedContacts.
     *
     * \param unblockedContacts
     *     
     *     Contacts removed from the result of RequestBlockedContacts.
     */
    void BlockedContactsChanged(const Tp::HandleIdentifierMap& blockedContacts, const Tp::HandleIdentifierMap& unblockedContacts);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceContactCapabilitiesInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities".
 */
class TP_QT_EXPORT ConnectionInterfaceContactCapabilitiesInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities");
    }

    /**
     * Creates a ConnectionInterfaceContactCapabilitiesInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactCapabilitiesInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactCapabilitiesInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactCapabilitiesInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactCapabilitiesInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceContactCapabilitiesInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceContactCapabilitiesInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceContactCapabilitiesInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceContactCapabilitiesInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactCapabilitiesInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c UpdateCapabilities on the remote object.
     * 
     * \htmlonly
     * <p>Alter the connection's advertised capabilities to include
     *   the intersection of the given clients' capabilities with what the
     *   connection manager is able to implement.</p>
     * 
     * <p>On connections managed by the ChannelDispatcher, processes other
     *   than the ChannelDispatcher SHOULD NOT call this method, and the
     *   ChannelDispatcher SHOULD use this method to advertise the
     *   capabilities of all the registered  \endhtmlonly ClientHandlerInterface \htmlonly 
     *   implementations.On connections not managed by the ChannelDispatcher,
     *   clients MAY use this method directly, to indicate the channels they
     *   will handle and the extra capabilities they have.</p>
     * 
     * <p>Upon a successful invocation of this method, the connection manager
     *   will only emit the
     *    \endhtmlonly ContactCapabilitiesChanged() \htmlonly  signal
     *   for the user's  \endhtmlonly \link ConnectionInterface::requestPropertySelfHandle() ConnectionInterface::SelfHandle \endlink \htmlonly 
     *   if, in the underlying protocol, the new capabilities are distinct
     *   from the previous state.</p>
     * 
     * <div class="rationale">
     *   <p>The connection manager will essentially intersect the provided
     *     capabilities and the channel classes it implements. Therefore,
     *     certain properties which are never fixed for a channel class
     *     (such as the target handle, or the Parameters property of a tube
     *     channel) will almost certainly not be advertised.</p>
     * </div>
     * 
     * <p>This method MAY be called on a newly-created connection while it
     *   is still in the DISCONNECTED state, to request that when the
     *   connection connects, it will do so with the appropriate
     *   capabilities. Doing so MUST NOT fail.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param handlerCapabilities
     *     
     *     The capabilities of one or more clients. For each client in the 
     *     given list, any capabilities previously advertised for the same 
     *     client name are discarded, then replaced by the capabilities 
     *     indicated. As a result, if a client becomes unavailable, this 
     *     method SHOULD be called with a Handler_Capabilities structure 
     *     containing its name, an empty list of channel classes, and an empty 
     *     list of capabilities. When this is done, the connection manager 
     *     SHOULD free all memory associated with that client name. This 
     *     method takes a list of clients so that when the channel dispatcher 
     *     first calls it (with a list of all the Handlers that are initially 
     *     available), the changes can be made atomically, with only one 
     *     transmission of updated capabilities to the network. Afterwards, 
     *     the channel dispatcher will call this method with a single-element 
     *     list every time a Handler becomes available or unavailable. The 
     *     connection manager MUST ignore any channel classes and client 
     *     capabilities for which there is no representation in the protocol 
     *     or no support in the connection manager.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> UpdateCapabilities(const Tp::HandlerCapabilitiesList& handlerCapabilities, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("UpdateCapabilities"));
        callMessage << QVariant::fromValue(handlerCapabilities);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetContactCapabilities on the remote object.
     * 
     * \htmlonly
     * <p>Returns an array of requestable channel classes for the given
     *   contact handles, representing the channel requests that are
     *   expected to succeed.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param handles
     *     
     *     \htmlonly
     *     <p>An array of contact handles for this connection.</p>
     *     
     *     <p>The handle zero MUST NOT be included in the request.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>A map from contact handles to lists of requestable channel
     *       classes, representing the channel requests that are expected
     *       to succeed for that contact.</p>
     *     
     *     <p>Contacts listed among Handles whose capabilities are unknown
     *       SHOULD be omitted from this map; contacts known to have an empty
     *       set of capabilities SHOULD be included in the keys of this map,
     *       with an empty array as the corresponding value.</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::ContactCapabilitiesMap> GetContactCapabilities(const Tp::UIntList& handles, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ContactCapabilitiesMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetContactCapabilities"));
        callMessage << QVariant::fromValue(handles);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c ContactCapabilitiesChanged on the remote object.
     * 
     * \htmlonly
     * <p>Announce that there has been a change of capabilities on the
     *   given handles. A single signal can be emitted for several
     * contacts.</p>
     * 
     * <div class="rationale">
     *   <p>The underlying protocol can get several contacts' capabilities at
     *     the same time.</p>
     * </div>
     * \endhtmlonly
     *
     * \param caps
     *     
     *     \htmlonly
     *     All the capabilities of the contacts
     *     \endhtmlonly
     */
    void ContactCapabilitiesChanged(const Tp::ContactCapabilitiesMap& caps);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceContactGroupsInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ContactGroups".
 */
class TP_QT_EXPORT ConnectionInterfaceContactGroupsInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.ContactGroups", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ContactGroups");
    }

    /**
     * Creates a ConnectionInterfaceContactGroupsInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactGroupsInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactGroupsInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactGroupsInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactGroupsInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceContactGroupsInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceContactGroupsInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceContactGroupsInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceContactGroupsInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactGroupsInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c DisjointGroups of type \c bool.
     *
     * 
     * \htmlonly
     * <p>True if each contact can be in at most one group; false if each
     *   contact can be in many groups.</p>
     * 
     * <p>This property cannot change after the connection has moved to the
     *   Connected state. Until then, its value is undefined, and it may
     *   change at any time, without notification.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDisjointGroups() const
    {
        return internalRequestProperty(QLatin1String("DisjointGroups"));
    }

    /**
     * Asynchronous getter for the remote object property \c GroupStorage of type \c uint.
     *
     * 
     * Indicates the extent to which contacts&apos; groups can be set and 
     * stored. This property cannot change after the connection has moved to 
     * the Connected state. Until then, its value is undefined, and it may 
     * change at any time, without notification.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyGroupStorage() const
    {
        return internalRequestProperty(QLatin1String("GroupStorage"));
    }

    /**
     * Asynchronous getter for the remote object property \c Groups of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>The names of all groups that currently exist. This may be a
     *   larger set than the union of all contacts' <code>groups</code>
     *   contact attributes, if the connection allows groups to be
     *   empty.</p>
     * 
     * <p>Change notification is via
     *    \endhtmlonly GroupsCreated() \htmlonly  and
     *    \endhtmlonly GroupsRemoved() \htmlonly ; clients can also
     *   distinguish between a create/remove pair and a renamed group by
     *   receiving  \endhtmlonly GroupRenamed() \htmlonly .</p>
     * 
     * <p>This property's value is not meaningful until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  has become Success.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyGroups() const
    {
        return internalRequestProperty(QLatin1String("Groups"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c SetContactGroups on the remote object.
     * 
     * \htmlonly
     * <p>Add the given contact to the given groups (creating new groups
     *   if necessary), and remove them from all other groups.</p>
     * 
     * <div class="rationale">
     *   <p>This is the easiest and most correct way to implement user
     *     interfaces that display a single contact with a list of groups,
     *     resulting in a user expectation that when they apply the changes,
     *     the contact's set of groups will become exactly what was
     *     displayed.</p>
     * </div>
     * 
     * <p>If the user is removed from a group of which they were the only
     *   member, the group MAY be removed automatically.</p>
     * 
     * <div class="rationale">
     *   <p>In protocols like XMPP where groups behave like tags, a group
     *     with no members has no protocol representation.</p>
     * </div>
     * 
     * <p>Any  \endhtmlonly GroupsCreated() \htmlonly ,
     *    \endhtmlonly GroupsChanged() \htmlonly  and
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contact
     *     
     *     The contact to alter.
     *
     * \param groups
     *     
     *     The set of groups which the contact should be in.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetContactGroups(uint contact, const QStringList& groups, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetContactGroups"));
        callMessage << QVariant::fromValue(contact) << QVariant::fromValue(groups);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetGroupMembers on the remote object.
     * 
     * \htmlonly
     * <p>Add the given members to the given group (creating it if necessary),
     *   and remove all other members.</p>
     * 
     * <div class="rationale">
     *   <p>This is the easiest and most correct way to implement user
     *     interfaces that display a single group with a list of contacts,
     *     resulting in a user expectation that when they apply the changes,
     *     the groups's set of members will become exactly what was
     *     displayed.</p>
     * </div>
     * 
     * <p>If  \endhtmlonly \link requestPropertyDisjointGroups() DisjointGroups \endlink \htmlonly  is true,
     *   this will also remove each member from their previous group.</p>
     * 
     * <p>If the user is removed from a group of which they were the only
     *   member, the group MAY be removed automatically.</p>
     * 
     * <p>Any  \endhtmlonly GroupsCreated() \htmlonly ,
     *    \endhtmlonly GroupsChanged() \htmlonly  and
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param group
     *     
     *     The group to alter.
     *
     * \param members
     *     
     *     The set of members for the group. If this set is empty, this method 
     *     MAY remove the group.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetGroupMembers(const QString& group, const Tp::UIntList& members, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetGroupMembers"));
        callMessage << QVariant::fromValue(group) << QVariant::fromValue(members);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AddToGroup on the remote object.
     * 
     * \htmlonly
     * <p>Add the given members to the given group, creating it if
     *   necessary.</p>
     * 
     * <p>If  \endhtmlonly \link requestPropertyDisjointGroups() DisjointGroups \endlink \htmlonly  is true,
     *   this will also remove each member from their previous group.</p>
     * 
     * <div class="rationale">
     *   <p>This is good for user interfaces in which you can edit groups
     *     via drag-and-drop.</p>
     * </div>
     * 
     * <p>Any  \endhtmlonly GroupsCreated() \htmlonly ,
     *    \endhtmlonly GroupsChanged() \htmlonly  and
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param group
     *     
     *     The group to alter.
     *
     * \param members
     *     
     *     The set of members to include in the group.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AddToGroup(const QString& group, const Tp::UIntList& members, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AddToGroup"));
        callMessage << QVariant::fromValue(group) << QVariant::fromValue(members);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RemoveFromGroup on the remote object.
     * 
     * \htmlonly
     * <p>Remove the given members from the given group.</p>
     * 
     * <div class="rationale">
     *   <p>This is good for user interfaces in which you can edit groups
     *     via drag-and-drop.</p>
     * </div>
     * 
     * <p>Any  \endhtmlonly GroupsChanged() \htmlonly  or
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param group
     *     
     *     The group to alter. If it does not exist, then it has no members by 
     *     definition, so this method SHOULD return successfully.
     *
     * \param members
     *     
     *     The set of members to remove from the group. It is not an error to 
     *     remove members who are already not in the group. If there are no 
     *     members left in the group afterwards, the group MAY itself be 
     *     removed.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RemoveFromGroup(const QString& group, const Tp::UIntList& members, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RemoveFromGroup"));
        callMessage << QVariant::fromValue(group) << QVariant::fromValue(members);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RemoveGroup on the remote object.
     * 
     * \htmlonly
     * <p>Remove all members from the given group, then remove the group
     *   itself. If the group already does not exist, this method SHOULD
     *   return successfully.</p>
     * 
     * <p>Any  \endhtmlonly GroupsChanged() \htmlonly  or
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param group
     *     
     *     The group to remove.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RemoveGroup(const QString& group, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RemoveGroup"));
        callMessage << QVariant::fromValue(group);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RenameGroup on the remote object.
     * 
     * \htmlonly
     * <p>Rename the given group.</p>
     * 
     * <p>On protocols where groups behave like tags, this is an API
     *   short-cut for adding all of the group's members to a group with
     *   the new name, then removing the old group.</p>
     * 
     * <div class="rationale">
     *   <p>Otherwise, clients can't perform this operation atomically, even
     *     if the connection could.</p>
     * </div>
     * 
     * <p>Any  \endhtmlonly GroupRenamed() \htmlonly  or
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param oldName
     *     
     *     The group to rename.
     *
     * \param newName
     *     
     *     The new name for the group.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RenameGroup(const QString& oldName, const QString& newName, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RenameGroup"));
        callMessage << QVariant::fromValue(oldName) << QVariant::fromValue(newName);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c GroupsChanged on the remote object.
     * 
     * Emitted when contacts&apos; groups change.
     *
     * \param contact
     *     
     *     The relevant contacts.
     *
     * \param added
     *     
     *     The names of groups to which the contacts were added.
     *
     * \param removed
     *     
     *     The names of groups from which the contacts were removed.
     */
    void GroupsChanged(const Tp::UIntList& contact, const QStringList& added, const QStringList& removed);

    /**
     * Represents the signal \c GroupsCreated on the remote object.
     * 
     * Emitted when new, empty groups are created. This will often be followed 
     * by GroupsChanged signals that add some members.
     *
     * \param names
     *     
     *     The names of the new groups.
     */
    void GroupsCreated(const QStringList& names);

    /**
     * Represents the signal \c GroupRenamed on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when a group is renamed, in protocols where this can
     *   be distinguished from group creation, removal and membership
     *   changes.</p>
     * 
     * <p>Immediately after this signal is emitted,
     *    \endhtmlonly GroupsCreated() \htmlonly  MUST signal the
     *   creation of a group with the new name, and
     *    \endhtmlonly GroupsRemoved() \htmlonly  MUST signal the
     *   removal of a group with the old name.</p>
     * 
     * <div class="rationale">
     *   <p>Emitting these extra signals, in this order, means that clients
     *     that are interested in the set of groups that exist (but treat a
     *     rename and a create/remove pair identically) can ignore the
     *     GroupRenamed signal entirely.</p>
     * </div>
     * 
     * <p>If the group was not empty, immediately after those signals are
     *   emitted,  \endhtmlonly GroupsChanged() \htmlonly  MUST signal
     *   that the members of that group were removed from the old name
     *   and added to the new name.</p>
     * 
     * <p>On connection managers where groups behave like tags, renaming a
     *   group MAY be signalled as a set of
     *    \endhtmlonly GroupsCreated() \htmlonly ,
     *    \endhtmlonly GroupsRemoved() \htmlonly  and
     *    \endhtmlonly GroupsChanged() \htmlonly  signals, instead of
     *   emitting this signal.</p>
     * 
     * <div class="rationale">
     *   <p>On protocols like XMPP, another resource "renaming a group" is
     *     indistinguishable from changing contacts' groups individually.</p>
     * </div>
     * \endhtmlonly
     *
     * \param oldName
     *     
     *     The old name of the group.
     *
     * \param newName
     *     
     *     The new name of the group.
     */
    void GroupRenamed(const QString& oldName, const QString& newName);

    /**
     * Represents the signal \c GroupsRemoved on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when one or more groups are removed. If they had members at
     *   the time that they were removed, then immediately after this signal
     *   is emitted,  \endhtmlonly GroupsChanged() \htmlonly  MUST signal
     *   that their members were removed.</p>
     * 
     * <div class="rationale">
     *   <p>Emitting the signals in this order allows for two modes of
     *     operation. A client interested only in a contact's set of groups
     *     can ignore  \endhtmlonly GroupsRemoved() \htmlonly  and rely
     *     on the  \endhtmlonly GroupsChanged() \htmlonly  signal that
     *     will follow; a more elaborate client wishing to distinguish between
     *     all of a group's members being removed, and the group itself
     *     being removed, can additionally watch for
     *      \endhtmlonly GroupsRemoved() \htmlonly  and use it to
     *     disambiguate.</p>
     * </div>
     * \endhtmlonly
     *
     * \param names
     *     
     *     The names of the groups.
     */
    void GroupsRemoved(const QStringList& names);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceContactInfoInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ContactInfo".
 */
class TP_QT_EXPORT ConnectionInterfaceContactInfoInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.ContactInfo", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ContactInfo");
    }

    /**
     * Creates a ConnectionInterfaceContactInfoInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactInfoInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactInfoInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactInfoInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactInfoInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceContactInfoInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceContactInfoInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceContactInfoInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceContactInfoInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactInfoInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c ContactInfoFlags of type \c uint.
     *
     * 
     * \htmlonly
     * <p>An integer representing the bitwise-OR of flags on this
     *   connection.</p>
     * 
     * <p>This property MAY change, without change notification, at any time
     *   before the connection moves to status Connection_Status_Connected.
     *   It MUST NOT change after that point.</p>
     * 
     * <div class="rationale">
     *   <p>Some XMPP servers, like Facebook Chat, do not allow the vCard to
     *     be changed (and so would not have the Can_Set flag). Whether the
     *     user's server is one of these cannot necessarily be detected until
     *     quite late in the connection process.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyContactInfoFlags() const
    {
        return internalRequestProperty(QLatin1String("ContactInfoFlags"));
    }

    /**
     * Asynchronous getter for the remote object property \c SupportedFields of type \c Tp::FieldSpecs.
     *
     * 
     * \htmlonly
     *         <p>A list of field specifications describing the kinds of fields which may
     *           be passed to  \endhtmlonly SetContactInfo() \htmlonly .  The empty
     *           list indicates that arbitrary vCard fields are permitted.  This
     *           property SHOULD be the empty list, and be ignored by clients, if
     *            \endhtmlonly \link requestPropertyContactInfoFlags() ContactInfoFlags \endlink \htmlonly  does not contain the
     *           Can_Set flag.</p>
     * 
     *         <p>For example, a protocol in which arbitrary vCards were stored
     *           as-is would set this property to the
     *           empty list. A protocol whose notion of contact information is one
     *           each of personal phone number, mobile phone number, location, email
     *           address and date of birth, with no attributes allowed on each piece
     *           of information, would set this property to (in Python-like
     *           syntax):</p>
     * 
     *         <pre>
     * [
     *   ('tel', ['type=home'], Parameters_Exact, 1),
     *   ('tel', ['type=cell'], Parameters_Exact, 1),
     *   ('adr', [], Parameters_Exact, 1),
     *   ('bday', [], Parameters_Exact, 1),
     *   ('email', ['type=internet'], Parameters_Exact, 1),
     * ]</pre>
     * 
     *         <p>A protocol which allows users to specify up to four phone numbers,
     *           which may be labelled as personal and/or mobile, would set this
     *           property to
     *           <code>[ ('tel', ['type=home', 'type=cell'], 0, 4), ]</code>.</p>
     * 
     *         <div class="rationale">
     *           <p>Studying existing IM protocols shows that in practice protocols
     *             allow either a very restricted set of fields (such as MSN, which
     *             seems to correspond roughly to the largest example above), or
     *             something mapping 1:1 to a large subset of vCard (such as XMPP's
     *             XEP-0054).</p>
     *         </div>
     * 
     *         <p>This property MAY change, without change notification, at any time
     *           before the connection moves to status Connection_Status_Connected.
     *           It MUST NOT change after that point.</p>
     * 
     *         <div class="rationale">
     *           <p>Some XMPP servers, like Google Talk, only allow a small subset of
     *             the "vcard-temp" protocol. Whether the user's server is one of
     *             these cannot be detected until quite late in the connection
     *             process.</p>
     *         </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySupportedFields() const
    {
        return internalRequestProperty(QLatin1String("SupportedFields"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetContactInfo on the remote object.
     * 
     * Request information on several contacts at once. This SHOULD only 
     * return cached information, omitting handles for which no information is 
     * cached from the returned map.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     An array of handles representing contacts.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A dictionary mapping contact handles to information, whose keys are 
     *     the subset of the requested list of handles for which information 
     *     was cached.
     */
    inline QDBusPendingReply<Tp::ContactInfoMap> GetContactInfo(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ContactInfoMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetContactInfo"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RefreshContactInfo on the remote object.
     * 
     * Retrieve information for the given contact, requesting it from the 
     * network if an up-to-date version is not cached locally. This method 
     * SHOULD return immediately, emitting ContactInfoChanged when the 
     * contacts&apos; updated contact information is returned. This method 
     * allows a client with cached contact information to update its cache 
     * after a number of days.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     Integer handles for contacts.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RefreshContactInfo(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RefreshContactInfo"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestContactInfo on the remote object.
     * 
     * Retrieve information for a contact, requesting it from the network if 
     * it is not cached locally. This method is appropriate for an explicit 
     * user request to show a contact&apos;s information; it allows a UI to 
     * wait for the contact info to be returned.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contact
     *     
     *     An integer handle for a contact.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     Information about that contact.
     */
    inline QDBusPendingReply<Tp::ContactInfoFieldList> RequestContactInfo(uint contact, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ContactInfoFieldList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestContactInfo"));
        callMessage << QVariant::fromValue(contact);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetContactInfo on the remote object.
     * 
     * Set new contact information for this connection, replacing existing 
     * information. This method is only suppported if ContactInfoFlags 
     * contains Can_Set, and may only be passed fields conforming to 
     * SupportedFields.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contactInfo
     *     
     *     The new information to be set.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetContactInfo(const Tp::ContactInfoFieldList& contactInfo, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetContactInfo"));
        callMessage << QVariant::fromValue(contactInfo);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c ContactInfoChanged on the remote object.
     * 
     * Emitted when a contact&apos;s information has changed or been received 
     * for the first time on this connection.
     *
     * \param contact
     *     
     *     An integer handle for the contact whose info has changed.
     *
     * \param contactInfo
     *     
     *     \htmlonly
     *     An array of fields representing information about this contact.
     *     \endhtmlonly
     */
    void ContactInfoChanged(uint contact, const Tp::ContactInfoFieldList& contactInfo);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceContactListInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ContactList".
 */
class TP_QT_EXPORT ConnectionInterfaceContactListInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.ContactList", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ContactList");
    }

    /**
     * Creates a ConnectionInterfaceContactListInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactListInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactListInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactListInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactListInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceContactListInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceContactListInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceContactListInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceContactListInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactListInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c ContactListState of type \c uint.
     *
     * 
     * The progress made in retrieving the contact list. Change notification 
     * is via ContactListStateChanged.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyContactListState() const
    {
        return internalRequestProperty(QLatin1String("ContactListState"));
    }

    /**
     * Asynchronous getter for the remote object property \c ContactListPersists of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If true, presence subscriptions (in both directions) on this
     *   connection are stored by the server or other infrastructure.</p>
     * 
     * <div class="rationale">
     *   <p>XMPP, MSN, ICQ, etc. all behave like this.</p>
     * </div>
     * 
     * <p>If false, presence subscriptions on this connection are not
     *   stored.</p>
     * 
     * <div class="rationale">
     *   <p>In SIMPLE (SIP), <em>clients</em> are expected to keep a record
     *     of subscriptions, as described below. In link-local XMPP,
     *     subscriptions are implicit (everyone on the local network receives
     *     presence from everyone else) so nothing is ever stored.</p>
     * </div>
     * 
     * <p>If  \endhtmlonly \link requestPropertyCanChangeContactList() CanChangeContactList \endlink \htmlonly 
     *   is true, Telepathy clients (e.g. user interfaces or address books)
     *   MAY keep a record of permission to publish and requests to subscribe
     *   locally, and attempt to restore it for each Connection. If
     *   ContactListPersists is false, clients MAY do this for all contacts;
     *   if ContactListPersists is true, clients SHOULD NOT change the state
     *   of contacts that were not changed locally.</p>
     * 
     * <div class="rationale">
     *   <p>In SIMPLE (SIP), ContactListPersists is false, but
     *     CanChangeContactList is true. Presence will not be received
     *     unless clients renew any subscriptions they have for each
     *     connection, in the way described. There is no server-side storage,
     *     so clients have no alternative but to maintain independent contact
     *     lists.</p>
     * 
     *   <p>In protocols like XMPP and MSN, it may be useful for clients to
     *     queue up subscription requests or removals made while offline and
     *     process them next time the connection is online. However, clients
     *     should only replay the changes, rather than resetting the contact
     *     list to match a stored copy, to avoid overwriting changes that
     *     were made on the server.</p>
     * </div>
     * 
     * <p>Clients that replay requests like this SHOULD do so by calling
     *   AuthorizePublication to pre-approve publication of presence to the
     *   appropriate contacts, followed by RequestSubscription to request the
     *   appropriate contacts' presences.</p>
     * 
     * <p>This property cannot change after the connection has moved to the
     *   Connected state. Until then, its value is undefined, and it may
     *   change at any time, without notification.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyContactListPersists() const
    {
        return internalRequestProperty(QLatin1String("ContactListPersists"));
    }

    /**
     * Asynchronous getter for the remote object property \c CanChangeContactList of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If true, presence subscription and publication can be changed
     *   using the
     *    \endhtmlonly RequestSubscription() \htmlonly ,
     *    \endhtmlonly AuthorizePublication() \htmlonly  and
     *    \endhtmlonly RemoveContacts() \htmlonly  methods.</p>
     * 
     * <p>If false, all of those methods will always fail; they SHOULD raise
     *   the error org.freedesktop.Telepathy.Error.NotImplemented.</p>
     * 
     * <div class="rationale">
     *   <p>In XEP-0174 "Serverless Messaging" (link-local XMPP), presence is
     *     implicitly published to everyone in the local subnet, so the user
     *     cannot control their presence publication.</p>
     * </div>
     * 
     * <p>This property cannot change after the connection has moved to the
     *   Connected state. Until then, its value is undefined, and it may
     *   change at any time, without notification.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCanChangeContactList() const
    {
        return internalRequestProperty(QLatin1String("CanChangeContactList"));
    }

    /**
     * Asynchronous getter for the remote object property \c RequestUsesMessage of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If true, the Message parameter to
     *    \endhtmlonly RequestSubscription() \htmlonly  is likely to be
     *   significant, and user interfaces SHOULD prompt the user for a
     *   message to send with the request; a message such as "I would like
     *   to add you to my contact list", translated into the local user's
     *   language, might make a suitable default.</p>
     * 
     * <div class="rationale">
     *   <p>This matches user expectations in XMPP and ICQ, for instance.</p>
     * </div>
     * 
     * <p>If false, the parameter is ignored; user interfaces SHOULD avoid
     *   prompting the user, and SHOULD pass an empty string to
     *   RequestSubscription.</p>
     * 
     * <div class="rationale">
     *   <p><em>FIXME: is there any such protocol?</em></p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRequestUsesMessage() const
    {
        return internalRequestProperty(QLatin1String("RequestUsesMessage"));
    }

    /**
     * Asynchronous getter for the remote object property \c DownloadAtConnection of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If true, the contact list is automatically downloaded at
     *   connection. If false, the contact list is only downloaded
     *   when requested explicitely with
     *    \endhtmlonly Download() \htmlonly .</p>
     * 
     * <div class="rationale">
     *   <p>Downloading the contact list uses bandwidth and is not always
     *     necessary or desired. For example, a client could cache the
     *     contact list from previous connections and accept less regular
     *     updates, it could get the contact list from an out-of-band
     *     protocol-specific way, or it could not need the contact list at
     *     all.</p>
     * </div>
     * 
     * <p>Connection managers MUST default to true.</p>
     * 
     * <div class="rationale">
     *   <p>If a connection manager starts supporting this property but
     *     defaults to false, it would break all existing clients that don't
     *     call  \endhtmlonly Download() \htmlonly .</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDownloadAtConnection() const
    {
        return internalRequestProperty(QLatin1String("DownloadAtConnection"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetContactListAttributes on the remote object.
     * 
     * \htmlonly
     * <p>Return some contact attributes for a list of contacts
     *   associated with the user. This list MUST include at least:</p>
     * 
     * <ul>
     *   <li>all contacts whose <tp:token-ref>subscribe</tp:token-ref>
     *     attribute is not No</li>
     *   <li>all contacts whose <tp:token-ref>publish</tp:token-ref>
     *     attribute is not No</li>
     * </ul>
     * 
     * <p>but MAY contain other contacts.</p>
     * 
     * <div class="rationale">
     *   <p>For instance, on XMPP, all contacts on the roster would appear
     *     here even if they have subscription="none", unless there's
     *     reason to believe the user does not want to see them (such as
     *     having been blocked).</p>
     * </div>
     * 
     * <p>This list does not need to contain every visible contact: for
     *   instance, contacts seen in XMPP or IRC chatrooms SHOULD NOT appear
     *   here. Blocked contacts SHOULD NOT appear here, unless they still
     *   have a non-<tt>No</tt> <tp:token-ref>subscribe</tp:token-ref> or
     *   <tp:token-ref>publish</tp:token-ref> attribute
     *   for some reason.</p>
     * 
     * <div class="rationale">
     *   <p>It's reasonable to assume that blocked contacts should not be
     *     visible to the user unless they specifically go looking for them,
     *     at least in protocols like XMPP where blocking a contact
     *     suppresses presence.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param interfaces
     *     
     *     \htmlonly
     *     <p>A list of strings indicating which D-Bus interfaces the calling
     *       process is interested in. Equivalent to the corresponding argument
     *       to  \endhtmlonly ConnectionInterfaceContactsInterface::GetContactAttributes() \htmlonly ,
     *       except that if this list does not contain the ContactList
     *       interface itself, it is treated as though that interface was also
     *       requested.</p>
     *     \endhtmlonly
     *
     * \param hold
     *     
     *     \htmlonly
     *     <p>If true, all handles that appear as keys in the result have been
     *       held on behalf of the calling process, as if by a call to
     *        \endhtmlonly ConnectionInterface::HoldHandles() \htmlonly .
     *       (If  \endhtmlonly \link ConnectionInterface::requestPropertyHasImmortalHandles() ConnectionInterface::HasImmortalHandles \endlink \htmlonly  is true, which SHOULD be the
     *       case in all new connection managers, this has no effect.)</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>A dictionary mapping the contact handles to contact attributes,
     *       equivalent to the result of  \endhtmlonly ConnectionInterfaceContactsInterface::GetContactAttributes() \htmlonly .</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::ContactAttributesMap> GetContactListAttributes(const QStringList& interfaces, bool hold, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ContactAttributesMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetContactListAttributes"));
        callMessage << QVariant::fromValue(interfaces) << QVariant::fromValue(hold);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestSubscription on the remote object.
     * 
     * \htmlonly
     * <p>Request that the given contacts allow the local user to
     *   subscribe to their presence, i.e. that their subscribe attribute
     *   becomes Yes.</p>
     * 
     * <p>Connection managers SHOULD NOT attempt to enforce a
     *   mutual-subscription policy (i.e. when this method is called, they
     *   should not automatically allow the contacts to see the local user's
     *   presence). User interfaces that require mutual subscription
     *   MAY call  \endhtmlonly AuthorizePublication() \htmlonly 
     *   at the same time as this method.</p>
     * 
     * <div class="rationale">
     *   <p>Whether to enforce mutual subscription is a matter of policy,
     *     so it is left to the user interface and/or the server.</p>
     * </div>
     * 
     * <p>Before calling this method on a connection where  \endhtmlonly ConnectionInterfaceAliasingInterface::GetAliasFlags() \htmlonly  returns the <code>User_Set</code> flag,
     *   user interfaces SHOULD obtain, from the user, an alias to
     *   identify the contact in future, and store it using  \endhtmlonly ConnectionInterfaceAliasingInterface::SetAliases() \htmlonly .</p>
     * 
     * <p>The user MAY be
     *   prompted using the contact's current self-assigned nickname, or
     *   something derived from the contact's (presumably self-assigned)
     *   identifier, as a default, but these names chosen by the contact
     *   SHOULD NOT be used without user approval.</p>
     * 
     * <div class="rationale">
     *   <p>This is a generalization of
     *     <a href="http://xmpp.org/extensions/xep-0165.html">XEP-0165 "Best Practices to Discourage JID Mimicking"</a>)
     *     to protocols other than XMPP. A reasonable user interface for
     *     this, as used in many XMPP clients, is to have a text entry
     *     for the alias adjacent to the text entry for the identifier
     *     to add.</p>
     * </div>
     * 
     * <p>For contacts with subscribe=Yes, this method has no effect.
     *   It MUST return successfully if all contacts are in this state.</p>
     * 
     * <p>For contacts with subscribe=Ask, this method SHOULD send a new
     *   request, with the given message, if allowed by the underlying
     *   protocol.</p>
     * 
     * <p>For contacts with subscribe=No or subscribe=Rejected, this method
     *   SHOULD request that the contact allows the local user to subscribe
     *   to their presence; in general, this will change their publish
     *   attribute to Ask (although it could change directly to Yes in some
     *   situations).</p>
     * 
     * <p>Any state changes that immediately result from this request MUST
     *   be signalled via  \endhtmlonly ContactsChanged() \htmlonly 
     *   before this method returns.</p>
     * 
     * <div class="rationale">
     *   <p>This makes it easy for user interfaces to see what practical
     *     effect this method had.</p>
     * </div>
     * 
     * <p>If the remote contact accepts the request, their subscribe
     *   attribute will later change from Ask to Yes.</p>
     * 
     * <p>If the remote contact explicitly rejects the request (in protocols
     *   that allow this), their subscribe attribute will later change from
     *   Ask to Rejected.</p>
     * 
     * <p>If the subscription request is cancelled by the local user, the
     *   contact's subscribe attribute will change from Ask to No.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to Success.
     *   If the  \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to
     *   Failure, this method SHOULD raise the same error as
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     \htmlonly
     *     <p>One or more contacts to whom requests are to be sent.</p>
     *     \endhtmlonly
     *
     * \param message
     *     
     *     \htmlonly
     *     <p>An optional plain-text message from the user, to send to those
     *       contacts with the subscription request. The
     *        \endhtmlonly \link requestPropertyRequestUsesMessage() RequestUsesMessage \endlink \htmlonly  property
     *       indicates whether this message will be used or ignored.</p>
     *     
     *     <p>Clients SHOULD NOT send a non-empty message without first giving
     *       the user an opportunity to edit it.</p>
     *     
     *     <div class="rationale">
     *       <p>These messages are typically presented to the remote contact
     *         as if the user had typed them, so as a minimum, the user should be
     *         allowed to see what the UI will be saying on their behalf.</p>
     *     </div>
     *     
     *     <p>Connections where this message is not useful MUST still allow it to
     *       be non-empty.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RequestSubscription(const Tp::UIntList& contacts, const QString& message, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestSubscription"));
        callMessage << QVariant::fromValue(contacts) << QVariant::fromValue(message);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AuthorizePublication on the remote object.
     * 
     * \htmlonly
     * <p>For each of the given contacts, request that the local user's
     *   presence is sent to that contact, i.e. that their publish attribute
     *   becomes Yes.</p>
     * 
     * <p>Connection managers SHOULD NOT attempt to enforce a
     *   mutual-subscription policy (i.e. when this method is called, they
     *   should not automatically request that the contacts allow the user to
     *   subscribe to their presence). User interfaces that require mutual
     *   subscription MAY call
     *    \endhtmlonly RequestSubscription() \htmlonly  at the same time
     *   as this method.</p>
     * 
     * <div class="rationale">
     *   <p>Whether to enforce mutual subscription is a matter of policy,
     *     so it is left to the user interface and/or the server.</p>
     * </div>
     * 
     * <p>For contacts with publish=Yes, this method has no effect; it
     *   MUST return successfully if all contacts given have this state.</p>
     * 
     * <p>For contacts with publish=Ask, this method accepts the
     *   contact's request to see the local user's presence, changing
     *   their publish attribute from Ask to Yes.</p>
     * 
     * <p>For contacts with publish=No, if the protocol allows it, this
     *   method allows the contacts to see the local user's presence even
     *   though they have not requested it, changing their publish attribute
     *   from No to Yes. Otherwise, it merely records the fact that
     *   presence publication to those contacts is allowed; if any of
     *   those contacts ask to receive the local user's presence
     *   later in the lifetime of the connection, the connection SHOULD
     *   immediately allow them to do so, changing their publish
     *   attribute directly from No to Yes.</p>
     * 
     * <div class="rationale">
     *   <p>This makes it easy to implement the common UI policy that if
     *     the user attempts to subscribe to a contact's presence, requests
     *     for reciprocal subscription are automatically approved.</p>
     * </div>
     * 
     * <p>Any state changes that immediately result from this request MUST
     *   be signalled via  \endhtmlonly ContactsChanged() \htmlonly 
     *   before this method returns.</p>
     * 
     * <div class="rationale">
     *   <p>This makes it easy for user interfaces to see what practical
     *     effect this method had.</p>
     * </div>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to Success.
     *   If the  \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to
     *   Failure, this method SHOULD raise the same error as
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     \htmlonly
     *     <p>One or more contacts to authorize.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AuthorizePublication(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AuthorizePublication"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RemoveContacts on the remote object.
     * 
     * \htmlonly
     * <p>Remove the given contacts from the contact list entirely. It is
     *   protocol-dependent whether this works, and under which
     *   circumstances.</p>
     * 
     * <p>If possible, this method SHOULD set the contacts' subscribe and
     *   publish attributes to No, remove any stored aliases for those
     *   contacts, and remove the contacts from the result of
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * 
     * <p>This method SHOULD succeed even if it was not possible to carry out
     *   the request entirely or for all contacts (for instance, if there is an
     *   outstanding request to subscribe to the contact's presence, and it's
     *   not possible to cancel such requests). However, all signals that
     *   immediately result from this method call MUST be emitted before it
     *   returns, so that clients can interpret the result.</p>
     * 
     * <div class="rationale">
     *   <p>User interfaces removing a contact from the contact list are
     *     unlikely to want spurious failure notifications resulting from
     *     limitations of a particular protocol. However, emitting the
     *     signals first means that if a client does want to check exactly
     *     what happened, it can wait for the method to return (while
     *     applying change-notification signals to its local cache of the
     *     contact list's state), then consult its local cache of the
     *     contact list's state to see whether the contact is still there.</p>
     * </div>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to Success.
     *   If the  \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to
     *   Failure, this method SHOULD raise the same error as
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     \htmlonly
     *     <p>One or more contacts to remove.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RemoveContacts(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RemoveContacts"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Unsubscribe on the remote object.
     * 
     * \htmlonly
     * <p>Attempt to set the given contacts' subscribe attribute to No,
     *   i.e. stop receiving their presence.</p>
     * 
     * <p>For contacts with subscribe=Ask, this attempts to cancel
     *   an earlier request to subscribe to the contact's presence; for
     *   contacts with subscribe=Yes, this attempts to
     *   unsubscribe from the contact's presence.</p>
     * 
     * <p>As with  \endhtmlonly RemoveContacts() \htmlonly , this method
     *   SHOULD succeed even if it was not possible to carry out the request
     *   entirely or for all contacts; however, all signals that
     *   immediately result from this method call MUST be emitted before it
     *   returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to Success.
     *   If the  \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to
     *   Failure, this method SHOULD raise the same error as
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     \htmlonly
     *     <p>One or more contacts to remove.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Unsubscribe(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Unsubscribe"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Unpublish on the remote object.
     * 
     * \htmlonly
     * <p>Attempt to set the given contacts' publish attribute to No,
     *   i.e. stop sending presence to them.</p>
     * 
     * <p>For contacts with publish=Ask, this method explicitly rejects the
     *   contact's request to subscribe to the user's presence; for
     *   contacts with publish=Yes, this method attempts to prevent the
     *   user's presence from being received by the contact.</p>
     * 
     * <p>As with  \endhtmlonly RemoveContacts() \htmlonly , this method
     *   SHOULD succeed even if it was not possible to carry out the request
     *   entirely or for all contacts; however, all signals that
     *   immediately result from this method call MUST be emitted before it
     *   returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to Success.
     *   If the  \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to
     *   Failure, this method SHOULD raise the same error as
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     \htmlonly
     *     <p>One or more contacts to remove.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Unpublish(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Unpublish"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Download on the remote object.
     * 
     * \htmlonly
     * <p>Download the contact list from the server. If
     *    \endhtmlonly \link requestPropertyDownloadAtConnection() DownloadAtConnection \endlink \htmlonly  is true,
     *   Download does nothing.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Download(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Download"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c ContactListStateChanged on the remote object.
     * 
     * Emitted when ContactListState changes.
     *
     * \param contactListState
     *     
     *     The new value of ContactListState.
     */
    void ContactListStateChanged(uint contactListState);

    /**
     * Represents the signal \c ContactsChangedWithID on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when the contact list becomes available, when contacts'
     *   basic stored properties change, when new contacts are added to the
     *   list that would be returned by
     *    \endhtmlonly GetContactListAttributes() \htmlonly ,
     *   or when contacts are removed from that list.</p>
     * 
     * <div class="rationale">
     *   <p>This provides change notification for that list, and for
     *     contacts' <tp:token-ref>subscribe</tp:token-ref>,
     *     <tp:token-ref>publish</tp:token-ref> and
     *     <tp:token-ref>publish-request</tp:token-ref> attributes.</p>
     * </div>
     * 
     * <p>Connection managers SHOULD also emit this signal when a contact
     *   requests that the user's presence is published to them, even if
     *   that contact's <tp:token>publish</tp:token> attribute is already
     *   Ask and the <tp:token>publish-request</tp:token> has not changed.</p>
     * 
     * <div class="rationale">
     *   <p>If the same contact sends 10 identical requests, 10 identical
     *     signals should be emitted.</p>
     * </div>
     * \endhtmlonly
     *
     * \param changes
     *     
     *     The new subscribe, publish and publish-request attributes of all 
     *     the contacts that have been added, and all the contacts for which 
     *     those attributes have changed.
     *
     * \param identifiers
     *     
     *     \htmlonly
     *     The identifiers of the contacts in the <var>Changes</var> map.
     *     \endhtmlonly
     *
     * \param removals
     *     
     *     \htmlonly
     *     The contacts that have been removed from the list that would be
     *     returned by
     *      \endhtmlonly GetContactListAttributes() \htmlonly .
     *     This also implies that they have subscribe = No and publish = No;
     *     contacts MUST NOT be listed both here and in <var>Changes</var>.
     *     \endhtmlonly
     */
    void ContactsChangedWithID(const Tp::ContactSubscriptionMap& changes, const Tp::HandleIdentifierMap& identifiers, const Tp::HandleIdentifierMap& removals);

    /**
     * Represents the signal \c ContactsChanged on the remote object.
     * 
     * \htmlonly
     * <p>Emitted immediately after
     *    \endhtmlonly ContactsChangedWithID() \htmlonly , under the same
     *   circumstances.</p>
     * 
     * <p>If clients receive this signal without first receiving a
     *   corresponding  \endhtmlonly ContactsChangedWithID() \htmlonly ,
     *   they MUST assume that only this signal will be emitted.</p>
     * \endhtmlonly
     *
     * \param changes
     *     
     *     The same as the corresponding argument to ContactsChangedWithID.
     *
     * \param removals
     *     
     *     The same as the corresponding argument to ContactsChangedWithID, 
     *     except that it only includes handles and not identifiers.
     */
    void ContactsChanged(const Tp::ContactSubscriptionMap& changes, const Tp::UIntList& removals);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceContactsInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Contacts".
 */
class TP_QT_EXPORT ConnectionInterfaceContactsInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.Contacts", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Contacts");
    }

    /**
     * Creates a ConnectionInterfaceContactsInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactsInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactsInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactsInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceContactsInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceContactsInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceContactsInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceContactsInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceContactsInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceContactsInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c ContactAttributeInterfaces of type \c QStringList.
     *
     * 
     * A list of D-Bus interfaces for which GetContactAttributes is expected 
     * to work. This cannot change during the lifetime of the Connection.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyContactAttributeInterfaces() const
    {
        return internalRequestProperty(QLatin1String("ContactAttributeInterfaces"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetContactAttributes on the remote object.
     * 
     * Return any number of contact attributes for the given handles.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param handles
     *     
     *     An array of handles representing contacts.
     *
     * \param interfaces
     *     
     *     \htmlonly
     *     <p>A list of strings indicating which D-Bus interfaces the calling
     *       process is interested in. All supported attributes from these
     *       interfaces, whose values can be obtained without additional network
     *       activity, will be in the reply.</p>
     *     
     *     <p>Connection managers SHOULD ignore interfaces requested which they
     *       do not support (i.e. those not mentioned in the
     *        \endhtmlonly \link requestPropertyContactAttributeInterfaces() ContactAttributeInterfaces \endlink \htmlonly 
     *       property.)</p>
     *     
     *     <div class="rationale">
     *       <p>This simplifies client-side code. Clients which care may
     *         distinguish between unsupported interfaces (e.g. this Connection
     *         does not support Avatars), and interfaces on which no information
     *         is known for these contacts (e.g. we don't know the avatar tokens
     *         of any of the contacts, so we omitted them all) by inspecting
     *          \endhtmlonly \link requestPropertyContactAttributeInterfaces() ContactAttributeInterfaces \endlink \htmlonly .</p>
     *     </div>
     *     
     *     <p>Attributes from the interface
     *        \endhtmlonly ConnectionInterface \htmlonly 
     *       are always returned, and need not be requested explicitly.</p>
     *     
     *     <p>As well as returning cached information immediately, the
     *       connection MAY start asynchronous requests to obtain better
     *       values for the contact attributes. If better values are later
     *       obtained by this process, they will be indicated with the usual
     *       signals (such as  \endhtmlonly ConnectionInterfaceAliasingInterface::AliasesChanged() \htmlonly ).</p>
     *     
     *     <div class="rationale">
     *       For instance, an XMPP connection manager could download vCards
     *       in response to a request for  \endhtmlonly ConnectionInterfaceAliasingInterface \htmlonly 
     *       attributes.
     *     </div>
     *     \endhtmlonly
     *
     * \param hold
     *     
     *     \htmlonly
     *     <p>If true, all handles that appear as keys in the result have been
     *       held on behalf of the calling process, as if by a call to
     *        \endhtmlonly ConnectionInterface::HoldHandles() \htmlonly .
     *       (If  \endhtmlonly \link ConnectionInterface::requestPropertyHasImmortalHandles() ConnectionInterface::HasImmortalHandles \endlink \htmlonly  is true, which SHOULD be the
     *       case in all new connection managers, this has no effect.)</p>
     *     
     *     <div class="rationale">
     *       <p>For further round-trip avoidance.</p>
     *     </div>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>A dictionary mapping the contact handles to contact attributes.
     *       If any of the requested handles are in fact invalid, they are
     *       simply omitted from this mapping. If contact attributes are not
     *       immediately known, the behaviour is defined by the interface;
     *       the attribute should either be omitted from the result or
     *       replaced with a default value.</p>
     *     
     *     <p>Each contact's attributes will always include at least the
     *       identifier that would be obtained by inspecting the handle
     *       (<code>org.freedesktop.Telepathy.Connection/contact-id</code>).</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::ContactAttributesMap> GetContactAttributes(const Tp::UIntList& handles, const QStringList& interfaces, bool hold, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ContactAttributesMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetContactAttributes"));
        callMessage << QVariant::fromValue(handles) << QVariant::fromValue(interfaces) << QVariant::fromValue(hold);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetContactByID on the remote object.
     * 
     * Return any number of contact attributes for the given identifier. This 
     * is for a single identifier to make it simpler to use for the most 
     * common use case. For multiple contacts case, GetContactAttributes 
     * should be used.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param identifier
     *     
     *     An identifier representing a contact.
     *
     * \param interfaces
     *     
     *     \htmlonly
     *     <p>A list of strings indicating which D-Bus interfaces the calling
     *       process is interested in. All supported attributes from these
     *       interfaces, whose values can be obtained without additional network
     *       activity, will be in the reply.</p>
     *     <p>See  \endhtmlonly GetContactAttributes() \htmlonly  for
     *       details.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>The contact's handle, as returned by  \endhtmlonly ConnectionInterface::RequestHandles() \htmlonly </p>
     *     \endhtmlonly
     *
     * \return
     *     
     *     \htmlonly
     *     <p>All supported attributes of the contact on
     *       the given interfaces that can be returned without network
     *       round-trips. If contact attributes are not immediately known, the
     *       behaviour is defined by the interface; the attribute should either
     *       be omitted from the result or replaced with a default value.</p>
     *     
     *     <p>The contact's attributes will always include at least the
     *       identifier that would be obtained by inspecting the handle
     *       (<code>org.freedesktop.Telepathy.Connection/contact-id</code>).</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<uint, QVariantMap> GetContactByID(const QString& identifier, const QStringList& interfaces, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint, QVariantMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetContactByID"));
        callMessage << QVariant::fromValue(identifier) << QVariant::fromValue(interfaces);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceLocationInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Location".
 */
class TP_QT_EXPORT ConnectionInterfaceLocationInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.Location", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Location");
    }

    /**
     * Creates a ConnectionInterfaceLocationInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceLocationInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceLocationInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceLocationInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceLocationInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceLocationInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceLocationInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceLocationInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceLocationInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceLocationInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c LocationAccessControlTypes of type \c Tp::UIntList.
     *
     * 
     * The types of access control that are supported by this connection.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyLocationAccessControlTypes() const
    {
        return internalRequestProperty(QLatin1String("LocationAccessControlTypes"));
    }

    /**
     * Asynchronous getter for the remote object property \c LocationAccessControl of type \c Tp::RichPresenceAccessControl.
     *
     * 
     * The current access control mechanism and settings for this connection. 
     * Before publishing location for the first time, if this has not been set 
     * by a client, implementations SHOULD set it to be as restrictive as 
     * possible (an empty whitelist, if supported).
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyLocationAccessControl() const
    {
        return internalRequestProperty(QLatin1String("LocationAccessControl"));
    }

    /**
     * Asynchronous setter for the remote object property \c LocationAccessControl of type \c Tp::RichPresenceAccessControl.
     *
     * 
     * The current access control mechanism and settings for this connection. 
     * Before publishing location for the first time, if this has not been set 
     * by a client, implementations SHOULD set it to be as restrictive as 
     * possible (an empty whitelist, if supported).
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyLocationAccessControl(Tp::RichPresenceAccessControl newValue)
    {
        return internalSetProperty(QLatin1String("LocationAccessControl"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c SupportedLocationFeatures of type \c uint.
     *
     * 
     * \htmlonly
     * Indicates the Location features supported by this connection. This
     * property MAY be undefined before  \endhtmlonly \link ConnectionInterface::requestPropertyStatus() ConnectionInterface::Status \endlink \htmlonly 
     * becomes <code>Connected</code>, but MUST remain constant thereafter.
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySupportedLocationFeatures() const
    {
        return internalRequestProperty(QLatin1String("SupportedLocationFeatures"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetLocations on the remote object.
     * 
     * \htmlonly
     * <p>Return the current locations of the given contacts, if they are
     *   already known. If any of the given contacts' locations are not known,
     *   request their current locations, but return immediately without waiting
     *   for a reply; if a reply with a non-empty location is later received
     *   for those contacts, the  \endhtmlonly LocationUpdated() \htmlonly 
     *   signal will be emitted for them.</p>
     * 
     * <div class="rationale">
     *   <p>This method is appropriate for "lazy" location finding, for instance
     *     displaying the location (if available) of everyone in your contact
     *     list.</p>
     * </div>
     * 
     * <p>For backwards compatibility, if this method is called by a client
     *   whose "interest count" for this interface, as defined by  \endhtmlonly ConnectionInterface::AddClientInterest() \htmlonly , is zero, the
     *   Connection SHOULD behave as if AddClientInterest had been called for
     *   this interface just before that method call. Clients that do not
     *   explicitly call AddClientInterest SHOULD NOT call  \endhtmlonly ConnectionInterface::RemoveClientInterest() \htmlonly  either.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     The contacts whose locations should be returned or signalled.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The contacts&apos; locations, if already known. Contacts whose 
     *     locations are not already known are omitted from the mapping; 
     *     contacts known to have no location information appear in the 
     *     mapping with an empty Location dictionary.
     */
    inline QDBusPendingReply<Tp::ContactLocations> GetLocations(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ContactLocations>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetLocations"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestLocation on the remote object.
     * 
     * Return the current location of the given contact. If necessary, make a 
     * request to the server for up-to-date information, and wait for a reply. 
     * This method is appropriate for use in a &quot;Contact 
     * Information...&quot; dialog; it can be used to show progress 
     * information (while waiting for the method to return), and can 
     * distinguish between various error conditions.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contact
     *     
     *     The contact whose location should be returned.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The contact&apos;s location. It MAY be empty, indicating that no 
     *     location information was found.
     */
    inline QDBusPendingReply<QVariantMap> RequestLocation(uint contact, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QVariantMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestLocation"));
        callMessage << QVariant::fromValue(contact);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetLocation on the remote object.
     * 
     * Set the local user&apos;s own location.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param location
     *     
     *     The location to advertise. If the user wants to obscure their exact 
     *     location by reducing the precision or accuracy, clients MUST do 
     *     this themselves, rather than relying on the connection manager to 
     *     do so. Clients that interact with more than one connection SHOULD 
     *     advertise the same reduced-accuracy location to all of them, so 
     *     that contacts cannot obtain an undesirably accurate location by 
     *     assuming that random errors have been added and averaging the 
     *     locations advertised on multiple connections.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetLocation(const QVariantMap& location, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetLocation"));
        callMessage << QVariant::fromValue(location);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c LocationUpdated on the remote object.
     * 
     * Emitted when a contact&apos;s location changes or becomes known.
     *
     * \param contact
     *     
     *     The contact
     *
     * \param location
     *     
     *     The contact&apos;s location, or empty to indicate that nothing is 
     *     known about the contact&apos;s location.
     */
    void LocationUpdated(uint contact, const QVariantMap& location);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceMailNotificationInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.MailNotification".
 */
class TP_QT_EXPORT ConnectionInterfaceMailNotificationInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.MailNotification", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.MailNotification");
    }

    /**
     * Creates a ConnectionInterfaceMailNotificationInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceMailNotificationInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceMailNotificationInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceMailNotificationInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceMailNotificationInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceMailNotificationInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceMailNotificationInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceMailNotificationInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceMailNotificationInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceMailNotificationInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c MailNotificationFlags of type \c uint.
     *
     * 
     * Integer representing the bitwise-OR of supported features for e-mails 
     * notification on this server. This property MUST NOT change after the 
     * Connection becomes CONNECTED. This property indicates the behavior and 
     * availability of the other properties and signals within this interface. 
     * A connection manager that cannot at least set one of the flags in the 
     * Mail_Notification_Flags SHOULD NOT provide this interface.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMailNotificationFlags() const
    {
        return internalRequestProperty(QLatin1String("MailNotificationFlags"));
    }

    /**
     * Asynchronous getter for the remote object property \c UnreadMailCount of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The number of unread messages in the Inbox. Change notification is
     *   via  \endhtmlonly UnreadMailsChanged() \htmlonly .</p>
     * 
     * <p>This property is only useful if <tt>Supports_Unread_Mail_Count</tt>
     *   is set in the  \endhtmlonly \link requestPropertyMailNotificationFlags() MailNotificationFlags \endlink \htmlonly ;
     *   otherwise, it MUST be zero.</p>
     * 
     * <p>If <tt>Thread_Based</tt> appears in the
     *    \endhtmlonly \link requestPropertyMailNotificationFlags() MailNotificationFlags \endlink \htmlonly , this property
     *   counts the number of threads, not the number of mails.</p>
     * 
     * <p>Note that this count MAY be bigger than the number of items in
     *    \endhtmlonly \link requestPropertyUnreadMails() UnreadMails \endlink \htmlonly . See
     *    \endhtmlonly \link requestPropertyUnreadMails() UnreadMails \endlink \htmlonly  for more details.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyUnreadMailCount() const
    {
        return internalRequestProperty(QLatin1String("UnreadMailCount"));
    }

    /**
     * Asynchronous getter for the remote object property \c UnreadMails of type \c Tp::MailList.
     *
     * 
     * An array of unread Mails. Change notification is via 
     * UnreadMailsChanged. This property is only useful if 
     * Supports_Unread_Mails is set in MailNotificationFlags; otherwise, it 
     * MUST be an empty list. The array size MAY be shorter than 
     * UnreadMailCount. Some servers may limits the amount of detailed e-mails 
     * sent. This can significantly reduce the network traffic for large 
     * inbox. For this reason, it is normal that UnreadMailCount be bigger or 
     * equal to the size of this array.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyUnreadMails() const
    {
        return internalRequestProperty(QLatin1String("UnreadMails"));
    }

    /**
     * Asynchronous getter for the remote object property \c MailAddress of type \c QString.
     *
     * 
     * A string representing the e-mail address of the account. The CMs MUST 
     * provide this information. In close integration of MailNotification with 
     * other e-mail services, the e-mail address can be used has a unique 
     * identifier for the account. Possible integration could be between 
     * Telepathy and Evolution where the e-mail address is the common 
     * information in both interfaces.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMailAddress() const
    {
        return internalRequestProperty(QLatin1String("MailAddress"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c RequestInboxURL on the remote object.
     * 
     * This method creates and returns a URL and an optional POST data that 
     * allow opening the Inbox folder of a webmail account. This URL MAY 
     * contain tokens with a short lifetime, so clients SHOULD request a new 
     * URL for each visit to the webmail interface. This method is implemented 
     * only if the Supports_Request_Inbox_URL flag is set in 
     * MailNotificationFlags. We are not using properties here because the 
     * tokens are unsuitable for sharing between clients, and network 
     * round-trips may be required to obtain the information that leads to 
     * authentication free webmail access.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A struture containing a URL and optional additional data to open a 
     *     webmail client, without re-authentication if possible.
     */
    inline QDBusPendingReply<Tp::MailURL> RequestInboxURL(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::MailURL>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestInboxURL"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestMailURL on the remote object.
     * 
     * This method creates and returns a URL and optional POST data that allow 
     * opening a specific mail in a webmail interface. This method is 
     * implemented only if Supports_Request_Mail_URL flag is set in 
     * MailNotificationFlags. See RequestInboxURL for design rationale.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param ID
     *     
     *     The mail&apos;s id as found in the Mail structure, or the empty 
     *     string if no id key was provided.
     *
     * \param URLData
     *     
     *     Whatever url-data was found in the Mail structure, or the boolean 
     *     value False (D-Bus type &apos;b&apos;) if no url-data was provided 
     *     in the Mail.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A struture that contains a URL and optional additional data to open 
     *     a webmail client, without re-authentication if possible.
     */
    inline QDBusPendingReply<Tp::MailURL> RequestMailURL(const QString& ID, const QDBusVariant& URLData, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::MailURL>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestMailURL"));
        callMessage << QVariant::fromValue(ID) << QVariant::fromValue(URLData);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c MailsReceived on the remote object.
     * 
     * Emitted when new e-mails messages arrive to the inbox associated with 
     * this connection. This signal is used for protocols that are not able to 
     * maintain the UnreadMails list, but do provide real-time notification 
     * about newly arrived e-mails. It MUST NOT be emitted unless 
     * Emits_Mails_Received is set in MailNotificationFlags.
     *
     * \param mails
     *     
     *     \htmlonly
     *     <p>An array of <tp:type>Mail</tp:type>s. Those e-mail MUST NOT have
     *       the "id" key.</p>
     *     
     *     <div class="rationale">
     *       <p>On connections that emit this signal, it's impossible to tell
     *         when a mail has been removed, and hence when "id" has become
     *         invalid.</p>
     *     </div>
     *     \endhtmlonly
     */
    void MailsReceived(const Tp::MailList& mails);

    /**
     * Represents the signal \c UnreadMailsChanged on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when  \endhtmlonly \link requestPropertyUnreadMails() UnreadMails \endlink \htmlonly  or
     *    \endhtmlonly \link requestPropertyUnreadMailCount() UnreadMailCount \endlink \htmlonly  have changed. It MUST
     *   NOT be emited if <tt>Supports_Unread_Mail_Count</tt> flag is not set
     *   in  \endhtmlonly \link requestPropertyMailNotificationFlags() MailNotificationFlags \endlink \htmlonly .</p>
     * 
     * <p><tt>Mails_Added</tt> and
     *   <tt>Mails_Removed</tt> MUST be empty if the
     *   <tt>Supports_Unread_Mails</tt> flag is not set.</p>
     * \endhtmlonly
     *
     * \param count
     *     
     *     Number of unread messages in the inbox (the new value of 
     *     UnreadMailCount).
     *
     * \param mailsAdded
     *     
     *     \htmlonly
     *     <p>A list of <tp:type>Mail</tp:type> that are being added or updated
     *       in  \endhtmlonly \link requestPropertyUnreadMails() UnreadMails \endlink \htmlonly .</p>
     *     
     *     <div class="rationale">
     *       <p>Mails may be updated when the URL information (URL and POST data)
     *         have changed, or senders were added or removed from an e-mail
     *         thread.</p>
     *     </div>
     *     
     *     <p>If the <tt>Supports_Unread_Mails</tt> flag is not set, this list
     *       MUST be empty, even if Count has increased.</p>
     *     \endhtmlonly
     *
     * \param mailsRemoved
     *     
     *     A list of e-mail IDs that are being removed from UnreadMails. If 
     *     the Supports_Unread_Mails flag is not set, this list MUST be empty, 
     *     even if Count has decreased.
     */
    void UnreadMailsChanged(uint count, const Tp::MailList& mailsAdded, const QStringList& mailsRemoved);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfacePowerSavingInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.PowerSaving".
 */
class TP_QT_EXPORT ConnectionInterfacePowerSavingInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.PowerSaving", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.PowerSaving");
    }

    /**
     * Creates a ConnectionInterfacePowerSavingInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfacePowerSavingInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfacePowerSavingInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfacePowerSavingInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfacePowerSavingInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfacePowerSavingInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfacePowerSavingInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfacePowerSavingInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfacePowerSavingInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfacePowerSavingInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c PowerSavingActive of type \c bool.
     *
     * 
     * \htmlonly
     * <p><code>True</code> if protocol-level power saving features are
     *   currently activated. This property can be changed using the
     *    \endhtmlonly SetPowerSaving() \htmlonly  method; change
     *   notifications is via the
     *    \endhtmlonly PowerSavingChanged() \htmlonly  signal.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyPowerSavingActive() const
    {
        return internalRequestProperty(QLatin1String("PowerSavingActive"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c SetPowerSaving on the remote object.
     * 
     * \htmlonly
     * <p>Turn power saving mode on or off.</p>
     * 
     * <div class="rationale">
     *   <p>Depending on the device's activity level, the
     *     connection can have its power saving mode turned on or off.</p>
     * </div>
     * 
     * <p>Errors raised by this method indicate that power saving could not be
     *   enabled, which SHOULD NOT generally be treated as fatal.</p>
     * 
     * <div class="rationale">
     *   If the CM cannot switch modes, either because of the
     *   protocol (<code>NotImplemented</code>), or because of the service
     *   (<code>NotAvailable</code>), Mission Control (or whoever manages this)
     *   should be made aware. The error could be ignored or, in the extreme,
     *   be fascist and disconnect the account.
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param activate
     *     
     *     True if protocol-level power saving features should be activated; 
     *     False if they should be de-activated.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetPowerSaving(bool activate, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetPowerSaving"));
        callMessage << QVariant::fromValue(activate);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c PowerSavingChanged on the remote object.
     * 
     * \htmlonly
     * The  \endhtmlonly \link requestPropertyPowerSavingActive() PowerSavingActive \endlink \htmlonly 
     * property changed.
     * \endhtmlonly
     *
     * \param active
     *     
     *     The new state of the power saving feature.
     */
    void PowerSavingChanged(bool active);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfacePresenceInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Presence".
 */
class TP_QT_EXPORT ConnectionInterfacePresenceInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.Presence", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Presence");
    }

    /**
     * Creates a ConnectionInterfacePresenceInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfacePresenceInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfacePresenceInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfacePresenceInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfacePresenceInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfacePresenceInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfacePresenceInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfacePresenceInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfacePresenceInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfacePresenceInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c AddStatus on the remote object.
     * 
     * Request that a single presence status is published for the user, along 
     * with any desired parameters. Changes will be indicated by 
     * PresenceUpdate signals being emitted.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param status
     *     
     *     The string identifier of the desired status
     *
     * \param parameters
     *     
     *     A dictionary of optional parameter names mapped to their 
     *     variant-boxed values
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AddStatus(const QString& status, const QVariantMap& parameters, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AddStatus"));
        callMessage << QVariant::fromValue(status) << QVariant::fromValue(parameters);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ClearStatus on the remote object.
     * 
     * Request that all of a user&apos;s presence statuses be removed. Be 
     * aware that this request may simply result in the statuses being 
     * replaced by a default available status. Changes will be indicated by 
     * PresenceUpdate signals being emitted.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> ClearStatus(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ClearStatus"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetPresence on the remote object.
     * 
     * Get presence previously emitted by PresenceUpdate for the given 
     * contacts. Data is returned in the same structure as the PresenceUpdate 
     * signal. Using this method in favour of RequestPresence has the 
     * advantage that it will not wake up each client connected to the 
     * PresenceUpdate signal.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     An array of the contacts whose presence should be obtained
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     Presence information in the same format as for the PresenceUpdate 
     *     signal
     */
    inline QDBusPendingReply<Tp::ContactPresences> GetPresence(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ContactPresences>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetPresence"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetStatuses on the remote object.
     * 
     * Get a dictionary of the valid presence statuses for this connection. 
     * This is only available when online because only some statuses will be 
     * available on some servers.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A dictionary of string identifiers mapped to a struct for each 
     *     status, containing: a type value from one of the values above a 
     *     boolean to indicate if this status may be set on yourself a boolean 
     *     to indicate if this is an exclusive status which you may not set 
     *     alongside any other a dictionary of valid optional string argument 
     *     names mapped to their types
     */
    inline QDBusPendingReply<Tp::StatusSpecMap> GetStatuses(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::StatusSpecMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetStatuses"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RemoveStatus on the remote object.
     * 
     * Request that the given presence status is no longer published for the 
     * user. Changes will be indicated by PresenceUpdate signals being 
     * emitted. As with ClearStatus, removing a status may actually result in 
     * it being replaced by a default available status.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param status
     *     
     *     The string identifier of the status not to publish anymore for the 
     *     user
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RemoveStatus(const QString& status, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RemoveStatus"));
        callMessage << QVariant::fromValue(status);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestPresence on the remote object.
     * 
     * Request the presence for contacts on this connection. A PresenceUpdate 
     * signal will be emitted when they are received. This is not the same as 
     * subscribing to the presence of a contact, which must be done using the 
     * &apos;subscription&apos; ContactList, and on some protocols presence 
     * information may not be available unless a subscription exists.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     An array of the contacts whose presence should be obtained
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RequestPresence(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestPresence"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetLastActivityTime on the remote object.
     * 
     * Request that the recorded last activity time for the user be updated on 
     * the server.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param time
     *     
     *     A UNIX timestamp of the user&apos;s last activity time (in UTC)
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetLastActivityTime(uint time, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetLastActivityTime"));
        callMessage << QVariant::fromValue(time);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetStatus on the remote object.
     * 
     * \htmlonly
     * <p>Request that the user's presence be changed to the given statuses
     *   and desired parameters. Changes will be reflected by
     *    \endhtmlonly PresenceUpdate() \htmlonly 
     *   signals being emitted.</p>
     * 
     * <p>Statuses whose <tp:type>Connection_Presence_Type</tp:type>
     *   is Offline, Error or Unknown MUST NOT be passed to this
     *   function. Connection managers SHOULD reject these statuses.</p>
     * 
     * <div class="rationale">
     *   <p>The same rationale as for  \endhtmlonly ConnectionInterfaceSimplePresenceInterface::SetPresence() \htmlonly 
     *     applies.</p>
     * </div>
     * 
     * <p>On certain protocols, this method may be
     *   called on a newly-created connection which is still in the
     *   DISCONNECTED state, and will sign on with the requested status.
     *   If the requested status is not available after signing on,
     *   NotAvailable will be returned and the connection will remain
     *   offline, or if the protocol does not support signing on with
     *   a certain status, Disconnected will be returned.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param statuses
     *     
     *     A dictionary mapping status identifiers to dictionaries, which map 
     *     optional parameter names to their variant-boxed values
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetStatus(const Tp::MultipleStatusMap& statuses, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetStatus"));
        callMessage << QVariant::fromValue(statuses);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c PresenceUpdate on the remote object.
     * 
     * This signal should be emitted when your own presence has been changed, 
     * or the presence of the member of any of the connection&apos;s channels 
     * has been changed, or when the presence requested by RequestPresence is 
     * available.
     *
     * \param presence
     *     
     *     A dictionary of contact handles mapped to a struct containing a 
     *     UNIX timestamp of the last activity time (in UTC), and a dictionary 
     *     mapping the contact&apos;s current status identifiers to a 
     *     dictionary of optional parameter names mapped to their 
     *     variant-boxed values
     */
    void PresenceUpdate(const Tp::ContactPresences& presence);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceRequestsInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Requests".
 */
class TP_QT_EXPORT ConnectionInterfaceRequestsInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.Requests", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Requests");
    }

    /**
     * Creates a ConnectionInterfaceRequestsInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceRequestsInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceRequestsInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceRequestsInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceRequestsInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceRequestsInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceRequestsInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceRequestsInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceRequestsInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceRequestsInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Channels of type \c Tp::ChannelDetailsList.
     *
     * 
     * A list of all the channels which currently exist on this connection. 
     * Change notification is via the NewChannels and ChannelClosed signals.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyChannels() const
    {
        return internalRequestProperty(QLatin1String("Channels"));
    }

    /**
     * Asynchronous getter for the remote object property \c RequestableChannelClasses of type \c Tp::RequestableChannelClassList.
     *
     * 
     * \htmlonly
     * <p>The classes of channel that are expected to be available on this
     *   connection, i.e. those for which
     *    \endhtmlonly CreateChannel() \htmlonly  can reasonably
     *   be expected to succeed. User interfaces can use this information
     *   to show or hide UI components.</p>
     * 
     * <p>This property cannot change after the connection has gone to
     *   state Connection_Status_Connected, so there is no change
     *   notification (if the connection has context-dependent capabilities,
     *   it SHOULD advertise support for all classes of channel that it might
     *   support during its lifetime). Before this state has been reached,
     *   the value of this property is undefined.</p>
     * 
     * <div class="rationale">
     *   <p>This is not on an optional interface, because connection
     *     managers can always offer some sort of clue about the channel
     *     classes they expect to support (at worst, they can announce
     *     support for everything for which they have code).</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRequestableChannelClasses() const
    {
        return internalRequestProperty(QLatin1String("RequestableChannelClasses"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c CreateChannel on the remote object.
     * 
     * \htmlonly
     * <p>Request that an entirely new channel is created.</p>
     * 
     * <div class="rationale">
     *   <p>There is deliberately no flag corresponding to the
     *     suppress_handler argument to
     *      \endhtmlonly ConnectionInterface::RequestChannel() \htmlonly ,
     *     because passing a FALSE value for that argument is deprecated.
     *     Requests made using this interface always behave as though
     *     suppress_handler was TRUE.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param request
     *     
     *     \htmlonly
     *     <p>A dictionary containing desirable properties, which MUST include
     *        \endhtmlonly \link ChannelInterface::requestPropertyChannelType() ChannelInterface::ChannelType \endlink \htmlonly .
     *       Some properties
     *       are defined such that only an exact match makes sense, and
     *       connection managers MUST NOT satisfy a request with a channel
     *       where that property does not match; some properties are defined
     *       such that the connection manager MAY treat the request as merely
     *       a hint, and make a best-effort attempt to satisfy it. This is
     *       documented separately for each property.</p>
     *     
     *     <p>If this dictionary contains a property whose semantics
     *       are not known to the connection manager, this method MUST fail
     *       without side-effects (in particular it must not create a new
     *       channel).</p>
     *     
     *     <div class="rationale">
     *       <p>This is necessary if we want to be able to invent properties
     *         in future that, when used in a request, are hard requirements
     *         rather than just hints. A connection manager that did not know
     *         the semantics of those properties could incorrectly return a
     *         new channel that did not satisfy the requirements.</p>
     *     </div>
     *     
     *     <p>The connection manager MUST NOT respond successfully,
     *       and SHOULD NOT create a new channel or cause any other
     *       side-effects, unless it can create a new channel that satisfies
     *       the client's requirements.</p>
     *     
     *     <p>Properties that will be set by this argument need not have write
     *       access after the channel has been created - indeed, it is
     *       expected that most will be read-only.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>The Channel object, which MUST NOT be signalled with
     *        \endhtmlonly NewChannels() \htmlonly  until after this method
     *       returns.</p>
     *     
     *     <div class="rationale">
     *       <p>This allows the requester to alter its handling of
     *         NewChannels by knowing whether one of the channels satisfied
     *         a request it made.</p>
     *     </div>
     *     \endhtmlonly
     *
     * \return
     *     
     *     \htmlonly
     *     <p>Properties of the channel that was produced, equivalent to
     *       the properties in <tp:type>Channel_Details</tp:type>.
     *       Connection managers MUST NOT include properties here whose
     *       values can change, for the same reasons as in
     *       <tp:type>Channel_Details</tp:type>.</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<QDBusObjectPath, QVariantMap> CreateChannel(const QVariantMap& request, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusObjectPath, QVariantMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("CreateChannel"));
        callMessage << QVariant::fromValue(request);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c EnsureChannel on the remote object.
     * 
     * \htmlonly
     * <p>Request that channels are ensured to exist.</p>
     * 
     * <div class="rationale">
     *   <p>The connection manager is in the best position to determine which
     *     existing channels could satisfy which requests.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param request
     *     
     *     \htmlonly
     *     <p>A dictionary containing desirable properties, with the same
     *       semantics as the corresponding parameter to
     *        \endhtmlonly CreateChannel() \htmlonly .</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>If false, the caller of EnsureChannel MUST assume that some
     *       other process is handling this channel; if true, the caller of
     *       EnsureChannel SHOULD handle it themselves or delegate it to another
     *       client.</p>
     *     
     *     <p>If the creation of a channel makes several calls to EnsureChannel
     *       (and no other requests) successful, exactly one of those calls MUST
     *       return a true value for this argument.</p>
     *     
     *     <p>If the creation of a channel makes other requests successful,
     *       the value returned for this argument MUST be such that exactly
     *       one of the clients making requests ends up responsible for the
     *       channel. In particular, if
     *        \endhtmlonly CreateChannel() \htmlonly  returns a channel
     *       <em>C</em>, any EnsureChannel calls that also return <em>C</em>
     *       MUST return a false value for this argument.</p>
     *     \endhtmlonly
     *
     * \return
     *     
     *     The Channel object. If it was created as a result of this method 
     *     call, it MUST NOT be signalled by NewChannels until after this 
     *     method returns. This allows the requester to alter its handling of 
     *     NewChannels by knowing whether one of the channels satisfied a 
     *     request it made.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>Properties of the channel that was produced, equivalent to
     *       the properties in <tp:type>Channel_Details</tp:type>.
     *       Connection managers MUST NOT include properties here whose
     *       values can change, for the same reasons as in
     *       <tp:type>Channel_Details</tp:type>.</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<bool, QDBusObjectPath, QVariantMap> EnsureChannel(const QVariantMap& request, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<bool, QDBusObjectPath, QVariantMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("EnsureChannel"));
        callMessage << QVariant::fromValue(request);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c NewChannels on the remote object.
     * 
     * \htmlonly
     * <p>New channels have been created. The connection manager SHOULD emit
     *   a single signal for any group of closely related channels that are
     *   created at the same time, so that the channel dispatcher can try to
     *   dispatch them to a handler as a unit.</p>
     * 
     * <p>In particular, if additional channels are created as a side-effect
     *   of a call to  \endhtmlonly CreateChannel() \htmlonly ,
     *   these channels SHOULD appear in the same NewChannels signal as
     *   the channel that satisfies the request.</p>
     * 
     * <div class="rationale">
     *   <p>Joining a MUC Tube in XMPP requires joining the corresponding
     *     MUC (chatroom), so a  \endhtmlonly ChannelTypeTextInterface \htmlonly 
     *     channel can be created as a side-effect.</p>
     * </div>
     * 
     * <p>Every time NewChannels is emitted, it MUST be followed by
     *   a  \endhtmlonly ConnectionInterface::NewChannel() \htmlonly 
     *   signal for each channel.</p>
     * 
     * <div class="rationale">
     *   <p>The double signal emission is for the benefit of older Telepathy
     *     clients, which won't be listening for NewChannels.</p>
     * 
     *   <p>The more informative NewChannels signal comes first so that
     *     clients that did not examine the connection to find
     *     out whether Requests is supported will see the more informative
     *     signal for each channel first, and then ignore the less
     *     informative signal because it announces a new channel of which
     *     they are already aware.</p>
     * </div>
     * \endhtmlonly
     *
     * \param channels
     *     
     *     The channels and their details. All channels that are signalled 
     *     together like this MUST have the same Bundle property, which may 
     *     either refer to an existing bundle, or establish a new bundle.
     */
    void NewChannels(const Tp::ChannelDetailsList& channels);

    /**
     * Represents the signal \c ChannelClosed on the remote object.
     * 
     * Emitted when a channel is closed and hence disappears from the Channels 
     * property. This is redundant with the Closed signal on the channel 
     * itself, but it does provide full change notification for the Channels 
     * property.
     *
     * \param removed
     *     
     *     The channel which has been removed from the Channels property
     */
    void ChannelClosed(const QDBusObjectPath& removed);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceServicePointInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ServicePoint".
 */
class TP_QT_EXPORT ConnectionInterfaceServicePointInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.ServicePoint", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ServicePoint");
    }

    /**
     * Creates a ConnectionInterfaceServicePointInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceServicePointInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceServicePointInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceServicePointInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceServicePointInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceServicePointInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceServicePointInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceServicePointInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceServicePointInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceServicePointInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c KnownServicePoints of type \c Tp::ServicePointInfoList.
     *
     * 
     * \htmlonly
     * The list of all (known) service points.
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyKnownServicePoints() const
    {
        return internalRequestProperty(QLatin1String("KnownServicePoints"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

Q_SIGNALS:
    /**
     * Represents the signal \c ServicePointsChanged on the remote object.
     * 
     * Emitted when the list of known service points (or their IDs) has 
     * changed.
     *
     * \param servicePoints
     *     
     *     \htmlonly
     *     <p>The new value of
     *        \endhtmlonly \link requestPropertyKnownServicePoints() KnownServicePoints \endlink \htmlonly .</p>
     *     \endhtmlonly
     */
    void ServicePointsChanged(const Tp::ServicePointInfoList& servicePoints);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ConnectionInterfaceSimplePresenceInterface
 * \headerfile TelepathyQt/connection.h <TelepathyQt/Connection>
 * \ingroup clientconn
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.SimplePresence".
 */
class TP_QT_EXPORT ConnectionInterfaceSimplePresenceInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Connection.Interface.SimplePresence", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Connection.Interface.SimplePresence");
    }

    /**
     * Creates a ConnectionInterfaceSimplePresenceInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceSimplePresenceInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceSimplePresenceInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceSimplePresenceInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ConnectionInterfaceSimplePresenceInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ConnectionInterfaceSimplePresenceInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ConnectionInterfaceSimplePresenceInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ConnectionInterfaceSimplePresenceInterface(const Tp::Client::ConnectionInterface& mainInterface);

    /**
     * Creates a ConnectionInterfaceSimplePresenceInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ConnectionInterfaceSimplePresenceInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Statuses of type \c Tp::SimpleStatusSpecMap.
     *
     * 
     * \htmlonly
     * <p>A dictionary where the keys are the presence statuses that are
     *   available on this connection, and the values are the corresponding
     *   presence types.</p>
     * 
     * <p>While the connection is in the DISCONNECTED state, it contains
     *   the set of presence statuses allowed to be set before connecting.
     *   The connection manager will attempt to set the appropriate status
     *   when the connection becomes connected, but cannot necessarily
     *   guarantee it. The available statuses cannot change until the
     *   connection status changes, so there is no change notification.</p>
     * 
     * <p>While the connection is in the CONNECTED state, this property
     *   contains the set of presence statuses which are actually available
     *   on this protocol. This set is constant for the remaining lifetime
     *   of the connection, so again, there is no change notification.</p>
     * 
     * <p>While the connection is in the CONNECTING state, the value of
     *   this property is undefined and SHOULD NOT be used. It can change
     *   at any time without notification (in particular, any cached values
     *   from when the connection was in the DISCONNECTED or CONNECTING
     *   state MUST NOT be assumed to still be correct when the state has
     *   become CONNECTED).</p>
     * 
     * <p>This property MUST include the special statuses "unknown" and
     *   "error" if and only if the connection manager can emit them
     *   as a contact's status.</p>
     * 
     * <div class="rationale">
     *   For instance, connection managers for local-xmpp (XEP-0174) would
     *   omit "unknown" since there is no such concept.
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyStatuses() const
    {
        return internalRequestProperty(QLatin1String("Statuses"));
    }

    /**
     * Asynchronous getter for the remote object property \c MaximumStatusMessageLength of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The maximum length in characters for any individual status
     *   message, or 0 if there is no limit.</p>
     * 
     * <p>While the connection is in the DISCONNECTED state, this property will
     *   be 0. The connection manager will attempt to set the appropriate value
     *   when the connection becomes connected, but cannot necessarily
     *   guarantee it. The maximum length cannot change until the
     *   connection status changes, so there is no change notification.</p>
     * 
     * <p>While the connection is in the CONNECTED state, this property
     *   contains the maximum length in characters for any individual status
     *   message which is actually allowed on this protocol.
     *   This value is constant for the remaining lifetime
     *   of the connection, so again, there is no change notification.</p>
     * 
     * <p>While the connection is in the CONNECTING state, the value of
     *   this property is undefined and SHOULD NOT be used. It can change
     *   at any time without notification (in particular, any cached values
     *   from when the connection was in the DISCONNECTED or CONNECTING
     *   state MUST NOT be assumed to still be correct when the state has
     *   become CONNECTED).</p>
     * 
     * <p>If a message passed to  \endhtmlonly SetPresence() \htmlonly  is
     *   longer than allowed by this property, the connection manager MUST
     *   truncate the supplied message; when emitting
     *    \endhtmlonly PresencesChanged() \htmlonly , the truncated version
     *   of the message MUST be used.</p>
     * 
     * <div class="rationale">
     *   <p>Some XMPP servers, like Google Talk, define a maximum length for
     *   status messages. Whether the user's server is one of
     *   these cannot be detected until quite late in the connection
     *   process.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMaximumStatusMessageLength() const
    {
        return internalRequestProperty(QLatin1String("MaximumStatusMessageLength"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c SetPresence on the remote object.
     * 
     * \htmlonly
     * <p>Request that the presence status and status message are published for
     *   the connection.  Changes will be indicated by
     *    \endhtmlonly PresencesChanged() \htmlonly 
     *   signals being emitted.</p>
     * 
     * <p>This method may be called on a newly-created connection while it
     *   is still in the DISCONNECTED state, to request that when the
     *   connection connects, it will do so with the selected status.</p>
     * 
     * <p>In DISCONNECTED state the
     *    \endhtmlonly \link requestPropertyStatuses() Statuses \endlink \htmlonly 
     *   property will indicate which statuses are allowed to be set
     *   while DISCONNECTED (none, if the Connection Manager doesn't allow
     *   this). This value MUST NOT be cached, as the set of allowed
     *   presences might change upon connecting.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param status
     *     
     *     \htmlonly
     *     <p>The string identifier of the desired status. Possible status
     *       identifiers are defined in the
     *        \endhtmlonly \link requestPropertyStatuses() Statuses \endlink \htmlonly  property.</p>
     *     
     *     <p>Clients MUST NOT set a status whose string value they do not
     *       recognise, even if its presence type in Statuses
     *       matches what the user requested.</p>
     *     
     *     <div class="rationale">
     *       <p>Suppose a protocol has statuses that include 'phone' (of type
     *         BUSY) and 'in-a-meeting' (of type BUSY), but there is no
     *         generic 'busy' status.</p>
     *     
     *       <p>If the user requests "Busy" status from a menu, a
     *         client author might be tempted to pick an arbitrary status
     *         that has type BUSY. However, on this protocol, neither of
     *         the choices would be appropriate, and incorrect information
     *         about the user would be conveyed.</p>
     *     </div>
     *     
     *     <p>Statuses whose <tp:type>Connection_Presence_Type</tp:type>
     *       is Offline, Error or Unknown MUST NOT be passed to this
     *       function. Connection managers SHOULD reject these statuses.</p>
     *     
     *     <div class="rationale">
     *       <p>To go offline, call  \endhtmlonly ConnectionInterface::Disconnect() \htmlonly 
     *       instead. The "error" and "unknown" statuses make no sense.</p>
     *     </div>
     *     \endhtmlonly
     *
     * \param statusMessage
     *     
     *     The status message associated with the current status.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetPresence(const QString& status, const QString& statusMessage, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetPresence"));
        callMessage << QVariant::fromValue(status) << QVariant::fromValue(statusMessage);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetPresences on the remote object.
     * 
     * Get presence previously emitted by PresencesChanged for the given 
     * contacts. Data is returned in the same structure as the 
     * PresencesChanged signal; no additional network requests are made.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     An array of the contacts whose presence should be obtained.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>Presence information in the same format as for the
     *        \endhtmlonly PresencesChanged() \htmlonly  signal.
     *       The returned mapping MUST include an entry for each contact
     *       in the method's argument.</p>
     *     
     *     <p>The definition of the connection presence types Unknown
     *       and Offline means that if a connection manager will return
     *       Unknown for contacts not on the subscribe list, it MUST delay
     *       the reply to this method call until it has found out which
     *       contacts are, in fact, on the subscribe list.</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::SimpleContactPresences> GetPresences(const Tp::UIntList& contacts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::SimpleContactPresences>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetPresences"));
        callMessage << QVariant::fromValue(contacts);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c PresencesChanged on the remote object.
     * 
     * This signal should be emitted when your own presence has been changed, 
     * or the presence of the member of any of the connection&apos;s channels 
     * has been changed.
     *
     * \param presence
     *     
     *     A dictionary of contact handles mapped to the status, presence type 
     *     and status message.
     */
    void PresencesChanged(const Tp::SimpleContactPresences& presence);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceAddressingInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceAliasingInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceAnonymityInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceAvatarsInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceBalanceInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceCapabilitiesInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceCellularInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceClientTypesInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceContactBlockingInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceContactCapabilitiesInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceContactGroupsInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceContactInfoInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceContactListInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceContactsInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceLocationInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceMailNotificationInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfacePowerSavingInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfacePresenceInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceRequestsInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceServicePointInterface*)
Q_DECLARE_METATYPE(Tp::Client::ConnectionInterfaceSimplePresenceInterface*)
