/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_ARM64_H
#define VATOMIC_ARM64_H
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */

#if !defined(VATOMIC_DISABLE_POLITE_AWAIT)
    #define vatomic_cpu_pause() __asm__ volatile("yield" ::: "memory")
#endif

/*******************************************************************************
 * options
 ******************************************************************************/
#if defined(__ARM_FEATURE_ATOMICS) && !defined(VATOMIC_DISABLE_ARM64_LSE)
    #if defined(VATOMIC_ENABLE_ARM64_LXE)
        #define VATOMIC_ARM64_LXE
        #include "arm64_lxe.h"
    #else
        #define VATOMIC_ARM64_LSE
        #include "arm64_lse.h"
    #endif
#endif

#if !defined(VATOMIC_ARM64_LSE) && !defined(VATOMIC_ARM64_LXE)
    #define VATOMIC_ARM64_LLSC
    #include "arm64_llsc.h"
#endif

#ifndef VATOMIC_FENCE
    #define VATOMIC_FENCE
static inline void
vatomic_fence(void)
{
    __asm__ volatile("dmb ish" ::: "memory");
}
#endif
#ifndef VATOMIC_FENCE_ACQ
    #define VATOMIC_FENCE_ACQ
static inline void
vatomic_fence_acq(void)
{
    __asm__ volatile("dmb ishld" ::: "memory");
}
#endif
#ifndef VATOMIC_FENCE_REL
    #define VATOMIC_FENCE_REL
static inline void
vatomic_fence_rel(void)
{
    __asm__ volatile("dmb ish" ::: "memory");
}
#endif
#ifndef VATOMIC_FENCE_RLX
    #define VATOMIC_FENCE_RLX
static inline void
vatomic_fence_rlx(void)
{
    __asm__ volatile(V_FENCE_RLX_INSTRUCTION::: "memory");
}
#endif
/******************************************************************************
 * vatomic32_read
 ******************************************************************************/
#ifndef VATOMIC32_READ
    #define VATOMIC32_READ
static inline vuint32_t
vatomic32_read(const vatomic32_t *a)
{
    vuint32_t val;
    __asm__ volatile("ldar %w[v], %[a]"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic32_read_acq
 ******************************************************************************/
#ifndef VATOMIC32_READ_ACQ
    #define VATOMIC32_READ_ACQ
static inline vuint32_t
vatomic32_read_acq(const vatomic32_t *a)
{
    vuint32_t val;
    __asm__ volatile("ldar %w[v], %[a]"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic32_read_rlx
 ******************************************************************************/
#ifndef VATOMIC32_READ_RLX
    #define VATOMIC32_READ_RLX
static inline vuint32_t
vatomic32_read_rlx(const vatomic32_t *a)
{
    vuint32_t val;
    __asm__ volatile("ldr %w[v], %[a]"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic64_read
 ******************************************************************************/
#ifndef VATOMIC64_READ
    #define VATOMIC64_READ
static inline vuint64_t
vatomic64_read(const vatomic64_t *a)
{
    vuint64_t val;
    __asm__ volatile("ldar %x[v], %[a]"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic64_read_acq
 ******************************************************************************/
#ifndef VATOMIC64_READ_ACQ
    #define VATOMIC64_READ_ACQ
static inline vuint64_t
vatomic64_read_acq(const vatomic64_t *a)
{
    vuint64_t val;
    __asm__ volatile("ldar %x[v], %[a]"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic64_read_rlx
 ******************************************************************************/
#ifndef VATOMIC64_READ_RLX
    #define VATOMIC64_READ_RLX
static inline vuint64_t
vatomic64_read_rlx(const vatomic64_t *a)
{
    vuint64_t val;
    __asm__ volatile("ldr %x[v], %[a]"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomicptr_read
 ******************************************************************************/
#ifndef VATOMICPTR_READ
    #define VATOMICPTR_READ
static inline void *
vatomicptr_read(const vatomicptr_t *a)
{
    void *val;
    __asm__ volatile("ldar %x[v], %[a]"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomicptr_read_acq
 ******************************************************************************/
#ifndef VATOMICPTR_READ_ACQ
    #define VATOMICPTR_READ_ACQ
static inline void *
vatomicptr_read_acq(const vatomicptr_t *a)
{
    void *val;
    __asm__ volatile("ldar %x[v], %[a]"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomicptr_read_rlx
 ******************************************************************************/
#ifndef VATOMICPTR_READ_RLX
    #define VATOMICPTR_READ_RLX
static inline void *
vatomicptr_read_rlx(const vatomicptr_t *a)
{
    void *val;
    __asm__ volatile("ldr %x[v], %[a]"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic32_write
 ******************************************************************************/
#ifndef VATOMIC32_WRITE
    #define VATOMIC32_WRITE
static inline void
vatomic32_write(vatomic32_t *a, vuint32_t v)
{
    __asm__ volatile("stlr %w[v], %[a]"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomic32_write_rel
 ******************************************************************************/
#ifndef VATOMIC32_WRITE_REL
    #define VATOMIC32_WRITE_REL
static inline void
vatomic32_write_rel(vatomic32_t *a, vuint32_t v)
{
    __asm__ volatile("stlr %w[v], %[a]"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomic32_write_rlx
 ******************************************************************************/
#ifndef VATOMIC32_WRITE_RLX
    #define VATOMIC32_WRITE_RLX
static inline void
vatomic32_write_rlx(vatomic32_t *a, vuint32_t v)
{
    __asm__ volatile("str %w[v], %[a]"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomic64_write
 ******************************************************************************/
#ifndef VATOMIC64_WRITE
    #define VATOMIC64_WRITE
static inline void
vatomic64_write(vatomic64_t *a, vuint64_t v)
{
    __asm__ volatile("stlr %x[v], %[a]"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomic64_write_rel
 ******************************************************************************/
#ifndef VATOMIC64_WRITE_REL
    #define VATOMIC64_WRITE_REL
static inline void
vatomic64_write_rel(vatomic64_t *a, vuint64_t v)
{
    __asm__ volatile("stlr %x[v], %[a]"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomic64_write_rlx
 ******************************************************************************/
#ifndef VATOMIC64_WRITE_RLX
    #define VATOMIC64_WRITE_RLX
static inline void
vatomic64_write_rlx(vatomic64_t *a, vuint64_t v)
{
    __asm__ volatile("str %x[v], %[a]"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomicptr_write
 ******************************************************************************/
#ifndef VATOMICPTR_WRITE
    #define VATOMICPTR_WRITE
static inline void
vatomicptr_write(vatomicptr_t *a, void *v)
{
    __asm__ volatile("stlr %x[v], %[a]"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomicptr_write_rel
 ******************************************************************************/
#ifndef VATOMICPTR_WRITE_REL
    #define VATOMICPTR_WRITE_REL
static inline void
vatomicptr_write_rel(vatomicptr_t *a, void *v)
{
    __asm__ volatile("stlr %x[v], %[a]"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomicptr_write_rlx
 ******************************************************************************/
#ifndef VATOMICPTR_WRITE_RLX
    #define VATOMICPTR_WRITE_RLX
static inline void
vatomicptr_write_rlx(vatomicptr_t *a, void *v)
{
    __asm__ volatile("str %x[v], %[a]"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomic32_await_eq
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_EQ
    #define VATOMIC32_AWAIT_EQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_eq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ne 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_eq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.eq 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.ne 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_neq
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_NEQ
    #define VATOMIC32_AWAIT_NEQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_neq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.eq 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_neq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ne 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.eq 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_lt
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_LT
    #define VATOMIC32_AWAIT_LT
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_lt(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hs 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_lt(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.lo 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.hs 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_le
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_LE
    #define VATOMIC32_AWAIT_LE
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_le(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hi 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_le(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ls 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.hi 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_gt
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_GT
    #define VATOMIC32_AWAIT_GT
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_gt(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ls 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_gt(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hi 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.ls 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_ge
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_GE
    #define VATOMIC32_AWAIT_GE
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_ge(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.lo 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_ge(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hs 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.lo 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_eq_acq
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_EQ_ACQ
    #define VATOMIC32_AWAIT_EQ_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_eq_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ne 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_eq_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.eq 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.ne 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_neq_acq
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_NEQ_ACQ
    #define VATOMIC32_AWAIT_NEQ_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_neq_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.eq 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_neq_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ne 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.eq 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_lt_acq
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_LT_ACQ
    #define VATOMIC32_AWAIT_LT_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_lt_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hs 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_lt_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.lo 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.hs 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_le_acq
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_LE_ACQ
    #define VATOMIC32_AWAIT_LE_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_le_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hi 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_le_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ls 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.hi 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_gt_acq
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_GT_ACQ
    #define VATOMIC32_AWAIT_GT_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_gt_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ls 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_gt_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hi 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.ls 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_ge_acq
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_GE_ACQ
    #define VATOMIC32_AWAIT_GE_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_ge_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.lo 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_ge_acq(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldar %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hs 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.lo 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_eq_rlx
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_EQ_RLX
    #define VATOMIC32_AWAIT_EQ_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_eq_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ne 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_eq_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.eq 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.ne 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_neq_rlx
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_NEQ_RLX
    #define VATOMIC32_AWAIT_NEQ_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_neq_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.eq 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_neq_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ne 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.eq 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_lt_rlx
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_LT_RLX
    #define VATOMIC32_AWAIT_LT_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_lt_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hs 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_lt_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.lo 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.hs 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_le_rlx
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_LE_RLX
    #define VATOMIC32_AWAIT_LE_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_le_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hi 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_le_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ls 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.hi 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_gt_rlx
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_GT_RLX
    #define VATOMIC32_AWAIT_GT_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_gt_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.ls 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_gt_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hi 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.ls 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic32_await_ge_rlx
 ******************************************************************************/
#ifndef VATOMIC32_AWAIT_GE_RLX
    #define VATOMIC32_AWAIT_GE_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint32_t
vatomic32_await_ge_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.lo 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint32_t
vatomic32_await_ge_rlx(const vatomic32_t *a, vuint32_t v)
{
    vuint32_t val;
    __asm__ volatile(
        "ldr %w[val], %[a]\n"
        "cmp %w[val], %w[exp]\n"
        "b.hs 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %w[val], %[a]\n"
        "cmp %w[val],  %w[exp]\n"
        "b.lo 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_eq
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_EQ
    #define VATOMIC64_AWAIT_EQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_eq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_eq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.ne 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_neq
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_NEQ
    #define VATOMIC64_AWAIT_NEQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_neq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_neq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.eq 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_lt
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_LT
    #define VATOMIC64_AWAIT_LT
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_lt(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hs 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_lt(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.lo 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.hs 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_le
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_LE
    #define VATOMIC64_AWAIT_LE
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_le(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hi 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_le(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ls 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.hi 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_gt
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_GT
    #define VATOMIC64_AWAIT_GT
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_gt(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ls 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_gt(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hi 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.ls 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_ge
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_GE
    #define VATOMIC64_AWAIT_GE
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_ge(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.lo 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_ge(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hs 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.lo 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_eq_acq
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_EQ_ACQ
    #define VATOMIC64_AWAIT_EQ_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_eq_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_eq_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.ne 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_neq_acq
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_NEQ_ACQ
    #define VATOMIC64_AWAIT_NEQ_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_neq_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_neq_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.eq 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_lt_acq
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_LT_ACQ
    #define VATOMIC64_AWAIT_LT_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_lt_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hs 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_lt_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.lo 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.hs 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_le_acq
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_LE_ACQ
    #define VATOMIC64_AWAIT_LE_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_le_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hi 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_le_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ls 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.hi 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_gt_acq
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_GT_ACQ
    #define VATOMIC64_AWAIT_GT_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_gt_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ls 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_gt_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hi 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.ls 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_ge_acq
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_GE_ACQ
    #define VATOMIC64_AWAIT_GE_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_ge_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.lo 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_ge_acq(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hs 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.lo 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_eq_rlx
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_EQ_RLX
    #define VATOMIC64_AWAIT_EQ_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_eq_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_eq_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.ne 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_neq_rlx
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_NEQ_RLX
    #define VATOMIC64_AWAIT_NEQ_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_neq_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_neq_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.eq 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_lt_rlx
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_LT_RLX
    #define VATOMIC64_AWAIT_LT_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_lt_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hs 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_lt_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.lo 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.hs 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_le_rlx
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_LE_RLX
    #define VATOMIC64_AWAIT_LE_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_le_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hi 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_le_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ls 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.hi 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_gt_rlx
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_GT_RLX
    #define VATOMIC64_AWAIT_GT_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_gt_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ls 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_gt_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hi 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.ls 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomic64_await_ge_rlx
 ******************************************************************************/
#ifndef VATOMIC64_AWAIT_GE_RLX
    #define VATOMIC64_AWAIT_GE_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline vuint64_t
vatomic64_await_ge_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "1:\n"
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.lo 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline vuint64_t
vatomic64_await_ge_rlx(const vatomic64_t *a, vuint64_t v)
{
    vuint64_t val;
    __asm__ volatile(
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.hs 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.lo 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomicptr_await_eq
 ******************************************************************************/
#ifndef VATOMICPTR_AWAIT_EQ
    #define VATOMICPTR_AWAIT_EQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline void *
vatomicptr_await_eq(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline void *
vatomicptr_await_eq(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.ne 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomicptr_await_neq
 ******************************************************************************/
#ifndef VATOMICPTR_AWAIT_NEQ
    #define VATOMICPTR_AWAIT_NEQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline void *
vatomicptr_await_neq(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline void *
vatomicptr_await_neq(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.eq 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomicptr_await_eq_acq
 ******************************************************************************/
#ifndef VATOMICPTR_AWAIT_EQ_ACQ
    #define VATOMICPTR_AWAIT_EQ_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline void *
vatomicptr_await_eq_acq(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline void *
vatomicptr_await_eq_acq(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.ne 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomicptr_await_neq_acq
 ******************************************************************************/
#ifndef VATOMICPTR_AWAIT_NEQ_ACQ
    #define VATOMICPTR_AWAIT_NEQ_ACQ
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline void *
vatomicptr_await_neq_acq(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "1:\n"
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline void *
vatomicptr_await_neq_acq(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "ldar %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldaxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.eq 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomicptr_await_eq_rlx
 ******************************************************************************/
#ifndef VATOMICPTR_AWAIT_EQ_RLX
    #define VATOMICPTR_AWAIT_EQ_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline void *
vatomicptr_await_eq_rlx(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "1:\n"
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline void *
vatomicptr_await_eq_rlx(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.ne 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
/******************************************************************************
 * vatomicptr_await_neq_rlx
 ******************************************************************************/
#ifndef VATOMICPTR_AWAIT_NEQ_RLX
    #define VATOMICPTR_AWAIT_NEQ_RLX
    #if defined(VATOMIC_DISABLE_POLITE_AWAIT)
static inline void *
vatomicptr_await_neq_rlx(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "1:\n"
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.eq 1b\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #else
static inline void *
vatomicptr_await_neq_rlx(const vatomicptr_t *a, void *v)
{
    void *val;
    __asm__ volatile(
        "ldr %x[val], %[a]\n"
        "cmp %x[val], %x[exp]\n"
        "b.ne 2f\n"
        "sevl\n"
        ".align 5\n"
        "1:\n"
        "wfe\n"
        "ldxr %x[val], %[a]\n"
        "cmp %x[val],  %x[exp]\n"
        "b.eq 1b\n"
        "2:\n"
        : [val] "=&r"(val)
        : [exp] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return val;
}
    #endif
#endif
#endif
