/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.LinkedList;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.SslTransport;
import org.fusesource.hawtdispatch.transport.TcpTransport;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportAware;
import org.fusesource.hawtdispatch.transport.UdpTransport;
import org.fusesource.hawtdispatch.util.BufferPool;
import org.fusesource.hawtdispatch.util.BufferPools;

public abstract class AbstractProtocolCodec
implements ProtocolCodec,
TransportAware {
    protected BufferPools bufferPools;
    protected BufferPool writeBufferPool;
    protected BufferPool readBufferPool;
    protected int writeBufferSize = 65536;
    protected long writeCounter = 0L;
    protected GatheringByteChannel writeChannel = null;
    protected DataByteArrayOutputStream nextWriteBuffer;
    protected long lastWriteIoSize = 0L;
    protected LinkedList<ByteBuffer> writeBuffer = new LinkedList();
    private long writeBufferRemaining = 0L;
    protected long readCounter = 0L;
    protected int readBufferSize = 65536;
    protected ReadableByteChannel readChannel = null;
    protected ByteBuffer readBuffer;
    protected ByteBuffer directReadBuffer = null;
    protected int readEnd;
    protected int readStart;
    protected int lastReadIoSize;
    protected Action nextDecodeAction;

    public void setTransport(Transport transport) {
        if (transport instanceof TcpTransport) {
            TcpTransport tcp = (TcpTransport)transport;
            this.writeBufferSize = tcp.getSendBufferSize();
            this.readBufferSize = tcp.getReceiveBufferSize();
        } else if (transport instanceof UdpTransport) {
            UdpTransport tcp = (UdpTransport)transport;
            this.writeBufferSize = tcp.getSendBufferSize();
            this.readBufferSize = tcp.getReceiveBufferSize();
        } else {
            try {
                if (this.writeChannel instanceof SocketChannel) {
                    this.writeBufferSize = ((SocketChannel)this.writeChannel).socket().getSendBufferSize();
                    this.readBufferSize = ((SocketChannel)this.readChannel).socket().getReceiveBufferSize();
                } else if (this.writeChannel instanceof SslTransport.SSLChannel) {
                    this.writeBufferSize = ((SslTransport.SSLChannel)this.readChannel).socket().getSendBufferSize();
                    this.readBufferSize = ((SslTransport.SSLChannel)this.writeChannel).socket().getReceiveBufferSize();
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        if (this.bufferPools != null) {
            this.readBufferPool = this.bufferPools.getBufferPool(this.readBufferSize);
            this.writeBufferPool = this.bufferPools.getBufferPool(this.writeBufferSize);
        }
    }

    public void setWritableByteChannel(WritableByteChannel channel) throws SocketException {
        this.writeChannel = (GatheringByteChannel)channel;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public boolean full() {
        return this.writeBufferRemaining >= (long)this.writeBufferSize;
    }

    public boolean isEmpty() {
        return this.writeBufferRemaining == 0L && (this.nextWriteBuffer == null || this.nextWriteBuffer.size() == 0);
    }

    public long getWriteCounter() {
        return this.writeCounter;
    }

    public long getLastWriteSize() {
        return this.lastWriteIoSize;
    }

    protected abstract void encode(Object var1) throws IOException;

    public ProtocolCodec.BufferState write(Object value) throws IOException {
        if (this.full()) {
            return ProtocolCodec.BufferState.FULL;
        }
        boolean wasEmpty = this.isEmpty();
        if (this.nextWriteBuffer == null) {
            this.nextWriteBuffer = this.allocateNextWriteBuffer();
        }
        this.encode(value);
        if ((double)this.nextWriteBuffer.size() >= (double)this.writeBufferSize * 0.75) {
            this.flushNextWriteBuffer();
        }
        if (wasEmpty) {
            return ProtocolCodec.BufferState.WAS_EMPTY;
        }
        return ProtocolCodec.BufferState.NOT_EMPTY;
    }

    private DataByteArrayOutputStream allocateNextWriteBuffer() {
        if (this.writeBufferPool != null) {
            return new DataByteArrayOutputStream((byte[])this.writeBufferPool.checkout()){

                protected void resize(int newcount) {
                    byte[] oldbuf = this.buf;
                    super.resize(newcount);
                    if (oldbuf.length == AbstractProtocolCodec.this.writeBufferPool.getBufferSize()) {
                        AbstractProtocolCodec.this.writeBufferPool.checkin(oldbuf);
                    }
                }
            };
        }
        return new DataByteArrayOutputStream(this.writeBufferSize);
    }

    protected void writeDirect(ByteBuffer value) throws IOException {
        int nextnextPospos = this.nextWriteBuffer.position();
        int valuevalueLengthlength = value.remaining();
        int available = this.nextWriteBuffer.getData().length - nextnextPospos;
        if (available > valuevalueLengthlength) {
            value.get(this.nextWriteBuffer.getData(), nextnextPospos, valuevalueLengthlength);
            this.nextWriteBuffer.position(nextnextPospos + valuevalueLengthlength);
        } else {
            if (this.nextWriteBuffer != null && this.nextWriteBuffer.size() != 0) {
                this.flushNextWriteBuffer();
            }
            this.writeBuffer.add(value);
            this.writeBufferRemaining += (long)value.remaining();
        }
    }

    protected void flushNextWriteBuffer() {
        DataByteArrayOutputStream next = this.allocateNextWriteBuffer();
        ByteBuffer bb = this.nextWriteBuffer.toBuffer().toByteBuffer();
        this.writeBuffer.add(bb);
        this.writeBufferRemaining += (long)bb.remaining();
        this.nextWriteBuffer = next;
    }

    public ProtocolCodec.BufferState flush() throws IOException {
        block0: while (true) {
            if (this.writeBufferRemaining != 0L) {
                if (this.writeBuffer.size() == 1) {
                    ByteBuffer b = this.writeBuffer.getFirst();
                    this.lastWriteIoSize = this.writeChannel.write(b);
                    if (this.lastWriteIoSize == 0L) {
                        return ProtocolCodec.BufferState.NOT_EMPTY;
                    }
                    this.writeBufferRemaining -= this.lastWriteIoSize;
                    this.writeCounter += this.lastWriteIoSize;
                    if (b.hasRemaining()) continue;
                    this.onBufferFlushed(this.writeBuffer.removeFirst());
                    continue;
                }
                ByteBuffer[] buffers = this.writeBuffer.toArray(new ByteBuffer[this.writeBuffer.size()]);
                this.lastWriteIoSize = this.writeChannel.write(buffers, 0, buffers.length);
                if (this.lastWriteIoSize == 0L) {
                    return ProtocolCodec.BufferState.NOT_EMPTY;
                }
                this.writeBufferRemaining -= this.lastWriteIoSize;
                this.writeCounter += this.lastWriteIoSize;
                while (true) {
                    if (this.writeBuffer.isEmpty() || this.writeBuffer.getFirst().hasRemaining()) continue block0;
                    this.onBufferFlushed(this.writeBuffer.removeFirst());
                }
            }
            if (this.nextWriteBuffer == null || this.nextWriteBuffer.size() == 0) {
                if (this.writeBufferPool != null && this.nextWriteBuffer != null) {
                    this.writeBufferPool.checkin(this.nextWriteBuffer.getData());
                    this.nextWriteBuffer = null;
                }
                return ProtocolCodec.BufferState.EMPTY;
            }
            this.flushNextWriteBuffer();
        }
    }

    protected void onBufferFlushed(ByteBuffer byteBuffer) {
    }

    protected abstract Action initialDecodeAction();

    public void setReadableByteChannel(ReadableByteChannel channel) throws SocketException {
        this.readChannel = channel;
        if (this.nextDecodeAction == null) {
            this.nextDecodeAction = this.initialDecodeAction();
        }
    }

    public void unread(byte[] buffer) {
        assert (this.readCounter == 0L);
        this.readBuffer = ByteBuffer.allocate(buffer.length);
        this.readBuffer.put(buffer);
        this.readCounter += (long)buffer.length;
    }

    public long getReadCounter() {
        return this.readCounter;
    }

    public long getLastReadSize() {
        return this.lastReadIoSize;
    }

    public Object read() throws IOException {
        Object command = null;
        while (command == null) {
            if (this.directReadBuffer != null) {
                while (this.directReadBuffer.hasRemaining()) {
                    this.lastReadIoSize = this.readChannel.read(this.directReadBuffer);
                    this.readCounter += (long)this.lastReadIoSize;
                    if (this.lastReadIoSize == -1) {
                        throw new EOFException("Peer disconnected");
                    }
                    if (this.lastReadIoSize != 0) continue;
                    return null;
                }
                command = this.nextDecodeAction.apply();
                continue;
            }
            if (this.readBuffer == null || this.readEnd == this.readBuffer.position()) {
                if (this.readBuffer == null || this.readBuffer.remaining() == 0) {
                    int size = this.readEnd - this.readStart;
                    int newCapacity = 0;
                    newCapacity = this.readStart == 0 ? size + this.readBufferSize : (size > this.readBufferSize ? size + this.readBufferSize : this.readBufferSize);
                    byte[] newBuffer = size > 0 ? Arrays.copyOfRange(this.readBuffer.array(), this.readStart, this.readStart + newCapacity) : (this.readBufferPool != null ? (newCapacity == this.readBufferPool.getBufferSize() ? (byte[])this.readBufferPool.checkout() : new byte[newCapacity]) : (size > 0 ? Arrays.copyOfRange(this.readBuffer.array(), this.readStart, this.readStart + newCapacity) : new byte[newCapacity]));
                    this.readBuffer = ByteBuffer.wrap(newBuffer);
                    this.readBuffer.position(size);
                    this.readStart = 0;
                    this.readEnd = size;
                }
                int p = this.readBuffer.position();
                this.lastReadIoSize = this.readChannel.read(this.readBuffer);
                this.readCounter += (long)this.lastReadIoSize;
                if (this.lastReadIoSize == -1) {
                    ++this.readCounter;
                    throw new EOFException("Peer disconnected");
                }
                if (this.lastReadIoSize == 0) {
                    if (this.readBufferPool != null && this.readStart == this.readEnd) {
                        if (this.readEnd == 0 && this.readBuffer.array().length == this.readBufferPool.getBufferSize()) {
                            this.readBufferPool.checkin(this.readBuffer.array());
                        } else {
                            this.readStart = 0;
                            this.readEnd = 0;
                        }
                        this.readBuffer = null;
                    }
                    return null;
                }
            }
            command = this.nextDecodeAction.apply();
            assert (this.readStart <= this.readEnd);
            assert (this.readEnd <= this.readBuffer.position());
        }
        return command;
    }

    protected Buffer readUntil(Byte octet) throws ProtocolException {
        return this.readUntil(octet, -1);
    }

    protected Buffer readUntil(Byte octet, int max) throws ProtocolException {
        return this.readUntil(octet, max, "Maximum protocol buffer length exeeded");
    }

    protected Buffer readUntil(Byte octet, int max, String msg) throws ProtocolException {
        byte[] array = this.readBuffer.array();
        Buffer buf = new Buffer(array, this.readEnd, this.readBuffer.position() - this.readEnd);
        int pos = buf.indexOf(octet.byteValue());
        if (pos >= 0) {
            int offset = this.readStart;
            this.readEnd += pos + 1;
            this.readStart = this.readEnd;
            int length = this.readEnd - offset;
            if (max >= 0 && length > max) {
                throw new ProtocolException(msg);
            }
            return new Buffer(array, offset, length);
        }
        this.readEnd += buf.length;
        if (max >= 0 && this.readEnd - this.readStart > max) {
            throw new ProtocolException(msg);
        }
        return null;
    }

    protected Buffer readBytes(int length) {
        if (this.readBuffer.position() - this.readStart < length) {
            this.readEnd = this.readBuffer.position();
            return null;
        }
        int offset = this.readStart;
        this.readStart = this.readEnd = offset + length;
        return new Buffer(this.readBuffer.array(), offset, length);
    }

    protected Buffer peekBytes(int length) {
        if (this.readBuffer.position() - this.readStart < length) {
            this.readEnd = this.readBuffer.position();
            return null;
        }
        return new Buffer(this.readBuffer.array(), this.readStart, length);
    }

    protected Boolean readDirect(ByteBuffer buffer) {
        assert (this.directReadBuffer == null || this.directReadBuffer == buffer);
        if (buffer.hasRemaining()) {
            int limit = this.readBuffer.position();
            int transferSize = Math.min(limit - this.readStart, buffer.remaining());
            byte[] readBufferArray = this.readBuffer.array();
            buffer.put(readBufferArray, this.readStart, transferSize);
            int trailingSize = limit - (this.readStart + transferSize);
            if (trailingSize > 0) {
                System.arraycopy(readBufferArray, this.readStart + transferSize, readBufferArray, this.readStart, trailingSize);
            }
            this.readBuffer.position(this.readStart + trailingSize);
        }
        if (buffer.hasRemaining()) {
            this.directReadBuffer = buffer;
            return false;
        }
        this.directReadBuffer = null;
        buffer.flip();
        return true;
    }

    public BufferPools getBufferPools() {
        return this.bufferPools;
    }

    public void setBufferPools(BufferPools bufferPools) {
        this.bufferPools = bufferPools;
        if (bufferPools != null) {
            this.readBufferPool = bufferPools.getBufferPool(this.readBufferSize);
            this.writeBufferPool = bufferPools.getBufferPool(this.writeBufferSize);
        } else {
            this.readBufferPool = null;
            this.writeBufferPool = null;
        }
    }

    public static interface Action {
        public Object apply() throws IOException;
    }
}

