/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.impl;

import edu.umd.marbl.mhap.align.AlignElementDoubleSketch;
import edu.umd.marbl.mhap.align.Aligner;
import edu.umd.marbl.mhap.impl.OverlapInfo;
import edu.umd.marbl.mhap.sketch.MinHashBitSketch;
import edu.umd.marbl.mhap.sketch.MinHashSketch;
import edu.umd.marbl.mhap.sketch.Sketch;
import edu.umd.marbl.mhap.sketch.ZeroNGramsFoundException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class MinHashBitSequenceSubSketches {
    private final AlignElementDoubleSketch<MinHashBitSketch> alignmentSketch;

    public static final MinHashBitSketch[] computeSequences(String seq, int nGramSize, int stepSize, int numWords) throws ZeroNGramsFoundException {
        int remainder = seq.length() % stepSize;
        int numSequence = (seq.length() - remainder) / stepSize;
        if (remainder > 0) {
            ++numSequence;
        }
        int start = 0;
        MinHashBitSketch[] sequence = new MinHashBitSketch[numSequence];
        for (int iter = 0; iter < numSequence; ++iter) {
            int end = Math.min(seq.length(), start + stepSize);
            int currStart = Math.max(0, end - stepSize);
            int[] sketch = new MinHashSketch(seq.substring(currStart, end), nGramSize, numWords * 64, true).getMinHashArray();
            sequence[iter] = new MinHashBitSketch(sketch);
            start += stepSize;
        }
        return sequence;
    }

    public static final MinHashBitSketch[] computeSequencesDouble(String seq, int nGramSize, int stepSize, int numWords) throws ZeroNGramsFoundException {
        int remainder = seq.length() % stepSize;
        int numSequence = (seq.length() - remainder) / stepSize - 1;
        if (remainder >= stepSize / 2 && remainder >= nGramSize) {
            ++numSequence;
        }
        int start = 0;
        MinHashBitSketch[] sketches = new MinHashBitSketch[numSequence];
        for (int iter = 0; iter < numSequence; ++iter) {
            int end = Math.min(seq.length(), start + stepSize * 2);
            int currStart = Math.max(0, end - stepSize * 2);
            sketches[iter] = new MinHashBitSketch(new MinHashSketch(seq.substring(currStart, end), nGramSize, numWords * 64, true).getMinHashArray());
            start += stepSize;
        }
        return sketches;
    }

    public OverlapInfo getOverlapInfo(Aligner<AlignElementDoubleSketch<MinHashBitSketch>> aligner, MinHashBitSequenceSubSketches b) {
        return this.alignmentSketch.getOverlapInfo(aligner, b.alignmentSketch);
    }

    public static final MinHashBitSequenceSubSketches fromByteStream(DataInputStream input) throws IOException {
        try {
            int numSketches = input.readInt();
            int numWordsPerSketch = input.readInt();
            int stepSize = input.readInt();
            int seqLength = input.readInt();
            MinHashBitSketch[] sequence = new MinHashBitSketch[numSketches];
            for (int iter = 0; iter < numSketches; ++iter) {
                long[] bits = new long[numWordsPerSketch];
                for (int word = 0; word < numWordsPerSketch; ++word) {
                    bits[word] = input.readLong();
                }
                sequence[iter] = new MinHashBitSketch(bits);
            }
            return new MinHashBitSequenceSubSketches(sequence, stepSize, seqLength);
        }
        catch (EOFException e) {
            return null;
        }
    }

    protected MinHashBitSequenceSubSketches(MinHashBitSketch[] sketches, int stepSize, int seqLength) {
        this.alignmentSketch = new AlignElementDoubleSketch((Sketch[])sketches, stepSize, seqLength);
    }

    public MinHashBitSequenceSubSketches(String seq, int kmerSize, int stepSize, int numWords) throws ZeroNGramsFoundException {
        this.alignmentSketch = new AlignElementDoubleSketch((Sketch[])MinHashBitSequenceSubSketches.computeSequencesDouble(seq, kmerSize, stepSize, numWords), stepSize, seq.length());
    }

    public byte[] getAsByteArray() {
        int numSketches = this.alignmentSketch.length();
        int numWordsPerSketch = this.alignmentSketch.getSketch(0).numberOfWords();
        ByteBuffer bb = ByteBuffer.allocate(8 * numWordsPerSketch * numSketches + 16);
        bb.putInt(numSketches);
        bb.putInt(numWordsPerSketch);
        bb.putInt(this.alignmentSketch.getStepSize());
        bb.putInt(this.alignmentSketch.getSequenceLength());
        for (int sketchIndex = 0; sketchIndex < numSketches; ++sketchIndex) {
            MinHashBitSketch sketch = this.alignmentSketch.getSketch(sketchIndex);
            for (int word = 0; word < numWordsPerSketch; ++word) {
                bb.putLong(sketch.getWord(word));
            }
        }
        return bb.array();
    }
}

