/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.sketch.Counter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public final class ClassicCounter<T>
implements Counter<T> {
    private final HashMap<Object, LongAdder> map;
    private final LongAdder numAdditions;
    private final AtomicLong maxCount;

    public ClassicCounter(int size) {
        this.map = new HashMap(size);
        this.maxCount = new AtomicLong();
        this.numAdditions = new LongAdder();
    }

    @Override
    public long getCount(Object obj) {
        LongAdder adder = this.map.get(obj);
        if (adder == null) {
            return 0L;
        }
        return this.map.get(obj).longValue();
    }

    @Override
    public void add(Object obj) {
        this.add(obj, 1L);
    }

    @Override
    public long maxCount() {
        return this.maxCount.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Object obj, long count) {
        LongAdder adder = null;
        Serializable serializable = this.map;
        synchronized (serializable) {
            adder = this.map.get(obj);
            if (adder == null) {
                adder = new LongAdder();
                this.map.put(obj, adder);
            }
        }
        adder.add(count);
        if (this.maxCount.longValue() < count) {
            serializable = this.maxCount;
            synchronized (serializable) {
                if (this.maxCount.longValue() < count) {
                    this.maxCount.set(count);
                }
            }
        }
        this.numAdditions.add(count);
    }
}

