/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.igoweb.go.Game;
import org.igoweb.go.Go;
import org.igoweb.go.Loc;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.swing.FwdBackIcon;
import org.igoweb.go.swing.GameLayout;
import org.igoweb.go.swing.GamePanel;
import org.igoweb.go.swing.GetLabelWindow;
import org.igoweb.go.swing.GobanController;
import org.igoweb.go.swing.GobanWidget;
import org.igoweb.go.swing.Map;
import org.igoweb.go.swing.MapViewport;
import org.igoweb.go.swing.NodeNameEditor;
import org.igoweb.go.swing.NodeWidget;
import org.igoweb.go.swing.StoneIcon;
import org.igoweb.util.Emitter;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.ComboIcon;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.swing.Prefs;
import org.igoweb.util.swing.SingletonWindow;

public class Editor
extends Emitter {
    public static final int NEW_TOOL_EVENT = 0;
    private static final int MAP_MODE_TALL_VERTICAL = -1;
    private static final int MAP_MODE_TALL_HORIZONTAL = -2;
    private static final int MAP_MODE_UNDER_BOARD = 0;
    private static final int MAP_MODE_UNDER_CHAT = 1;
    private static final int MAP_MODE_UNDER_BOTH = 2;
    private static final int MAP_MODE_COUNT = 3;
    private static final String MAP_MODE_WIDE_PREF = "Zu<BcY/d";
    private static final String MAP_MODE_TALL_PREF = "@zXY!iI_W*";
    private int currentTool = -1;
    private int mapMode = Prefs.getInt("@zXY!iI_W*", -1);
    private final GamePanel gamePanel;
    private final GobanWidget gobanWidget;
    private final Tree tree;
    private final Game game;
    private Map map;
    private static final String MAP_HEIGHT_PREF = "S@4EY1C.T3";
    private MapSplitPane mapSplitPane;
    private JScrollPane mapScroller;
    private int lastPos;
    private GetLabelWindow lWin = null;
    private static Icon[] toolIcons;
    private JRadioButtonMenuItem[] toolMenuItems;
    private final JMenu toolMenu = new JMenu(Defs.getString(-451068472));
    private boolean inSetWide = false;
    private static final SingletonWindow nodeNameEditor;
    private final EventListener gamePanelListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: {
                    if (Editor.this.map == null) break;
                    Editor.this.map.setListener(Editor.this.gamePanel.isNodeChangeEnabled() ? Editor.this.nodeListener : null);
                }
            }
        }
    };
    private final ActionListener nodeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            Editor.this.gamePanel.changeActiveNode((Node)event.getSource());
        }
    };
    private final EventListener treeListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            if (Editor.this.currentTool == 2 && event.type == 7) {
                if (Editor.this.tree.getActiveNode().findProp(22) == null && (Editor.this.toolMenuItems == null || Editor.this.toolMenuItems[0].isEnabled())) {
                    Editor.this.setTool(0);
                } else {
                    Editor.this.gamePanel.changeScoreMarks(false);
                }
            }
        }
    };
    private final EventListener moveUpdater = new EventListener(){
        int lastWhoseMove = 2;

        @Override
        public void handleEvent(Event event) {
            int newWhoseMove = Editor.this.game.getWhoseMove();
            if (newWhoseMove != this.lastWhoseMove) {
                this.lastWhoseMove = newWhoseMove;
                if (Editor.this.toolMenuItems != null) {
                    Editor.this.toolMenuItems[0].setIcon(toolIcons[newWhoseMove]);
                    if (Editor.this.currentTool == 0) {
                        Editor.this.setMenuButIcon();
                    }
                }
            }
        }
    };

    public Editor(GamePanel gamePanel) {
        this.gamePanel = gamePanel;
        this.gobanWidget = gamePanel.getGobanWidget();
        this.game = gamePanel.getGame();
        this.tree = gamePanel.getSgfTree();
        this.tree.addListener(this.treeListener);
    }

    public void addToolMenu(JComponent[] extraMenuItems) {
        this.toolMenuItems = new JRadioButtonMenuItem[8];
        this.toolMenu.setHorizontalTextPosition(2);
        this.setMenuButIcon();
        if (toolIcons == null) {
            StoneIcon icon0 = new StoneIcon(0, 0);
            toolIcons = new Icon[]{icon0, new StoneIcon(1, 4), this.makeIcon("tool1.png", icon0.getIconWidth()), this.makeIcon("tool2.png", icon0.getIconWidth()), new StoneIcon(0, 0, 4, null), new StoneIcon(0, 0, 8, null), new StoneIcon(0, 0, 16, null), new StoneIcon(0, 0, 2, Defs.getString(-451068496).substring(0, 1)), new StoneIcon(0, 0, 2, Integer.toString(1))};
        }
        ButtonGroup toolGroup = new ButtonGroup();
        int i = 0;
        while (i < 8) {
            JRadioButtonMenuItem toolMenuItem;
            StringTokenizer tokenizer = new StringTokenizer(Defs.getString(1639062481 + i), "|");
            this.toolMenuItems[i] = toolMenuItem = new JRadioButtonMenuItem(tokenizer.nextToken());
            toolMenuItem.setAccelerator(KeyStroke.getKeyStroke(112 + i, 0));
            toolMenuItem.setSelected(false);
            toolMenuItem.setIcon(toolIcons[i + 1]);
            if (i != 1 && i != 2) {
                toolMenuItem.setDisabledIcon(toolIcons[i + 1]);
            }
            toolMenuItem.setHorizontalTextPosition(4);
            toolMenuItem.setToolTipText(this.buildToolTipText(tokenizer));
            toolGroup.add(toolMenuItem);
            this.toolMenu.add(toolMenuItem);
            final int finalIndex = i++;
            toolMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        Editor.this.toolChanged(finalIndex);
                    }
                }
            });
        }
        if (extraMenuItems != null) {
            boolean mayBeRadio = true;
            for (int i2 = 0; i2 < extraMenuItems.length; ++i2) {
                if (extraMenuItems[i2] == null) {
                    this.toolMenu.addSeparator();
                    mayBeRadio = false;
                    continue;
                }
                if (mayBeRadio) {
                    if (extraMenuItems[i2] instanceof JRadioButtonMenuItem) {
                        JRadioButtonMenuItem rb = (JRadioButtonMenuItem)extraMenuItems[i2];
                        toolGroup.add(rb);
                        rb.setAccelerator(KeyStroke.getKeyStroke(112 + i2 + 8, 0));
                    } else {
                        mayBeRadio = false;
                    }
                }
                this.toolMenu.add(extraMenuItems[i2]);
            }
        }
        JMenuBar mbar = new JMenuBar();
        mbar.add(this.toolMenu);
        mbar.setBorder(null);
        this.gamePanel.titlePanel.add("Before", mbar);
        this.game.addListener(this.moveUpdater);
        this.moveUpdater.handleEvent(null);
        this.gobanWidget.setController(this.buildBoardController(-1));
    }

    public void setTool(int newTool) {
        if (this.toolMenuItems != null) {
            if (newTool == -1) {
                if (this.currentTool != -1) {
                    this.toolMenuItems[this.currentTool].setSelected(false);
                }
            } else {
                this.toolMenuItems[newTool].setSelected(true);
            }
        }
        this.toolChanged(newTool);
    }

    private void toolChanged(int newTool) {
        if (this.currentTool == newTool) {
            return;
        }
        this.currentTool = newTool;
        this.setMenuButIcon();
        if (newTool == -1) {
            this.toolMenu.setToolTipText(null);
        } else {
            this.toolMenu.setToolTipText(this.buildToolTipText(new StringTokenizer(Defs.getString(1639062481 + newTool), "|")));
        }
        if (newTool == 2) {
            this.gamePanel.changeScoreMarks(false);
        }
        this.gobanWidget.setController(this.buildBoardController(this.currentTool));
        this.gamePanel.getPlayerWidget(0).setShowScore(newTool == 2);
        this.gamePanel.getPlayerWidget(1).setShowScore(newTool == 2);
        this.emit(0, new Integer(this.currentTool));
    }

    private void setMenuButIcon() {
        FwdBackIcon menuIcon = new FwdBackIcon(2);
        this.toolMenu.setIcon(this.currentTool == -1 ? menuIcon : new ComboIcon(toolIcons[this.currentTool == 0 ? this.game.getWhoseMove() : this.currentTool + 1], menuIcon));
    }

    private ImageIcon makeIcon(String fileName, int size) {
        return new ImageIcon(GuiUtil.loadImage("org/igoweb/go/swing/images/" + fileName).getScaledInstance(size, size, 4));
    }

    private String buildToolTipText(StringTokenizer tok) {
        StringBuilder buf = new StringBuilder("<html><p>");
        while (true) {
            buf.append(tok.nextToken());
            if (!tok.hasMoreTokens()) {
                return buf.append("</p></html>").toString();
            }
            buf.append("<br>");
        }
    }

    public boolean changeLiveness(Loc loc2, boolean markDead) {
        Node activeNode = this.tree.getActiveNode();
        ArrayList<Prop> addedProps = new ArrayList<Prop>();
        ArrayList<Prop> removedProps = new ArrayList<Prop>();
        if (loc2 != Loc.PASS) {
            int targetColor = this.game.getColor(loc2);
            if (targetColor == 2 || activeNode.findProp(23, loc2) != null == markDead) {
                return false;
            }
            HashSet<Loc> deadLocs = new HashSet<Loc>();
            for (Prop p : activeNode) {
                if (p.type != 23) continue;
                deadLocs.add(p.getLoc());
            }
            for (Loc loc2 : this.game.floodFill(loc2, 1 << Go.opponent(targetColor), deadLocs)) {
                if (this.game.getColor(loc2) != targetColor) continue;
                Prop param = new Prop(23, loc2);
                if (markDead) {
                    if (deadLocs.contains(loc2)) continue;
                    addedProps.add(param);
                    continue;
                }
                if (!deadLocs.contains(loc2)) continue;
                removedProps.add(param);
            }
        }
        activeNode.score(this.game, addedProps, removedProps);
        Iterator<Prop> iter = removedProps.iterator();
        while (iter.hasNext()) {
            this.gamePanel.removeProp(activeNode, iter.next());
        }
        for (Prop prop : addedProps) {
            if (activeNode.contains(prop)) {
                System.err.println("ASSERT - PROP DOUBLY ADDED: " + prop);
                Thread.dumpStack();
            }
            this.gamePanel.addProp(activeNode, prop);
        }
        return !addedProps.isEmpty() || !removedProps.isEmpty();
    }

    private void addMarkupLabel(Loc loc) {
        HashSet<String> labels = this.currentLabels();
        String labelSeq = Defs.getString(-451068496);
        for (int labelId = 0; labelId < labelSeq.length(); ++labelId) {
            String newLabel = labelSeq.substring(labelId, labelId + 1);
            if (labels.contains(newLabel)) continue;
            this.gamePanel.addProp(new Prop(19, loc, newLabel));
            return;
        }
        new Errout(Defs.getString(-451068493), this.gamePanel);
    }

    private void addMarkupNumber(Loc loc) {
        String newLabel;
        HashSet<String> labels = this.currentLabels();
        int labelNum = 0;
        while (labels.contains(newLabel = Integer.toString(++labelNum))) {
        }
        this.gamePanel.addProp(new Prop(19, loc, newLabel));
    }

    private HashSet<String> currentLabels() {
        HashSet<String> labels = new HashSet<String>();
        Iterator<Loc> allLocs = this.game.allLocs();
        while (allLocs.hasNext()) {
            Loc loc = allLocs.next();
            if ((this.gobanWidget.getMark(loc) & 2) == 0) continue;
            labels.add(this.gobanWidget.getLabel(loc));
        }
        return labels;
    }

    private void addMoveNumberLabel(Loc loc) {
        Node n = this.tree.getActiveNode();
        while (n != null) {
            Iterator<Prop> params = n.iterator();
            while (params.hasNext()) {
                Prop p = params.next();
                if (p.type == 14 && p.getLoc().equals(loc)) {
                    int moveNum = n.getMoveNum();
                    String labelStr = moveNum < 100 ? Integer.toString(moveNum) : ((moveNum %= 100) < 10 ? "0" + Integer.toString(moveNum) : Integer.toString(moveNum));
                    this.gamePanel.addProp(new Prop(19, loc, labelStr));
                    return;
                }
                params.hasNext();
            }
            n = n.parent;
        }
        new Errout(Defs.getString(-451068492), this.gamePanel);
    }

    public Map addMap() {
        this.mapScroller = new JScrollPane(22, 32);
        this.map = new Map(this.tree, this.buildNodePopupMenu());
        this.mapScroller.setViewport(new MapViewport());
        this.mapScroller.setViewportView(this.map);
        this.gamePanel.setLayout(new MappedGameLayout());
        this.map.setListener(this.gamePanel.isNodeChangeEnabled() ? this.nodeListener : null);
        this.game.addListener(this.moveUpdater);
        this.moveUpdater.handleEvent(null);
        this.gamePanel.addListener(this.gamePanelListener);
        JButton cornerBut = new JButton(new FwdBackIcon(5));
        cornerBut.setToolTipText(Defs.getString(-451068471));
        cornerBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Editor.this.mapMode >= 0) {
                    Editor.this.mapMode = (Editor.this.mapMode + 1) % 3;
                    Editor.this.setWide(true);
                    Prefs.putInt(Editor.MAP_MODE_WIDE_PREF, Editor.this.mapMode);
                } else {
                    Editor.this.mapMode = Editor.this.mapMode ^ 1;
                    Editor.this.setWide(false);
                    Prefs.putInt(Editor.MAP_MODE_TALL_PREF, Editor.this.mapMode);
                }
                Editor.this.gamePanel.invalidate();
                RepaintManager.currentManager(Editor.this.gamePanel).addInvalidComponent(Editor.this.gamePanel);
            }
        });
        this.mapScroller.setCorner("LOWER_RIGHT_CORNER", cornerBut);
        this.setWide(((MappedGameLayout)this.gamePanel.getLayout()).isWide());
        return this.map;
    }

    private void setWide(boolean isWide) {
        if (this.inSetWide) {
            return;
        }
        this.inSetWide = true;
        try {
            this.gamePanel.removeAll();
            this.gamePanel.add(this.gamePanel.getTitlePanel());
            this.gamePanel.add(this.gamePanel.getControlPanel());
            this.gamePanel.add(this.gobanWidget);
            this.gamePanel.add(this.gamePanel.getCommentWidget());
            if (isWide) {
                if (this.mapMode < 0) {
                    Prefs.putInt(MAP_MODE_TALL_PREF, this.mapMode);
                    this.mapMode = Prefs.getInt(MAP_MODE_WIDE_PREF, 1);
                }
            } else if (this.mapMode >= 0) {
                Prefs.putInt(MAP_MODE_WIDE_PREF, this.mapMode);
                this.mapMode = Prefs.getInt(MAP_MODE_TALL_PREF, -1);
            }
            switch (this.mapMode) {
                case 0: {
                    this.gobanWidget.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
                    this.mapSplitPane = new MapSplitPane(0, this.gobanWidget, this.mapScroller, false);
                    this.gamePanel.add(this.gamePanel.getCommentWidget());
                    break;
                }
                case 1: {
                    this.gobanWidget.setBorder(null);
                    this.mapSplitPane = new MapSplitPane(0, this.gamePanel.getCommentWidget(), this.mapScroller, false);
                    this.gamePanel.add(this.gobanWidget);
                    break;
                }
                case 2: {
                    this.gobanWidget.setBorder(null);
                    JPanel masterPanel = new JPanel(this.gamePanel.getLayout());
                    masterPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
                    masterPanel.setOpaque(false);
                    masterPanel.add(this.gamePanel.getTitlePanel());
                    masterPanel.add(this.gamePanel.getControlPanel());
                    masterPanel.add(this.gobanWidget);
                    masterPanel.add(this.gamePanel.getCommentWidget());
                    this.mapSplitPane = new MapSplitPane(0, masterPanel, this.mapScroller, false);
                    break;
                }
                case -2: 
                case -1: {
                    this.gobanWidget.setBorder(null);
                    this.mapSplitPane = new MapSplitPane(this.mapMode == -2 ? 1 : 0, this.mapScroller, this.gamePanel.getCommentWidget(), true);
                    this.gamePanel.add(this.gobanWidget);
                }
            }
            this.gamePanel.add(this.mapSplitPane);
            this.gamePanel.invalidate();
            RepaintManager.currentManager(this.gamePanel).addInvalidComponent(this.gamePanel);
        }
        finally {
            this.inSetWide = false;
        }
    }

    public int getTool() {
        return this.currentTool;
    }

    public JMenuItem getToolMenuItem(int tool) {
        return this.toolMenuItems[tool];
    }

    private void dividerMoved() {
        if (this.mapMode == 0) {
            int newPos = this.mapSplitPane.getDividerLocation();
            if (newPos != this.lastPos) {
                this.lastPos = newPos;
                ((MappedGameLayout)this.gamePanel.getLayout()).forceLayout();
            }
        } else {
            this.lastPos = -1;
        }
    }

    protected GobanController buildBoardController(int tool) {
        return new BoardController(tool);
    }

    protected JPopupMenu buildNodePopupMenu() {
        final JPopupMenu nodePopup = new JPopupMenu(Defs.getString(-451068466));
        JMenuItem mi = new JMenuItem(Defs.getString(-451068503));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.gamePanel.changeActiveNode(((NodeWidget)nodePopup.getInvoker()).node);
            }
        });
        nodePopup.add(mi);
        mi = new JMenuItem(Defs.getString(-451068467));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                nodeNameEditor.setWindow(new NodeNameEditor(((NodeWidget)nodePopup.getInvoker()).node, Editor.this.gamePanel));
            }
        });
        nodePopup.add(mi);
        return nodePopup;
    }

    static {
        nodeNameEditor = new SingletonWindow();
    }

    private class MapSplitPane
    extends JSplitPane {
        private boolean setSizeNeeded;
        private final boolean saveTopSize;

        public MapSplitPane(int orientation, JComponent top, JComponent bottom, boolean saveTopSize) {
            super(orientation, true, top, bottom);
            this.setSizeNeeded = true;
            this.saveTopSize = saveTopSize;
            this.setOneTouchExpandable(true);
            this.setOpaque(false);
            this.setBorder(null);
            this.setResizeWeight(saveTopSize ? 0.0 : 1.0);
            this.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    Editor.this.dividerMoved();
                }
            });
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            if (this.setSizeNeeded) {
                this.setSizeNeeded = false;
                int sizeWanted = Prefs.getInt(Editor.MAP_HEIGHT_PREF + this.getOrientation(), ((Editor)Editor.this).mapScroller.getMinimumSize().height);
                this.setDividerLocation(this.saveTopSize ? sizeWanted : h - (this.getDividerSize() + sizeWanted));
            }
        }

        @Override
        public void removeNotify() {
            if (!this.setSizeNeeded) {
                this.setSizeNeeded = true;
                int size = this.getDividerLocation();
                if (!this.saveTopSize) {
                    size = this.getHeight() - (this.getDividerSize() + size);
                }
                Prefs.putInt(Editor.MAP_HEIGHT_PREF + this.getOrientation(), size);
            }
            super.removeNotify();
        }
    }

    private class MappedGameLayout
    extends GameLayout
    implements Runnable {
        private boolean layoutNeeded;

        public MappedGameLayout() {
            super(Editor.this.gamePanel);
            this.layoutNeeded = false;
        }

        @Override
        protected void doLayout(Container cont, Dimension size, Insets insets) {
            if (cont == Editor.this.gamePanel) {
                if (Editor.this.mapMode == 2) {
                    Component comp = cont.getComponent(0);
                    comp.setBounds(insets.left, insets.top, size.width - (insets.left + insets.right), size.height - (insets.top + insets.bottom));
                } else {
                    this.layoutNeeded = false;
                    super.doLayout(cont, size, insets);
                }
            } else if (Editor.this.mapMode == 2) {
                this.layoutNeeded = false;
                super.doLayout(cont, size, insets);
            }
        }

        @Override
        public JComponent getMainWidget() {
            return Editor.this.mapMode == 0 ? Editor.this.mapSplitPane : Editor.this.gobanWidget;
        }

        @Override
        public JComponent getCommentWidget() {
            return Editor.this.mapMode == 1 || Editor.this.mapMode < 0 ? Editor.this.mapSplitPane : Editor.this.gamePanel.getCommentWidget();
        }

        @Override
        protected void setWide(boolean isWide) {
            Editor.this.setWide(isWide);
            super.setWide(isWide);
        }

        @Override
        protected int getUsableBoardWidth(int maxW, int maxH) {
            if (Editor.this.map != null && Editor.this.mapMode == 0 && (maxH = Editor.this.mapSplitPane.getDividerLocation()) < ((Editor)Editor.this).gobanWidget.getMinimumSize().width) {
                maxH = ((Editor)Editor.this).gobanWidget.getMinimumSize().width;
            }
            return super.getUsableBoardWidth(maxW, maxH);
        }

        public void forceLayout() {
            if (!this.layoutNeeded) {
                this.layoutNeeded = true;
                Editor.this.gamePanel.invalidate();
                RepaintManager.currentManager(Editor.this.gamePanel).addInvalidComponent(Editor.this.gamePanel);
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            if (this.layoutNeeded) {
                Editor.this.gamePanel.invalidate();
                RepaintManager.currentManager(Editor.this.gamePanel).addInvalidComponent(Editor.this.gamePanel);
            }
        }
    }

    public class BoardController
    extends GobanController {
        public final int tool;

        public BoardController(int tool) {
            this.tool = tool;
        }

        @Override
        public int getCursor(Loc loc, int modifiers, boolean shifted) {
            switch (this.tool) {
                case -1: {
                    return 2;
                }
                case 0: {
                    if (shifted) {
                        return 3;
                    }
                    if (Editor.this.game.isLegal(loc) == 0) {
                        return Editor.this.game.getWhoseMove();
                    }
                    return 2;
                }
                case 1: {
                    if (loc != Loc.PASS && Editor.this.game.getColor(loc) == 2) {
                        return shifted ? 1 : 0;
                    }
                    return 3;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (shifted) {
                        return 2;
                    }
                    return 3;
                }
                case 6: 
                case 7: {
                    return 3;
                }
                case 2: {
                    if ((modifiers & 3) == 3) {
                        return 3;
                    }
                    if (loc == Loc.PASS || Editor.this.game.getColor(loc) == 2 || shifted == ((Editor.this.gobanWidget.getMark(loc) & 0x80) == 0)) {
                        return 2;
                    }
                    return Go.opponent(Editor.this.game.getColor(loc));
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isCapsLockShift() {
            return this.tool == 1;
        }

        @Override
        public boolean useAntiSkid() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void boardClicked(Loc loc, int modifiers, boolean shifted) {
            Editor.this.gamePanel.startPropBundle();
            try {
                if (loc == Loc.PASS) {
                    if (this.tool != 0) {
                        Editor.this.gamePanel.addNode();
                        return;
                    }
                } else {
                    if (loc != Loc.PASS && (modifiers & 3) == 2) {
                        Editor.this.gamePanel.displayLocName(loc);
                        return;
                    }
                    if (this.getCursor(loc, modifiers, shifted) == 2) {
                        return;
                    }
                }
                int markType = -1;
                int color = 0;
                switch (this.tool) {
                    case 0: {
                        if ((modifiers & 3) == 3) {
                            Editor.this.gamePanel.changeWhoseMove(Go.opponent(Editor.this.game.getWhoseMove()));
                            return;
                        }
                        if (shifted) {
                            if (loc != Loc.PASS) {
                                Node node = Editor.this.tree.findNodeContainingMove(loc, Editor.this.game.getColor(loc) == 2);
                                if (node == null) {
                                    Defs.ringBell();
                                } else {
                                    Editor.this.gamePanel.changeActiveNode(node);
                                }
                            }
                        } else {
                            color = Editor.this.game.getWhoseMove();
                            for (Node child : Editor.this.tree.getActiveNode().children()) {
                                Prop move = child.findProp(14);
                                if (move == null || move.getColor() != color || !move.getLoc().equals(loc)) continue;
                                Editor.this.gamePanel.changeActiveNode(child);
                                return;
                            }
                            Editor.this.gamePanel.addProp(new Prop(14, color, loc));
                        }
                        return;
                    }
                    case 1: {
                        if (loc != Loc.PASS && Editor.this.game.getColor(loc) == 2) {
                            color = shifted ? 1 : 0;
                            boolean allDead = true;
                            Iterator<Loc> neighbors = loc.neighbors(((Editor)Editor.this).game.size);
                            while (neighbors.hasNext()) {
                                Loc n = neighbors.next();
                                int c = Editor.this.game.getColor(n);
                                if (c == 2) {
                                    allDead = false;
                                    continue;
                                }
                                if (c == color) {
                                    if (Editor.this.game.getChain(n).countLiberties() <= 1) continue;
                                    allDead = false;
                                    continue;
                                }
                                if (c != Go.opponent(color) || Editor.this.game.getChain(n).countLiberties() != 1) continue;
                                allDead = false;
                                Iterator<Loc> victims = Editor.this.game.getChain(n).iterator();
                                while (victims.hasNext()) {
                                    Editor.this.gamePanel.addProp(new Prop(17, 2, victims.next()));
                                }
                            }
                            if (!allDead) {
                                Editor.this.gamePanel.addProp(new Prop(17, color, loc));
                            }
                        } else {
                            Editor.this.gamePanel.addProp(new Prop(17, 2, loc));
                        }
                        return;
                    }
                    case 2: {
                        if ((modifiers & 3) == 3) {
                            Editor.this.gamePanel.changeScoreMarks(true);
                            return;
                        }
                        Editor.this.changeLiveness(loc, !shifted);
                        return;
                    }
                    case 3: {
                        markType = 20;
                        break;
                    }
                    case 4: {
                        markType = 21;
                        break;
                    }
                    case 5: {
                        markType = 15;
                        break;
                    }
                    case 6: {
                        if ((Editor.this.gobanWidget.getMark(loc) & 2) != 0) {
                            Editor.this.gamePanel.removeProp(Editor.this.tree.getActiveNode().findProp(19, loc));
                        } else if (shifted) {
                            if (Editor.this.lWin != null) {
                                Editor.this.lWin.dispose();
                            }
                            Editor.this.lWin = new GetLabelWindow(loc, Editor.this.gamePanel, Editor.this.gobanWidget.getStoneWidget(loc));
                        } else {
                            Editor.this.addMarkupLabel(loc);
                        }
                        return;
                    }
                    case 7: {
                        if ((Editor.this.gobanWidget.getMark(loc) & 2) != 0) {
                            Editor.this.gamePanel.removeProp(Editor.this.tree.getActiveNode().findProp(19, loc));
                        } else if (shifted) {
                            Editor.this.addMoveNumberLabel(loc);
                        } else {
                            Editor.this.addMarkupNumber(loc);
                        }
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                Prop param = Prop.hasColor(markType) ? new Prop(markType, color, loc) : new Prop(markType, loc);
                Prop oldProp = Editor.this.tree.getActiveNode().findProp(param.type, param.getLoc());
                if (oldProp == null) {
                    Editor.this.gamePanel.addProp(param);
                } else {
                    Editor.this.gamePanel.removeProp(oldProp);
                }
            }
            finally {
                Editor.this.gamePanel.endPropBundle();
            }
        }
    }
}

