/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;

public class IOUtilities {
    private static final Hashtable urlCache = new Hashtable();

    public static DataOutputStream maybeCreateDataOutputStream(OutputStream outputStream) {
        if (outputStream instanceof DataOutputStream) {
            return (DataOutputStream)outputStream;
        }
        return new DataOutputStream(outputStream);
    }

    public static DataInputStream maybeCreateDataInputStream(InputStream inputStream) {
        if (inputStream instanceof DataInputStream) {
            return (DataInputStream)inputStream;
        }
        return new DataInputStream(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDir(File file, File file2, boolean bl) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("The source directory (" + file + ") doesn't exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The source (" + file + ") is a file, not a directory");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException("The destination directory (" + file2 + ") doesn't exist");
        }
        if (!file2.isDirectory()) {
            throw new IllegalArgumentException("The destination (" + file2 + ") is a file, not a directory");
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string = stringArray[i];
            File file3 = new File(file, string);
            if (file3.isDirectory()) {
                if (!bl) continue;
                object = new File(file2, string);
                if (!((File)object).exists() && !((File)object).mkdirs()) {
                    throw new IOException("Unable to create directory " + object);
                }
                IOUtilities.copyDir(file3, (File)object, true);
                continue;
            }
            object = null;
            OutputStream outputStream = null;
            try {
                object = new FileInputStream(file3);
                outputStream = new FileOutputStream(new File(file2, string));
                IOUtilities.pump((InputStream)object, outputStream);
                continue;
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }

    public static boolean rmdir(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (!(file2.isDirectory() ? !IOUtilities.rmdir(file2) : !file2.delete())) continue;
            return false;
        }
        return file.delete();
    }

    public static int pump(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtilities.pump(inputStream, outputStream, new byte[2048]);
    }

    public static int pump(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        return IOUtilities.pump(inputStream, outputStream, n, new byte[2048]);
    }

    public static int pump(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Cannot use a 0 length buffer");
        }
        int n2 = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
        return n2;
    }

    public static int pump(InputStream inputStream, OutputStream outputStream, int n, byte[] byArray) throws IOException {
        int n2;
        int n3;
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Cannot use a 0 length buffer");
        }
        int n4 = 0;
        while (n > 0 && (n3 = inputStream.read(byArray, 0, n2 = n > byArray.length ? byArray.length : n)) != -1) {
            outputStream.write(byArray, 0, n3);
            n -= n3;
            n4 += n3;
        }
        return n4;
    }

    public static byte[] readToEnd(InputStream inputStream) throws IOException {
        byte[] byArray;
        byte[] byArray2 = new byte[2048];
        int n = 0;
        int n2 = 0;
        while ((n2 = inputStream.read(byArray2, n, byArray2.length - n)) > 0) {
            if ((n += n2) != byArray2.length) continue;
            byArray = byArray2;
            byArray2 = new byte[byArray.length * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n);
        }
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    public static byte[] read(InputStream inputStream, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        if (IOUtilities.pump(inputStream, (OutputStream)byteArrayOutputStream, n) != n) {
            throw new EOFException();
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] load(URL uRL, boolean bl) throws IOException {
        InputStream inputStream = IOUtilities.inputStreamForURL(uRL, bl);
        try {
            byte[] byArray = IOUtilities.readToEnd(inputStream);
            return byArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String loadText(InputStream inputStream) throws IOException {
        return new String(IOUtilities.readToEnd(inputStream));
    }

    public static String loadText(URL uRL, boolean bl) throws IOException {
        return new String(IOUtilities.load(uRL, bl));
    }

    public static String loadTextFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File does not exist");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = IOUtilities.loadText(fileInputStream);
        ((InputStream)fileInputStream).close();
        return string;
    }

    public static String loadTextFile(String string) throws IOException {
        return IOUtilities.loadTextFile(new File(string));
    }

    public static boolean equal(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0 || n + n3 > byArray.length || n2 + n3 > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            if (byArray[n + i] == byArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }

    public static URL fileToURL(File file) {
        try {
            String string = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (!string.endsWith("/") && file.isDirectory()) {
                string = string + "/";
            }
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Properties loadProperties(InputStream inputStream) throws IOException {
        return IOUtilities.loadProperties(inputStream, new Properties());
    }

    public static Properties loadProperties(InputStream inputStream, Properties properties) throws IOException {
        if (inputStream == null) {
            return null;
        }
        properties.load(inputStream);
        return properties;
    }

    public static Properties loadPropertiesAndClose(InputStream inputStream) throws IOException {
        return IOUtilities.loadPropertiesAndClose(inputStream, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesAndClose(InputStream inputStream, Properties properties) throws IOException {
        try {
            Properties properties2 = IOUtilities.loadProperties(inputStream, properties);
            return properties2;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Properties loadProperties(File file) throws IOException {
        return IOUtilities.loadPropertiesAndClose(new FileInputStream(file));
    }

    public static Properties loadProperties(URL uRL, boolean bl) throws IOException {
        return IOUtilities.loadProperties(uRL, bl, new Properties());
    }

    public static Properties loadProperties(URL uRL, boolean bl, Properties properties) throws IOException {
        return IOUtilities.loadPropertiesAndClose(IOUtilities.inputStreamForURL(uRL, bl), properties);
    }

    public static void cacheURL(URL uRL) throws IOException {
        IOUtilities.cacheData(uRL, IOUtilities.load(uRL, false));
    }

    public static void cacheData(URL uRL, byte[] byArray) {
        urlCache.put(uRL, byArray);
    }

    public static boolean isURLCached(URL uRL) {
        return urlCache.containsKey(uRL);
    }

    public static InputStream inputStreamForURL(URL uRL, boolean bl) throws IOException {
        byte[] byArray = null;
        if (bl) {
            byArray = (byte[])urlCache.get(uRL);
        }
        return byArray == null ? uRL.openStream() : new ByteArrayInputStream(byArray);
    }

    public static void loadAsynchronously(URL[] uRLArray, Object object, DataReceiver dataReceiver, boolean bl) {
        Thread thread = new Thread((Runnable)new UrlDataReader((URL[])uRLArray.clone(), object, dataReceiver, bl), "AsyncThread-" + ++UrlDataReader.threadCount);
        thread.setDaemon(true);
        thread.start();
    }

    public static void loadSynchronously(URL[] uRLArray, Object object, DataReceiver dataReceiver, boolean bl) {
        new UrlDataReader((URL[])uRLArray.clone(), object, dataReceiver, bl).run();
    }

    private static class UrlDataReader
    implements Runnable {
        public static int threadCount = 0;
        private final URL[] urls;
        private final Object id;
        private final DataReceiver receiver;
        private final boolean allowCache;
        private final byte[][] data;
        private final IOException[] exceptions;

        public UrlDataReader(URL[] uRLArray, Object object, DataReceiver dataReceiver, boolean bl) {
            this.urls = uRLArray;
            this.id = object;
            this.receiver = dataReceiver;
            this.allowCache = bl;
            this.data = new byte[uRLArray.length][];
            this.exceptions = new IOException[uRLArray.length];
        }

        public void run() {
            for (int i = 0; i < this.urls.length; ++i) {
                try {
                    this.data[i] = IOUtilities.load(this.urls[i], this.allowCache);
                    continue;
                }
                catch (IOException iOException) {
                    this.exceptions[i] = iOException;
                }
            }
            this.receiver.dataRead(this.urls, this.id, this.data, this.exceptions);
        }
    }

    public static interface DataReceiver {
        public void dataRead(URL[] var1, Object var2, byte[][] var3, IOException[] var4);
    }
}

