/*
 * Decompiled with CFR 0.152.
 */
package free.util.audio;

import free.util.IOUtilities;
import free.util.audio.AudioPlayer;
import free.util.audio.NullAudioPlayer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;

public class AudioClip {
    private static AudioPlayer successfulPlayer = null;
    private static final String[] PLAYER_CLASSNAMES;
    private final URL url;
    private final byte[] data;

    public AudioClip(URL uRL) throws IOException {
        this.url = uRL;
        InputStream inputStream = uRL.openStream();
        this.data = IOUtilities.readToEnd(inputStream);
        inputStream.close();
    }

    public synchronized void play() {
        String string;
        if (successfulPlayer != null) {
            try {
                successfulPlayer.play(this);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            string = System.getProperty("free.util.audio.player");
        }
        catch (SecurityException securityException) {
            string = null;
        }
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                AudioPlayer audioPlayer = (AudioPlayer)clazz.newInstance();
                if (!audioPlayer.isSupported()) {
                    System.err.println(string + " is not supported on your system - audio disabled.");
                    successfulPlayer = new NullAudioPlayer();
                    return;
                }
                audioPlayer.play(this);
                successfulPlayer = audioPlayer;
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                System.err.println(string + " failed - audio disabled.");
                successfulPlayer = new NullAudioPlayer();
            }
        } else {
            for (int i = 0; i < PLAYER_CLASSNAMES.length; ++i) {
                String string2 = PLAYER_CLASSNAMES[i];
                try {
                    Class<?> clazz = Class.forName(string2);
                    AudioPlayer audioPlayer = (AudioPlayer)clazz.newInstance();
                    if (!audioPlayer.isSupported()) continue;
                    audioPlayer.play(this);
                    System.err.println("Will now use " + string2 + " to play audio clips.");
                    successfulPlayer = audioPlayer;
                    break;
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)throwable;
                }
            }
            if (successfulPlayer == null) {
                System.err.println("All supported players failed - audio disabled");
                successfulPlayer = new NullAudioPlayer();
            }
        }
    }

    public URL getURL() {
        return this.url;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    static {
        String[] stringArray = new String[]{};
        try {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(AudioClip.class.getResourceAsStream("players.txt")));
                Vector<String> vector = new Vector<String>();
                while ((string = bufferedReader.readLine()) != null) {
                    vector.addElement(string);
                }
                bufferedReader.close();
                stringArray = new String[vector.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)vector.elementAt(i);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                stringArray = new String[]{};
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PLAYER_CLASSNAMES = stringArray;
    }
}

