/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board.icc;

import free.chess.Position;
import free.chess.Square;
import free.jin.board.Arrow;
import free.jin.board.Circle;
import free.jin.board.JinBoard;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class ChessclubJBoard
extends JinBoard {
    private Square tmpArrowFrom = null;
    private Square tmpArrowTo = null;

    public ChessclubJBoard(Position position) {
        super(position);
        this.enableEvents(48L);
    }

    public void paint(Component component, Graphics graphics) {
        super.paint(component, graphics);
        Rectangle rectangle = this.squareToRect(0, 0, null);
        int n = this.calcArrowSize(rectangle.width, rectangle.height);
        if (this.tmpArrowFrom != null && this.tmpArrowTo != null && !this.tmpArrowFrom.equals(this.tmpArrowTo)) {
            this.drawArrow(graphics, this.tmpArrowFrom, this.tmpArrowTo, n, this.getDefaultArrowColor());
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!this.isEnabled()) {
            return;
        }
        if ((mouseEvent.getModifiers() & 4) != 4) {
            return;
        }
        if (!this.isArrowCircleEnabled()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Square square = this.locationToSquare(n, n2);
        if (mouseEvent.getID() == 500) {
            if (this.areCirclesAt(square)) {
                this.removeCirclesAt(square);
            } else {
                this.addCircle(new Circle(square, this.getDefaultCircleColor()));
            }
        } else if (mouseEvent.getID() == 501) {
            this.tmpArrowFrom = square;
        } else if (mouseEvent.getID() == 502) {
            if (this.tmpArrowFrom != null && this.tmpArrowTo != null && !this.tmpArrowFrom.equals(this.tmpArrowTo)) {
                if (this.areArrowsAt(this.tmpArrowFrom, this.tmpArrowTo)) {
                    this.removeArrowsAt(this.tmpArrowFrom, this.tmpArrowTo);
                } else {
                    this.addArrow(new Arrow(this.tmpArrowFrom, this.tmpArrowTo, this.getDefaultArrowColor()));
                }
            }
            this.tmpArrowFrom = null;
            this.tmpArrowTo = null;
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (!this.isEnabled()) {
            return;
        }
        if ((mouseEvent.getModifiers() & 4) != 4) {
            return;
        }
        if (!this.isArrowCircleEnabled()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Square square = this.locationToSquare(n, n2);
        if (mouseEvent.getID() == 506 && this.tmpArrowFrom != null) {
            this.tmpArrowTo = square;
            this.repaint();
        }
    }
}

