//===========================================================================
//  CVS Information:                                                         
//                                                                           
//     $RCSfile: ilu.cc,v $  $Revision: 1.2 $  $State: Exp $ 
//     $Author: jsiek $  $Date: 2000/08/28 15:22:59 $ 
//     $Locker:  $ 
//---------------------------------------------------------------------------
//                                                                           
// DESCRIPTION                                                               
//                                                                           
//---------------------------------------------------------------------------
//                                                                           
// LICENSE AGREEMENT                                                         
// Software License for MTL
// 
// Copyright (c) 2001-2005 The Trustees of Indiana University. All rights reserved.
// Copyright (c) 1998-2001 University of Notre Dame. All rights reserved.
// Authors: Andrew Lumsdaine, Jeremy G. Siek, Lie-Quan Lee
// 
// This file is part of the Matrix Template Library
// 
// See also license.mtl.txt in the distribution.
//                                                                           
// REVISION HISTORY:                                                         
//                                                                           
// $Log: ilu.cc,v $
// Revision 1.2  2000/08/28 15:22:59  jsiek
// got rid of iostream.h and replaced with iostream
//
// Revision 1.1.1.1  2000/07/12 21:51:43  jsiek
// stable mtl version
//
// Revision 1.7  1999/09/30 07:08:42  jsiek
// argc, argv unused
//
// Revision 1.6  1999/04/19 17:47:56  jsiek
// blah
//
// Revision 1.5  1999/03/10 17:07:58  jsiek
// sparse -> compressed<> and compressed -> compressed<> name changes
//
// Revision 1.4  1999/03/04 17:36:59  llee1
// *** empty log message ***
//
// Revision 1.3  1999/01/26 15:58:55  llee1
// change path
//
// Revision 1.2  1998/09/01 19:09:23  llee1
// put the right results in the file
//
// Revision 1.1  1998/09/01 18:31:43  llee1
// new file
//
// Revision 1.3  1998/08/16 22:03:37  jsiek
// compresse1D name change and using namespace itl
//
// Revision 1.2  1998/08/13 20:43:57  jsiek
// mtl
//
// Revision 1.1  1998/08/12 18:02:25  llee1
// ilut example
//
//                                                                           
//===========================================================================

#include "mtl/matrix.h"
#include "mtl/mtl.h"
#include "mtl/utils.h"

#include "itl/itl.h"
#include "itl/qmr.h"

#include "itl/ilu.h"
/*
  In thsi example, we show how to use ILU algorithm, the output should be:

iteration 0: resid 1
iteration 1: resid 1.95673
iteration 2: resid 0.151187
iteration 3: resid 6.03361e-13
finished! error code = 0
3 iterations
6.03361e-13 final residual
     1      2      0      0      3   x          0.205847  =       1
     4      5      0      6      0   x         0.0419363  =       1
     0      7      8      0      9   x         -0.178049  =       1
     0      0     10     11     12   x       -0.00551162  =       1
     0      0     13      0     14   x           0.23676  =       1
*/

using namespace mtl;
using namespace itl;

typedef  double Type;
//begin
typedef matrix< Type, rectangle<>, 
	        array< compressed<> >, 
                row_major >::type Matrix;
//end
int main (int , char* []) 
{
  int max_iter = 50;
  //begin
  Matrix A(5, 5);
  //end
  A(0, 0) = 1.0;
  A(0, 1) = 2.0;
  A(0, 4) = 3.0;
  A(1, 0) = 4.0;
  A(1, 1) = 5.0;
  A(1, 3) = 6.0;
  A(2, 1) = 7.0;
  A(2, 2) = 8.0;
  A(2, 4) = 9.0;
  A(3, 2) = 10.;
  A(3, 3) = 11.;
  A(3, 4) = 12.;
  A(4, 2) = 13.; 
  A(4, 4) = 14.;
  //begin
  dense1D<Type> x(A.nrows(), Type(0));
  dense1D<Type> b(A.ncols());
  for (dense1D<Type>::iterator i=b.begin(); i!=b.end(); i++)
    *i = 1.;
  // ilu preconditioner 
  ILU<Matrix> precond(A);
  //iteration
  noisy_iteration<double> iter(b, max_iter, 1.e-6);
  //qmr algorithm
  qmr(A, x, b, precond.left(), precond.right(), iter);
  //end

  //verify the result
  dense1D<Type> b1(A.ncols());
  mult(A, x, b1);
  add(b1, scaled(b, -1.), b1);

  if ( two_norm(b1) < 1.e-6) { //output
    for (int i=0; i<5; i++) {
      for (int j=0; j<5; j++) {
	std::cout.width(6);
	std::cout << A(i, j) << " ";
      }
      std::cout << "  x  ";
      std::cout.width(16);
      std::cout << x[i] << "  =  ";
      std::cout.width(6);
      std::cout << b[i] << std::endl;
    }
  } else {
    std::cout << "Residual " << iter.resid() << std::endl;
  }

  return 0;
  }


