<?php

/**
 * BaseJobTitle
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                      $id                                                            Type: integer(13), primary key
 * @property string                                   $jobTitleName                                                  Type: string(100)
 * @property string                                   $jobDescription                                                Type: string(400)
 * @property string                                   $note                                                          Type: string(400)
 * @property int                                      $isDeleted                                                     Type: integer(1), default "0"
 * @property JobSpecificationAttachment               $JobSpecificationAttachment                                    
 * @property Doctrine_Collection|Employee[]           $employees                                                     
 * @property Doctrine_Collection|Kpi[]                $Kpi                                                           
 * @property Doctrine_Collection|PerformanceReview[]  $PerformanceReview                                             
 * @property Doctrine_Collection|JobVacancy[]         $JobVacancy                                                    
 *  
 * @method int                                        getId()                                                        Type: integer(13), primary key
 * @method string                                     getJobtitlename()                                              Type: string(100)
 * @method string                                     getJobdescription()                                            Type: string(400)
 * @method string                                     getNote()                                                      Type: string(400)
 * @method int                                        getIsdeleted()                                                 Type: integer(1), default "0"
 * @method JobSpecificationAttachment                 getJobSpecificationAttachment()                                
 * @method Doctrine_Collection|Employee[]             getEmployees()                                                 
 * @method Doctrine_Collection|Kpi[]                  getKpi()                                                       
 * @method Doctrine_Collection|PerformanceReview[]    getPerformanceReview()                                         
 * @method Doctrine_Collection|JobVacancy[]           getJobVacancy()                                                
 *  
 * @method JobTitle                                   setId(int $val)                                                Type: integer(13), primary key
 * @method JobTitle                                   setJobtitlename(string $val)                                   Type: string(100)
 * @method JobTitle                                   setJobdescription(string $val)                                 Type: string(400)
 * @method JobTitle                                   setNote(string $val)                                           Type: string(400)
 * @method JobTitle                                   setIsdeleted(int $val)                                         Type: integer(1), default "0"
 * @method JobTitle                                   setJobSpecificationAttachment(JobSpecificationAttachment $val) 
 * @method JobTitle                                   setEmployees(Doctrine_Collection $val)                         
 * @method JobTitle                                   setKpi(Doctrine_Collection $val)                               
 * @method JobTitle                                   setPerformanceReview(Doctrine_Collection $val)                 
 * @method JobTitle                                   setJobVacancy(Doctrine_Collection $val)                        
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseJobTitle extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_job_title');
        $this->hasColumn('id', 'integer', 13, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 13,
             ));
        $this->hasColumn('job_title as jobTitleName', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('job_description as jobDescription', 'string', 400, array(
             'type' => 'string',
             'length' => 400,
             ));
        $this->hasColumn('note', 'string', 400, array(
             'type' => 'string',
             'length' => 400,
             ));
        $this->hasColumn('is_deleted as isDeleted', 'integer', 1, array(
             'type' => 'integer',
             'default' => '0',
             'length' => 1,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('JobSpecificationAttachment', array(
             'local' => 'id',
             'foreign' => 'jobTitleId'));

        $this->hasMany('Employee as employees', array(
             'local' => 'id',
             'foreign' => 'job_title_code'));

        $this->hasMany('Kpi', array(
             'local' => 'id',
             'foreign' => 'jobTitleCode'));

        $this->hasMany('PerformanceReview', array(
             'local' => 'id',
             'foreign' => 'jobTitleCode'));

        $this->hasMany('JobVacancy', array(
             'local' => 'id',
             'foreign' => 'jobTitleCode'));
    }
}