<?php

/**
 * BaseEmployee
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                               $empNumber                                                   Type: integer(4), primary key
 * @property string                                            $lastName                                                    Type: string(100)
 * @property string                                            $firstName                                                   Type: string(100)
 * @property string                                            $middleName                                                  Type: string(100)
 * @property string                                            $nickName                                                    Type: string(100)
 * @property int                                               $smoker                                                      Type: integer(2), default "0"
 * @property string                                            $ssn                                                         Type: string(100)
 * @property string                                            $sin                                                         Type: string(100)
 * @property string                                            $otherId                                                     Type: string(100)
 * @property string                                            $licenseNo                                                   Type: string(100)
 * @property string                                            $militaryService                                             Type: string(100)
 * @property string                                            $street1                                                     Type: string(100)
 * @property string                                            $street2                                                     Type: string(100)
 * @property string                                            $city                                                        Type: string(100)
 * @property string                                            $country                                                     Type: string(100)
 * @property string                                            $province                                                    Type: string(100)
 * @property string                                            $employeeId                                                  Type: string(50)
 * @property string                                            $ethnic_race_code                                            Type: string(13)
 * @property string                                            $emp_birthday                                                Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @property int                                               $nation_code                                                 Type: integer
 * @property int                                               $emp_gender                                                  Type: integer(2)
 * @property string                                            $emp_marital_status                                          Type: string(20)
 * @property string                                            $emp_dri_lice_exp_date                                       Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @property int                                               $emp_status                                                  Type: integer(13)
 * @property int                                               $job_title_code                                              Type: integer(6)
 * @property int                                               $eeo_cat_code                                                Type: integer
 * @property int                                               $work_station                                                Type: integer(4)
 * @property string                                            $emp_zipcode                                                 Type: string(20)
 * @property string                                            $emp_hm_telephone                                            Type: string(50)
 * @property string                                            $emp_mobile                                                  Type: string(50)
 * @property string                                            $emp_work_telephone                                          Type: string(50)
 * @property string                                            $emp_work_email                                              Type: string(50)
 * @property string                                            $sal_grd_code                                                Type: string(13)
 * @property string                                            $joined_date                                                 Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @property string                                            $emp_oth_email                                               Type: string(50)
 * @property int                                               $termination_id                                              Type: integer(4)
 * @property string                                            $custom1                                                     Type: string(250)
 * @property string                                            $custom2                                                     Type: string(250)
 * @property string                                            $custom3                                                     Type: string(250)
 * @property string                                            $custom4                                                     Type: string(250)
 * @property string                                            $custom5                                                     Type: string(250)
 * @property string                                            $custom6                                                     Type: string(250)
 * @property string                                            $custom7                                                     Type: string(250)
 * @property string                                            $custom8                                                     Type: string(250)
 * @property string                                            $custom9                                                     Type: string(250)
 * @property string                                            $custom10                                                    Type: string(250)
 * @property string                                            $purged_at                                                   Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property Subunit                                           $subDivision                                                 
 * @property JobTitle                                          $jobTitle                                                    
 * @property EmploymentStatus                                  $employeeStatus                                              
 * @property Doctrine_Collection|Employee[]                    $supervisors                                                 
 * @property Doctrine_Collection|Location[]                    $locations                                                   
 * @property Doctrine_Collection|EmpDependent[]                $dependents                                                  
 * @property Doctrine_Collection|EmpEmergencyContact[]         $emergencyContacts                                           
 * @property Doctrine_Collection|EmpWorkExperience[]           $workExperience                                              
 * @property Doctrine_Collection|EmployeeEducation[]           $education                                                   
 * @property Doctrine_Collection|EmployeeSkill[]               $skills                                                      
 * @property Doctrine_Collection|EmployeeLanguage[]            $languages                                                   
 * @property Doctrine_Collection|EmployeeSalary[]              $salary                                                      
 * @property Doctrine_Collection|EmpContract[]                 $contracts                                                   
 * @property Doctrine_Collection|EmployeeAttachment[]          $attachments                                                 
 * @property Doctrine_Collection|ProjectAdmin[]                $projectAdmin                                                
 * @property EmployeeTerminationRecord                         $EmployeeTerminationRecord                                   
 * @property Country                                           $EmployeeCountry                                             
 * @property Nationality                                       $Nationality                                                 
 * @property JobCategory                                       $JobCategory                                                 
 * @property Doctrine_Collection|AttendanceRecord[]            $AttendanceRecord                                            
 * @property Doctrine_Collection|Post[]                        $posts                                                       
 * @property Doctrine_Collection|Share[]                       $share                                                       
 * @property Doctrine_Collection|Comment[]                     $comment                                                     
 * @property BuzzNotificationMetadata                          $NotificationMetadata                                        
 * @property Doctrine_Collection|SystemUser[]                  $SystemUser                                                  
 * @property Doctrine_Collection|LeaveEntitlement[]            $LeaveEntitlement                                            
 * @property Doctrine_Collection|LeaveAdjustment[]             $LeaveAdjustment                                             
 * @property Doctrine_Collection|LeaveRequest[]                $LeaveRequest                                                
 * @property Doctrine_Collection|LeaveRequestComment[]         $LeaveRequestComment                                         
 * @property Doctrine_Collection|LeaveComment[]                $LeaveComment                                                
 * @property Doctrine_Collection|PerformanceReview[]           $PerformanceReview                                           
 * @property Doctrine_Collection|Reviewer[]                    $Reviewer                                                    
 * @property Doctrine_Collection|PerformanceTrack[]            $PerformanceTrack                                            
 * @property Doctrine_Collection|PerformanceTrackerLog[]       $PerformanceTrackerLog                                       
 * @property Doctrine_Collection|PerformanceTrackerReviewer[]  $PerformanceTrackerReviewer                                  
 * @property Doctrine_Collection|Employee[]                    $subordinates                                                
 * @property Doctrine_Collection|EmpPicture[]                  $EmpPicture                                                  
 * @property Doctrine_Collection|EmployeeImmigrationRecord[]   $EmployeeImmigrationRecord                                   
 * @property Doctrine_Collection|EmpUsTaxExemption[]           $EmpUsTaxExemption                                           
 * @property Doctrine_Collection|EmployeeMembership[]          $EmployeeMembership                                          
 * @property Doctrine_Collection|ReportTo[]                    $ReportTo                                                    
 * @property Doctrine_Collection|EmployeeLicense[]             $EmployeeLicense                                             
 * @property Doctrine_Collection|EmployeeWorkShift[]           $EmployeeWorkShift                                           
 * @property Doctrine_Collection|EmployeeEducation[]           $EmployeeEducation                                           
 * @property Doctrine_Collection|EmployeeEvent[]               $EmployeeEvent                                               
 * @property Doctrine_Collection|EmployeeSubscription[]        $EmployeeSubscription                                        
 * @property Doctrine_Collection|JobVacancy[]                  $managedVacancies                                            
 * @property Doctrine_Collection|JobCandidate[]                $JobCandidate                                                
 * @property Doctrine_Collection|JobInterviewInterviewer[]     $JobInterviewInterviewer                                     
 * @property Doctrine_Collection|CandidateHistory[]            $CandidateHistory                                            
 * @property Doctrine_Collection|TimesheetItem[]               $TimesheetItem                                               
 * @property Doctrine_Collection|EmpChildren[]                 $EmpChildren                                                 
 *  
 * @method int                                                 getEmpnumber()                                               Type: integer(4), primary key
 * @method string                                              getLastname()                                                Type: string(100)
 * @method string                                              getFirstname()                                               Type: string(100)
 * @method string                                              getMiddlename()                                              Type: string(100)
 * @method string                                              getNickname()                                                Type: string(100)
 * @method int                                                 getSmoker()                                                  Type: integer(2), default "0"
 * @method string                                              getSsn()                                                     Type: string(100)
 * @method string                                              getSin()                                                     Type: string(100)
 * @method string                                              getOtherid()                                                 Type: string(100)
 * @method string                                              getLicenseno()                                               Type: string(100)
 * @method string                                              getMilitaryservice()                                         Type: string(100)
 * @method string                                              getStreet1()                                                 Type: string(100)
 * @method string                                              getStreet2()                                                 Type: string(100)
 * @method string                                              getCity()                                                    Type: string(100)
 * @method string                                              getCountry()                                                 Type: string(100)
 * @method string                                              getProvince()                                                Type: string(100)
 * @method string                                              getEmployeeid()                                              Type: string(50)
 * @method string                                              getEthnicRaceCode()                                          Type: string(13)
 * @method string                                              getEmpBirthday()                                             Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method int                                                 getNationCode()                                              Type: integer
 * @method int                                                 getEmpGender()                                               Type: integer(2)
 * @method string                                              getEmpMaritalStatus()                                        Type: string(20)
 * @method string                                              getEmpDriLiceExpDate()                                       Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method int                                                 getEmpStatus()                                               Type: integer(13)
 * @method int                                                 getJobTitleCode()                                            Type: integer(6)
 * @method int                                                 getEeoCatCode()                                              Type: integer
 * @method int                                                 getWorkStation()                                             Type: integer(4)
 * @method string                                              getEmpZipcode()                                              Type: string(20)
 * @method string                                              getEmpHmTelephone()                                          Type: string(50)
 * @method string                                              getEmpMobile()                                               Type: string(50)
 * @method string                                              getEmpWorkTelephone()                                        Type: string(50)
 * @method string                                              getEmpWorkEmail()                                            Type: string(50)
 * @method string                                              getSalGrdCode()                                              Type: string(13)
 * @method string                                              getJoinedDate()                                              Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method string                                              getEmpOthEmail()                                             Type: string(50)
 * @method int                                                 getTerminationId()                                           Type: integer(4)
 * @method string                                              getCustom1()                                                 Type: string(250)
 * @method string                                              getCustom2()                                                 Type: string(250)
 * @method string                                              getCustom3()                                                 Type: string(250)
 * @method string                                              getCustom4()                                                 Type: string(250)
 * @method string                                              getCustom5()                                                 Type: string(250)
 * @method string                                              getCustom6()                                                 Type: string(250)
 * @method string                                              getCustom7()                                                 Type: string(250)
 * @method string                                              getCustom8()                                                 Type: string(250)
 * @method string                                              getCustom9()                                                 Type: string(250)
 * @method string                                              getCustom10()                                                Type: string(250)
 * @method string                                              getPurgedAt()                                                Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Subunit                                             getSubDivision()                                             
 * @method JobTitle                                            getJobTitle()                                                
 * @method EmploymentStatus                                    getEmployeeStatus()                                          
 * @method Doctrine_Collection|Employee[]                      getSupervisors()                                             
 * @method Doctrine_Collection|Location[]                      getLocations()                                               
 * @method Doctrine_Collection|EmpDependent[]                  getDependents()                                              
 * @method Doctrine_Collection|EmpEmergencyContact[]           getEmergencyContacts()                                       
 * @method Doctrine_Collection|EmpWorkExperience[]             getWorkExperience()                                          
 * @method Doctrine_Collection|EmployeeEducation[]             getEducation()                                               
 * @method Doctrine_Collection|EmployeeSkill[]                 getSkills()                                                  
 * @method Doctrine_Collection|EmployeeLanguage[]              getLanguages()                                               
 * @method Doctrine_Collection|EmployeeSalary[]                getSalary()                                                  
 * @method Doctrine_Collection|EmpContract[]                   getContracts()                                               
 * @method Doctrine_Collection|EmployeeAttachment[]            getAttachments()                                             
 * @method Doctrine_Collection|ProjectAdmin[]                  getProjectAdmin()                                            
 * @method EmployeeTerminationRecord                           getEmployeeTerminationRecord()                               
 * @method Country                                             getEmployeeCountry()                                         
 * @method Nationality                                         getNationality()                                             
 * @method JobCategory                                         getJobCategory()                                             
 * @method Doctrine_Collection|AttendanceRecord[]              getAttendanceRecord()                                        
 * @method Doctrine_Collection|Post[]                          getPosts()                                                   
 * @method Doctrine_Collection|Share[]                         getShare()                                                   
 * @method Doctrine_Collection|Comment[]                       getComment()                                                 
 * @method BuzzNotificationMetadata                            getNotificationMetadata()                                    
 * @method Doctrine_Collection|SystemUser[]                    getSystemUser()                                              
 * @method Doctrine_Collection|LeaveEntitlement[]              getLeaveEntitlement()                                        
 * @method Doctrine_Collection|LeaveAdjustment[]               getLeaveAdjustment()                                         
 * @method Doctrine_Collection|LeaveRequest[]                  getLeaveRequest()                                            
 * @method Doctrine_Collection|LeaveRequestComment[]           getLeaveRequestComment()                                     
 * @method Doctrine_Collection|LeaveComment[]                  getLeaveComment()                                            
 * @method Doctrine_Collection|PerformanceReview[]             getPerformanceReview()                                       
 * @method Doctrine_Collection|Reviewer[]                      getReviewer()                                                
 * @method Doctrine_Collection|PerformanceTrack[]              getPerformanceTrack()                                        
 * @method Doctrine_Collection|PerformanceTrackerLog[]         getPerformanceTrackerLog()                                   
 * @method Doctrine_Collection|PerformanceTrackerReviewer[]    getPerformanceTrackerReviewer()                              
 * @method Doctrine_Collection|Employee[]                      getSubordinates()                                            
 * @method Doctrine_Collection|EmpPicture[]                    getEmpPicture()                                              
 * @method Doctrine_Collection|EmployeeImmigrationRecord[]     getEmployeeImmigrationRecord()                               
 * @method Doctrine_Collection|EmpUsTaxExemption[]             getEmpUsTaxExemption()                                       
 * @method Doctrine_Collection|EmployeeMembership[]            getEmployeeMembership()                                      
 * @method Doctrine_Collection|ReportTo[]                      getReportTo()                                                
 * @method Doctrine_Collection|EmployeeLicense[]               getEmployeeLicense()                                         
 * @method Doctrine_Collection|EmployeeWorkShift[]             getEmployeeWorkShift()                                       
 * @method Doctrine_Collection|EmployeeEducation[]             getEmployeeEducation()                                       
 * @method Doctrine_Collection|EmployeeEvent[]                 getEmployeeEvent()                                           
 * @method Doctrine_Collection|EmployeeSubscription[]          getEmployeeSubscription()                                    
 * @method Doctrine_Collection|JobVacancy[]                    getManagedVacancies()                                        
 * @method Doctrine_Collection|JobCandidate[]                  getJobCandidate()                                            
 * @method Doctrine_Collection|JobInterviewInterviewer[]       getJobInterviewInterviewer()                                 
 * @method Doctrine_Collection|CandidateHistory[]              getCandidateHistory()                                        
 * @method Doctrine_Collection|TimesheetItem[]                 getTimesheetItem()                                           
 * @method Doctrine_Collection|EmpChildren[]                   getEmpChildren()                                             
 *  
 * @method Employee                                            setEmpnumber(int $val)                                       Type: integer(4), primary key
 * @method Employee                                            setLastname(string $val)                                     Type: string(100)
 * @method Employee                                            setFirstname(string $val)                                    Type: string(100)
 * @method Employee                                            setMiddlename(string $val)                                   Type: string(100)
 * @method Employee                                            setNickname(string $val)                                     Type: string(100)
 * @method Employee                                            setSmoker(int $val)                                          Type: integer(2), default "0"
 * @method Employee                                            setSsn(string $val)                                          Type: string(100)
 * @method Employee                                            setSin(string $val)                                          Type: string(100)
 * @method Employee                                            setOtherid(string $val)                                      Type: string(100)
 * @method Employee                                            setLicenseno(string $val)                                    Type: string(100)
 * @method Employee                                            setMilitaryservice(string $val)                              Type: string(100)
 * @method Employee                                            setStreet1(string $val)                                      Type: string(100)
 * @method Employee                                            setStreet2(string $val)                                      Type: string(100)
 * @method Employee                                            setCity(string $val)                                         Type: string(100)
 * @method Employee                                            setCountry(string $val)                                      Type: string(100)
 * @method Employee                                            setProvince(string $val)                                     Type: string(100)
 * @method Employee                                            setEmployeeid(string $val)                                   Type: string(50)
 * @method Employee                                            setEthnicRaceCode(string $val)                               Type: string(13)
 * @method Employee                                            setEmpBirthday(string $val)                                  Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method Employee                                            setNationCode(int $val)                                      Type: integer
 * @method Employee                                            setEmpGender(int $val)                                       Type: integer(2)
 * @method Employee                                            setEmpMaritalStatus(string $val)                             Type: string(20)
 * @method Employee                                            setEmpDriLiceExpDate(string $val)                            Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method Employee                                            setEmpStatus(int $val)                                       Type: integer(13)
 * @method Employee                                            setJobTitleCode(int $val)                                    Type: integer(6)
 * @method Employee                                            setEeoCatCode(int $val)                                      Type: integer
 * @method Employee                                            setWorkStation(int $val)                                     Type: integer(4)
 * @method Employee                                            setEmpZipcode(string $val)                                   Type: string(20)
 * @method Employee                                            setEmpHmTelephone(string $val)                               Type: string(50)
 * @method Employee                                            setEmpMobile(string $val)                                    Type: string(50)
 * @method Employee                                            setEmpWorkTelephone(string $val)                             Type: string(50)
 * @method Employee                                            setEmpWorkEmail(string $val)                                 Type: string(50)
 * @method Employee                                            setSalGrdCode(string $val)                                   Type: string(13)
 * @method Employee                                            setJoinedDate(string $val)                                   Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method Employee                                            setEmpOthEmail(string $val)                                  Type: string(50)
 * @method Employee                                            setTerminationId(int $val)                                   Type: integer(4)
 * @method Employee                                            setCustom1(string $val)                                      Type: string(250)
 * @method Employee                                            setCustom2(string $val)                                      Type: string(250)
 * @method Employee                                            setCustom3(string $val)                                      Type: string(250)
 * @method Employee                                            setCustom4(string $val)                                      Type: string(250)
 * @method Employee                                            setCustom5(string $val)                                      Type: string(250)
 * @method Employee                                            setCustom6(string $val)                                      Type: string(250)
 * @method Employee                                            setCustom7(string $val)                                      Type: string(250)
 * @method Employee                                            setCustom8(string $val)                                      Type: string(250)
 * @method Employee                                            setCustom9(string $val)                                      Type: string(250)
 * @method Employee                                            setCustom10(string $val)                                     Type: string(250)
 * @method Employee                                            setPurgedAt(string $val)                                     Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Employee                                            setSubDivision(Subunit $val)                                 
 * @method Employee                                            setJobTitle(JobTitle $val)                                   
 * @method Employee                                            setEmployeeStatus(EmploymentStatus $val)                     
 * @method Employee                                            setSupervisors(Doctrine_Collection $val)                     
 * @method Employee                                            setLocations(Doctrine_Collection $val)                       
 * @method Employee                                            setDependents(Doctrine_Collection $val)                      
 * @method Employee                                            setEmergencyContacts(Doctrine_Collection $val)               
 * @method Employee                                            setWorkExperience(Doctrine_Collection $val)                  
 * @method Employee                                            setEducation(Doctrine_Collection $val)                       
 * @method Employee                                            setSkills(Doctrine_Collection $val)                          
 * @method Employee                                            setLanguages(Doctrine_Collection $val)                       
 * @method Employee                                            setSalary(Doctrine_Collection $val)                          
 * @method Employee                                            setContracts(Doctrine_Collection $val)                       
 * @method Employee                                            setAttachments(Doctrine_Collection $val)                     
 * @method Employee                                            setProjectAdmin(Doctrine_Collection $val)                    
 * @method Employee                                            setEmployeeTerminationRecord(EmployeeTerminationRecord $val) 
 * @method Employee                                            setEmployeeCountry(Country $val)                             
 * @method Employee                                            setNationality(Nationality $val)                             
 * @method Employee                                            setJobCategory(JobCategory $val)                             
 * @method Employee                                            setAttendanceRecord(Doctrine_Collection $val)                
 * @method Employee                                            setPosts(Doctrine_Collection $val)                           
 * @method Employee                                            setShare(Doctrine_Collection $val)                           
 * @method Employee                                            setComment(Doctrine_Collection $val)                         
 * @method Employee                                            setNotificationMetadata(BuzzNotificationMetadata $val)       
 * @method Employee                                            setSystemUser(Doctrine_Collection $val)                      
 * @method Employee                                            setLeaveEntitlement(Doctrine_Collection $val)                
 * @method Employee                                            setLeaveAdjustment(Doctrine_Collection $val)                 
 * @method Employee                                            setLeaveRequest(Doctrine_Collection $val)                    
 * @method Employee                                            setLeaveRequestComment(Doctrine_Collection $val)             
 * @method Employee                                            setLeaveComment(Doctrine_Collection $val)                    
 * @method Employee                                            setPerformanceReview(Doctrine_Collection $val)               
 * @method Employee                                            setReviewer(Doctrine_Collection $val)                        
 * @method Employee                                            setPerformanceTrack(Doctrine_Collection $val)                
 * @method Employee                                            setPerformanceTrackerLog(Doctrine_Collection $val)           
 * @method Employee                                            setPerformanceTrackerReviewer(Doctrine_Collection $val)      
 * @method Employee                                            setSubordinates(Doctrine_Collection $val)                    
 * @method Employee                                            setEmpPicture(Doctrine_Collection $val)                      
 * @method Employee                                            setEmployeeImmigrationRecord(Doctrine_Collection $val)       
 * @method Employee                                            setEmpUsTaxExemption(Doctrine_Collection $val)               
 * @method Employee                                            setEmployeeMembership(Doctrine_Collection $val)              
 * @method Employee                                            setReportTo(Doctrine_Collection $val)                        
 * @method Employee                                            setEmployeeLicense(Doctrine_Collection $val)                 
 * @method Employee                                            setEmployeeWorkShift(Doctrine_Collection $val)               
 * @method Employee                                            setEmployeeEducation(Doctrine_Collection $val)               
 * @method Employee                                            setEmployeeEvent(Doctrine_Collection $val)                   
 * @method Employee                                            setEmployeeSubscription(Doctrine_Collection $val)            
 * @method Employee                                            setManagedVacancies(Doctrine_Collection $val)                
 * @method Employee                                            setJobCandidate(Doctrine_Collection $val)                    
 * @method Employee                                            setJobInterviewInterviewer(Doctrine_Collection $val)         
 * @method Employee                                            setCandidateHistory(Doctrine_Collection $val)                
 * @method Employee                                            setTimesheetItem(Doctrine_Collection $val)                   
 * @method Employee                                            setEmpChildren(Doctrine_Collection $val)                     
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEmployee extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('hs_hr_employee');
        $this->hasColumn('emp_number as empNumber', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('emp_lastname as lastName', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'notnull' => true,
             'length' => 100,
             ));
        $this->hasColumn('emp_firstname as firstName', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'notnull' => true,
             'length' => 100,
             ));
        $this->hasColumn('emp_middle_name as middleName', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'notnull' => true,
             'length' => 100,
             ));
        $this->hasColumn('emp_nick_name as nickName', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('emp_smoker as smoker', 'integer', 2, array(
             'type' => 'integer',
             'default' => '0',
             'length' => 2,
             ));
        $this->hasColumn('emp_ssn_num as ssn', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('emp_sin_num as sin', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('emp_other_id as otherId', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('emp_dri_lice_num as licenseNo', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('emp_military_service as militaryService', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('emp_street1 as street1', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('emp_street2 as street2', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('city_code as city', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('coun_code as country', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('provin_code as province', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('employee_id as employeeId', 'string', 50, array(
             'type' => 'string',
             'default' => '',
             'length' => 50,
             ));
        $this->hasColumn('ethnic_race_code', 'string', 13, array(
             'type' => 'string',
             'length' => 13,
             ));
        $this->hasColumn('emp_birthday', 'date', 25, array(
             'type' => 'date',
             'length' => 25,
             ));
        $this->hasColumn('nation_code', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('emp_gender', 'integer', 2, array(
             'type' => 'integer',
             'length' => 2,
             ));
        $this->hasColumn('emp_marital_status', 'string', 20, array(
             'type' => 'string',
             'length' => 20,
             ));
        $this->hasColumn('emp_dri_lice_exp_date', 'date', 25, array(
             'type' => 'date',
             'length' => 25,
             ));
        $this->hasColumn('emp_status', 'integer', 13, array(
             'type' => 'integer',
             'length' => 13,
             ));
        $this->hasColumn('job_title_code', 'integer', 6, array(
             'type' => 'integer',
             'length' => 6,
             ));
        $this->hasColumn('eeo_cat_code', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('work_station', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
        $this->hasColumn('emp_zipcode', 'string', 20, array(
             'type' => 'string',
             'length' => 20,
             ));
        $this->hasColumn('emp_hm_telephone', 'string', 50, array(
             'type' => 'string',
             'length' => 50,
             ));
        $this->hasColumn('emp_mobile', 'string', 50, array(
             'type' => 'string',
             'length' => 50,
             ));
        $this->hasColumn('emp_work_telephone', 'string', 50, array(
             'type' => 'string',
             'length' => 50,
             ));
        $this->hasColumn('emp_work_email', 'string', 50, array(
             'type' => 'string',
             'length' => 50,
             ));
        $this->hasColumn('sal_grd_code', 'string', 13, array(
             'type' => 'string',
             'length' => 13,
             ));
        $this->hasColumn('joined_date', 'date', 25, array(
             'type' => 'date',
             'length' => 25,
             ));
        $this->hasColumn('emp_oth_email', 'string', 50, array(
             'type' => 'string',
             'length' => 50,
             ));
        $this->hasColumn('termination_id', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
        $this->hasColumn('custom1', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('custom2', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('custom3', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('custom4', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('custom5', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('custom6', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('custom7', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('custom8', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('custom9', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('custom10', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('purged_at', 'timestamp', null, array(
             'type' => 'timestamp',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Subunit as subDivision', array(
             'local' => 'work_station',
             'foreign' => 'id'));

        $this->hasOne('JobTitle as jobTitle', array(
             'local' => 'job_title_code',
             'foreign' => 'id'));

        $this->hasOne('EmploymentStatus as employeeStatus', array(
             'local' => 'emp_status',
             'foreign' => 'id'));

        $this->hasMany('Employee as supervisors', array(
             'refClass' => 'ReportTo',
             'local' => 'erep_sub_emp_number',
             'foreign' => 'erep_sup_emp_number'));

        $this->hasMany('Location as locations', array(
             'refClass' => 'EmpLocations',
             'local' => 'emp_number',
             'foreign' => 'location_id'));

        $this->hasMany('EmpDependent as dependents', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('EmpEmergencyContact as emergencyContacts', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('EmpWorkExperience as workExperience', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('EmployeeEducation as education', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('EmployeeSkill as skills', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('EmployeeLanguage as languages', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('EmployeeSalary as salary', array(
             'local' => 'empNumber',
             'foreign' => 'empNumber'));

        $this->hasMany('EmpContract as contracts', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('EmployeeAttachment as attachments', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('ProjectAdmin as projectAdmin', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasOne('EmployeeTerminationRecord', array(
             'local' => 'termination_id',
             'foreign' => 'id'));

        $this->hasOne('Country as EmployeeCountry', array(
             'local' => 'coun_code',
             'foreign' => 'cou_code'));

        $this->hasOne('Nationality', array(
             'local' => 'nation_code',
             'foreign' => 'id'));

        $this->hasOne('JobCategory', array(
             'local' => 'eeo_cat_code',
             'foreign' => 'id'));

        $this->hasMany('AttendanceRecord', array(
             'local' => 'empNumber',
             'foreign' => 'employeeId'));

        $this->hasMany('Post as posts', array(
             'local' => 'empNumber',
             'foreign' => 'employee_number'));

        $this->hasMany('Share as share', array(
             'local' => 'empNumber',
             'foreign' => 'employee_number'));

        $this->hasMany('Comment as comment', array(
             'local' => 'empNumber',
             'foreign' => 'employee_number'));

        $this->hasOne('BuzzNotificationMetadata as NotificationMetadata', array(
             'local' => 'empNumber',
             'foreign' => 'employee_number'));

        $this->hasMany('SystemUser', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('LeaveEntitlement', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('LeaveAdjustment', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('LeaveRequest', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('LeaveRequestComment', array(
             'local' => 'emp_number',
             'foreign' => 'created_by_emp_number'));

        $this->hasMany('LeaveComment', array(
             'local' => 'emp_number',
             'foreign' => 'created_by_emp_number'));

        $this->hasMany('PerformanceReview', array(
             'local' => 'emp_number',
             'foreign' => 'employee_number'));

        $this->hasMany('Reviewer', array(
             'local' => 'emp_number',
             'foreign' => 'employee_number'));

        $this->hasMany('PerformanceTrack', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('PerformanceTrackerLog', array(
             'local' => 'emp_number',
             'foreign' => 'reviewer_id'));

        $this->hasMany('PerformanceTrackerReviewer', array(
             'local' => 'emp_number',
             'foreign' => 'reviewer_id'));

        $this->hasMany('Employee as subordinates', array(
             'refClass' => 'ReportTo',
             'local' => 'erep_sup_emp_number',
             'foreign' => 'erep_sub_emp_number'));

        $this->hasMany('EmpPicture', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('EmployeeImmigrationRecord', array(
             'local' => 'empNumber',
             'foreign' => 'empNumber'));

        $this->hasMany('EmpUsTaxExemption', array(
             'local' => 'empNumber',
             'foreign' => 'empNumber'));

        $this->hasMany('EmployeeMembership', array(
             'local' => 'empNumber',
             'foreign' => 'empNumber'));

        $this->hasMany('ReportTo', array(
             'local' => 'emp_number',
             'foreign' => 'erep_sup_emp_number'));

        $this->hasMany('EmployeeLicense', array(
             'local' => 'empNumber',
             'foreign' => 'empNumber'));

        $this->hasMany('EmployeeWorkShift', array(
             'local' => 'empNumber',
             'foreign' => 'emp_number'));

        $this->hasMany('EmployeeEducation', array(
             'local' => 'empNumber',
             'foreign' => 'empNumber'));

        $this->hasMany('EmployeeEvent', array(
             'local' => 'emp_number',
             'foreign' => 'employee_id'));

        $this->hasMany('EmployeeSubscription', array(
             'local' => 'emp_number',
             'foreign' => 'employee_id'));

        $this->hasMany('JobVacancy as managedVacancies', array(
             'local' => 'empNumber',
             'foreign' => 'hiringManagerId'));

        $this->hasMany('JobCandidate', array(
             'local' => 'empNumber',
             'foreign' => 'addedPerson'));

        $this->hasMany('JobInterviewInterviewer', array(
             'local' => 'empNumber',
             'foreign' => 'interviewerId'));

        $this->hasMany('CandidateHistory', array(
             'local' => 'empNumber',
             'foreign' => 'performedBy'));

        $this->hasMany('TimesheetItem', array(
             'local' => 'empNumber',
             'foreign' => 'employeeId'));

        $this->hasMany('EmpChildren', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));
    }
}