/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.util;

import java.io.Serializable;
import java.util.Arrays;
import org.trie4j.util.BitSet;

public class FastBitSet
implements Serializable,
BitSet {
    private int size;
    private byte[] bytes = new byte[0];
    private static final long serialVersionUID = -3346250300546707823L;

    public FastBitSet() {
    }

    public FastBitSet(int bitSize) {
        this.bytes = new byte[bitSize / 8 + 1];
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int n = Math.min(this.size, 32);
        for (int i = 0; i < n; ++i) {
            b.append((this.bytes[i / 8] & 128 >> i % 8) != 0 ? "1" : "0");
        }
        return b.toString();
    }

    @Override
    public int size() {
        return this.size;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public boolean get(int index) {
        return (this.bytes[index / 8] & 128 >> index % 8) != 0;
    }

    public void set(int index) {
        if (this.size <= index) {
            if (index / 8 >= this.bytes.length) {
                this.extend(index);
            }
            this.size = index + 1;
        }
        int n = index / 8;
        this.bytes[n] = (byte)(this.bytes[n] | 128 >> index % 8);
    }

    public void unset(int index) {
        if (this.size <= index) {
            if (index / 8 >= this.bytes.length) {
                this.extend(index);
            }
            this.size = index + 1;
        }
        int n = index / 8;
        this.bytes[n] = (byte)(this.bytes[n] & ~(128 >> index % 8));
    }

    public void unsetIfLE(int index) {
        if (this.size <= index) {
            if (index / 8 >= this.bytes.length) {
                this.extend(index);
            }
            this.size = index + 1;
        }
    }

    public void ensureCapacity(int index) {
        if (index / 8 >= this.bytes.length) {
            this.extend(index);
        }
    }

    public void trimToSize() {
        int sz = this.size / 8 + 1;
        if (this.bytes.length > sz) {
            this.bytes = Arrays.copyOf(this.bytes, sz);
        }
    }

    private void extend(int index) {
        this.bytes = Arrays.copyOf(this.bytes, Math.max(index / 8 + 1, (int)((double)this.bytes.length * 1.5)));
    }
}

