/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.io.IOException;
import org.caffinitas.ohc.linked.AbstractOffHeapDataOutput;
import org.caffinitas.ohc.linked.Hasher;

final class HashEntryKeyOutput
extends AbstractOffHeapDataOutput {
    final long keyLen;

    HashEntryKeyOutput(long hashEntryAdr, long keyLen) {
        super(hashEntryAdr, 56L, keyLen);
        this.keyLen = keyLen;
    }

    long hash(Hasher hasher) {
        return hasher.hash(this.blkAdr, 56L, (int)this.keyLen);
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56 & 0xFFL));
        this.write((int)(v >>> 48 & 0xFFL));
        this.write((int)(v >>> 40 & 0xFFL));
        this.write((int)(v >>> 32 & 0xFFL));
        this.write((int)(v >>> 24 & 0xFFL));
        this.write((int)(v >>> 16 & 0xFFL));
        this.write((int)(v >>> 8 & 0xFFL));
        this.write((int)(v & 0xFFL));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }
}

