/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.ByteLookupContainer;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import java.util.Arrays;

abstract class AbstractByteCollection
implements ByteCollection {
    AbstractByteCollection() {
    }

    @Override
    public int removeAll(final ByteLookupContainer c) {
        return this.removeAll(new BytePredicate(){

            @Override
            public boolean apply(byte k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final ByteLookupContainer c) {
        return this.removeAll(new BytePredicate(){

            @Override
            public boolean apply(byte k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final BytePredicate predicate) {
        return this.removeAll(new BytePredicate(){

            @Override
            public boolean apply(byte value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public byte[] toArray() {
        byte[] array = new byte[this.size()];
        int i = 0;
        for (ByteCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

