/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Paint;
import java.util.Arrays;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.graph.Area;
import org.rrd4j.graph.SourcedPlotElement;

public class ConstantArea
extends Area {
    private final double value;

    ConstantArea(double value, Paint color, SourcedPlotElement parent) {
        super(Double.toString(value), color, parent);
        this.value = value;
    }

    @Override
    void assignValues(DataProcessor dproc) {
        this.values = new double[dproc.getTimestamps().length];
        Arrays.fill(this.values, this.value);
        if (this.parent != null) {
            double[] parentValues = this.parent.getValues();
            for (int i = 0; i < this.values.length; ++i) {
                if (Double.isNaN(parentValues[i])) continue;
                int n = i;
                this.values[n] = this.values[n] + parentValues[i];
            }
        }
    }
}

