#
# Try to reprodue PR 53311
# Based on kgdb_trap.py
# Use with noemu (because qemu bug interacting with bootblocks)
#

from __future__ import print_function

import os
import anita
import pexpect

from bracket import *

name = 'boot_d'

def test_func(ts):
    dist = anita.URL(anita_dist_url(ts))
    # vmm_args = ['--no-kvm']
    a = anita.Anita(dist, workdir = anita_workdir(ts), no_install = True,
                    vmm = 'noemu', vmm_args = ['--conf', './noemu.conf'])
    child = a.start_boot()
    child.expect("(.). Drop to boot prompt")
    option_no = child.match.group(1)
    print("option number is", option_no)
    #child.expect("Option: ")
    child.send(option_no) # + "\r")
    # Wait for boot prompt
    child.expect("> ")
    child.send("boot -d\r")
    try:
        child.expect(r'db\{0\}', timeout = 120)
        print("got debugger prompt")
    except pexpect.TIMEOUT:
        print("got timeout")
        return False
    return True

def op():
    return TestOp(test_func, [install_op], name = name)
