/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.sketch.AbstractBitSketch;
import edu.umd.marbl.mhap.sketch.MinHashSketch;
import edu.umd.marbl.mhap.sketch.ZeroNGramsFoundException;

public final class MinHashBitSketch
extends AbstractBitSketch<MinHashBitSketch> {
    private static final long serialVersionUID = -44448450811302477L;

    private static final long[] getAsBits(int[] minHashes) {
        int numWords = minHashes.length / 64;
        long[] bits = new long[numWords];
        long mask = 1L;
        int bitCount = 0;
        int wordCount = 0;
        for (int word = 0; word < numWords; ++word) {
            long currWord = 0L;
            for (int bit = 0; bit < 64; ++bit) {
                currWord = currWord << 1 | (long)minHashes[bitCount] & mask;
                ++bitCount;
            }
            bits[wordCount] = currWord;
            ++wordCount;
        }
        return bits;
    }

    public MinHashBitSketch(long[] bits) {
        super(bits);
    }

    public MinHashBitSketch(int[] minHashes) {
        super(MinHashBitSketch.getAsBits(minHashes));
    }

    public MinHashBitSketch(String seq, int nGramSize, int numWords, boolean doReverseCompliment) throws ZeroNGramsFoundException {
        super(MinHashBitSketch.getAsBits(new MinHashSketch(seq, nGramSize, numWords * 64, doReverseCompliment).getMinHashArray()));
    }

    public final double jaccard(MinHashBitSketch sh) {
        int count = this.getIntersectionCount(sh);
        double sim = (double)count / (double)this.numberOfBits();
        double jaccard = (sim - 0.5) * 2.0;
        return Math.max(0.0, jaccard);
    }
}

