/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.security.authz.interceptor.FieldAndDocumentLevelSecurityRequestInterceptor;

public class SearchRequestInterceptor
extends FieldAndDocumentLevelSecurityRequestInterceptor {
    public SearchRequestInterceptor(ThreadPool threadPool, XPackLicenseState licenseState) {
        super(threadPool.getThreadContext(), licenseState);
    }

    @Override
    public void disableFeatures(IndicesRequest indicesRequest, boolean fieldLevelSecurityEnabled, boolean documentLevelSecurityEnabled, ActionListener<Void> listener) {
        SearchRequest request = (SearchRequest)indicesRequest;
        request.requestCache(Boolean.valueOf(false));
        if (documentLevelSecurityEnabled) {
            if (request.source() != null && request.source().suggest() != null) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Suggest isn't supported if document level security is enabled", RestStatus.BAD_REQUEST, new Object[0])));
            } else if (request.source() != null && request.source().profile()) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("A search request cannot be profiled if document level security is enabled", RestStatus.BAD_REQUEST, new Object[0])));
            } else {
                listener.onResponse(null);
            }
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    public boolean supports(IndicesRequest request) {
        return request instanceof SearchRequest;
    }
}

