/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReloadGlobalIndexTask
extends Task {
    static final String RELOAD_GLOBAL_INDEX_TASK_CLASS = "com.unboundid.directory.proxy.tasks.ReloadTask";
    private static final String ATTR_BACKGROUND_RELOAD = "ds-task-reload-background";
    private static final String ATTR_BASE_DN = "ds-task-reload-base-dn";
    private static final String ATTR_INDEX_NAME = "ds-task-reload-index-name";
    private static final String ATTR_MAX_ENTRIES_PER_SECOND = "ds-task-search-entry-per-second";
    private static final String ATTR_RELOAD_FROM_DS = "ds-task-reload-from-ds";
    private static final String OC_RELOAD_GLOBAL_INDEX_TASK = "ds-task-reload-index";
    private static final TaskProperty PROPERTY_BACKGROUND_RELOAD = new TaskProperty("ds-task-reload-background", TaskMessages.INFO_DISPLAY_NAME_RELOAD_GLOBAL_INDEX_BACKGROUND.get(), TaskMessages.INFO_DESCRIPTION_RELOAD_GLOBAL_INDEX_BACKGROUND.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_BASE_DN = new TaskProperty("ds-task-reload-base-dn", TaskMessages.INFO_DISPLAY_NAME_RELOAD_GLOBAL_INDEX_BASE_DN.get(), TaskMessages.INFO_DESCRIPTION_RELOAD_GLOBAL_INDEX_BASE_DN.get(), String.class, true, false, false);
    private static final TaskProperty PROPERTY_INDEX_NAME = new TaskProperty("ds-task-reload-index-name", TaskMessages.INFO_DISPLAY_NAME_RELOAD_GLOBAL_INDEX_ATTR_NAME.get(), TaskMessages.INFO_DESCRIPTION_RELOAD_GLOBAL_INDEX_ATTR_NAME.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_MAX_ENTRIES_PER_SECOND = new TaskProperty("ds-task-search-entry-per-second", TaskMessages.INFO_DISPLAY_NAME_RELOAD_GLOBAL_INDEX_MAX_ENTRIES_PER_SECOND.get(), TaskMessages.INFO_DESCRIPTION_RELOAD_GLOBAL_INDEX_MAX_ENTRIES_PER_SECOND.get(), Long.class, false, false, false);
    static final TaskProperty PROPERTY_RELOAD_FROM_DS = new TaskProperty("ds-task-reload-from-ds", TaskMessages.INFO_DISPLAY_NAME_RELOAD_GLOBAL_INDEX_RELOAD_FROM_DS.get(), TaskMessages.INFO_DESCRIPTION_RELOAD_GLOBAL_INDEX_RELOAD_FROM_DS.get(), Boolean.class, false, false, false);
    private static final long serialVersionUID = 9152807987055252560L;
    private final Boolean reloadFromDS;
    private final Boolean reloadInBackground;
    private final List<String> indexNames;
    private final Long maxEntriesPerSecond;
    private final String baseDN;

    public ReloadGlobalIndexTask() {
        this.reloadFromDS = null;
        this.reloadInBackground = null;
        this.indexNames = null;
        this.maxEntriesPerSecond = null;
        this.baseDN = null;
    }

    public ReloadGlobalIndexTask(String taskID, String baseDN, List<String> indexNames, Boolean reloadFromDS, Boolean reloadInBackground, Long maxEntriesPerSecond) {
        this(taskID, baseDN, indexNames, reloadFromDS, reloadInBackground, maxEntriesPerSecond, null, null, null, null, null);
    }

    public ReloadGlobalIndexTask(String taskID, String baseDN, List<String> indexNames, Boolean reloadFromDS, Boolean reloadInBackground, Long maxEntriesPerSecond, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        this(taskID, baseDN, indexNames, reloadFromDS, reloadInBackground, maxEntriesPerSecond, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public ReloadGlobalIndexTask(String taskID, String baseDN, List<String> indexNames, Boolean reloadFromDS, Boolean reloadInBackground, Long maxEntriesPerSecond, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnStart, List<String> notifyOnCompletion, List<String> notifyOnSuccess, List<String> notifyOnError, Boolean alertOnStart, Boolean alertOnSuccess, Boolean alertOnError) {
        super(taskID, RELOAD_GLOBAL_INDEX_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        Validator.ensureNotNull(baseDN);
        this.baseDN = baseDN;
        this.reloadFromDS = reloadFromDS;
        this.reloadInBackground = reloadInBackground;
        this.maxEntriesPerSecond = maxEntriesPerSecond;
        this.indexNames = indexNames == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(indexNames));
    }

    public ReloadGlobalIndexTask(Entry entry) throws TaskException {
        super(entry);
        this.baseDN = entry.getAttributeValue(ATTR_BASE_DN);
        if (this.baseDN == null) {
            throw new TaskException(TaskMessages.ERR_RELOAD_GLOBAL_INDEX_MISSING_REQUIRED_ATTR.get(ATTR_BASE_DN));
        }
        String[] nameArray = entry.getAttributeValues(ATTR_INDEX_NAME);
        this.indexNames = nameArray == null || nameArray.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(nameArray));
        this.reloadFromDS = entry.getAttributeValueAsBoolean(ATTR_RELOAD_FROM_DS);
        this.reloadInBackground = entry.getAttributeValueAsBoolean(ATTR_BACKGROUND_RELOAD);
        this.maxEntriesPerSecond = entry.getAttributeValueAsLong(ATTR_MAX_ENTRIES_PER_SECOND);
    }

    public ReloadGlobalIndexTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(RELOAD_GLOBAL_INDEX_TASK_CLASS, properties);
        ArrayList<String> attrs = new ArrayList<String>(10);
        Boolean background = null;
        Boolean fromDS = null;
        Long maxPerSecond = null;
        String baseDNStr = null;
        for (Map.Entry<TaskProperty, List<Object>> e : properties.entrySet()) {
            TaskProperty p = e.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = e.getValue();
            if (attrName.equalsIgnoreCase(ATTR_BASE_DN)) {
                baseDNStr = ReloadGlobalIndexTask.parseString(p, values, null);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INDEX_NAME)) {
                String[] nameArray = ReloadGlobalIndexTask.parseStrings(p, values, null);
                if (nameArray == null) continue;
                attrs.addAll(Arrays.asList(nameArray));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_RELOAD_FROM_DS)) {
                fromDS = ReloadGlobalIndexTask.parseBoolean(p, values, null);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_BACKGROUND_RELOAD)) {
                background = ReloadGlobalIndexTask.parseBoolean(p, values, null);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_MAX_ENTRIES_PER_SECOND)) continue;
            maxPerSecond = ReloadGlobalIndexTask.parseLong(p, values, null);
        }
        if (baseDNStr == null) {
            throw new TaskException(TaskMessages.ERR_RELOAD_GLOBAL_INDEX_MISSING_REQUIRED_PROPERTY.get(ATTR_BASE_DN));
        }
        this.baseDN = baseDNStr;
        this.indexNames = Collections.unmodifiableList(attrs);
        this.reloadFromDS = fromDS;
        this.reloadInBackground = background;
        this.maxEntriesPerSecond = maxPerSecond;
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_RELOAD_GLOBAL_INDEX.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_RELOAD_GLOBAL_INDEX.get();
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public List<String> getIndexNames() {
        return this.indexNames;
    }

    public Boolean reloadFromDS() {
        return this.reloadFromDS;
    }

    public Boolean reloadInBackground() {
        return this.reloadInBackground;
    }

    public Long getMaxEntriesPerSecond() {
        return this.maxEntriesPerSecond;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_RELOAD_GLOBAL_INDEX_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(5);
        attrList.add(new Attribute(ATTR_BASE_DN, this.baseDN));
        if (!this.indexNames.isEmpty()) {
            attrList.add(new Attribute(ATTR_INDEX_NAME, this.indexNames));
        }
        if (this.reloadFromDS != null) {
            attrList.add(new Attribute(ATTR_RELOAD_FROM_DS, String.valueOf(this.reloadFromDS)));
        }
        if (this.reloadInBackground != null) {
            attrList.add(new Attribute(ATTR_BACKGROUND_RELOAD, String.valueOf(this.reloadInBackground)));
        }
        if (this.maxEntriesPerSecond != null) {
            attrList.add(new Attribute(ATTR_MAX_ENTRIES_PER_SECOND, String.valueOf(this.maxEntriesPerSecond)));
        }
        return attrList;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_BASE_DN, PROPERTY_INDEX_NAME, PROPERTY_RELOAD_FROM_DS, PROPERTY_BACKGROUND_RELOAD, PROPERTY_MAX_ENTRIES_PER_SECOND));
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(15);
        props.put(PROPERTY_BASE_DN, Collections.singletonList(this.baseDN));
        props.put(PROPERTY_INDEX_NAME, Collections.unmodifiableList(this.indexNames));
        if (this.reloadFromDS == null) {
            props.put(PROPERTY_RELOAD_FROM_DS, Collections.emptyList());
        } else {
            props.put(PROPERTY_RELOAD_FROM_DS, Collections.singletonList(this.reloadFromDS));
        }
        if (this.reloadInBackground == null) {
            props.put(PROPERTY_BACKGROUND_RELOAD, Collections.emptyList());
        } else {
            props.put(PROPERTY_BACKGROUND_RELOAD, Collections.singletonList(this.reloadInBackground));
        }
        if (this.maxEntriesPerSecond == null) {
            props.put(PROPERTY_MAX_ENTRIES_PER_SECOND, Collections.emptyList());
        } else {
            props.put(PROPERTY_MAX_ENTRIES_PER_SECOND, Collections.singletonList(this.maxEntriesPerSecond));
        }
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

