/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.util.Arrays;

public interface DeprecationHandler {
    public static final DeprecationHandler THROW_UNSUPPORTED_OPERATION = new DeprecationHandler(){

        @Override
        public void usedDeprecatedField(String usedName, String replacedWith) {
            throw new UnsupportedOperationException("deprecated fields not supported here but got [" + usedName + "] which is a deprecated name for [" + replacedWith + "]");
        }

        @Override
        public void usedDeprecatedName(String usedName, String modernName) {
            throw new UnsupportedOperationException("deprecated fields not supported here but got [" + usedName + "] which has been replaced with [" + modernName + "]");
        }

        @Override
        public void deprecated(String message, Object ... params) {
            throw new UnsupportedOperationException("deprecations are not supported here but got [" + message + "] and " + Arrays.toString(params));
        }
    };

    public void usedDeprecatedName(String var1, String var2);

    public void usedDeprecatedField(String var1, String var2);

    public void deprecated(String var1, Object ... var2);
}

