/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfigReader;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.job.JobManager;

public class TransportPreviewDatafeedAction
extends HandledTransportAction<PreviewDatafeedAction.Request, PreviewDatafeedAction.Response> {
    private final Client client;
    private final ClusterService clusterService;
    private final JobManager jobManager;
    private final DatafeedConfigReader datafeedConfigReader;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportPreviewDatafeedAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, JobManager jobManager, NamedXContentRegistry xContentRegistry, ClusterService clusterService) {
        super(settings, "cluster:admin/xpack/ml/datafeeds/preview", threadPool, transportService, actionFilters, indexNameExpressionResolver, PreviewDatafeedAction.Request::new);
        this.client = client;
        this.clusterService = clusterService;
        this.jobManager = jobManager;
        this.datafeedConfigReader = new DatafeedConfigReader(client, xContentRegistry);
        this.xContentRegistry = xContentRegistry;
    }

    protected void doExecute(PreviewDatafeedAction.Request request, final ActionListener<PreviewDatafeedAction.Response> listener) {
        this.datafeedConfigReader.datafeedConfig(request.getDatafeedId(), this.clusterService.state(), (ActionListener<DatafeedConfig>)ActionListener.wrap(datafeedConfig -> this.jobManager.getJob(datafeedConfig.getJobId(), (ActionListener<Job>)ActionListener.wrap(job -> {
            DatafeedConfig.Builder previewDatafeed = TransportPreviewDatafeedAction.buildPreviewDatafeed(datafeedConfig);
            Map<String, String> headers = this.threadPool.getThreadContext().getHeaders().entrySet().stream().filter(e -> ClientHelper.SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            previewDatafeed.setHeaders(headers);
            DataExtractorFactory.create(this.client, previewDatafeed.build(), job, this.xContentRegistry, new ActionListener<DataExtractorFactory>(){

                public void onResponse(DataExtractorFactory dataExtractorFactory) {
                    DataExtractor dataExtractor = dataExtractorFactory.newExtractor(0L, Long.MAX_VALUE);
                    TransportPreviewDatafeedAction.this.threadPool.generic().execute(() -> TransportPreviewDatafeedAction.previewDatafeed(dataExtractor, (ActionListener<PreviewDatafeedAction.Response>)listener));
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    static DatafeedConfig.Builder buildPreviewDatafeed(DatafeedConfig datafeed) {
        DatafeedConfig.Builder previewDatafeed = new DatafeedConfig.Builder(datafeed);
        if (!datafeed.hasAggregations()) {
            previewDatafeed.setChunkingConfig(ChunkingConfig.newAuto());
        }
        return previewDatafeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void previewDatafeed(DataExtractor dataExtractor, ActionListener<PreviewDatafeedAction.Response> listener) {
        try {
            Optional inputStream = dataExtractor.next();
            StringBuilder responseBuilder = new StringBuilder("[");
            if (inputStream.isPresent()) {
                try (BufferedReader buffer = new BufferedReader(new InputStreamReader((InputStream)inputStream.get(), StandardCharsets.UTF_8));){
                    responseBuilder.append(buffer.lines().collect(Collectors.joining(" ")).replace("} {", "},{"));
                }
            }
            responseBuilder.append("]");
            listener.onResponse((Object)new PreviewDatafeedAction.Response((BytesReference)new BytesArray(responseBuilder.toString().getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
        finally {
            dataExtractor.cancel();
        }
    }
}

