/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;

public class ScheduledEventsWriter {
    private static final String SCHEDULED_EVENT_PREFIX = "scheduledevent.";
    private static final String SCHEDULED_EVENT_DESCRIPTION_SUFFIX = ".description";
    private static final String RULES_SUFFIX = ".rules";
    private final Collection<ScheduledEvent> scheduledEvents;
    private final TimeValue bucketSpan;
    private final StringBuilder buffer;

    public ScheduledEventsWriter(Collection<ScheduledEvent> scheduledEvents, TimeValue bucketSpan, StringBuilder buffer) {
        this.scheduledEvents = Objects.requireNonNull(scheduledEvents);
        this.bucketSpan = Objects.requireNonNull(bucketSpan);
        this.buffer = Objects.requireNonNull(buffer);
    }

    public void write() throws IOException {
        int eventIndex = 0;
        for (ScheduledEvent event : this.scheduledEvents) {
            StringBuilder eventContent = new StringBuilder();
            eventContent.append(SCHEDULED_EVENT_PREFIX).append(eventIndex).append(SCHEDULED_EVENT_DESCRIPTION_SUFFIX).append(" = ").append(event.getDescription()).append('\n');
            eventContent.append(SCHEDULED_EVENT_PREFIX).append(eventIndex).append(RULES_SUFFIX).append(" = ");
            try (XContentBuilder contentBuilder = XContentFactory.jsonBuilder();){
                contentBuilder.startArray();
                event.toDetectionRule(this.bucketSpan).toXContent(contentBuilder, null);
                contentBuilder.endArray();
                eventContent.append(Strings.toString((XContentBuilder)contentBuilder));
            }
            eventContent.append('\n');
            this.buffer.append(eventContent.toString());
            ++eventIndex;
        }
    }
}

