/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.xpack.core.indexlifecycle.AsyncActionStep;
import org.elasticsearch.xpack.core.indexlifecycle.Step;

final class OpenFollowerIndexStep
extends AsyncActionStep {
    static final String NAME = "open-follower-index";

    OpenFollowerIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public void performAction(IndexMetaData indexMetaData, ClusterState currentClusterState, ClusterStateObserver observer, AsyncActionStep.Listener listener) {
        OpenIndexRequest request = new OpenIndexRequest(new String[]{indexMetaData.getIndex().getName()});
        this.getClient().admin().indices().open(request, ActionListener.wrap(r -> {
            assert (r.isAcknowledged()) : "open index response is not acknowledged";
            listener.onResponse(true);
        }, listener::onFailure));
    }
}

