/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.kafka.trogdor.rest.CreateWorkerRequest;
import org.apache.kafka.trogdor.rest.CreateWorkerResponse;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.JsonRestServer;
import org.apache.kafka.trogdor.rest.StopWorkerRequest;
import org.apache.kafka.trogdor.rest.StopWorkerResponse;

public class AgentClient {
    private final int maxTries;
    private final String target;

    public AgentClient(int maxTries, String host, int port) {
        this(maxTries, String.format("%s:%d", host, port));
    }

    public AgentClient(int maxTries, String target) {
        this.target = target;
        this.maxTries = maxTries;
    }

    public String target() {
        return this.target;
    }

    public int maxTries() {
        return this.maxTries;
    }

    private String url(String suffix) {
        return String.format("http://%s%s", this.target, suffix);
    }

    public AgentStatusResponse status() throws Exception {
        JsonRestServer.HttpResponse<AgentStatusResponse> resp = JsonRestServer.httpRequest(this.url("/agent/status"), "GET", null, new TypeReference<AgentStatusResponse>(){}, this.maxTries);
        return resp.body();
    }

    public CreateWorkerResponse createWorker(CreateWorkerRequest request) throws Exception {
        JsonRestServer.HttpResponse<CreateWorkerResponse> resp = JsonRestServer.httpRequest(this.url("/agent/worker/create"), "POST", request, new TypeReference<CreateWorkerResponse>(){}, this.maxTries);
        return resp.body();
    }

    public StopWorkerResponse stopWorker(StopWorkerRequest request) throws Exception {
        JsonRestServer.HttpResponse<StopWorkerResponse> resp = JsonRestServer.httpRequest(this.url("/agent/worker/stop"), "PUT", request, new TypeReference<StopWorkerResponse>(){}, this.maxTries);
        return resp.body();
    }

    public void invokeShutdown() throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.url("/agent/shutdown"), "PUT", null, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"trogdor-agent-client").defaultHelp(true).description("The Trogdor fault injection agent client.");
        parser.addArgument(new String[]{"target"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("target").metavar(new String[]{"TARGET"}).help("A colon-separated host and port pair.  For example, example.com:8888");
        MutuallyExclusiveGroup actions = parser.addMutuallyExclusiveGroup();
        actions.addArgument(new String[]{"--status"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("status").help("Get agent status.");
        actions.addArgument(new String[]{"--create-worker"}).action((ArgumentAction)Arguments.store()).type(String.class).dest("create_worker").metavar(new String[]{"SPEC_JSON"}).help("Create a new fault.");
        actions.addArgument(new String[]{"--stop-worker"}).action((ArgumentAction)Arguments.store()).type(String.class).dest("stop_worker").metavar(new String[]{"SPEC_JSON"}).help("Create a new fault.");
        actions.addArgument(new String[]{"--shutdown"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("shutdown").help("Trigger agent shutdown");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit((int)0);
            }
            parser.handleError(e);
            Exit.exit((int)1);
        }
        String target = res.getString("target");
        AgentClient client = new AgentClient(3, target);
        if (res.getBoolean("status").booleanValue()) {
            System.out.println("Got agent status: " + JsonUtil.toPrettyJsonString(client.status()));
        } else if (res.getString("create_worker") != null) {
            client.createWorker((CreateWorkerRequest)JsonUtil.JSON_SERDE.readValue(res.getString("create_worker"), CreateWorkerRequest.class));
            System.out.println("Created fault.");
        } else if (res.getBoolean("shutdown").booleanValue()) {
            client.invokeShutdown();
            System.out.println("Sent shutdown request.");
        } else {
            System.out.println("You must choose an action. Type --help for help.");
            Exit.exit((int)1);
        }
    }
}

