/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.DelayedTxnMarker;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u0001\u0003\u0001%\u00111\u0005\u0016:b]N\f7\r^5p]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005YAO]1og\u0006\u001cG/[8o\u0015\t)a!A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002C\u0001\u000b\u0001\u001b\u0005\u0011\u0001b\u0002\f\u0001\u0005\u0004%IaF\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003a\u0001\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\rM,'O^3s\u0013\ti\"DA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0005\u0007?\u0001\u0001\u000b\u0011\u0002\r\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0013!\u00048fi^|'o[\"mS\u0016tG/F\u0001$!\t!C&D\u0001&\u0015\t1s%A\u0004dY&,g\u000e^:\u000b\u0005\u001dA#BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001eL!!L\u0013\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u0011\u0019y\u0003\u0001)A\u0005G\u0005qa.\u001a;x_J\\7\t\\5f]R\u0004\u0003bB\u0019\u0001\u0005\u0004%IAM\u0001\u0010ibt7\u000b^1uK6\u000bg.Y4feV\t1\u0007\u0005\u0002\u0015i%\u0011QG\u0001\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJDaa\u000e\u0001!\u0002\u0013\u0019\u0014\u0001\u0005;y]N#\u0018\r^3NC:\fw-\u001a:!\u0011\u001dI\u0004A1A\u0005\ni\n!\u0002]1si&$\u0018n\u001c82+\u0005Y\u0004C\u0001\u001f@\u001b\u0005i$B\u0001 (\u0003\u0019\u0019w.\\7p]&\u0011\u0001)\u0010\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\u0011\u0005\u0001)A\u0005w\u0005Y\u0001/\u0019:uSRLwN\\\u0019!\u0011\u001d!\u0005A1A\u0005\ni\n!\u0002]1si&$\u0018n\u001c83\u0011\u00191\u0005\u0001)A\u0005w\u0005Y\u0001/\u0019:uSRLwN\u001c\u001a!\u0011\u001dA\u0005A1A\u0005\n%\u000bqA\u0019:pW\u0016\u0014\u0018'F\u0001K!\ta4*\u0003\u0002M{\t!aj\u001c3f\u0011\u0019q\u0005\u0001)A\u0005\u0015\u0006A!M]8lKJ\f\u0004\u0005C\u0004Q\u0001\t\u0007I\u0011B%\u0002\u000f\t\u0014xn[3se!1!\u000b\u0001Q\u0001\n)\u000b\u0001B\u0019:pW\u0016\u0014(\u0007\t\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017'F\u0001W!\t9F,D\u0001Y\u0015\tI&,\u0001\u0003mC:<'\"A.\u0002\t)\fg/Y\u0005\u0003;b\u0013aa\u0015;sS:<\u0007BB0\u0001A\u0003%a+A\tue\u0006t7/Y2uS>t\u0017\r\\%ec\u0001Bq!\u0019\u0001C\u0002\u0013%Q+\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%ee!11\r\u0001Q\u0001\nY\u000b\u0011\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u001a!\u0011\u001d)\u0007A1A\u0005\n\u0019\f1\u0002\u001d:pIV\u001cWM]%ecU\tq\r\u0005\u0002\fQ&\u0011\u0011\u000e\u0004\u0002\u0005\u0019>tw\r\u0003\u0004l\u0001\u0001\u0006IaZ\u0001\raJ|G-^2fe&#\u0017\u0007\t\u0005\b[\u0002\u0011\r\u0011\"\u0003g\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u001a\t\r=\u0004\u0001\u0015!\u0003h\u00031\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u001a!\u0011\u001d\t\bA1A\u0005\nI\fQ\u0002\u001d:pIV\u001cWM]#q_\u000eDW#A:\u0011\u0005-!\u0018BA;\r\u0005\u0015\u0019\u0006n\u001c:u\u0011\u00199\b\u0001)A\u0005g\u0006q\u0001O]8ek\u000e,'/\u00129pG\"\u0004\u0003bB=\u0001\u0005\u0004%IA_\u0001\u0013ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0017'F\u0001|!\tYA0\u0003\u0002~\u0019\t\u0019\u0011J\u001c;\t\r}\u0004\u0001\u0015!\u0003|\u0003M!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\u0019!\u0011!\t\u0019\u0001\u0001b\u0001\n\u0013Q\u0018A\u0005;y]R{\u0007/[2QCJ$\u0018\u000e^5p]JBq!a\u0002\u0001A\u0003%10A\nuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014\u0004\u0005\u0003\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003{\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eC\u0004\u0002\u0010\u0001\u0001\u000b\u0011B>\u0002#\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007\u0005\u0003\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003{\u00031!\bP\u001c+j[\u0016|W\u000f^'t\u0011\u001d\t9\u0002\u0001Q\u0001\nm\fQ\u0002\u001e=o)&lWm\\;u\u001bN\u0004\u0003\"CA\u000e\u0001\t\u0007I\u0011BA\u000f\u0003%!\bP\u001c*fgVdG/\u0006\u0002\u0002 A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&u\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003S\t\u0019CA\tUe\u0006t7/Y2uS>t'+Z:vYRD\u0001\"!\f\u0001A\u0003%\u0011qD\u0001\u000bibt'+Z:vYR\u0004\u0003\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u00031!\bP\\'fi\u0006$\u0017\r^12+\t\t)\u0004E\u0002\u0015\u0003oI1!!\u000f\u0003\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0011!\ti\u0004\u0001Q\u0001\n\u0005U\u0012!\u0004;y]6+G/\u00193bi\u0006\f\u0004\u0005C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u00024\u0005aA\u000f\u001f8NKR\fG-\u0019;be!A\u0011Q\t\u0001!\u0002\u0013\t)$A\u0007uq:lU\r^1eCR\f'\u0007\t\u0005\n\u0003\u0013\u0002!\u0019!C\u0005\u0003\u0017\nacY1qiV\u0014X\rZ#se>\u00148oQ1mY\n\f7m[\u000b\u0003\u0003\u001b\u0002b!a\u0014\u0002V\u0005eSBAA)\u0015\r\t\u0019FK\u0001\tK\u0006\u001c\u00180\\8dW&!\u0011qKA)\u0005\u001d\u0019\u0015\r\u001d;ve\u0016\u0004raCA.\u0003?\nY'C\u0002\u0002^1\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001a>\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA5\u0003G\u0012a!\u0012:s_J\u001c\bcA\u0006\u0002n%\u0019\u0011q\u000e\u0007\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002N\u000592-\u00199ukJ,G-\u0012:s_J\u001c8)\u00197mE\u0006\u001c7\u000e\t\u0005\n\u0003o\u0002!\u0019!C\u0005\u0003s\n!\u0003\u001e=o\u001b\u0006\u00148.\u001a:QkJ<\u0017\r^8ssV\u0011\u00111\u0010\t\u00063\u0005u\u0014\u0011Q\u0005\u0004\u0003\u007fR\"!\u0007#fY\u0006LX\rZ(qKJ\fG/[8o!V\u0014x-\u0019;pef\u00042\u0001FAB\u0013\r\t)I\u0001\u0002\u0011\t\u0016d\u0017-_3e)btW*\u0019:lKJD\u0001\"!#\u0001A\u0003%\u00111P\u0001\u0014ibtW*\u0019:lKJ\u0004VO]4bi>\u0014\u0018\u0010\t\u0005\n\u0003\u001b\u0003!\u0019!C\u0005\u0003\u001f\u000bA\u0001^5nKV\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*\u0019\u0011qS\u001f\u0002\u000bU$\u0018\u000e\\:\n\t\u0005m\u0015Q\u0013\u0002\t\u001b>\u001c7\u000eV5nK\"A\u0011q\u0014\u0001!\u0002\u0013\t\t*A\u0003uS6,\u0007\u0005C\u0005\u0002$\u0002\u0011\r\u0011\"\u0003\u0002&\u0006q1\r[1o]\u0016dW*\u00198bO\u0016\u0014XCAAT!\r!\u0012\u0011V\u0005\u0004\u0003W\u0013!a\b+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\"A\u0011q\u0016\u0001!\u0002\u0013\t9+A\bdQ\u0006tg.\u001a7NC:\fw-\u001a:!\u0011\u001d\t\u0019\f\u0001C\u0005\u0003k\u000b\u0011\"\\8dW\u000e\u000b7\r[3\u0015\u0005\u0005-\u0004bBA]\u0001\u0011\u0005\u0011QW\u00010g\"|W\u000f\u001c3HK:,'/\u0019;f\u000b6\u0004H/_'ba^CWM\u001c(p%\u0016\fX/Z:ug>+Ho\u001d;b]\u0012Lgn\u001a\u0015\u0005\u0003o\u000bi\f\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\r\t\u0019MK\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u000f\f\tM\u0001\u0003UKN$\bbBAf\u0001\u0011\u0005\u0011QW\u0001+g\"|W\u000f\u001c3HK:,'/\u0019;f%\u0016\fX/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c)fe\n\u0013xn[3sQ\u0011\tI-!0\t\u000f\u0005E\u0007\u0001\"\u0001\u00026\u000693\u000f[8vY\u0012\u001c6.\u001b9TK:$W*\u0019:lKJ\u001cx\u000b[3o\u0019\u0016\fG-\u001a:O_R4u.\u001e8eQ\u0011\ty-!0\t\u000f\u0005]\u0007\u0001\"\u0001\u00026\u0006\u00114\u000f[8vY\u0012\u001c\u0016M^3G_Jd\u0015\r^3s/\",g\u000eT3bI\u0016\u0014XK\\6o_^t')\u001e;O_R\fe/Y5mC\ndW\r\u000b\u0003\u0002V\u0006u\u0006bBAo\u0001\u0011\u0005\u0011QW\u00019g\"|W\u000f\u001c3SK6|g/Z'be.,'o\u001d$peRCh\u000eU1si&$\u0018n\u001c8XQ\u0016t\u0007+\u0019:uSRLwN\\#nS\u001e\u0014\u0018\r^3eQ\u0011\tY.!0\t\u000f\u0005\r\b\u0001\"\u0001\u00026\u000694\u000f[8vY\u0012\u001cu.\u001c9mKR,\u0017\t\u001d9f]\u0012$v\u000eT8h\u001f:,e\u000e\u001a+y]^CWM\\*f]\u0012l\u0015M]6feN\u001cVoY2fK\u0012DC!!9\u0002>\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005U\u0016!N:i_VdG-\u00112peR\f\u0005\u000f]3oIR{Gj\\4P]\u0016sG\r\u0016=o/\",gNT8u\u0007>|'\u000fZ5oCR|'/\u0012:s_JDC!a:\u0002>\"9\u0011q\u001e\u0001\u0005\u0002\u0005U\u0016AP:i_VdGMU3uef\f\u0005\u000f]3oIR{Gj\\4P]\u0016sG\r\u0016=o/\",gnQ8pe\u0012Lg.\u0019;pe:{G/\u0011<bS2\f'\r\\3FeJ|'\u000f\u000b\u0003\u0002n\u0006u\u0006bBA{\u0001\u0011%\u0011q_\u0001\u0012GJ,\u0017\r^3QS\u0012,%O]8s\u001b\u0006\u0004H\u0003BA}\u0005\u001f\u0001\u0002\"a?\u0003\u0002\t\u0015!\u0011B\u0007\u0003\u0003{T1!a@[\u0003\u0011)H/\u001b7\n\t\t\r\u0011Q \u0002\b\u0011\u0006\u001c\b.T1q!\r9&qA\u0005\u0003Sb\u0003r!a?\u0003\fm\ny&\u0003\u0003\u0003\u000e\u0005u(aA'ba\"A!\u0011CAz\u0001\u0004\ty&\u0001\u0004feJ|'o\u001d\u0005\b\u0005+\u0001A\u0011AA[\u0003u\u0019\bn\\;mI\u000e\u0013X-\u0019;f\u001b\u0016$(/[2t\u001f:\u001cF/\u0019:uS:<\u0007\u0006\u0002B\n\u0003{\u0003")
public class TransactionMarkerChannelManagerTest {
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
    private final NetworkClient networkClient = (NetworkClient)EasyMock.createNiceMock(NetworkClient.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)EasyMock.createNiceMock(TransactionStateManager.class);
    private final TopicPartition partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic1", 1);
    private final Node broker1 = new Node(1, "host", 10);
    private final Node broker2 = new Node(2, "otherhost", 10);
    private final String transactionalId1;
    private final String transactionalId2;
    private final long producerId1;
    private final long producerId2;
    private final short producerEpoch = (short)0;
    private final int txnTopicPartition1;
    private final int txnTopicPartition2;
    private final int coordinatorEpoch;
    private final int txnTimeoutMs;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TransactionMetadata txnMetadata1 = new TransactionMetadata(this.transactionalId1(), this.producerId1(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1(), this.partition2()})), 0L, 0L);
    private final TransactionMetadata kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2 = new TransactionMetadata(this.transactionalId2(), this.producerId2(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1()})), 0L, 0L);
    private final Capture<Function1<Errors, BoxedUnit>> kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback = EasyMock.newCapture();
    private final DelayedOperationPurgatory<DelayedTxnMarker> txnMarkerPurgatory;
    private final MockTime time;
    private final TransactionMarkerChannelManager channelManager;

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TopicPartition partition1() {
        return this.partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    private Node broker1() {
        return this.broker1;
    }

    private Node broker2() {
        return this.broker2;
    }

    private String transactionalId1() {
        return this.transactionalId1;
    }

    private String transactionalId2() {
        return this.transactionalId2;
    }

    private long producerId1() {
        return this.producerId1;
    }

    private long producerId2() {
        return this.producerId2;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private int txnTopicPartition1() {
        return this.txnTopicPartition1;
    }

    private int txnTopicPartition2() {
        return this.txnTopicPartition2;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public TransactionMetadata kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2() {
        return this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2;
    }

    public Capture<Function1<Errors, BoxedUnit>> kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback() {
        return this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback;
    }

    private DelayedOperationPurgatory<DelayedTxnMarker> txnMarkerPurgatory() {
        return this.txnMarkerPurgatory;
    }

    private MockTime time() {
        return this.time;
    }

    private TransactionMarkerChannelManager channelManager() {
        return this.channelManager;
    }

    private void mockCache() {
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId1()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition1())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId2()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition2())).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId1()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())))).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId2()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2())))).anyTimes();
        ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock();
        EasyMock.expect((Object)this.txnStateManager().stateReadLock()).andReturn((Object)stateLock.readLock()).anyTimes();
    }

    @Test
    public void shouldGenerateEmptyMapWhenNoRequestsOutstanding() {
        Assert.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldGenerateRequestPerPartitionPerBroker() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)2L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)2L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Utils.mkList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Utils.mkList((Object[])new TopicPartition[]{this.partition1()})), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Utils.mkList((Object[])new TopicPartition[]{this.partition1()}))})).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Utils.mkList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Utils.mkList((Object[])new TopicPartition[]{this.partition2()}))})).build();
        scala.collection.immutable.Map requests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)requests);
        Assert.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldSkipSendMarkersWhenLeaderNotFound() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)1L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldSaveForLaterWhenLeaderUnknownButNotAvailable() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)this.broker1())).andReturn((Object)new Some((Object)this.broker1()));
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)2L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)2L, (long)this.channelManager().queueForUnknownBroker().totalNumMarkers());
        Assert.assertEquals((long)1L, (long)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Utils.mkList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Utils.mkList((Object[])new TopicPartition[]{this.partition1()})), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Utils.mkList((Object[])new TopicPartition[]{this.partition1()}))})).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Utils.mkList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Utils.mkList((Object[])new TopicPartition[]{this.partition2()}))})).build();
        scala.collection.immutable.Map firstDrainedRequests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)firstDrainedRequests);
        scala.collection.immutable.Map secondDrainedRequests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request)})), (Object)secondDrainedRequests);
    }

    @Test
    public void shouldRemoveMarkersForTxnPartitionWhenPartitionEmigrated() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)2L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)2L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        this.channelManager().removeMarkersForTxnTopicPartition(this.txnTopicPartition1());
        Assert.assertEquals((long)1L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, txnTransitionMetadata2){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;
            private final TxnTransitMetadata txnTransitionMetadata2$1;

            public void answer() {
                this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().completeTransitionTo(this.txnTransitionMetadata2$1);
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.txnTransitionMetadata2$1 = txnTransitionMetadata2$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assert.assertEquals((long)0L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState());
        Assert.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().state());
    }

    @Test
    public void shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;

            public void answer() {
                this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState_$eq((Option)None$.MODULE$);
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.NOT_COORDINATOR);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assert.assertEquals((long)0L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState());
        Assert.assertEquals((Object)PrepareCommit$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().state());
    }

    @Test
    public void shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;

            public void answer() {
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.COORDINATOR_NOT_AVAILABLE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, txnTransitionMetadata2){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;
            private final TxnTransitMetadata txnTransitionMetadata2$2;

            public void answer() {
                this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().completeTransitionTo(this.txnTransitionMetadata2$2);
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.txnTransitionMetadata2$2 = txnTransitionMetadata2$2;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        this.channelManager().generateRequests();
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assert.assertEquals((long)0L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState());
        Assert.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().state());
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<Long, Map<TopicPartition, Errors>> createPidErrorMap(Errors errors) {
        void var2_2;
        HashMap pidMap = new HashMap();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.partition1(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId2()), errorsMap);
        return var2_2;
    }

    @Test
    public void shouldCreateMetricsOnStarting() {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala();
        Assert.assertEquals((long)1L, (long)metrics.filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$1(x$1))).size());
        Assert.assertEquals((long)1L, (long)metrics.filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$2(x$2))).size());
    }

    public static final /* synthetic */ void $anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(WriteTxnMarkersResponse response$1, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, (AbstractResponse)response$1));
    }

    public static final /* synthetic */ void $anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(WriteTxnMarkersResponse response$2, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, (AbstractResponse)response$2));
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(WriteTxnMarkersResponse response$3, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, (AbstractResponse)response$3));
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$1(MetricName x$1) {
        String string = x$1.getMBeanName();
        String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=UnknownDestinationQueueSize";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$2(MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=LogAppendRetryQueueSize";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public TransactionMarkerChannelManagerTest() {
        this.transactionalId1 = "txnId1";
        this.transactionalId2 = "txnId2";
        this.producerId1 = 0;
        this.producerId2 = 1;
        this.txnTopicPartition1 = 0;
        this.txnTopicPartition2 = 1;
        this.coordinatorEpoch = 0;
        this.txnTimeoutMs = 0;
        String x$3 = "txn-purgatory-name";
        MockTimer x$4 = new MockTimer();
        boolean x$5 = false;
        int x$6 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$7 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$8 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        this.txnMarkerPurgatory = new DelayedOperationPurgatory(x$3, (Timer)x$4, x$6, x$7, x$5, x$8);
        this.time = new MockTime();
        this.channelManager = new TransactionMarkerChannelManager(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())), this.metadataCache(), this.networkClient(), this.txnStateManager(), this.txnMarkerPurgatory(), (Time)this.time());
    }
}

