/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.generator.producers;

import com.intellij.database.dialects.base.generator.BaseCreateGenerator;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateTable;
import com.intellij.database.dialects.postgres.generator.PgScriptGeneratorHelperKt;
import com.intellij.database.dialects.postgres.generator.producers.PgCreateTable;
import com.intellij.database.dialects.postgres.model.PgForeignTable;
import com.intellij.database.dialects.postgres.model.PgLocalTable;
import com.intellij.database.dialects.postgres.model.PgModelFun;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgres.model.PgTableColumn;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseOwnerAwareProducer;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectWithOwner;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0011H\u0014J$\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000fH\u0002J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0016J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001bH\u0014J\b\u0010 \u001a\u00020\rH\u0014J\u0010\u0010!\u001a\u00020\u0017*\u00060\"R\u00020\u0005H\u0014J\u0010\u0010#\u001a\u00020\u0017*\u00060\"R\u00020\u0005H\u0014R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/postgres/generator/producers/PgCreateTable;", "Lcom/intellij/database/dialects/base/generator/producers/CreateTable;", "Lcom/intellij/database/dialects/postgres/model/PgTable;", "Lcom/intellij/database/dialects/postgresbase/generator/producers/PgBaseOwnerAwareProducer;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/postgres/model/PgTable;)V", "objectType", "", "getObjectType", "()Ljava/lang/String;", "acceptColumn", "", "column", "Lcom/intellij/database/dialects/postgres/model/PgTableColumn;", "elementKindNameForCreate", "Lcom/intellij/database/model/basic/BasicElement;", "findPropertyInAncestors", "condition", "Lkotlin/Function1;", "isModifiedColumnFromAncestor", "produceComment", "", "exists", "comment", "registerColumn", "Lcom/intellij/database/dialects/base/generator/Operation;", "generator", "Lcom/intellij/database/dialects/base/generator/BaseCreateGenerator;", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "root", "shouldProduceChildren", "produceFooter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "produceHeader", "intellij.database.dialects"})
public final class PgCreateTable
extends CreateTable<PgTable>
implements PgBaseOwnerAwareProducer {
    @Override
    @NotNull
    public String getObjectType() {
        String string = this.elementKindNameForCreate((BasicElement)this.getElement());
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Override
    @Nullable
    protected Operation registerColumn(@NotNull BaseCreateGenerator generator, @NotNull BasicTableOrViewColumn column2, @NotNull Operation root2) {
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        if (column2 instanceof PgTableColumn && !this.acceptColumn((PgTableColumn)column2)) {
            Operation operation2;
            Operation operation3 = BaseCreateGenerator.prepareElement$default(generator, column2, root2, false, 4, null);
            if (operation3 != null) {
                Operation operation4;
                Operation $receiver = operation4 = operation3;
                $receiver.setProvided(true);
                operation2 = operation4;
            } else {
                operation2 = null;
            }
            return operation2;
        }
        return super.registerColumn(generator, column2, root2);
    }

    private final boolean acceptColumn(PgTableColumn column2) {
        BasicElement basicElement = column2.getParent();
        if (!(basicElement instanceof PgTable)) {
            basicElement = null;
        }
        PgTable pgTable = (PgTable)basicElement;
        if (pgTable == null) {
            return true;
        }
        PgTable table = pgTable;
        return !table.isPartition() && !column2.isInherited() || table.isPartition() && this.isModifiedColumnFromAncestor(column2);
    }

    @Override
    protected boolean shouldProduceChildren() {
        return super.shouldProduceChildren() || !((PgTable)this.getElement()).isPartition();
    }

    private final boolean isModifiedColumnFromAncestor(PgTableColumn element2) {
        return element2.getDefaultExpression() != null && !this.findPropertyInAncestors(element2, (Function1<? super PgTableColumn, Boolean>)((Function1)new Function1<PgTableColumn, Boolean>(element2){
            final /* synthetic */ PgTableColumn $element;

            public final boolean invoke(@NotNull PgTableColumn it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)this.$element.getDefaultExpression(), (Object)it.getDefaultExpression());
            }
            {
                this.$element = pgTableColumn;
                super(1);
            }
        })) || element2.isNotNull() && !this.findPropertyInAncestors(element2, (Function1<? super PgTableColumn, Boolean>)((Function1)isModifiedColumnFromAncestor.2.INSTANCE));
    }

    private final boolean findPropertyInAncestors(PgTableColumn column2, Function1<? super PgTableColumn, Boolean> condition) {
        BasicElement basicElement = column2.getParent();
        if (!(basicElement instanceof PgTable)) {
            basicElement = null;
        }
        PgTable pgTable = (PgTable)basicElement;
        if (pgTable == null) {
            return false;
        }
        PgTable parent2 = pgTable;
        List<PgTable> ancestors = PgModelFun.getAncestors(parent2);
        for (PgTable ancestor : ancestors) {
            PgTableColumn sameInAncestor2;
            if (ancestor.getColumns().find((Predicate<? extends PgTableColumn>)new Predicate<PgTableColumn>(column2){
                final /* synthetic */ PgTableColumn $column;

                public final boolean test(PgTableColumn it) {
                    PgTableColumn pgTableColumn = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pgTableColumn, (String)"it");
                    return Intrinsics.areEqual((Object)pgTableColumn.getName(), (Object)this.$column.getName());
                }
                {
                    this.$column = pgTableColumn;
                }
            }) == null) {
                continue;
            }
            if (!((Boolean)condition.invoke((Object)sameInAncestor2)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void produceHeader(@NotNull ScriptingContext.NewCodingAdapter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PgTable t = (PgTable)this.getElement();
        $receiver.unaryPlus(this.header());
        List<Long> list = t.getAncestorIds();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"t.ancestorIds");
        Collection collection = list;
        if (!collection.isEmpty() && t.isPartition()) {
            $receiver.newLine();
            $receiver.plus($receiver.unaryPlus("partition of"), BaseProducer.currentScopeName$default(this, (BasicElement)CollectionsKt.first(PgModelFun.getAncestors(t)), null, 1, null));
        }
    }

    @Override
    protected void produceFooter(@NotNull ScriptingContext.NewCodingAdapter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PgTable t = (PgTable)this.getElement();
        List<Long> list = t.getAncestorIds();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"t.ancestorIds");
        Collection collection = list;
        if (!collection.isEmpty()) {
            if (t.isPartition()) {
                $receiver.unaryPlus(t.getPartitionExpression());
                $receiver.newLine();
            } else {
                $receiver.plus($receiver.plus($receiver.unaryPlus("inherits ("), CollectionsKt.joinToString$default((Iterable)PgModelFun.getAncestors(t), null, null, null, (int)0, null, (Function1)((Function1)new Function1<PgTable, String>(this){
                    final /* synthetic */ PgCreateTable this$0;

                    @NotNull
                    public final String invoke(@NotNull PgTable it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return BaseProducer.currentScopeName$default(this.this$0, it, null, 1, null);
                    }
                    {
                        this.this$0 = pgCreateTable;
                        super(1);
                    }
                }), (int)31, null)), ")");
                $receiver.newLine();
            }
        }
        if (t instanceof PgLocalTable && ((PgLocalTable)t).isPartitioned()) {
            $receiver.unaryPlus("partition by " + ((PgLocalTable)t).getPartitionKey());
        }
        if (t instanceof PgForeignTable) {
            StringBuilder stringBuilder = new StringBuilder().append("server ").append(((PgForeignTable)t).getServer());
            List<String> list2 = ((PgForeignTable)t).getOptions();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"t.options");
            $receiver.unaryPlus(stringBuilder.append(PgScriptGeneratorHelperKt.optionsToString(list2, true)).toString());
        }
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        BaseProducersKt.commentStatement(this, this.getElement() instanceof PgLocalTable ? "table" : "foreign table", comment);
    }

    @Override
    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        ObjectKind objectKind = element2.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE) ? "foreign table" : super.elementKindNameForCreate(element2);
    }

    public PgCreateTable(@NotNull ScriptingContext context, @NotNull PgTable element2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super(context, (BasicTable)element2);
    }

    @Override
    public void produceOwner() {
        PgBaseOwnerAwareProducer.DefaultImpls.produceOwner(this);
    }

    @Override
    @NotNull
    public String definition(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return PgBaseOwnerAwareProducer.DefaultImpls.definition(this, $receiver);
    }

    @Override
    @Nullable
    public PgBaseObjectWithOwner element(@NotNull ElementProducer<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return PgBaseOwnerAwareProducer.DefaultImpls.element(this, $receiver);
    }
}

