/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.EmmetPreviewHint;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Collections;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetPreviewUtil {
    private EmmetPreviewUtil() {
    }

    @Nullable
    public static String calculateTemplateText(@NotNull Editor editor, @NotNull PsiFile file2, boolean expandPrimitiveAbbreviations) {
        String templatePrefix;
        if (editor == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        CollectCustomTemplateCallback callback2 = new CollectCustomTemplateCallback(editor, file2);
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback2, false);
        if (generator instanceof XmlZenCodingGenerator && (templatePrefix = new ZenCodingTemplate().computeTemplateKeyWithoutContextChecking(callback2)) != null) {
            try {
                String templateText;
                ZenCodingTemplate.expand(templatePrefix, callback2, generator, Collections.emptyList(), expandPrimitiveAbbreviations, 0);
                TemplateImpl template = callback2.getGeneratedTemplate();
                String string = templateText = template != null ? template.getTemplateText() : null;
                if (!StringUtil.isEmpty((String)templateText)) {
                    return template.isToReformat() ? EmmetPreviewUtil.reformatTemplateText(file2, templateText) : templateText;
                }
            }
            catch (EmmetException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    public static void addEmmetPreviewListeners(final @NotNull Editor editor, final @NotNull PsiFile file2, final boolean expandPrimitiveAbbreviations) {
        if (editor == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(3);
        }
        editor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                EmmetPreviewHint existingHint;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((existingHint = EmmetPreviewHint.getExistingHint(editor)) != null) {
                    existingHint.updateText(new TemplateTextProducer(editor, file2, expandPrimitiveAbbreviations));
                } else {
                    e.getDocument().removeDocumentListener((DocumentListener)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$1", "documentChanged"));
            }
        });
        editor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                EmmetPreviewHint existingHint;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((existingHint = EmmetPreviewHint.getExistingHint(e.getEditor())) != null) {
                    existingHint.updateText(new TemplateTextProducer(editor, file2, expandPrimitiveAbbreviations));
                } else {
                    e.getEditor().getCaretModel().removeCaretListener((CaretListener)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$2", "caretPositionChanged"));
            }
        });
    }

    private static String reformatTemplateText(@NotNull PsiFile file2, @NotNull String templateText) {
        PsiFile copy;
        VirtualFile vFile;
        if (file2 == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(4);
        }
        if (templateText == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(5);
        }
        if ((vFile = (copy = PsiFileFactory.getInstance((Project)file2.getProject()).createFileFromText(file2.getName(), file2.getFileType(), (CharSequence)templateText)).getVirtualFile()) != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (file2 == null) {
                EmmetPreviewUtil.$$$reportNull$$$0(6);
            }
            CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                if (file2 == null) {
                    EmmetPreviewUtil.$$$reportNull$$$0(7);
                }
                CodeStyleManager.getInstance((Project)file2.getProject()).reformat((PsiElement)copy);
            });
        });
        return copy.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateTemplateText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addEmmetPreviewListeners";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatTemplateText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$reformatTemplateText$1";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TemplateTextProducer
    implements Supplier<String> {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final PsiFile myFile;
        private final boolean myExpandPrimitiveAbbreviations;

        TemplateTextProducer(@NotNull Editor editor, @NotNull PsiFile file2, boolean expandPrimitiveAbbreviations) {
            if (editor == null) {
                TemplateTextProducer.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                TemplateTextProducer.$$$reportNull$$$0(1);
            }
            this.myEditor = editor;
            this.myFile = file2;
            this.myExpandPrimitiveAbbreviations = expandPrimitiveAbbreviations;
        }

        @Override
        @Nullable
        public String get() {
            return EmmetPreviewUtil.calculateTemplateText(this.myEditor, this.myFile, this.myExpandPrimitiveAbbreviations);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$TemplateTextProducer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

