/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.FullIntList;
import com.intellij.vcs.log.graph.utils.impl.SmartDeltaCompressor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class IntTimestampGetter
implements TimestampGetter {
    public static final int DEFAULT_BLOCK_SIZE = 30;
    private static final long MAX_DELTA = 0x7FFFFFF5L;
    private static final int BROKEN_DELTA = Integer.MAX_VALUE;
    private final IntList myDeltas;
    @NotNull
    private final Map<Integer, Long> myBrokenDeltas;
    private final int myBlockSize;
    private final long[] mySaveTimestamps;

    @NotNull
    public static IntTimestampGetter newInstance(@NotNull TimestampGetter delegateGetter) {
        if (delegateGetter == null) {
            IntTimestampGetter.$$$reportNull$$$0(0);
        }
        IntTimestampGetter intTimestampGetter = IntTimestampGetter.newInstance(delegateGetter, 30);
        if (intTimestampGetter == null) {
            IntTimestampGetter.$$$reportNull$$$0(1);
        }
        return intTimestampGetter;
    }

    @NotNull
    public static IntTimestampGetter newInstance(@NotNull TimestampGetter delegateGetter, int blockSize) {
        if (delegateGetter == null) {
            IntTimestampGetter.$$$reportNull$$$0(2);
        }
        if (delegateGetter.size() < 0) {
            throw new NegativeArraySizeException("delegateGetter.size() < 0: " + delegateGetter.size());
        }
        if (delegateGetter.size() == 0) {
            throw new IllegalArgumentException("Empty TimestampGetter not supported");
        }
        long[] saveTimestamps = new long[(delegateGetter.size() - 1) / blockSize + 1];
        for (int i = 0; i < saveTimestamps.length; ++i) {
            saveTimestamps[i] = delegateGetter.getTimestamp(blockSize * i);
        }
        HashMap<Integer, Long> brokenDeltas = new HashMap<Integer, Long>();
        int[] deltas = new int[delegateGetter.size()];
        for (int i = 0; i < delegateGetter.size(); ++i) {
            int intDelta;
            int blockIndex = i - i % blockSize;
            long delta = delegateGetter.getTimestamp(i) - delegateGetter.getTimestamp(blockIndex);
            deltas[i] = intDelta = IntTimestampGetter.deltaToInt(delta);
            if (intDelta != Integer.MAX_VALUE) continue;
            brokenDeltas.put(i, delta);
        }
        IntTimestampGetter intTimestampGetter = new IntTimestampGetter(deltas, blockSize, saveTimestamps, brokenDeltas);
        if (intTimestampGetter == null) {
            IntTimestampGetter.$$$reportNull$$$0(3);
        }
        return intTimestampGetter;
    }

    private static int deltaToInt(long delta) {
        if (delta >= 0L && delta <= 0x7FFFFFF5L) {
            return (int)delta;
        }
        if (delta < 0L && -delta <= 0x7FFFFFF5L) {
            return (int)delta;
        }
        return Integer.MAX_VALUE;
    }

    public IntTimestampGetter(int[] deltas, int blockSize, long[] saveTimestamps, @NotNull Map<Integer, Long> brokenDeltas) {
        if (brokenDeltas == null) {
            IntTimestampGetter.$$$reportNull$$$0(4);
        }
        this.myDeltas = SmartDeltaCompressor.newInstance(new FullIntList(deltas));
        this.myBlockSize = blockSize;
        this.mySaveTimestamps = saveTimestamps;
        this.myBrokenDeltas = brokenDeltas;
    }

    @Override
    public int size() {
        return this.myDeltas.size();
    }

    @Override
    public long getTimestamp(int index) {
        this.checkRange(index);
        int relativeSaveIndex = index / this.myBlockSize;
        long timestamp = this.mySaveTimestamps[relativeSaveIndex];
        return timestamp + this.getDelta(index);
    }

    private long getDelta(int index) {
        int delta = this.myDeltas.get(index);
        if (delta != Integer.MAX_VALUE) {
            return delta;
        }
        return this.myBrokenDeltas.get(index);
    }

    private void checkRange(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0:" + index);
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("index: " + index + " >= size: " + this.size());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateGetter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/utils/impl/IntTimestampGetter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brokenDeltas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/utils/impl/IntTimestampGetter";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

