/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import java.io.FileOutputStream;
import java.io.IOException;
import org.joni.Analyser;
import org.joni.Compiler;
import org.joni.Config;
import org.joni.MatcherFactory;
import org.joni.constants.AsmConstants;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

abstract class AsmCompilerSupport
extends Compiler
implements Opcodes,
AsmConstants {
    protected ClassWriter factory;
    protected MethodVisitor factoryInit;
    protected String factoryName;
    protected ClassWriter machine;
    protected MethodVisitor machineInit;
    protected MethodVisitor match;
    protected String machineName;
    protected int maxStack = 1;
    protected int maxVars = 6;
    protected int bitsets;
    protected int ranges;
    protected int templates;
    static int REG_NUM = 0;
    private static final DummyClassLoader loader = new DummyClassLoader();

    AsmCompilerSupport(Analyser analyser) {
        super(analyser);
    }

    protected final void prepareFactory() {
        this.factory = new ClassWriter(1);
        this.factoryName = "org/joni/MatcherFactory" + REG_NUM;
        this.factory.visit(48, 17, this.factoryName, null, "org/joni/MatcherFactory", null);
        MethodVisitor create = this.factory.visitMethod(4096, "create", "(Lorg/joni/Regex;[BII)Lorg/joni/Matcher;", null, null);
        create.visitTypeInsn(187, this.machineName);
        create.visitInsn(89);
        create.visitVarInsn(25, 1);
        create.visitVarInsn(25, 2);
        create.visitVarInsn(21, 3);
        create.visitVarInsn(21, 4);
        create.visitMethodInsn(183, this.machineName, "<init>", "(Lorg/joni/Regex;[BII)V");
        create.visitInsn(176);
        create.visitMaxs(0, 0);
        create.visitEnd();
    }

    protected final void prepareFactoryInit() {
        this.factoryInit = this.factory.visitMethod(1, "<init>", "()V", null, null);
        this.factoryInit.visitVarInsn(25, 0);
        this.factoryInit.visitMethodInsn(183, "org/joni/MatcherFactory", "<init>", "()V");
    }

    protected final void setupFactoryInit() {
        this.factoryInit.visitInsn(177);
        this.factoryInit.visitMaxs(0, 0);
        this.factoryInit.visitEnd();
    }

    protected final void prepareMachine() {
        this.machine = new ClassWriter(1);
        this.machineName = "org/joni/NativeMachine" + REG_NUM;
    }

    protected final void prepareMachineInit() {
        this.machine.visit(48, 17, this.machineName, null, "org/joni/NativeMachine", null);
        this.machineInit = this.machine.visitMethod(4, "<init>", "(Lorg/joni/Regex;[BII)V", null, null);
        this.machineInit.visitVarInsn(25, 0);
        this.machineInit.visitVarInsn(25, 1);
        this.machineInit.visitVarInsn(25, 2);
        this.machineInit.visitVarInsn(21, 3);
        this.machineInit.visitVarInsn(21, 4);
        this.machineInit.visitMethodInsn(183, "org/joni/NativeMachine", "<init>", "(Lorg/joni/Regex;[BII)V");
    }

    protected final void setupMachineInit() {
        if (this.bitsets + this.ranges + this.templates > 0) {
            this.machine.visitField(18, "factory", "L" + this.factoryName + ";", null, null);
            this.machineInit.visitVarInsn(25, 0);
            this.machineInit.visitVarInsn(25, 1);
            this.machineInit.visitFieldInsn(180, "org/joni/Regex", "factory", "Lorg/joni/MatcherFactory;");
            this.machineInit.visitTypeInsn(192, this.factoryName);
            this.machineInit.visitFieldInsn(181, this.machineName, "factory", "L" + this.factoryName + ";");
        }
        this.machineInit.visitInsn(177);
        this.machineInit.visitMaxs(0, 0);
        this.machineInit.visitEnd();
    }

    protected final void prepareMachineMatch() {
        this.match = this.machine.visitMethod(4096, "matchAt", "(III)I", null, null);
        this.move(4, 2);
        this.load("bytes", "[B");
        this.astore(5);
    }

    protected final void setupMachineMatch() {
        this.match.visitInsn(2);
        this.match.visitInsn(172);
        this.match.visitMaxs(this.maxStack, this.maxVars);
        this.match.visitEnd();
    }

    protected final void setupClasses() {
        byte[] factoryCode = this.factory.toByteArray();
        byte[] machineCode = this.machine.toByteArray();
        try {
            FileOutputStream fos = new FileOutputStream(this.factoryName.substring(this.factoryName.lastIndexOf(47) + 1) + ".class");
            fos.write(factoryCode);
            fos.close();
            fos = new FileOutputStream(this.machineName.substring(this.machineName.lastIndexOf(47) + 1) + ".class");
            fos.write(machineCode);
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(Config.err);
        }
        loader.defineClass(this.machineName.replace('/', '.'), machineCode);
        Class<?> cls = loader.defineClass(this.factoryName.replace('/', '.'), factoryCode);
        try {
            this.regex.factory = (MatcherFactory)cls.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace(Config.err);
        }
    }

    protected final void aload(int var) {
        this.match.visitVarInsn(25, var);
    }

    protected final void astore(int var) {
        this.match.visitVarInsn(58, var);
    }

    protected final void loadThis() {
        this.match.visitVarInsn(25, 0);
    }

    protected final void load(int var) {
        this.match.visitVarInsn(21, var);
    }

    protected final void store(int var) {
        this.match.visitVarInsn(54, var);
    }

    protected final void move(int to, int from) {
        this.load(from);
        this.store(to);
    }

    protected final void load(String field, String singature) {
        this.loadThis();
        this.match.visitFieldInsn(180, this.machineName, field, singature);
    }

    protected final void load(String field) {
        this.load(field, "I");
    }

    protected final void store(String field, String singature) {
        this.loadThis();
        this.match.visitFieldInsn(181, this.machineName, field, singature);
    }

    protected final void store(String field) {
        this.store(field, "I");
    }

    protected final String installTemplate(byte[] arr, int p, int length) {
        String templateName = "template" + ++this.templates;
        this.installArray(templateName, arr, p, length);
        return templateName;
    }

    protected final String installCodeRange(int[] arr) {
        String coreRangeName = "range" + ++this.ranges;
        this.installArray(coreRangeName, arr);
        return coreRangeName;
    }

    protected final String installBitSet(int[] arr) {
        String bitsetName = "bitset" + ++this.bitsets;
        this.installArray(bitsetName, arr);
        return bitsetName;
    }

    private void installArray(String name, int[] arr) {
        this.factory.visitField(18, name, "[I", null, null);
        this.factoryInit.visitVarInsn(25, 0);
        this.loadInt(this.factoryInit, arr.length);
        this.factoryInit.visitIntInsn(188, 10);
        for (int i = 0; i < arr.length; ++i) {
            this.buildArray(i, arr[i], 79);
        }
        this.factoryInit.visitFieldInsn(181, this.factoryName, name, "[I");
    }

    private void installArray(String name, byte[] arr, int p, int length) {
        this.factory.visitField(18, name, "[B", null, null);
        this.factoryInit.visitVarInsn(25, 0);
        this.loadInt(this.factoryInit, arr.length);
        this.factoryInit.visitIntInsn(188, 8);
        int i = p;
        int j = 0;
        while (i < p + length) {
            this.buildArray(j, arr[i] & 0xFF, 84);
            ++i;
            ++j;
        }
        this.factoryInit.visitFieldInsn(181, this.factoryName, name, "[B");
    }

    private void buildArray(int index, int value, int type) {
        this.factoryInit.visitInsn(89);
        this.loadInt(this.factoryInit, index);
        this.loadInt(this.factoryInit, value);
        this.factoryInit.visitInsn(type);
    }

    private void loadInt(MethodVisitor mv, int value) {
        if (value >= -1 && value <= 5) {
            mv.visitInsn(value + 3);
        } else if (value >= 6 && value <= 127 || value >= -128 && value <= -2) {
            mv.visitIntInsn(16, value);
        } else if (value >= 128 && value <= Short.MAX_VALUE || value >= Short.MIN_VALUE && value <= -129) {
            mv.visitIntInsn(17, value);
        } else {
            mv.visitLdcInsn((Object)new Integer(value));
        }
    }

    private static final class DummyClassLoader
    extends ClassLoader {
        private DummyClassLoader() {
        }

        public Class<?> defineClass(String name, byte[] bytes) {
            return super.defineClass(name, bytes, 0, bytes.length);
        }
    }
}

