/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.completion.TwigBlockCompletionProvider;
import com.jetbrains.twig.elements.TwigBlockTag;
import com.jetbrains.twig.elements.TwigCompositeElement;
import com.jetbrains.twig.elements.TwigElementTypes;
import com.jetbrains.twig.elements.TwigTag;
import org.jetbrains.annotations.NotNull;

public class TwigCompletionContributor
extends CompletionContributor {
    private static final String[] BUILT_IN_FILTERS = new String[]{"date", "format", "replace", "url_encode", "json_encode", "title", "capitalize", "upper", "lower", "striptags", "join", "reverse", "length", "sort", "default", "keys", "escape", "raw", "merge"};

    private static void addTagNameLookups(@NotNull CompletionResultSet result) {
        if (result == null) {
            TwigCompletionContributor.$$$reportNull$$$0(0);
        }
        for (IElementType tagType : TwigElementTypes.TAGS.getTypes()) {
            if (!(tagType instanceof TwigTag)) continue;
            result.addElement((LookupElement)LookupElementBuilder.create((String)((TwigTag)tagType).getTagName()));
        }
    }

    private static void addBuildInFilterLookups(@NotNull CompletionResultSet result) {
        if (result == null) {
            TwigCompletionContributor.$$$reportNull$$$0(1);
        }
        for (String filter : BUILT_IN_FILTERS) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)filter));
        }
    }

    public TwigCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(TwigCompositeElement.class), new TwigKeywordCompletionContributor());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(TwigBlockTag.class), new TwigBlockCompletionProvider());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "result";
        objectArray2[1] = "com/jetbrains/twig/completion/TwigCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addTagNameLookups";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addBuildInFilterLookups";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TwigKeywordCompletionContributor
    extends CompletionProvider<CompletionParameters> {
        private TwigKeywordCompletionContributor() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement currElement;
            if (parameters == null) {
                TwigKeywordCompletionContributor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                TwigKeywordCompletionContributor.$$$reportNull$$$0(1);
            }
            if (result == null) {
                TwigKeywordCompletionContributor.$$$reportNull$$$0(2);
            }
            if ((currElement = parameters.getPosition().getOriginalElement()).getNode().getElementType() == TwigTokenTypes.TAG_NAME) {
                TwigCompletionContributor.addTagNameLookups(result);
                return;
            }
            PsiElement prevElement = currElement.getPrevSibling();
            if (prevElement instanceof PsiWhiteSpace) {
                prevElement = prevElement.getPrevSibling();
            }
            if (prevElement != null && prevElement.getNode().getElementType() == TwigTokenTypes.FILTER) {
                TwigCompletionContributor.addBuildInFilterLookups(result);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/twig/completion/TwigCompletionContributor$TwigKeywordCompletionContributor";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

