/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import javax.swing.Icon;

public abstract class ZoomAction
extends AbstractGraphAction {
    private double myScale = 0.0;

    protected ZoomAction() {
        this.setNameAndIcon();
    }

    protected ZoomAction(double scale) {
        this.myScale = scale;
        this.setNameAndIcon();
    }

    protected ZoomAction(Graph2D graph, double scale) {
        super(graph);
        this.myScale = scale;
        this.setNameAndIcon();
    }

    protected abstract Icon getIcon();

    protected abstract String getText();

    protected void setNameAndIcon() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(this.getText());
        presentation.setIcon(this.getIcon());
    }

    public void actionPerformed(AnActionEvent e, Graph2D graph) {
        Graph2DView graph2DView = ZoomAction.getGraph2DView(graph);
        double zoom = graph2DView.getZoom() + this.myScale;
        graph2DView.setZoom(Math.min(20.0, Math.max(zoom, 0.1)));
    }

    public void update(AnActionEvent e, Graph2D graph) {
        Presentation presentation = e.getPresentation();
        double zoom = ZoomAction.getGraph2DView(graph).getZoom() + this.getScale();
        presentation.setEnabled(zoom > 0.1 && zoom < 20.0);
    }

    public double getScale() {
        return this.myScale;
    }
}

