/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListUtil {
    public static final String SELECTED_BY_MOUSE_EVENT = "byMouseEvent";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.ListUtil");
    private static final ListModelExtension DEFAULT_MODEL = new ListModelExtension<DefaultListModel>(){

        @Override
        public Object get(DefaultListModel model, int index2) {
            return model.get(index2);
        }

        @Override
        public void remove(DefaultListModel model, int index2) {
            model.remove(index2);
        }
    };
    private static final ListModelExtension COLLECTION_MODEL = new ListModelExtension<CollectionListModel>(){

        @Override
        public Object get(CollectionListModel model, int index2) {
            return model.getElementAt(index2);
        }

        @Override
        public void remove(CollectionListModel model, int index2) {
            model.remove(index2);
        }
    };
    private static final ListModelExtension SORTED_MODEL = new ListModelExtension<SortedListModel>(){

        @Override
        public Object get(SortedListModel model, int index2) {
            return model.get(index2);
        }

        @Override
        public void remove(SortedListModel model, int index2) {
            model.remove(index2);
        }
    };
    private static final ListModelExtension FILTERED_MODEL = new ListModelExtension<FilteringListModel>(){

        @Override
        public Object get(FilteringListModel model, int index2) {
            return model.getElementAt(index2);
        }

        @Override
        public void remove(FilteringListModel model, int index2) {
            model.remove(index2);
        }
    };

    public static MouseMotionListener installAutoSelectOnMouseMove(final JList list) {
        MouseMotionAdapter listener = new MouseMotionAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !(focusOwner instanceof JRootPane)) {
                    Point point = e.getPoint();
                    int index2 = list.locationToIndex(point);
                    list.putClientProperty(ListUtil.SELECTED_BY_MOUSE_EVENT, Boolean.TRUE);
                    list.setSelectedIndex(index2);
                    list.putClientProperty(ListUtil.SELECTED_BY_MOUSE_EVENT, Boolean.FALSE);
                } else {
                    this.myIsEngaged = true;
                }
            }
        };
        list.addMouseMotionListener(listener);
        return listener;
    }

    public static List removeSelectedItems(JList list) {
        return ListUtil.removeSelectedItems(list, null);
    }

    public static <T> List<T> removeIndices(JList<T> list, int[] indices) {
        return ListUtil.removeIndices(list, indices, null);
    }

    public static <T> List<T> removeSelectedItems(JList list, Condition<? super T> condition) {
        int[] idxs = list.getSelectedIndices();
        return ListUtil.removeIndices(list, idxs, condition);
    }

    private static <T> List<T> removeIndices(JList list, int[] idxs, Condition<? super T> condition) {
        if (idxs.length == 0) {
            return new ArrayList(0);
        }
        ListModel model = list.getModel();
        int firstSelectedIndex = idxs[0];
        ArrayList<Object> removedItems = new ArrayList<Object>();
        int deletedCount = 0;
        for (int idx1 : idxs) {
            int index2 = idx1 - deletedCount;
            if (index2 < 0 || index2 >= model.getSize()) continue;
            Object obj = ListUtil.get(model, index2);
            if (condition != null && !condition.value(obj)) continue;
            removedItems.add(obj);
            ListUtil.remove(model, index2);
            ++deletedCount;
        }
        if (model.getSize() == 0) {
            list.clearSelection();
        } else if (list.getSelectedValue() == null) {
            if (firstSelectedIndex >= model.getSize()) {
                list.setSelectedIndex(model.getSize() - 1);
            } else {
                list.setSelectedIndex(firstSelectedIndex);
            }
        }
        return removedItems;
    }

    public static boolean canRemoveSelectedItems(JList list) {
        return ListUtil.canRemoveSelectedItems(list, null);
    }

    public static boolean canRemoveSelectedItems(JList list, Condition applyable) {
        ListModel model = list.getModel();
        int[] idxs = list.getSelectedIndices();
        if (idxs.length == 0) {
            return false;
        }
        for (int index2 : idxs) {
            if (index2 < 0 || index2 >= model.getSize()) continue;
            Object obj = ListUtil.getExtensions(model).get(model, index2);
            if (applyable != null && !applyable.value(obj)) continue;
            return true;
        }
        return false;
    }

    public static int moveSelectedItemsUp(JList list) {
        DefaultListModel model = ListUtil.getModel(list);
        int[] indices = list.getSelectedIndices();
        if (!ListUtil.canMoveSelectedItemsUp(list)) {
            return 0;
        }
        for (int index2 : indices) {
            Object temp = model.get(index2);
            model.set(index2, model.get(index2 - 1));
            model.set(index2 - 1, temp);
            list.removeSelectionInterval(index2, index2);
            list.addSelectionInterval(index2 - 1, index2 - 1);
        }
        Rectangle cellBounds = list.getCellBounds(indices[0] - 1, indices[indices.length - 1] - 1);
        if (cellBounds != null) {
            list.scrollRectToVisible(cellBounds);
        }
        return indices.length;
    }

    public static boolean canMoveSelectedItemsUp(JList list) {
        int[] indices = list.getSelectedIndices();
        return indices.length > 0 && indices[0] > 0;
    }

    public static int moveSelectedItemsDown(JList list) {
        DefaultListModel model = ListUtil.getModel(list);
        int[] indices = list.getSelectedIndices();
        if (!ListUtil.canMoveSelectedItemsDown(list)) {
            return 0;
        }
        for (int i = indices.length - 1; i >= 0; --i) {
            int index2 = indices[i];
            Object temp = model.get(index2);
            model.set(index2, model.get(index2 + 1));
            model.set(index2 + 1, temp);
            list.removeSelectionInterval(index2, index2);
            list.addSelectionInterval(index2 + 1, index2 + 1);
        }
        Rectangle cellBounds = list.getCellBounds(indices[0] + 1, indices[indices.length - 1] + 1);
        if (cellBounds != null) {
            list.scrollRectToVisible(cellBounds);
        }
        return indices.length;
    }

    private static DefaultListModel getModel(JList list) {
        ListModel model = list.getModel();
        if (model instanceof FilteringListModel) {
            return (DefaultListModel)((FilteringListModel)model).getOriginalModel();
        }
        if (model instanceof CollectionListModel) {
            return ListUtil.getWrapperModel((CollectionListModel)model);
        }
        return (DefaultListModel)model;
    }

    private static DefaultListModel getWrapperModel(final CollectionListModel source) {
        DefaultListModel model = new DefaultListModel(){

            public Object set(int index2, Object element) {
                Object o = source.getElementAt(index2);
                source.setElementAt(element, index2);
                return o;
            }

            public Object get(int index2) {
                return source.getElementAt(index2);
            }
        };
        return model;
    }

    public static boolean isPointOnSelection(@NotNull JList list, int x, int y) {
        int row;
        if (list == null) {
            ListUtil.$$$reportNull$$$0(0);
        }
        if ((row = list.locationToIndex(new Point(x, y))) < 0) {
            return false;
        }
        return list.isSelectedIndex(row);
    }

    @Nullable
    public static <E> Component getDeepestRendererChildComponentAt(@NotNull JList<E> list, @NotNull Point point) {
        int idx;
        if (list == null) {
            ListUtil.$$$reportNull$$$0(1);
        }
        if (point == null) {
            ListUtil.$$$reportNull$$$0(2);
        }
        if ((idx = list.locationToIndex(point)) < 0) {
            return null;
        }
        Rectangle cellBounds = list.getCellBounds(idx, idx);
        if (!cellBounds.contains(point)) {
            return null;
        }
        E value = list.getModel().getElementAt(idx);
        if (value == null) {
            return null;
        }
        Component rendererComponent = list.getCellRenderer().getListCellRendererComponent(list, value, idx, true, true);
        rendererComponent.setBounds(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
        UIUtil.layoutRecursively((Component)rendererComponent);
        int rendererRelativeX = point.x - cellBounds.x;
        int rendererRelativeY = point.y - cellBounds.y;
        return UIUtil.getDeepestComponentAt((Component)rendererComponent, (int)rendererRelativeX, (int)rendererRelativeY);
    }

    public static boolean canMoveSelectedItemsDown(JList list) {
        ListModel model = list.getModel();
        int[] indices = list.getSelectedIndices();
        return indices.length > 0 && indices[indices.length - 1] < model.getSize() - 1;
    }

    public static Updatable addMoveUpListener(JButton button, final JList list) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.moveSelectedItemsUp(list);
                list.requestFocusInWindow();
            }
        });
        return ListUtil.disableWhenNoSelection(button, list);
    }

    public static Updatable addMoveDownListener(JButton button, final JList list) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.moveSelectedItemsDown(list);
                list.requestFocusInWindow();
            }
        });
        return ListUtil.disableWhenNoSelection(button, list);
    }

    public static Updatable addRemoveListener(JButton button, JList list) {
        return ListUtil.addRemoveListener(button, list, null);
    }

    public static Updatable addRemoveListener(JButton button, final JList list, final RemoveNotification<String> notification) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List items = ListUtil.removeSelectedItems(list);
                if (notification != null) {
                    notification.itemsRemoved(items);
                }
                list.requestFocusInWindow();
            }
        });
        class MyListSelectionListener
        extends Updatable
        implements ListSelectionListener {
            final /* synthetic */ JList val$list;

            MyListSelectionListener(JButton jButton) {
                this.val$list = jButton;
                super(button);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.setButtonEnabled(ListUtil.canRemoveSelectedItems(this.val$list));
            }

            @Override
            protected void update() {
                this.valueChanged(null);
            }
        }
        MyListSelectionListener listener = new MyListSelectionListener(button, list);
        list.getSelectionModel().addListSelectionListener(listener);
        listener.update();
        return listener;
    }

    private static Object get(ListModel model, int index2) {
        return ListUtil.getExtensions(model).get(model, index2);
    }

    private static void remove(ListModel model, int index2) {
        ListUtil.getExtensions(model).remove(model, index2);
    }

    public static Updatable disableWhenNoSelection(JButton button, JList list) {
        class MyListSelectionListener
        extends Updatable
        implements ListSelectionListener {
            final /* synthetic */ JList val$list;

            MyListSelectionListener(JButton jButton) {
                this.val$list = jButton;
                super(button);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.setButtonEnabled(this.val$list.getSelectedIndex() != -1);
            }

            @Override
            public void update() {
                this.valueChanged(null);
            }
        }
        MyListSelectionListener listener = new MyListSelectionListener(button, list);
        list.getSelectionModel().addListSelectionListener(listener);
        listener.update();
        return listener;
    }

    private static ListModelExtension getExtensions(ListModel model) {
        if (model instanceof DefaultListModel) {
            return DEFAULT_MODEL;
        }
        if (model instanceof SortedListModel) {
            return SORTED_MODEL;
        }
        if (model instanceof FilteringListModel) {
            return FILTERED_MODEL;
        }
        if (model instanceof CollectionListModel) {
            return COLLECTION_MODEL;
        }
        if (model == null) {
            LOG.assertTrue(false);
        } else {
            LOG.error("Unknown model class: " + model.getClass().getName());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/ListUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPointOnSelection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeepestRendererChildComponentAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface ListModelExtension<ModelType extends ListModel> {
        public Object get(ModelType var1, int var2);

        public void remove(ModelType var1, int var2);
    }

    public static interface RemoveNotification<ItemType> {
        public void itemsRemoved(List<ItemType> var1);
    }

    public static abstract class Updatable {
        private final JButton myButton;
        private boolean myEnabled = true;

        public Updatable(JButton button) {
            this.myButton = button;
        }

        public void enable(boolean enable) {
            this.myEnabled = enable;
            this.update();
        }

        protected void setButtonEnabled(boolean enabled) {
            this.myButton.setEnabled(enabled && this.myEnabled);
        }

        protected abstract void update();
    }
}

