/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.slicer;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.slicer.SliceTooComplexDFAUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpThrowInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.slicer.PhpSliceForwardUtil;
import com.jetbrains.php.slicer.PhpSliceUsage;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PhpSliceUtil {
    PhpSliceUtil() {
    }

    static boolean processUsagesFlownDownTo(@NotNull PsiElement expression, final @NotNull Processor<SliceUsage> processor, final @NotNull SliceUsage parent) {
        AssignmentExpression assignment;
        PhpPsiElement rExpression;
        Boolean value;
        if (expression == null) {
            PhpSliceUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(2);
        }
        if ((value = PhpSliceUtil.tryHandleCast(expression, processor, parent)) != null) {
            return value;
        }
        PsiElement par = expression.getParent();
        if (expression instanceof Variable) {
            PsiElement resolvedVariable;
            Variable variable = (Variable)expression;
            if (!(par instanceof Global)) {
                ReferencesSearch.search((PsiElement)variable, (SearchScope)parent.getScope().toSearchScope()).forEach(reference -> {
                    PsiElement element;
                    if (processor == null) {
                        PhpSliceUtil.$$$reportNull$$$0(46);
                    }
                    if (parent == null) {
                        PhpSliceUtil.$$$reportNull$$$0(47);
                    }
                    return !((element = reference.getElement()) instanceof Variable) || PhpSliceUtil.tryGlobalDeclaration((Variable)element, element.getParent(), processor, parent) == null;
                });
            }
            if ((value = PhpSliceUtil.tryHandleAssignmentVariable((PhpPsiElement)variable, par, processor, parent)) != null) {
                return value;
            }
            value = PhpSliceUtil.tryHandleVariableFromCatch(par, processor, parent);
            if (value != null) {
                return value;
            }
            value = PhpSliceUtil.tryGlobalDeclaration(variable, par, processor, parent);
            if (value != null) {
                return value;
            }
            PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
            if (scopeHolder == null) {
                SliceUsage stopUsage = PhpSliceUtil.createTooComplexDFAUsage(expression, parent);
                return processor.process((Object)stopUsage);
            }
            PhpAccessVariableInstruction accessVariableInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
            if (accessVariableInstruction == null) {
                return true;
            }
            final CharSequence variableName = accessVariableInstruction.getVariableName();
            PhpControlFlowUtil.processPredecessors((PhpInstruction)accessVariableInstruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    PsiElement expParent;
                    if (!PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                        return true;
                    }
                    PhpPsiElement exp = instruction.getAnchor();
                    Boolean value = PhpSliceUtil.tryHandleAssignmentVariable(exp, expParent = exp.getParent(), (Processor<SliceUsage>)processor, parent);
                    if (value != null) {
                        return false;
                    }
                    value = PhpSliceUtil.tryHandleUnaryExpression(exp, expParent, (Processor<SliceUsage>)processor, parent);
                    if (value != null) {
                        return false;
                    }
                    if (expParent instanceof Catch) {
                        return PhpSliceUtil.handToProcessor((PsiElement)exp, (Processor<SliceUsage>)processor, parent);
                    }
                    return true;
                }
            });
            if (scopeHolder instanceof Function && ((Function)scopeHolder).isClosure()) {
                Collection<Variable> usedVariables = PhpPsiUtil.getUsedVariables((Function)scopeHolder);
                for (Variable usedVariable : usedVariables) {
                    if (usedVariable == null || !PhpLangUtil.equalsVariableNames(variable.getName(), usedVariable.getName()) || PhpSliceUtil.handToProcessor((PsiElement)usedVariable, processor, parent)) continue;
                    return false;
                }
            }
            if ((resolvedVariable = variable.resolve()) instanceof Field) {
                return PhpSliceUtil.processFieldUsages((Field)variable, parent, processor);
            }
            if (resolvedVariable instanceof Parameter) {
                return PhpSliceUtil.processParameterUsages((Parameter)resolvedVariable, parent, processor);
            }
        }
        if (expression instanceof FunctionReference) {
            return PhpSliceUtil.processMethodReturnValue((FunctionReference)expression, processor, parent);
        }
        if (expression instanceof Field) {
            return PhpSliceUtil.processFieldUsages((Field)expression, parent, processor);
        }
        if (expression instanceof Parameter) {
            return PhpSliceUtil.processParameterUsages((Parameter)expression, parent, processor);
        }
        if (expression instanceof AssignmentExpression && (rExpression = (assignment = (AssignmentExpression)expression).getVariable()) != null) {
            return PhpSliceUtil.processUsagesFlownDownTo((PsiElement)rExpression, processor, parent);
        }
        if (expression instanceof TernaryExpression) {
            TernaryExpression conditional = (TernaryExpression)expression;
            PhpPsiElement thenE = conditional.getTrueVariant();
            PhpPsiElement elseE = conditional.getFalseVariant();
            if (thenE != null && !PhpSliceUtil.handToProcessor((PsiElement)thenE, processor, parent)) {
                return false;
            }
            if (elseE != null && !PhpSliceUtil.handToProcessor((PsiElement)elseE, processor, parent)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static Boolean tryHandleCast(@NotNull PsiElement expression, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent) {
        if (expression == null) {
            PhpSliceUtil.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(5);
        }
        Boolean result = null;
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            PhpPsiElement value = unaryExpression.getValue();
            if (value instanceof PhpTypedElement && PhpPsiUtil.isOfType(unaryExpression.getOperation(), PhpTokenTypes.opSTRING_CAST)) {
                PhpType phpType = ((PhpTypedElement)value).getType();
                PhpIndex index = PhpIndex.getInstance((Project)value.getProject());
                for (String type : phpType.getTypes()) {
                    Method toStringMethod;
                    String className = PhpLangUtil.toShortName(type);
                    PhpClass clazz = index.getClassByName(className);
                    if (clazz == null || (toStringMethod = clazz.findMethodByName((CharSequence)"__toString")) == null) continue;
                    result = PhpSliceUtil.processMethodReturnValue((Function)toStringMethod, processor, parent);
                }
            } else if (value != null && PhpPsiUtil.isOfType(expression, PhpElementTypes.CAST_EXPRESSION)) {
                result = PhpSliceUtil.handToProcessor((PsiElement)value, processor, parent);
            }
        }
        return result;
    }

    private static Boolean tryGlobalDeclaration(@NotNull Variable variable, PsiElement par, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent) {
        PsiElement resolve;
        if (variable == null) {
            PhpSliceUtil.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(8);
        }
        if (par instanceof Global && (resolve = variable.resolve()) instanceof Variable) {
            return PhpSliceUtil.processEntityReferences((PhpPsiElement)((Variable)resolve), parent, processor);
        }
        return null;
    }

    @Nullable
    private static Boolean tryHandleVariableFromCatch(PsiElement par, final @NotNull Processor<SliceUsage> processor, final @NotNull SliceUsage parent) {
        PsiElement parParent;
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(10);
        }
        if (par instanceof Catch && (parParent = par.getParent()) instanceof Try) {
            PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder(parParent);
            if (scopeHolder == null) {
                return null;
            }
            PhpControlFlow controlFlow = scopeHolder.getControlFlow();
            SliceUsage grandParentUsage = parent.getParent();
            if (grandParentUsage == null) {
                return null;
            }
            PhpStatementInstruction tryInstruction = PhpControlFlowUtil.getStatementInstruction(controlFlow, (Statement)((Try)parParent));
            if (tryInstruction == null) {
                return null;
            }
            final Ref proceed = new Ref((Object)true);
            PhpInstructionProcessor instructionProcessor = new PhpInstructionProcessor(){

                public boolean processThrowInstruction(PhpThrowInstruction instruction) {
                    PsiElement argument = instruction.getArgument();
                    if (argument != null && !PhpSliceUtil.handToProcessor(argument, (Processor<SliceUsage>)processor, parent)) {
                        proceed.set((Object)false);
                        return false;
                    }
                    return super.processThrowInstruction(instruction);
                }

                public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
                    return false;
                }
            };
            PhpControlFlowUtil.processSuccessors((PhpInstruction)tryInstruction, false, instructionProcessor);
            return (Boolean)proceed.get();
        }
        return null;
    }

    @Nullable
    private static Boolean tryHandleAssignmentVariable(PhpPsiElement element, PsiElement psiParent, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent) {
        PhpPsiElement value;
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(12);
        }
        if (psiParent instanceof AssignmentExpression && element.equals(((AssignmentExpression)psiParent).getVariable()) && (value = ((AssignmentExpression)psiParent).getValue()) != null) {
            return PhpSliceUtil.handToProcessor((PsiElement)value, processor, parent);
        }
        return null;
    }

    private static boolean handToProcessor(@NotNull PsiElement expression, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent) {
        PsiElement realExpression;
        if (expression == null) {
            PhpSliceUtil.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(14);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(15);
        }
        PsiElement psiElement = realExpression = expression.getParent() instanceof DummyHolder ? expression.getParent().getContext() : expression;
        assert (realExpression != null);
        SliceUsage usage = PhpSliceUtil.createSliceUsage(realExpression, parent);
        return processor.process((Object)usage);
    }

    private static boolean processMethodReturnValue(@NotNull FunctionReference methodCallExpr, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent) {
        PsiElement r;
        if (methodCallExpr == null) {
            PhpSliceUtil.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(18);
        }
        if (!((r = methodCallExpr.resolve()) instanceof Function)) {
            return true;
        }
        return PhpSliceUtil.processMethodReturnValue((Function)r, processor, parent);
    }

    private static boolean processMethodReturnValue(@NotNull Function functionCalled, final @NotNull Processor<SliceUsage> processor, final @NotNull SliceUsage parent) {
        if (functionCalled == null) {
            PhpSliceUtil.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(20);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(21);
        }
        class MyPhpInstructionProcessor
        extends PhpInstructionProcessor {
            public volatile boolean stopped = false;

            MyPhpInstructionProcessor() {
            }

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                PsiElement argument = instruction.getArgument();
                if (argument != null && !PhpSliceUtil.handToProcessor(argument, (Processor<SliceUsage>)processor, parent)) {
                    this.stopped = true;
                    return false;
                }
                return true;
            }
        }
        MyPhpInstructionProcessor instructionProcessor = new MyPhpInstructionProcessor();
        PhpControlFlowUtil.processPredecessors((PhpInstruction)functionCalled.getControlFlow().getExitPoint(), true, instructionProcessor);
        if (instructionProcessor.stopped) {
            return false;
        }
        if (functionCalled instanceof Method) {
            Method methodCalled = (Method)functionCalled;
            PhpClassHierarchyUtils.HierarchyClassMemberProcessor memberProcessor = (classMember, subClass, baseClass) -> {
                if (parent == null) {
                    PhpSliceUtil.$$$reportNull$$$0(45);
                }
                if (!parent.getScope().contains((PsiElement)classMember)) {
                    return true;
                }
                if (!(classMember instanceof Method)) {
                    return true;
                }
                PhpControlFlowUtil.processPredecessors((PhpInstruction)((Method)classMember).getControlFlow().getExitPoint(), true, instructionProcessor);
                return !instructionProcessor.stopped;
            };
            return PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)methodCalled, (PhpIndex)PhpIndex.getInstance((Project)functionCalled.getProject()), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)memberProcessor);
        }
        return !instructionProcessor.stopped;
    }

    private static boolean processFieldUsages(@NotNull Field field, @NotNull SliceUsage parent, @NotNull Processor<SliceUsage> processor) {
        ASTNode nameNode;
        PsiElement defaultValue;
        if (field == null) {
            PhpSliceUtil.$$$reportNull$$$0(22);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(23);
        }
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(24);
        }
        if ((defaultValue = field.getDefaultValue()) != null && (nameNode = field.getNameNode()) != null && !nameNode.equals(defaultValue.getNode()) && !PhpSliceUtil.handToProcessor(defaultValue, processor, parent)) {
            return false;
        }
        return PhpSliceUtil.processEntityReferences((PhpPsiElement)field, parent, processor);
    }

    private static boolean processEntityReferences(@NotNull PhpPsiElement variable, @NotNull SliceUsage parent, @NotNull Processor<SliceUsage> processor) {
        if (variable == null) {
            PhpSliceUtil.$$$reportNull$$$0(25);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(27);
        }
        SearchScope searchScope = parent.getScope().toSearchScope();
        return ReferencesSearch.search((PsiElement)variable, (SearchScope)searchScope).forEach(reference -> {
            if (processor == null) {
                PhpSliceUtil.$$$reportNull$$$0(43);
            }
            if (parent == null) {
                PhpSliceUtil.$$$reportNull$$$0(44);
            }
            ProgressManager.checkCanceled();
            PsiElement element = reference.getElement();
            if (!(element instanceof PhpReference)) {
                return true;
            }
            PhpReference referenceExpression = (PhpReference)element;
            PsiElement parentExpr = referenceExpression.getParent();
            Boolean value = PhpSliceUtil.tryHandleAssignmentVariable((PhpPsiElement)referenceExpression, parentExpr, processor, parent);
            if (value != null) {
                return value;
            }
            value = PhpSliceUtil.tryHandleUnaryExpression((PhpPsiElement)referenceExpression, parentExpr, processor, parent);
            if (value != null) {
                return value;
            }
            return true;
        });
    }

    @Nullable
    protected static Boolean tryHandleUnaryExpression(PhpPsiElement referenceExpression, PsiElement parentExpr, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent) {
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(28);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(29);
        }
        if (parentExpr instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)parentExpr).getOperation(), PhpTokenTypes.opDECREMENT, PhpTokenTypes.opINCREMENT) && referenceExpression.equals(((UnaryExpression)parentExpr).getValue())) {
            return PhpSliceUtil.handToProcessor(parentExpr, processor, parent);
        }
        return null;
    }

    @NotNull
    static SliceUsage createSliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent) {
        if (element == null) {
            PhpSliceUtil.$$$reportNull$$$0(30);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(31);
        }
        PhpSliceUsage phpSliceUsage = new PhpSliceUsage(element, parent);
        if (phpSliceUsage == null) {
            PhpSliceUtil.$$$reportNull$$$0(32);
        }
        return phpSliceUsage;
    }

    @NotNull
    private static SliceUsage createTooComplexDFAUsage(@NotNull PsiElement element, @NotNull SliceUsage parent) {
        if (element == null) {
            PhpSliceUtil.$$$reportNull$$$0(33);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(34);
        }
        SliceTooComplexDFAUsage sliceTooComplexDFAUsage = new SliceTooComplexDFAUsage(element, parent);
        if (sliceTooComplexDFAUsage == null) {
            PhpSliceUtil.$$$reportNull$$$0(35);
        }
        return sliceTooComplexDFAUsage;
    }

    private static boolean processParameterUsages(@NotNull Parameter parameter, @NotNull SliceUsage parent, @NotNull Processor<SliceUsage> processor) {
        Function function;
        PsiElement defaultValue;
        if (parameter == null) {
            PhpSliceUtil.$$$reportNull$$$0(36);
        }
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(37);
        }
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(38);
        }
        if ((defaultValue = parameter.getDefaultValue()) != null) {
            PhpSliceUtil.handToProcessor(defaultValue, processor, parent);
        }
        if ((function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)parameter, (Condition<? super PsiElement>)Function.INSTANCEOF)) == null) {
            return true;
        }
        THashSet superMethods = new THashSet();
        superMethods.add(function);
        if (function instanceof Method) {
            superMethods.addAll(PhpSliceForwardUtil.findDeepestSuperMethods((Method)function, parent.getScope()));
        }
        boolean isVariadic = parameter.isVariadic();
        int index = ArrayUtil.indexOf((Object[])function.getParameters(), (Object)parameter);
        assert (index != -1);
        THashSet processed = new THashSet();
        Processor methodReferenceProcessor = arg_0 -> PhpSliceUtil.lambda$processParameterUsages$3((Set)processed, parent, processor, isVariadic, index, arg_0);
        for (Function superMethod : superMethods) {
            if (PhpSliceUtil.isAnonymousClassConstructor(superMethod)) {
                PhpClass containingClass = ((Method)superMethod).getContainingClass();
                assert (containingClass != null);
                ParameterList parameterList = (ParameterList)PhpPsiUtil.getChildOfType((PsiElement)containingClass, PhpElementTypes.PARAMETER_LIST);
                if (parameterList == null || PhpSliceUtil.handParametersToProcessor(parent, processor, isVariadic, index, parameterList.getParameters())) continue;
                return false;
            }
            if (ReferencesSearch.search((PsiElement)superMethod, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(methodReferenceProcessor)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAnonymousClassConstructor(Function function) {
        Method method;
        PhpClass containingClass;
        return function instanceof Method && (containingClass = (method = (Method)function).getContainingClass()) != null && containingClass.isAnonymous() && method.getMethodType(false) == Method.MethodType.CONSTRUCTOR;
    }

    private static boolean handParametersToProcessor(@NotNull SliceUsage parent, @NotNull Processor<SliceUsage> processor, boolean isVariadic, int index, PsiElement[] parameters) {
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(39);
        }
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(40);
        }
        if (parameters == null) {
            return true;
        }
        if (index >= parameters.length) {
            return true;
        }
        if (isVariadic) {
            for (int i = index; i < parameters.length; ++i) {
                PsiElement passExpression = parameters[i];
                if (PhpSliceUtil.handToProcessor(passExpression, processor, parent)) continue;
                return false;
            }
            return true;
        }
        PsiElement passExpression = parameters[index];
        return PhpSliceUtil.handToProcessor(passExpression, processor, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ boolean lambda$processParameterUsages$3(Set processed, @NotNull SliceUsage parent, @NotNull Processor processor, boolean isVariadic, int index, PsiReference reference) {
        PsiElement refParent;
        if (parent == null) {
            PhpSliceUtil.$$$reportNull$$$0(41);
        }
        if (processor == null) {
            PhpSliceUtil.$$$reportNull$$$0(42);
        }
        ProgressManager.checkCanceled();
        Set set = processed;
        synchronized (set) {
            if (!processed.add(reference)) {
                return true;
            }
        }
        PsiElement refElement = reference.getElement();
        PsiElement[] parameters = null;
        if (refElement instanceof FunctionReference) {
            parameters = ((FunctionReference)refElement).getParameters();
        } else if (refElement instanceof ClassReference && (refParent = refElement.getParent()) instanceof NewExpression) {
            parameters = ((NewExpression)refParent).getParameters();
        }
        return PhpSliceUtil.handParametersToProcessor(parent, (Processor<SliceUsage>)processor, isVariadic, index, parameters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 32: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 31: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpr";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCalled";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/slicer/PhpSliceUtil";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/slicer/PhpSliceUtil";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createSliceUsage";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooComplexDFAUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesFlownDownTo";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryHandleCast";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryGlobalDeclaration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryHandleVariableFromCatch";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryHandleAssignmentVariable";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handToProcessor";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processMethodReturnValue";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processFieldUsages";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processEntityReferences";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryHandleUnaryExpression";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createSliceUsage";
                break;
            }
            case 32: 
            case 35: {
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createTooComplexDFAUsage";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processParameterUsages";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "handParametersToProcessor";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processParameterUsages$3";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processEntityReferences$2";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMethodReturnValue$1";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUsagesFlownDownTo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

