/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugUtil;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NotNull;

public class PhpServerDebugExtensionUsagesCollector
extends ProjectUsagesCollector {
    private static final String GROUP_ID = "statistics.php.server.debugger";

    @NotNull
    public String getGroupId() {
        if (GROUP_ID == null) {
            PhpServerDebugExtensionUsagesCollector.$$$reportNull$$$0(0);
        }
        return GROUP_ID;
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        List<PhpServer> servers;
        PhpProjectConfigurationFacade projectConfigurationFacade;
        if (project == null) {
            PhpServerDebugExtensionUsagesCollector.$$$reportNull$$$0(1);
        }
        if (!project.isDefault() && (projectConfigurationFacade = PhpProjectConfigurationFacade.getInstance(project)) != null && !(servers = projectConfigurationFacade.getServers()).isEmpty()) {
            Map extensions = servers.stream().map(server -> PhpDebugUtil.getDebugExtensionByDebuggerId(server.getDebuggerId())).collect(Collectors.groupingBy(type -> type, MoreCollectors.countingInt()));
            THashSet usages = new THashSet();
            for (Map.Entry extension : extensions.entrySet()) {
                usages.add(new UsageDescriptor(extension.getKey().getId(), ((Integer)extension.getValue()).intValue()));
            }
            THashSet tHashSet = usages;
            if (tHashSet == null) {
                PhpServerDebugExtensionUsagesCollector.$$$reportNull$$$0(2);
            }
            return tHashSet;
        }
        Set<UsageDescriptor> set = Collections.emptySet();
        if (set == null) {
            PhpServerDebugExtensionUsagesCollector.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/statistics/PhpServerDebugExtensionUsagesCollector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/statistics/PhpServerDebugExtensionUsagesCollector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

