/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core;

import java.awt.Component;
import java.awt.Font;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IEditorEventListener;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.main.IMainWindow;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public final class CoreEvents {
    private static final List<IProjectEventListener> PROJECT_EVENT_LISTENERS = new CopyOnWriteArrayList<IProjectEventListener>();
    private static final List<IApplicationEventListener> APPLICATION_EVENT_LISTENERS = new CopyOnWriteArrayList<IApplicationEventListener>();
    private static final List<IEntryEventListener> ENTRY_EVENT_LISTENERS = new CopyOnWriteArrayList<IEntryEventListener>();
    private static final List<IFontChangedEventListener> FONT_CHANGED_EVENT_LISTENERS = new CopyOnWriteArrayList<IFontChangedEventListener>();
    private static final List<IEditorEventListener> EDITOR_EVENT_LISTENERS = new CopyOnWriteArrayList<IEditorEventListener>();

    private CoreEvents() {
    }

    public static void registerProjectChangeListener(IProjectEventListener listener) {
        PROJECT_EVENT_LISTENERS.add(listener);
    }

    public static void unregisterProjectChangeListener(IProjectEventListener listener) {
        PROJECT_EVENT_LISTENERS.remove(listener);
    }

    public static void registerApplicationEventListener(IApplicationEventListener listener) {
        APPLICATION_EVENT_LISTENERS.add(listener);
    }

    public static void unregisterApplicationEventListener(IApplicationEventListener listener) {
        APPLICATION_EVENT_LISTENERS.remove(listener);
    }

    public static void registerEntryEventListener(IEntryEventListener listener) {
        ENTRY_EVENT_LISTENERS.add(listener);
    }

    public static void unregisterEntryEventListener(IEntryEventListener listener) {
        ENTRY_EVENT_LISTENERS.remove(listener);
    }

    public static void registerFontChangedEventListener(IFontChangedEventListener listener) {
        FONT_CHANGED_EVENT_LISTENERS.add(listener);
    }

    public static void unregisterFontChangedEventListener(IFontChangedEventListener listener) {
        FONT_CHANGED_EVENT_LISTENERS.remove(listener);
    }

    public static void registerEditorEventListener(IEditorEventListener listener) {
        EDITOR_EVENT_LISTENERS.add(listener);
    }

    public static void unregisterEditorEventListener(IEditorEventListener listener) {
        EDITOR_EVENT_LISTENERS.remove(listener);
    }

    public static void fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        SwingUtilities.invokeLater(() -> {
            Log.logInfoRB("LOG_INFO_EVENT_PROJECT_CHANGE", new Object[]{eventType});
            for (IProjectEventListener listener : PROJECT_EVENT_LISTENERS) {
                try {
                    listener.onProjectChanged(eventType);
                }
                catch (Throwable t) {
                    CoreEvents.log("ERROR_EVENT_PROJECT_CHANGE", t);
                }
            }
        });
    }

    public static void fireApplicationStartup() {
        SwingUtilities.invokeLater(() -> {
            Log.logInfoRB("LOG_INFO_EVENT_APPLICATION_STARTUP", new Object[0]);
            for (IApplicationEventListener listener : APPLICATION_EVENT_LISTENERS) {
                try {
                    listener.onApplicationStartup();
                }
                catch (Throwable t) {
                    CoreEvents.log("ERROR_EVENT_APPLICATION_STARTUP", t);
                }
            }
        });
    }

    public static void fireApplicationShutdown() {
        Log.logInfoRB("LOG_INFO_EVENT_APPLICATION_SHUTDOWN", new Object[0]);
        for (IApplicationEventListener listener : APPLICATION_EVENT_LISTENERS) {
            try {
                listener.onApplicationShutdown();
            }
            catch (Throwable t) {
                CoreEvents.log("ERROR_EVENT_APPLICATION_SHUTDOWN", t);
            }
        }
    }

    public static void fireEntryNewFile(String activeFileName) {
        SwingUtilities.invokeLater(() -> {
            Log.logInfoRB("LOG_INFO_EVENT_ENTRY_NEWFILE", activeFileName);
            for (IEntryEventListener listener : ENTRY_EVENT_LISTENERS) {
                try {
                    listener.onNewFile(activeFileName);
                }
                catch (Throwable t) {
                    CoreEvents.log("ERROR_EVENT_ENTRY_NEWFILE", t);
                }
            }
        });
    }

    public static void fireEntryActivated(SourceTextEntry newEntry) {
        SwingUtilities.invokeLater(() -> {
            Log.logInfoRB("LOG_INFO_EVENT_ENTRY_ACTIVATED", new Object[0]);
            for (IEntryEventListener listener : ENTRY_EVENT_LISTENERS) {
                try {
                    listener.onEntryActivated(newEntry);
                }
                catch (Throwable t) {
                    CoreEvents.log("ERROR_EVENT_ENTRY_ACTIVATED", t);
                }
            }
        });
    }

    public static void fireFontChanged(Font newFont) {
        SwingUtilities.invokeLater(() -> {
            Log.logInfoRB("LOG_INFO_EVENT_FONT_CHANGED", new Object[0]);
            for (IFontChangedEventListener listener : FONT_CHANGED_EVENT_LISTENERS) {
                try {
                    listener.onFontChanged(newFont);
                }
                catch (Throwable t) {
                    CoreEvents.log("ERROR_EVENT_FONT_CHANGED", t);
                }
            }
        });
    }

    public static void fireEditorNewWord(String newWord) {
        SwingUtilities.invokeLater(() -> {
            for (IEditorEventListener listener : EDITOR_EVENT_LISTENERS) {
                try {
                    listener.onNewWord(newWord);
                }
                catch (Throwable t) {
                    CoreEvents.log("ERROR_EVENT_EDITOR_NEW_WORD", t);
                }
            }
        });
    }

    private static void log(String msgKey, Throwable t) {
        Log.log(t);
        Component parent = Optional.ofNullable(Core.getMainWindow()).map(IMainWindow::getApplicationFrame).orElse(null);
        JOptionPane.showMessageDialog(parent, OStrings.getString(msgKey, t), OStrings.getString("ERROR_TITLE"), 0);
    }
}

