/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fa;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceRule.load((String)"/fa/replace.txt");

    public SimpleReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(Categories.CONFUSED_WORDS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"\u0648\u06cc <marker>\u062d\u0627\u0638\u0631</marker> \u0628\u0647 \u0647\u0645\u06a9\u0627\u0631\u06cc \u0634\u062f."), Example.fixed((String)"\u0648\u06cc <marker>\u062d\u0627\u0636\u0631</marker> \u0628\u0647 \u0647\u0645\u06a9\u0627\u0631\u06cc \u0634\u062f."));
    }

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public final String getId() {
        return "FA_SIMPLE_REPLACE";
    }

    public String getDescription() {
        return "\u0627\u0634\u062a\u0628\u0627\u0647 \u0645\u062d\u062a\u0645\u0644 \u0627\u0645\u0644\u0627\u0626\u06cc";
    }

    public String getShort() {
        return "\u0627\u0634\u062a\u0628\u0627\u0647 \u0645\u062d\u062a\u0645\u0644 \u0627\u0645\u0644\u0627\u0626\u06cc";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "\u0627\u0634\u062a\u0628\u0627\u0647 \u0645\u062d\u062a\u0645\u0644 \u0627\u0645\u0644\u0627\u0626\u06cc \u067e\u06cc\u062f\u0627\u0634\u062f\u0647: " + StringUtils.join(replacements, (String)"\u060c ") + ".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }
}

