/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.BufferExpiringCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.DeletedCell;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.NativeCell;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.NativeAllocator;

public class NativeExpiringCell
extends NativeCell
implements ExpiringCell {
    private static final long SIZE = ObjectSizes.measure(new NativeExpiringCell());

    private NativeExpiringCell() {
    }

    public NativeExpiringCell(NativeAllocator allocator, OpOrder.Group writeOp, ExpiringCell copyOf) {
        super(allocator, writeOp, copyOf);
    }

    @Override
    protected int sizeOf(Cell cell) {
        return super.sizeOf(cell) + 8;
    }

    @Override
    protected void construct(Cell from) {
        ExpiringCell expiring = (ExpiringCell)from;
        this.setInt(this.internalSize() - 4L, expiring.getTimeToLive());
        this.setInt(this.internalSize() - 8L, expiring.getLocalDeletionTime());
        super.construct(from);
    }

    @Override
    protected int postfixSize() {
        return 8;
    }

    @Override
    public int getTimeToLive() {
        return this.getInt(this.internalSize() - 4L);
    }

    @Override
    public int getLocalDeletionTime() {
        return this.getInt(this.internalSize() - 8L);
    }

    @Override
    public boolean isLive() {
        return this.isLive(System.currentTimeMillis());
    }

    @Override
    public boolean isLive(long now) {
        return (int)(now / 1000L) < this.getLocalDeletionTime();
    }

    @Override
    public int serializationFlags() {
        return 2;
    }

    @Override
    public int cellDataSize() {
        return super.cellDataSize() + TypeSizes.NATIVE.sizeof(this.getLocalDeletionTime()) + TypeSizes.NATIVE.sizeof(this.getTimeToLive());
    }

    @Override
    public int serializedSize(CellNameType type, TypeSizes typeSizes) {
        return super.serializedSize(type, typeSizes) + typeSizes.sizeof(this.getLocalDeletionTime()) + typeSizes.sizeof(this.getTimeToLive());
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        super.validateFields(metadata);
        if (this.getTimeToLive() <= 0) {
            throw new MarshalException("A column TTL should be > 0");
        }
        if (this.getLocalDeletionTime() < 0) {
            throw new MarshalException("The local expiration time should not be negative");
        }
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        super.updateDigest(digest);
        FBUtilities.updateWithInt(digest, this.getTimeToLive());
    }

    @Override
    public Cell reconcile(Cell cell) {
        int let2;
        int let1;
        long ts2;
        long ts1 = this.timestamp();
        if (ts1 != (ts2 = cell.timestamp())) {
            return ts1 < ts2 ? cell : this;
        }
        if (cell instanceof DeletedCell) {
            return cell;
        }
        int c = this.value().compareTo(cell.value());
        if (c != 0) {
            return c < 0 ? cell : this;
        }
        if (cell instanceof ExpiringCell && (let1 = this.getLocalDeletionTime()) < (let2 = cell.getLocalDeletionTime())) {
            return cell;
        }
        return this;
    }

    @Override
    public boolean equals(Cell cell) {
        if (!super.equals(cell)) {
            return false;
        }
        ExpiringCell that = (ExpiringCell)cell;
        return this.getLocalDeletionTime() == that.getLocalDeletionTime() && this.getTimeToLive() == that.getTimeToLive();
    }

    @Override
    public String getString(CellNameType comparator) {
        return String.format("%s(%s!%d)", this.getClass().getSimpleName(), super.getString(comparator), this.getTimeToLive());
    }

    @Override
    public ExpiringCell localCopy(CFMetaData metadata, AbstractAllocator allocator) {
        return new BufferExpiringCell(this.name().copy(metadata, allocator), allocator.clone(this.value()), this.timestamp(), this.getTimeToLive(), this.getLocalDeletionTime());
    }

    @Override
    public ExpiringCell localCopy(CFMetaData metadata, MemtableAllocator allocator, OpOrder.Group opGroup) {
        return allocator.clone(this, metadata, opGroup);
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return SIZE;
    }

    @Override
    public long unsharedHeapSize() {
        return SIZE;
    }
}

