/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import com.ning.compress.lzf.BufferRecycler;
import com.ning.compress.lzf.ChunkEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class LZFOutputStream
extends OutputStream {
    private static final int OUTPUT_BUFFER_SIZE = 65535;
    private final ChunkEncoder _encoder = new ChunkEncoder(65535);
    private final BufferRecycler _recycler = BufferRecycler.instance();
    protected final OutputStream _outputStream;
    protected byte[] _outputBuffer;
    protected int _position = 0;
    protected boolean _cfgFinishBlockOnFlush = true;
    protected boolean _outputStreamClosed;

    public LZFOutputStream(OutputStream outputStream) {
        this._outputStream = outputStream;
        this._outputBuffer = this._recycler.allocOutputBuffer(65535);
        this._outputStreamClosed = false;
    }

    public LZFOutputStream setFinishBlockOnFlush(boolean b) {
        this._cfgFinishBlockOnFlush = b;
        return this;
    }

    public void write(int singleByte) throws IOException {
        if (this._position >= this._outputBuffer.length) {
            this.writeCompressedBlock();
        }
        this._outputBuffer[this._position++] = (byte)singleByte;
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        int BUFFER_LEN = this._outputBuffer.length;
        int free = BUFFER_LEN - this._position;
        if (free >= length) {
            System.arraycopy(buffer, offset, this._outputBuffer, this._position, length);
            this._position += length;
            return;
        }
        System.arraycopy(buffer, offset, this._outputBuffer, this._position, free);
        offset += free;
        length -= free;
        this._position += free;
        this.writeCompressedBlock();
        while (length >= BUFFER_LEN) {
            this._encoder.encodeAndWriteChunk(buffer, offset, BUFFER_LEN, this._outputStream);
            offset += BUFFER_LEN;
            length -= BUFFER_LEN;
        }
        if (length > 0) {
            System.arraycopy(buffer, offset, this._outputBuffer, 0, length);
        }
        this._position = length;
    }

    public void flush() throws IOException {
        if (this._cfgFinishBlockOnFlush && this._position > 0) {
            this.writeCompressedBlock();
        }
        this._outputStream.flush();
    }

    public void close() throws IOException {
        if (!this._outputStreamClosed) {
            if (this._position > 0) {
                this.writeCompressedBlock();
            }
            this._outputStream.flush();
            this._encoder.close();
            byte[] buf = this._outputBuffer;
            if (buf != null) {
                this._outputBuffer = null;
                this._recycler.releaseOutputBuffer(buf);
            }
            this._outputStreamClosed = true;
            this._outputStream.close();
        }
    }

    public OutputStream getUnderlyingOutputStream() {
        return this._outputStream;
    }

    public boolean getFinishBlockOnFlush() {
        return this._cfgFinishBlockOnFlush;
    }

    public LZFOutputStream finishBlock() throws IOException {
        if (this._position > 0) {
            this.writeCompressedBlock();
        }
        return this;
    }

    protected void writeCompressedBlock() throws IOException {
        int chunkLen;
        int left = this._position;
        this._position = 0;
        int offset = 0;
        do {
            chunkLen = Math.min(65535, left);
            this._encoder.encodeAndWriteChunk(this._outputBuffer, 0, chunkLen, this._outputStream);
            offset += chunkLen;
        } while ((left -= chunkLen) > 0);
    }
}

